/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.entity.CustomerServiceProjectFollowUpLedger;
import com.ruoyi.mapper.CustomerServiceProjectFollowUpLedgerMapper;
import com.ruoyi.query.FollowUpLedgerQuery;
import com.ruoyi.service.CustomerServiceProjectFollowUpLedgerService;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.followupledger.FollowUpLedgerEditVO;
import com.ruoyi.vo.followupledger.FollowUpLedgerExportVO;
import com.ruoyi.vo.followupledger.FollowUpLedgerInfoVO;
import com.ruoyi.vo.followupledger.FollowUpLedgerSaveVO;
import com.ruoyi.vo.followupledger.FollowUpLedgerVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class CustomerServiceProjectFollowUpLedgerServiceImpl
extends ServiceImpl<CustomerServiceProjectFollowUpLedgerMapper, CustomerServiceProjectFollowUpLedger>
implements CustomerServiceProjectFollowUpLedgerService {
    private LambdaQueryWrapper<CustomerServiceProjectFollowUpLedger> getQueryWrapperByFollowUpLedgerQuery(FollowUpLedgerQuery query) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)query.getProjectName())) {
            wrapper.like(CustomerServiceProjectFollowUpLedger::getProjectName, (Object)query.getProjectName());
        }
        if (null != query.getHasReconciliation()) {
            wrapper.eq(CustomerServiceProjectFollowUpLedger::getHasReconciliation, (Object)query.getHasReconciliation());
        }
        if (null != query.getStartDate()) {
            wrapper.ge(CustomerServiceProjectFollowUpLedger::getCreateTime, (Object)query.getStartDate());
        }
        if (null != query.getEndDate()) {
            wrapper.le(CustomerServiceProjectFollowUpLedger::getCreateTime, (Object)query.getEndDate());
        }
        wrapper.orderByDesc(CustomerServiceProjectFollowUpLedger::getCreateTime);
        return wrapper;
    }

    public PageResultVo<FollowUpLedgerVO> getPageList(FollowUpLedgerQuery query) {
        LambdaQueryWrapper wrapper = this.getQueryWrapperByFollowUpLedgerQuery(query);
        Page page = new Page((long)query.getPageNum(), (long)query.getPageSize());
        this.page((IPage)page, (Wrapper)wrapper);
        ArrayList resultList = new ArrayList();
        page.getRecords().forEach(r -> {
            FollowUpLedgerVO followUpLedgerVO = new FollowUpLedgerVO();
            BeanUtil.copyProperties((Object)r, (Object)followUpLedgerVO, (String[])new String[0]);
            followUpLedgerVO.setCity(r.getProvince() + "-" + r.getCity());
            resultList.add(followUpLedgerVO);
        });
        return new PageResultVo(page, resultList);
    }

    public FollowUpLedgerInfoVO info(String id) {
        CustomerServiceProjectFollowUpLedger followUpLedger = (CustomerServiceProjectFollowUpLedger)this.getById((Serializable)Long.valueOf(Long.parseLong(id)));
        if (null == followUpLedger) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        FollowUpLedgerInfoVO info = new FollowUpLedgerInfoVO();
        BeanUtil.copyProperties((Object)followUpLedger, (Object)info, (String[])new String[0]);
        info.setCity(followUpLedger.getProvince() + "-" + followUpLedger.getCity());
        info.setCreateTime(DateUtil.formatLocalDateTime((LocalDateTime)followUpLedger.getCreateTime()));
        return info;
    }

    public void save(FollowUpLedgerSaveVO saveVO) {
        CustomerServiceProjectFollowUpLedger followUpLedger = new CustomerServiceProjectFollowUpLedger();
        BeanUtil.copyProperties((Object)saveVO, (Object)followUpLedger, (String[])new String[0]);
        followUpLedger.setHasReconciliation(Integer.valueOf(0));
        if (StrUtil.isNotBlank((CharSequence)saveVO.getCity())) {
            String[] citys = saveVO.getCity().split("-");
            followUpLedger.setProvince(citys[0]);
            followUpLedger.setCity(citys[1]);
        }
        this.save((Object)followUpLedger);
    }

    public void edit(FollowUpLedgerEditVO editVO) {
        if (StrUtil.isBlank((CharSequence)editVO.getId())) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
        }
        CustomerServiceProjectFollowUpLedger followUpLedger = (CustomerServiceProjectFollowUpLedger)this.getById((Serializable)Long.valueOf(Long.parseLong(editVO.getId())));
        if (null == followUpLedger) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        BeanUtil.copyProperties((Object)editVO, (Object)followUpLedger, (String[])new String[0]);
        followUpLedger.setUpdateId(SecurityUtils.getLoginUser().getUserid());
        followUpLedger.setUpdateName(SecurityUtils.getLoginUser().getUsername());
        followUpLedger.setUpdateTime(LocalDateTime.now());
        if (StrUtil.isNotBlank((CharSequence)editVO.getCity())) {
            String[] citys = editVO.getCity().split("-");
            followUpLedger.setProvince(citys[0]);
            followUpLedger.setCity(citys[1]);
        }
        this.updateById((Object)followUpLedger);
    }

    public List<FollowUpLedgerExportVO> exportList(FollowUpLedgerQuery query) {
        LambdaQueryWrapper wrapper = this.getQueryWrapperByFollowUpLedgerQuery(query);
        List marketLedgerList = this.list((Wrapper)wrapper);
        ArrayList<FollowUpLedgerExportVO> resultList = new ArrayList<FollowUpLedgerExportVO>();
        marketLedgerList.forEach(r -> {
            FollowUpLedgerExportVO exportVO = new FollowUpLedgerExportVO();
            BeanUtil.copyProperties((Object)r, (Object)exportVO, (String[])new String[0]);
            exportVO.setHasReconciliation(r.getHasReconciliation() == 1 ? "\u662f" : "\u5426");
            resultList.add(exportVO);
        });
        return resultList;
    }
}

