/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.constant.RepairWorkOrderProcessNode;
import com.ruoyi.constant.RepairWorkOrderStatus;
import com.ruoyi.dto.CustomerOrderDetailDto;
import com.ruoyi.entity.CustomerServiceRepairWorkOrder;
import com.ruoyi.entity.CustomerServiceRepairWorkOrderFile;
import com.ruoyi.mapper.CustomerServiceRepairWorkOrderFileMapper;
import com.ruoyi.mapper.CustomerServiceRepairWorkOrderMapper;
import com.ruoyi.query.RepairQuery;
import com.ruoyi.service.CustomerServiceRepairWorkOrderService;
import com.ruoyi.util.DictUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.SerialNumberUtil;
import com.ruoyi.util.ThemeUtils;
import com.ruoyi.vo.FileVO;
import com.ruoyi.vo.repair.EngineerRepairVO;
import com.ruoyi.vo.repair.EngineeringManagerDispatchVO;
import com.ruoyi.vo.repair.OrderTakerDispatchVO;
import com.ruoyi.vo.repair.TmpStorageVO;
import com.ruoyi.vo.repair.UrgeVO;
import com.ruoyi.vo.repair.WorkOrderEditVO;
import com.ruoyi.vo.repair.WorkOrderExportVO;
import com.ruoyi.vo.repair.WorkOrderInfoVO;
import com.ruoyi.vo.repair.WorkOrderRejectEditVO;
import com.ruoyi.vo.repair.WorkOrderSaveVO;
import com.ruoyi.vo.repair.WorkOrderVO;
import com.ruoyi.workflow.service.WorkFlowService;
import com.ruoyi.workflow.vo.ApproveTaskVO;
import com.ruoyi.workflow.vo.ApproveVO;
import com.ruoyi.workflow.vo.JumpVO;
import com.ruoyi.workflow.vo.ProcessStartVO;
import com.ruoyi.workflow.vo.PushTaskVO;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomerServiceRepairWorkOrderServiceImpl
extends ServiceImpl<CustomerServiceRepairWorkOrderMapper, CustomerServiceRepairWorkOrder>
implements CustomerServiceRepairWorkOrderService {
    @Autowired
    private WorkFlowService workFlowService;
    @Value(value="${work-flow.process-definition-key.wxgd}")
    private String PROCESS_DEFINITION_KEY;
    @Autowired
    private CustomerServiceRepairWorkOrderFileMapper customerServiceRepairWorkOrderFileMapper;

    private LambdaQueryWrapper<CustomerServiceRepairWorkOrder> getQueryWrapperByRepairQuery(RepairQuery query) {
        String[] citys;
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)query.getSerialNumber())) {
            wrapper.like(CustomerServiceRepairWorkOrder::getSerialNumber, (Object)query.getSerialNumber());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getFaultLevel())) {
            wrapper.eq(CustomerServiceRepairWorkOrder::getFaultLevel, (Object)query.getFaultLevel());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getCity()) && (citys = query.getCity().split("-")).length == 2) {
            wrapper.eq(CustomerServiceRepairWorkOrder::getProvince, (Object)citys[0]);
            wrapper.eq(CustomerServiceRepairWorkOrder::getCity, (Object)citys[1]);
        }
        if (null != query.getFaultType()) {
            wrapper.eq(CustomerServiceRepairWorkOrder::getFaultType, (Object)query.getFaultType());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getProjectName())) {
            wrapper.like(CustomerServiceRepairWorkOrder::getProjectName, (Object)query.getProjectName());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getUserRoomNo())) {
            wrapper.like(CustomerServiceRepairWorkOrder::getUserRoomNo, (Object)query.getUserRoomNo());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRepairStaffPhoneNumber())) {
            wrapper.like(CustomerServiceRepairWorkOrder::getRepairStaffPhoneNumber, (Object)query.getRepairStaffPhoneNumber());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getWorkOrderStatus())) {
            wrapper.like(CustomerServiceRepairWorkOrder::getWorkOrderStatus, (Object)query.getWorkOrderStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getReportRepairPersonPhoneNumber())) {
            wrapper.like(CustomerServiceRepairWorkOrder::getReportRepairPersonPhoneNumber, (Object)query.getReportRepairPersonPhoneNumber());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getLastestHandleTimeBegin())) {
            wrapper.ge(CustomerServiceRepairWorkOrder::getLastestHandleTime, (Object)query.getLastestHandleTimeBegin());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getLastestHandleTimeEnd())) {
            wrapper.le(CustomerServiceRepairWorkOrder::getLastestHandleTime, (Object)query.getLastestHandleTimeEnd());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRepairStaffName())) {
            wrapper.like(CustomerServiceRepairWorkOrder::getRepairStaffName, (Object)query.getRepairStaffName());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getOrderTakerName())) {
            wrapper.like(CustomerServiceRepairWorkOrder::getOrderTakerName, (Object)query.getOrderTakerName());
        }
        if (ObjectUtil.isNotEmpty((Object)query.getWorkOrderStatusList())) {
            wrapper.in(CustomerServiceRepairWorkOrder::getWorkOrderStatus, (Collection)query.getWorkOrderStatusList());
        }
        wrapper.orderByDesc(CustomerServiceRepairWorkOrder::getCreateTime);
        return wrapper;
    }

    public PageResultVo<WorkOrderVO> pageList(RepairQuery query) {
        LambdaQueryWrapper wrapper = this.getQueryWrapperByRepairQuery(query);
        Page page = new Page((long)query.getPageNum(), (long)query.getPageSize());
        this.page((IPage)page, (Wrapper)wrapper);
        List myTasks = this.workFlowService.getMyTask();
        ArrayList resultList = new ArrayList();
        page.getRecords().forEach(r -> {
            WorkOrderVO workOrderVO = new WorkOrderVO();
            BeanUtil.copyProperties((Object)r, (Object)workOrderVO, (String[])new String[0]);
            workOrderVO.setRepairFinishTime(DateUtil.format((LocalDateTime)r.getRepairFinishTime(), (String)"yyyy-MM-dd"));
            if (CollUtil.isNotEmpty((Collection)myTasks) && myTasks.contains(r.getProcessId())) {
                workOrderVO.setMyTask(Integer.valueOf(1));
            } else {
                workOrderVO.setMyTask(Integer.valueOf(0));
            }
            resultList.add(workOrderVO);
        });
        return new PageResultVo(page, resultList);
    }

    public PageResultVo<CustomerOrderDetailDto> pageOrderList(CustomerOrderDetailDto query) {
        Page objectPage = new Page((long)query.getPageNum(), (long)query.getPageSize());
        Page customerOrderDetailDtoPage = ((CustomerServiceRepairWorkOrderMapper)this.baseMapper).selectOrderDetail(query, objectPage);
        return new PageResultVo(customerOrderDetailDtoPage);
    }

    public List<CustomerOrderDetailDto> exportOrderList(CustomerOrderDetailDto query) {
        return ((CustomerServiceRepairWorkOrderMapper)this.baseMapper).selectOrderList(query);
    }

    public List<WorkOrderExportVO> exportList(RepairQuery query) {
        List list = this.list((Wrapper)this.getQueryWrapperByRepairQuery(query));
        Map finalDictMap = DictUtil.getDictMap((String)"helpdesk_repair_fault_type");
        List<WorkOrderExportVO> result = list.stream().map(l -> {
            WorkOrderExportVO exportVO = new WorkOrderExportVO();
            BeanUtil.copyProperties((Object)l, (Object)exportVO, (String[])new String[0]);
            exportVO.setFaultType((String)finalDictMap.get(String.valueOf(l.getFaultType())));
            exportVO.setWorkOrderStatus(RepairWorkOrderStatus.getNameByCode((Integer)l.getWorkOrderStatus()));
            exportVO.setRepairFinishTime(DateUtil.format((LocalDateTime)l.getRepairFinishTime(), (String)"yyyy-MM-dd"));
            exportVO.setCreateTime(DateUtil.formatLocalDateTime((LocalDateTime)l.getCreateTime()));
            return exportVO;
        }).collect(Collectors.toList());
        return result;
    }

    public WorkOrderInfoVO info(String id) {
        CustomerServiceRepairWorkOrder workOrder = this.findById(id);
        WorkOrderInfoVO infoVO = new WorkOrderInfoVO();
        BeanUtil.copyProperties((Object)workOrder, (Object)infoVO, (String[])new String[0]);
        infoVO.setCreateTime(DateUtil.formatLocalDateTime((LocalDateTime)workOrder.getCreateTime()));
        infoVO.setDispatchTime(workOrder.getDispatchTime().toString());
        infoVO.setRepairFinishTime(DateUtil.formatLocalDateTime((LocalDateTime)workOrder.getRepairFinishTime()));
        infoVO.setCity(workOrder.getProvince() + "-" + workOrder.getCity());
        List files = this.customerServiceRepairWorkOrderFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerServiceRepairWorkOrderFile::getOrderId, (Object)workOrder.getId())).eq(CustomerServiceRepairWorkOrderFile::getIsDelete, (Object)0));
        List fileVOList = files.stream().map(f -> {
            FileVO fileVO = new FileVO();
            fileVO.setName(f.getFileName());
            fileVO.setUrl(f.getFilePath());
            fileVO.setUid(f.getFileUid());
            return fileVO;
        }).collect(Collectors.toList());
        infoVO.setFiles(fileVOList);
        return infoVO;
    }

    public CustomerServiceRepairWorkOrder findById(String id) {
        CustomerServiceRepairWorkOrder workOrder = (CustomerServiceRepairWorkOrder)this.getById((Serializable)Long.valueOf(Long.parseLong(id)));
        if (null == workOrder) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        return workOrder;
    }

    private void saveFile(List<FileVO> files, Long workOrderId) {
        if (CollUtil.isNotEmpty(files)) {
            ArrayList records = new ArrayList();
            files.forEach(file -> {
                CustomerServiceRepairWorkOrderFile record = new CustomerServiceRepairWorkOrderFile();
                record.setId(Long.valueOf(IdWorker.getId((Object)record)));
                record.setOrderId(workOrderId);
                record.setFilePath(file.getUrl());
                record.setFileName(file.getName());
                record.setFileUid(file.getUid());
                record.setIsDelete(Integer.valueOf(0));
                records.add(record);
            });
            this.customerServiceRepairWorkOrderFileMapper.saveBatch(records);
        }
    }

    private void processStart(CustomerServiceRepairWorkOrder workOrder, String formUrl) {
        String processInstId = this.workFlowService.start(ProcessStartVO.builder().processDefinitionKey(this.PROCESS_DEFINITION_KEY).processInstanceName(workOrder.getSubjectName()).projectName(workOrder.getProjectName()).businessKey(workOrder.getId() + "").startUserId(workOrder.getCreateId() + "").formUrl(formUrl).build());
        if (ObjectUtil.isNotEmpty((Object)processInstId)) {
            workOrder.setProcessInstId(processInstId);
            this.updateById((Object)workOrder);
        }
    }

    private void processFlow(String processInstanceId, ApproveVO approveVO) {
        this.workFlowService.approveTask(ApproveTaskVO.builder().assignee(approveVO.getApprover()).businessStatus("PASSED").comment(approveVO.getComment()).processInstanceId(processInstanceId).build());
    }

    public void fillOutSave(WorkOrderSaveVO saveVO) {
        CustomerServiceRepairWorkOrder workOrder = new CustomerServiceRepairWorkOrder();
        BeanUtil.copyProperties((Object)saveVO, (Object)workOrder, (String[])new String[0]);
        if (StrUtil.isNotBlank((CharSequence)saveVO.getCity())) {
            String[] citys = saveVO.getCity().split("-");
            workOrder.setProvince(citys[0]);
            workOrder.setCity(citys[1]);
            workOrder.setSerialNumber(SerialNumberUtil.generate((String)"YY%s%s%s%s%s", (String)"WXGD", (String)citys[1]));
        }
        workOrder.setWorkOrderStatus(RepairWorkOrderStatus.AWAITING_SUBMIT.getCode());
        ThemeUtils themes = new ThemeUtils();
        workOrder.setSubjectName(ThemeUtils.getThemeName((String)"\u7ef4\u4fee\u5de5\u5355\u7533\u8bf7"));
        this.save((Object)workOrder);
        this.saveFile(saveVO.getFiles(), workOrder.getId());
    }

    public void fillOutSaveAndApply(WorkOrderSaveVO saveVO) {
        CustomerServiceRepairWorkOrder workOrder = new CustomerServiceRepairWorkOrder();
        BeanUtil.copyProperties((Object)saveVO, (Object)workOrder, (String[])new String[0]);
        if (StrUtil.isNotBlank((CharSequence)saveVO.getCity())) {
            String[] citys = saveVO.getCity().split("-");
            workOrder.setProvince(citys[0]);
            workOrder.setCity(citys[1]);
            workOrder.setSerialNumber(SerialNumberUtil.generate((String)"YY%s%s%s%s%s", (String)"WXGD", (String)citys[1]));
        }
        workOrder.setWorkOrderStatus(RepairWorkOrderStatus.AWAITING_REVIEW.getCode());
        ThemeUtils themes = new ThemeUtils();
        workOrder.setSubjectName(ThemeUtils.getThemeName((String)"\u7ef4\u4fee\u5de5\u5355\u7533\u8bf7"));
        this.save((Object)workOrder);
        this.saveFile(saveVO.getFiles(), workOrder.getId());
        this.processStart(workOrder, saveVO.getFormUrl());
    }

    public void fillOutEdit(WorkOrderEditVO editVO) {
        CustomerServiceRepairWorkOrder workOrder = this.findById(editVO.getId());
        BeanUtil.copyProperties((Object)editVO, (Object)workOrder, (String[])new String[0]);
        if (StrUtil.isNotBlank((CharSequence)editVO.getCity())) {
            String[] citys = editVO.getCity().split("-");
            workOrder.setProvince(citys[0]);
            workOrder.setCity(citys[1]);
            if (!citys[0].equals(workOrder.getProvince()) && !citys[1].equals(workOrder.getCity())) {
                workOrder.setSerialNumber(SerialNumberUtil.generate((String)"YY%s%s%s%s%s", (String)"WXGD", (String)citys[1]));
            }
        }
        this.updateById((Object)workOrder);
        this.customerServiceRepairWorkOrderFileMapper.deleteByOrderId(workOrder.getId());
        if (CollUtil.isNotEmpty((Collection)editVO.getFiles())) {
            this.saveFile(editVO.getFiles(), workOrder.getId());
        }
    }

    public void fillOutEditAndApply(WorkOrderEditVO editVO) {
        CustomerServiceRepairWorkOrder workOrder = this.findById(editVO.getId());
        BeanUtil.copyProperties((Object)editVO, (Object)workOrder, (String[])new String[0]);
        if (StrUtil.isNotBlank((CharSequence)editVO.getCity())) {
            String[] citys = editVO.getCity().split("-");
            workOrder.setProvince(citys[0]);
            workOrder.setCity(citys[1]);
            if (!citys[0].equals(workOrder.getProvince()) && !citys[1].equals(workOrder.getCity())) {
                workOrder.setSerialNumber(SerialNumberUtil.generate((String)"YY%s%s%s%s%s", (String)"WXGD", (String)citys[1]));
            }
        }
        workOrder.setWorkOrderStatus(RepairWorkOrderStatus.AWAITING_REVIEW.getCode());
        this.updateById((Object)workOrder);
        this.customerServiceRepairWorkOrderFileMapper.deleteByOrderId(workOrder.getId());
        if (CollUtil.isNotEmpty((Collection)editVO.getFiles())) {
            this.saveFile(editVO.getFiles(), workOrder.getId());
        }
        this.processStart(workOrder, editVO.getFormUrl());
    }

    public void fillOutRejectEdit(WorkOrderRejectEditVO rejectEditVO) {
        WorkOrderEditVO editVO = new WorkOrderEditVO();
        BeanUtil.copyProperties((Object)rejectEditVO, (Object)editVO, (String[])new String[0]);
        CustomerServiceRepairWorkOrder workOrder = this.findById(editVO.getId());
        BeanUtil.copyProperties((Object)editVO, (Object)workOrder, (String[])new String[0]);
        if (StrUtil.isNotBlank((CharSequence)editVO.getCity())) {
            String[] citys = editVO.getCity().split("-");
            workOrder.setProvince(citys[0]);
            workOrder.setCity(citys[1]);
            if (!citys[0].equals(workOrder.getProvince()) && !citys[1].equals(workOrder.getCity())) {
                workOrder.setSerialNumber(SerialNumberUtil.generate((String)"YY%s%s%s%s%s", (String)"WXGD", (String)citys[1]));
            }
        }
        workOrder.setWorkOrderStatus(RepairWorkOrderStatus.AWAITING_REVIEW.getCode());
        this.updateById((Object)workOrder);
        this.customerServiceRepairWorkOrderFileMapper.deleteByOrderId(workOrder.getId());
        if (CollUtil.isNotEmpty((Collection)editVO.getFiles())) {
            this.saveFile(editVO.getFiles(), workOrder.getId());
        }
        this.workFlowService.approveTask(ApproveTaskVO.builder().businessStatus("PASSED").processInstanceId(workOrder.getProcessId()).build());
    }

    public void technicalDeptApprove(ApproveVO approveVO) {
        CustomerServiceRepairWorkOrder workOrder = this.findById(approveVO.getId());
        this.processFlow(workOrder.getProcessId(), approveVO);
    }

    public void engineeringManagerApprove(EngineeringManagerDispatchVO dispatchVO) {
        ApproveVO approveVO = new ApproveVO();
        BeanUtil.copyProperties((Object)dispatchVO, (Object)approveVO, (String[])new String[0]);
        CustomerServiceRepairWorkOrder workOrder = this.findById(approveVO.getId());
        workOrder.setOrderTakerId(Long.valueOf(Long.parseLong(approveVO.getApprover())));
        workOrder.setOrderTakerName(dispatchVO.getName());
        workOrder.setOrderTakerPhoneNumber(dispatchVO.getPhoneNumber());
        this.updateById((Object)workOrder);
        this.processFlow(workOrder.getProcessId(), approveVO);
    }

    public void orderTakerApprove(OrderTakerDispatchVO dispatchVO) {
        ApproveVO approveVO = new ApproveVO();
        BeanUtil.copyProperties((Object)dispatchVO, (Object)approveVO, (String[])new String[0]);
        CustomerServiceRepairWorkOrder workOrder = this.findById(approveVO.getId());
        workOrder.setRepairStaffType(dispatchVO.getRepairStaffType());
        workOrder.setRepairStaffId(Long.valueOf(Long.parseLong(approveVO.getApprover())));
        workOrder.setRepairStaffName(dispatchVO.getName());
        workOrder.setRepairStaffPhoneNumber(dispatchVO.getPhoneNumber());
        this.updateById((Object)workOrder);
        this.processFlow(workOrder.getProcessId(), approveVO);
    }

    public void repairStaffApprove(EngineerRepairVO repairVO) {
        ApproveVO approveVO = new ApproveVO();
        BeanUtil.copyProperties((Object)repairVO, (Object)approveVO, (String[])new String[0]);
        CustomerServiceRepairWorkOrder workOrder = this.findById(approveVO.getId());
        workOrder.setRepairFinishTime(DateUtil.parseLocalDateTime((CharSequence)repairVO.getFinishTime()));
        workOrder.setActualFaultDescription(repairVO.getActualFaultDescription());
        workOrder.setRepairPlan(repairVO.getRepairPlan());
        workOrder.setRepairNote(repairVO.getNote());
        if (StringUtils.isNotBlank((CharSequence)repairVO.getCustomerFile())) {
            workOrder.setCustomerFile(repairVO.getCustomerFile());
        }
        this.updateById((Object)workOrder);
        this.processFlow(workOrder.getProcessId(), approveVO);
    }

    public void customerServiceApprove(ApproveVO approveVO) {
        CustomerServiceRepairWorkOrder workOrder = this.findById(approveVO.getId());
        this.processFlow(workOrder.getProcessId(), approveVO);
    }

    public List<Map<String, String>> getHistoricActivity(String id) {
        CustomerServiceRepairWorkOrder workOrder = this.findById(id);
        return this.workFlowService.getHistoricActivity(workOrder.getProcessId());
    }

    private void jump(CustomerServiceRepairWorkOrder workOrder, JumpVO jumpVO) {
        this.workFlowService.jump(workOrder.getProcessId(), jumpVO.getNode());
        this.updateById((Object)workOrder);
    }

    public void toStart(JumpVO jumpVO) {
        jumpVO.setNode(RepairWorkOrderProcessNode.FILL_OUT_WORK_ORDER.getName());
        this.toNode(jumpVO);
    }

    public void toNode(JumpVO jumpVO) {
        CustomerServiceRepairWorkOrder workOrder = this.findById(jumpVO.getId());
        this.jump(workOrder, jumpVO);
    }

    public void toUp(JumpVO jumpVO) {
        CustomerServiceRepairWorkOrder workOrder = this.findById(jumpVO.getId());
        int processNode = workOrder.getProcessNode();
        if (processNode == RepairWorkOrderProcessNode.FILL_OUT_WORK_ORDER.getCode() || processNode == RepairWorkOrderProcessNode.END.getCode()) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        jumpVO.setNode(RepairWorkOrderProcessNode.getNameByCode((Integer)(--processNode)));
        this.jump(workOrder, jumpVO);
    }

    public void urge(UrgeVO urgeVO) {
        CustomerServiceRepairWorkOrder workOrder = this.findById(urgeVO.getId());
        this.workFlowService.pushTask(PushTaskVO.builder().name("\u60a8\u7684\u7ef4\u4fee\u5de5\u5355\u5df2\u8d85\u65f6\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406").content("\u60a8\u7684\u7ef4\u4fee\u5de5\u5355\u5df2\u8d85\u65f6\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406").isWorkflow(Integer.valueOf(0)).targetUrl(urgeVO.getFormUrl()).senderId(SecurityUtils.getUserId() + "").senderName(SecurityUtils.getUsername()).businessKey(urgeVO.getId()).processInstanceId(workOrder.getProcessId()).receiverIds(Arrays.asList(workOrder.getOrderTakerId() + "")).build());
    }

    public void workOrderTimeOut() {
        this.update((Wrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().lt((Object)"lastest_handle_time", (Object)LocalDate.now())).ge((Object)"process_node", (Object)3)).lt((Object)"process_node", (Object)6)).set((Object)"work_order_status", (Object)RepairWorkOrderStatus.TIME_OUT.getCode()));
    }

    public void tmpStorage(TmpStorageVO tmpStorageVO) throws ParseException {
        CustomerServiceRepairWorkOrder updateEntity = new CustomerServiceRepairWorkOrder();
        updateEntity.setId(Long.valueOf(Long.parseLong(tmpStorageVO.getId())));
        updateEntity.setSubjectName(tmpStorageVO.getSubjectName());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getDispatchTime())) {
            updateEntity.setDispatchTime(LocalDate.parse(tmpStorageVO.getDispatchTime()));
        }
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getLastestHandleTime())) {
            updateEntity.setLastestHandleTime(LocalDate.parse(tmpStorageVO.getLastestHandleTime()));
        }
        updateEntity.setIsUrgent(tmpStorageVO.getIsUrgent());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getExpectedVisitTimeBegin())) {
            updateEntity.setExpectedVisitTimeBegin(LocalTime.parse(tmpStorageVO.getExpectedVisitTimeBegin()));
        }
        updateEntity.setReportRepairPerson(tmpStorageVO.getReportRepairPerson());
        updateEntity.setReportRepairPersonPhoneNumber(tmpStorageVO.getReportRepairPersonPhoneNumber());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getProjectId())) {
            updateEntity.setProjectId(Long.valueOf(Long.parseLong(tmpStorageVO.getProjectId())));
        }
        updateEntity.setProjectName(tmpStorageVO.getProjectName());
        if (StrUtil.isNotBlank((CharSequence)tmpStorageVO.getCity())) {
            String[] citys = tmpStorageVO.getCity().split("-");
            updateEntity.setProvince(citys[0]);
            updateEntity.setCity(citys[1]);
        }
        updateEntity.setUserRoomNo(tmpStorageVO.getUserRoomNo());
        updateEntity.setReportRepairNote(tmpStorageVO.getReportRepairPerson());
        updateEntity.setFaultLevel(tmpStorageVO.getFaultLevel());
        updateEntity.setFaultType(tmpStorageVO.getFaultType());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getPlanMentorId())) {
            updateEntity.setPlanMentorId(Long.valueOf(Long.parseLong(tmpStorageVO.getPlanMentorId())));
        }
        updateEntity.setPlanMentorName(tmpStorageVO.getPlanMentorName());
        updateEntity.setProjectCode(tmpStorageVO.getProjectCode());
        updateEntity.setOpticalModemStatus(tmpStorageVO.getOpticalModemStatus());
        updateEntity.setProcessedPlan(tmpStorageVO.getProcessedPlan());
        updateEntity.setUserCode(tmpStorageVO.getUserCode());
        updateEntity.setFaultNote(tmpStorageVO.getFaultNote());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getOrderTakerId())) {
            updateEntity.setOrderTakerId(Long.valueOf(Long.parseLong(tmpStorageVO.getOrderTakerId())));
        }
        updateEntity.setOrderTakerName(tmpStorageVO.getOrderTakerName());
        updateEntity.setOrderTakerPhoneNumber(tmpStorageVO.getOrderTakerPhoneNumber());
        updateEntity.setRepairStaffType(tmpStorageVO.getRepairStaffType());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getRepairStaffId())) {
            updateEntity.setRepairStaffId(Long.valueOf(Long.parseLong(tmpStorageVO.getRepairStaffId())));
        }
        updateEntity.setRepairStaffName(tmpStorageVO.getRepairStaffName());
        updateEntity.setRepairStaffPhoneNumber(tmpStorageVO.getRepairStaffPhoneNumber());
        updateEntity.setStatus(tmpStorageVO.getStatus());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getCustomerTime())) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            Date parse = sdf.parse(tmpStorageVO.getCustomerTime());
            updateEntity.setCustomerTime(parse);
        }
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getRepairFinishTime())) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
            updateEntity.setRepairFinishTime(LocalDateTime.parse(tmpStorageVO.getRepairFinishTime(), formatter));
        }
        updateEntity.setActualFaultDescription(tmpStorageVO.getActualFaultDescription());
        updateEntity.setRepairPlan(tmpStorageVO.getRepairPlan());
        updateEntity.setRepairNote(tmpStorageVO.getRepairNote());
        updateEntity.setActualSolutionId(tmpStorageVO.getActualSolutionId());
        updateEntity.setActualSolutionName(tmpStorageVO.getActualSolutionName());
        this.updateById((Object)updateEntity);
    }
}

