/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.util;

import cn.hutool.core.date.DateUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.ruoyi.util.PinYinUtil;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class SerialNumberUtil {
    public static String generate(String template, String serialNumberKey, String city) {
        if (city.endsWith("\u5e02") || city.endsWith("\u533a")) {
            city = city.substring(0, city.length() - 1);
        }
        Date now = new Date();
        String year = String.valueOf(DateUtil.year((Date)now));
        String month = DateUtil.format((Date)now, (String)"MM");
        String cityFirstUppercase = PinYinUtil.getFirstUppercase((String)city);
        RedisTemplate redisTemplate = (RedisTemplate)SpringUtil.getBean((String)"redisTemplate");
        Long serialNumber = redisTemplate.opsForValue().increment((Object)("serial_number:" + year + month + ":" + cityFirstUppercase + ":" + serialNumberKey), 1L);
        String result = String.format(template, cityFirstUppercase, year, month, serialNumberKey, String.format("%03d", serialNumber));
        redisTemplate.expire((Object)result, 31L, TimeUnit.DAYS);
        return result;
    }
}

