/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.workflow.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.ruoyi.constant.OpenNetworkWorkOrderProcessNode;
import com.ruoyi.constant.OpenNetworkWorkOrderStatus;
import com.ruoyi.constant.ProcessStatus;
import com.ruoyi.entity.CustomerServiceOpenNetworkWorkOrder;
import com.ruoyi.service.CustomerServiceOpenNetworkWorkOrderService;
import com.ruoyi.workflow.service.WorkFlowCallbackService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="process_xfnket6l")
public class OpenNetworkWorkOrderCallbackService
implements WorkFlowCallbackService {
    private static final Logger log = LoggerFactory.getLogger(OpenNetworkWorkOrderCallbackService.class);
    @Autowired
    private CustomerServiceOpenNetworkWorkOrderService openNetworkWorkOrderService;

    public void callback(JSONObject data) {
        log.info("\u5f00\u7f51\u5de5\u5355\u56de\u8c03=\u300b{}", (Object)data);
        String event = data.getString("event");
        JSONObject body = data.getJSONObject("body");
        String businessKey = body.getString("businessKey");
        if ("PROCESS_STARTED".equals(event)) {
            CustomerServiceOpenNetworkWorkOrder workOrder = this.openNetworkWorkOrderService.findById(businessKey);
            workOrder.setProcessStatus(ProcessStatus.AWAITING_REVIEW.getCode());
            this.openNetworkWorkOrderService.updateById((Object)workOrder);
        } else if ("PROCESS_COMPLETED".equals(event)) {
            CustomerServiceOpenNetworkWorkOrder workOrder = this.openNetworkWorkOrderService.findById(businessKey);
            workOrder.setProcessStatus(ProcessStatus.FINISHED.getCode());
            workOrder.setWorkOrderStatus(OpenNetworkWorkOrderStatus.FINISHED.getCode());
            this.openNetworkWorkOrderService.updateById((Object)workOrder);
        } else if ("TASK_CREATED".equals(event)) {
            Integer workFlowProcessNode = OpenNetworkWorkOrderProcessNode.getCodeByName((String)body.getString("taskDefinitionKey"));
            CustomerServiceOpenNetworkWorkOrder workOrder = this.openNetworkWorkOrderService.findById(businessKey);
            workOrder.setProcessNode(workFlowProcessNode);
            if (OpenNetworkWorkOrderProcessNode.FILL_OUT_WORK_ORDER.getCode() == workFlowProcessNode && workOrder.getProcessStatus() == ProcessStatus.REJECTED.getCode()) {
                workOrder.setWorkOrderStatus(OpenNetworkWorkOrderStatus.REJECTED.getCode());
            }
            this.openNetworkWorkOrderService.updateById((Object)workOrder);
        } else if ("TASK_COMPLETED".equals(event)) {
            JSONObject taskVariables = body.getJSONObject("taskVariables");
            if (null != taskVariables && !taskVariables.isEmpty() && taskVariables.getIntValue("approveStatus") == 2) {
                CustomerServiceOpenNetworkWorkOrder workOrder = this.openNetworkWorkOrderService.findById(businessKey);
                workOrder.setProcessStatus(ProcessStatus.REJECTED.getCode());
                this.openNetworkWorkOrderService.updateById((Object)workOrder);
            } else {
                JSONObject formData = body.getJSONObject("processVariables").getJSONObject("formData");
                CustomerServiceOpenNetworkWorkOrder workOrder = this.openNetworkWorkOrderService.findById(businessKey);
                if (null != formData && !formData.isEmpty()) {
                    BeanUtil.copyProperties((Object)formData, (Object)workOrder, (String[])new String[0]);
                }
                Integer workFlowProcessNode = OpenNetworkWorkOrderProcessNode.getCodeByName((String)body.getString("taskDefinitionKey"));
                if (OpenNetworkWorkOrderProcessNode.CUSTOMER_SERVICE_DEPT.getCode() == workFlowProcessNode) {
                    workOrder.setWorkOrderStatus(OpenNetworkWorkOrderStatus.FINISHED.getCode());
                    workOrder.setProcessNode(OpenNetworkWorkOrderProcessNode.END.getCode());
                } else if (OpenNetworkWorkOrderProcessNode.TECHNICAL_DEPT.getCode() == workFlowProcessNode) {
                    workOrder.setWorkOrderStatus(OpenNetworkWorkOrderStatus.OPENING_NETWORK.getCode());
                } else if (OpenNetworkWorkOrderProcessNode.FILL_OUT_WORK_ORDER.getCode() == workFlowProcessNode) {
                    workOrder.setWorkOrderStatus(OpenNetworkWorkOrderStatus.AWAITING_REVIEW.getCode());
                }
                workOrder.setProcessStatus(ProcessStatus.AWAITING_REVIEW.getCode());
                this.openNetworkWorkOrderService.updateById((Object)workOrder);
            }
        }
    }
}

