/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.construction;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.baomidou.mybatisplus.extension.api.R;
import com.ruoyi.dto.construction.ProjectConstructionLogsDTO;
import com.ruoyi.query.construction.ProjectConstructionLogsQuery;
import com.ruoyi.service.construction.ProjectConstructionLogsService;
import com.ruoyi.service.workFlow.WorkFlowCallBackVO;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.construction.ProjectConstructionLogsDetailsVO;
import com.ruoyi.vo.construction.ProjectConstructionLogsExportVO;
import com.ruoyi.vo.construction.ProjectConstructionLogsPageVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u65bd\u5de5\u65e5\u5fd7", tags={"\u65bd\u5de5\u65e5\u5fd7"})
@RequestMapping(value={"/projectConstructionLogs"})
@RestController
public class ProjectConstructionLogsController {
    private static final Logger log = LoggerFactory.getLogger(ProjectConstructionLogsController.class);
    @Resource
    private ProjectConstructionLogsService projectConstructionLogsService;

    @PostMapping(value={"/getPage"})
    @ApiOperation(value="\u65bd\u5de5\u65e5\u5fd7\u5217\u8868\u9875\u9762")
    public R<PageResultVo<ProjectConstructionLogsPageVO>> getPage(@RequestBody ProjectConstructionLogsQuery projectConstructionLogsQuery) {
        try {
            PageResultVo contractDTOListPage = this.projectConstructionLogsService.getPage(projectConstructionLogsQuery);
            return R.ok((Object)contractDTOListPage);
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u65bd\u5de5\u65e5\u5fd7")
    public void export(@RequestBody ProjectConstructionLogsQuery projectConstructionLogsQuery, HttpServletResponse response) {
        try {
            List contractProjectList = this.projectConstructionLogsService.getList(projectConstructionLogsQuery);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u65bd\u5de5\u65e5\u5fd7", "\u65bd\u5de5\u65e5\u5fd7", ExcelType.XSSF), ProjectConstructionLogsExportVO.class, (Collection)contractProjectList);
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u65bd\u5de5\u65e5\u5fd7");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warn("\u5bfc\u51fa\u5931\u8d25 error:{}", (Object)e.getMessage());
        }
    }

    @GetMapping(value={"getById"})
    @ApiOperation(value="\u65bd\u5de5\u65e5\u5fd7-\u8be6\u60c5")
    public R<ProjectConstructionLogsDetailsVO> getById(Long id) {
        try {
            ProjectConstructionLogsDetailsVO detailVo = this.projectConstructionLogsService.getDetails(id);
            return R.ok((Object)detailVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u521b\u5efa\u52d8\u5bdf\u4fe1\u606f")
    public R<Boolean> create(@RequestBody ProjectConstructionLogsDTO projectConstructionLogsDTO) {
        try {
            return R.ok((Object)this.projectConstructionLogsService.create(projectConstructionLogsDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u65bd\u5de5\u65e5\u5fd7\u4fe1\u606f")
    public R<Boolean> update(@RequestBody ProjectConstructionLogsDTO projectConstructionLogsDTO) {
        try {
            return R.ok((Object)this.projectConstructionLogsService.update(projectConstructionLogsDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u65bd\u5de5\u65e5\u5fd7\u4fe1\u606f-\u5220\u9664")
    public R<Boolean> delete(@PathVariable(value="id") Long id) {
        try {
            return R.ok((Object)this.projectConstructionLogsService.delete(id));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBack"})
    @ApiOperation(value="\u65bd\u5de5\u65e5\u5fd7\u5217\u6570\u636e-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> workFromCallBackProjectSurvey(@RequestBody WorkFlowCallBackVO callBackVO) {
        try {
            this.projectConstructionLogsService.callBack(callBackVO);
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }
}

