/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.construction.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.construction.ProjectAcceptanceCheckDTO;
import com.ruoyi.dto.construction.ProjectAcceptanceRectificationDTO;
import com.ruoyi.entity.construction.ProjectAcceptanceCheckEntity;
import com.ruoyi.entity.construction.ProjectAcceptanceInventoryEntity;
import com.ruoyi.entity.construction.ProjectAcceptanceRectificationChildEntity;
import com.ruoyi.entity.construction.ProjectAcceptanceRectificationEntity;
import com.ruoyi.entity.construction.ProjectAcceptanceScoreEntity;
import com.ruoyi.entity.construction.ProjectAcceptanceStageEntity;
import com.ruoyi.enums.ProjectAcceptanceCheckStatusEnum;
import com.ruoyi.enums.ProjectAcceptanceRectificationStatusEnum;
import com.ruoyi.mapper.construction.ProjectAcceptanceCheckMapper;
import com.ruoyi.query.construction.ProjectAcceptanceCheckQuery;
import com.ruoyi.service.construction.ProjectAcceptanceCheckService;
import com.ruoyi.service.construction.ProjectAcceptanceInventoryService;
import com.ruoyi.service.construction.ProjectAcceptanceRectificationChildService;
import com.ruoyi.service.construction.ProjectAcceptanceRectificationService;
import com.ruoyi.service.construction.ProjectAcceptanceScoreModelService;
import com.ruoyi.service.construction.ProjectAcceptanceScoreService;
import com.ruoyi.service.construction.ProjectAcceptanceStageService;
import com.ruoyi.service.construction.impl.ProjectAcceptanceCheckServiceImpl;
import com.ruoyi.service.workFlow.ProcessDTO;
import com.ruoyi.service.workFlow.ProcessEnum;
import com.ruoyi.service.workFlow.WorkFlowCallBackVO;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.ChineseToPinyinUtils;
import com.ruoyi.util.DateUtils;
import com.ruoyi.util.DozerUtils;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.UserUtils;
import com.ruoyi.vo.construction.ProjectAcceptanceCheckDetailsVO;
import com.ruoyi.vo.construction.ProjectAcceptanceCheckExportVO;
import com.ruoyi.vo.construction.ProjectAcceptanceCheckPageVO;
import com.ruoyi.vo.construction.ProjectAcceptanceInventoryVO;
import com.ruoyi.vo.construction.ProjectAcceptanceRectificationChildVO;
import com.ruoyi.vo.construction.ProjectAcceptanceRectificationDetailsVO;
import com.ruoyi.vo.construction.ProjectAcceptanceScoreVO;
import com.ruoyi.vo.construction.ProjectAcceptanceStageVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectAcceptanceCheckServiceImpl
extends ServiceImpl<ProjectAcceptanceCheckMapper, ProjectAcceptanceCheckEntity>
implements ProjectAcceptanceCheckService {
    @Resource
    private ProjectAcceptanceScoreModelService projectAcceptanceScoreModelService;
    @Resource
    private ProjectAcceptanceScoreService projectAcceptanceScoreService;
    @Resource
    private ProjectAcceptanceStageService projectAcceptanceStageService;
    @Resource
    private ProjectAcceptanceInventoryService projectAcceptanceInventoryService;
    @Resource
    private ProjectAcceptanceRectificationService projectAcceptanceRectificationService;
    @Resource
    private ProjectAcceptanceRectificationChildService projectAcceptanceRectificationChildService;
    @Resource
    private WorkFlowService workFlowService;

    public PageResultVo<ProjectAcceptanceCheckPageVO> getAcceptanceCheckListPage(ProjectAcceptanceCheckQuery projectAcceptanceCheckQuery) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(projectAcceptanceCheckQuery);
        Page page = (Page)this.page((IPage)new Page((long)projectAcceptanceCheckQuery.getPageNum(), (long)projectAcceptanceCheckQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo pageResultVo = new PageResultVo();
        List list = DozerUtils.mapList((Collection)resultVo.getData(), ProjectAcceptanceCheckPageVO.class);
        if (ObjectUtils.isNotEmpty((Object)list)) {
            list.stream().forEach(f -> {
                f.setStatusString(ProjectAcceptanceCheckStatusEnum.getName((Integer)f.getStatus()));
                if (StringUtils.isBlank((CharSequence)f.getAcceptanceRectificationNumber())) {
                    f.setAcceptanceRectificationNumber("\u65e0");
                }
            });
        }
        pageResultVo.setData(list);
        pageResultVo.setPageSize(resultVo.getPageSize());
        pageResultVo.setPageNum(resultVo.getPageNum());
        pageResultVo.setTotal(resultVo.getTotal());
        pageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return pageResultVo;
    }

    private LambdaQueryWrapper getWrapperProject(ProjectAcceptanceCheckQuery projectAcceptanceCheckQuery) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(ObjectUtil.isNotEmpty((Object)projectAcceptanceCheckQuery.getAcceptanceNumber()), ProjectAcceptanceCheckEntity::getAcceptanceNumber, (Object)projectAcceptanceCheckQuery.getAcceptanceNumber())).like(ObjectUtil.isNotEmpty((Object)projectAcceptanceCheckQuery.getProjectName()), ProjectAcceptanceCheckEntity::getProjectName, (Object)projectAcceptanceCheckQuery.getProjectName())).like(ObjectUtil.isNotEmpty((Object)projectAcceptanceCheckQuery.getTopicName()), ProjectAcceptanceCheckEntity::getTopicName, (Object)projectAcceptanceCheckQuery.getTopicName())).ge(ObjectUtil.isNotEmpty((Object)projectAcceptanceCheckQuery.getStartTime()), ProjectAcceptanceCheckEntity::getCreateTime, (Object)(projectAcceptanceCheckQuery.getStartTime() + " 00:0:00"))).le(ObjectUtil.isNotEmpty((Object)projectAcceptanceCheckQuery.getEndTime()), ProjectAcceptanceCheckEntity::getCreateTime, (Object)(projectAcceptanceCheckQuery.getEndTime() + " 23:59:59"))).isNotNull(ObjectUtil.isNotEmpty((Object)projectAcceptanceCheckQuery.getTypes()) && "\u6709".equals(projectAcceptanceCheckQuery.getTypes()), ProjectAcceptanceCheckEntity::getAcceptanceRectificationNumber)).isNull(ObjectUtil.isNotEmpty((Object)projectAcceptanceCheckQuery.getTypes()) && "\u65e0".equals(projectAcceptanceCheckQuery.getTypes()), ProjectAcceptanceCheckEntity::getAcceptanceRectificationNumber)).orderByDesc(ProjectAcceptanceCheckEntity::getCreateTime);
        return wrapper;
    }

    public List<ProjectAcceptanceCheckExportVO> getAcceptanceCheckList(ProjectAcceptanceCheckQuery projectAcceptanceCheckQuery) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(projectAcceptanceCheckQuery);
        List list = this.list((Wrapper)wrapper);
        ArrayList<ProjectAcceptanceCheckExportVO> exportVOS = new ArrayList<ProjectAcceptanceCheckExportVO>();
        if (ObjectUtils.isNotEmpty((Object)list)) {
            for (int i = 0; i < list.size(); ++i) {
                ProjectAcceptanceCheckExportVO exportVO = (ProjectAcceptanceCheckExportVO)DozerUtils.transfor(list.get(i), ProjectAcceptanceCheckExportVO.class);
                exportVO.setStatusString(ProjectAcceptanceCheckStatusEnum.getName((Integer)((ProjectAcceptanceCheckEntity)list.get(i)).getStatus()));
                if (StringUtils.isBlank((CharSequence)exportVO.getAcceptanceRectificationNumber())) {
                    exportVO.setAcceptanceRectificationNumber("\u65e0");
                }
                exportVO.setNumber(Integer.valueOf(i + 1));
                exportVOS.add(exportVO);
            }
        }
        return exportVOS;
    }

    public ProjectAcceptanceCheckDetailsVO getAcceptanceCheckDTOById(Long id) {
        ProjectAcceptanceCheckEntity acceptanceCheckEntity = (ProjectAcceptanceCheckEntity)this.getById((Serializable)id);
        ProjectAcceptanceCheckDetailsVO detailsVO = (ProjectAcceptanceCheckDetailsVO)DozerUtils.transfor((Object)acceptanceCheckEntity, ProjectAcceptanceCheckDetailsVO.class);
        detailsVO.setStatusString(ProjectAcceptanceCheckStatusEnum.getName((Integer)detailsVO.getStatus()));
        List acceptanceStageEntities = ((LambdaQueryChainWrapper)this.projectAcceptanceStageService.lambdaQuery().eq(ProjectAcceptanceStageEntity::getProjectAcceptanceId, (Object)id)).list();
        detailsVO.setAcceptanceStageVOS(DozerUtils.mapList((Collection)acceptanceStageEntities, ProjectAcceptanceStageVO.class));
        List acceptanceInventoryEntities = ((LambdaQueryChainWrapper)this.projectAcceptanceInventoryService.lambdaQuery().eq(ProjectAcceptanceInventoryEntity::getProjectAcceptanceId, (Object)id)).list();
        detailsVO.setAcceptanceInventoryVOS(DozerUtils.mapList((Collection)acceptanceInventoryEntities, ProjectAcceptanceInventoryVO.class));
        List acceptanceScoreEntities = ((LambdaQueryChainWrapper)this.projectAcceptanceScoreService.lambdaQuery().eq(ProjectAcceptanceScoreEntity::getProjectAcceptanceId, (Object)id)).list();
        detailsVO.setAcceptanceScoreVOS(DozerUtils.mapList((Collection)acceptanceScoreEntities, ProjectAcceptanceScoreVO.class));
        String acceptanceRectificationNumber = detailsVO.getAcceptanceRectificationNumber();
        if (StringUtils.isNotBlank((CharSequence)acceptanceRectificationNumber)) {
            ProjectAcceptanceRectificationEntity rectificationEntity = (ProjectAcceptanceRectificationEntity)((LambdaQueryChainWrapper)this.projectAcceptanceRectificationService.lambdaQuery().eq(ProjectAcceptanceRectificationEntity::getAcceptanceRectificationNumber, (Object)acceptanceRectificationNumber)).one();
            ProjectAcceptanceRectificationDetailsVO rectificationDetailsVO = (ProjectAcceptanceRectificationDetailsVO)DozerUtils.transfor((Object)rectificationEntity, ProjectAcceptanceRectificationDetailsVO.class);
            List list = ((LambdaQueryChainWrapper)this.projectAcceptanceRectificationChildService.lambdaQuery().eq(ProjectAcceptanceRectificationChildEntity::getAcceptanceRectificationId, (Object)rectificationEntity.getId())).list();
            List rectificationChildVOS = DozerUtils.mapList((Collection)list, ProjectAcceptanceRectificationChildVO.class);
            rectificationDetailsVO.setRectificationChildVOS(rectificationChildVOS);
            detailsVO.setRectificationDetailsVO(rectificationDetailsVO);
        }
        return detailsVO;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean createAcceptanceCheck(ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO) throws Exception {
        List acceptanceInventoryVOS;
        ProjectAcceptanceCheckEntity acceptanceCheckEntity = (ProjectAcceptanceCheckEntity)DozerUtils.transfor((Object)projectAcceptanceCheckDTO, ProjectAcceptanceCheckEntity.class);
        acceptanceCheckEntity.setId(null);
        LoginUser loginUser = UserUtils.getLoginUser();
        acceptanceCheckEntity.setAcceptanceNumber(this.getNumber(projectAcceptanceCheckDTO));
        acceptanceCheckEntity.setCreateName(loginUser.getUsername());
        acceptanceCheckEntity.setCreateId(loginUser.getUserid());
        acceptanceCheckEntity.setCreateTime(new Date());
        acceptanceCheckEntity.setStatus(ProjectAcceptanceCheckStatusEnum.ZERO.getCode());
        this.save((Object)acceptanceCheckEntity);
        List acceptanceStageVOS = projectAcceptanceCheckDTO.getAcceptanceStageVOS();
        if (ObjectUtils.isNotEmpty((Object)acceptanceStageVOS)) {
            List projectPlanStageEntities = DozerUtils.mapList((Collection)acceptanceStageVOS, ProjectAcceptanceStageEntity.class);
            for (ProjectAcceptanceStageEntity projectPlanStageEntity : projectPlanStageEntities) {
                projectPlanStageEntity.setId(null);
                projectPlanStageEntity.setCreateName(loginUser.getUsername());
                projectPlanStageEntity.setCreateId(loginUser.getUserid());
                projectPlanStageEntity.setCreateTime(new Date());
                projectPlanStageEntity.setProjectAcceptanceId(acceptanceCheckEntity.getId());
                this.projectAcceptanceStageService.save((Object)projectPlanStageEntity);
            }
        }
        if (ObjectUtils.isNotEmpty((Object)(acceptanceInventoryVOS = projectAcceptanceCheckDTO.getAcceptanceInventoryVOS()))) {
            List projectPlanStageEntities = DozerUtils.mapList((Collection)acceptanceInventoryVOS, ProjectAcceptanceInventoryEntity.class);
            for (ProjectAcceptanceInventoryEntity projectPlanStageEntity : projectPlanStageEntities) {
                projectPlanStageEntity.setId(null);
                projectPlanStageEntity.setCreateName(loginUser.getUsername());
                projectPlanStageEntity.setCreateId(loginUser.getUserid());
                projectPlanStageEntity.setCreateTime(new Date());
                projectPlanStageEntity.setProjectAcceptanceId(acceptanceCheckEntity.getId());
                this.projectAcceptanceInventoryService.save((Object)projectPlanStageEntity);
            }
        }
        ProcessDTO processDTO = new ProcessDTO();
        HashMap<String, Long> stringStringHashMap = new HashMap<String, Long>();
        stringStringHashMap.put("createId", loginUser.getUserid());
        processDTO.setFormData(stringStringHashMap);
        processDTO.setProcessInstanceName(acceptanceCheckEntity.getTopicName());
        processDTO.setProjectName(acceptanceCheckEntity.getProjectName());
        processDTO.setBusinessKey(acceptanceCheckEntity.getId().toString());
        String processId = this.workFlowService.startProcess(ProcessEnum.check, processDTO, new Object[]{acceptanceCheckEntity.getId().toString()});
        if (ObjectUtils.isNotEmpty((Object)processId)) {
            acceptanceCheckEntity.setProcessInstId(processId);
            this.updateById((Object)acceptanceCheckEntity);
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean updateAcceptanceCheck(ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO) {
        ProjectAcceptanceCheckEntity acceptanceCheckEntity = (ProjectAcceptanceCheckEntity)DozerUtils.transfor((Object)projectAcceptanceCheckDTO, ProjectAcceptanceCheckEntity.class);
        LoginUser loginUser = UserUtils.getLoginUser();
        acceptanceCheckEntity.setUpdateName(loginUser.getUsername());
        acceptanceCheckEntity.setUpdateId(loginUser.getUserid());
        acceptanceCheckEntity.setUpdateTime(new Date());
        this.updateById((Object)acceptanceCheckEntity);
        List acceptanceStageVOS = projectAcceptanceCheckDTO.getAcceptanceStageVOS();
        this.projectAcceptanceStageService.remove((Wrapper)new LambdaQueryWrapper().eq(ProjectAcceptanceStageEntity::getProjectAcceptanceId, (Object)acceptanceCheckEntity.getId()));
        if (ObjectUtils.isNotEmpty((Object)acceptanceStageVOS)) {
            List projectPlanStageEntities = DozerUtils.mapList((Collection)acceptanceStageVOS, ProjectAcceptanceStageEntity.class);
            for (ProjectAcceptanceStageEntity projectPlanStageEntity : projectPlanStageEntities) {
                projectPlanStageEntity.setUpdateName(loginUser.getUsername());
                projectPlanStageEntity.setUpdateId(loginUser.getUserid());
                projectPlanStageEntity.setUpdateTime(new Date());
                projectPlanStageEntity.setProjectAcceptanceId(acceptanceCheckEntity.getId());
                this.projectAcceptanceStageService.save((Object)projectPlanStageEntity);
            }
        }
        this.projectAcceptanceInventoryService.remove((Wrapper)new LambdaQueryWrapper().eq(ProjectAcceptanceInventoryEntity::getProjectAcceptanceId, (Object)acceptanceCheckEntity.getId()));
        List acceptanceInventoryVOS = projectAcceptanceCheckDTO.getAcceptanceInventoryVOS();
        if (ObjectUtils.isNotEmpty((Object)acceptanceInventoryVOS)) {
            List projectPlanStageEntities = DozerUtils.mapList((Collection)acceptanceInventoryVOS, ProjectAcceptanceInventoryEntity.class);
            for (ProjectAcceptanceInventoryEntity projectPlanStageEntity : projectPlanStageEntities) {
                projectPlanStageEntity.setUpdateName(loginUser.getUsername());
                projectPlanStageEntity.setUpdateId(loginUser.getUserid());
                projectPlanStageEntity.setUpdateTime(new Date());
                projectPlanStageEntity.setProjectAcceptanceId(acceptanceCheckEntity.getId());
                this.projectAcceptanceInventoryService.save((Object)projectPlanStageEntity);
            }
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean callBackUpdate(ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO) {
        if (ObjectUtils.isEmpty((Object)projectAcceptanceCheckDTO) || StringUtils.isEmpty((CharSequence)projectAcceptanceCheckDTO.getTaskKey())) {
            return null;
        }
        String jiedian = projectAcceptanceCheckDTO.getTaskKey();
        ProjectAcceptanceCheckEntity acceptanceCheckEntity = (ProjectAcceptanceCheckEntity)DozerUtils.transfor((Object)projectAcceptanceCheckDTO, ProjectAcceptanceCheckEntity.class);
        LoginUser loginUser = UserUtils.getLoginUser();
        if ("Activity_0fkpom0".equals(jiedian)) {
            acceptanceCheckEntity.setUpdateName(loginUser.getUsername());
            acceptanceCheckEntity.setUpdateId(loginUser.getUserid());
            acceptanceCheckEntity.setUpdateTime(new Date());
            this.updateById((Object)acceptanceCheckEntity);
            List acceptanceStageVOS = projectAcceptanceCheckDTO.getAcceptanceStageVOS();
            this.projectAcceptanceStageService.remove((Wrapper)new LambdaQueryWrapper().eq(ProjectAcceptanceStageEntity::getProjectAcceptanceId, (Object)acceptanceCheckEntity.getId()));
            if (ObjectUtils.isNotEmpty((Object)acceptanceStageVOS)) {
                List projectPlanStageEntities = DozerUtils.mapList((Collection)acceptanceStageVOS, ProjectAcceptanceStageEntity.class);
                for (ProjectAcceptanceStageEntity projectPlanStageEntity : projectPlanStageEntities) {
                    projectPlanStageEntity.setUpdateName(loginUser.getUsername());
                    projectPlanStageEntity.setUpdateId(loginUser.getUserid());
                    projectPlanStageEntity.setUpdateTime(new Date());
                    projectPlanStageEntity.setProjectAcceptanceId(acceptanceCheckEntity.getId());
                    this.projectAcceptanceStageService.save((Object)projectPlanStageEntity);
                }
            }
            this.projectAcceptanceInventoryService.remove((Wrapper)new LambdaQueryWrapper().eq(ProjectAcceptanceInventoryEntity::getProjectAcceptanceId, (Object)acceptanceCheckEntity.getId()));
            List acceptanceInventoryVOS = projectAcceptanceCheckDTO.getAcceptanceInventoryVOS();
            if (ObjectUtils.isNotEmpty((Object)acceptanceInventoryVOS)) {
                List projectPlanStageEntities = DozerUtils.mapList((Collection)acceptanceInventoryVOS, ProjectAcceptanceInventoryEntity.class);
                for (ProjectAcceptanceInventoryEntity projectPlanStageEntity : projectPlanStageEntities) {
                    projectPlanStageEntity.setUpdateName(loginUser.getUsername());
                    projectPlanStageEntity.setUpdateId(loginUser.getUserid());
                    projectPlanStageEntity.setUpdateTime(new Date());
                    projectPlanStageEntity.setProjectAcceptanceId(acceptanceCheckEntity.getId());
                    this.projectAcceptanceInventoryService.save((Object)projectPlanStageEntity);
                }
            }
        } else if (!("Activity_0r15fd4".equals(jiedian) || "Activity_1ayaqq5".equals(jiedian) || "Activity_02dgtca".equals(jiedian) || "Activity_0ajjtvy".equals(jiedian) || "Activity_05uhac1".equals(jiedian))) {
            if ("Activity_0mwi7an".equals(jiedian)) {
                ProjectAcceptanceRectificationDetailsVO rectificationDetailsVO = projectAcceptanceCheckDTO.getRectificationDetailsVO();
                ProjectAcceptanceRectificationDTO projectAcceptanceRectificationDTO = (ProjectAcceptanceRectificationDTO)DozerUtils.transfor((Object)rectificationDetailsVO, ProjectAcceptanceRectificationDTO.class);
                projectAcceptanceRectificationDTO.setStatus(ProjectAcceptanceRectificationStatusEnum.ONE.getCode());
                this.projectAcceptanceRectificationService.updateAcceptanceRectification(projectAcceptanceRectificationDTO);
            } else if ("Activity_0tajesc".equals(jiedian) || "Activity_1j8rmck".equals(jiedian) || "vActivity_1dccm46".equals(jiedian)) {
                // empty if block
            }
        }
        return true;
    }

    public Boolean deleteAcceptanceCheck(Long id) {
        return this.removeById((Serializable)id);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void callBack(WorkFlowCallBackVO callBackVO) {
        String event = callBackVO.getEvent();
        ProjectAcceptanceCheckEntity acceptanceCheckEntity = new ProjectAcceptanceCheckEntity();
        acceptanceCheckEntity.setId(callBackVO.getBody().getBusinessKey());
        switch (1.$SwitchMap$com$ruoyi$service$workFlow$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                return;
            }
            case 2: {
                WorkFlowCallBackVO.ProcessVariables processVariables = callBackVO.getBody().getProcessVariables();
                String fromUrl = processVariables.getFromUrl();
                if (!StringUtils.isNotBlank((CharSequence)fromUrl)) return;
                String[] taskKey = fromUrl.split("taskKey=");
                String jiedian = taskKey[1].split("&")[0];
                if ("Activity_0fkpom0".equals(jiedian)) {
                    acceptanceCheckEntity.setStatus(ProjectAcceptanceCheckStatusEnum.ZERO.getCode());
                    this.updateById((Object)acceptanceCheckEntity);
                    return;
                }
                if ("Activity_0r15fd4".equals(jiedian)) {
                    WorkFlowCallBackVO.TaskVariables taskVariables = callBackVO.getBody().getTaskVariables();
                    if (2 == taskVariables.getApproveStatus()) {
                        acceptanceCheckEntity.setStatus(ProjectAcceptanceCheckStatusEnum.ONE.getCode());
                    } else if (1 == taskVariables.getApproveStatus()) {
                        acceptanceCheckEntity.setStatus(ProjectAcceptanceCheckStatusEnum.TWO.getCode());
                    }
                    this.updateById((Object)acceptanceCheckEntity);
                    return;
                }
                if ("Activity_1ayaqq5".equals(jiedian)) {
                    acceptanceCheckEntity.setStatus(ProjectAcceptanceCheckStatusEnum.THREE.getCode());
                    this.updateById((Object)acceptanceCheckEntity);
                    return;
                }
                if ("Activity_02dgtca".equals(jiedian)) {
                    ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO = processVariables.getFormData();
                    acceptanceCheckEntity.setId(projectAcceptanceCheckDTO.getId());
                    acceptanceCheckEntity.setScoringPersonnelId(projectAcceptanceCheckDTO.getScoringPersonnelId());
                    acceptanceCheckEntity.setScoringPersonnelName(projectAcceptanceCheckDTO.getScoringPersonnelName());
                    acceptanceCheckEntity.setStatus(ProjectAcceptanceCheckStatusEnum.FOUR.getCode());
                    this.updateById((Object)acceptanceCheckEntity);
                    this.projectAcceptanceScoreService.remove((Wrapper)new LambdaQueryWrapper().eq(ProjectAcceptanceScoreEntity::getProjectAcceptanceId, (Object)acceptanceCheckEntity.getId()));
                    List acceptanceScoreVOS = projectAcceptanceCheckDTO.getAcceptanceScoreVOS();
                    if (!ObjectUtils.isNotEmpty((Object)acceptanceScoreVOS)) return;
                    List projectPlanStageEntities = DozerUtils.mapList((Collection)acceptanceScoreVOS, ProjectAcceptanceScoreEntity.class);
                    for (ProjectAcceptanceScoreEntity projectPlanStageEntity : projectPlanStageEntities) {
                        projectPlanStageEntity.setUpdateTime(new Date());
                        projectPlanStageEntity.setProjectAcceptanceId(acceptanceCheckEntity.getId());
                        this.projectAcceptanceScoreService.save((Object)projectPlanStageEntity);
                    }
                    return;
                }
                if ("Activity_0ajjtvy".equals(jiedian)) {
                    ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO = processVariables.getFormData();
                    String comments = projectAcceptanceCheckDTO.getComments();
                    if (StringUtils.isNotBlank((CharSequence)comments)) {
                        acceptanceCheckEntity.setComments(comments);
                    }
                    acceptanceCheckEntity.setStatus(ProjectAcceptanceCheckStatusEnum.FIVE.getCode());
                    this.updateById((Object)acceptanceCheckEntity);
                    return;
                }
                if ("Activity_05uhac1".equals(jiedian)) {
                    ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO = processVariables.getFormData();
                    String isRectification = projectAcceptanceCheckDTO.getIsRectification();
                    if ("0".equals(isRectification)) {
                        acceptanceCheckEntity.setIsRectification(isRectification);
                        ProjectAcceptanceRectificationDetailsVO rectificationDetailsVO = projectAcceptanceCheckDTO.getRectificationDetailsVO();
                        ProjectAcceptanceRectificationDTO projectAcceptanceRectificationDTO = (ProjectAcceptanceRectificationDTO)DozerUtils.transfor((Object)rectificationDetailsVO, ProjectAcceptanceRectificationDTO.class);
                        projectAcceptanceRectificationDTO.setProjectCode(projectAcceptanceCheckDTO.getProjectCode());
                        projectAcceptanceRectificationDTO.setProjectName(projectAcceptanceCheckDTO.getProjectName());
                        projectAcceptanceRectificationDTO.setRectificationPersonnelId(projectAcceptanceCheckDTO.getCreateId().toString());
                        projectAcceptanceRectificationDTO.setRectificationPersonnelName(projectAcceptanceCheckDTO.getCreateName());
                        projectAcceptanceRectificationDTO.setInspectPersonnelId(projectAcceptanceCheckDTO.getScoringPersonnelId());
                        projectAcceptanceRectificationDTO.setInspectPersonnelName(projectAcceptanceCheckDTO.getScoringPersonnelName());
                        String acceptanceRectification = this.projectAcceptanceRectificationService.createAcceptanceRectification(projectAcceptanceRectificationDTO);
                        acceptanceCheckEntity.setAcceptanceRectificationNumber(acceptanceRectification);
                    }
                    acceptanceCheckEntity.setStatus(ProjectAcceptanceCheckStatusEnum.SIX.getCode());
                    this.updateById((Object)acceptanceCheckEntity);
                    return;
                }
                if ("Activity_0mwi7an".equals(jiedian)) {
                    ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO = processVariables.getFormData();
                    String acceptanceRectificationNumber = projectAcceptanceCheckDTO.getAcceptanceRectificationNumber();
                    ProjectAcceptanceRectificationEntity rectificationEntity = (ProjectAcceptanceRectificationEntity)((LambdaQueryChainWrapper)this.projectAcceptanceRectificationService.lambdaQuery().eq(ProjectAcceptanceRectificationEntity::getAcceptanceRectificationNumber, (Object)acceptanceRectificationNumber)).one();
                    ProjectAcceptanceRectificationEntity rectificationVO = new ProjectAcceptanceRectificationEntity();
                    rectificationVO.setId(rectificationEntity.getId());
                    rectificationVO.setStatus(ProjectAcceptanceRectificationStatusEnum.TWO.getCode());
                    this.projectAcceptanceRectificationService.updateById((Object)rectificationVO);
                    return;
                }
                if ("Activity_0tajesc".equals(jiedian)) {
                    WorkFlowCallBackVO.TaskVariables taskVariables = callBackVO.getBody().getTaskVariables();
                    if (2 == taskVariables.getApproveStatus()) {
                        ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO = processVariables.getFormData();
                        String acceptanceRectificationNumber = projectAcceptanceCheckDTO.getAcceptanceRectificationNumber();
                        ProjectAcceptanceRectificationEntity rectificationEntity = (ProjectAcceptanceRectificationEntity)((LambdaQueryChainWrapper)this.projectAcceptanceRectificationService.lambdaQuery().eq(ProjectAcceptanceRectificationEntity::getAcceptanceRectificationNumber, (Object)acceptanceRectificationNumber)).one();
                        ProjectAcceptanceRectificationEntity rectificationVO = new ProjectAcceptanceRectificationEntity();
                        rectificationVO.setId(rectificationEntity.getId());
                        rectificationVO.setRectificationTime(new Date());
                        rectificationVO.setStatus(ProjectAcceptanceRectificationStatusEnum.THREE.getCode());
                        rectificationVO.setReasons(callBackVO.getBody().getTaskComment());
                        this.projectAcceptanceRectificationService.updateById((Object)rectificationVO);
                        return;
                    }
                    if (1 != taskVariables.getApproveStatus()) return;
                }
                if ("Activity_1j8rmck".equals(jiedian)) {
                    WorkFlowCallBackVO.TaskVariables taskVariables = callBackVO.getBody().getTaskVariables();
                    if (2 == taskVariables.getApproveStatus()) {
                        ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO = processVariables.getFormData();
                        String acceptanceRectificationNumber = projectAcceptanceCheckDTO.getAcceptanceRectificationNumber();
                        ProjectAcceptanceRectificationEntity rectificationEntity = (ProjectAcceptanceRectificationEntity)((LambdaQueryChainWrapper)this.projectAcceptanceRectificationService.lambdaQuery().eq(ProjectAcceptanceRectificationEntity::getAcceptanceRectificationNumber, (Object)acceptanceRectificationNumber)).one();
                        ProjectAcceptanceRectificationEntity rectificationVO = new ProjectAcceptanceRectificationEntity();
                        rectificationVO.setId(rectificationEntity.getId());
                        rectificationVO.setStatus(ProjectAcceptanceRectificationStatusEnum.THREE.getCode());
                        rectificationVO.setReasons(callBackVO.getBody().getTaskComment());
                        this.projectAcceptanceRectificationService.updateById((Object)rectificationVO);
                        return;
                    }
                    if (1 != taskVariables.getApproveStatus()) return;
                }
                if (!"vActivity_1dccm46".equals(jiedian)) return;
                WorkFlowCallBackVO.TaskVariables taskVariables = callBackVO.getBody().getTaskVariables();
                if (2 == taskVariables.getApproveStatus()) {
                    ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO = processVariables.getFormData();
                    String acceptanceRectificationNumber = projectAcceptanceCheckDTO.getAcceptanceRectificationNumber();
                    ProjectAcceptanceRectificationEntity rectificationEntity = (ProjectAcceptanceRectificationEntity)((LambdaQueryChainWrapper)this.projectAcceptanceRectificationService.lambdaQuery().eq(ProjectAcceptanceRectificationEntity::getAcceptanceRectificationNumber, (Object)acceptanceRectificationNumber)).one();
                    ProjectAcceptanceRectificationEntity rectificationVO = new ProjectAcceptanceRectificationEntity();
                    rectificationVO.setId(rectificationEntity.getId());
                    rectificationVO.setStatus(ProjectAcceptanceRectificationStatusEnum.THREE.getCode());
                    rectificationVO.setReasons(callBackVO.getBody().getTaskComment());
                    this.projectAcceptanceRectificationService.updateById((Object)rectificationVO);
                    return;
                }
                if (1 != taskVariables.getApproveStatus()) return;
            }
            case 3: {
                return;
            }
            case 4: {
                return;
            }
            case 5: {
                acceptanceCheckEntity.setStatus(ProjectAcceptanceCheckStatusEnum.TEN.getCode());
                this.updateById((Object)acceptanceCheckEntity);
                WorkFlowCallBackVO.ProcessVariables processVariables1111 = callBackVO.getBody().getProcessVariables();
                ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO = processVariables1111.getFormData();
                String acceptanceRectificationNumber = projectAcceptanceCheckDTO.getAcceptanceRectificationNumber();
                ProjectAcceptanceRectificationEntity rectificationEntity = (ProjectAcceptanceRectificationEntity)((LambdaQueryChainWrapper)this.projectAcceptanceRectificationService.lambdaQuery().eq(ProjectAcceptanceRectificationEntity::getAcceptanceRectificationNumber, (Object)acceptanceRectificationNumber)).one();
                ProjectAcceptanceRectificationEntity rectificationVO = new ProjectAcceptanceRectificationEntity();
                rectificationVO.setId(rectificationEntity.getId());
                rectificationVO.setStatus(ProjectAcceptanceRectificationStatusEnum.FOUR.getCode());
                rectificationVO.setReasons(callBackVO.getBody().getTaskComment());
                this.projectAcceptanceRectificationService.updateById((Object)rectificationVO);
            }
        }
    }

    public List<ProjectAcceptanceInventoryVO> getInventoryVO(String projectCode) {
        return ((ProjectAcceptanceCheckMapper)this.baseMapper).getInventoryVO(projectCode);
    }

    public JSONObject setProcessVariables(String processInstanceId, Map<String, Object> map) {
        return this.workFlowService.setProcessVariables(processInstanceId, map);
    }

    public List<ProjectAcceptanceScoreVO> getScoreModel() {
        List list = this.projectAcceptanceScoreModelService.list();
        return DozerUtils.mapList((Collection)list, ProjectAcceptanceScoreVO.class);
    }

    public String getNumber(ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JGYS");
        if (StringUtils.isNotBlank((CharSequence)projectAcceptanceCheckDTO.getBelongingBrand())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterUpper((String)projectAcceptanceCheckDTO.getBelongingBrand()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectAcceptanceCheckDTO.getChildBelongingBrand())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterLower((String)projectAcceptanceCheckDTO.getChildBelongingBrand()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectAcceptanceCheckDTO.getProjectName())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterUpper((String)projectAcceptanceCheckDTO.getProjectName()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectAcceptanceCheckDTO.getCityNo())) {
            stringBuffer.append(projectAcceptanceCheckDTO.getCityNo());
        }
        stringBuffer.append(DateUtils.getDateToString((Date)DateTime.now(), (String)"yyyyMMdd"));
        Integer count = ((ProjectAcceptanceCheckMapper)this.baseMapper).selectCountInToday();
        stringBuffer.append(String.format("%04d", count + 1));
        return stringBuffer.toString();
    }
}

