/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.construction.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.construction.ProjectAcceptanceRectificationDTO;
import com.ruoyi.entity.construction.ProjectAcceptanceRectificationChildEntity;
import com.ruoyi.entity.construction.ProjectAcceptanceRectificationEntity;
import com.ruoyi.enums.ProjectAcceptanceRectificationStatusEnum;
import com.ruoyi.mapper.construction.ProjectAcceptanceRectificationMapper;
import com.ruoyi.query.construction.ProjectAcceptanceRectificationQuery;
import com.ruoyi.service.construction.ProjectAcceptanceRectificationChildService;
import com.ruoyi.service.construction.ProjectAcceptanceRectificationService;
import com.ruoyi.service.construction.impl.ProjectAcceptanceRectificationServiceImpl;
import com.ruoyi.service.workFlow.WorkFlowCallBackVO;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.ChineseToPinyinUtils;
import com.ruoyi.util.DateUtils;
import com.ruoyi.util.DozerUtils;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.UserUtils;
import com.ruoyi.vo.construction.ProjectAcceptanceRectificationChildVO;
import com.ruoyi.vo.construction.ProjectAcceptanceRectificationDetailsVO;
import com.ruoyi.vo.construction.ProjectAcceptanceRectificationExportVO;
import com.ruoyi.vo.construction.ProjectAcceptanceRectificationPageVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectAcceptanceRectificationServiceImpl
extends ServiceImpl<ProjectAcceptanceRectificationMapper, ProjectAcceptanceRectificationEntity>
implements ProjectAcceptanceRectificationService {
    @Resource
    private ProjectAcceptanceRectificationChildService projectAcceptanceRectificationChildService;

    public PageResultVo<ProjectAcceptanceRectificationPageVO> getAcceptanceRectificationListPage(ProjectAcceptanceRectificationQuery projectAcceptanceRectificationQuery) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(projectAcceptanceRectificationQuery);
        Page page = (Page)this.page((IPage)new Page((long)projectAcceptanceRectificationQuery.getPageNum(), (long)projectAcceptanceRectificationQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo contractDTOPageResultVo = new PageResultVo();
        List contractDTOList = DozerUtils.mapList((Collection)resultVo.getData(), ProjectAcceptanceRectificationPageVO.class);
        if (ObjectUtils.isNotEmpty((Object)contractDTOList)) {
            contractDTOList.stream().forEach(f -> f.setStatusString(ProjectAcceptanceRectificationStatusEnum.getName((Integer)f.getStatus())));
        }
        contractDTOPageResultVo.setData(contractDTOList);
        contractDTOPageResultVo.setPageSize(resultVo.getPageSize());
        contractDTOPageResultVo.setPageNum(resultVo.getPageNum());
        contractDTOPageResultVo.setTotal(resultVo.getTotal());
        contractDTOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return contractDTOPageResultVo;
    }

    private LambdaQueryWrapper getWrapperProject(ProjectAcceptanceRectificationQuery projectAcceptanceRectificationQuery) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(ObjectUtil.isNotEmpty((Object)projectAcceptanceRectificationQuery.getAcceptanceRectificationNumber()), ProjectAcceptanceRectificationEntity::getAcceptanceRectificationNumber, (Object)projectAcceptanceRectificationQuery.getAcceptanceRectificationNumber())).like(ObjectUtil.isNotEmpty((Object)projectAcceptanceRectificationQuery.getProjectName()), ProjectAcceptanceRectificationEntity::getProjectName, (Object)projectAcceptanceRectificationQuery.getProjectName())).like(ObjectUtil.isNotEmpty((Object)projectAcceptanceRectificationQuery.getRectificationPersonnelName()), ProjectAcceptanceRectificationEntity::getRectificationPersonnelName, (Object)projectAcceptanceRectificationQuery.getRectificationPersonnelName())).like(ObjectUtil.isNotEmpty((Object)projectAcceptanceRectificationQuery.getStatus()), ProjectAcceptanceRectificationEntity::getStatus, (Object)projectAcceptanceRectificationQuery.getStatus())).ge(ObjectUtil.isNotEmpty((Object)projectAcceptanceRectificationQuery.getStartTime()), ProjectAcceptanceRectificationEntity::getRectificationTime, (Object)(projectAcceptanceRectificationQuery.getStartTime() + " 00:0:00"))).le(ObjectUtil.isNotEmpty((Object)projectAcceptanceRectificationQuery.getEndTime()), ProjectAcceptanceRectificationEntity::getRectificationTime, (Object)(projectAcceptanceRectificationQuery.getEndTime() + " 23:59:59"))).orderByDesc(ProjectAcceptanceRectificationEntity::getCreateTime);
        return wrapper;
    }

    public List<ProjectAcceptanceRectificationExportVO> getAcceptanceRectificationList(ProjectAcceptanceRectificationQuery projectAcceptanceRectificationQuery) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(projectAcceptanceRectificationQuery);
        List contractEntityList = this.list((Wrapper)wrapper);
        List exportVOS = DozerUtils.mapList((Collection)contractEntityList, ProjectAcceptanceRectificationExportVO.class);
        if (ObjectUtils.isNotEmpty((Object)exportVOS)) {
            for (int i = 0; i < exportVOS.size(); ++i) {
                ((ProjectAcceptanceRectificationExportVO)exportVOS.get(i)).setNumber(Integer.valueOf(i + 1));
                ((ProjectAcceptanceRectificationExportVO)exportVOS.get(i)).setStatusString(ProjectAcceptanceRectificationStatusEnum.getName((Integer)((ProjectAcceptanceRectificationExportVO)exportVOS.get(i)).getStatus()));
            }
        }
        return exportVOS;
    }

    public ProjectAcceptanceRectificationDetailsVO getAcceptanceRectificationDTOById(Long id) {
        ProjectAcceptanceRectificationEntity projectPlanEntity = (ProjectAcceptanceRectificationEntity)this.getById((Serializable)id);
        ProjectAcceptanceRectificationDetailsVO detailsVO = (ProjectAcceptanceRectificationDetailsVO)DozerUtils.transfor((Object)projectPlanEntity, ProjectAcceptanceRectificationDetailsVO.class);
        List list = ((LambdaQueryChainWrapper)this.projectAcceptanceRectificationChildService.lambdaQuery().eq(ProjectAcceptanceRectificationChildEntity::getAcceptanceRectificationId, (Object)id)).list();
        List rectificationChildVOS = DozerUtils.mapList((Collection)list, ProjectAcceptanceRectificationChildVO.class);
        detailsVO.setRectificationChildVOS(rectificationChildVOS);
        return detailsVO;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public String createAcceptanceRectification(ProjectAcceptanceRectificationDTO projectAcceptanceRectificationDTO) {
        ProjectAcceptanceRectificationEntity rectificationEntity = (ProjectAcceptanceRectificationEntity)DozerUtils.transfor((Object)projectAcceptanceRectificationDTO, ProjectAcceptanceRectificationEntity.class);
        rectificationEntity.setId(null);
        rectificationEntity.setAcceptanceRectificationNumber(this.getNumber(projectAcceptanceRectificationDTO));
        LoginUser loginUser = UserUtils.getLoginUser();
        rectificationEntity.setCreateName(loginUser.getUsername());
        rectificationEntity.setCreateId(loginUser.getUserid());
        rectificationEntity.setCreateTime(new Date());
        rectificationEntity.setStatus(ProjectAcceptanceRectificationStatusEnum.ZERO.getCode());
        this.save((Object)rectificationEntity);
        List rectificationChildVOS = projectAcceptanceRectificationDTO.getRectificationChildVOS();
        if (ObjectUtils.isNotEmpty((Object)rectificationChildVOS)) {
            List rectificationChildEntities = DozerUtils.mapList((Collection)rectificationChildVOS, ProjectAcceptanceRectificationChildEntity.class);
            for (ProjectAcceptanceRectificationChildEntity rectificationChildEntity : rectificationChildEntities) {
                rectificationChildEntity.setId(null);
                rectificationChildEntity.setCreateName(loginUser.getUsername());
                rectificationChildEntity.setCreateId(loginUser.getUserid());
                rectificationChildEntity.setCreateTime(new Date());
                rectificationChildEntity.setAcceptanceRectificationId(rectificationEntity.getId());
                this.projectAcceptanceRectificationChildService.save((Object)rectificationChildEntity);
            }
        }
        return rectificationEntity.getAcceptanceRectificationNumber();
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean updateAcceptanceRectification(ProjectAcceptanceRectificationDTO projectAcceptanceRectificationDTO) {
        ProjectAcceptanceRectificationEntity rectificationEntity = (ProjectAcceptanceRectificationEntity)DozerUtils.transfor((Object)projectAcceptanceRectificationDTO, ProjectAcceptanceRectificationEntity.class);
        LoginUser loginUser = UserUtils.getLoginUser();
        rectificationEntity.setUpdateName(loginUser.getUsername());
        rectificationEntity.setUpdateId(loginUser.getUserid());
        rectificationEntity.setUpdateTime(new Date());
        rectificationEntity.setRectificationTime(new Date());
        this.updateById((Object)rectificationEntity);
        this.projectAcceptanceRectificationChildService.remove((Wrapper)new LambdaQueryWrapper().eq(ProjectAcceptanceRectificationChildEntity::getAcceptanceRectificationId, (Object)rectificationEntity.getId()));
        List rectificationChildVOS = projectAcceptanceRectificationDTO.getRectificationChildVOS();
        if (ObjectUtils.isNotEmpty((Object)rectificationChildVOS)) {
            List rectificationChildEntities = DozerUtils.mapList((Collection)rectificationChildVOS, ProjectAcceptanceRectificationChildEntity.class);
            for (ProjectAcceptanceRectificationChildEntity rectificationChildEntity : rectificationChildEntities) {
                rectificationChildEntity.setId(null);
                rectificationChildEntity.setCreateName(loginUser.getUsername());
                rectificationChildEntity.setCreateId(loginUser.getUserid());
                rectificationChildEntity.setCreateTime(new Date());
                rectificationChildEntity.setAcceptanceRectificationId(rectificationEntity.getId());
                this.projectAcceptanceRectificationChildService.save((Object)rectificationChildEntity);
            }
        }
        return true;
    }

    public Boolean submit(ProjectAcceptanceRectificationDTO projectAcceptanceRectificationDTO) {
        this.updateAcceptanceRectification(projectAcceptanceRectificationDTO);
        return null;
    }

    public Boolean deleteAcceptanceRectification(Long id) {
        return this.removeById((Serializable)id);
    }

    public void callBack(WorkFlowCallBackVO callBackVO) {
        String event = callBackVO.getEvent();
        switch (1.$SwitchMap$com$ruoyi$service$workFlow$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
        }
    }

    public String getNumber(ProjectAcceptanceRectificationDTO projectAcceptanceRectificationDTO) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JGZG");
        if (StringUtils.isNotBlank((CharSequence)projectAcceptanceRectificationDTO.getBelongingBrand())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterUpper((String)projectAcceptanceRectificationDTO.getBelongingBrand()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectAcceptanceRectificationDTO.getChildBelongingBrand())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterLower((String)projectAcceptanceRectificationDTO.getChildBelongingBrand()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectAcceptanceRectificationDTO.getProjectName())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterUpper((String)projectAcceptanceRectificationDTO.getProjectName()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectAcceptanceRectificationDTO.getCityNo())) {
            stringBuffer.append(projectAcceptanceRectificationDTO.getCityNo());
        }
        stringBuffer.append(DateUtils.getDateToString((Date)DateTime.now(), (String)"yyyyMMdd"));
        Integer count = ((ProjectAcceptanceRectificationMapper)this.baseMapper).selectCountInToday();
        stringBuffer.append(String.format("%04d", count + 1));
        return stringBuffer.toString();
    }
}

