/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.construction.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.construction.ProjectConstructionLogsDTO;
import com.ruoyi.entity.construction.ProjectConstructionLogsEntity;
import com.ruoyi.enums.ApprovalStatusEnum;
import com.ruoyi.mapper.construction.ProjectConstructionLogsMapper;
import com.ruoyi.query.construction.ProjectConstructionLogsQuery;
import com.ruoyi.service.construction.ProjectConstructionLogsService;
import com.ruoyi.service.construction.impl.ProjectConstructionLogsServiceImpl;
import com.ruoyi.service.workFlow.JsonRootDTO;
import com.ruoyi.service.workFlow.ProcessEnum;
import com.ruoyi.service.workFlow.SystemService;
import com.ruoyi.service.workFlow.WorkFlowCallBackVO;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.ChineseToPinyinUtils;
import com.ruoyi.util.DateUtils;
import com.ruoyi.util.DozerUtils;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.UserUtils;
import com.ruoyi.vo.construction.ProjectConstructionLogsDetailsVO;
import com.ruoyi.vo.construction.ProjectConstructionLogsExportVO;
import com.ruoyi.vo.construction.ProjectConstructionLogsPageVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ProjectConstructionLogsServiceImpl
extends ServiceImpl<ProjectConstructionLogsMapper, ProjectConstructionLogsEntity>
implements ProjectConstructionLogsService {
    @Resource
    private SystemService systemService;
    @Resource
    private WorkFlowService workFlowService;

    public PageResultVo<ProjectConstructionLogsPageVO> getPage(ProjectConstructionLogsQuery projectConstructionLogsQuery) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(projectConstructionLogsQuery);
        Page page = (Page)this.page((IPage)new Page((long)projectConstructionLogsQuery.getPageNum(), (long)projectConstructionLogsQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo contractDTOPageResultVo = new PageResultVo();
        List contractDTOList = DozerUtils.mapList((Collection)resultVo.getData(), ProjectConstructionLogsPageVO.class);
        if (ObjectUtil.isNotEmpty((Object)contractDTOList)) {
            contractDTOList.forEach(f -> {
                if (StringUtils.isNotBlank((CharSequence)f.getProjectType())) {
                    if ("gy".equals(f.getProjectType())) {
                        f.setProjectType("\u516c\u5bd3");
                    } else {
                        f.setProjectType("\u5546\u5199");
                    }
                }
            });
        }
        contractDTOPageResultVo.setData(contractDTOList);
        contractDTOPageResultVo.setPageSize(resultVo.getPageSize());
        contractDTOPageResultVo.setPageNum(resultVo.getPageNum());
        contractDTOPageResultVo.setTotal(resultVo.getTotal());
        contractDTOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return contractDTOPageResultVo;
    }

    private LambdaQueryWrapper getWrapperProject(ProjectConstructionLogsQuery projectConstructionLogsQuery) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(ObjectUtil.isNotEmpty((Object)projectConstructionLogsQuery.getProjectNumber()), ProjectConstructionLogsEntity::getProjectNumber, (Object)projectConstructionLogsQuery.getProjectNumber())).like(ObjectUtil.isNotEmpty((Object)projectConstructionLogsQuery.getProjectName()), ProjectConstructionLogsEntity::getProjectName, (Object)projectConstructionLogsQuery.getProjectName())).like(ObjectUtil.isNotEmpty((Object)projectConstructionLogsQuery.getProjectType()), ProjectConstructionLogsEntity::getProjectType, (Object)projectConstructionLogsQuery.getProjectType())).like(ObjectUtil.isNotEmpty((Object)projectConstructionLogsQuery.getIsAcceptance()), ProjectConstructionLogsEntity::getIsAcceptance, (Object)projectConstructionLogsQuery.getIsAcceptance())).like(ObjectUtil.isNotEmpty((Object)projectConstructionLogsQuery.getIsCoordinate()), ProjectConstructionLogsEntity::getIsCoordinate, (Object)projectConstructionLogsQuery.getIsCoordinate())).like(ObjectUtil.isNotEmpty((Object)projectConstructionLogsQuery.getCreateName()), ProjectConstructionLogsEntity::getCreateName, (Object)projectConstructionLogsQuery.getCreateName())).ge(ObjectUtil.isNotEmpty((Object)projectConstructionLogsQuery.getStartTime()), ProjectConstructionLogsEntity::getCreateTime, (Object)(projectConstructionLogsQuery.getStartTime() + " 00:0:00"))).le(ObjectUtil.isNotEmpty((Object)projectConstructionLogsQuery.getEndTime()), ProjectConstructionLogsEntity::getCreateTime, (Object)(projectConstructionLogsQuery.getEndTime() + " 23:59:59"))).orderByDesc(ProjectConstructionLogsEntity::getCreateTime);
        return wrapper;
    }

    public List<ProjectConstructionLogsExportVO> getList(ProjectConstructionLogsQuery projectConstructionLogsQuery) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(projectConstructionLogsQuery);
        List contractEntityList = this.list((Wrapper)wrapper);
        List projectConstructionLogsExportVOS = DozerUtils.mapList((Collection)contractEntityList, ProjectConstructionLogsExportVO.class);
        if (ObjectUtil.isNotEmpty((Object)projectConstructionLogsExportVOS)) {
            for (int i = 0; i < projectConstructionLogsExportVOS.size(); ++i) {
                ((ProjectConstructionLogsExportVO)projectConstructionLogsExportVOS.get(i)).setNumber(Integer.valueOf(i + 1));
                if (!StringUtils.isNotBlank((CharSequence)((ProjectConstructionLogsExportVO)projectConstructionLogsExportVOS.get(i)).getProjectType())) continue;
                if ("gy".equals(((ProjectConstructionLogsExportVO)projectConstructionLogsExportVOS.get(i)).getProjectType())) {
                    ((ProjectConstructionLogsExportVO)projectConstructionLogsExportVOS.get(i)).setProjectType("\u516c\u5bd3");
                    continue;
                }
                ((ProjectConstructionLogsExportVO)projectConstructionLogsExportVOS.get(i)).setProjectType("\u5546\u5199");
            }
        }
        return projectConstructionLogsExportVOS;
    }

    public ProjectConstructionLogsDetailsVO getDetails(Long id) {
        ProjectConstructionLogsEntity logsEntity = (ProjectConstructionLogsEntity)this.getById((Serializable)id);
        ProjectConstructionLogsDetailsVO detailsVO = (ProjectConstructionLogsDetailsVO)DozerUtils.transfor((Object)logsEntity, ProjectConstructionLogsDetailsVO.class);
        return detailsVO;
    }

    public Boolean create(ProjectConstructionLogsDTO projectConstructionLogsDTO) throws Exception {
        List receiverIds;
        ProjectConstructionLogsEntity logsEntity = (ProjectConstructionLogsEntity)DozerUtils.transfor((Object)projectConstructionLogsDTO, ProjectConstructionLogsEntity.class);
        logsEntity.setId(null);
        logsEntity.setProjectNumber(this.getNumber(projectConstructionLogsDTO));
        LoginUser loginUser = UserUtils.getLoginUser();
        logsEntity.setCreateName(loginUser.getUsername());
        logsEntity.setCreateId(loginUser.getUserid());
        logsEntity.setCreateTime(new Date());
        this.save((Object)logsEntity);
        if (StringUtils.isNotBlank((CharSequence)projectConstructionLogsDTO.getIsAcceptance()) && "\u662f".equals(projectConstructionLogsDTO.getIsAcceptance()) && ObjectUtil.isNotEmpty((Object)(receiverIds = this.systemService.getUserIdsByRoleId(Integer.valueOf(113))))) {
            JsonRootDTO jsonRootDTO = new JsonRootDTO();
            jsonRootDTO.setName(logsEntity.getTopicName());
            jsonRootDTO.setProjectName(logsEntity.getProjectName());
            jsonRootDTO.setBusinessKey(logsEntity.getId().toString());
            jsonRootDTO.setSenderId(loginUser.getUserid().toString());
            jsonRootDTO.setSenderName(loginUser.getUsername());
            jsonRootDTO.setReceiverIds(receiverIds);
            JSONObject jsonObject1 = this.workFlowService.pushUndoTask(ProcessEnum.log, jsonRootDTO, new Object[]{logsEntity.getId().toString()});
            System.out.println(jsonObject1.toJSONString());
        }
        return this.updateById((Object)logsEntity);
    }

    public Boolean update(ProjectConstructionLogsDTO projectConstructionLogsDTO) throws Exception {
        ProjectConstructionLogsEntity logsEntity = (ProjectConstructionLogsEntity)DozerUtils.transfor((Object)projectConstructionLogsDTO, ProjectConstructionLogsEntity.class);
        LoginUser loginUser = UserUtils.getLoginUser();
        logsEntity.setUpdateName(loginUser.getUsername());
        logsEntity.setUpdateId(loginUser.getUserid());
        logsEntity.setUpdateTime(new Date());
        return this.updateById((Object)logsEntity);
    }

    public Boolean delete(Long id) {
        return this.removeById((Serializable)id);
    }

    public void callBack(WorkFlowCallBackVO callBackVO) {
        String event = callBackVO.getEvent();
        ProjectConstructionLogsEntity logsEntity = new ProjectConstructionLogsEntity();
        logsEntity.setId(callBackVO.getBody().getBusinessKey());
        switch (1.$SwitchMap$com$ruoyi$service$workFlow$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                logsEntity.setApprovalStatus(ApprovalStatusEnum.THREE.getCode());
                this.updateById((Object)logsEntity);
            }
        }
    }

    public String getNumber(ProjectConstructionLogsDTO projectConstructionLogsDTO) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SGRZ");
        if (StringUtils.isNotBlank((CharSequence)projectConstructionLogsDTO.getBelongingBrand())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterUpper((String)projectConstructionLogsDTO.getBelongingBrand()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectConstructionLogsDTO.getChildBelongingBrand())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterLower((String)projectConstructionLogsDTO.getChildBelongingBrand()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectConstructionLogsDTO.getProjectName())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterUpper((String)projectConstructionLogsDTO.getProjectName()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectConstructionLogsDTO.getCityNo())) {
            stringBuffer.append(projectConstructionLogsDTO.getCityNo());
        }
        stringBuffer.append(DateUtils.getDateToString((Date)DateTime.now(), (String)"yyyyMMdd"));
        Integer count = ((ProjectConstructionLogsMapper)this.baseMapper).selectCountInToday();
        stringBuffer.append(String.format("%04d", count + 1));
        return stringBuffer.toString();
    }
}

