/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.construction.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.construction.ProjectPlanDetailsDTO;
import com.ruoyi.entity.construction.ProjectPlanEntity;
import com.ruoyi.entity.construction.ProjectPlanStageEntity;
import com.ruoyi.enums.ApprovalStatusEnum;
import com.ruoyi.mapper.construction.ProjectPlanMapper;
import com.ruoyi.query.construction.ProjectPlanQuery;
import com.ruoyi.service.construction.ProjectPlanService;
import com.ruoyi.service.construction.ProjectPlanStageService;
import com.ruoyi.service.construction.impl.ProjectPlanServiceImpl;
import com.ruoyi.service.workFlow.JsonRootDTO;
import com.ruoyi.service.workFlow.ProcessDTO;
import com.ruoyi.service.workFlow.ProcessEnum;
import com.ruoyi.service.workFlow.SystemService;
import com.ruoyi.service.workFlow.WorkFlowCallBackVO;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.ChineseToPinyinUtils;
import com.ruoyi.util.DateUtils;
import com.ruoyi.util.DozerUtils;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.UserUtils;
import com.ruoyi.vo.construction.ProjectPlanDetailsVO;
import com.ruoyi.vo.construction.ProjectPlanExportVO;
import com.ruoyi.vo.construction.ProjectPlanPageVO;
import com.ruoyi.vo.construction.ProjectPlanStageVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectPlanServiceImpl
extends ServiceImpl<ProjectPlanMapper, ProjectPlanEntity>
implements ProjectPlanService {
    @Resource
    private ProjectPlanStageService projectPlanStageService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private SystemService systemService;

    public PageResultVo<ProjectPlanPageVO> getPage(ProjectPlanQuery projectPlanQuery) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(projectPlanQuery);
        Page page = (Page)this.page((IPage)new Page((long)projectPlanQuery.getPageNum(), (long)projectPlanQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo contractDTOPageResultVo = new PageResultVo();
        List contractDTOList = DozerUtils.mapList((Collection)resultVo.getData(), ProjectPlanPageVO.class);
        if (ObjectUtils.isNotEmpty((Object)contractDTOList)) {
            contractDTOList.stream().forEach(f -> {
                if (StringUtils.isNotBlank((CharSequence)f.getOtherEngineersName())) {
                    List name = JSON.parseArray((String)f.getOtherEngineersName(), String.class);
                    String names = name.stream().collect(Collectors.joining(","));
                    f.setOtherEngineersName(names);
                }
            });
        }
        contractDTOPageResultVo.setData(contractDTOList);
        contractDTOPageResultVo.setPageSize(resultVo.getPageSize());
        contractDTOPageResultVo.setPageNum(resultVo.getPageNum());
        contractDTOPageResultVo.setTotal(resultVo.getTotal());
        contractDTOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return contractDTOPageResultVo;
    }

    private LambdaQueryWrapper getWrapperProject(ProjectPlanQuery projectPlanQuery) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(ObjectUtil.isNotEmpty((Object)projectPlanQuery.getPlanNumber()), ProjectPlanEntity::getPlanNumber, (Object)projectPlanQuery.getPlanNumber())).like(ObjectUtil.isNotEmpty((Object)projectPlanQuery.getProjectName()), ProjectPlanEntity::getProjectName, (Object)projectPlanQuery.getProjectName())).like(ObjectUtil.isNotEmpty((Object)projectPlanQuery.getBelongingBrand()), ProjectPlanEntity::getBelongingBrand, (Object)projectPlanQuery.getBelongingBrand())).like(ObjectUtil.isNotEmpty((Object)projectPlanQuery.getCitys()), ProjectPlanEntity::getCitys, (Object)projectPlanQuery.getCitys())).like(ObjectUtil.isNotEmpty((Object)projectPlanQuery.getProjectLeaderName()), ProjectPlanEntity::getProjectLeaderName, (Object)projectPlanQuery.getProjectLeaderName())).like(ObjectUtil.isNotEmpty((Object)projectPlanQuery.getOtherEngineersName()), ProjectPlanEntity::getOtherEngineersName, (Object)projectPlanQuery.getOtherEngineersName())).ge(ObjectUtil.isNotEmpty((Object)projectPlanQuery.getPlannedStartTime()), ProjectPlanEntity::getPlannedEntry, (Object)(projectPlanQuery.getPlannedStartTime() + " 00:0:00"))).le(ObjectUtil.isNotEmpty((Object)projectPlanQuery.getPlannedEndTime()), ProjectPlanEntity::getPlannedEntry, (Object)(projectPlanQuery.getPlannedEndTime() + " 23:59:59"))).ge(ObjectUtil.isNotEmpty((Object)projectPlanQuery.getCompletionStartTime()), ProjectPlanEntity::getPlannedCompletion, (Object)(projectPlanQuery.getCompletionStartTime() + " 00:0:00"))).le(ObjectUtil.isNotEmpty((Object)projectPlanQuery.getCompletionEndTime()), ProjectPlanEntity::getPlannedCompletion, (Object)(projectPlanQuery.getCompletionEndTime() + " 23:59:59"))).orderByDesc(ProjectPlanEntity::getCreateTime);
        return wrapper;
    }

    public List<ProjectPlanExportVO> getList(ProjectPlanQuery projectPlanQuery) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(projectPlanQuery);
        List contractEntityList = this.list((Wrapper)wrapper);
        List projectPlanExportVOS = DozerUtils.mapList((Collection)contractEntityList, ProjectPlanExportVO.class);
        if (ObjectUtils.isNotEmpty((Object)projectPlanExportVOS)) {
            for (int i = 0; i < projectPlanExportVOS.size(); ++i) {
                ((ProjectPlanExportVO)projectPlanExportVOS.get(i)).setNumber(Integer.valueOf(i + 1));
                if (!StringUtils.isNotBlank((CharSequence)((ProjectPlanExportVO)projectPlanExportVOS.get(i)).getProjectLeader())) continue;
                List name = JSON.parseArray((String)((ProjectPlanExportVO)projectPlanExportVOS.get(i)).getProjectLeader(), String.class);
                String names = name.stream().collect(Collectors.joining(","));
                ((ProjectPlanExportVO)projectPlanExportVOS.get(i)).setProjectLeader(names);
            }
        }
        return projectPlanExportVOS;
    }

    public ProjectPlanDetailsVO getDetails(Long id) {
        ProjectPlanEntity projectPlanEntity = (ProjectPlanEntity)this.getById((Serializable)id);
        ProjectPlanDetailsVO detailsVO = (ProjectPlanDetailsVO)DozerUtils.transfor((Object)projectPlanEntity, ProjectPlanDetailsVO.class);
        List list = ((LambdaQueryChainWrapper)this.projectPlanStageService.lambdaQuery().eq(ProjectPlanStageEntity::getProjectPlanId, (Object)id)).list();
        List planStageVOS = DozerUtils.mapList((Collection)list, ProjectPlanStageVO.class);
        detailsVO.setPlanStageVOS(planStageVOS);
        return detailsVO;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean create(ProjectPlanDetailsDTO projectPlanDetailsDTO) throws Exception {
        ProjectPlanEntity projectPlanEntity = (ProjectPlanEntity)DozerUtils.transfor((Object)projectPlanDetailsDTO, ProjectPlanEntity.class);
        projectPlanEntity.setId(null);
        LoginUser loginUser = UserUtils.getLoginUser();
        projectPlanEntity.setPlanNumber(this.getNumber(projectPlanDetailsDTO));
        projectPlanEntity.setCreateName(loginUser.getUsername());
        projectPlanEntity.setCreateId(loginUser.getUserid());
        projectPlanEntity.setCreateTime(new Date());
        projectPlanEntity.setApprovalStatus(ApprovalStatusEnum.TWO.getCode());
        this.save((Object)projectPlanEntity);
        List planStageVOS = projectPlanDetailsDTO.getPlanStageVOS();
        if (ObjectUtils.isNotEmpty((Object)planStageVOS)) {
            List projectPlanStageEntities = DozerUtils.mapList((Collection)planStageVOS, ProjectPlanStageEntity.class);
            for (ProjectPlanStageEntity projectPlanStageEntity : projectPlanStageEntities) {
                projectPlanStageEntity.setId(null);
                projectPlanStageEntity.setCreateName(loginUser.getUsername());
                projectPlanStageEntity.setCreateId(loginUser.getUserid());
                projectPlanStageEntity.setCreateTime(new Date());
                projectPlanStageEntity.setProjectPlanId(projectPlanEntity.getId());
                this.projectPlanStageService.save((Object)projectPlanStageEntity);
            }
        }
        ProcessDTO processDTO = new ProcessDTO();
        processDTO.setProcessInstanceName(projectPlanEntity.getTopicName());
        processDTO.setProjectName(projectPlanEntity.getProjectName());
        processDTO.setBusinessKey(projectPlanEntity.getId().toString());
        String processId = this.workFlowService.startProcess(ProcessEnum.plan, processDTO, new Object[]{projectPlanEntity.getId().toString()});
        if (ObjectUtils.isNotEmpty((Object)processId)) {
            projectPlanEntity.setProcessInstId(processId);
            this.updateById((Object)projectPlanEntity);
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean update(ProjectPlanDetailsDTO projectPlanDetailsDTO) {
        ProjectPlanEntity projectPlanEntity = (ProjectPlanEntity)DozerUtils.transfor((Object)projectPlanDetailsDTO, ProjectPlanEntity.class);
        LoginUser loginUser = UserUtils.getLoginUser();
        projectPlanEntity.setUpdateName(loginUser.getUsername());
        projectPlanEntity.setUpdateId(loginUser.getUserid());
        projectPlanEntity.setUpdateTime(new Date());
        this.updateById((Object)projectPlanEntity);
        this.projectPlanStageService.remove((Wrapper)new LambdaQueryWrapper().eq(ProjectPlanStageEntity::getProjectPlanId, (Object)projectPlanEntity.getId()));
        List planStageVOS = projectPlanDetailsDTO.getPlanStageVOS();
        if (ObjectUtils.isNotEmpty((Object)planStageVOS)) {
            List projectPlanStageEntities = DozerUtils.mapList((Collection)planStageVOS, ProjectPlanStageEntity.class);
            for (ProjectPlanStageEntity projectPlanStageEntity : projectPlanStageEntities) {
                projectPlanStageEntity.setId(null);
                projectPlanStageEntity.setCreateName(loginUser.getUsername());
                projectPlanStageEntity.setCreateId(loginUser.getUserid());
                projectPlanStageEntity.setCreateTime(new Date());
                projectPlanStageEntity.setProjectPlanId(projectPlanEntity.getId());
                this.projectPlanStageService.save((Object)projectPlanStageEntity);
            }
        }
        return true;
    }

    public Boolean delete(Long id) {
        return this.removeById((Serializable)id);
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean callBackUpdate(ProjectPlanDetailsDTO projectPlanDetailsDTO) throws Exception {
        if (ObjectUtils.isEmpty((Object)projectPlanDetailsDTO) || StringUtils.isEmpty((CharSequence)projectPlanDetailsDTO.getTaskKey())) {
            return null;
        }
        String jiedian = projectPlanDetailsDTO.getTaskKey();
        LoginUser loginUser = UserUtils.getLoginUser();
        if (!"Activity_0fkpom0".equals(jiedian) && !"Activity_1dui0n6".equals(jiedian) && "Activity_0r4aaw6".equals(jiedian)) {
            List userIds = this.systemService.getUserIdsByRoleId(Integer.valueOf(119));
            String projectLeader = projectPlanDetailsDTO.getProjectLeader();
            String otherEngineers = projectPlanDetailsDTO.getOtherEngineers();
            List other = JSON.parseArray((String)otherEngineers, String.class);
            userIds.add(projectLeader);
            userIds.addAll(other);
            if (ObjectUtil.isNotEmpty((Object)userIds)) {
                userIds = userIds.stream().distinct().collect(Collectors.toList());
                JsonRootDTO jsonRootDTO = new JsonRootDTO();
                jsonRootDTO.setName(projectPlanDetailsDTO.getTopicName());
                jsonRootDTO.setProjectName(projectPlanDetailsDTO.getProjectName());
                jsonRootDTO.setBusinessKey(projectPlanDetailsDTO.getId().toString());
                jsonRootDTO.setSenderId(loginUser.getUserid().toString());
                jsonRootDTO.setSenderName(loginUser.getUsername());
                jsonRootDTO.setReceiverIds(userIds);
                JSONObject jsonObject1 = this.workFlowService.pushUndoTask(ProcessEnum.plan, jsonRootDTO, new Object[]{projectPlanDetailsDTO.getId().toString()});
                System.out.println(jsonObject1.toJSONString());
            }
        }
        return true;
    }

    public void callBack(WorkFlowCallBackVO callBackVO) {
        String event = callBackVO.getEvent();
        ProjectPlanEntity projectPlanEntity = new ProjectPlanEntity();
        projectPlanEntity.setId(callBackVO.getBody().getBusinessKey());
        switch (1.$SwitchMap$com$ruoyi$service$workFlow$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                WorkFlowCallBackVO.ProcessVariables processVariables = callBackVO.getBody().getProcessVariables();
                String fromUrl = processVariables.getFromUrl();
                if (!StringUtils.isNotBlank((CharSequence)fromUrl)) break;
                String[] taskKey = fromUrl.split("taskKey=");
                String jiedian = taskKey[1].split("&")[0];
                if ("Activity_0fkpom0".equals(jiedian)) {
                    projectPlanEntity.setApprovalStatus(ApprovalStatusEnum.TWO.getCode());
                    this.updateById((Object)projectPlanEntity);
                    break;
                }
                if ("Activity_1dui0n6".equals(jiedian)) {
                    WorkFlowCallBackVO.TaskVariables taskVariables = callBackVO.getBody().getTaskVariables();
                    if (2 == taskVariables.getApproveStatus()) {
                        projectPlanEntity.setApprovalStatus(ApprovalStatusEnum.FOUR.getCode());
                        this.updateById((Object)projectPlanEntity);
                        break;
                    }
                    if (1 != taskVariables.getApproveStatus()) break;
                    projectPlanEntity.setApprovalStatus(ApprovalStatusEnum.TWO.getCode());
                    this.updateById((Object)projectPlanEntity);
                    break;
                }
                if (!"Activity_0r4aaw6".equals(jiedian)) break;
                WorkFlowCallBackVO.TaskVariables taskVariables = callBackVO.getBody().getTaskVariables();
                if (2 == taskVariables.getApproveStatus()) {
                    projectPlanEntity.setApprovalStatus(ApprovalStatusEnum.FOUR.getCode());
                    this.updateById((Object)projectPlanEntity);
                    break;
                }
                if (1 != taskVariables.getApproveStatus()) break;
                projectPlanEntity.setApprovalStatus(ApprovalStatusEnum.TWO.getCode());
                this.updateById((Object)projectPlanEntity);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                projectPlanEntity.setApprovalStatus(ApprovalStatusEnum.THREE.getCode());
                this.updateById((Object)projectPlanEntity);
            }
        }
    }

    public String getNumber(ProjectPlanDetailsDTO projectPlanDetailsDTO) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SGJH");
        if (StringUtils.isNotBlank((CharSequence)projectPlanDetailsDTO.getBelongingBrand())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterUpper((String)projectPlanDetailsDTO.getBelongingBrand()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectPlanDetailsDTO.getChildBelongingBrand())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterUpper((String)projectPlanDetailsDTO.getChildBelongingBrand()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectPlanDetailsDTO.getProjectName())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterUpper((String)projectPlanDetailsDTO.getProjectName()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectPlanDetailsDTO.getCityNo())) {
            stringBuffer.append(projectPlanDetailsDTO.getCityNo());
        }
        stringBuffer.append(DateUtils.getDateToString((Date)DateTime.now(), (String)"yyyyMMdd"));
        Integer count = ((ProjectPlanMapper)this.baseMapper).selectCountInToday();
        stringBuffer.append(String.format("%04d", count + 1));
        return stringBuffer.toString();
    }
}

