/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.construction.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.construction.ProjectProgrammeDTO;
import com.ruoyi.entity.construction.ProjectProgrammeBroadbandEntity;
import com.ruoyi.entity.construction.ProjectProgrammeEntity;
import com.ruoyi.entity.construction.ProjectProgrammeEntitysEntity;
import com.ruoyi.enums.ApprovalStatusEnum;
import com.ruoyi.mapper.construction.ProjectProgrammeMapper;
import com.ruoyi.query.construction.ProjectProgrammeQuery;
import com.ruoyi.service.construction.ProjectProgrammeBroadbandService;
import com.ruoyi.service.construction.ProjectProgrammeEntitysService;
import com.ruoyi.service.construction.ProjectProgrammeService;
import com.ruoyi.service.construction.impl.ProjectProgrammeServiceImpl;
import com.ruoyi.service.workFlow.ProcessDTO;
import com.ruoyi.service.workFlow.ProcessEnum;
import com.ruoyi.service.workFlow.WorkFlowCallBackVO;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.ChineseToPinyinUtils;
import com.ruoyi.util.DateUtils;
import com.ruoyi.util.DozerUtils;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.UserUtils;
import com.ruoyi.vo.construction.ProjectProgrammeBroadbandVO;
import com.ruoyi.vo.construction.ProjectProgrammeDetailsVO;
import com.ruoyi.vo.construction.ProjectProgrammeEntitysVO;
import com.ruoyi.vo.construction.ProjectProgrammeExportVO;
import com.ruoyi.vo.construction.ProjectProgrammePageVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectProgrammeServiceImpl
extends ServiceImpl<ProjectProgrammeMapper, ProjectProgrammeEntity>
implements ProjectProgrammeService {
    @Resource
    private ProjectProgrammeEntitysService projectProgrammeEntitysService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private ProjectProgrammeBroadbandService projectProgrammeBroadbandService;

    public PageResultVo<ProjectProgrammePageVO> getProjectProgrammeListPage(ProjectProgrammeQuery projectProgrammeQuery) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(projectProgrammeQuery);
        Page page = (Page)this.page((IPage)new Page((long)projectProgrammeQuery.getPageNum(), (long)projectProgrammeQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo contractDTOPageResultVo = new PageResultVo();
        List contractDTOList = DozerUtils.mapList((Collection)resultVo.getData(), ProjectProgrammePageVO.class);
        contractDTOPageResultVo.setData(contractDTOList);
        contractDTOPageResultVo.setPageSize(resultVo.getPageSize());
        contractDTOPageResultVo.setPageNum(resultVo.getPageNum());
        contractDTOPageResultVo.setTotal(resultVo.getTotal());
        contractDTOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return contractDTOPageResultVo;
    }

    private LambdaQueryWrapper getWrapperProject(ProjectProgrammeQuery projectProgrammeQuery) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(ObjectUtil.isNotEmpty((Object)projectProgrammeQuery.getProgrammeNumber()), ProjectProgrammeEntity::getProgrammeNumber, (Object)projectProgrammeQuery.getProgrammeNumber())).like(ObjectUtil.isNotEmpty((Object)projectProgrammeQuery.getTopicName()), ProjectProgrammeEntity::getTopicName, (Object)projectProgrammeQuery.getTopicName())).like(ObjectUtil.isNotEmpty((Object)projectProgrammeQuery.getProjectName()), ProjectProgrammeEntity::getProjectName, (Object)projectProgrammeQuery.getProjectName())).ge(ObjectUtil.isNotEmpty((Object)projectProgrammeQuery.getStartTime()), ProjectProgrammeEntity::getCreateTime, (Object)(projectProgrammeQuery.getStartTime() + " 00:0:00"))).le(ObjectUtil.isNotEmpty((Object)projectProgrammeQuery.getEndTime()), ProjectProgrammeEntity::getCreateTime, (Object)(projectProgrammeQuery.getEndTime() + " 23:59:59"))).orderByDesc(ProjectProgrammeEntity::getCreateTime);
        return wrapper;
    }

    public List<ProjectProgrammeExportVO> getProjectProgrammeList(ProjectProgrammeQuery projectProgrammeQuery) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(projectProgrammeQuery);
        List contractEntityList = this.list((Wrapper)wrapper);
        List projectProgrammeExportVOS = DozerUtils.mapList((Collection)contractEntityList, ProjectProgrammeExportVO.class);
        if (ObjectUtil.isNotEmpty((Object)projectProgrammeExportVOS)) {
            for (int i = 0; i < projectProgrammeExportVOS.size(); ++i) {
                ((ProjectProgrammeExportVO)projectProgrammeExportVOS.get(i)).setNumber(Integer.valueOf(i + 1));
            }
        }
        return projectProgrammeExportVOS;
    }

    public ProjectProgrammeDetailsVO getProjectProgrammeById(Long id) {
        ProjectProgrammeEntity projectProgrammeEntity = (ProjectProgrammeEntity)this.getById((Serializable)id);
        ProjectProgrammeDetailsVO detailsVO = (ProjectProgrammeDetailsVO)DozerUtils.transfor((Object)projectProgrammeEntity, ProjectProgrammeDetailsVO.class);
        List list = ((LambdaQueryChainWrapper)this.projectProgrammeEntitysService.lambdaQuery().eq(ProjectProgrammeEntitysEntity::getProjectProgrammeId, (Object)id)).list();
        List entitysVOList = DozerUtils.mapList((Collection)list, ProjectProgrammeEntitysVO.class);
        detailsVO.setEntitysVOList(entitysVOList);
        List broadbandEntityList = ((LambdaQueryChainWrapper)this.projectProgrammeBroadbandService.lambdaQuery().eq(ProjectProgrammeBroadbandEntity::getProjectProgrammeId, (Object)id)).list();
        List broadbandVOS = DozerUtils.mapList((Collection)broadbandEntityList, ProjectProgrammeBroadbandVO.class);
        detailsVO.setBroadbandVOS(broadbandVOS);
        return detailsVO;
    }

    public List<ProjectProgrammeEntitysVO> getProjectProgrammeEntitysVO(Long id) {
        ProjectProgrammeEntity projectProgrammeEntity = (ProjectProgrammeEntity)this.getById((Serializable)id);
        ProjectProgrammeDetailsVO detailsVO = (ProjectProgrammeDetailsVO)DozerUtils.transfor((Object)projectProgrammeEntity, ProjectProgrammeDetailsVO.class);
        List list = ((LambdaQueryChainWrapper)this.projectProgrammeEntitysService.lambdaQuery().eq(ProjectProgrammeEntitysEntity::getProjectProgrammeId, (Object)id)).list();
        List entitysVOList = DozerUtils.mapList((Collection)list, ProjectProgrammeEntitysVO.class);
        return entitysVOList;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean createProjectProgramme(ProjectProgrammeDTO projectProgrammeDTO) throws Exception {
        List broadbandVOS;
        ProjectProgrammeEntity projectProgrammeEntity = (ProjectProgrammeEntity)DozerUtils.transfor((Object)projectProgrammeDTO, ProjectProgrammeEntity.class);
        projectProgrammeEntity.setId(null);
        LoginUser loginUser = UserUtils.getLoginUser();
        projectProgrammeEntity.setProgrammeNumber(this.getNumber(projectProgrammeDTO));
        projectProgrammeEntity.setCreateName(loginUser.getUsername());
        projectProgrammeEntity.setCreateId(loginUser.getUserid());
        projectProgrammeEntity.setCreateTime(new Date());
        projectProgrammeEntity.setApprovalStatus(ApprovalStatusEnum.TWO.getCode());
        this.save((Object)projectProgrammeEntity);
        List entitysVOList = projectProgrammeDTO.getEntitysVOList();
        if (ObjectUtils.isNotEmpty((Object)entitysVOList)) {
            List projectProgrammeEntitysEntities = DozerUtils.mapList((Collection)entitysVOList, ProjectProgrammeEntitysEntity.class);
            for (ProjectProgrammeEntitysEntity projectProgrammeEntitysEntity : projectProgrammeEntitysEntities) {
                projectProgrammeEntitysEntity.setId(null);
                projectProgrammeEntitysEntity.setCreateName(loginUser.getUsername());
                projectProgrammeEntitysEntity.setCreateId(loginUser.getUserid());
                projectProgrammeEntitysEntity.setCreateTime(new Date());
                projectProgrammeEntitysEntity.setProjectProgrammeId(projectProgrammeEntity.getId());
                this.projectProgrammeEntitysService.save((Object)projectProgrammeEntitysEntity);
            }
        }
        if (ObjectUtils.isNotEmpty((Object)(broadbandVOS = projectProgrammeDTO.getBroadbandVOS()))) {
            List projectProgrammeBroadbandEntities = DozerUtils.mapList((Collection)broadbandVOS, ProjectProgrammeBroadbandEntity.class);
            for (ProjectProgrammeBroadbandEntity projectProgrammeBroadbandEntity : projectProgrammeBroadbandEntities) {
                projectProgrammeBroadbandEntity.setId(null);
                projectProgrammeBroadbandEntity.setCreateName(loginUser.getUsername());
                projectProgrammeBroadbandEntity.setCreateId(loginUser.getUserid());
                projectProgrammeBroadbandEntity.setCreateTime(new Date());
                projectProgrammeBroadbandEntity.setProjectProgrammeId(projectProgrammeEntity.getId());
                this.projectProgrammeBroadbandService.save((Object)projectProgrammeBroadbandEntity);
            }
        }
        ProcessDTO processDTO = new ProcessDTO();
        processDTO.setProcessInstanceName(projectProgrammeEntity.getTopicName());
        processDTO.setProjectName(projectProgrammeEntity.getProjectName());
        processDTO.setBusinessKey(projectProgrammeEntity.getId().toString());
        String processId = this.workFlowService.startProcess(ProcessEnum.programme, processDTO, new Object[]{projectProgrammeEntity.getId().toString()});
        if (ObjectUtils.isNotEmpty((Object)processId)) {
            projectProgrammeEntity.setProcessInstId(processId);
            this.updateById((Object)projectProgrammeEntity);
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean updateProjectProgramme(ProjectProgrammeDTO projectProgrammeDTO) {
        ProjectProgrammeEntity projectProgrammeEntity = (ProjectProgrammeEntity)DozerUtils.transfor((Object)projectProgrammeDTO, ProjectProgrammeEntity.class);
        LoginUser loginUser = UserUtils.getLoginUser();
        projectProgrammeEntity.setUpdateName(loginUser.getUsername());
        projectProgrammeEntity.setUpdateId(loginUser.getUserid());
        projectProgrammeEntity.setUpdateTime(new Date());
        this.updateById((Object)projectProgrammeEntity);
        this.projectProgrammeEntitysService.remove((Wrapper)new LambdaQueryWrapper().eq(ProjectProgrammeEntitysEntity::getProjectProgrammeId, (Object)projectProgrammeEntity.getId()));
        List entitysVOList = projectProgrammeDTO.getEntitysVOList();
        if (ObjectUtils.isNotEmpty((Object)entitysVOList)) {
            List projectProgrammeEntitysEntities = DozerUtils.mapList((Collection)entitysVOList, ProjectProgrammeEntitysEntity.class);
            for (ProjectProgrammeEntitysEntity projectProgrammeEntitysEntity : projectProgrammeEntitysEntities) {
                projectProgrammeEntitysEntity.setId(null);
                projectProgrammeEntitysEntity.setCreateName(loginUser.getUsername());
                projectProgrammeEntitysEntity.setCreateId(loginUser.getUserid());
                projectProgrammeEntitysEntity.setCreateTime(new Date());
                projectProgrammeEntitysEntity.setProjectProgrammeId(projectProgrammeEntity.getId());
                this.projectProgrammeEntitysService.save((Object)projectProgrammeEntitysEntity);
            }
        }
        this.projectProgrammeBroadbandService.remove((Wrapper)new LambdaQueryWrapper().eq(ProjectProgrammeBroadbandEntity::getProjectProgrammeId, (Object)projectProgrammeEntity.getId()));
        List broadbandVOS = projectProgrammeDTO.getBroadbandVOS();
        if (ObjectUtils.isNotEmpty((Object)broadbandVOS)) {
            List projectProgrammeBroadbandEntities = DozerUtils.mapList((Collection)broadbandVOS, ProjectProgrammeBroadbandEntity.class);
            for (ProjectProgrammeBroadbandEntity projectProgrammeBroadbandEntity : projectProgrammeBroadbandEntities) {
                projectProgrammeBroadbandEntity.setId(null);
                projectProgrammeBroadbandEntity.setCreateName(loginUser.getUsername());
                projectProgrammeBroadbandEntity.setCreateId(loginUser.getUserid());
                projectProgrammeBroadbandEntity.setCreateTime(new Date());
                projectProgrammeBroadbandEntity.setProjectProgrammeId(projectProgrammeEntity.getId());
                this.projectProgrammeBroadbandService.save((Object)projectProgrammeBroadbandEntity);
            }
        }
        return true;
    }

    public Boolean deleteProjectProgramme(Long id) {
        return this.removeById((Serializable)id);
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean callBackUpdate(ProjectProgrammeDTO projectProgrammeDTO) throws Exception {
        if (ObjectUtils.isEmpty((Object)projectProgrammeDTO) || StringUtils.isEmpty((CharSequence)projectProgrammeDTO.getTaskKey())) {
            return null;
        }
        String jiedian = projectProgrammeDTO.getTaskKey();
        LoginUser loginUser = UserUtils.getLoginUser();
        if ("Activity_0fkpom0".equals(jiedian) || "Activity_0r4aaw6".equals(jiedian)) {
            // empty if block
        }
        return true;
    }

    public void callBack(WorkFlowCallBackVO callBackVO) {
        String event = callBackVO.getEvent();
        ProjectProgrammeEntity projectProgrammeEntity = new ProjectProgrammeEntity();
        projectProgrammeEntity.setId(callBackVO.getBody().getBusinessKey());
        switch (1.$SwitchMap$com$ruoyi$service$workFlow$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                WorkFlowCallBackVO.ProcessVariables processVariables = callBackVO.getBody().getProcessVariables();
                String fromUrl = processVariables.getFromUrl();
                if (!StringUtils.isNotBlank((CharSequence)fromUrl)) break;
                String[] taskKey = fromUrl.split("taskKey=");
                String jiedian = taskKey[1].split("&")[0];
                if ("Activity_0fkpom0".equals(jiedian)) {
                    projectProgrammeEntity.setApprovalStatus(ApprovalStatusEnum.TWO.getCode());
                    this.updateById((Object)projectProgrammeEntity);
                    break;
                }
                if (!"Activity_0r4aaw6".equals(jiedian)) break;
                WorkFlowCallBackVO.TaskVariables taskVariables = callBackVO.getBody().getTaskVariables();
                if (2 == taskVariables.getApproveStatus()) {
                    projectProgrammeEntity.setApprovalStatus(ApprovalStatusEnum.FOUR.getCode());
                    this.updateById((Object)projectProgrammeEntity);
                    break;
                }
                if (1 != taskVariables.getApproveStatus()) break;
                projectProgrammeEntity.setApprovalStatus(ApprovalStatusEnum.TWO.getCode());
                this.updateById((Object)projectProgrammeEntity);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                projectProgrammeEntity.setApprovalStatus(ApprovalStatusEnum.THREE.getCode());
                this.updateById((Object)projectProgrammeEntity);
            }
        }
    }

    public String getNumber(ProjectProgrammeDTO projectProgrammeDTO) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JSFA");
        if (StringUtils.isNotBlank((CharSequence)projectProgrammeDTO.getBelongingBrand())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterUpper((String)projectProgrammeDTO.getBelongingBrand()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectProgrammeDTO.getChildBelongingBrand())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterLower((String)projectProgrammeDTO.getChildBelongingBrand()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectProgrammeDTO.getProjectName())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterUpper((String)projectProgrammeDTO.getProjectName()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectProgrammeDTO.getCityNo())) {
            stringBuffer.append(projectProgrammeDTO.getCityNo());
        }
        stringBuffer.append(DateUtils.getDateToString((Date)DateTime.now(), (String)"yyyyMMdd"));
        Integer count = ((ProjectProgrammeMapper)this.baseMapper).selectCountInToday();
        stringBuffer.append(String.format("%04d", count + 1));
        return stringBuffer.toString();
    }
}

