/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.construction.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.dto.construction.ProjectSurveyDTO;
import com.ruoyi.entity.construction.ProjectSurveyChildrenEntity;
import com.ruoyi.entity.construction.ProjectSurveyEntity;
import com.ruoyi.enums.ApprovalStatusEnum;
import com.ruoyi.mapper.construction.ProjectSurveyMapper;
import com.ruoyi.query.construction.ProjectSurveyQuery;
import com.ruoyi.service.construction.ProjectSurveyChildrenService;
import com.ruoyi.service.construction.ProjectSurveyService;
import com.ruoyi.service.construction.impl.ProjectSurveyServiceImpl;
import com.ruoyi.service.workFlow.ProcessDTO;
import com.ruoyi.service.workFlow.ProcessEnum;
import com.ruoyi.service.workFlow.WorkFlowCallBackVO;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.util.ChineseToPinyinUtils;
import com.ruoyi.util.DateUtils;
import com.ruoyi.util.DozerUtils;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.UserUtils;
import com.ruoyi.vo.construction.ProjectSurveyChildrenVO;
import com.ruoyi.vo.construction.ProjectSurveyDetailsVO;
import com.ruoyi.vo.construction.ProjectSurveyExportVO;
import com.ruoyi.vo.construction.ProjectSurveyPageVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProjectSurveyServiceImpl
extends ServiceImpl<ProjectSurveyMapper, ProjectSurveyEntity>
implements ProjectSurveyService {
    @Resource
    private ProjectSurveyChildrenService projectSurveyChildrenService;
    @Resource
    private WorkFlowService workFlowService;

    public PageResultVo<ProjectSurveyPageVO> getProjectSurveyListPage(ProjectSurveyQuery projectSurveyQuery) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(projectSurveyQuery);
        Page page = (Page)this.page((IPage)new Page((long)projectSurveyQuery.getPageNum(), (long)projectSurveyQuery.getPageSize()), (Wrapper)wrapper);
        PageResultVo resultVo = new PageResultVo(page);
        PageResultVo contractDTOPageResultVo = new PageResultVo();
        List contractDTOList = DozerUtils.mapList((Collection)resultVo.getData(), ProjectSurveyPageVO.class);
        contractDTOPageResultVo.setData(contractDTOList);
        contractDTOPageResultVo.setPageSize(resultVo.getPageSize());
        contractDTOPageResultVo.setPageNum(resultVo.getPageNum());
        contractDTOPageResultVo.setTotal(resultVo.getTotal());
        contractDTOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
        return contractDTOPageResultVo;
    }

    private LambdaQueryWrapper getWrapperProject(ProjectSurveyQuery projectSurveyQuery) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(ObjectUtil.isNotEmpty((Object)projectSurveyQuery.getSurveyNumber()), ProjectSurveyEntity::getSurveyNumber, (Object)projectSurveyQuery.getSurveyNumber())).like(ObjectUtil.isNotEmpty((Object)projectSurveyQuery.getTopicName()), ProjectSurveyEntity::getTopicName, (Object)projectSurveyQuery.getTopicName())).like(ObjectUtil.isNotEmpty((Object)projectSurveyQuery.getProjectName()), ProjectSurveyEntity::getProjectName, (Object)projectSurveyQuery.getProjectName())).like(ObjectUtil.isNotEmpty((Object)projectSurveyQuery.getConstructionType()), ProjectSurveyEntity::getConstructionType, (Object)projectSurveyQuery.getConstructionType())).ge(ObjectUtil.isNotEmpty((Object)projectSurveyQuery.getStartTime()), ProjectSurveyEntity::getCreateTime, (Object)(projectSurveyQuery.getStartTime() + " 00:0:00"))).le(ObjectUtil.isNotEmpty((Object)projectSurveyQuery.getEndTime()), ProjectSurveyEntity::getCreateTime, (Object)(projectSurveyQuery.getEndTime() + " 23:59:59"))).orderByDesc(ProjectSurveyEntity::getCreateTime);
        return wrapper;
    }

    public List<ProjectSurveyExportVO> getProjectSurveyList(ProjectSurveyQuery projectSurveyQuery) {
        LambdaQueryWrapper wrapper = this.getWrapperProject(projectSurveyQuery);
        List contractEntityList = this.list((Wrapper)wrapper);
        List projectSurveyExportVOS = DozerUtils.mapList((Collection)contractEntityList, ProjectSurveyExportVO.class);
        if (ObjectUtil.isNotEmpty((Object)projectSurveyExportVOS)) {
            for (int i = 0; i < projectSurveyExportVOS.size(); ++i) {
                ((ProjectSurveyExportVO)projectSurveyExportVOS.get(i)).setNumber(Integer.valueOf(i + 1));
            }
        }
        return projectSurveyExportVOS;
    }

    public ProjectSurveyDetailsVO getProjectSurveyDTOById(Long id) {
        ProjectSurveyEntity projectSurveyEntity = (ProjectSurveyEntity)this.getById((Serializable)id);
        ProjectSurveyDetailsVO detailsVO = (ProjectSurveyDetailsVO)DozerUtils.transfor((Object)projectSurveyEntity, ProjectSurveyDetailsVO.class);
        List list = ((LambdaQueryChainWrapper)this.projectSurveyChildrenService.lambdaQuery().eq(ProjectSurveyChildrenEntity::getProjectSurveyId, (Object)id)).list();
        List projectSurveyChildrenVOS = DozerUtils.mapList((Collection)list, ProjectSurveyChildrenVO.class);
        detailsVO.setChildrenVOS(projectSurveyChildrenVOS);
        return detailsVO;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean createProjectSurvey(ProjectSurveyDTO projectSurveyDTO) throws Exception {
        ProjectSurveyEntity projectSurveyEntity = (ProjectSurveyEntity)DozerUtils.transfor((Object)projectSurveyDTO, ProjectSurveyEntity.class);
        LoginUser loginUser = UserUtils.getLoginUser();
        projectSurveyEntity.setId(null);
        projectSurveyEntity.setTopicName(this.getTopicName(loginUser));
        projectSurveyEntity.setSurveyNumber(this.getNumber(projectSurveyDTO));
        projectSurveyEntity.setCreateName(loginUser.getUsername());
        projectSurveyEntity.setCreateId(loginUser.getUserid());
        projectSurveyEntity.setCreateTime(new Date());
        projectSurveyEntity.setApprovalStatus(ApprovalStatusEnum.TWO.getCode());
        this.save((Object)projectSurveyEntity);
        List childrenVOS = projectSurveyDTO.getChildrenVOS();
        if (ObjectUtils.isNotEmpty((Object)childrenVOS)) {
            List projectSurveyChildrenEntities = DozerUtils.mapList((Collection)childrenVOS, ProjectSurveyChildrenEntity.class);
            for (ProjectSurveyChildrenEntity projectSurveyChildrenEntity : projectSurveyChildrenEntities) {
                projectSurveyChildrenEntity.setId(null);
                projectSurveyChildrenEntity.setCreateName(loginUser.getUsername());
                projectSurveyChildrenEntity.setCreateId(loginUser.getUserid());
                projectSurveyChildrenEntity.setCreateTime(new Date());
                projectSurveyChildrenEntity.setProjectSurveyId(projectSurveyEntity.getId());
                this.projectSurveyChildrenService.save((Object)projectSurveyChildrenEntity);
            }
        }
        ProcessDTO processDTO = new ProcessDTO();
        processDTO.setProcessInstanceName(projectSurveyEntity.getTopicName());
        processDTO.setProjectName(projectSurveyEntity.getProjectName());
        processDTO.setBusinessKey(projectSurveyEntity.getId().toString());
        String processId = this.workFlowService.startProcess(ProcessEnum.survey, processDTO, new Object[]{projectSurveyEntity.getId().toString()});
        if (ObjectUtils.isNotEmpty((Object)processId)) {
            projectSurveyEntity.setProcessInstId(processId);
            this.updateById((Object)projectSurveyEntity);
        }
        return true;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean updateProjectSurvey(ProjectSurveyDTO projectSurveyDTO) {
        ProjectSurveyEntity projectSurveyEntity = (ProjectSurveyEntity)DozerUtils.transfor((Object)projectSurveyDTO, ProjectSurveyEntity.class);
        LoginUser loginUser = UserUtils.getLoginUser();
        projectSurveyEntity.setUpdateName(loginUser.getUsername());
        projectSurveyEntity.setUpdateId(loginUser.getUserid());
        projectSurveyEntity.setUpdateTime(new Date());
        this.updateById((Object)projectSurveyEntity);
        this.projectSurveyChildrenService.remove((Wrapper)new LambdaQueryWrapper().eq(ProjectSurveyChildrenEntity::getProjectSurveyId, (Object)projectSurveyEntity.getId()));
        List childrenVOS = projectSurveyDTO.getChildrenVOS();
        if (ObjectUtils.isNotEmpty((Object)childrenVOS)) {
            List projectSurveyChildrenEntities = DozerUtils.mapList((Collection)childrenVOS, ProjectSurveyChildrenEntity.class);
            for (ProjectSurveyChildrenEntity projectSurveyChildrenEntity : projectSurveyChildrenEntities) {
                projectSurveyChildrenEntity.setId(null);
                projectSurveyChildrenEntity.setCreateName(loginUser.getUsername());
                projectSurveyChildrenEntity.setCreateId(loginUser.getUserid());
                projectSurveyChildrenEntity.setCreateTime(new Date());
                projectSurveyChildrenEntity.setProjectSurveyId(projectSurveyEntity.getId());
                this.projectSurveyChildrenService.save((Object)projectSurveyChildrenEntity);
            }
        }
        return true;
    }

    public Boolean deleteProjectSurvey(Long id) {
        return this.removeById((Serializable)id);
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public Boolean callBackUpdate(ProjectSurveyDTO projectSurveyDTO) throws Exception {
        if (ObjectUtils.isEmpty((Object)projectSurveyDTO) || StringUtils.isEmpty((CharSequence)projectSurveyDTO.getTaskKey())) {
            return null;
        }
        String jiedian = projectSurveyDTO.getTaskKey();
        LoginUser loginUser = UserUtils.getLoginUser();
        if ("Activity_0fkpom0".equals(jiedian) || "Activity_0r4aaw6".equals(jiedian)) {
            // empty if block
        }
        return true;
    }

    public void callBack(WorkFlowCallBackVO callBackVO) {
        String event = callBackVO.getEvent();
        ProjectSurveyEntity projectSurveyEntity = new ProjectSurveyEntity();
        projectSurveyEntity.setId(callBackVO.getBody().getBusinessKey());
        switch (1.$SwitchMap$com$ruoyi$service$workFlow$WorkFlowCallBackVO$EventEnum[WorkFlowCallBackVO.EventEnum.of((String)event).ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                WorkFlowCallBackVO.ProcessVariables processVariables = callBackVO.getBody().getProcessVariables();
                String fromUrl = processVariables.getFromUrl();
                if (!StringUtils.isNotBlank((CharSequence)fromUrl)) break;
                String[] taskKey = fromUrl.split("taskKey=");
                String jiedian = taskKey[1].split("&")[0];
                if ("Activity_0fkpom0".equals(jiedian)) {
                    projectSurveyEntity.setApprovalStatus(ApprovalStatusEnum.TWO.getCode());
                    this.updateById((Object)projectSurveyEntity);
                    break;
                }
                if (!"Activity_0r4aaw6".equals(jiedian)) break;
                WorkFlowCallBackVO.TaskVariables taskVariables = callBackVO.getBody().getTaskVariables();
                if (2 == taskVariables.getApproveStatus()) {
                    projectSurveyEntity.setApprovalStatus(ApprovalStatusEnum.FOUR.getCode());
                    this.updateById((Object)projectSurveyEntity);
                    break;
                }
                if (1 != taskVariables.getApproveStatus()) break;
                projectSurveyEntity.setApprovalStatus(ApprovalStatusEnum.TWO.getCode());
                this.updateById((Object)projectSurveyEntity);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                projectSurveyEntity.setApprovalStatus(ApprovalStatusEnum.THREE.getCode());
                this.updateById((Object)projectSurveyEntity);
            }
        }
    }

    public String getNumber(ProjectSurveyDTO projectSurveyDTO) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("XMKC");
        if (StringUtils.isNotBlank((CharSequence)projectSurveyDTO.getBelongingBrand())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterUpper((String)projectSurveyDTO.getBelongingBrand()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectSurveyDTO.getChildBelongingBrand())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterLower((String)projectSurveyDTO.getChildBelongingBrand()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectSurveyDTO.getProjectName())) {
            stringBuffer.append(ChineseToPinyinUtils.getFirstLetterUpper((String)projectSurveyDTO.getProjectName()));
        }
        if (StringUtils.isNotBlank((CharSequence)projectSurveyDTO.getCityNo())) {
            stringBuffer.append(projectSurveyDTO.getCityNo());
        }
        stringBuffer.append(DateUtils.getDateToString((Date)DateTime.now(), (String)"yyyyMMdd"));
        Integer count = ((ProjectSurveyMapper)this.baseMapper).selectCountInToday();
        stringBuffer.append(String.format("%04d", count + 1));
        return stringBuffer.toString();
    }

    public String getTopicName(LoginUser loginUser) {
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append(loginUser.getUsername());
        stringBuffer.append(DateUtils.getDateToString((Date)DateTime.now(), (String)"yyyy-MM-dd"));
        stringBuffer.append("\u53d1\u8d77\u9879\u76ee\u52d8\u5bdf");
        return stringBuffer.toString();
    }
}

