/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.util;

import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ChineseToPinyinUtils {
    public static String getFirstLetterUpper(String chinese) {
        char[] chars;
        if (StringUtils.isEmpty((CharSequence)chinese)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        HanyuPinyinOutputFormat outputFormat = new HanyuPinyinOutputFormat();
        outputFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (char ch : chars = chinese.toCharArray()) {
            if (!Character.isLowerCase(ch) && !Character.isUpperCase(ch)) {
                try {
                    String[] pinyin = PinyinHelper.toHanyuPinyinStringArray((char)ch, (HanyuPinyinOutputFormat)outputFormat);
                    if (ObjectUtils.isEmpty((Object)pinyin)) {
                        sb.append(ch);
                        continue;
                    }
                    sb.append(pinyin[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            sb.append(Character.toUpperCase(ch));
        }
        return sb.toString();
    }

    public static String getFirstLetterLower(String chinese) {
        char[] chars;
        if (StringUtils.isEmpty((CharSequence)chinese)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        HanyuPinyinOutputFormat outputFormat = new HanyuPinyinOutputFormat();
        outputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (char ch : chars = chinese.toCharArray()) {
            if (!Character.isLowerCase(ch) && !Character.isUpperCase(ch)) {
                try {
                    String[] pinyin = PinyinHelper.toHanyuPinyinStringArray((char)ch, (HanyuPinyinOutputFormat)outputFormat);
                    if (ObjectUtils.isEmpty((Object)pinyin)) {
                        sb.append(ch);
                        continue;
                    }
                    sb.append(pinyin[0].charAt(0));
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            sb.append(Character.toLowerCase(ch));
        }
        return sb.toString();
    }

    public static String getAllLetterUpper(String chinese) {
        char[] chars;
        if (StringUtils.isEmpty((CharSequence)chinese)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        HanyuPinyinOutputFormat outputFormat = new HanyuPinyinOutputFormat();
        outputFormat.setCaseType(HanyuPinyinCaseType.UPPERCASE);
        outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (char ch : chars = chinese.toCharArray()) {
            if (!Character.isLowerCase(ch) && !Character.isUpperCase(ch)) {
                try {
                    String[] pinyin = PinyinHelper.toHanyuPinyinStringArray((char)ch, (HanyuPinyinOutputFormat)outputFormat);
                    if (ObjectUtils.isEmpty((Object)pinyin)) {
                        sb.append(ch);
                        continue;
                    }
                    sb.append(pinyin[0]);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            sb.append(Character.toUpperCase(ch));
        }
        return sb.toString();
    }

    public static String getAllLetterLower(String chinese) {
        char[] chars;
        if (StringUtils.isEmpty((CharSequence)chinese)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        HanyuPinyinOutputFormat outputFormat = new HanyuPinyinOutputFormat();
        outputFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        outputFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        for (char ch : chars = chinese.toCharArray()) {
            if (!Character.isLowerCase(ch) && !Character.isUpperCase(ch)) {
                try {
                    String[] pinyin = PinyinHelper.toHanyuPinyinStringArray((char)ch, (HanyuPinyinOutputFormat)outputFormat);
                    if (ObjectUtils.isEmpty((Object)pinyin)) {
                        sb.append(ch);
                        continue;
                    }
                    sb.append(pinyin[0]);
                }
                catch (BadHanyuPinyinOutputFormatCombination e) {
                    e.printStackTrace();
                }
                continue;
            }
            sb.append(Character.toLowerCase(ch));
        }
        return sb.toString();
    }
}

