/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.util;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.StringUtils;

public class EnumUtils {
    private static String ENUM_CLASSPATH = "java.lang.Enum";

    public static List<Map<String, Object>> enumToListMap(Class<?> enumClass) {
        Enum[] enums;
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        if (!ENUM_CLASSPATH.equals(enumClass.getSuperclass().getCanonicalName())) {
            return resultList;
        }
        Method[] methods = enumClass.getMethods();
        ArrayList fieldList = new ArrayList();
        Arrays.stream(methods).map(Method::getName).filter(methodName -> methodName.startsWith("get") && !"getDeclaringClass".equals(methodName) && !"getClass".equals(methodName)).forEachOrdered(methodName -> {
            try {
                Field field = enumClass.getDeclaredField(StringUtils.uncapitalize((String)methodName.substring(3)));
                if (null != field) {
                    fieldList.add(field);
                }
            }
            catch (NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        });
        if (CollectionUtils.isEmpty(fieldList)) {
            return resultList;
        }
        for (Enum anEnum : enums = (Enum[])enumClass.getEnumConstants()) {
            HashMap<String, Object> map = new HashMap<String, Object>(fieldList.size());
            for (Field field : fieldList) {
                field.setAccessible(true);
                try {
                    map.put(field.getName(), field.get(anEnum));
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            resultList.add(map);
        }
        return resultList;
    }
}

