/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.util;

import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.core.utils.SpringUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.system.api.RemoteFileService;
import com.ruoyi.system.api.domain.SysFile;
import com.ruoyi.util.CommonMultipartFile;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class ImageUtil {
    private static final Logger log = LoggerFactory.getLogger(ImageUtil.class);
    public static ExecutorService imageExecutor = Executors.newFixedThreadPool(4);
    private static RemoteFileService remoteFileService = (RemoteFileService)SpringUtils.getBean(RemoteFileService.class);

    public static String compressImage(String url) {
        if (StringUtils.isEmpty((String)url)) {
            return "";
        }
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpGet = new HttpGet(url);
        httpGet.addHeader("Authorization", "");
        int i = url.lastIndexOf("/");
        String fileName = url.substring(i);
        String thumbUrl = "";
        try {
            HttpResponse execute = httpClient.execute((HttpUriRequest)httpGet);
            InputStream content = execute.getEntity().getContent();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            Thumbnails.of((InputStream[])new InputStream[]{content}).scale(1.0).outputQuality(0.6).outputFormat("jpg").toOutputStream((OutputStream)byteArrayOutputStream);
            IOUtils.copy((InputStream)content, (OutputStream)byteArrayOutputStream);
            CommonMultipartFile commonMultipartFile = new CommonMultipartFile(fileName, fileName, "", byteArrayOutputStream.toByteArray());
            R upload = remoteFileService.upload((MultipartFile)commonMultipartFile);
            thumbUrl = ((SysFile)upload.getData()).getUrl();
            System.out.println(thumbUrl);
        }
        catch (Exception e) {
            log.error("\u538b\u7f29\u56fe\u7247\u5931\u8d25\u3002url={}", (Object)url);
        }
        return thumbUrl;
    }
}

