/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.system.controller;

import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.system.api.domain.SysDept;
import com.ruoyi.system.domain.query.CompanyQuery;
import com.ruoyi.system.domain.vo.CompanyVo;
import com.ruoyi.system.dto.CompanyDTO;
import com.ruoyi.system.service.CompanyService;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/company"})
public class CompanyController
extends BaseController {
    @Autowired
    private CompanyService companyService;

    @PostMapping(value={"/getPageList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2", response=CompanyVo.class)
    public TableDataInfo getPageList(@RequestBody CompanyQuery query) {
        TableDataInfo result = this.companyService.getPageList(query);
        return result;
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868-\u4f01\u4e1a\u3001\u90e8\u95e8tree", response=CompanyVo.class)
    @PostMapping(value={"/getList"})
    public AjaxResult getList(@RequestBody CompanyQuery query) {
        List results = this.companyService.getList(query);
        return this.success((Object)results);
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2")
    @GetMapping(value={"/getInfoById"})
    public AjaxResult getInfoById(@RequestParam(value="id") Long id) {
        CompanyVo result = this.companyService.getInfoById(id);
        return this.success((Object)result);
    }

    @ApiOperation(value="\u6839\u636eCODE\u67e5\u8be2")
    @GetMapping(value={"/getInfoByCode"})
    public AjaxResult getInfoByCode(@RequestParam(value="code") String code) {
        CompanyVo result = this.companyService.getInfoByCode(code);
        return this.success((Object)result);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/addEntity"})
    public AjaxResult addEntity(@RequestBody CompanyDTO dto) {
        this.companyService.addEntity(dto);
        return this.success();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/updateEntityById"})
    public AjaxResult updateEntityById(@RequestBody CompanyDTO dto) {
        this.companyService.updateEntityById(dto);
        return this.success();
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"/delEntityById/{id}"})
    public AjaxResult delEntityById(@PathVariable(value="id") String id) {
        this.companyService.delEntityById(id);
        return this.success();
    }

    @PostMapping(value={"/addParentDept"})
    public AjaxResult addParentDept(@RequestBody SysDept dept) {
        return this.toAjax(this.companyService.addParentDept(dept));
    }

    @ApiOperation(value="\u6839\u636e\u516c\u53f8code\u83b7\u53d6\u90e8\u95e8\u6811")
    @GetMapping(value={"/getTreeByCode"})
    public AjaxResult getTreeByCode(@RequestParam(value="code") String code) {
        List results = this.companyService.getDeptTreeByCode(code);
        return this.success((Object)results);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868-\u4f01\u4e1a\u3001\u90e8\u95e8\u3001\u4eba\u5458tree", response=CompanyVo.class)
    @PostMapping(value={"/getUserTreeByCode"})
    public AjaxResult getUserTreeByCode(@RequestBody CompanyQuery query) {
        List results = this.companyService.getUserTreeByCode(query);
        return this.success((Object)results);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868-\u4f01\u4e1a\u3001\u90e8\u95e8\u3001\u4eba\u5458tree", response=CompanyVo.class)
    @PostMapping(value={"/getTreeByCodeUser"})
    public AjaxResult getTreeByCodeUser(@RequestBody CompanyQuery query) {
        List results = this.companyService.getTreeByCodeUser(query);
        return this.success((Object)results);
    }
}

