/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.system.controller;

import com.ruoyi.common.core.domain.R;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.core.utils.poi.ExcelUtil;
import com.ruoyi.common.core.web.controller.BaseController;
import com.ruoyi.common.core.web.domain.AjaxResult;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.log.annotation.Log;
import com.ruoyi.common.log.enums.BusinessType;
import com.ruoyi.common.security.annotation.InnerAuth;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.system.api.domain.SysDept;
import com.ruoyi.system.api.domain.SysRole;
import com.ruoyi.system.api.domain.SysUser;
import com.ruoyi.system.api.model.LoginUser;
import com.ruoyi.system.domain.CompanyEntity;
import com.ruoyi.system.service.CompanyService;
import com.ruoyi.system.service.ISysConfigService;
import com.ruoyi.system.service.ISysDeptService;
import com.ruoyi.system.service.ISysPermissionService;
import com.ruoyi.system.service.ISysPostService;
import com.ruoyi.system.service.ISysRoleService;
import com.ruoyi.system.service.ISysUserService;
import com.ruoyi.system.utils.PageData;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/user"})
public class SysUserController
extends BaseController {
    @Autowired
    private ISysUserService userService;
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private CompanyService companyService;
    @Autowired
    private ISysDeptService deptService;
    @Autowired
    private ISysPostService postService;
    @Autowired
    private ISysPermissionService permissionService;
    @Autowired
    private ISysConfigService configService;

    @GetMapping(value={"/list"})
    public TableDataInfo list(SysUser user) {
        this.startPage();
        List list = this.userService.selectUserList(user);
        return this.getDataTable(list);
    }

    @GetMapping(value={"/pageList"})
    public TableDataInfo pageList(SysUser user) {
        this.startPage();
        List list = this.userService.selectALlUserList(user);
        return this.getDataTable(list);
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.EXPORT)
    @PostMapping(value={"/export"})
    public void export(HttpServletResponse response, SysUser user) {
        List list = this.userService.selectUserList(user);
        ExcelUtil util = new ExcelUtil(SysUser.class);
        util.exportExcel(response, list, "\u7528\u6237\u6570\u636e");
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.IMPORT)
    @PostMapping(value={"/importData"})
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception {
        ExcelUtil util = new ExcelUtil(SysUser.class);
        List userList = util.importExcel(file.getInputStream());
        String operName = SecurityUtils.getUsername();
        String message = this.userService.importUser(userList, Boolean.valueOf(updateSupport), operName);
        return this.success(message);
    }

    @PostMapping(value={"/importTemplate"})
    public void importTemplate(HttpServletResponse response) throws IOException {
        ExcelUtil util = new ExcelUtil(SysUser.class);
        util.importTemplateExcel(response, "\u7528\u6237\u6570\u636e");
    }

    @InnerAuth
    @GetMapping(value={"/info/{username}"})
    public R<LoginUser> info(@PathVariable(value="username") String username) {
        Long deptId;
        CompanyEntity company;
        SysUser sysUser = this.userService.selectUserByUserName(username);
        if (StringUtils.isNull((Object)sysUser)) {
            return R.fail((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        }
        String companyId = sysUser.getCompanyId();
        if (StringUtils.isNotNull((Object)companyId) && (company = (CompanyEntity)this.companyService.getById((Serializable)((Object)companyId))) != null) {
            sysUser.setCompanyName(company.getCompanyName());
        }
        if ((deptId = sysUser.getDeptId()) != null) {
            SysDept dept = this.deptService.selectDeptById(deptId);
            sysUser.setDeptName(dept.getDeptName());
            sysUser.setDept(dept);
        }
        Set roles = this.permissionService.getRolePermission(sysUser);
        Set permissions = this.permissionService.getMenuPermission(sysUser);
        LoginUser sysUserVo = new LoginUser();
        sysUserVo.setSysUser(sysUser);
        sysUserVo.setRoles(roles);
        sysUserVo.setPermissions(permissions);
        return R.ok((Object)sysUserVo);
    }

    @InnerAuth
    @PostMapping(value={"/getByUserPhone/{phonenumber}"})
    public R<LoginUser> getUserInfo(@PathVariable(value="phonenumber") String phonenumber, @RequestBody SysUser useInfo) {
        Long deptId;
        CompanyEntity company;
        SysUser sysUser = this.userService.selectUserByPhone(phonenumber);
        if (StringUtils.isNull((Object)sysUser)) {
            return R.fail((String)"\u7528\u6237\u624b\u673a\u53f7\u7801\u4e0d\u5b58\u5728\uff01");
        }
        String companyId = sysUser.getCompanyId();
        if (StringUtils.isNotNull((Object)companyId) && (company = (CompanyEntity)this.companyService.getById((Serializable)((Object)companyId))) != null) {
            sysUser.setCompanyName(company.getCompanyName());
        }
        if ((deptId = sysUser.getDeptId()) != null) {
            SysDept dept = this.deptService.selectDeptById(deptId);
            sysUser.setDeptName(dept.getDeptName());
        }
        Set roles = this.permissionService.getRolePermission(sysUser);
        List longList = this.permissionService.selectRoleListByUserId(sysUser.getUserId());
        Set permissions = this.permissionService.getMenuPermission(sysUser);
        LoginUser sysUserVo = new LoginUser();
        sysUserVo.setSysUser(sysUser);
        sysUserVo.setRoles(roles);
        sysUserVo.setPermissions(permissions);
        if (useInfo != null) {
            Long[] longs = SysUserController.convertSetToLongArray((List)longList);
            sysUser.setRoleIds(longs);
            sysUser.setOpenid(useInfo.getOpenid());
            sysUser.setUnionid(useInfo.getUnionid());
            this.userService.updateUser(sysUser);
        }
        return R.ok((Object)sysUserVo);
    }

    private static Long[] convertSetToLongArray(List<Long> longList) {
        Long[] longArray = longList.toArray(new Long[0]);
        return longArray;
    }

    @InnerAuth
    @GetMapping(value={"/getByUserOpenidOrUnionid"})
    public R<LoginUser> selectByUserOpenidOrUnionid(@RequestParam String openid, @RequestParam(required=false) String unionid) {
        Long deptId;
        CompanyEntity company;
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{openid, unionid})) {
            return R.fail((String)"\u7528\u6237openid\u6216unionid\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        SysUser sysUser = this.userService.selectByUserOpenidOrUnionid(openid, unionid);
        if (StringUtils.isNull((Object)sysUser)) {
            return R.fail((String)"\u7528\u6237\u672a\u7ed1\u5b9a\uff0c\u8bf7\u5148\u7ed1\u5b9a\u7528\u6237\uff01");
        }
        String companyId = sysUser.getCompanyId();
        if (StringUtils.isNotNull((Object)companyId) && (company = (CompanyEntity)this.companyService.getById((Serializable)((Object)companyId))) != null) {
            sysUser.setCompanyName(company.getCompanyName());
        }
        if ((deptId = sysUser.getDeptId()) != null) {
            SysDept dept = this.deptService.selectDeptById(deptId);
            sysUser.setDeptName(dept.getDeptName());
        }
        Set roles = this.permissionService.getRolePermission(sysUser);
        Set permissions = this.permissionService.getMenuPermission(sysUser);
        LoginUser sysUserVo = new LoginUser();
        sysUserVo.setSysUser(sysUser);
        sysUserVo.setRoles(roles);
        sysUserVo.setPermissions(permissions);
        return R.ok((Object)sysUserVo);
    }

    @InnerAuth
    @PostMapping(value={"/register"})
    public R<Boolean> register(@RequestBody SysUser sysUser) {
        String username = sysUser.getUserName();
        if (!"true".equals(this.configService.selectConfigByKey("sys.account.registerUser"))) {
            return R.fail((String)"\u5f53\u524d\u7cfb\u7edf\u6ca1\u6709\u5f00\u542f\u6ce8\u518c\u529f\u80fd\uff01");
        }
        if (!this.userService.checkUserNameUnique(sysUser)) {
            return R.fail((String)("\u4fdd\u5b58\u7528\u6237'" + username + "'\u5931\u8d25\uff0c\u6ce8\u518c\u8d26\u53f7\u5df2\u5b58\u5728"));
        }
        return R.ok((Object)this.userService.registerUser(sysUser));
    }

    public static void main(String[] args) {
        String s = "true";
        if (!"true".equals(s)) {
            System.out.printf("====", new Object[0]);
        }
    }

    @GetMapping(value={"getInfo"})
    public AjaxResult getInfo() {
        Long deptId;
        SysUser user = this.userService.selectUserById(SecurityUtils.getUserId());
        String companyId = user.getCompanyId();
        if (StringUtils.isNotNull((Object)companyId)) {
            CompanyEntity company = (CompanyEntity)this.companyService.getById((Serializable)((Object)companyId));
            user.setCompanyName(company.getCompanyName());
        }
        if ((deptId = user.getDeptId()) != null) {
            SysDept dept = this.deptService.selectDeptById(deptId);
            user.setDeptName(dept.getDeptName());
        }
        user.setPassword(null);
        Set roles = this.permissionService.getRolePermission(user);
        Set permissions = this.permissionService.getMenuPermission(user);
        AjaxResult ajax = AjaxResult.success();
        ajax.put("user", (Object)user);
        ajax.put("roles", (Object)roles);
        ajax.put("permissions", (Object)permissions);
        return ajax;
    }

    @GetMapping(value={"/", "/{userId}"})
    public AjaxResult getInfo(@PathVariable(value="userId", required=false) Long userId) {
        AjaxResult ajax = AjaxResult.success();
        List roles = this.roleService.selectRoleAll();
        ajax.put("roles", (Object)(SysUser.isAdmin((Long)userId) ? roles : roles.stream().filter(r -> !r.isAdmin()).collect(Collectors.toList())));
        ajax.put("posts", (Object)this.postService.selectPostAll());
        if (StringUtils.isNotNull((Object)userId)) {
            SysUser sysUser = this.userService.selectUserById(userId);
            if (sysUser != null) {
                Long deptId;
                CompanyEntity company;
                String companyId = sysUser.getCompanyId();
                if (StringUtils.isNotNull((Object)companyId) && (company = (CompanyEntity)this.companyService.getById((Serializable)((Object)companyId))) != null) {
                    sysUser.setCompanyName(company.getCompanyName());
                }
                if ((deptId = sysUser.getDeptId()) != null) {
                    SysDept dept = this.deptService.selectDeptById(deptId);
                    sysUser.setDeptName(dept.getDeptName());
                }
            }
            ajax.put("data", (Object)sysUser);
            ajax.put("postIds", (Object)this.postService.selectPostListByUserId(userId));
            ajax.put("roleIds", sysUser.getRoles().stream().map(SysRole::getRoleId).collect(Collectors.toList()));
        }
        return ajax;
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@Validated @RequestBody SysUser user) {
        if (!this.userService.userInfoIdUnique(user)) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getUserInfoId() + "'\u5931\u8d25\uff0c\u7528\u6237\u8eab\u4efd\u8bc1\u5df2\u5b58\u5728");
        }
        if (!this.userService.checkUserNameUnique(user)) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)user.getPhonenumber()) && !this.userService.checkPhoneUnique(user)) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)user.getEmail()) && !this.userService.checkEmailUnique(user)) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (!this.userService.checkUserCodeUnique(user)) {
            return this.error("\u65b0\u589e\u7528\u6237'" + user.getUserCode() + "'\u5931\u8d25\uff0c\u7528\u6237\u7f16\u7801\u5df2\u5b58\u5728");
        }
        user.setCreateBy(SecurityUtils.getUsername());
        user.setPassword(SecurityUtils.encryptPassword((String)user.getPassword()));
        return this.toAjax(this.userService.insertUser(user));
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@Validated @RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        if (!this.userService.checkNickNameUnique(user)) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getNickName() + "'\u5931\u8d25\uff0c\u7528\u6237\u6635\u79f0\u5df2\u5b58\u5728");
        }
        if (!this.userService.checkUserNameUnique(user)) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u767b\u5f55\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)user.getPhonenumber()) && !this.userService.checkPhoneUnique(user)) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u624b\u673a\u53f7\u7801\u5df2\u5b58\u5728");
        }
        if (StringUtils.isNotEmpty((String)user.getEmail()) && !this.userService.checkEmailUnique(user)) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getUserName() + "'\u5931\u8d25\uff0c\u90ae\u7bb1\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        String userCode = user.getUserCode();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)userCode)) {
            throw new ServiceException("\u7528\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        if (!this.userService.checkUserCodeUnique(user)) {
            return this.error("\u4fee\u6539\u7528\u6237'" + user.getUserCode() + "'\u5931\u8d25\uff0c\u7528\u6237\u7f16\u7801\u5df2\u5b58\u5728");
        }
        user.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.userService.updateUser(user));
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.DELETE)
    @DeleteMapping(value={"/{userIds}"})
    public AjaxResult remove(@PathVariable Long[] userIds) {
        if (ArrayUtils.contains((Object[])userIds, (Object)SecurityUtils.getUserId())) {
            return this.error("\u5f53\u524d\u7528\u6237\u4e0d\u80fd\u5220\u9664");
        }
        return this.toAjax(this.userService.deleteUserByIds(userIds));
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/resetPwd"})
    public AjaxResult resetPwd(@RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        user.setPassword(SecurityUtils.encryptPassword((String)user.getPassword()));
        user.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.userService.resetPwd(user));
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.UPDATE)
    @PutMapping(value={"/changeStatus"})
    public AjaxResult changeStatus(@RequestBody SysUser user) {
        this.userService.checkUserAllowed(user);
        user.setUpdateBy(SecurityUtils.getUsername());
        return this.toAjax(this.userService.updateUserStatus(user));
    }

    @GetMapping(value={"/authRole/{userId}"})
    public AjaxResult authRole(@PathVariable(value="userId") Long userId) {
        Long deptId;
        AjaxResult ajax = AjaxResult.success();
        SysUser user = this.userService.selectUserById(userId);
        String companyId = user.getCompanyId();
        if (StringUtils.isNotNull((Object)companyId)) {
            CompanyEntity company = (CompanyEntity)this.companyService.getById((Serializable)((Object)companyId));
            user.setCompanyName(company.getCompanyName());
        }
        if ((deptId = user.getDeptId()) != null) {
            SysDept dept = this.deptService.selectDeptById(deptId);
            user.setDeptName(dept.getDeptName());
        }
        List roles = this.roleService.selectRolesByUserId(userId);
        ajax.put("user", (Object)user);
        ajax.put("roles", (Object)(SysUser.isAdmin((Long)userId) ? roles : roles.stream().filter(r -> !r.isAdmin()).collect(Collectors.toList())));
        return ajax;
    }

    @Log(title="\u7528\u6237\u7ba1\u7406", businessType=BusinessType.GRANT)
    @PutMapping(value={"/authRole"})
    public AjaxResult insertAuthRole(Long userId, Long[] roleIds) {
        this.userService.insertUserAuth(userId, roleIds);
        return this.success();
    }

    @GetMapping(value={"/deptTree"})
    public AjaxResult deptTree(SysDept dept) {
        return this.success((Object)this.deptService.selectDeptTreeList(dept));
    }

    @GetMapping(value={"/deptTree/user"})
    public AjaxResult deptUserTree(SysDept dept) {
        return this.success((Object)this.deptService.selectDeptUserTreeList(dept));
    }

    @GetMapping(value={"/getUserList"})
    public AjaxResult getUserList(SysUser user) {
        List sysUsers = this.userService.selectAllUserList(user);
        for (SysUser sysUser : sysUsers) {
            Long deptId;
            CompanyEntity company;
            String companyId = sysUser.getCompanyId();
            if (StringUtils.isNotNull((Object)companyId) && (company = (CompanyEntity)this.companyService.getById((Serializable)((Object)companyId))) != null) {
                sysUser.setCompanyName(company.getCompanyName());
            }
            if ((deptId = sysUser.getDeptId()) == null) continue;
            SysDept dept = this.deptService.selectDeptById(deptId);
            sysUser.setDeptName(dept.getDeptName());
        }
        return this.success((Object)sysUsers);
    }

    @GetMapping(value={"/getDeptUserList"})
    public AjaxResult getDeptUserList() {
        List sysUsers = this.userService.getDeptUser();
        for (SysUser sysUser : sysUsers) {
            Long deptId;
            CompanyEntity company;
            String companyId = sysUser.getCompanyId();
            if (StringUtils.isNotNull((Object)companyId) && (company = (CompanyEntity)this.companyService.getById((Serializable)((Object)companyId))) != null) {
                sysUser.setCompanyName(company.getCompanyName());
            }
            if ((deptId = sysUser.getDeptId()) == null) continue;
            SysDept dept = this.deptService.selectDeptById(deptId);
            sysUser.setDeptName(dept.getDeptName());
        }
        return this.success((Object)sysUsers);
    }

    @GetMapping(value={"/pageUsersForProcess"})
    public AjaxResult pageUsersForProcess(@RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="userName", required=false) String userName, @RequestParam(value="userCode", required=false) String userCode) {
        PageData results = this.userService.pageUsersForProcess(pageNum, pageSize, userName, userCode);
        return this.success((Object)results);
    }

    @GetMapping(value={"/getUserByRoleId"})
    public AjaxResult getUserByRoleId(@RequestParam(value="roleId") String roleId) {
        List results = this.userService.getUserByRoleId(roleId);
        return this.success((Object)results);
    }
}

