/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.ValidatorUtils;
import com.ruoyi.common.core.web.page.TableDataInfo;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.system.api.domain.SysDept;
import com.ruoyi.system.api.domain.SysUser;
import com.ruoyi.system.domain.CompanyEntity;
import com.ruoyi.system.domain.query.CompanyQuery;
import com.ruoyi.system.domain.vo.CompanyVo;
import com.ruoyi.system.dto.CompanyDTO;
import com.ruoyi.system.mapper.CompanyMapper;
import com.ruoyi.system.mapper.SysDeptMapper;
import com.ruoyi.system.service.CompanyService;
import com.ruoyi.system.service.ISysDeptService;
import com.ruoyi.system.service.ISysUserService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CompanyServiceImpl
extends ServiceImpl<CompanyMapper, CompanyEntity>
implements CompanyService {
    @Autowired
    private CompanyMapper companyMapper;
    @Autowired
    private SysDeptMapper deptMapper;
    @Autowired
    private ISysUserService userService;
    @Autowired
    private ISysDeptService deptService;

    public TableDataInfo getPageList(CompanyQuery query) {
        List<Object> results = new ArrayList();
        String companyCode = query.getCompanyCode();
        String companyName = query.getCompanyName();
        Integer companyType = query.getCompanyType();
        String status = query.getStatus();
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)companyCode)) {
            wrapper.eq((Object)"company_code", (Object)companyCode);
        }
        if (StringUtils.isNotBlank((CharSequence)companyName)) {
            wrapper.like((Object)"company_name", (Object)companyName);
        }
        if (companyType != null) {
            wrapper.eq((Object)"company_type", (Object)companyType);
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            wrapper.eq((Object)"status", (Object)status);
        }
        wrapper.orderByDesc((Object)"create_time");
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        List entities = this.companyMapper.selectList((Wrapper)wrapper);
        results = entities.stream().map(t -> {
            CompanyVo vo = new CompanyVo();
            BeanUtils.copyProperties((Object)t, (Object)vo);
            vo.setCompanyId(t.getCompanyId().toString());
            List depts = this.getDeptTreeByCode(vo.getCompanyCode());
            vo.setDepts(depts);
            return vo;
        }).collect(Collectors.toList());
        TableDataInfo rspData = new TableDataInfo();
        rspData.setCode(200);
        rspData.setRows(results);
        rspData.setMsg("\u67e5\u8be2\u6210\u529f");
        rspData.setTotal(new PageInfo(entities).getTotal());
        return rspData;
    }

    public List<CompanyVo> getList(CompanyQuery query) {
        ArrayList<CompanyVo> results = new ArrayList();
        String companyCode = query.getCompanyCode();
        String companyName = query.getCompanyName();
        Integer companyType = query.getCompanyType();
        String status = query.getStatus();
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)companyCode)) {
            wrapper.eq((Object)"company_code", (Object)companyCode);
        }
        if (StringUtils.isNotBlank((CharSequence)companyName)) {
            wrapper.like((Object)"company_name", (Object)companyName);
        }
        if (companyType != null) {
            wrapper.eq((Object)"company_type", (Object)companyType);
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            wrapper.eq((Object)"status", (Object)status);
        }
        wrapper.orderByDesc((Object)"create_time");
        List entities = this.companyMapper.selectList((Wrapper)wrapper);
        results = entities.stream().map(t -> {
            CompanyVo vo = new CompanyVo();
            BeanUtils.copyProperties((Object)t, (Object)vo);
            vo.setCompanyId(t.getCompanyId().toString());
            List depts = this.getDeptTreeByCode(vo.getCompanyCode());
            vo.setDepts(depts);
            return vo;
        }).collect(Collectors.toList());
        return results;
    }

    public CompanyVo getInfoById(Long id) {
        CompanyVo result = new CompanyVo();
        CompanyEntity companyEntity = (CompanyEntity)this.companyMapper.selectById((Serializable)id);
        if (companyEntity != null) {
            BeanUtils.copyProperties((Object)companyEntity, (Object)result);
            result.setCompanyId(companyEntity.getCompanyId().toString());
        }
        return result;
    }

    public CompanyVo getInfoByCode(String code) {
        CompanyVo result = new CompanyVo();
        CompanyEntity companyEntity = (CompanyEntity)this.companyMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"company_code", (Object)code));
        if (companyEntity != null) {
            BeanUtils.copyProperties((Object)companyEntity, (Object)result);
            result.setCompanyId(companyEntity.getCompanyId().toString());
        }
        return result;
    }

    public void addEntity(CompanyDTO dto) {
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        CompanyEntity nameEntity = (CompanyEntity)this.companyMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"company_name", (Object)dto.getCompanyName()));
        if (nameEntity != null) {
            throw new ServiceException("\u4f01\u4e1a\u540d\u79f0\u5df2\u5b58\u5728\u8bf7\u6838\u5b9e\uff01");
        }
        CompanyEntity codeEntity = (CompanyEntity)this.companyMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"company_code", (Object)dto.getCompanyCode()));
        if (codeEntity != null) {
            throw new ServiceException("\u4f01\u4e1a\u7f16\u7801\u5df2\u5b58\u5728\u8bf7\u6838\u5b9e\uff01");
        }
        CompanyEntity entity = new CompanyEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        entity.setCreateBy(SecurityUtils.getUsername());
        entity.setCreateTime(new Date());
        entity.setUpdateBy(SecurityUtils.getUsername());
        entity.setUpdateTime(new Date());
        this.companyMapper.insert((Object)entity);
    }

    public void updateEntityById(CompanyDTO dto) {
        Long id = dto.getCompanyId();
        String companyCode = dto.getCompanyCode();
        if (id == null) {
            throw new ServiceException("ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        if (StringUtils.isBlank((CharSequence)companyCode)) {
            throw new ServiceException("\u4f01\u4e1a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        CompanyEntity codeEntity = (CompanyEntity)this.companyMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"company_code", (Object)dto.getCompanyCode()));
        if (codeEntity != null && id.longValue() != codeEntity.getCompanyId().longValue()) {
            throw new ServiceException("\u4f01\u4e1a\u7f16\u7801\u5df2\u5b58\u5728\u8bf7\u6838\u5b9e\uff01");
        }
        CompanyEntity nameEntity = (CompanyEntity)this.companyMapper.selectOne((Wrapper)new QueryWrapper().eq((Object)"company_name", (Object)dto.getCompanyName()));
        if (nameEntity != null && id.longValue() != nameEntity.getCompanyId().longValue()) {
            throw new ServiceException("\u4f01\u4e1a\u540d\u79f0\u5df2\u5b58\u5728\u8bf7\u6838\u5b9e\uff01");
        }
        CompanyEntity entity = new CompanyEntity();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        entity.setUpdateBy(SecurityUtils.getUsername());
        entity.setUpdateTime(new Date());
        this.companyMapper.updateById((Object)entity);
    }

    public void delEntityById(String id) {
        CompanyEntity companyEntity = (CompanyEntity)this.companyMapper.selectById((Serializable)((Object)id));
        if (companyEntity != null) {
            String companyCode = companyEntity.getCompanyCode();
            SysDept sysDept = this.deptMapper.selectDeptByCompanyCode(companyCode);
            if (sysDept != null) {
                throw new ServiceException("\u4f01\u4e1a\u4e0b\u5b58\u5728\u90e8\u95e8\uff0c\u8bf7\u6838\u5b9e\uff01");
            }
            this.companyMapper.deleteById((Serializable)((Object)id));
        }
    }

    public int addParentDept(SysDept dept) {
        String companyCode = dept.getCompanyCode();
        if (StringUtils.isBlank((CharSequence)companyCode)) {
            throw new ServiceException("\u4f01\u4e1a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        List depts = this.deptMapper.getParentDeptByCode(companyCode);
        List names = depts.stream().map(t -> t.getDeptName()).collect(Collectors.toList());
        if (names.contains(dept.getDeptName())) {
            throw new ServiceException("\u65b0\u589e\u90e8\u95e8'" + dept.getDeptName() + "'\u5931\u8d25\uff0c\u90e8\u95e8\u540d\u79f0\u5df2\u5b58\u5728");
        }
        dept.setParentId(Long.valueOf(0L));
        dept.setAncestors("0");
        dept.setCreateBy(SecurityUtils.getUsername());
        dept.setCreateTime(new Date());
        dept.setUpdateBy(SecurityUtils.getUsername());
        dept.setUpdateTime(new Date());
        return this.deptMapper.insertDept(dept);
    }

    public List<SysDept> getDeptTreeByCode(String code) {
        ArrayList<SysDept> results = new ArrayList<SysDept>();
        List parentResults = this.deptMapper.getParentDeptByCode(code);
        List allDepts = this.deptMapper.selectDeptAllList(new SysDept());
        for (SysDept result : parentResults) {
            List depts = this.buildVolumeData(result.getDeptId(), allDepts);
            results.addAll(depts);
        }
        return results;
    }

    private List<SysDept> buildVolumeData(Long rootId, List<SysDept> allDepts) {
        ArrayList<SysDept> trees = new ArrayList<SysDept>();
        if (CollectionUtils.isNotEmpty(allDepts)) {
            for (SysDept dept : allDepts) {
                if (!rootId.equals(dept.getDeptId())) continue;
                trees.add(this.findChildren(dept, allDepts));
            }
        }
        return trees;
    }

    private SysDept findChildren(SysDept treeNode, List<SysDept> treeNodes) {
        treeNode.setChildren(new ArrayList());
        for (SysDept it : treeNodes) {
            if (!treeNode.getDeptId().equals(it.getParentId())) continue;
            if (treeNode.getChildren() == null) {
                treeNode.setChildren(new ArrayList());
            }
            treeNode.getChildren().add(this.findChildren(it, treeNodes));
        }
        List children = treeNode.getChildren();
        treeNode.setChildren(children.stream().sorted(Comparator.comparing(SysDept::getOrderNum)).collect(Collectors.toList()));
        return treeNode;
    }

    public List<CompanyVo> getUserTreeByCode(CompanyQuery query) {
        ArrayList<CompanyVo> results = new ArrayList();
        String companyCode = query.getCompanyCode();
        String companyName = query.getCompanyName();
        Integer companyType = query.getCompanyType();
        String status = query.getStatus();
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)companyCode)) {
            wrapper.eq((Object)"company_code", (Object)companyCode);
        }
        if (StringUtils.isNotBlank((CharSequence)companyName)) {
            wrapper.like((Object)"company_name", (Object)companyName);
        }
        if (companyType != null) {
            wrapper.eq((Object)"company_type", (Object)companyType);
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            wrapper.eq((Object)"status", (Object)status);
        }
        wrapper.orderByDesc((Object)"create_time");
        List entities = this.companyMapper.selectList((Wrapper)wrapper);
        results = entities.stream().map(t -> {
            CompanyVo vo = new CompanyVo();
            BeanUtils.copyProperties((Object)t, (Object)vo);
            vo.setCompanyId(t.getCompanyId().toString());
            List depts = this.getUserTreeByCode(vo.getCompanyCode());
            vo.setDepts(depts);
            return vo;
        }).collect(Collectors.toList());
        return results;
    }

    public List<CompanyVo> getTreeByCodeUser(CompanyQuery query) {
        ArrayList<CompanyVo> results = new ArrayList();
        String companyCode = query.getCompanyCode();
        String companyName = query.getCompanyName();
        Integer companyType = query.getCompanyType();
        String status = query.getStatus();
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)companyCode)) {
            wrapper.eq((Object)"company_code", (Object)companyCode);
        }
        if (StringUtils.isNotBlank((CharSequence)companyName)) {
            wrapper.like((Object)"company_name", (Object)companyName);
        }
        if (companyType != null) {
            wrapper.eq((Object)"company_type", (Object)companyType);
        }
        if (StringUtils.isNotBlank((CharSequence)status)) {
            wrapper.eq((Object)"status", (Object)status);
        }
        wrapper.orderByDesc((Object)"create_time");
        List entities = this.companyMapper.selectList((Wrapper)wrapper);
        results = entities.stream().map(t -> {
            CompanyVo vo = new CompanyVo();
            BeanUtils.copyProperties((Object)t, (Object)vo);
            vo.setCompanyId(t.getCompanyId().toString());
            List depts = this.getTreeByCodeUser(vo.getCompanyCode());
            vo.setDepts(depts);
            return vo;
        }).collect(Collectors.toList());
        return results;
    }

    public List<SysDept> getTreeByCodeUser(String code) {
        ArrayList<SysDept> results = new ArrayList<SysDept>();
        List parentResults = this.deptMapper.getParentDeptByCode(code);
        List allDepts = this.deptMapper.selectDeptAllList(new SysDept());
        for (SysDept result : parentResults) {
            List depts = this.buildVolumeUserDataUser(result.getDeptId(), allDepts);
            results.addAll(depts);
        }
        return results;
    }

    public List<SysDept> getUserTreeByCode(String code) {
        ArrayList<SysDept> results = new ArrayList<SysDept>();
        List parentResults = this.deptMapper.getParentDeptByCode(code);
        List allDepts = this.deptMapper.selectDeptAllList(new SysDept());
        for (SysDept result : parentResults) {
            List depts = this.buildVolumeUserData(result.getDeptId(), allDepts);
            results.addAll(depts);
        }
        return results;
    }

    private List<SysDept> buildVolumeUserDataUser(Long rootId, List<SysDept> allDepts) {
        ArrayList<SysDept> trees = new ArrayList<SysDept>();
        if (CollectionUtils.isNotEmpty(allDepts)) {
            for (SysDept dept : allDepts) {
                Long deptId = dept.getDeptId();
                if (!rootId.equals(deptId)) continue;
                SysUser param = new SysUser();
                param.setDeptId(deptId);
                List sysUserList = this.userService.selectUserList(param);
                dept.setSysUserList(sysUserList);
                trees.add(this.findUserChildren(dept, allDepts));
            }
        }
        return trees;
    }

    private List<SysDept> buildVolumeUserData(Long rootId, List<SysDept> allDepts) {
        ArrayList<SysDept> trees = new ArrayList<SysDept>();
        if (CollectionUtils.isNotEmpty(allDepts)) {
            for (SysDept dept : allDepts) {
                Long deptId = dept.getDeptId();
                if (!rootId.equals(deptId)) continue;
                SysUser param = new SysUser();
                param.setDeptId(deptId);
                List sysUserList = this.userService.selectAllUserList(param);
                dept.setSysUserList(sysUserList);
                trees.add(this.findUserChildren(dept, allDepts));
            }
        }
        return trees;
    }

    private SysDept findUserChildren(SysDept treeNode, List<SysDept> treeNodes) {
        treeNode.setChildren(new ArrayList());
        for (SysDept it : treeNodes) {
            Long deptId = it.getDeptId();
            if (!treeNode.getDeptId().equals(it.getParentId())) continue;
            if (treeNode.getChildren() == null) {
                treeNode.setChildren(new ArrayList());
            }
            SysUser param = new SysUser();
            param.setDeptId(deptId);
            List sysUserList = this.userService.selectAllUserList(param);
            it.setSysUserList(sysUserList);
            treeNode.getChildren().add(this.findUserChildren(it, treeNodes));
        }
        List children = treeNode.getChildren();
        treeNode.setChildren(children.stream().sorted(Comparator.comparing(SysDept::getOrderNum)).collect(Collectors.toList()));
        return treeNode;
    }
}

