/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.system.service.impl;

import com.ruoyi.system.api.domain.SysRole;
import com.ruoyi.system.api.domain.SysUser;
import com.ruoyi.system.service.ISysMenuService;
import com.ruoyi.system.service.ISysPermissionService;
import com.ruoyi.system.service.ISysRoleService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SysPermissionServiceImpl
implements ISysPermissionService {
    @Autowired
    private ISysRoleService roleService;
    @Autowired
    private ISysMenuService menuService;

    public Set<String> getRolePermission(SysUser user) {
        HashSet<String> roles = new HashSet<String>();
        if (user.isAdmin()) {
            roles.add("admin");
        } else {
            roles.addAll(this.roleService.selectRolePermissionByUserId(user.getUserId()));
        }
        return roles;
    }

    public Set<String> getMenuPermission(SysUser user) {
        HashSet<String> perms = new HashSet<String>();
        if (user.isAdmin()) {
            perms.add("*:*:*");
        } else {
            List roles = user.getRoles();
            if (!CollectionUtils.isEmpty((Collection)roles)) {
                for (SysRole role : roles) {
                    Set rolePerms = this.menuService.selectMenuPermsByRoleId(role.getRoleId());
                    role.setPermissions(rolePerms);
                    perms.addAll(rolePerms);
                }
            } else {
                perms.addAll(this.menuService.selectMenuPermsByUserId(user.getUserId()));
            }
        }
        return perms;
    }

    public List<Long> selectRoleListByUserId(Long userId) {
        return this.roleService.selectRoleListByUserId(userId);
    }
}

