/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.system.service.impl;

import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.system.domain.SysPost;
import com.ruoyi.system.mapper.SysPostMapper;
import com.ruoyi.system.mapper.SysUserPostMapper;
import com.ruoyi.system.service.ISysPostService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysPostServiceImpl
implements ISysPostService {
    @Autowired
    private SysPostMapper postMapper;
    @Autowired
    private SysUserPostMapper userPostMapper;

    public List<SysPost> selectPostList(SysPost post) {
        return this.postMapper.selectPostList(post);
    }

    public List<SysPost> selectPostAll() {
        return this.postMapper.selectPostAll();
    }

    public SysPost selectPostById(Long postId) {
        return this.postMapper.selectPostById(postId);
    }

    public List<Long> selectPostListByUserId(Long userId) {
        return this.postMapper.selectPostListByUserId(userId);
    }

    public boolean checkPostNameUnique(SysPost post) {
        Long postId = StringUtils.isNull((Object)post.getPostId()) ? -1L : post.getPostId();
        SysPost info = this.postMapper.checkPostNameUnique(post.getPostName());
        return !StringUtils.isNotNull((Object)info) || info.getPostId().longValue() == postId.longValue();
    }

    public boolean checkPostCodeUnique(SysPost post) {
        Long postId = StringUtils.isNull((Object)post.getPostId()) ? -1L : post.getPostId();
        SysPost info = this.postMapper.checkPostCodeUnique(post.getPostCode());
        return !StringUtils.isNotNull((Object)info) || info.getPostId().longValue() == postId.longValue();
    }

    public int countUserPostById(Long postId) {
        return this.userPostMapper.countUserPostById(postId);
    }

    public int deletePostById(Long postId) {
        return this.postMapper.deletePostById(postId);
    }

    public int deletePostByIds(Long[] postIds) {
        for (Long postId : postIds) {
            SysPost post = this.selectPostById(postId);
            if (this.countUserPostById(postId) <= 0) continue;
            throw new ServiceException(String.format("%1$s\u5df2\u5206\u914d,\u4e0d\u80fd\u5220\u9664", post.getPostName()));
        }
        return this.postMapper.deletePostByIds(postIds);
    }

    public int insertPost(SysPost post) {
        return this.postMapper.insertPost(post);
    }

    public int updatePost(SysPost post) {
        return this.postMapper.updatePost(post);
    }
}

