/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.system.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.ruoyi.common.core.exception.ServiceException;
import com.ruoyi.common.core.utils.SpringUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.core.utils.bean.BeanValidators;
import com.ruoyi.common.datascope.annotation.DataScope;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.system.api.domain.SysDept;
import com.ruoyi.system.api.domain.SysRole;
import com.ruoyi.system.api.domain.SysUser;
import com.ruoyi.system.domain.CompanyEntity;
import com.ruoyi.system.domain.SysPost;
import com.ruoyi.system.domain.SysUserPost;
import com.ruoyi.system.domain.SysUserRole;
import com.ruoyi.system.dto.ProcessUserCommDTO;
import com.ruoyi.system.mapper.CompanyMapper;
import com.ruoyi.system.mapper.SysDeptMapper;
import com.ruoyi.system.mapper.SysPostMapper;
import com.ruoyi.system.mapper.SysRoleMapper;
import com.ruoyi.system.mapper.SysUserMapper;
import com.ruoyi.system.mapper.SysUserPostMapper;
import com.ruoyi.system.mapper.SysUserRoleMapper;
import com.ruoyi.system.service.ISysConfigService;
import com.ruoyi.system.service.ISysUserService;
import com.ruoyi.system.utils.PageData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SysUserServiceImpl
implements ISysUserService {
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    @Autowired
    private SysUserMapper userMapper;
    @Autowired
    private SysRoleMapper roleMapper;
    @Autowired
    private SysPostMapper postMapper;
    @Autowired
    private SysUserRoleMapper userRoleMapper;
    @Autowired
    private SysUserPostMapper userPostMapper;
    @Autowired
    private ISysConfigService configService;
    @Autowired
    private CompanyMapper companyMapper;
    @Autowired
    private SysDeptMapper sysDeptMapper;
    @Autowired
    protected Validator validator;

    @DataScope(deptAlias="d", userAlias="u")
    public List<SysUser> selectUserList(SysUser user) {
        List sysUsers = this.userMapper.selectUserList(user);
        for (SysUser sysUser : sysUsers) {
            Long deptId;
            CompanyEntity company;
            sysUser.setRoles(this.roleMapper.selectRolesByUserName(sysUser.getUserName()));
            String companyId = sysUser.getCompanyId();
            if (StringUtils.isNotNull((Object)companyId) && (company = (CompanyEntity)this.companyMapper.selectById((Serializable)((Object)companyId))) != null) {
                sysUser.setCompanyName(company.getCompanyName());
            }
            if ((deptId = sysUser.getDeptId()) == null) continue;
            SysDept dept = this.sysDeptMapper.selectDeptById(deptId);
            sysUser.setDeptName(dept.getDeptName());
        }
        return sysUsers;
    }

    public List<SysUser> selectALlUserList(SysUser user) {
        List sysUsers = this.userMapper.selectPageUserList(user);
        for (SysUser sysUser : sysUsers) {
            Long deptId;
            CompanyEntity company;
            sysUser.setRoles(this.roleMapper.selectRolesByUserName(sysUser.getUserName()));
            String companyId = sysUser.getCompanyId();
            if (StringUtils.isNotNull((Object)companyId) && (company = (CompanyEntity)this.companyMapper.selectById((Serializable)((Object)companyId))) != null) {
                sysUser.setCompanyName(company.getCompanyName());
            }
            if ((deptId = sysUser.getDeptId()) == null) continue;
            SysDept dept = this.sysDeptMapper.selectDeptById(deptId);
            sysUser.setDeptName(dept.getDeptName());
        }
        return sysUsers;
    }

    @DataScope(deptAlias="d", userAlias="u")
    public List<SysUser> selectAllocatedList(SysUser user) {
        return this.userMapper.selectAllocatedList(user);
    }

    @DataScope(deptAlias="d", userAlias="u")
    public List<SysUser> selectAllUserList(SysUser user) {
        return this.userMapper.selectAllUserList(user);
    }

    @DataScope(deptAlias="d", userAlias="u")
    public List<SysUser> selectUnallocatedList(SysUser user) {
        return this.userMapper.selectUnallocatedList(user);
    }

    public SysUser selectUserByUserName(String userName) {
        return this.userMapper.selectUserByUserName(userName);
    }

    public SysUser selectUserByPhone(String phoneNumber) {
        return this.userMapper.selectUserByUserPhone(phoneNumber);
    }

    public SysUser selectByUserOpenidOrUnionid(String openid, String unionid) {
        return this.userMapper.selectByUserOpenidOrUnionid(openid, unionid);
    }

    public SysUser selectUserById(Long userId) {
        return this.userMapper.selectUserById(userId);
    }

    public String selectUserRoleGroup(String userName) {
        List list = this.roleMapper.selectRolesByUserName(userName);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return "";
        }
        return list.stream().map(SysRole::getRoleName).collect(Collectors.joining(","));
    }

    public String selectUserPostGroup(String userName) {
        List list = this.postMapper.selectPostsByUserName(userName);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return "";
        }
        return list.stream().map(SysPost::getPostName).collect(Collectors.joining(","));
    }

    public boolean checkUserNameUnique(SysUser user) {
        Long userId = StringUtils.isNull((Object)user.getUserId()) ? -1L : user.getUserId();
        SysUser info = this.userMapper.checkUserNameUnique(user.getUserName());
        return !StringUtils.isNotNull((Object)info) || info.getUserId().longValue() == userId.longValue();
    }

    public boolean checkNickNameUnique(SysUser user) {
        Long userId = StringUtils.isNull((Object)user.getUserId()) ? -1L : user.getUserId();
        SysUser info = this.userMapper.checkNickNameUnique(user.getNickName());
        return !StringUtils.isNotNull((Object)info) || info.getUserId().longValue() == userId.longValue();
    }

    public boolean userInfoIdUnique(SysUser user) {
        Long userId = StringUtils.isNull((Object)user.getUserId()) ? -1L : user.getUserId();
        SysUser info = this.userMapper.userInfoIdUnique(user.getUserInfoId());
        return !StringUtils.isNotNull((Object)info) || info.getUserId().longValue() == userId.longValue();
    }

    public boolean checkUserCodeUnique(SysUser user) {
        Long userId = StringUtils.isNull((Object)user.getUserId()) ? -1L : user.getUserId();
        SysUser info = this.userMapper.checkUserCodeUnique(user.getUserCode());
        return !StringUtils.isNotNull((Object)info) || info.getUserId().longValue() == userId.longValue();
    }

    public boolean checkPhoneUnique(SysUser user) {
        Long userId = StringUtils.isNull((Object)user.getUserId()) ? -1L : user.getUserId();
        SysUser info = this.userMapper.checkPhoneUnique(user.getPhonenumber());
        return !StringUtils.isNotNull((Object)info) || info.getUserId().longValue() == userId.longValue();
    }

    public boolean checkEmailUnique(SysUser user) {
        Long userId = StringUtils.isNull((Object)user.getUserId()) ? -1L : user.getUserId();
        SysUser info = this.userMapper.checkEmailUnique(user.getEmail());
        return !StringUtils.isNotNull((Object)info) || info.getUserId().longValue() == userId.longValue();
    }

    public void checkUserAllowed(SysUser user) {
        if (StringUtils.isNotNull((Object)user.getUserId()) && user.isAdmin()) {
            throw new ServiceException("\u4e0d\u5141\u8bb8\u64cd\u4f5c\u8d85\u7ea7\u7ba1\u7406\u5458\u7528\u6237");
        }
    }

    public void checkUserDataScope(Long userId) {
        if (!SysUser.isAdmin((Long)SecurityUtils.getUserId())) {
            SysUser user = new SysUser();
            user.setUserId(userId);
            List users = ((SysUserServiceImpl)SpringUtils.getAopProxy((Object)this)).selectUserList(user);
            if (StringUtils.isEmpty((Collection)users)) {
                throw new ServiceException("\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u7528\u6237\u6570\u636e\uff01");
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int insertUser(SysUser user) {
        int rows = this.userMapper.insertUser(user);
        this.insertUserPost(user);
        this.insertUserRole(user);
        return rows;
    }

    public boolean registerUser(SysUser user) {
        return this.userMapper.insertUser(user) > 0;
    }

    @Transactional(rollbackFor={Exception.class})
    public int updateUser(SysUser user) {
        Long userId = user.getUserId();
        this.userRoleMapper.deleteUserRoleByUserId(userId);
        this.insertUserRole(user);
        this.userPostMapper.deleteUserPostByUserId(userId);
        this.insertUserPost(user);
        return this.userMapper.updateUser(user);
    }

    @Transactional(rollbackFor={Exception.class})
    public void insertUserAuth(Long userId, Long[] roleIds) {
        this.userRoleMapper.deleteUserRoleByUserId(userId);
        this.insertUserRole(userId, roleIds);
    }

    public int updateUserStatus(SysUser user) {
        return this.userMapper.updateUser(user);
    }

    public int updateUserProfile(SysUser user) {
        return this.userMapper.updateUser(user);
    }

    public boolean updateUserAvatar(String userName, String avatar) {
        return this.userMapper.updateUserAvatar(userName, avatar) > 0;
    }

    public int resetPwd(SysUser user) {
        return this.userMapper.updateUser(user);
    }

    public int resetUserPwd(String userName, String password) {
        return this.userMapper.resetUserPwd(userName, password);
    }

    public void insertUserRole(SysUser user) {
        this.insertUserRole(user.getUserId(), user.getRoleIds());
    }

    public void insertUserPost(SysUser user) {
        Object[] posts = user.getPostIds();
        if (StringUtils.isNotEmpty((Object[])posts)) {
            ArrayList<SysUserPost> list = new ArrayList<SysUserPost>();
            for (Object postId : posts) {
                SysUserPost up = new SysUserPost();
                up.setUserId(user.getUserId());
                up.setPostId((Long)postId);
                list.add(up);
            }
            this.userPostMapper.batchUserPost(list);
        }
    }

    public void insertUserRole(Long userId, Long[] roleIds) {
        if (StringUtils.isNotEmpty((Object[])roleIds)) {
            ArrayList<SysUserRole> list = new ArrayList<SysUserRole>();
            for (Long roleId : roleIds) {
                SysUserRole ur = new SysUserRole();
                ur.setUserId(userId);
                ur.setRoleId(roleId);
                list.add(ur);
            }
            this.userRoleMapper.batchUserRole(list);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteUserById(Long userId) {
        this.userRoleMapper.deleteUserRoleByUserId(userId);
        this.userPostMapper.deleteUserPostByUserId(userId);
        return this.userMapper.deleteUserById(userId);
    }

    @Transactional(rollbackFor={Exception.class})
    public int deleteUserByIds(Long[] userIds) {
        for (Long userId : userIds) {
            this.checkUserAllowed(new SysUser(userId));
        }
        this.userRoleMapper.deleteUserRole(userIds);
        this.userPostMapper.deleteUserPost(userIds);
        return this.userMapper.deleteUserByIds(userIds);
    }

    public String importUser(List<SysUser> userList, Boolean isUpdateSupport, String operName) {
        if (StringUtils.isNull(userList) || userList.size() == 0) {
            throw new ServiceException("\u5bfc\u5165\u7528\u6237\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        int successNum = 0;
        int failureNum = 0;
        StringBuilder successMsg = new StringBuilder();
        StringBuilder failureMsg = new StringBuilder();
        String password = this.configService.selectConfigByKey("sys.user.initPassword");
        for (SysUser user : userList) {
            try {
                SysUser u = this.userMapper.selectUserByUserName(user.getUserName());
                if (StringUtils.isNull((Object)u)) {
                    BeanValidators.validateWithException((Validator)this.validator, (Object)user, (Class[])new Class[0]);
                    user.setPassword(SecurityUtils.encryptPassword((String)password));
                    user.setCreateBy(operName);
                    this.userMapper.insertUser(user);
                    successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getUserName() + " \u5bfc\u5165\u6210\u529f");
                    continue;
                }
                if (isUpdateSupport.booleanValue()) {
                    BeanValidators.validateWithException((Validator)this.validator, (Object)user, (Class[])new Class[0]);
                    this.checkUserAllowed(u);
                    user.setUserId(u.getUserId());
                    user.setUpdateBy(operName);
                    this.userMapper.updateUser(user);
                    successMsg.append("<br/>" + ++successNum + "\u3001\u8d26\u53f7 " + user.getUserName() + " \u66f4\u65b0\u6210\u529f");
                    continue;
                }
                failureMsg.append("<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getUserName() + " \u5df2\u5b58\u5728");
            }
            catch (Exception e) {
                String msg = "<br/>" + ++failureNum + "\u3001\u8d26\u53f7 " + user.getUserName() + " \u5bfc\u5165\u5931\u8d25\uff1a";
                failureMsg.append(msg + e.getMessage());
                log.error(msg, (Throwable)e);
            }
        }
        if (failureNum > 0) {
            failureMsg.insert(0, "\u5f88\u62b1\u6b49\uff0c\u5bfc\u5165\u5931\u8d25\uff01\u5171 " + failureNum + " \u6761\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u9519\u8bef\u5982\u4e0b\uff1a");
            throw new ServiceException(failureMsg.toString());
        }
        successMsg.insert(0, "\u606d\u559c\u60a8\uff0c\u6570\u636e\u5df2\u5168\u90e8\u5bfc\u5165\u6210\u529f\uff01\u5171 " + successNum + " \u6761\uff0c\u6570\u636e\u5982\u4e0b\uff1a");
        return successMsg.toString();
    }

    public List<SysUser> getDeptUser() {
        ArrayList<SysUser> sysUserList = new ArrayList<SysUser>();
        SysDept sysDept = new SysDept();
        sysDept.setDeptName("\u9ec4\u91d1\u5c40");
        List sysDepts = this.sysDeptMapper.selectDeptAllList(sysDept);
        for (SysDept dept : sysDepts) {
            SysUser sysUser = new SysUser();
            sysUser.setDeptId(dept.getDeptId());
            List userList = this.userMapper.selectUserList(sysUser);
            sysUserList.addAll(userList);
        }
        return sysUserList;
    }

    public PageData<ProcessUserCommDTO> pageUsersForProcess(Integer pageNum, Integer pageSize, String userName, String userCode) {
        ArrayList<ProcessUserCommDTO> results = new ArrayList<ProcessUserCommDTO>();
        PageHelper.startPage((int)pageNum, (int)pageSize);
        SysUser user = new SysUser();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userName)) {
            user.setUserName(userName);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)userCode)) {
            user.setNickName(userCode);
        }
        List sysUsers = this.userMapper.selectUserList(user);
        for (SysUser sysUser : sysUsers) {
            ProcessUserCommDTO dto = new ProcessUserCommDTO();
            dto.setId(String.valueOf(sysUser.getUserId()));
            dto.setUserCode(sysUser.getNickName());
            dto.setUserName(sysUser.getUserName());
            results.add(dto);
        }
        PageInfo pageInfo = new PageInfo(sysUsers);
        PageData page = new PageData(results, pageInfo.getTotal());
        return page;
    }

    public List<ProcessUserCommDTO> getUserByRoleId(String roleId) {
        ArrayList<ProcessUserCommDTO> results = new ArrayList<ProcessUserCommDTO>();
        List sysUsers = this.userMapper.getUserByRoleId(roleId);
        for (SysUser sysUser : sysUsers) {
            ProcessUserCommDTO dto = new ProcessUserCommDTO();
            dto.setId(String.valueOf(sysUser.getUserId()));
            dto.setUserCode(sysUser.getNickName());
            dto.setUserName(sysUser.getUserName());
            results.add(dto);
        }
        return results;
    }
}

