/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.crypto.digest.MD5;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.Ignore;
import com.njhm.workflow.dto.FlowProcess;
import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.query.DefinitionParamQuery;
import com.njhm.workflow.service.ProcessDefService;
import com.njhm.workflow.utils.ConvertUtils;
import com.njhm.workflow.utils.FlowUtils;
import com.njhm.workflow.utils.PageData;
import com.njhm.workflow.utils.Result;
import com.njhm.workflow.vo.HistoricActivityVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import liquibase.util.MD5Util;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.repository.ProcessDefinitionQuery;
import org.flowable.image.ProcessDiagramGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Tag(name="\u6d41\u7a0b\u5b9a\u4e49\u7ba1\u7406")
@RestController
@RequestMapping(value={"/process-definition"})
public class ProcessDefController {
    private static final Logger log = LoggerFactory.getLogger(ProcessDefController.class);
    @Autowired
    private ProcessDefService processDefService;
    private final RepositoryService repositoryService;
    private final ProcessEngine processEngine;

    @ApiOperationSupport(order=10)
    @Operation(summary="\u5206\u9875\u83b7\u53d6\u6d41\u7a0b\u5217\u8868")
    @GetMapping(value={"page"})
    @Parameters(value={@Parameter(description="\u5206\u9875\u9875\u7801", name="page", required=true, in=ParameterIn.QUERY), @Parameter(description="\u5206\u9875\u5927\u5c0f", name="limit", required=true, in=ParameterIn.QUERY), @Parameter(description="\u6d41\u7a0b\u5206\u7c7b", name="category", in=ParameterIn.QUERY), @Parameter(description="\u6d41\u7a0b\u5b9a\u4e49KEY", name="processKey", in=ParameterIn.QUERY), @Parameter(description="\u6d41\u7a0b\u5b9a\u4e49\u540d\u79f0", name="processName", in=ParameterIn.QUERY)})
    public Result<PageData<FlowProcess>> page(@Ignore @RequestParam(required=false) Map<String, Object> param) {
        List flowProcesses;
        String processName;
        String processKey;
        ProcessDefinitionQuery processDefinitionQuery = this.repositoryService.createProcessDefinitionQuery().latestVersion();
        String category = MapUtils.getString(param, (Object)"category");
        if (StringUtils.hasLength((String)category)) {
            processDefinitionQuery.processDefinitionCategoryLike(category);
        }
        if (StringUtils.hasLength((String)(processKey = MapUtils.getString(param, (Object)"processKey")))) {
            processDefinitionQuery.processDefinitionKeyLike(processKey);
        }
        if (StringUtils.hasLength((String)(processName = MapUtils.getString(param, (Object)"processName")))) {
            processDefinitionQuery.processDefinitionNameLike(processName);
        }
        long total = processDefinitionQuery.count();
        List list = Collections.emptyList();
        if (total > 0L) {
            int pageNo = MapUtils.getInteger(param, (Object)"page", (Integer)0);
            int limit = MapUtils.getInteger(param, (Object)"limit", (Integer)10);
            int startIndex = Math.max((pageNo - 1) * limit, 0);
            list = processDefinitionQuery.listPage(startIndex, limit);
        }
        if (!CollectionUtils.isEmpty((Collection)(flowProcesses = ConvertUtils.sourceToTarget(list, FlowProcess.class)))) {
            flowProcesses.parallelStream().forEach(flow -> {
                HashMap attributes = new HashMap();
                attributes.putAll(FlowUtils.getProcessAttributes((String)flow.getId()));
                flow.setAttributes(attributes);
            });
        }
        return Result.okData((Object)new PageData(flowProcesses, total));
    }

    @Operation(summary="\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u8be6\u7ec6")
    @Parameter(name="processDefinitionId", required=true, description="\u6d41\u7a0b\u90e8\u7f72ID", in=ParameterIn.PATH)
    @GetMapping(value={"{processDefinitionId}"})
    public Result<FlowProcess> getById(@PathVariable String processDefinitionId) {
        ProcessDefinition processDefinition = this.repositoryService.getProcessDefinition(processDefinitionId);
        return Result.ok((String)"SUCCESS", (Object)ConvertUtils.sourceToTarget((Object)processDefinition, FlowProcess.class));
    }

    @ApiOperationSupport(order=3)
    @Operation(summary="\u6302\u8d77\u6d41\u7a0b")
    @Parameter(name="processDefinitionId", required=true, description="\u6d41\u7a0b\u90e8\u7f72ID", in=ParameterIn.PATH)
    @PostMapping(value={"{processDefinitionId}/suspend"})
    public Result suspend(@PathVariable String processDefinitionId) {
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
        return Result.ok();
    }

    @ApiOperationSupport(order=4)
    @Operation(summary="\u6fc0\u6d3b\u6d41\u7a0b")
    @Parameter(name="processDefinitionId", required=true, description="\u6d41\u7a0b\u90e8\u7f72ID", in=ParameterIn.PATH)
    @PostMapping(value={"{processDefinitionId}/activate"})
    public Result active(@PathVariable String processDefinitionId) {
        this.repositoryService.activateProcessDefinitionById(processDefinitionId);
        return Result.ok();
    }

    @ApiOperationSupport(order=5)
    @Operation(summary="\u6d41\u7a0b\u56fe\u8d44\u6e90")
    @GetMapping(value={"{processKey}/process.png"})
    public void pngDiagram(@PathVariable String processKey, HttpServletResponse response) throws IOException {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().singleResult();
        ProcessEngineConfiguration processEngineConfig = this.processEngine.getProcessEngineConfiguration();
        List flows = Collections.emptyList();
        BpmnModel bpmnModel = FlowUtils.getBpmnModel((String)processDefinition.getId());
        ProcessDiagramGenerator processDiagramGenerator = processEngineConfig.getProcessDiagramGenerator();
        InputStream in = processDiagramGenerator.generateDiagram(bpmnModel, "png", Collections.emptyList(), flows, processEngineConfig.getActivityFontName(), processEngineConfig.getLabelFontName(), processEngineConfig.getAnnotationFontName(), processEngineConfig.getClassLoader(), 1.0, true);
        response.setContentType("image/png");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
        in.close();
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    @ApiOperationSupport(order=6)
    @Operation(summary="\u83b7\u53d6\u6d41\u7a0b\u90e8\u7f72\u4fe1\u606f", hidden=true)
    @GetMapping(value={"deploy/{deploymentId}"})
    @Parameter(name="deploymentId", required=true, description="\u6d41\u7a0b\u90e8\u7f72ID", in=ParameterIn.PATH)
    public Result getDeployment(@PathVariable(value="deploymentId") String deploymentId) {
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().deploymentId(deploymentId).singleResult();
        return Result.okData((Object)deployment);
    }

    @ApiOperationSupport(order=1)
    @Operation(summary="\u90e8\u7f72\u6d41\u7a0b", description="\u652f\u6301.bpmn20.xml\u548c.zip\u6587\u4ef6")
    @Parameter(name="processFile", description="\u6d41\u7a0b\u90e8\u7f72\u6587\u4ef6", required=true, in=ParameterIn.QUERY)
    @PostMapping(value={"deploy"}, consumes={"multipart/form-data"})
    public Result<String> deployProcess(MultipartFile processFile) throws IOException {
        if (processFile.isEmpty()) {
            throw new BizException(10019);
        }
        String deploymentId = this.repositoryService.createDeployment().addBytes(processFile.getOriginalFilename(), processFile.getBytes()).deploy().getId();
        return Result.ok((String)"\u90e8\u7f72\u6210\u529f", (Object)deploymentId);
    }

    @ApiOperationSupport(order=2)
    @Operation(summary="\u90e8\u7f72\u6d41\u7a0bXML", description="\u6d41\u7a0b\u8bbe\u8ba1\u5668\u90e8\u7f72\u6d41\u7a0b")
    @PutMapping(value={"deploy"}, consumes={"application/xml"})
    public Result deploy(@RequestBody String xmlData) throws Exception {
        ProcessDefinition lastProcessDefinition;
        String resourceName = MD5Util.computeMD5((String)xmlData) + ".bpmn20.xml";
        String deploymentId = this.repositoryService.createDeployment().addString(resourceName, xmlData).deploy().getId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
        if (processDefinition.getVersion() != 1 && StringUtils.hasLength((String)(lastProcessDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinition.getKey()).processDefinitionVersion(Integer.valueOf(processDefinition.getVersion() - 1)).singleResult()).getCategory())) {
            this.repositoryService.setProcessDefinitionCategory(processDefinition.getId(), lastProcessDefinition.getCategory());
        }
        return Result.ok((String)"\u90e8\u7f72\u6210\u529f", (Object)deploymentId);
    }

    @ApiOperationSupport(order=13)
    @Operation(summary="\u6839\u636e\u6d41\u7a0bKEY\u83b7\u53d6\u5b9a\u4e49XML", description="\u6d41\u7a0b\u8bbe\u8ba1\u5668\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49xml\u8d44\u6e90")
    @GetMapping(value={"{processKey}.xml"})
    public void getDeployXMLByKey(@PathVariable(value="processKey") String processKey, HttpServletResponse response) throws Exception, IOException {
        ProcessDefinition process = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().latestVersion().processDefinitionKey(processKey).singleResult();
        Assert.notNull((Object)process, (String)("\u6d41\u7a0b\u672a\u5b9a\u4e49\uff1aprocessKey=" + processKey));
        List resourceNameList = this.repositoryService.getDeploymentResourceNames(process.getDeploymentId());
        log.debug("=======\u8d44\u6e90\u540d\u79f0\u5217\u8868\uff1a{}", (Object)resourceNameList);
        InputStream in = this.repositoryService.getResourceAsStream(process.getDeploymentId(), (String)resourceNameList.get(0));
        response.setContentType("application/xml");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
        in.close();
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    @Operation(description="\u5220\u9664\u6d41\u7a0b\u90e8\u7f72")
    @DeleteMapping(value={"{deploymentId}"})
    public Result deleteDeployment(@PathVariable String deploymentId) {
        this.repositoryService.deleteDeployment(deploymentId);
        return Result.ok();
    }

    @ApiOperationSupport(order=11)
    @PostMapping(value={"deployXML"}, consumes={"application/xml"})
    public Result deployXML(@RequestBody String xmlData) throws Exception {
        String resourceName = MD5.create().digestHex(xmlData) + ".bpmn20.xml";
        String deploymentId = this.repositoryService.createDeployment().addString(resourceName, xmlData).deploy().getId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
        Map processAttributes = FlowUtils.getProcessAttributes((ProcessDefinition)processDefinition);
        String sourceCode = (String)processAttributes.get("sourceCode");
        this.repositoryService.setProcessDefinitionCategory(processDefinition.getId(), sourceCode);
        return Result.ok((String)"\u90e8\u7f72\u6210\u529f", (Object)deploymentId);
    }

    @ApiOperationSupport(order=6)
    @Operation(description="\u6839\u636e\u6d41\u7a0bKEY\u83b7\u53d6\u7528\u6237\u4efb\u52a1\u8282\u70b9(\u5e9f)")
    @GetMapping(value={"getUserTaskOld/{processKey}"})
    public Result getUserTaskOld(@PathVariable(value="processKey") String processKey) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().singleResult();
        List processes = this.repositoryService.getBpmnModel(processDefinition.getId()).getProcesses();
        ArrayList<FlowElement> useTaskList = new ArrayList<FlowElement>();
        for (Process process : processes) {
            Collection flowElements = process.getFlowElements();
            if (!CollectionUtil.isNotEmpty((Collection)flowElements)) continue;
            for (FlowElement flowElement : flowElements) {
                if (flowElement instanceof UserTask) {
                    log.debug("userTask:{}", (Object)flowElement.getName());
                    useTaskList.add(flowElement);
                }
                if (!(flowElement instanceof SubProcess)) continue;
            }
        }
        return Result.ok((String)"SUCCESS", useTaskList.stream().map(p -> BeanUtil.beanToMap((Object)p, (String[])new String[]{"id", "name"})).collect(Collectors.toList()));
    }

    @Operation(summary="\u901a\u8fc7stringBPMN\u6dfb\u52a0\u6d41\u7a0b\u5b9a\u4e49")
    @PostMapping(value={"/addDeploymentByString"})
    public Result addDeploymentByString(@RequestParam(value="stringBPMN") String stringBPMN) {
        this.processDefService.addDeploymentByString(stringBPMN);
        return Result.ok();
    }

    @Operation(summary="\u4e0a\u4f20\u5e76\u90e8\u7f72\u6d41\u7a0b\u5b9a\u4e49")
    @PostMapping(value={"/uploadStreamAndDeployment"})
    public Result uploadStreamAndDeployment(@RequestParam(value="file") MultipartFile file) throws IOException {
        this.processDefService.uploadStreamAndDeployment(file);
        return Result.ok();
    }

    @Operation(summary="\u6d41\u7a0b\u5b9a\u4e49\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/definitionPage"})
    public Result<PageData<FlowProcess>> definitionPage(@RequestBody DefinitionParamQuery query) {
        PageData results = this.processDefService.definitionPage(query);
        return Result.okData((Object)results);
    }

    @Operation(summary="\u6839\u636e\u6d41\u7a0b\u90e8\u7f72ID\u5220\u9664\u90e8\u7f72\u7684\u5de5\u4f5c\u6d41")
    @DeleteMapping(value={"/remove/{deploymentId}"})
    public Result delDefinition(@PathVariable(value="deploymentId") String deploymentId) {
        this.processDefService.deleteProcessDefinitionById(deploymentId);
        return Result.ok();
    }

    @Operation(summary="\u7269\u7406\u5f3a\u5236\u7ea7\u8054\u5220\u9664")
    @DeleteMapping(value={"/cascadeDelete/{deploymentId}"})
    public Result cascadeDelete(@PathVariable(value="deploymentId") String deploymentId) {
        this.processDefService.cascadeDelete(deploymentId);
        return Result.ok();
    }

    @Operation(summary="\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49XML")
    @GetMapping(value={"/getDefinitionXML"})
    public void getProcessDefineXML(HttpServletResponse response, @RequestParam(value="deploymentId") String deploymentId, @RequestParam(value="resourceName") String resourceName) throws IOException {
        this.processDefService.getProcessDefineXML(response, deploymentId, resourceName);
    }

    @Operation(description="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49KEY\u83b7\u53d6\u7528\u6237\u4efb\u52a1\u8282\u70b9")
    @GetMapping(value={"/getUserTask/{processDefinitionKey}"})
    public Result<List<HistoricActivityVO>> getUserTask(@PathVariable(value="processDefinitionKey") String processDefinitionKey) {
        List results = this.processDefService.getUserTask(processDefinitionKey);
        return Result.okData((Object)results);
    }

    public ProcessDefController(ProcessDefService processDefService, RepositoryService repositoryService, ProcessEngine processEngine) {
        this.processDefService = processDefService;
        this.repositoryService = repositoryService;
        this.processEngine = processEngine;
    }
}

