/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.github.xiaoymin.knife4j.annotations.Ignore;
import com.njhm.workflow.dto.FlowProcess;
import com.njhm.workflow.dto.FlowProcessInstance;
import com.njhm.workflow.dto.FlowRuntimeInfo;
import com.njhm.workflow.dto.FlowTaskInfo;
import com.njhm.workflow.dto.comm.ProcessStartForm;
import com.njhm.workflow.enums.BusinessStatusEnum;
import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.query.InstanceParamQuery;
import com.njhm.workflow.service.ProcessInstanceService;
import com.njhm.workflow.service.WorkflowService;
import com.njhm.workflow.utils.ConvertUtils;
import com.njhm.workflow.utils.FlowUtils;
import com.njhm.workflow.utils.PageData;
import com.njhm.workflow.utils.Result;
import com.njhm.workflow.vo.HistoricActivityVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.IOUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceQuery;
import org.flowable.image.impl.DefaultProcessDiagramGenerator;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/processInstanceInf"})
@Tag(name="\u8fd0\u884c\u4e2d\u6d41\u7a0b\u7ba1\u7406")
public class ProcessInstanceController {
    private static final Logger log = LoggerFactory.getLogger(ProcessInstanceController.class);
    @Autowired
    private ProcessInstanceService processInstanceService;
    private final RuntimeService runtimeService;
    private final HistoryService historyService;
    private final WorkflowService workflowService;
    private final TaskService taskService;

    @Operation(summary="\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868")
    @GetMapping(value={"/page"})
    @Parameters(value={@Parameter(description="\u9875\u7801,\u4ece1\u5f00\u59cb", name="page", in=ParameterIn.QUERY, required=true), @Parameter(description="\u5206\u9875\u5927\u5c0f", name="limit", in=ParameterIn.QUERY, required=true), @Parameter(description="\u6d41\u7a0b\u5b9a\u4e49\u540d\u79f0", name="processDefinitionName", in=ParameterIn.QUERY), @Parameter(description="\u6d41\u7a0b\u5b9a\u4e49KEY", name="processDefinitionKey", in=ParameterIn.QUERY), @Parameter(description="\u6d41\u7a0b\u5b9e\u4f8b\u540d\u79f0", name="processInstanceName", in=ParameterIn.QUERY), @Parameter(description="\u4e1a\u52a1KEY", name="businessKey", in=ParameterIn.QUERY), @Parameter(description="\u6d41\u7a0b\u5b9e\u4f8b\u53d1\u8d77\u4eba", name="startUserId", in=ParameterIn.QUERY)})
    public Result<PageData<FlowProcessInstance>> page(@RequestParam(required=false) @Ignore Map<String, Object> params) {
        ArrayList<FlowProcessInstance> results = new ArrayList<FlowProcessInstance>();
        int pageNo = MapUtils.getInteger(params, (Object)"page", (Integer)1);
        int pageSize = MapUtils.getInteger(params, (Object)"limit", (Integer)10);
        ProcessInstanceQuery queryCondition = this.runtimeService.createProcessInstanceQuery();
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"processDefinitionName"))) {
            queryCondition.processDefinitionName(MapUtils.getString(params, (Object)"processDefinitionName"));
        }
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"processDefinitionKey"))) {
            queryCondition.processDefinitionKey(MapUtils.getString(params, (Object)"processDefinitionKey"));
        }
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"processInstanceName"))) {
            queryCondition.processInstanceNameLike("%" + MapUtils.getString(params, (Object)"processInstanceName") + "%");
        }
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"businessKey"))) {
            queryCondition.processInstanceBusinessKey(MapUtils.getString(params, (Object)"businessKey"));
        }
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"startUserId"))) {
            queryCondition.startedBy(MapUtils.getString(params, (Object)"startUserId"));
        }
        long total = queryCondition.list().size();
        int start = (pageNo - 1) * pageSize;
        List instanceList = ((ProcessInstanceQuery)queryCondition.includeProcessVariables().orderByProcessDefinitionId().orderByStartTime().desc()).listPage(start, pageSize);
        for (ProcessInstance instance : instanceList) {
            List tasks;
            FlowProcessInstance info = new FlowProcessInstance(instance);
            Map processVariables = instance.getProcessVariables();
            if (processVariables.size() > 0) {
                info.setProcessVariables(processVariables);
            }
            if ((tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instance.getProcessInstanceId())).list()).size() > 0) {
                Object taskName = "";
                Object assignee = "";
                for (Task t : tasks) {
                    taskName = (String)taskName + t.getName() + ",";
                    assignee = (String)assignee + t.getAssignee() + ",";
                }
                taskName = ((String)taskName).substring(0, ((String)taskName).length() - 1);
                assignee = ((String)assignee).substring(0, ((String)assignee).length() - 1);
                info.setCurrentTaskAlias((String)taskName);
                info.setAssignee((String)assignee);
            }
            results.add(info);
        }
        PageData page = new PageData(results, total);
        return Result.okData((Object)page);
    }

    @Operation(summary="\u67e5\u8be2\u5df2\u5b8c\u6210\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868")
    @GetMapping(value={"/historicPage"})
    @Parameters(value={@Parameter(description="\u9875\u7801,\u4ece1\u5f00\u59cb", name="page", in=ParameterIn.QUERY, required=true), @Parameter(description="\u5206\u9875\u5927\u5c0f", name="limit", in=ParameterIn.QUERY, required=true), @Parameter(description="\u6d41\u7a0bkey", name="processKey", in=ParameterIn.QUERY), @Parameter(description="\u6d41\u7a0b\u542f\u52a8\u8005ID\uff0c\u9ed8\u8ba4\u4e3a\u5f53\u524d\u767b\u5f55\u7528\u6237", name="startUserId", in=ParameterIn.QUERY), @Parameter(description="\u6d41\u7a0b\u540d\u79f0", name="processInstanceName", in=ParameterIn.QUERY), @Parameter(description="\u4e1a\u52a1\u4e3b\u952e", name="businessKey", in=ParameterIn.QUERY)})
    public Result<PageData<FlowProcessInstance>> historypage(@RequestParam(required=false) @Ignore Map<String, Object> params) {
        String startUserId;
        int pageNo = MapUtils.getInteger(params, (Object)"page", (Integer)1);
        int pageSize = MapUtils.getInteger(params, (Object)"limit", (Integer)10);
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery().finished();
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"processKey"))) {
            historicProcessInstanceQuery.processDefinitionKey(MapUtils.getString(params, (Object)"processKey"));
        }
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"processInstanceName"))) {
            historicProcessInstanceQuery.processDefinitionName(MapUtils.getString(params, (Object)"processInstanceName"));
        }
        if (StringUtils.hasLength((String)(startUserId = MapUtils.getString(params, (Object)"startUserId")))) {
            historicProcessInstanceQuery.startedBy(startUserId);
        }
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"businessKey"))) {
            historicProcessInstanceQuery.processInstanceBusinessKey(MapUtils.getString(params, (Object)"businessKey"));
        }
        long count = historicProcessInstanceQuery.count();
        ArrayList<FlowProcessInstance> processInstances = new ArrayList<FlowProcessInstance>();
        if (count > 0L) {
            List list = ((HistoricProcessInstanceQuery)historicProcessInstanceQuery.includeProcessVariables().orderByProcessInstanceEndTime().desc()).listPage(Math.max((pageNo - 1) * pageSize, 0), pageSize);
            for (HistoricProcessInstance processInstance : list) {
                FlowProcessInstance inst = (FlowProcessInstance)ConvertUtils.sourceToTarget((Object)processInstance, FlowProcessInstance.class);
                inst.setStartUserName(MapUtils.getString((Map)processInstance.getProcessVariables(), (Object)"startUserName"));
                processInstances.add(inst);
            }
        }
        PageData page = new PageData(processInstances, count);
        return Result.okData((Object)page);
    }

    @Operation(summary="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u8be6\u7ec6")
    @Parameters(value={@Parameter(description="\u6d41\u7a0b\u5b9e\u4f8bID", name="processInstanceId", required=true, in=ParameterIn.QUERY), @Parameter(description="\u662f\u5426\u5305\u542b\u6d41\u7a0b\u53d8\u91cf true:\u5305\u542b false:\u4e0d\u5305\u542b", name="includeVariables", in=ParameterIn.QUERY)})
    @GetMapping(value={"{processInstanceId}"})
    public Result<FlowProcessInstance> getInfo(@PathVariable(value="processInstanceId") String processInstanceId, @RequestParam(defaultValue="false") boolean includeVariables) {
        FlowProcessInstance processInstance = this.workflowService.getProcessInstanceById(processInstanceId, includeVariables);
        if (processInstance == null) {
            throw new BizException(10020);
        }
        FlowProcessInstance flowProcessInstance = (FlowProcessInstance)ConvertUtils.sourceToTarget((Object)processInstance, FlowProcessInstance.class);
        List historyTaskList = this.workflowService.getHistoryTaskList(processInstanceId, true);
        flowProcessInstance.setHistoryTaskList(historyTaskList);
        flowProcessInstance.setCurrentTask((FlowTaskInfo)CollectionUtil.getLast((Collection)historyTaskList));
        return Result.okData((Object)flowProcessInstance);
    }

    @Operation(summary="\u64a4\u9500\u5ba1\u6279\u7533\u8bf7", description="\u64a4\u9500\u5e76\u7ed3\u675f\u6d41\u7a0b\u5ba1\u6279")
    @Parameters(value={@Parameter(name="processInstanceId", description="\u6d41\u7a0b\u5b9e\u4f8bID", in=ParameterIn.PATH)})
    @DeleteMapping(value={"cancel/{processInstanceId}"})
    public Result doCancel(@PathVariable(value="processInstanceId") String processInstanceId) {
        if (!this.workflowService.isProcessInstanceExist(processInstanceId)) {
            throw new BizException(10020);
        }
        this.workflowService.deleteProcessInstance(processInstanceId, BusinessStatusEnum.CANCELLED);
        return Result.ok();
    }

    @Operation(summary="\u7ec8\u6b62\u5ba1\u6279\u7533\u8bf7", description="\u7ed3\u675f\u6d41\u7a0b\u5ba1\u6279")
    @Parameters(value={@Parameter(name="processInstanceId", description="\u6d41\u7a0b\u5b9e\u4f8bID", in=ParameterIn.PATH)})
    @DeleteMapping(value={"ending/{processInstanceId}"})
    public Result doEnding(@PathVariable(value="processInstanceId") String processInstanceId) {
        if (!this.workflowService.isProcessInstanceExist(processInstanceId)) {
            throw new BizException(10020);
        }
        this.workflowService.deleteProcessInstance(processInstanceId, BusinessStatusEnum.CANCELLED);
        return Result.ok();
    }

    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u5ba1\u6279\u4efb\u52a1")
    @GetMapping(value={"getCurrentTask"})
    public Result<FlowTaskInfo> getCurrentTask(@RequestParam String processInstId) {
        Task currentTask = this.workflowService.getCurrentTask(processInstId);
        return Result.okData((Object)ConvertUtils.sourceToTarget((Object)currentTask, FlowTaskInfo.class));
    }

    @Operation(summary="\u6d41\u7a0b\u8fd0\u884c\u65f6\u56fe", deprecated=true)
    @GetMapping(value={"{processInstanceId}/diagram"})
    public void findProcessImage(@PathVariable String processInstanceId, HttpServletResponse response) throws Exception {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new BizException(10020);
        }
        BpmnModel bpmnModel = FlowUtils.getBpmnModel((String)processInstance.getProcessDefinitionId());
        DefaultProcessDiagramGenerator defaultProcessDiagramGenerator = new DefaultProcessDiagramGenerator();
        String imageType = "png";
        ArrayList highLightedActivities = new ArrayList();
        ArrayList highLightedFlows = new ArrayList();
        List hisActInsList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        hisActInsList.forEach(historicActivityInstance -> {
            if ("sequenceFlow".equals(historicActivityInstance.getActivityType())) {
                highLightedFlows.add(historicActivityInstance.getActivityId());
            } else {
                highLightedActivities.add(historicActivityInstance.getActivityId());
            }
        });
        String activityFontName = "\u5b8b\u4f53";
        String labelFontName = "\u5fae\u8f6f\u96c5\u9ed1";
        String annotationFontName = "\u5b8b\u4f53";
        double scaleFactor = 1.0;
        boolean drawSequenceFlowNameWithNoLabelDI = true;
        InputStream inputStream = defaultProcessDiagramGenerator.generateDiagram(bpmnModel, imageType, highLightedActivities, highLightedFlows, activityFontName, labelFontName, annotationFontName, null, scaleFactor, drawSequenceFlowNameWithNoLabelDI);
        response.setContentType("image/png");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        IOUtils.copy((InputStream)inputStream, (OutputStream)response.getOutputStream());
        inputStream.close();
        response.getOutputStream().flush();
        response.getOutputStream().close();
    }

    @Operation(summary="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u8fd0\u884c\u65f6\u8be6\u7ec6")
    @GetMapping(value={"/runtime/{processInstanceId}"})
    public Result<FlowRuntimeInfo> getFlowRuntimeInfo(@PathVariable(value="processInstanceId") String processInstanceId, @RequestParam(defaultValue="false") boolean includeProcessInstance) {
        return Result.okData((Object)this.workflowService.getFlowRuntimeInfo(processInstanceId, includeProcessInstance));
    }

    @Operation(summary="\u53d1\u8d77\u6d41\u7a0b\u5b9e\u4f8b")
    @PostMapping(value={"/startProcessInstance"})
    public Result<FlowProcessInstance> startProcessInstance(@RequestBody ProcessStartForm form) {
        FlowProcessInstance result = this.processInstanceService.startProcessInstance(form);
        return Result.okData((Object)result);
    }

    @Operation(summary="\u6d41\u7a0b\u5b9e\u4f8b\u5524\u9192")
    @GetMapping(value={"/run/{processInstanceId}"})
    public Result run(@PathVariable String processInstanceId) {
        this.processInstanceService.run(processInstanceId);
        return Result.okMsg((String)"\u5524\u9192\u6d41\u7a0b\u5b9e\u4f8b\u6210\u529f\uff01");
    }

    @Operation(summary="\u6d41\u7a0b\u5b9e\u4f8b\u6302\u8d77")
    @GetMapping(value={"/suspend/{processInstanceId}"})
    public Result suspend(@PathVariable String processInstanceId) {
        this.processInstanceService.suspend(processInstanceId);
        return Result.okMsg((String)"\u6302\u8d77\u6d41\u7a0b\u5b9e\u4f8b\u6210\u529f");
    }

    @Operation(summary="\u8fd0\u884c\u4e2d\u7684\u6d41\u7a0b\u5b9e\u4f8b\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/instancePage"})
    public Result<PageData<FlowProcessInstance>> instancePage(@RequestBody InstanceParamQuery query) {
        PageData results = this.processInstanceService.instancePage(query);
        return Result.okData((Object)results);
    }

    @Operation(summary="\u5df2\u5b8c\u6210\u7684\u6d41\u7a0b\u5b9e\u4f8b\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/instanceFinishedPage"})
    public Result<PageData<FlowProcessInstance>> instanceFinishedPage(@RequestBody InstanceParamQuery query) {
        PageData results = this.processInstanceService.instanceFinishedPage(query);
        return Result.okData((Object)results);
    }

    @Operation(summary="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49Key\u548c\u4e1a\u52a1key\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f")
    @GetMapping(value={"/instanceInfoByKey"})
    public Result<FlowProcessInstance> instanceInfoByKey(@RequestParam(value="processDefinitionKey") String processDefinitionKey, @RequestParam(value="businessKey") String businessKey) {
        FlowProcessInstance result = this.processInstanceService.instanceInfoByKey(processDefinitionKey, businessKey);
        return Result.okData((Object)result);
    }

    @Operation(summary="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f")
    @GetMapping(value={"/getDefinitions/{instanceId}"})
    public Result<FlowProcess> getDefinitionsByInstanceId(@PathVariable(value="instanceId") String instanceId) {
        FlowProcess result = this.processInstanceService.getDefinitionsByInstanceId(instanceId);
        return Result.okData((Object)result);
    }

    @Operation(summary="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bIds\u83b7\u53d6\u4efb\u52a1\u8be6\u60c5")
    @PostMapping(value={"/getTaskInfosByInstanceIds"})
    public Result<List<FlowTaskInfo>> getTaskInfosByInstanceIds(@RequestBody List<String> instanceIds) {
        List results = this.processInstanceService.getTaskInfosByInstanceIds(instanceIds);
        return Result.okData((Object)results);
    }

    @Operation(summary="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID\u83b7\u53d6\u5df2\u7ecf\u6267\u884c\u7684\u8282\u70b9")
    @GetMapping(value={"/getHistoricActivity"})
    public Result<List<HistoricActivityVO>> getHistoricActivity(@RequestParam(value="instanceId") String instanceId) {
        List results = this.processInstanceService.getHistoricActivity(instanceId);
        return Result.okData((Object)results);
    }

    @Operation(summary="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bID\u83b7\u53d6\u7f51\u5173\u8df3\u8f6c\u6761\u4ef6")
    @GetMapping(value={"/getGetewayCondition"})
    public Result<Set<String>> getGetewayCondition(@RequestParam(value="instanceId") String instanceId) {
        Set results = this.processInstanceService.getGetewayCondition(instanceId);
        return Result.okData((Object)results);
    }

    @Operation(summary="\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid\u751f\u6210\u6d41\u7a0b\u8ffd\u8e2a\u56fe")
    @GetMapping(value={"/generateFlowChart"})
    public Result generateFlowChart(@RequestParam(value="processInstanceId") String processInstanceId, OutputStream outputStream) {
        this.processInstanceService.generateFlowChart(processInstanceId, outputStream);
        return Result.ok();
    }

    @Operation(summary="\u8bbe\u7f6e\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u4eba;body\uff1a {taskxxx:1212121}")
    @PostMapping(value={"setApproveUsers"})
    public Result setTaskAssignee(@RequestParam(value="processInstanceId") String processInstanceId, @RequestBody Map<String, Object> params) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        List userTask = FlowUtils.getUserTask((String)processInstance.getProcessDefinitionKey());
        Set taskKeySet = userTask.stream().map(BaseElement::getId).collect(Collectors.toSet());
        params.keySet().parallelStream().forEach(taskKey -> {
            if (taskKeySet.contains(taskKey)) {
                String key = taskKey + "Assignee";
                this.runtimeService.setVariable(processInstanceId, key, params.get(taskKey));
            } else {
                this.runtimeService.setVariable(processInstanceId, taskKey, params.get(taskKey));
            }
        });
        return Result.ok();
    }

    @Operation(summary="\u8bbe\u7f6e\u6d41\u7a0b\u8282\u70b9\u53d8\u91cfbody\uff1a {taskxxx:1212121}")
    @PostMapping(value={"setProcessVariables"})
    public Result setProcessInstanceVariables(@RequestParam(value="processInstanceId") String processInstanceId, @RequestBody Map<String, Object> params) {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        List userTask = FlowUtils.getUserTask((String)processInstance.getProcessDefinitionKey());
        Set taskKeySet = userTask.stream().map(BaseElement::getId).collect(Collectors.toSet());
        params.keySet().parallelStream().forEach(taskKey -> {
            if (taskKeySet.contains(taskKey)) {
                String key = taskKey + "Assignee";
                log.debug("\u8bbe\u7f6e\u6d41\u7a0b\u8282\u70b9\u5ba1\u6279\u4eba\uff1a{}", (Object)key, params.get(taskKey));
                String taskAssignee = Objects.toString(params.remove(taskKey));
                params.put(key, taskAssignee);
            }
        });
        this.runtimeService.setVariables(processInstanceId, params);
        return Result.ok();
    }

    public ProcessInstanceController(ProcessInstanceService processInstanceService, RuntimeService runtimeService, HistoryService historyService, WorkflowService workflowService, TaskService taskService) {
        this.processInstanceService = processInstanceService;
        this.runtimeService = runtimeService;
        this.historyService = historyService;
        this.workflowService = workflowService;
        this.taskService = taskService;
    }
}

