/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.njhm.workflow.dto.WorkflowButtonDTO;
import com.njhm.workflow.entity.WorkflowButton;
import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.query.WorkflowButtonQuery;
import com.njhm.workflow.service.WorkflowButtonService;
import com.njhm.workflow.utils.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/buttons"})
@Tag(name="\u6309\u94ae\u7ba1\u7406")
public class WorkflowButtonController {
    @Autowired
    private WorkflowButtonService buttonInfoService;

    @GetMapping
    @Operation(summary="\u67e5\u8be2\u6309\u94ae")
    @Parameters(value={@Parameter(name="status", description="\u6309\u94ae\u72b6\u6001,1\u542f\u75280\u7981\u7528 \u4e0d\u4f20\u5165\u8868\u793a\u67e5\u8be2\u6240\u6709", in=ParameterIn.QUERY, required=true)})
    public Result<List<WorkflowButton>> findAll(@RequestParam(required=false) Integer status) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.buttonInfoService.lambdaQuery().orderByAsc(WorkflowButton::getId)).eq(status != null, WorkflowButton::getStatus, (Object)status)).list();
        return Result.okData((Object)list);
    }

    @PostMapping(value={"/{id}/enable"})
    @Operation(summary="\u542f\u7528\u6309\u94ae")
    public Result enable(@PathVariable(value="id") Long id) {
        this.buttonInfoService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(WorkflowButton::getId, (Object)id)).set(WorkflowButton::getStatus, (Object)1));
        return Result.ok();
    }

    @PostMapping(value={"/{id}/disable"})
    @Operation(summary="\u7981\u7528\u6309\u94ae")
    public Result disable(@PathVariable(value="id") Long id) {
        this.buttonInfoService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(WorkflowButton::getId, (Object)id)).set(WorkflowButton::getStatus, (Object)0));
        return Result.ok();
    }

    @Operation(description="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/getList"})
    public Result<List<WorkflowButton>> getList(@RequestBody WorkflowButtonQuery query) {
        List models = this.buttonInfoService.getList(query);
        return Result.okData((Object)models);
    }

    @Operation(description="\u67e5\u8be2")
    @GetMapping(value={"/getById"})
    public Result<WorkflowButton> getById(@RequestParam(value="id") Long id) {
        WorkflowButton entity = (WorkflowButton)this.buttonInfoService.getById((Serializable)id);
        return Result.okData((Object)entity);
    }

    @Operation(description="\u65b0\u589e")
    @PostMapping(value={"/add"})
    public Result save(@RequestBody WorkflowButtonDTO dto) {
        this.buttonInfoService.addButtonEntity(dto);
        return Result.ok();
    }

    @Operation(description="\u66f4\u65b0")
    @PostMapping(value={"/updateById"})
    public Result updateById(@RequestBody WorkflowButtonDTO dto) {
        this.buttonInfoService.updateButtonEntity(dto);
        return Result.ok();
    }

    @Operation(description="\u5220\u9664")
    @GetMapping(value={"/deleteById"})
    public Result deleteById(@RequestParam(value="id") Long id) {
        WorkflowButton byId = (WorkflowButton)this.buttonInfoService.getById((Serializable)id);
        if (byId == null) {
            throw new BizException("\u83b7\u53d6\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        this.buttonInfoService.removeById((Object)byId);
        return Result.ok();
    }
}

