/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.controller;

import com.njhm.workflow.dto.comm.ProcessRoleComm;
import com.njhm.workflow.dto.comm.ProcessUserComm;
import com.njhm.workflow.dto.event.FlowNoticeEvent;
import com.njhm.workflow.service.WorkflowCommService;
import com.njhm.workflow.utils.PageData;
import com.njhm.workflow.utils.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/comm"})
@Tag(name="\u516c\u5171\u7ba1\u7406")
public class WorkflowCommController {
    @Autowired
    private WorkflowCommService workflowCommService;

    @Operation(summary="\u83b7\u53d6\u4eba\u5458")
    @GetMapping(value={"/findUserList"})
    public Result<PageData<ProcessUserComm>> findUserList(@RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="userName", required=false) String userName) {
        PageData results = this.workflowCommService.findUserList(pageNum, pageSize, userName);
        return Result.okData((Object)results);
    }

    @Operation(summary="\u83b7\u53d6\u89d2\u8272")
    @GetMapping(value={"/findRoleList"})
    public Result<PageData<ProcessRoleComm>> findRoleList(@RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize, @RequestParam(value="roleName", required=false) String roleName) {
        PageData results = this.workflowCommService.findRoleList(pageNum, pageSize, roleName);
        return Result.okData((Object)results);
    }

    @Operation(summary="\u6839\u636e\u89d2\u8272\u83b7\u53d6\u4eba\u5458")
    @GetMapping(value={"/findUserByRoleId"})
    public Result<List<ProcessUserComm>> findUserByRoleId(@RequestParam(value="roleId") String roleId) {
        List results = this.workflowCommService.findUserByRoleId(roleId);
        return Result.okData((Object)results);
    }

    @Operation(summary="\u5de5\u4f5c\u6d41\u56de\u8c03")
    @PostMapping(value={"/workflowCallBack"})
    public Result workflowCallBack(@RequestBody FlowNoticeEvent data) {
        this.workflowCommService.workflowCallBack(data);
        return Result.ok();
    }
}

