/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.listener;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.njhm.workflow.dto.comm.ProcessButtonComm;
import com.njhm.workflow.dto.comm.ProcessRoleComm;
import com.njhm.workflow.dto.comm.ProcessUserComm;
import com.njhm.workflow.dto.event.FlowNoticeEvent;
import com.njhm.workflow.dto.event.FlowTaskNotice;
import com.njhm.workflow.enums.BusinessCommEnum;
import com.njhm.workflow.enums.BusinessStatusEnum;
import com.njhm.workflow.enums.CallbackTypeEnum;
import com.njhm.workflow.security.SecurityUser;
import com.njhm.workflow.service.ProcessTaskService;
import com.njhm.workflow.service.UndoTaskService;
import com.njhm.workflow.service.WorkflowCommService;
import com.njhm.workflow.utils.CommUtils;
import com.njhm.workflow.utils.FlowEventUtil;
import com.njhm.workflow.utils.FlowUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEntityEvent;
import org.flowable.common.engine.impl.event.FlowableEntityEventImpl;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.delegate.event.AbstractFlowableEngineEventListener;
import org.flowable.engine.delegate.event.FlowableCancelledEvent;
import org.flowable.engine.delegate.event.FlowableProcessStartedEvent;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.task.Comment;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class GlobalFlowableListener
extends AbstractFlowableEngineEventListener {
    private static final Logger log = LoggerFactory.getLogger(GlobalFlowableListener.class);
    @Autowired
    @Lazy
    private RuntimeService runtimeService;
    @Autowired
    @Lazy
    private RepositoryService repositoryService;
    @Autowired
    @Lazy
    private TaskService taskService;
    @Autowired
    @Lazy
    private HistoryService historyService;
    @Autowired
    @Lazy
    private ProcessTaskService processTaskService;
    @Autowired
    @Lazy
    private FlowEventUtil flowEventUtil;
    @Autowired
    @Lazy
    private UndoTaskService undoTaskService;
    @Autowired
    @Lazy
    private WorkflowCommService workflowCommService;

    protected void processStarted(FlowableProcessStartedEvent event) {
        JSONArray array;
        List entities;
        List defaultCctoIds;
        String defaultCcto;
        log.info("\u6d41\u7a0b\u5b9e\u4f8b\u53d1\u8d77\u76d1\u542c");
        String eventName = event.getType().name();
        ExecutionEntityImpl executionEntity = (ExecutionEntityImpl)event.getEntity();
        String instanceId = executionEntity.getProcessInstanceId();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().includeProcessVariables().processInstanceId(instanceId).singleResult();
        log.info("\u6d41\u7a0b\u5b9e\u4f8bID\uff1a{},\u6d41\u7a0b\u5b9e\u4f8b\u53d1\u8d77\u4eba\uff1a{},\u4e1a\u52a1\u4e3b\u952e\uff1a{}", new Object[]{instance.getProcessInstanceId(), instance.getStartUserId(), instance.getBusinessKey()});
        FlowNoticeEvent flowNoticeEvent = new FlowNoticeEvent();
        flowNoticeEvent.setEvent(BusinessCommEnum.FlowEventTypeEnum.PP_1.getCode());
        FlowTaskNotice flowTaskNotice = new FlowTaskNotice(instance);
        flowTaskNotice.setEventName(eventName);
        flowTaskNotice.setBusinessStatus(BusinessStatusEnum.APPROVING.name());
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instance.getProcessInstanceId())).list();
        if (tasks.size() > 0) {
            Object taskName = "";
            Object assignee = "";
            for (Task t : tasks) {
                taskName = (String)taskName + t.getName() + ",";
                assignee = (String)assignee + t.getAssignee() + ",";
            }
            taskName = ((String)taskName).substring(0, ((String)taskName).length() - 1);
            assignee = ((String)assignee).substring(0, ((String)assignee).length() - 1);
            flowTaskNotice.setCurrentTaskAlias((String)taskName);
            flowTaskNotice.setAssignee((String)assignee);
        }
        if (StringUtils.isNotBlank((CharSequence)(defaultCcto = FlowUtils.getProcessAttributeValue((String)instance.getProcessDefinitionId(), (String)BusinessCommEnum.ProcessAttrEnum.PP_7.getCode()))) && !"null".equals(defaultCcto) && CollectionUtils.isNotEmpty(defaultCctoIds = (entities = JSONUtil.toList((JSONArray)(array = JSONUtil.parseArray((String)defaultCcto)), ProcessUserComm.class)).stream().map(s -> s.getId()).collect(Collectors.toList()))) {
            for (String defaultCctoId : defaultCctoIds) {
                this.undoTaskService.sendCcToUser(executionEntity, defaultCctoId);
            }
            flowTaskNotice.setDefaultCcto(StringUtils.join(defaultCctoIds, (String)","));
        }
        flowNoticeEvent.setBody(flowTaskNotice);
        CallbackTypeEnum callbackType = FlowUtils.getCallbackType((String)instance.getProcessDefinitionId());
        String callbackId = FlowUtils.getCallbackId((String)instance.getProcessDefinitionId());
        log.info("\u6d41\u7a0b\u5b9e\u4f8b\u53d1\u8d77\u5f00\u59cb\u56de\u8c03\uff0c\u56de\u8c03\u5730\u5740\uff1a{} \u56de\u8c03\u7c7b\u578b\uff1a{}", (Object)callbackId, (Object)callbackType);
        this.flowEventUtil.callBack(flowNoticeEvent, callbackType, callbackId);
        this.undoTaskService.send(executionEntity);
    }

    protected void processCancelled(FlowableCancelledEvent event) {
        JSONArray array;
        List entities;
        List defaultCctoIds;
        String defaultCcto;
        log.info("\u6d41\u7a0b\u5b9e\u4f8b\u53d6\u6d88\u76d1\u542c");
        String eventName = event.getType().name();
        String instanceId = event.getProcessInstanceId();
        log.info("\u6d41\u7a0b\u5b9e\u4f8bID\uff1a{}", (Object)instanceId);
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().includeProcessVariables().processInstanceId(instanceId).singleResult();
        log.info("\u6d41\u7a0b\u5b9e\u4f8bID\uff1a{},\u6d41\u7a0b\u5b9e\u4f8b\u53d1\u8d77\u4eba\uff1a{},\u4e1a\u52a1\u4e3b\u952e\uff1a{},\u53d6\u6d88\u539f\u56e0\uff1a{}", new Object[]{instance.getProcessInstanceId(), instance.getStartUserId(), instance.getBusinessKey(), event.getCause()});
        FlowNoticeEvent flowNoticeEvent = new FlowNoticeEvent();
        flowNoticeEvent.setEvent(BusinessCommEnum.FlowEventTypeEnum.PP_2.getCode());
        FlowTaskNotice flowTaskNotice = new FlowTaskNotice(instance);
        flowTaskNotice.setEventName(eventName);
        flowTaskNotice.setBusinessStatus(BusinessStatusEnum.CANCELLED.name());
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instance.getProcessInstanceId())).list();
        if (tasks.size() > 0) {
            Object taskName = "";
            Object assignee = "";
            for (Task t : tasks) {
                taskName = (String)taskName + t.getName() + ",";
                assignee = (String)assignee + t.getAssignee() + ",";
            }
            taskName = ((String)taskName).substring(0, ((String)taskName).length() - 1);
            assignee = ((String)assignee).substring(0, ((String)assignee).length() - 1);
            flowTaskNotice.setCurrentTaskAlias((String)taskName);
            flowTaskNotice.setAssignee((String)assignee);
        }
        if (StringUtils.isNotBlank((CharSequence)(defaultCcto = FlowUtils.getProcessAttributeValue((String)instance.getProcessDefinitionId(), (String)BusinessCommEnum.ProcessAttrEnum.PP_7.getCode()))) && !"null".equals(defaultCcto) && CollectionUtils.isNotEmpty(defaultCctoIds = (entities = JSONUtil.toList((JSONArray)(array = JSONUtil.parseArray((String)defaultCcto)), ProcessUserComm.class)).stream().map(s -> s.getId()).collect(Collectors.toList()))) {
            flowTaskNotice.setDefaultCcto(StringUtils.join(defaultCctoIds, (String)","));
        }
        flowNoticeEvent.setBody(flowTaskNotice);
        CallbackTypeEnum callbackType = FlowUtils.getCallbackType((String)instance.getProcessDefinitionId());
        String callbackId = FlowUtils.getCallbackId((String)instance.getProcessDefinitionId());
        log.info("\u6d41\u7a0b\u5b9e\u4f8b\u53d6\u6d88\u5f00\u59cb\u56de\u8c03\uff0c\u56de\u8c03\u5730\u5740\uff1a{} \u56de\u8c03\u7c7b\u578b\uff1a{}", (Object)callbackId, (Object)callbackType);
        this.flowEventUtil.callBack(flowNoticeEvent, callbackType, callbackId);
        this.undoTaskService.cancelAll(instanceId, Objects.toString(event.getCause()));
    }

    protected void processCompleted(FlowableEngineEntityEvent event) {
        JSONArray array;
        List entities;
        List defaultCctoIds;
        String defaultCcto;
        log.info("\u6d41\u7a0b\u5b9e\u4f8b\u7ed3\u675f\u76d1\u542c");
        String eventName = event.getType().name();
        ExecutionEntityImpl executionEntity = (ExecutionEntityImpl)event.getEntity();
        String instanceId = executionEntity.getProcessInstanceId();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().includeProcessVariables().processInstanceId(instanceId).singleResult();
        log.info("\u6d41\u7a0b\u5b9e\u4f8bID\uff1a{},\u6d41\u7a0b\u5b9e\u4f8b\u53d1\u8d77\u4eba\uff1a{},\u4e1a\u52a1\u4e3b\u952e\uff1a{}", new Object[]{instance.getProcessInstanceId(), instance.getStartUserId(), instance.getBusinessKey()});
        FlowNoticeEvent flowNoticeEvent = new FlowNoticeEvent();
        flowNoticeEvent.setEvent(BusinessCommEnum.FlowEventTypeEnum.PP_3.getCode());
        FlowTaskNotice flowTaskNotice = new FlowTaskNotice(instance);
        flowTaskNotice.setEventName(eventName);
        flowTaskNotice.setBusinessStatus(BusinessStatusEnum.ENDED.name());
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instance.getProcessInstanceId())).list();
        if (tasks.size() > 0) {
            Object taskName = "";
            Object assignee = "";
            for (Task t : tasks) {
                taskName = (String)taskName + t.getName() + ",";
                assignee = (String)assignee + t.getAssignee() + ",";
            }
            taskName = ((String)taskName).substring(0, ((String)taskName).length() - 1);
            assignee = ((String)assignee).substring(0, ((String)assignee).length() - 1);
            flowTaskNotice.setCurrentTaskAlias((String)taskName);
            flowTaskNotice.setAssignee((String)assignee);
        }
        if (StringUtils.isNotBlank((CharSequence)(defaultCcto = FlowUtils.getProcessAttributeValue((String)instance.getProcessDefinitionId(), (String)BusinessCommEnum.ProcessAttrEnum.PP_7.getCode()))) && !"null".equals(defaultCcto) && CollectionUtils.isNotEmpty(defaultCctoIds = (entities = JSONUtil.toList((JSONArray)(array = JSONUtil.parseArray((String)defaultCcto)), ProcessUserComm.class)).stream().map(s -> s.getId()).collect(Collectors.toList()))) {
            flowTaskNotice.setDefaultCcto(StringUtils.join(defaultCctoIds, (String)","));
        }
        flowNoticeEvent.setBody(flowTaskNotice);
        CallbackTypeEnum callbackType = FlowUtils.getCallbackType((String)instance.getProcessDefinitionId());
        String callbackId = FlowUtils.getCallbackId((String)instance.getProcessDefinitionId());
        log.info("\u6d41\u7a0b\u5b9e\u4f8b\u7ed3\u675f\u5f00\u59cb\u56de\u8c03\uff0c\u56de\u8c03\u5730\u5740\uff1a{} \u56de\u8c03\u7c7b\u578b\uff1a{}", (Object)callbackType);
        this.flowEventUtil.callBack(flowNoticeEvent, callbackType, callbackId);
        this.undoTaskService.resolveByProcessInstanceId(instance.getProcessInstanceId());
    }

    protected void taskCreated(FlowableEngineEntityEvent event) {
        String buttonsVal;
        String formKey;
        JSONArray array;
        List entities;
        List taskCctoIds;
        String taskCcto;
        List comments;
        Set taskCandidateGroup;
        Set taskCandidateUser;
        log.info("\u4efb\u52a1\u521b\u5efa\u76d1\u542c");
        String eventName = event.getType().name();
        FlowableEntityEventImpl flowableEntityEvent = (FlowableEntityEventImpl)event;
        TaskEntityImpl entity = (TaskEntityImpl)flowableEntityEvent.getEntity();
        String selectAssignee = "";
        String selectCandidateUser = "";
        String selectCandidateGroup = "";
        String taskId = entity.getId();
        Task t = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).taskId(taskId)).singleResult();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().includeProcessVariables().processInstanceId(t.getProcessInstanceId()).singleResult();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(instance.getProcessDefinitionId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(t.getExecutionId()).singleResult();
        String activityId = execution.getActivityId();
        FlowNode currentNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityId);
        Map attributes = currentNode.getAttributes();
        Map attrMap = CommUtils.parseAttributes((Map)attributes);
        String assignTypeVal = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_0.getCode());
        if (StringUtils.isNotBlank((CharSequence)assignTypeVal) && assignTypeVal.equals(BusinessCommEnum.AssignTypeEnum.PP_1.getCode())) {
            Map processVariables = instance.getProcessVariables();
            String startUserId = processVariables.get("startUserId").toString();
            this.taskService.setAssignee(taskId, startUserId);
        }
        String preAssigneeKey = entity.getTaskDefinitionKey() + "Assignee";
        Object preUserId = this.runtimeService.getVariable(event.getProcessInstanceId(), preAssigneeKey);
        if (!Objects.isNull(preUserId)) {
            this.taskService.setAssignee(taskId, Objects.toString(preUserId));
            t.setAssignee(Objects.toString(preUserId));
        } else {
            String roleVal;
            String userVal;
            String configTypeVal;
            if (StringUtils.isNotBlank((CharSequence)assignTypeVal) && assignTypeVal.equals(BusinessCommEnum.AssignTypeEnum.PP_2.getCode()) && StringUtils.isNotBlank((CharSequence)(configTypeVal = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_1.getCode()))) && configTypeVal.equals(BusinessCommEnum.ConfigTypeEnum.PP_1.getCode()) && StringUtils.isNotBlank((CharSequence)(userVal = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_5.getCode()))) && !"null".equals(userVal)) {
                JSONArray array2 = JSONUtil.parseArray((String)userVal);
                List entities2 = JSONUtil.toList((JSONArray)array2, ProcessUserComm.class);
                List userIds = entities2.stream().map(s -> s.getId()).collect(Collectors.toList());
                if (userIds.size() == 1) {
                    selectAssignee = (String)userIds.get(0);
                    this.taskService.setAssignee(taskId, selectAssignee);
                } else if (userIds.size() > 1) {
                    selectCandidateUser = StringUtils.join((Iterable)userIds, (String)",");
                    for (String userId : userIds) {
                        this.taskService.addCandidateUser(taskId, userId);
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)assignTypeVal) && assignTypeVal.equals(BusinessCommEnum.AssignTypeEnum.PP_3.getCode()) && StringUtils.isNotBlank((CharSequence)(roleVal = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_6.getCode()))) && !"null".equals(roleVal)) {
                JSONArray array3 = JSONUtil.parseArray((String)roleVal);
                List entities3 = JSONUtil.toList((JSONArray)array3, ProcessRoleComm.class);
                List roleIds = entities3.stream().map(s -> s.getId()).collect(Collectors.toList());
                selectCandidateGroup = StringUtils.join(roleIds, (String)",");
                for (String roleId : roleIds) {
                    this.taskService.addCandidateGroup(taskId, roleId);
                }
            }
        }
        FlowNoticeEvent flowNoticeEvent = new FlowNoticeEvent();
        flowNoticeEvent.setEvent(BusinessCommEnum.FlowEventTypeEnum.PP_4.getCode());
        FlowTaskNotice flowTaskNotice = new FlowTaskNotice(t, instance);
        flowTaskNotice.setEventName(eventName);
        String assignee = flowTaskNotice.getAssignee();
        if (StringUtils.isBlank((CharSequence)assignee) && StringUtils.isNotBlank((CharSequence)selectAssignee)) {
            flowTaskNotice.setAssignee(selectAssignee);
        }
        if (CollectionUtils.isEmpty((Collection)(taskCandidateUser = this.processTaskService.getTaskCandidate(t.getId(), Integer.valueOf(0))))) {
            if (StringUtils.isNotBlank((CharSequence)selectCandidateUser)) {
                flowTaskNotice.setCandidateUser(selectCandidateUser);
            }
        } else {
            flowTaskNotice.setCandidateUser(StringUtils.join((Iterable)taskCandidateUser, (String)","));
        }
        if (CollectionUtils.isEmpty((Collection)(taskCandidateGroup = this.processTaskService.getTaskCandidate(t.getId(), Integer.valueOf(1))))) {
            if (StringUtils.isNotBlank((CharSequence)selectCandidateGroup)) {
                flowTaskNotice.setCandidateGroups(selectCandidateGroup);
            }
        } else {
            flowTaskNotice.setCandidateGroups(StringUtils.join((Iterable)taskCandidateGroup, (String)","));
        }
        if ((comments = this.taskService.getTaskComments(t.getId())) != null && !comments.isEmpty()) {
            Comment latestComment = (Comment)comments.get(comments.size() - 1);
            flowTaskNotice.setTaskComment(latestComment.getFullMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)(taskCcto = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_8.getCode()))) && !"null".equals(taskCcto) && CollectionUtils.isNotEmpty(taskCctoIds = (entities = JSONUtil.toList((JSONArray)(array = JSONUtil.parseArray((String)taskCcto)), ProcessUserComm.class)).stream().map(s -> s.getId()).collect(Collectors.toList()))) {
            for (String taskCctoId : taskCctoIds) {
                List unCcList = this.undoTaskService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"task_id", (Object)t.getId())).eq((Object)"user_id", (Object)taskCctoId)).in((Object)"user_type", Arrays.asList(2, 3))).eq((Object)"msg_status", (Object)0));
                if (!CollectionUtils.isEmpty((Collection)unCcList)) continue;
                this.undoTaskService.sendCcToUser(taskCctoId, entity);
            }
            flowTaskNotice.setTaskCcto(StringUtils.join(taskCctoIds, (String)","));
        }
        if (StringUtils.isNotBlank((CharSequence)(formKey = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_9.getCode()))) && !"null".equals(formKey)) {
            flowTaskNotice.setDynamicFormKey(formKey);
        }
        if (StringUtils.isNotBlank((CharSequence)(buttonsVal = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_2.getCode()))) && !"null".equals(buttonsVal)) {
            JSONArray array4 = JSONUtil.parseArray((String)buttonsVal);
            List entities4 = JSONUtil.toList((JSONArray)array4, ProcessButtonComm.class);
            List buttonNames = entities4.stream().map(s -> s.getButtonName()).collect(Collectors.toList());
            flowTaskNotice.setButtonNames(StringUtils.join(buttonNames, (String)","));
            String[] buttonAnotherNames = entities4.stream().map(s -> s.getAnotherName()).collect(Collectors.toList());
            flowTaskNotice.setButtonAnotherName(StringUtils.join((Iterable)buttonAnotherNames, (String)","));
        }
        flowNoticeEvent.setBody(flowTaskNotice);
        log.info("\u6d41\u7a0b\u5b9e\u4f8bID\uff1a{},\u4efb\u52a1ID\uff1a{}", (Object)t.getProcessInstanceId(), (Object)t.getId());
        boolean callBack = FlowUtils.taskIsCallback((String)t.getId());
        if (callBack) {
            log.info("\u4efb\u52a1\u521b\u5efa\u76d1\u542c\u5f00\u59cb\u56de\u8c03");
            this.flowEventUtil.callBack(flowNoticeEvent, FlowUtils.getCallbackType((String)t.getProcessDefinitionId()), FlowUtils.getCallbackId((String)t.getProcessDefinitionId(), (String)t.getId()));
        }
        if (StringUtils.isNotBlank((CharSequence)flowTaskNotice.getAssignee())) {
            List undoList = this.undoTaskService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"task_id", (Object)t.getId())).eq((Object)"user_id", (Object)flowTaskNotice.getAssignee())).in((Object)"user_type", Arrays.asList(0, 1))).eq((Object)"status", (Object)0));
            if (CollectionUtils.isEmpty((Collection)undoList)) {
                this.undoTaskService.send(flowTaskNotice.getAssignee(), entity, Integer.valueOf(0));
            }
        } else {
            HashSet<String> toUsers = new HashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)flowTaskNotice.getCandidateUser())) {
                String[] candidateUsers;
                for (String candidateUser : candidateUsers = flowTaskNotice.getCandidateUser().split(",")) {
                    toUsers.add(candidateUser);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)flowTaskNotice.getCandidateGroups())) {
                String[] candidateGroups;
                for (String candidateGroup : candidateGroups = flowTaskNotice.getCandidateGroups().split(",")) {
                    List users = this.workflowCommService.findUserByRoleId(candidateGroup);
                    if (!CollectionUtils.isNotEmpty((Collection)users)) continue;
                    for (ProcessUserComm user : users) {
                        toUsers.add(user.getId());
                    }
                }
            }
            for (String toUser : toUsers) {
                List undoList = this.undoTaskService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"task_id", (Object)t.getId())).eq((Object)"user_id", (Object)toUser)).in((Object)"user_type", Arrays.asList(0, 1))).eq((Object)"status", (Object)0));
                if (!CollectionUtils.isEmpty((Collection)undoList)) continue;
                this.undoTaskService.send(toUser, entity, Integer.valueOf(1));
            }
        }
    }

    protected void taskCompleted(FlowableEngineEntityEvent event) {
        String buttonsVal;
        String formKey;
        JSONArray array;
        List entities;
        List taskCctoIds;
        String taskCcto;
        log.info("\u5b8c\u6210\u4efb\u52a1\u76d1\u542c");
        String eventName = event.getType().name();
        TaskEntityImpl taskEntity = (TaskEntityImpl)event.getEntity();
        String taskId = taskEntity.getId();
        Task t = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).taskId(taskId)).singleResult();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().includeProcessVariables().processInstanceId(t.getProcessInstanceId()).singleResult();
        if (instance == null) {
            log.debug(">>\u6d41\u7a0b\u5df2\u7ed3\u675f");
            return;
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(instance.getProcessDefinitionId());
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(t.getExecutionId()).singleResult();
        String activityId = execution.getActivityId();
        FlowNode currentNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityId);
        Map attributes = currentNode.getAttributes();
        Map attrMap = CommUtils.parseAttributes((Map)attributes);
        FlowNoticeEvent flowNoticeEvent = new FlowNoticeEvent();
        flowNoticeEvent.setEvent(BusinessCommEnum.FlowEventTypeEnum.PP_5.getCode());
        FlowTaskNotice flowTaskNotice = new FlowTaskNotice(t, instance);
        Map taskVars = flowTaskNotice.getTaskVariables();
        if (taskVars == null || taskVars.isEmpty()) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().includeTaskLocalVariables()).taskId(taskId)).singleResult();
            flowTaskNotice.setTaskVariables(historicTaskInstance.getTaskLocalVariables());
        }
        flowTaskNotice.setEventName(eventName);
        Set taskCandidateUser = this.processTaskService.getTaskCandidate(t.getId(), Integer.valueOf(0));
        flowTaskNotice.setCandidateUser(StringUtils.join((Iterable)taskCandidateUser, (String)","));
        Set taskCandidateGroup = this.processTaskService.getTaskCandidate(t.getId(), Integer.valueOf(1));
        flowTaskNotice.setCandidateGroups(StringUtils.join((Iterable)taskCandidateGroup, (String)","));
        List comments = this.taskService.getTaskComments(t.getId());
        if (comments != null && !comments.isEmpty()) {
            Comment latestComment = (Comment)comments.get(comments.size() - 1);
            flowTaskNotice.setTaskComment(latestComment.getFullMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)(taskCcto = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_8.getCode()))) && !"null".equals(taskCcto) && CollectionUtils.isNotEmpty(taskCctoIds = (entities = JSONUtil.toList((JSONArray)(array = JSONUtil.parseArray((String)taskCcto)), ProcessUserComm.class)).stream().map(s -> s.getId()).collect(Collectors.toList()))) {
            flowTaskNotice.setTaskCcto(StringUtils.join(taskCctoIds, (String)","));
        }
        if (StringUtils.isNotBlank((CharSequence)(formKey = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_9.getCode()))) && !"null".equals(formKey)) {
            flowTaskNotice.setDynamicFormKey(formKey);
        }
        if (StringUtils.isNotBlank((CharSequence)(buttonsVal = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_2.getCode()))) && !"null".equals(buttonsVal)) {
            JSONArray array2 = JSONUtil.parseArray((String)buttonsVal);
            List entities2 = JSONUtil.toList((JSONArray)array2, ProcessButtonComm.class);
            List buttonNames = entities2.stream().map(s -> s.getButtonName()).collect(Collectors.toList());
            flowTaskNotice.setButtonNames(StringUtils.join(buttonNames, (String)","));
            List buttonAnotherNames = entities2.stream().map(s -> s.getAnotherName()).collect(Collectors.toList());
            flowTaskNotice.setButtonAnotherName(StringUtils.join(buttonAnotherNames, (String)","));
        }
        flowNoticeEvent.setBody(flowTaskNotice);
        log.info("\u6d41\u7a0b\u5b9e\u4f8bID\uff1a{},\u4efb\u52a1ID\uff1a{}", (Object)t.getProcessInstanceId(), (Object)t.getId());
        boolean callBack = FlowUtils.taskIsCallback((String)t.getId());
        if (callBack) {
            log.info("\u5b8c\u6210\u4efb\u52a1\u76d1\u542c\u5f00\u59cb\u56de\u8c03");
            this.flowEventUtil.callBack(flowNoticeEvent, FlowUtils.getCallbackType((String)t.getProcessDefinitionId()), FlowUtils.getCallbackId((String)t.getProcessDefinitionId(), (String)t.getId()));
        }
        this.undoTaskService.resolveByTaskId(taskId);
        this.runtimeService.setVariable(event.getProcessInstanceId(), taskEntity.getTaskDefinitionKey() + "Assignee", (Object)SecurityUser.getUserId());
    }

    protected void taskAssigned(FlowableEngineEntityEvent event) {
        List undoList;
        log.info("\u8bbe\u7f6e\u6267\u884c\u4eba");
        String eventName = event.getType().name();
        TaskEntityImpl entity = (TaskEntityImpl)event.getEntity();
        String taskId = entity.getId();
        Task t = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).taskId(taskId)).singleResult();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(t.getProcessInstanceId()).singleResult();
        FlowTaskNotice flowTaskNotice = new FlowTaskNotice(t, instance);
        flowTaskNotice.setEventName(eventName);
        String assignee = flowTaskNotice.getAssignee();
        if (StringUtils.isNotBlank((CharSequence)assignee) && CollectionUtils.isEmpty((Collection)(undoList = this.undoTaskService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"task_id", (Object)t.getId())).eq((Object)"user_id", (Object)assignee)).in((Object)"user_type", Arrays.asList(0, 1))).eq((Object)"status", (Object)0))))) {
            this.undoTaskService.send(assignee, entity, Integer.valueOf(0));
        }
    }
}

