/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.njhm.workflow.dto.FlowCategory;
import com.njhm.workflow.dto.FlowProcess;
import com.njhm.workflow.enums.BusinessCommEnum;
import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.mapper.ActReDeploymentMapper;
import com.njhm.workflow.mapper.ActRunTaskMapper;
import com.njhm.workflow.query.DefinitionParamQuery;
import com.njhm.workflow.service.ProcessDefService;
import com.njhm.workflow.service.WorkflowCategoryService;
import com.njhm.workflow.utils.CommUtils;
import com.njhm.workflow.utils.FlowUtils;
import com.njhm.workflow.utils.PageData;
import com.njhm.workflow.vo.ActReDeploymentVO;
import com.njhm.workflow.vo.HistoricActivityVO;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.repository.ProcessDefinitionQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProcessDefServiceImpl
implements ProcessDefService {
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private WorkflowCategoryService workflowCategoryService;
    @Autowired
    private ActReDeploymentMapper actReDeploymentMapper;
    @Autowired
    private ActRunTaskMapper actRunTaskMapper;

    public void addDeploymentByString(String stringBPMN) {
        String processCategory;
        Deployment deploy = this.repositoryService.createDeployment().addString("CreateWithBPMNJS.bpmn", stringBPMN).deploy();
        String deploymentId = deploy.getId();
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).latestVersion().singleResult();
        Map processAttributes = FlowUtils.getProcessAttributes((String)definition.getId());
        if (processAttributes != null && !processAttributes.isEmpty() && StringUtils.isNotBlank((CharSequence)(processCategory = (String)processAttributes.get("category")))) {
            this.repositoryService.setProcessDefinitionCategory(definition.getId(), processCategory);
        }
        Boolean isContentStartUser = false;
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(definition.getId());
        Process process = (Process)bpmnModel.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        for (FlowElement flowElement : flowElements) {
            UserTask userTask;
            Map attributes;
            Map attrMap;
            String assignTypeVal;
            if (!(flowElement instanceof UserTask) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(assignTypeVal = (String)(attrMap = CommUtils.parseAttributes((Map)(attributes = (userTask = (UserTask)flowElement).getAttributes()))).get(BusinessCommEnum.ProcessAttrEnum.PP_0.getCode()))) || !assignTypeVal.equals(BusinessCommEnum.AssignTypeEnum.PP_1.getCode())) continue;
            isContentStartUser = true;
            break;
        }
        if (!isContentStartUser.booleanValue()) {
            this.deleteProcessDefinitionById(deploymentId);
            throw new BizException("\u6d41\u7a0b\u8bbe\u8ba1\u5fc5\u987b\u5305\u542b\u53d1\u8d77\u4eba\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
    }

    public void uploadStreamAndDeployment(MultipartFile file) throws IOException {
        String processCategory;
        String fileName = file.getOriginalFilename();
        InputStream fileInputStream = file.getInputStream();
        String extension = FilenameUtils.getExtension((String)fileName);
        Deployment deploy = null;
        if ("zip".equals(extension)) {
            ZipInputStream zip = new ZipInputStream(fileInputStream);
            deploy = this.repositoryService.createDeployment().addZipInputStream(zip).deploy();
        } else {
            deploy = this.repositoryService.createDeployment().addInputStream(fileName, fileInputStream).deploy();
        }
        String deploymentId = deploy.getId();
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).latestVersion().singleResult();
        Map processAttributes = FlowUtils.getProcessAttributes((String)definition.getId());
        if (processAttributes != null && !processAttributes.isEmpty() && StringUtils.isNotBlank((CharSequence)(processCategory = (String)processAttributes.get("category")))) {
            this.repositoryService.setProcessDefinitionCategory(definition.getId(), processCategory);
        }
        Boolean isContentStartUser = false;
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(definition.getId());
        Process process = (Process)bpmnModel.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        for (FlowElement flowElement : flowElements) {
            UserTask userTask;
            Map attributes;
            Map attrMap;
            String assignTypeVal;
            if (!(flowElement instanceof UserTask) || !org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(assignTypeVal = (String)(attrMap = CommUtils.parseAttributes((Map)(attributes = (userTask = (UserTask)flowElement).getAttributes()))).get(BusinessCommEnum.ProcessAttrEnum.PP_0.getCode()))) || !assignTypeVal.equals(BusinessCommEnum.AssignTypeEnum.PP_1.getCode())) continue;
            isContentStartUser = true;
            break;
        }
        if (!isContentStartUser.booleanValue()) {
            this.deleteProcessDefinitionById(deploymentId);
            throw new BizException("\u6d41\u7a0b\u8bbe\u8ba1\u5fc5\u987b\u5305\u542b\u53d1\u8d77\u4eba\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
    }

    public PageData<FlowProcess> definitionPage(DefinitionParamQuery query) {
        ArrayList<FlowProcess> results = new ArrayList<FlowProcess>();
        String category = query.getCategory();
        String deploymentId = query.getDeploymentId();
        String processDefinitionKey = query.getProcessDefinitionKey();
        String processDefinitionName = query.getProcessDefinitionName();
        String resourceName = query.getResourceName();
        Boolean latest = query.getLatest();
        if (latest == null) {
            latest = true;
        }
        ProcessDefinitionQuery queryCondition = this.repositoryService.createProcessDefinitionQuery();
        if (StringUtils.isNotBlank((CharSequence)category)) {
            queryCondition.processDefinitionCategoryLike(category);
        }
        if (StringUtils.isNotBlank((CharSequence)deploymentId)) {
            queryCondition.deploymentId(deploymentId);
        }
        if (StringUtils.isNotBlank((CharSequence)processDefinitionKey)) {
            queryCondition.processDefinitionKey(processDefinitionKey);
        }
        if (StringUtils.isNotBlank((CharSequence)processDefinitionName)) {
            queryCondition.processDefinitionNameLike("%" + processDefinitionName + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)resourceName)) {
            queryCondition.processDefinitionResourceNameLike("%" + resourceName + "%");
        }
        if (latest.booleanValue()) {
            queryCondition.latestVersion();
        }
        int total = queryCondition.list().size();
        int start = (query.getPage() - 1) * query.getLimit();
        List pageList = ((ProcessDefinitionQuery)queryCondition.orderByProcessDefinitionName().orderByProcessDefinitionVersion().desc()).listPage(start, query.getLimit().intValue());
        for (ProcessDefinition definition : pageList) {
            FlowCategory entity;
            Set ids = pageList.parallelStream().map(pdl -> pdl.getDeploymentId()).collect(Collectors.toSet());
            List actReDeploymentVOS = this.actReDeploymentMapper.selectActReDeploymentByIds(ids);
            ActReDeploymentVO actReDeploymentVO = actReDeploymentVOS.parallelStream().filter(ard -> definition.getDeploymentId().equals(ard.getId())).findAny().orElse(new ActReDeploymentVO());
            FlowProcess info = new FlowProcess(definition, actReDeploymentVO);
            HashMap attributes = new HashMap();
            attributes.putAll(FlowUtils.getProcessAttributes((String)info.getId()));
            info.setAttributes(attributes);
            String categoryCode = info.getCategory();
            if (StringUtils.isNotBlank((CharSequence)categoryCode) && (entity = this.workflowCategoryService.getInfoByCode(categoryCode)) != null) {
                info.setCategoryName(entity.getCategoryName());
            }
            results.add(info);
        }
        PageData page = new PageData(results, (long)total);
        return page;
    }

    public void deleteProcessDefinitionById(String deploymentId) {
        this.repositoryService.deleteDeployment(deploymentId, true);
    }

    public void getProcessDefineXML(HttpServletResponse response, String deploymentId, String resourceName) throws IOException {
        InputStream inputStream = this.repositoryService.getResourceAsStream(deploymentId, resourceName);
        int count = inputStream.available();
        byte[] bytes = new byte[count];
        response.setContentType("text/xml");
        ServletOutputStream outputStream = response.getOutputStream();
        while (inputStream.read(bytes) != -1) {
            outputStream.write(bytes);
        }
        inputStream.close();
    }

    public List<HistoricActivityVO> getUserTask(String processDefinitionKey) {
        ArrayList<HistoricActivityVO> results = new ArrayList<HistoricActivityVO>();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        Process process = (Process)bpmnModel.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof UserTask)) continue;
            UserTask userTask = (UserTask)flowElement;
            HistoricActivityVO vo = new HistoricActivityVO();
            vo.setActivityId(userTask.getId());
            vo.setActivityName(userTask.getName());
            vo.setExecutionId(userTask.getExtensionId());
            results.add(vo);
        }
        ArrayList collect = results.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<HistoricActivityVO>(Comparator.comparing(p -> p.getActivityId()))), ArrayList::new));
        return collect;
    }

    @Transactional(rollbackFor={Exception.class})
    public void cascadeDelete(String deploymentId) {
        this.actReDeploymentMapper.deleteBytearray(deploymentId);
        this.actReDeploymentMapper.deleteDeployment(deploymentId);
        String processDefinitionId = this.actReDeploymentMapper.getProcessDefinitionId(deploymentId);
        if (StringUtils.isNotBlank((CharSequence)processDefinitionId)) {
            List processInstancesIds = this.actReDeploymentMapper.getProcessInstancesId(processDefinitionId);
            if (!CollectionUtils.isEmpty((Collection)processInstancesIds)) {
                for (String processInstancesId : processInstancesIds) {
                    this.actReDeploymentMapper.deleteActinst(processInstancesId);
                    this.actReDeploymentMapper.deleteIdentitylink(processInstancesId);
                    this.actReDeploymentMapper.deleteVariable(processInstancesId);
                    this.actReDeploymentMapper.deleteTask(processInstancesId);
                }
                this.actReDeploymentMapper.deleteExecution(processDefinitionId);
            }
            this.actReDeploymentMapper.deleteProcdef(deploymentId);
        }
    }
}

