/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.njhm.workflow.enums.BusinessCommEnum;
import com.njhm.workflow.enums.CallbackTypeEnum;
import com.njhm.workflow.utils.SpringContextUtils;
import jakarta.validation.constraints.NotNull;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngines;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FlowUtils {
    private static final RepositoryService repositoryService = (RepositoryService)SpringContextUtils.getBean(RepositoryService.class);

    public static BpmnModel getBpmnModel(String processDefinitionId) {
        return repositoryService.getBpmnModel(processDefinitionId);
    }

    public static List<FlowElement> getEndFlowElement(String processDefinitionId) {
        Process mainProcess = FlowUtils.getBpmnModel((String)processDefinitionId).getMainProcess();
        return mainProcess.getFlowElements().stream().filter(f -> f instanceof EndEvent).collect(Collectors.toList());
    }

    public static Map<String, FlowElement> getProcessFlowElementMap(String processDefinitionId) {
        Process mainProcess = FlowUtils.getBpmnModel((String)processDefinitionId).getMainProcess();
        return mainProcess.getFlowElements().stream().collect(Collectors.toMap(BaseElement::getId, FlowElement::clone));
    }

    public static <T extends FlowElement> List<T> getBpmnModelElements(BpmnModel model, Class<T> clazz) {
        ArrayList result = new ArrayList();
        model.getProcesses().forEach(process -> process.getFlowElements().forEach(flowElement -> {
            if (flowElement.getClass().isAssignableFrom(clazz)) {
                result.add(flowElement);
            }
        }));
        return result;
    }

    public static Map<String, String> getTaskAttributes(String processDefinitionId, @NotNull String taskDefinitionKey) {
        BpmnModel bpmnModel = FlowUtils.getBpmnModel((String)processDefinitionId);
        FlowNode flowNode = (FlowNode)bpmnModel.getFlowElement(taskDefinitionKey);
        Map attributes = flowNode.getAttributes();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (attributes != null) {
            attributes.forEach((key, extensionAttributes) -> resultMap.put(((ExtensionAttribute)extensionAttributes.get(0)).getName(), ((ExtensionAttribute)extensionAttributes.get(0)).getValue()));
        }
        return resultMap;
    }

    public static boolean isHttpCallback(@NotNull String processDefinitionId) {
        return FlowUtils.getCallbackType((String)processDefinitionId).name().equals(CallbackTypeEnum.HTTP.name());
    }

    public List<UserTask> getUserTasks(String processDefinitionId) {
        BpmnModel bpmnModel = FlowUtils.getBpmnModel((String)processDefinitionId);
        return FlowUtils.getBpmnModelElements((BpmnModel)bpmnModel, UserTask.class);
    }

    public static String getProcessAttributeValue(@NotNull String processDefinitionId, @NotNull String attributeKey) {
        return (String)FlowUtils.getProcessAttributes((String)processDefinitionId).get(attributeKey);
    }

    public static Map<String, String> getProcessAttributes(String processDefinitionId) {
        BpmnModel bpmnModel = FlowUtils.getBpmnModel((String)processDefinitionId);
        Map attributes = bpmnModel.getMainProcess().getAttributes();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (attributes != null) {
            attributes.forEach((key, attrs) -> resultMap.put(((ExtensionAttribute)attrs.get(0)).getName(), ((ExtensionAttribute)attrs.get(0)).getValue()));
        }
        return resultMap;
    }

    public static Map<String, String> getProcessAttributes(@NotNull ProcessDefinition processDefinition) {
        BpmnModel bpmnModel = FlowUtils.getBpmnModel((String)processDefinition.getId());
        Map attributes = ((Process)bpmnModel.getProcesses().get(0)).getAttributes();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (attributes == null) {
            return resultMap;
        }
        attributes.forEach((key, extensionAttributes) -> resultMap.put(((ExtensionAttribute)extensionAttributes.get(0)).getName(), ((ExtensionAttribute)extensionAttributes.get(0)).getValue()));
        return resultMap;
    }

    public static BpmnModel updateProcessAttribute(String processDefinitionId, String attributeName, String attributeValue) {
        BpmnModel bpmnModel = FlowUtils.getBpmnModel((String)processDefinitionId);
        Process mainProcess = bpmnModel.getMainProcess();
        List attributes = (List)mainProcess.getAttributes().get(attributeName);
        boolean updated = false;
        if (attributes != null) {
            for (ExtensionAttribute attr : attributes) {
                if (!attributeName.equals(attr.getName())) continue;
                attr.setValue(attributeValue);
                updated = true;
            }
        }
        if (!updated) {
            mainProcess.getAttributes().put(attributeName, Arrays.asList(new ExtensionAttribute("flowable:" + attributeName, attributeValue)));
        }
        return bpmnModel;
    }

    public static String getProcessDefinitionXml(ProcessDefinition processDefinition) {
        List resourceNameList = repositoryService.getDeploymentResourceNames(processDefinition.getDeploymentId());
        InputStream in = repositoryService.getResourceAsStream(processDefinition.getDeploymentId(), (String)resourceNameList.get(0));
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = in.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            return outputStream.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getProcessDefinitionXml(String processDefinitionId) {
        ProcessDefinition processDefinition = (ProcessDefinition)repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        return FlowUtils.getProcessDefinitionXml((ProcessDefinition)processDefinition);
    }

    public static boolean taskIsCallback(String taskId) {
        String isCallback = (String)FlowUtils.getTaskAttributes((String)taskId).get("isCallback");
        return StringUtils.hasLength((String)isCallback) && "true".equals(isCallback);
    }

    public static Map<String, String> getTaskAttributes(FlowNode flowNode) {
        Map attributes = flowNode.getAttributes();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (attributes == null) {
            return resultMap;
        }
        attributes.forEach((key, extensionAttributes) -> resultMap.put(((ExtensionAttribute)extensionAttributes.get(0)).getName(), ((ExtensionAttribute)extensionAttributes.get(0)).getValue()));
        return resultMap;
    }

    public static Map<String, String> getTaskAttributes(String taskId) {
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        Task t = (Task)((TaskQuery)processEngine.getTaskService().createTaskQuery().taskId(taskId)).singleResult();
        String processDefinitionId = ((ProcessInstance)processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(t.getProcessInstanceId()).singleResult()).getProcessDefinitionId();
        BpmnModel bpmnModel = processEngine.getRepositoryService().getBpmnModel(processDefinitionId);
        Execution execution = (Execution)processEngine.getRuntimeService().createExecutionQuery().executionId(t.getExecutionId()).singleResult();
        String activityId = execution.getActivityId();
        FlowNode currentNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityId);
        Map attributes = currentNode.getAttributes();
        HashMap<String, String> resultMap = new HashMap<String, String>();
        if (attributes == null) {
            return resultMap;
        }
        attributes.forEach((key, extensionAttributes) -> resultMap.put(((ExtensionAttribute)extensionAttributes.get(0)).getName(), ((ExtensionAttribute)extensionAttributes.get(0)).getValue()));
        return resultMap;
    }

    public static CallbackTypeEnum getCallbackType(@NotNull String processDefinitionId) {
        String callbackType = FlowUtils.getProcessAttributeValue((String)processDefinitionId, (String)BusinessCommEnum.ProcessAttrEnum.PP_10.getCode());
        callbackType = StrUtil.blankToDefault((CharSequence)callbackType, (String)"HTTP").toUpperCase();
        return CallbackTypeEnum.valueOf((String)callbackType);
    }

    public static String getCallbackId(@NotNull String processDefinitionId) {
        return FlowUtils.getProcessAttributeValue((String)processDefinitionId, (String)BusinessCommEnum.ProcessAttrEnum.PP_11.getCode());
    }

    public static String getCallbackId(@NotNull String processDefinitionId, String taskId) {
        String taskCallBack = (String)FlowUtils.getTaskAttributes((String)taskId).get(BusinessCommEnum.ProcessAttrEnum.PP_12.getCode());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)taskCallBack) || "null".equals(taskCallBack)) {
            taskCallBack = FlowUtils.getProcessAttributeValue((String)processDefinitionId, (String)BusinessCommEnum.ProcessAttrEnum.PP_11.getCode());
        }
        return taskCallBack;
    }

    public static List<UserTask> getUserTask(String processKey) {
        RepositoryService repositoryService = ProcessEngines.getDefaultProcessEngine().getRepositoryService();
        ProcessDefinition processDefinition = (ProcessDefinition)repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().singleResult();
        List processes = repositoryService.getBpmnModel(processDefinition.getId()).getProcesses();
        ArrayList<UserTask> useTaskList = new ArrayList<UserTask>();
        for (Process process : processes) {
            Collection flowElements = process.getFlowElements();
            if (!CollectionUtil.isNotEmpty((Collection)flowElements)) continue;
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                useTaskList.add((UserTask)flowElement);
            }
        }
        return useTaskList;
    }
}

