/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.utils;

import com.njhm.workflow.utils.SpringContextUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionAttribute;
import org.flowable.bpmn.model.Process;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.repository.Deployment;
import org.flowable.engine.repository.ProcessDefinition;

public class ProcessDefinitionHolder {
    private static RepositoryService repositoryService = (RepositoryService)SpringContextUtils.getBean(RepositoryService.class);
    private BpmnModel bpmnModel;
    private String processDefinitionId;
    private ProcessDefinition processDefinition;

    public static ProcessDefinitionHolder createByProcessDefinitionId(String processDefinitionId) {
        ProcessDefinitionHolder holder = new ProcessDefinitionHolder();
        holder.processDefinition = (ProcessDefinition)repositoryService.createProcessDefinitionQuery().processDefinitionId(processDefinitionId).singleResult();
        return holder;
    }

    public static ProcessDefinitionHolder createByProcessDefinitionKey(String processDefinitionKey) {
        ProcessDefinitionHolder holder = new ProcessDefinitionHolder();
        holder.processDefinition = (ProcessDefinition)repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
        holder.processDefinitionId = holder.processDefinition.getId();
        return holder;
    }

    public static ProcessDefinitionHolder createByProcessDefinition(ProcessDefinition processDefinition) {
        ProcessDefinitionHolder holder = new ProcessDefinitionHolder();
        holder.processDefinition = processDefinition;
        holder.processDefinitionId = processDefinition.getId();
        return holder;
    }

    private ProcessDefinitionHolder initBpmnModel() {
        this.bpmnModel = repositoryService.getBpmnModel(this.processDefinitionId);
        return this;
    }

    private Map<String, List<ExtensionAttribute>> getExtensionAttributes() {
        return this.bpmnModel.getMainProcess().getAttributes();
    }

    public String getAttributeValue(String attributeName) {
        if (this.bpmnModel == null) {
            this.initBpmnModel();
        }
        Map attributes = this.getExtensionAttributes();
        HashMap resultMap = new HashMap();
        if (attributes != null) {
            attributes.forEach((key, attrs) -> resultMap.put(((ExtensionAttribute)attrs.get(0)).getName(), ((ExtensionAttribute)attrs.get(0)).getValue()));
        }
        return (String)resultMap.get(attributeName);
    }

    public ProcessDefinitionHolder setAttribute(String attributeName, String attributeValue) {
        if (this.bpmnModel == null) {
            this.initBpmnModel();
        }
        Process process = (Process)this.bpmnModel.getProcesses().get(0);
        List attributes = (List)this.getExtensionAttributes().get(attributeName);
        boolean isUpdated = false;
        if (attributes != null) {
            for (ExtensionAttribute attr : attributes) {
                if (!attributeName.equals(attr.getName())) continue;
                attr.setValue(attributeValue);
                isUpdated = true;
            }
        }
        if (!isUpdated) {
            process.getAttributes().put(attributeName, Arrays.asList(new ExtensionAttribute("flowable:" + attributeName, attributeValue)));
        }
        return this;
    }

    public ProcessDefinitionHolder deleteDeployment() {
        repositoryService.deleteDeployment(this.processDefinition.getDeploymentId());
        return this;
    }

    public Deployment deploy(boolean keepVersion) {
        if (keepVersion) {
            repositoryService.deleteDeployment(this.processDefinition.getDeploymentId());
        }
        return repositoryService.createDeployment().addBpmnModel(this.processDefinition.getResourceName(), this.bpmnModel).deploy();
    }

    public Deployment deploy() {
        return this.deploy(false);
    }
}

