/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import org.springframework.boot.loader.zip.DataBlock;

class VirtualDataBlock
implements DataBlock {
    private List<DataBlock> parts;
    private long size;

    protected VirtualDataBlock() {
    }

    VirtualDataBlock(Collection<? extends DataBlock> parts) throws IOException {
        this.setParts(parts);
    }

    protected void setParts(Collection<? extends DataBlock> parts) throws IOException {
        this.parts = List.copyOf(parts);
        long size = 0L;
        for (DataBlock dataBlock : parts) {
            size += dataBlock.size();
        }
        this.size = size;
    }

    @Override
    public long size() throws IOException {
        return this.size;
    }

    @Override
    public int read(ByteBuffer dst, long pos) throws IOException {
        if (pos < 0L || pos >= this.size) {
            return -1;
        }
        long offset = 0L;
        int result = 0;
        for (DataBlock part : this.parts) {
            while (pos >= offset && pos < offset + part.size()) {
                int count = part.read(dst, pos - offset);
                result += Math.max(count, 0);
                if (count <= 0 || !dst.hasRemaining()) {
                    return result;
                }
                pos += (long)count;
            }
            offset += part.size();
        }
        return result;
    }
}

