/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.controller;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.github.xiaoymin.knife4j.annotations.Ignore;
import com.njhm.workflow.dto.FlowComment;
import com.njhm.workflow.dto.FlowTaskInfo;
import com.njhm.workflow.dto.TaskCompleteForm;
import com.njhm.workflow.dto.comm.ProcessApproveForm;
import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.query.TaskParamQuery;
import com.njhm.workflow.service.ProcessTaskService;
import com.njhm.workflow.service.WorkflowService;
import com.njhm.workflow.utils.ConvertUtils;
import com.njhm.workflow.utils.PageData;
import com.njhm.workflow.utils.Result;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.task.api.DelegationState;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/task"})
@Tag(name="\u6d41\u7a0b\u4efb\u52a1")
public class TaskController {
    @Autowired
    private ProcessTaskService processTaskService;
    private final WorkflowService workflowService;
    private final TaskService taskService;
    private final RuntimeService runtimeService;

    @Operation(summary="\u5206\u9875\u83b7\u53d6\u5ba1\u6279\u4efb\u52a1", description="\u8bb0\u5f55\u4e2d\u9ed8\u8ba4\u4e0d\u5305\u542b\u4efb\u52a1\u53d8\u91cf\u4fe1\u606f")
    @Parameters(value={@Parameter(description="\u9875\u7801,\u4ece1\u5f00\u59cb", name="page", in=ParameterIn.QUERY, required=true), @Parameter(description="\u5206\u9875\u5927\u5c0f", name="limit", in=ParameterIn.QUERY, required=true), @Parameter(description="\u6d41\u7a0b\u5b9a\u4e49\u540d\u79f0", name="processDefinitionName", in=ParameterIn.QUERY), @Parameter(description="\u6d41\u7a0b\u5b9a\u4e49KEY", name="processDefinitionKey", in=ParameterIn.QUERY), @Parameter(description="\u4efb\u52a1ID", name="taskId", in=ParameterIn.QUERY), @Parameter(description="\u4e1a\u52a1Key", name="businessKey", in=ParameterIn.QUERY), @Parameter(description="\u4efb\u52a1\u540d\u79f0", name="taskName", in=ParameterIn.QUERY), @Parameter(description="\u4efb\u52a1\u6267\u884c\u4eba", name="assignee", in=ParameterIn.QUERY)})
    @GetMapping(value={"page"})
    public Result<FlowTaskInfo> page(@RequestParam(required=false) @Ignore Map<String, Object> params) {
        ArrayList<FlowTaskInfo> results = new ArrayList<FlowTaskInfo>();
        int pageNo = MapUtils.getInteger(params, (Object)"page", (Integer)1);
        int pageSize = MapUtils.getInteger(params, (Object)"limit", (Integer)10);
        TaskQuery queryCondition = this.taskService.createTaskQuery();
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"processDefinitionName"))) {
            queryCondition.processDefinitionNameLike("%" + MapUtils.getString(params, (Object)"processDefinitionName") + "%");
        }
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"processDefinitionKey"))) {
            queryCondition.processDefinitionKeyLike("%" + MapUtils.getString(params, (Object)"processDefinitionKey") + "%");
        }
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"taskId"))) {
            queryCondition.taskId(MapUtils.getString(params, (Object)"taskId"));
        }
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"businessKey"))) {
            queryCondition.processInstanceBusinessKeyLike("%" + MapUtils.getString(params, (Object)"businessKey") + "%");
        }
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"taskName"))) {
            queryCondition.taskNameLike("%" + MapUtils.getString(params, (Object)"taskName") + "%");
        }
        if (StringUtils.hasLength((String)MapUtils.getString(params, (Object)"assignee"))) {
            queryCondition.taskAssigneeLike("%" + MapUtils.getString(params, (Object)"assignee") + "%");
        }
        long total = queryCondition.list().size();
        int start = (pageNo - 1) * pageSize;
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)queryCondition.includeTaskLocalVariables()).orderByProcessDefinitionId()).orderByTaskCreateTime()).desc()).listPage(start, pageSize);
        for (Task task : taskList) {
            ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().includeProcessVariables().processInstanceId(task.getProcessInstanceId()).singleResult();
            FlowTaskInfo info = new FlowTaskInfo(task, instance);
            results.add(info);
        }
        PageData page = new PageData(results, total);
        return Result.okData((Object)page);
    }

    @ApiOperationSupport(ignoreParameters={"comments.taskId", "comments.processInstanceId"})
    @Operation(summary="\u83b7\u53d6\u5ba1\u6279\u4efb\u52a1\u8be6\u7ec6", description="\u4fdd\u542b\u4efb\u52a1\u53d8\u91cf\u4fe1\u606f")
    @GetMapping(value={"{taskId}"})
    public Result<FlowTaskInfo> getTaskInfo(@PathVariable String taskId) {
        Task task = (Task)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeProcessVariables()).includeTaskLocalVariables()).taskId(taskId)).singleResult();
        FlowTaskInfo flowTaskInfo = (FlowTaskInfo)ConvertUtils.sourceToTarget((Object)task, FlowTaskInfo.class);
        if (Objects.nonNull(flowTaskInfo)) {
            List commentList = this.taskService.getTaskComments(taskId);
            flowTaskInfo.setComments(ConvertUtils.sourceToTarget((Collection)commentList, FlowComment.class));
            flowTaskInfo.setTaskVariables(task.getTaskLocalVariables());
            flowTaskInfo.setProcessVariables(task.getProcessVariables());
        }
        return Result.okData((Object)flowTaskInfo);
    }

    @Operation(summary="\u5ba1\u6279\u5b8c\u6210\u4efb\u52a1")
    @PostMapping(value={"completeTask"})
    public Result rejectTask(@RequestBody(required=false) TaskCompleteForm form) {
        this.workflowService.completeTask(form);
        return Result.ok();
    }

    @Operation(summary="\u62fe\u53d6\u4efb\u52a1")
    @PostMapping(value={"{taskId}/claim"})
    public Result claimTask(@PathVariable(value="taskId") String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new BizException(10008);
        }
        this.taskService.claim(taskId, Authentication.getAuthenticatedUserId());
        return Result.ok();
    }

    @Operation(summary="\u4e22\u5f03\u4efb\u52a1", description="\u4efb\u52a1\u5fc5\u987b\u662f\u5f53\u524d\u7528\u6237\u5177\u6709\u5ba1\u6279\u6743\u9650")
    @PostMapping(value={"{taskId}/unclaimed"})
    public Result unclaimedTask(@PathVariable(value="taskId") String taskId) {
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).taskAssignee(Authentication.getAuthenticatedUserId())).singleResult();
        if (task == null) {
            throw new BizException(10008);
        }
        this.taskService.unclaim(taskId);
        return Result.ok();
    }

    @Operation(summary="\u4efb\u52a1\u8f6c\u529e", description="\u8bbe\u7f6e\u4efb\u52a1\u529e\u7406\u4eba")
    @Parameters(value={@Parameter(name="taskId", description="\u4efb\u52a1ID", in=ParameterIn.QUERY, required=true), @Parameter(name="userId", description="\u8f6c\u529e\u7ed9\u7528\u6237ID", in=ParameterIn.QUERY, required=true)})
    @PostMapping(value={"/transform"})
    public Result transformTask(@RequestParam(value="taskId") String taskId, @RequestParam(value="userId") String userId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new BizException(10008);
        }
        this.taskService.setAssignee(taskId, userId);
        return Result.ok();
    }

    @Operation(summary="\u59d4\u529e\u5b8c\u6210\u4efb\u52a1", description="\u59d4\u529e\u5b8c\u6210\u540e\u4efb\u52a1\u5c06\u56de\u5230\u4e4b\u524d\u5ba1\u6279\u540d\u4e0b")
    @PostMapping(value={"resolveTask"})
    public Result resolveTask(@RequestBody(required=false) TaskCompleteForm form) {
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(form.getTaskId())).taskAssignee(Authentication.getAuthenticatedUserId())).singleResult();
        if (task == null) {
            throw new BizException(10008);
        }
        if (task.isSuspended()) {
            throw new BizException(10007);
        }
        if (StringUtils.hasLength((String)form.getComment())) {
            this.taskService.addComment(form.getTaskId(), task.getProcessInstanceId(), form.getComment());
        }
        this.taskService.resolveTask(form.getTaskId(), form.getVariables());
        return Result.ok();
    }

    @Operation(summary="\u4efb\u52a1\u59d4\u529e", description="\u4efb\u52a1\u5fc5\u987b\u662f\u5f53\u524d\u7528\u6237\u5177\u6709\u5ba1\u6279\u6743\u9650")
    @Parameters(value={@Parameter(name="taskId", description="\u4efb\u52a1ID", in=ParameterIn.QUERY, required=true), @Parameter(name="userId", description="\u8f6c\u529e\u7ed9\u7528\u6237ID", in=ParameterIn.QUERY, required=true)})
    @PostMapping(value={"/delegateTask"})
    public Result delegateTask(@RequestParam(value="taskId") String taskId, @RequestParam(value="userId") String userId) {
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).taskAssignee(Authentication.getAuthenticatedUserId())).singleResult();
        if (task == null) {
            throw new BizException(10008);
        }
        if (task.getDelegationState() == DelegationState.PENDING) {
            throw new BizException(10008);
        }
        this.taskService.delegateTask(taskId, userId);
        return Result.ok();
    }

    @Operation(summary="\u67e5\u8be2\u6240\u6709\u6b63\u5728\u8fd0\u884c\u7684\u8c03\u5ea6\u4efb\u52a1\u5217\u8868")
    @PostMapping(value={"/taskPage"})
    public Result<PageData<FlowTaskInfo>> taskPage(@RequestBody TaskParamQuery query) {
        PageData results = this.processTaskService.taskPage(query);
        return Result.okData((Object)results);
    }

    @Operation(summary="\u5ba1\u6279\u4efb\u52a1")
    @PostMapping(value={"/approveTask"})
    public Result approveTask(@RequestBody ProcessApproveForm form) {
        this.processTaskService.approveTask(form);
        return Result.ok();
    }

    @Operation(summary="\u62fe\u53d6\u4efb\u52a1")
    @PostMapping(value={"/pickupGroupTask"})
    public Result pickupGroupTask(@RequestBody TaskParamQuery query) {
        this.processTaskService.pickupGroupTask(query);
        return Result.ok();
    }

    @Operation(summary="\u5f52\u8fd8\u4efb\u52a1")
    @PostMapping(value={"/returnGroupTask"})
    public Result returnGroupTask(@RequestBody TaskParamQuery query) {
        this.processTaskService.returnGroupTask(query);
        return Result.ok();
    }

    @Operation(summary="\u9a73\u56de:\u8df3\u8f6c\u5230\u6307\u5b9a\u8282\u70b9")
    @GetMapping(value={"/jump"})
    public Result jump(@RequestParam(value="taskId") String taskId, @RequestParam(value="sid") String sid, @RequestParam(value="comment", required=false) String comment) {
        this.processTaskService.jump(taskId, sid, comment);
        return Result.ok();
    }

    @Operation(summary="\u6d41\u7a0b\u7ec8\u6b62:\u5f3a\u5236\u7ed3\u675f\u4e00\u4e2a\u6d41\u7a0b")
    @GetMapping(value={"/forceEnd/{taskId}"})
    public Result forceEnd(@PathVariable(value="taskId") String taskId) {
        this.processTaskService.forceEnd(taskId);
        return Result.ok();
    }

    @Operation(summary="\u4efb\u52a1\u8f6c\u529e")
    @PostMapping(value={"/taskTransfer"})
    public Result taskTransfer(@RequestParam(value="taskId") String taskId, @RequestParam(value="assignee") String assignee, @RequestParam(value="comment", required=false) String comment) {
        this.processTaskService.taskTransfer(taskId, assignee, comment);
        return Result.ok();
    }

    @Operation(summary="\u53d8\u66f4\u5ba1\u6838\u4eba")
    @PostMapping(value={"/taskToExamine"})
    public Result taskToExamine(@RequestParam(value="taskId") String taskId, @RequestParam(value="assignee") String assignee, @RequestParam(value="comment", required=false) String comment) {
        this.processTaskService.taskToExamine(taskId, assignee, comment);
        return Result.ok();
    }

    @Operation(summary="\u4efb\u52a1\u64a4\u56de")
    @PostMapping(value={"/taskWithdraw"})
    public Result taskWithdraw(@RequestParam(value="taskId") String taskId) {
        this.processTaskService.taskWithdraw(taskId);
        return Result.ok();
    }

    @Operation(summary="\u6839\u636e\u4efb\u52a1ID\u83b7\u53d6\u4efb\u52a1\u8be6\u60c5")
    @GetMapping(value={"/getTaskInfosByTaskId/{taskId}"})
    public Result<FlowTaskInfo> getTaskInfosByTaskId(@PathVariable(value="taskId") String taskId) {
        FlowTaskInfo result = this.processTaskService.getTaskInfosByTaskId(taskId);
        return Result.okData((Object)result);
    }

    public TaskController(ProcessTaskService processTaskService, WorkflowService workflowService, TaskService taskService, RuntimeService runtimeService) {
        this.processTaskService = processTaskService;
        this.workflowService = workflowService;
        this.taskService = taskService;
        this.runtimeService = runtimeService;
    }
}

