/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.service;

import cn.hutool.core.collection.CollectionUtil;
import com.njhm.workflow.dto.FlowComment;
import com.njhm.workflow.dto.FlowProcessInstance;
import com.njhm.workflow.dto.FlowRuntimeInfo;
import com.njhm.workflow.dto.FlowTaskInfo;
import com.njhm.workflow.dto.TaskCompleteForm;
import com.njhm.workflow.dto.comm.ProcessStartForm;
import com.njhm.workflow.enums.BusinessStatusEnum;
import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.security.SecurityUser;
import com.njhm.workflow.utils.ConvertUtils;
import com.njhm.workflow.utils.FlowUtils;
import com.njhm.workflow.utils.ValidatorUtils;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.engine.HistoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceBuilder;
import org.flowable.engine.task.Comment;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class WorkflowService {
    @Resource
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Resource
    private TaskService taskService;

    @Transactional(rollbackFor={Exception.class})
    public void completeTask(TaskCompleteForm form) {
        Task nextTask;
        ProcessInstance processInstance;
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(form.getTaskId())).taskAssignee(Authentication.getAuthenticatedUserId())).singleResult();
        if (task == null) {
            throw new BizException(10008);
        }
        Map variables = form.getVariables();
        variables.put("approveStatus", 1);
        variables.put("approveUserId", Authentication.getAuthenticatedUserId());
        if (StringUtils.hasLength((String)form.getComment())) {
            this.taskService.addComment(form.getTaskId(), task.getProcessInstanceId(), form.getComment());
        }
        if (form.getBusinessStatus() != null) {
            this.runtimeService.updateBusinessStatus(task.getProcessInstanceId(), form.getBusinessStatus().name());
        }
        this.taskService.complete(form.getTaskId(), Authentication.getAuthenticatedUserId(), variables, form.getFormData());
        if (form.getBusinessStatus() == null && StringUtils.hasLength((String)form.getNextApprover()) && (processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()) != null && !processInstance.isEnded() && (nextTask = this.getCurrentTask(processInstance.getId())) != null) {
            this.taskService.setAssignee(nextTask.getId(), form.getNextApprover());
        }
    }

    public boolean isProcessInstanceExist(String processInstId) {
        return this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstId).count() > 0L;
    }

    public FlowProcessInstance getProcessInstanceById(String processInstId, boolean includeProcessInstanceVariables) {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstId);
        if (includeProcessInstanceVariables) {
            query.includeProcessVariables();
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)query.singleResult();
        return (FlowProcessInstance)ConvertUtils.sourceToTarget((Object)historicProcessInstance, FlowProcessInstance.class);
    }

    public Task getTask(String taskId) {
        return (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
    }

    public Task getUserTask(String processInstId, String userId) {
        return (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstId)).taskAssignee(userId)).singleResult();
    }

    public Task getCurrentTask(String processInstId) {
        return (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstId)).active().singleResult();
    }

    public FlowProcessInstance startProcessInstanceByKey(ProcessStartForm form) {
        ValidatorUtils.validateEntity((Object)form, (Class[])new Class[0]);
        String processDefinitionKey = form.getProcessDefinitionKey();
        String processInstanceName = form.getProcessInstanceName();
        String businessKey = form.getBusinessKey();
        String formUrl = form.getFormUrl();
        HashMap<String, String> variables = form.getVariables();
        if (CollectionUtils.isEmpty((Map)variables)) {
            variables = new HashMap<String, String>();
        }
        variables.put("businessKey", businessKey);
        variables.put("startUserId", (String)((Object)SecurityUser.getUserId()));
        variables.put("startUserName", SecurityUser.getUsername());
        variables.put("fromUrl", formUrl);
        ProcessInstanceBuilder processInstanceBuilder = this.runtimeService.createProcessInstanceBuilder().processDefinitionKey(processDefinitionKey).name(processInstanceName).businessKey(businessKey).variables(variables);
        ProcessInstance instance = processInstanceBuilder.start();
        Task autoTask = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey(processDefinitionKey)).processInstanceBusinessKey(businessKey)).singleResult();
        this.taskService.complete(autoTask.getId());
        FlowProcessInstance flowProcessInstance = new FlowProcessInstance(instance);
        Map processVariables = instance.getProcessVariables();
        if (processVariables.size() > 0) {
            flowProcessInstance.setProcessVariables(processVariables);
        }
        return flowProcessInstance;
    }

    public List<FlowTaskInfo> getHistoryTaskList(String processInstanceId, boolean includeTaskVariables) {
        HistoricTaskInstanceQuery historicTaskInstanceQuery = (HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId);
        if (includeTaskVariables) {
            historicTaskInstanceQuery.includeTaskLocalVariables();
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)historicTaskInstanceQuery.orderByHistoricTaskInstanceStartTime().asc()).list();
        Map<String, HistoricTaskInstance> collectMap = historicTaskInstances.stream().collect(Collectors.toMap(p -> p.getId(), p -> p));
        List flowTasks = ConvertUtils.sourceToTarget((Collection)historicTaskInstances, FlowTaskInfo.class);
        for (FlowTaskInfo flowTaskInfo : flowTasks) {
            flowTaskInfo.setTaskVariables(collectMap.get(flowTaskInfo.getId()).getTaskLocalVariables());
        }
        List commentList = this.taskService.getProcessInstanceComments(processInstanceId);
        if (CollectionUtil.isNotEmpty((Collection)commentList)) {
            Map<String, List<Comment>> commentMap = commentList.stream().collect(Collectors.groupingBy(Comment::getTaskId));
            flowTasks.parallelStream().forEach(task -> task.setComments(ConvertUtils.sourceToTarget((Collection)((Collection)commentMap.get(task.getId())), FlowComment.class)));
        }
        return flowTasks;
    }

    public FlowRuntimeInfo getFlowRuntimeInfo(String processInstanceId, boolean includeProcessInstance) {
        FlowProcessInstance processInstance = this.getProcessInstanceById(processInstanceId, true);
        String xmlData = FlowUtils.getProcessDefinitionXml((String)processInstance.getProcessDefinitionId());
        FlowRuntimeInfo runtimeInfo = new FlowRuntimeInfo();
        runtimeInfo.setProcessInstanceId(processInstanceId);
        runtimeInfo.setProcessInstanceName(processInstance.getProcessDefinitionName());
        runtimeInfo.setHistoryTaskList(this.getHistoryTaskList(processInstanceId, true));
        runtimeInfo.setXmlData(xmlData);
        ArrayList highLightedActivities = new ArrayList();
        ArrayList highLightedFlows = new ArrayList();
        List hisActInsList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        hisActInsList.forEach(historicActivityInstance -> {
            if ("sequenceFlow".equals(historicActivityInstance.getActivityType())) {
                highLightedFlows.add(historicActivityInstance.getActivityId());
            } else {
                highLightedActivities.add(historicActivityInstance.getActivityId());
            }
        });
        if (includeProcessInstance) {
            runtimeInfo.setProcessInstance(processInstance);
        }
        runtimeInfo.setHighLightedFlows(highLightedFlows);
        runtimeInfo.setHighLightedActivities(highLightedActivities);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).active().list();
        List collect = tasks.stream().map(t -> t.getTaskDefinitionKey()).collect(Collectors.toList());
        runtimeInfo.setProcessVariables(processInstance.getProcessVariables());
        runtimeInfo.setActiveLightedActivities(collect);
        return runtimeInfo;
    }

    public void deleteProcessInstance(String processInstanceId, BusinessStatusEnum status) {
        this.runtimeService.updateBusinessStatus(processInstanceId, status.name());
        this.runtimeService.setVariable(processInstanceId, "businessStatus", (Object)status.name());
        this.runtimeService.deleteProcessInstance(processInstanceId, status.name());
    }
}

