/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.service.impl;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.njhm.workflow.dto.FlowCategory;
import com.njhm.workflow.dto.FlowTaskInfo;
import com.njhm.workflow.dto.comm.ProcessApproveForm;
import com.njhm.workflow.dto.comm.ProcessButtonComm;
import com.njhm.workflow.enums.BusinessCommEnum;
import com.njhm.workflow.enums.BusinessStatusEnum;
import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.mapper.ActRunTaskMapper;
import com.njhm.workflow.query.TaskParamQuery;
import com.njhm.workflow.security.SecurityUser;
import com.njhm.workflow.service.ProcessTaskService;
import com.njhm.workflow.service.UndoTaskService;
import com.njhm.workflow.service.WorkflowCategoryService;
import com.njhm.workflow.utils.CommUtils;
import com.njhm.workflow.utils.ExpressionCommand;
import com.njhm.workflow.utils.FlowUtils;
import com.njhm.workflow.utils.PageData;
import com.njhm.workflow.utils.ValidatorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.EndEvent;
import org.flowable.bpmn.model.ExclusiveGateway;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.ParallelGateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.engine.HistoryService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngines;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.runtime.Execution;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.identitylink.api.IdentityLink;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessTaskServiceImpl
implements ProcessTaskService {
    private static final Logger log = LoggerFactory.getLogger(ProcessTaskServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private WorkflowCategoryService workflowCategoryService;
    @Autowired
    private ActRunTaskMapper actRunTaskMapper;
    @Autowired
    private UndoTaskService undoTaskService;

    public PageData<FlowTaskInfo> taskPage(TaskParamQuery query) {
        ArrayList<FlowTaskInfo> results = new ArrayList<FlowTaskInfo>();
        String category = query.getCategory();
        String processDefinitionKey = query.getProcessDefinitionKey();
        String processDefinitionName = query.getProcessDefinitionName();
        String businessKey = query.getBusinessKey();
        String taskId = query.getTaskId();
        String taskName = query.getTaskName();
        String assignee = query.getAssignee();
        String candidateUser = query.getCandidateUser();
        String candidateGroup = query.getCandidateGroup();
        if (StringUtils.isNotBlank((CharSequence)assignee) && (StringUtils.isNotBlank((CharSequence)candidateUser) || StringUtils.isNotBlank((CharSequence)candidateGroup))) {
            throw new BizException("\u5b58\u5728\u6267\u884c\u4eba\u5165\u53c2\uff0c\u5019\u9009\u4eba\u548c\u5019\u9009\u7ec4\u5165\u53c2\u8981\u6c42\u4e3a\u7a7a\u503c\u8bf7\u6838\u5b9e!");
        }
        if ((StringUtils.isNotBlank((CharSequence)candidateUser) || StringUtils.isNotBlank((CharSequence)candidateGroup)) && StringUtils.isNotBlank((CharSequence)assignee)) {
            throw new BizException("\u5b58\u5728\u5019\u9009\u5165\u53c2\uff0c\u6267\u884c\u5165\u53c2\u8981\u6c42\u4e3a\u7a7a\u503c\u8bf7\u6838\u5b9e!");
        }
        TaskQuery queryCondition = this.taskService.createTaskQuery();
        if (StringUtils.isNotEmpty((CharSequence)category)) {
            queryCondition.processCategoryIn(Arrays.asList(category));
        }
        if (StringUtils.isNotEmpty((CharSequence)processDefinitionKey)) {
            queryCondition.processDefinitionKeyLike("%" + processDefinitionKey + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)processDefinitionName)) {
            queryCondition.processDefinitionNameLike("%" + processDefinitionName + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)businessKey)) {
            queryCondition.processInstanceBusinessKeyLike("%" + businessKey + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)taskId)) {
            queryCondition.taskId(taskId);
        }
        if (StringUtils.isNotEmpty((CharSequence)taskName)) {
            queryCondition.taskNameLike("%" + taskName + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)assignee)) {
            queryCondition.taskAssignee(assignee);
        }
        if (StringUtils.isNotEmpty((CharSequence)candidateUser)) {
            queryCondition.taskCandidateUser(candidateUser);
        }
        if (StringUtils.isNotEmpty((CharSequence)candidateGroup)) {
            queryCondition.taskCandidateGroup(candidateGroup);
        }
        int total = queryCondition.list().size();
        int start = (query.getPage() - 1) * query.getLimit();
        List pageList = ((TaskQuery)((TaskQuery)((TaskQuery)queryCondition.includeTaskLocalVariables()).orderByTaskCreateTime()).desc()).listPage(start, query.getLimit().intValue());
        for (Task task : pageList) {
            FlowCategory entity;
            ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().includeProcessVariables().processInstanceId(task.getProcessInstanceId()).singleResult();
            FlowTaskInfo info = new FlowTaskInfo(task, process);
            Set taskCandidateUser = this.getTaskCandidate(task.getId(), Integer.valueOf(0));
            info.setCandidateUser(org.apache.commons.lang3.StringUtils.join((Iterable)taskCandidateUser, (String)","));
            Set taskCandidateGroup = this.getTaskCandidate(task.getId(), Integer.valueOf(1));
            info.setCandidateGroups(org.apache.commons.lang3.StringUtils.join((Iterable)taskCandidateGroup, (String)","));
            String categoryCode = info.getCategory();
            if (StringUtils.isNotBlank((CharSequence)categoryCode) && (entity = this.workflowCategoryService.getInfoByCode(categoryCode)) != null) {
                info.setCategoryName(entity.getCategoryName());
            }
            results.add(info);
        }
        PageData page = new PageData(results, (long)total);
        return page;
    }

    public void approveTask(ProcessApproveForm form) {
        ProcessInstance processInstance;
        ValidatorUtils.validateEntity((Object)form, (Class[])new Class[0]);
        String taskId = form.getTaskId();
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        String processInstanceId = task.getProcessInstanceId();
        BusinessStatusEnum businessStatus = form.getBusinessStatus();
        String comment = form.getComment();
        String assignee = form.getAssignee();
        if (StringUtils.isBlank((CharSequence)assignee)) {
            String realAssignee = task.getAssignee();
            assignee = StringUtils.isNotBlank((CharSequence)realAssignee) ? realAssignee : SecurityUser.getUserId().toString();
        }
        Map formData = form.getFormData();
        this.runtimeService.setVariable(processInstanceId, "formData", (Object)formData);
        Integer approveResult = -1;
        if (businessStatus.equals((Object)BusinessStatusEnum.PASSED)) {
            approveResult = BusinessCommEnum.TaskStatus.PP_1.getCode();
        }
        if (businessStatus.equals((Object)BusinessStatusEnum.NOPASSED)) {
            approveResult = BusinessCommEnum.TaskStatus.PP_0.getCode();
        }
        HashMap<String, Object> localVariables = new HashMap<String, Object>();
        localVariables.put("approveStatus", approveResult);
        localVariables.put("approveUserId", SecurityUser.getUserId());
        localVariables.put("approveUserName", SecurityUser.getUsername());
        this.taskService.setVariablesLocal(taskId, localVariables);
        this.taskService.addComment(taskId, processInstanceId, comment);
        this.taskService.setAssignee(taskId, assignee);
        String taskCctoId = form.getTaskCctoId();
        if (StringUtils.isNotBlank((CharSequence)taskCctoId)) {
            String[] toIds;
            for (String toId : toIds = taskCctoId.split(",")) {
                List unCcList = this.undoTaskService.list((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"task_id", (Object)task.getId())).eq((Object)"user_id", (Object)toId)).in((Object)"user_type", Arrays.asList(2, 3))).eq((Object)"msg_status", (Object)0));
                if (!CollectionUtils.isEmpty((Collection)unCcList)) continue;
                TaskEntityImpl entity = new TaskEntityImpl();
                entity.setId(task.getId());
                entity.setName(task.getName());
                entity.setProcessInstanceId(task.getProcessInstanceId());
                entity.setCreateTime(task.getCreateTime());
                this.undoTaskService.sendCcToUser(toId, entity);
            }
        }
        log.info("nowTaskDefinitionKey:{}", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(taskId);
        if (StringUtils.isNotBlank((CharSequence)form.getNextApprover()) && (processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()) != null && !processInstance.isEnded()) {
            Task nextTask = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstance.getId())).active().singleResult();
            log.info("nextTaskDefinitionKey:{}", (Object)task.getTaskDefinitionKey());
            if (nextTask != null) {
                this.taskService.setAssignee(nextTask.getId(), form.getNextApprover());
            }
        }
    }

    public void pickupGroupTask(TaskParamQuery query) {
        String taskId = query.getTaskId();
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            throw new BizException("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        String candidateUser = query.getCandidateUser();
        String candidateGroup = query.getCandidateGroup();
        if (StringUtils.isNotBlank((CharSequence)candidateUser) && StringUtils.isEmpty((CharSequence)candidateGroup)) {
            Set taskCandidateUser = this.getTaskCandidate(taskId, Integer.valueOf(0));
            if (!taskCandidateUser.contains(candidateUser)) {
                throw new BizException("\u8be5\u7528\u6237\u975e\u5019\u9009\u4eba\u65e0\u6cd5\u62fe\u53d6\u6b64\u4efb\u52a1\uff0c\u8bf7\u6838\u5b9e\uff01");
            }
            this.taskService.claim(taskId, candidateUser);
        }
        if (StringUtils.isNotBlank((CharSequence)candidateGroup) && StringUtils.isEmpty((CharSequence)candidateUser)) {
            String assignee = query.getAssignee();
            if (StringUtils.isBlank((CharSequence)assignee)) {
                throw new BizException("\u6267\u884c\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
            }
            Set taskCandidateGroup = this.getTaskCandidate(taskId, Integer.valueOf(1));
            if (!taskCandidateGroup.contains(candidateGroup)) {
                throw new BizException("\u8be5\u7528\u6237\u975e\u5019\u9009\u7ec4\u65e0\u6cd5\u62fe\u53d6\u6b64\u4efb\u52a1\uff0c\u8bf7\u6838\u5b9e\uff01");
            }
            this.taskService.claim(taskId, assignee);
        }
    }

    public void returnGroupTask(TaskParamQuery query) {
        String taskId = query.getTaskId();
        if (StringUtils.isEmpty((CharSequence)taskId)) {
            throw new BizException("\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        String assignee = query.getAssignee();
        if (StringUtils.isEmpty((CharSequence)assignee)) {
            throw new BizException("\u6267\u884c\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e!");
        }
        Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).taskAssignee(assignee)).singleResult();
        if (task != null) {
            this.taskService.setAssignee(taskId, null);
            this.actRunTaskMapper.updateRunTaskClaimInfo(taskId);
        }
    }

    public void jump(String taskId, String sid, String comment) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new BizException("\u4efb\u52a1\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        String processDefinitionId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()).getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        String activityId = execution.getActivityId();
        FlowNode currentNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityId);
        FlowNode targetNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(sid);
        ArrayList<SequenceFlow> newSequenceFlowList = new ArrayList<SequenceFlow>();
        SequenceFlow newSequenceFlow = new SequenceFlow();
        newSequenceFlow.setId("newFlow");
        newSequenceFlow.setSourceFlowElement((FlowElement)currentNode);
        newSequenceFlow.setTargetFlowElement((FlowElement)targetNode);
        newSequenceFlowList.add(newSequenceFlow);
        List dataflows = currentNode.getOutgoingFlows();
        ArrayList oriSequenceFlows = new ArrayList();
        oriSequenceFlows.addAll(dataflows);
        currentNode.getOutgoingFlows().clear();
        currentNode.setOutgoingFlows(newSequenceFlowList);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)comment) && !"null".equals(comment)) {
            sb.append(comment);
            sb.append("_");
        }
        sb.append("\u9a73\u56de\u8df3\u8f6c\u8282\u70b9");
        this.taskService.addComment(taskId, task.getProcessInstanceId(), "comment", sb.toString());
        HashMap<String, Object> localVariables = new HashMap<String, Object>();
        localVariables.put("approveStatus", BusinessCommEnum.TaskStatus.PP_2.getCode());
        localVariables.put("approveUserId", SecurityUser.getUserId());
        localVariables.put("approveUserName", SecurityUser.getUsername());
        localVariables.put("targetNode", targetNode.getId());
        this.taskService.setVariablesLocal(taskId, localVariables);
        this.taskService.complete(taskId);
        currentNode.setOutgoingFlows(oriSequenceFlows);
    }

    public void forceEnd(String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new BizException("\u4efb\u52a1\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        String processDefinitionId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult()).getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        String activityId = execution.getActivityId();
        FlowNode currentNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityId);
        EndEvent end = new EndEvent();
        end.setName("\u5f3a\u5236\u7ed3\u675f");
        end.setId("forceEnd");
        ArrayList<SequenceFlow> newSequenceFlowList = new ArrayList<SequenceFlow>();
        SequenceFlow newSequenceFlow = new SequenceFlow();
        newSequenceFlow.setId("newFlow");
        newSequenceFlow.setSourceFlowElement((FlowElement)currentNode);
        newSequenceFlow.setTargetFlowElement((FlowElement)end);
        newSequenceFlowList.add(newSequenceFlow);
        List dataflows = currentNode.getOutgoingFlows();
        ArrayList oriSequenceFlows = new ArrayList();
        oriSequenceFlows.addAll(dataflows);
        currentNode.getOutgoingFlows().clear();
        currentNode.setOutgoingFlows(newSequenceFlowList);
        HashMap<String, Object> localVariables = new HashMap<String, Object>();
        localVariables.put("approveStatus", BusinessCommEnum.TaskStatus.PP_4.getCode());
        localVariables.put("approveUserId", SecurityUser.getUserId());
        localVariables.put("approveUserName", SecurityUser.getUsername());
        this.taskService.setVariablesLocal(taskId, localVariables);
        this.taskService.addComment(taskId, task.getProcessInstanceId(), "comment", "\u64a4\u9500\u6d41\u7a0b");
        this.taskService.complete(taskId);
        currentNode.setOutgoingFlows(oriSequenceFlows);
    }

    public void taskTransfer(String taskId, String assignee, String comment) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new BizException("\u4efb\u52a1\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        this.taskService.setAssignee(taskId, assignee);
        HashMap<String, Object> localVariables = new HashMap<String, Object>();
        localVariables.put("approveStatus", BusinessCommEnum.TaskStatus.PP_5.getCode());
        localVariables.put("approveUserId", SecurityUser.getUserId());
        localVariables.put("approveUserName", SecurityUser.getUsername());
        this.taskService.setVariablesLocal(taskId, localVariables);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)comment)) {
            this.taskService.addComment(taskId, task.getProcessInstanceId(), "comment", comment);
        }
    }

    public void taskToExamine(String taskId, String assignee, String comment) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new BizException("\u4efb\u52a1\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        this.taskService.setAssignee(taskId, assignee);
        HashMap<String, Object> localVariables = new HashMap<String, Object>();
        localVariables.put("approveStatus", BusinessCommEnum.TaskStatus.PP_5.getCode());
        localVariables.put("approveUserId", SecurityUser.getUserId());
        localVariables.put("approveUserName", SecurityUser.getUsername());
        this.taskService.setVariablesLocal(taskId, localVariables);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)comment)) {
            this.taskService.addComment(taskId, task.getProcessInstanceId(), "comment", comment);
        }
    }

    public void taskWithdraw(String taskId) {
        Task t = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(t.getProcessInstanceId()).singleResult();
        if (processInstance == null) {
            throw new BizException("\u64cd\u4f5c\u5931\u8d25\uff01\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\u3002");
        }
        String processDefinitionId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(t.getProcessInstanceId()).singleResult()).getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Process process = (Process)bpmnModel.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        String targetActivityId = "";
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof UserTask)) continue;
            UserTask userTask = (UserTask)flowElement;
            String id = userTask.getId();
            Map attributes = userTask.getAttributes();
            Map attrMap = CommUtils.parseAttributes((Map)attributes);
            String assignTypeVal = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_0.getCode());
            if (!StringUtils.isNotBlank((CharSequence)assignTypeVal) || !assignTypeVal.equals(BusinessCommEnum.AssignTypeEnum.PP_1.getCode())) continue;
            targetActivityId = id;
        }
        if (StringUtils.isNotBlank((CharSequence)targetActivityId)) {
            Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(t.getExecutionId()).singleResult();
            String activityId = execution.getActivityId();
            FlowNode currentNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityId);
            FlowNode targetNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(targetActivityId);
            ArrayList<SequenceFlow> newSequenceFlowList = new ArrayList<SequenceFlow>();
            SequenceFlow newSequenceFlow = new SequenceFlow();
            newSequenceFlow.setId("newFlow");
            newSequenceFlow.setSourceFlowElement((FlowElement)currentNode);
            newSequenceFlow.setTargetFlowElement((FlowElement)targetNode);
            newSequenceFlowList.add(newSequenceFlow);
            List dataflows = currentNode.getOutgoingFlows();
            ArrayList oriSequenceFlows = new ArrayList();
            oriSequenceFlows.addAll(dataflows);
            currentNode.getOutgoingFlows().clear();
            currentNode.setOutgoingFlows(newSequenceFlowList);
            HashMap<String, Object> localVariables = new HashMap<String, Object>();
            localVariables.put("approveStatus", BusinessCommEnum.TaskStatus.PP_3.getCode());
            localVariables.put("approveUserId", SecurityUser.getUserId());
            localVariables.put("approveUserName", SecurityUser.getUsername());
            localVariables.put("targetNode", targetNode.getId());
            this.taskService.setVariablesLocal(taskId, localVariables);
            this.taskService.addComment(taskId, t.getProcessInstanceId(), "comment", "\u64a4\u9500\u7533\u8bf7");
            this.taskService.complete(taskId);
            currentNode.setOutgoingFlows(oriSequenceFlows);
        }
    }

    public Set<String> getTaskCandidate(String taskId, Integer flag) {
        HashSet<String> candidates = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                String type;
                if (flag == 0) {
                    type = identityLink.getType();
                    String userId = identityLink.getUserId();
                    if (StringUtils.isNotBlank((CharSequence)userId) && "candidate".equals(type)) {
                        List<String> candidateList = Arrays.asList(userId.split(","));
                        candidates.addAll(candidateList);
                    }
                }
                if (flag != 1) continue;
                type = identityLink.getType();
                String groupId = identityLink.getGroupId();
                if (!StringUtils.isNotBlank((CharSequence)groupId) || !"candidate".equals(type)) continue;
                candidates.addAll(Arrays.asList(groupId.split(",")));
            }
        }
        return candidates;
    }

    public FlowTaskInfo getTaskInfosByTaskId(String taskId) {
        FlowTaskInfo result = new FlowTaskInfo();
        Task t = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).taskId(taskId)).singleResult();
        if (t != null) {
            FlowCategory entity;
            ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().includeProcessVariables().processInstanceId(t.getProcessInstanceId()).singleResult();
            result = new FlowTaskInfo(t, process);
            String categoryCode = result.getCategory();
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)categoryCode) && (entity = this.workflowCategoryService.getInfoByCode(categoryCode)) != null) {
                result.setCategoryName(entity.getCategoryName());
            }
            Set taskCandidateUser = this.getTaskCandidate(t.getId(), Integer.valueOf(0));
            result.setCandidateUser(org.apache.commons.lang3.StringUtils.join((Iterable)taskCandidateUser, (String)","));
            Set taskCandidateGroup = this.getTaskCandidate(t.getId(), Integer.valueOf(1));
            result.setCandidateGroups(org.apache.commons.lang3.StringUtils.join((Iterable)taskCandidateGroup, (String)","));
            ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().includeProcessVariables().processInstanceId(t.getProcessInstanceId()).singleResult();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(instance.getProcessDefinitionId());
            Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(t.getExecutionId()).singleResult();
            String activityId = execution.getActivityId();
            FlowNode currentNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(activityId);
            Map attributes = currentNode.getAttributes();
            Map attrMap = CommUtils.parseAttributes((Map)attributes);
            String buttonsVal = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_2.getCode());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)buttonsVal) && !"null".equals(buttonsVal)) {
                JSONArray array = JSONUtil.parseArray((String)buttonsVal);
                List entities = JSONUtil.toList((JSONArray)array, ProcessButtonComm.class);
                result.setButtons(entities);
            }
            result.setTaskAttributes(attrMap);
            FlowNode nextFlowElement = this.getNextFlowElement(taskId);
            if (nextFlowElement != null) {
                Map taskAttributes = FlowUtils.getTaskAttributes((FlowNode)nextFlowElement);
                UserTask userTask = (UserTask)nextFlowElement;
                String assignee = userTask.getAssignee();
                String userAttr = (String)taskAttributes.get(BusinessCommEnum.ProcessAttrEnum.PP_5.getCode());
                String roleAttr = (String)taskAttributes.get(BusinessCommEnum.ProcessAttrEnum.PP_6.getCode());
                if (StringUtils.isBlank((CharSequence)userAttr) && StringUtils.isBlank((CharSequence)roleAttr) && StringUtils.isNotBlank((CharSequence)assignee)) {
                    taskAttributes.put(BusinessCommEnum.ProcessAttrEnum.PP_5.getCode(), assignee);
                }
                result.setNextTaskAttributes(taskAttributes);
            }
            Boolean isStarterNode = false;
            String assignTypeVal = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_0.getCode());
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)assignTypeVal) && assignTypeVal.equals(BusinessCommEnum.AssignTypeEnum.PP_1.getCode())) {
                isStarterNode = true;
            }
            result.setIsStarterNode(isStarterNode);
            Boolean isEndTaskNode = false;
            if (nextFlowElement == null) {
                isEndTaskNode = true;
            }
            result.setIsEndTaskNode(isEndTaskNode);
            Boolean isHaveCcToUser = false;
            String taskCcto = (String)attrMap.get(BusinessCommEnum.ProcessAttrEnum.PP_8.getCode());
            if (StringUtils.isNotBlank((CharSequence)taskCcto) && !"null".equals(taskCcto)) {
                isHaveCcToUser = true;
            }
            result.setIsHaveCcToUser(isHaveCcToUser);
        } else {
            HistoricProcessInstance historicProcess;
            HistoricTaskInstance historicTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().includeTaskLocalVariables()).taskId(taskId)).singleResult();
            if (historicTask != null && (historicProcess = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().includeProcessVariables().processInstanceId(historicTask.getProcessInstanceId()).singleResult()) != null) {
                result = new FlowTaskInfo(historicTask, historicProcess);
            }
        }
        return result;
    }

    public FlowNode getNextFlowElement(String taskId) {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        BpmnModel bpmnModel = FlowUtils.getBpmnModel((String)task.getProcessDefinitionId());
        ExecutionEntity executionEntity = (ExecutionEntity)this.runtimeService.createExecutionQuery().executionId(task.getExecutionId()).singleResult();
        String currentActivityId = executionEntity.getActivityId();
        FlowNode flowNode = (FlowNode)bpmnModel.getFlowElement(currentActivityId);
        List outgoingFlows = flowNode.getOutgoingFlows();
        for (SequenceFlow outgoingFlow : outgoingFlows) {
            FlowElement targetFlowElement = outgoingFlow.getTargetFlowElement();
            if (targetFlowElement instanceof EndEvent) {
                return null;
            }
            if (targetFlowElement instanceof UserTask) {
                return (UserTask)targetFlowElement;
            }
            if (targetFlowElement instanceof ExclusiveGateway) {
                try {
                    ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).includeProcessVariables().singleResult();
                    return this.handleExclusiveGateway(targetFlowElement, processInstance);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (!(targetFlowElement instanceof ParallelGateway)) continue;
            FlowElement target = ((SequenceFlow)((ParallelGateway)targetFlowElement).getOutgoingFlows().get(0)).getTargetFlowElement();
            if (target instanceof UserTask) {
                return (UserTask)target;
            }
            return null;
        }
        return null;
    }

    private UserTask handleExclusiveGateway(FlowElement flowElement, ProcessInstance processInstance) {
        Map processVariables = processInstance.getProcessVariables();
        List targetFlows = ((Gateway)flowElement).getOutgoingFlows();
        for (SequenceFlow sequenceFlow : targetFlows) {
            String conditionExpression = sequenceFlow.getConditionExpression();
            if (!this.checkFormDataByRuleEl(conditionExpression, processVariables)) continue;
            FlowElement targetFlowElement = sequenceFlow.getTargetFlowElement();
            if (targetFlowElement instanceof UserTask) {
                return (UserTask)targetFlowElement;
            }
            if (targetFlowElement instanceof EndEvent) {
                return null;
            }
            if (targetFlowElement instanceof ServiceTask) {
                return (UserTask)targetFlowElement;
            }
            if (!(targetFlowElement instanceof Gateway)) continue;
            this.handleExclusiveGateway(targetFlowElement, processInstance);
        }
        return null;
    }

    private boolean checkFormDataByRuleEl(String el, Map<String, Object> formData) {
        ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
        return (Boolean)processEngine.getManagementService().executeCommand((Command)new ExpressionCommand(el, formData));
    }
}

