/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.service.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.njhm.workflow.dto.event.FlowNoticeEvent;
import com.njhm.workflow.dto.event.FlowTaskNotice;
import com.njhm.workflow.enums.BusinessCommEnum;
import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.service.AsyncService;
import com.njhm.workflow.service.SynExplogService;
import com.njhm.workflow.utils.CommUtils;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class AsyncServiceImpl
implements AsyncService {
    private static final Logger log = LoggerFactory.getLogger(AsyncServiceImpl.class);
    @Autowired
    private SynExplogService synExplogService;

    @Async
    public void httpCallBack(FlowNoticeEvent flowNoticeEvent, String callBackUrl) {
        try {
            JSONObject entries;
            String code;
            boolean callBackResult = false;
            String body = JSONUtil.toJsonStr((Object)flowNoticeEvent);
            log.info("\u5f00\u59cb\u5f02\u6b65\u56de\u8c03\u63a5\u53e3\u3002\u8868\u5355\uff1a{}, \u56de\u8c03\u5730\u5740\uff1a{}", (Object)body, (Object)callBackUrl);
            HttpPost httpPost = new HttpPost(callBackUrl);
            httpPost.setEntity((HttpEntity)new StringEntity(body, ContentType.APPLICATION_JSON));
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(30L, TimeUnit.SECONDS).setConnectTimeout(30L, TimeUnit.SECONDS).setResponseTimeout(30L, TimeUnit.SECONDS).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpClient httpclient = HttpClients.createDefault();
            CloseableHttpResponse response = null;
            long t = System.currentTimeMillis();
            response = httpclient.execute((ClassicHttpRequest)httpPost);
            log.info("\u4e1a\u52a1\u63a5\u53e3\u56de\u8c03\u5b8c\u6210\uff01\u5171\u8ba1\u8017\u65f6{} \u6beb\u79d2", (Object)(System.currentTimeMillis() - t));
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("\u56de\u8c03\u63a5\u53e3\u8fd4\u56de>>>>>>\u8868\u5355\uff1a{}, \u56de\u8c03\u5730\u5740\uff1a{}, \u8fd4\u56de\u503c\uff1a{}", new Object[]{body, callBackUrl, result});
            if (response.getCode() == 200 && ("200".equals(code = (entries = JSONUtil.parseObj((String)result)).getStr((Object)"code", "")) || "0".equals(code))) {
                callBackResult = true;
            }
            if (!callBackResult) {
                throw new BizException("\u4e1a\u52a1\u7cfb\u7edf\u56de\u8c03\u5931\u8d25:" + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            httpclient.close();
            if (response != null) {
                response.close();
            }
        }
        catch (Exception e) {
            log.info("\u3010\u6d41\u7a0b\u56de\u8c03\u3011\u5f02\u6b65\u56de\u8c03\u5f02\u5e38");
            String event = flowNoticeEvent.getEvent();
            String exptionCause = CommUtils.getExceptionMsg((Exception)e);
            FlowTaskNotice notice = flowNoticeEvent.getBody();
            String content = JSONUtil.toJsonStr((Object)notice);
            this.synExplogService.exceptionRecord(BusinessCommEnum.ModelTypeEnum.PP_1.getCode(), BusinessCommEnum.BizTypeEnum.PP_1.getCode(), event + ">>>" + callBackUrl, exptionCause, content);
            e.printStackTrace();
        }
    }
}

