/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.njhm.workflow.dto.WorkflowButtonDTO;
import com.njhm.workflow.entity.WorkflowButton;
import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.mapper.WorkflowButtonMapper;
import com.njhm.workflow.query.WorkflowButtonQuery;
import com.njhm.workflow.service.WorkflowButtonService;
import com.njhm.workflow.utils.ValidatorUtils;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowButtonServiceImpl
extends ServiceImpl<WorkflowButtonMapper, WorkflowButton>
implements WorkflowButtonService {
    @Autowired
    private WorkflowButtonMapper workflowButtonMapper;

    public List<WorkflowButton> findByCodes(List<String> codes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(WorkflowButton::getStatus, (Object)1)).in(WorkflowButton::getButtonCode, codes)).list();
    }

    public List<WorkflowButton> getList(WorkflowButtonQuery query) {
        String buttonCode = query.getButtonCode();
        String buttonName = query.getButtonName();
        String buttonTheme = query.getButtonTheme();
        Integer status = query.getStatus();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)buttonCode)) {
            queryWrapper.eq((Object)"button_code", (Object)buttonCode);
        }
        if (StringUtils.isNotBlank((CharSequence)buttonName)) {
            queryWrapper.like((Object)"button_name", (Object)buttonName);
        }
        if (StringUtils.isNotBlank((CharSequence)buttonTheme)) {
            queryWrapper.like((Object)"button_theme", (Object)buttonTheme);
        }
        if (status != null) {
            queryWrapper.eq((Object)"status", (Object)status);
        }
        queryWrapper.orderByDesc((Object)"sort");
        List results = this.workflowButtonMapper.selectList((Wrapper)queryWrapper);
        return results;
    }

    public void addButtonEntity(WorkflowButtonDTO dto) {
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        QueryWrapper codeWrapper = new QueryWrapper();
        codeWrapper.eq((Object)"button_code", (Object)dto.getButtonCode());
        WorkflowButton codeEntity = (WorkflowButton)this.workflowButtonMapper.selectOne((Wrapper)codeWrapper);
        if (codeEntity != null) {
            throw new BizException("\u6309\u94ae\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        QueryWrapper nameWrapper = new QueryWrapper();
        nameWrapper.eq((Object)"button_name", (Object)dto.getButtonCode());
        WorkflowButton nameEntity = (WorkflowButton)this.workflowButtonMapper.selectOne((Wrapper)nameWrapper);
        if (nameEntity != null) {
            throw new BizException("\u6309\u94ae\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        WorkflowButton entity = new WorkflowButton();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        entity.setCreateTime(new Date());
        entity.setUpdateTime(new Date());
        this.workflowButtonMapper.insert((Object)entity);
    }

    public void updateButtonEntity(WorkflowButtonDTO dto) {
        Long id = dto.getId();
        if (id == null) {
            throw new BizException("\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        QueryWrapper codeWrapper = new QueryWrapper();
        codeWrapper.eq((Object)"button_code", (Object)dto.getButtonCode());
        WorkflowButton codeEntity = (WorkflowButton)this.workflowButtonMapper.selectOne((Wrapper)codeWrapper);
        if (codeEntity != null && id.longValue() != codeEntity.getId().longValue()) {
            throw new BizException("\u6309\u94ae\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        QueryWrapper nameWrapper = new QueryWrapper();
        nameWrapper.eq((Object)"button_name", (Object)dto.getButtonCode());
        WorkflowButton nameEntity = (WorkflowButton)this.workflowButtonMapper.selectOne((Wrapper)nameWrapper);
        if (nameEntity != null && id.longValue() != nameEntity.getId().longValue()) {
            throw new BizException("\u6309\u94ae\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e\uff01");
        }
        WorkflowButton entity = new WorkflowButton();
        BeanUtils.copyProperties((Object)dto, (Object)entity);
        entity.setUpdateTime(new Date());
        this.workflowButtonMapper.updateById((Object)entity);
    }
}

