/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.njhm.workflow.dto.FlowCategory;
import com.njhm.workflow.entity.WorkflowCategory;
import com.njhm.workflow.mapper.WorkflowCategoryMapper;
import com.njhm.workflow.query.CategoryQuery;
import com.njhm.workflow.service.WorkflowCategoryService;
import com.njhm.workflow.utils.PageData;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowCategoryServiceImpl
extends ServiceImpl<WorkflowCategoryMapper, WorkflowCategory>
implements WorkflowCategoryService {
    @Autowired
    private WorkflowCategoryMapper workflowCategoryMapper;

    public PageData<FlowCategory> listPage(CategoryQuery query) {
        ArrayList<FlowCategory> results = new ArrayList<FlowCategory>();
        String categoryCode = query.getCategoryCode();
        String categoryName = query.getCategoryName();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)categoryCode)) {
            queryWrapper.eq((Object)"category_code", (Object)categoryCode);
        }
        if (StringUtils.isNotBlank((CharSequence)categoryName)) {
            queryWrapper.like((Object)"category_name", (Object)categoryName);
        }
        queryWrapper.orderByDesc((Object)"create_time");
        Page pageDatas = (Page)this.workflowCategoryMapper.selectPage((IPage)new Page(query.getPage().longValue(), query.getLimit().longValue(), true), (Wrapper)queryWrapper);
        List records = pageDatas.getRecords();
        for (WorkflowCategory record : records) {
            FlowCategory result = new FlowCategory();
            BeanUtils.copyProperties((Object)record, (Object)result);
            results.add(result);
        }
        PageData page = new PageData(results, pageDatas.getTotal());
        return page;
    }

    public FlowCategory getInfoByCode(String categoryCode) {
        FlowCategory result = new FlowCategory();
        WorkflowCategory entity = (WorkflowCategory)((WorkflowCategoryMapper)this.baseMapper).selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"category_code", (Object)categoryCode)).eq((Object)"status", (Object)1));
        if (entity != null) {
            BeanUtils.copyProperties((Object)entity, (Object)result);
        }
        return result;
    }
}

