/*
 * Copyright 2022. cnofd All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * You may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * cnofd.js - A Javascript class for reading and rendering ofd files
 * <https://gitee.com/cnofd>
 *
 */
(function(t, e) {
	"object" === typeof exports && "object" === typeof module ? module.exports = e() : "function" === typeof define && define.amd ? define([], e) : "object" === typeof exports ? exports["cnofd"] = e() : t["cnofd"] = e()
})("undefined" !== typeof self ? self : this, (function() {
	return function(t) {
		var e = {};

		function r(n) {
			if (e[n]) return e[n].exports;
			var i = e[n] = {
				i: n,
				l: !1,
				exports: {}
			};
			return t[n].call(i.exports, i, i.exports, r), i.l = !0, i.exports
		}
		return r.m = t, r.c = e, r.d = function(t, e, n) {
			r.o(t, e) || Object.defineProperty(t, e, {
				enumerable: !0,
				get: n
			})
		}, r.r = function(t) {
			"undefined" !== typeof Symbol && Symbol.toStringTag && Object.defineProperty(t, Symbol.toStringTag, {
				value: "Module"
			}), Object.defineProperty(t, "__esModule", {
				value: !0
			})
		}, r.t = function(t, e) {
			if (1 & e && (t = r(t)), 8 & e) return t;
			if (4 & e && "object" === typeof t && t && t.__esModule) return t;
			var n = Object.create(null);
			if (r.r(n), Object.defineProperty(n, "default", {
				enumerable: !0,
				value: t
			}), 2 & e && "string" != typeof t)
				for (var i in t) r.d(n, i, function(e) {
					return t[e]
				}.bind(null, i));
			return n
		}, r.n = function(t) {
			var e = t && t.__esModule ? function() {
				return t["default"]
			} : function() {
				return t
			};
			return r.d(e, "a", e), e
		}, r.o = function(t, e) {
			return Object.prototype.hasOwnProperty.call(t, e)
		}, r.p = "", r(r.s = "fae3")
	}({
		"0083": function(t, e, r) {
			"use strict";
			var n = {};

			function i() {
				try {
					return new window.XMLHttpRequest
				} catch (t) {}
			}

			function o() {
				try {
					return new window.ActiveXObject("Microsoft.XMLHTTP")
				} catch (t) {}
			}
			n._getBinaryFromXHR = function(t) {
				return t.response || t.responseText
			};
			var a = "undefined" !== typeof window && window.ActiveXObject ? function() {
				return i() || o()
			} : i;
			n.getBinaryContent = function(t, e) {
				var r, i, o, s;
				e || (e = {}), "function" === typeof e ? (s = e, e = {}) : "function" === typeof e.callback && (s = e.callback), s || "undefined" === typeof Promise ? (i = function(t) {
					s(null, t)
				}, o = function(t) {
					s(t, null)
				}) : r = new Promise((function(t, e) {
					i = t, o = e
				}));
				try {
					var c = a();
					c.open("GET", t, !0), "responseType" in c && (c.responseType = "arraybuffer"), c.overrideMimeType && c.overrideMimeType("text/plain; charset=x-user-defined"), c.onreadystatechange = function(e) {
						if (4 === c.readyState)
							if (200 === c.status || 0 === c.status) try {
								i(n._getBinaryFromXHR(c))
							} catch (r) {
								o(new Error(r))
							} else o(new Error("Ajax error for " + t + " : " + this.status + " " + this.statusText))
					}, e.progress && (c.onprogress = function(r) {
						e.progress({
							path: t,
							originalEvent: r,
							percent: r.loaded / r.total * 100,
							loaded: r.loaded,
							total: r.total
						})
					}), c.send()
				} catch (u) {
					o(new Error(u), null)
				}
				return r
			}, t.exports = n
		},
		"0094": function(t, e, r) {
			"use strict";
			var n, i = r("da84"),
				o = r("e330"),
				a = r("6964"),
				s = r("f183"),
				c = r("6d61"),
				u = r("acac"),
				d = r("861d"),
				l = r("4fad"),
				f = r("69f3")
				.enforce,
				h = r("7f9a"),
				p = !i.ActiveXObject && "ActiveXObject" in i,
				m = function(t) {
					return function() {
						return t(this, arguments.length ? arguments[0] : void 0)
					}
				},
				b = c("WeakMap", m, u);
			if (h && p) {
				n = u.getConstructor(m, "WeakMap", !0), s.enable();
				var g = b.prototype,
					y = o(g["delete"]),
					v = o(g.has),
					S = o(g.get),
					w = o(g.set);
				a(g, {
					delete: function(t) {
						if (d(t) && !l(t)) {
							var e = f(this);
							return e.frozen || (e.frozen = new n), y(this, t) || e.frozen["delete"](t)
						}
						return y(this, t)
					},
					has: function(t) {
						if (d(t) && !l(t)) {
							var e = f(this);
							return e.frozen || (e.frozen = new n), v(this, t) || e.frozen.has(t)
						}
						return v(this, t)
					},
					get: function(t) {
						if (d(t) && !l(t)) {
							var e = f(this);
							return e.frozen || (e.frozen = new n), v(this, t) ? S(this, t) : e.frozen.get(t)
						}
						return S(this, t)
					},
					set: function(t, e) {
						if (d(t) && !l(t)) {
							var r = f(this);
							r.frozen || (r.frozen = new n), v(this, t) ? w(this, t, e) : r.frozen.set(t, e)
						} else w(this, t, e);
						return this
					}
				})
			}
		},
		"00ee": function(t, e, r) {
			var n = r("b622"),
				i = n("toStringTag"),
				o = {};
			o[i] = "z", t.exports = "[object z]" === String(o)
		},
		"01b4": function(t, e) {
			var r = function() {
				this.head = null, this.tail = null
			};
			r.prototype = {
				add: function(t) {
					var e = {
						item: t,
						next: null
					};
					this.head ? this.tail.next = e : this.head = e, this.tail = e
				},
				get: function() {
					var t = this.head;
					if (t) return this.head = t.next, this.tail === t && (this.tail = null), t.item
				}
			}, t.exports = r
		},
		"0366": function(t, e, r) {
			var n = r("e330"),
				i = r("59ed"),
				o = r("40d5"),
				a = n(n.bind);
			t.exports = function(t, e) {
				return i(t), void 0 === e ? t : o ? a(t, e) : function() {
					return t.apply(e, arguments)
				}
			}
		},
		"057f": function(t, e, r) {
			var n = r("c6b6"),
				i = r("fc6a"),
				o = r("241c")
				.f,
				a = r("4dae"),
				s = "object" == typeof window && window && Object.getOwnPropertyNames ? Object.getOwnPropertyNames(window) : [],
				c = function(t) {
					try {
						return o(t)
					} catch (e) {
						return a(s)
					}
				};
			t.exports.f = function(t) {
				return s && "Window" == n(t) ? c(t) : o(i(t))
			}
		},
		"06cf": function(t, e, r) {
			var n = r("83ab"),
				i = r("c65b"),
				o = r("d1e7"),
				a = r("5c6c"),
				s = r("fc6a"),
				c = r("a04b"),
				u = r("1a2d"),
				d = r("0cfb"),
				l = Object.getOwnPropertyDescriptor;
			e.f = n ? l : function(t, e) {
				if (t = s(t), e = c(e), d) try {
					return l(t, e)
				} catch (r) {}
				if (u(t, e)) return a(!i(o.f, t, e), t[e])
			}
		},
		"07ac": function(t, e, r) {
			var n = r("23e7"),
				i = r("6f53")
				.values;
			n({
				target: "Object",
				stat: !0
			}, {
				values: function(t) {
					return i(t)
				}
			})
		},
		"07fa": function(t, e, r) {
			var n = r("50c4");
			t.exports = function(t) {
				return n(t.length)
			}
		},
		"0a06": function(t, e, r) {
			"use strict";
			var n = r("c532"),
				i = r("30b5"),
				o = r("f6b4"),
				a = r("5270"),
				s = r("4a7b");

			function c(t) {
				this.defaults = t, this.interceptors = {
					request: new o,
					response: new o
				}
			}
			c.prototype.request = function(t) {
				"string" === typeof t ? (t = arguments[1] || {}, t.url = arguments[0]) : t = t || {}, t = s(this.defaults, t), t.method ? t.method = t.method.toLowerCase() : this.defaults.method ? t.method = this.defaults.method.toLowerCase() : t.method = "get";
				var e = [a, void 0],
					r = Promise.resolve(t);
				this.interceptors.request.forEach((function(t) {
					e.unshift(t.fulfilled, t.rejected)
				})), this.interceptors.response.forEach((function(t) {
					e.push(t.fulfilled, t.rejected)
				}));
				while (e.length) r = r.then(e.shift(), e.shift());
				return r
			}, c.prototype.getUri = function(t) {
				return t = s(this.defaults, t), i(t.url, t.params, t.paramsSerializer)
					.replace(/^\?/, "")
			}, n.forEach(["delete", "get", "head", "options"], (function(t) {
				c.prototype[t] = function(e, r) {
					return this.request(s(r || {}, {
						method: t,
						url: e
					}))
				}
			})), n.forEach(["post", "put", "patch"], (function(t) {
				c.prototype[t] = function(e, r, n) {
					return this.request(s(n || {}, {
						method: t,
						url: e,
						data: r
					}))
				}
			})), t.exports = c
		},
		"0b42": function(t, e, r) {
			var n = r("da84"),
				i = r("e8b5"),
				o = r("68ee"),
				a = r("861d"),
				s = r("b622"),
				c = s("species"),
				u = n.Array;
			t.exports = function(t) {
				var e;
				return i(t) && (e = t.constructor, o(e) && (e === u || i(e.prototype)) ? e = void 0 : a(e) && (e = e[c], null === e && (e = void 0))), void 0 === e ? u : e
			}
		},
		"0c47": function(t, e, r) {
			var n = r("da84"),
				i = r("d44e");
			i(n.JSON, "JSON", !0)
		},
		"0ccb": function(t, e, r) {
			var n = r("e330"),
				i = r("50c4"),
				o = r("577e"),
				a = r("1148"),
				s = r("1d80"),
				c = n(a),
				u = n("".slice),
				d = Math.ceil,
				l = function(t) {
					return function(e, r, n) {
						var a, l, f = o(s(e)),
							h = i(r),
							p = f.length,
							m = void 0 === n ? " " : o(n);
						return h <= p || "" == m ? f : (a = h - p, l = c(m, d(a / m.length)), l.length > a && (l = u(l, 0, a)), t ? f + l : l + f)
					}
				};
			t.exports = {
				start: l(!1),
				end: l(!0)
			}
		},
		"0cfb": function(t, e, r) {
			var n = r("83ab"),
				i = r("d039"),
				o = r("cc12");
			t.exports = !n && !i((function() {
				return 7 != Object.defineProperty(o("div"), "a", {
						get: function() {
							return 7
						}
					})
					.a
			}))
		},
		"0d3b": function(t, e, r) {
			var n = r("d039"),
				i = r("b622"),
				o = r("c430"),
				a = i("iterator");
			t.exports = !n((function() {
				var t = new URL("b?a=1&b=2&c=3", "http://a"),
					e = t.searchParams,
					r = "";
				return t.pathname = "c%20d", e.forEach((function(t, n) {
						e["delete"]("b"), r += n + t
					})), o && !t.toJSON || !e.sort || "http://a/c%20d?a=1&c=3" !== t.href || "3" !== e.get("c") || "a=1" !== String(new URLSearchParams("?a=1")) || !e[a] || "a" !== new URL("https://a@b")
					.username || "b" !== new URLSearchParams(new URLSearchParams("a=b"))
					.get("a") || "xn--e1aybc" !== new URL("http://тест")
					.host || "#%D0%B1" !== new URL("http://a#б")
					.hash || "a1c3" !== r || "x" !== new URL("http://x", void 0)
					.host
			}))
		},
		"0d51": function(t, e, r) {
			var n = r("da84"),
				i = n.String;
			t.exports = function(t) {
				try {
					return i(t)
				} catch (e) {
					return "Object"
				}
			}
		},
		"0df6": function(t, e, r) {
			"use strict";
			t.exports = function(t) {
				return function(e) {
					return t.apply(null, e)
				}
			}
		},
		"10d1": function(t, e, r) {
			r("0094")
		},
		1148: function(t, e, r) {
			"use strict";
			var n = r("da84"),
				i = r("5926"),
				o = r("577e"),
				a = r("1d80"),
				s = n.RangeError;
			t.exports = function(t) {
				var e = o(a(this)),
					r = "",
					n = i(t);
				if (n < 0 || n == 1 / 0) throw s("Wrong number of repetitions");
				for (; n > 0;
					(n >>>= 1) && (e += e)) 1 & n && (r += e);
				return r
			}
		},
		"13d2": function(t, e, r) {
			var n = r("d039"),
				i = r("1626"),
				o = r("1a2d"),
				a = r("83ab"),
				s = r("5e77")
				.CONFIGURABLE,
				c = r("8925"),
				u = r("69f3"),
				d = u.enforce,
				l = u.get,
				f = Object.defineProperty,
				h = a && !n((function() {
					return 8 !== f((function() {}), "length", {
							value: 8
						})
						.length
				})),
				p = String(String)
				.split("String"),
				m = t.exports = function(t, e, r) {
					if ("Symbol(" === String(e)
						.slice(0, 7) && (e = "[" + String(e)
							.replace(/^Symbol\(([^)]*)\)/, "$1") + "]"), r && r.getter && (e = "get " + e), r && r.setter && (e = "set " + e), (!o(t, "name") || s && t.name !== e) && f(t, "name", {
							value: e,
							configurable: !0
						}), h && r && o(r, "arity") && t.length !== r.arity && f(t, "length", {
							value: r.arity
						}), r && o(r, "constructor") && r.constructor) {
						if (a) try {
							f(t, "prototype", {
								writable: !1
							})
						} catch (i) {}
					} else t.prototype = void 0;
					var n = d(t);
					return o(n, "source") || (n.source = p.join("string" == typeof e ? e : "")), t
				};
			Function.prototype.toString = m((function() {
				return i(this) && l(this)
					.source || c(this)
			}), "toString")
		},
		"14a5": function(t, e, r) {
			var n, i, o;

			function a(t) {
				return a = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t) {
					return typeof t
				} : function(t) {
					return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
				}, a(t)
			}(function(r, a) {
				i = [], n = a(), o = "function" === typeof n ? n.apply(e, i) : n, void 0 === o || (t.exports = o)
			})(0, (function() {
				var t, e = {},
					r = {
						watermark_id: "wm_div_id",
						watermark_prefix: "mask_div_id",
						watermark_txt: "测试水印",
						watermark_x: 20,
						watermark_y: 20,
						watermark_rows: 0,
						watermark_cols: 0,
						watermark_x_space: 50,
						watermark_y_space: 50,
						watermark_font: "微软雅黑",
						watermark_color: "black",
						watermark_fontsize: "18px",
						watermark_alpha: .15,
						watermark_width: 100,
						watermark_height: 100,
						watermark_angle: 15,
						watermark_parent_width: 0,
						watermark_parent_height: 0,
						watermark_parent_node: null,
						monitor: !0
					},
					n = function(t) {
						r.watermark_id = t.watermark_id || r.watermark_id, r.watermark_prefix = t.watermark_prefix || r.watermark_prefix, r.watermark_txt = t.watermark_txt || r.watermark_txt, r.watermark_x = t.watermark_x || r.watermark_x, r.watermark_y = t.watermark_y || r.watermark_y, r.watermark_rows = t.watermark_rows || r.watermark_rows, r.watermark_cols = t.watermark_cols || r.watermark_cols, r.watermark_x_space = t.watermark_x_space || r.watermark_x_space, r.watermark_y_space = t.watermark_y_space || r.watermark_y_space, r.watermark_font = t.watermark_font || r.watermark_font, r.watermark_color = t.watermark_color || r.watermark_color, r.watermark_fontsize = t.watermark_fontsize || r.watermark_fontsize, r.watermark_alpha = t.watermark_alpha || r.watermark_alpha, r.watermark_width = t.watermark_width || r.watermark_width, r.watermark_height = t.watermark_height || r.watermark_height, r.watermark_angle = t.watermark_angle || r.watermark_angle, r.watermark_parent_width = t.watermark_parent_width || r.watermark_parent_width, r.watermark_parent_height = t.watermark_parent_height || r.watermark_parent_height, r.watermark_parent_node = t.watermark_parent_node || r.watermark_parent_node, r.monitor = t.monitor || r.monitor
					};
				t = function(t) {
					if (1 === arguments.length && "object" === a(arguments[0])) {
						var e = arguments[0] || {};
						for (key in e) e[key] && r[key] && e[key] === r[key] || (e[key] || 0 === e[key]) && (r[key] = e[key])
					}
					n(t);
					var i = document.getElementById(r.watermark_id);
					i && i.parentNode && i.parentNode.removeChild(i);
					var o = document.getElementById(r.watermark_parent_node),
						s = o || document.body,
						c = Math.max(s.scrollWidth, s.clientWidth),
						l = Math.max(s.scrollHeight, s.clientHeight),
						f = arguments[0] || {},
						h = s,
						p = 0,
						m = 0;
					f.watermark_parent_width || f.watermark_parent_height ? h && (p = h.offsetTop || 0, m = h.offsetLeft || 0, r.watermark_x = r.watermark_x + m, r.watermark_y = r.watermark_y + p) : h && (p = h.offsetTop || 0, m = h.offsetLeft || 0);
					var b = document.getElementById(r.watermark_id),
						g = null;
					if (b) b.shadowRoot && (g = b.shadowRoot);
					else {
						b = document.createElement("div"), b.id = r.watermark_id, b.setAttribute("style", "pointer-events: none !important; display: block !important"), g = "function" === typeof b.attachShadow ? b.attachShadow({
							mode: "open"
						}) : b;
						var y = s.children,
							v = Math.floor(Math.random() * (y.length - 1));
						y[v] ? s.insertBefore(b, y[v]) : s.appendChild(b)
					}
					r.watermark_cols = parseInt((c - r.watermark_x) / (r.watermark_width + r.watermark_x_space) || 0);
					var S, w = parseInt((c - r.watermark_x - r.watermark_width * r.watermark_cols) / r.watermark_cols);
					r.watermark_x_space = w ? r.watermark_x_space : w, r.watermark_rows = parseInt((l - r.watermark_y) / (r.watermark_height + r.watermark_y_space) || 0);
					var C, _, A, I = parseInt((l - r.watermark_y - r.watermark_height * r.watermark_rows) / r.watermark_rows);
					r.watermark_y_space = I ? r.watermark_y_space : I, o ? (S = r.watermark_x + r.watermark_width * r.watermark_cols + r.watermark_x_space * (r.watermark_cols - 1), C = r.watermark_y + r.watermark_height * r.watermark_rows + r.watermark_y_space * (r.watermark_rows - 1)) : (S = m + r.watermark_x + r.watermark_width * r.watermark_cols + r.watermark_x_space * (r.watermark_cols - 1), C = p + r.watermark_y + r.watermark_height * r.watermark_rows + r.watermark_y_space * (r.watermark_rows - 1));
					for (var E = 0; E < r.watermark_rows; E++) {
						A = o ? p + r.watermark_y + (l - C) / 2 + (r.watermark_y_space + r.watermark_height) * E : r.watermark_y + (l - C) / 2 + (r.watermark_y_space + r.watermark_height) * E;
						for (var T = 0; T < r.watermark_cols; T++) {
							_ = o ? m + r.watermark_x + (c - S) / 2 + (r.watermark_width + r.watermark_x_space) * T : r.watermark_x + (c - S) / 2 + (r.watermark_width + r.watermark_x_space) * T;
							var x = document.createElement("div"),
								P = document.createTextNode(r.watermark_txt);
							x.appendChild(P), x.id = r.watermark_prefix + E + T, x.style.webkitTransform = "rotate(-" + r.watermark_angle + "deg)", x.style.MozTransform = "rotate(-" + r.watermark_angle + "deg)", x.style.msTransform = "rotate(-" + r.watermark_angle + "deg)", x.style.OTransform = "rotate(-" + r.watermark_angle + "deg)", x.style.transform = "rotate(-" + r.watermark_angle + "deg)", x.style.visibility = "", x.style.position = "absolute", x.style.left = _ + "px", x.style.top = A + "px", x.style.overflow = "hidden", x.style.zIndex = "9999999", x.style.opacity = r.watermark_alpha, x.style.fontSize = r.watermark_fontsize, x.style.fontFamily = r.watermark_font, x.style.color = r.watermark_color, x.style.textAlign = "center", x.style.width = r.watermark_width + "px", x.style.height = r.watermark_height + "px", x.style.display = "block", x.style["-ms-user-select"] = "none", g.appendChild(x)
						}
					}
					var k = void 0 === t.monitor ? r.monitor : t.monitor;
					k && (u.observe(s, d), u.observe(document.getElementById("wm_div_id")
						.shadowRoot, d))
				};
				var i, o = function() {
					if (1 === arguments.length && "object" === a(arguments[0])) {
						var t = arguments[0] || {};
						for (key in t) t[key] && r[key] && t[key] === r[key] || (t[key] || 0 === t[key]) && (r[key] = t[key])
					}
					var e = document.getElementById(r.watermark_id),
						n = e.parentNode;
					n.removeChild(e)
				};
				e.init = function(e) {
					i = e, t(e), window.addEventListener("onload", (function() {
						t(e)
					})), window.addEventListener("resize", (function() {
						t(e)
					}))
				}, e.load = function(e) {
					i = e, t(e)
				}, e.remove = function() {
					o()
				};
				var s = function(e) {
						(i && 1 === e.length || 1 === e.length && e[0].removedNodes.length >= 1) && t(i)
					},
					c = window.MutationObserver || window.WebKitMutationObserver || window.MozMutationObserver,
					u = new c(s),
					d = {
						childList: !0,
						attributes: !0,
						subtree: !0
					};
				return e
			}))
		},
		"14d8": function(t, e, r) {
			r("2b3d"), r("bf19"), r("9861");
			var n = r("428f");
			t.exports = n.URL
		},
		"14e5": function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("c65b"),
				o = r("59ed"),
				a = r("f069"),
				s = r("e667"),
				c = r("2266"),
				u = r("5eed");
			n({
				target: "Promise",
				stat: !0,
				forced: u
			}, {
				all: function(t) {
					var e = this,
						r = a.f(e),
						n = r.resolve,
						u = r.reject,
						d = s((function() {
							var r = o(e.resolve),
								a = [],
								s = 0,
								d = 1;
							c(t, (function(t) {
								var o = s++,
									c = !1;
								d++, i(r, e, t)
									.then((function(t) {
										c || (c = !0, a[o] = t, --d || n(a))
									}), u)
							})), --d || n(a)
						}));
					return d.error && u(d.value), r.promise
				}
			})
		},
		1626: function(t, e) {
			t.exports = function(t) {
				return "function" == typeof t
			}
		},
		1920: function(t, e, r) {
			r("4d90");
			var n = r("b109");
			t.exports = n("String", "padStart")
		},
		"197b": function(t, e, r) {
			var n = r("746f");
			n("species")
		},
		"19aa": function(t, e, r) {
			var n = r("da84"),
				i = r("3a9b"),
				o = n.TypeError;
			t.exports = function(t, e) {
				if (i(e, t)) return t;
				throw o("Incorrect invocation")
			}
		},
		"1a2d": function(t, e, r) {
			var n = r("e330"),
				i = r("7b0b"),
				o = n({}.hasOwnProperty);
			t.exports = Object.hasOwn || function(t, e) {
				return o(i(t), e)
			}
		},
		"1be4": function(t, e, r) {
			var n = r("d066");
			t.exports = n("document", "documentElement")
		},
		"1c59": function(t, e, r) {
			"use strict";
			var n = r("6d61"),
				i = r("6566");
			n("Set", (function(t) {
				return function() {
					return t(this, arguments.length ? arguments[0] : void 0)
				}
			}), i)
		},
		"1c7e": function(t, e, r) {
			var n = r("b622"),
				i = n("iterator"),
				o = !1;
			try {
				var a = 0,
					s = {
						next: function() {
							return {
								done: !!a++
							}
						},
						return: function() {
							o = !0
						}
					};
				s[i] = function() {
					return this
				}, Array.from(s, (function() {
					throw 2
				}))
			} catch (c) {}
			t.exports = function(t, e) {
				if (!e && !o) return !1;
				var r = !1;
				try {
					var n = {};
					n[i] = function() {
						return {
							next: function() {
								return {
									done: r = !0
								}
							}
						}
					}, t(n)
				} catch (c) {}
				return r
			}
		},
		"1cd7": function(t, e, r) {
			r("f6d6");
			var n = r("428f");
			t.exports = n.String.fromCodePoint
		},
		"1cdc": function(t, e, r) {
			var n = r("342f");
			t.exports = /(?:ipad|iphone|ipod).*applewebkit/i.test(n)
		},
		"1d2b": function(t, e, r) {
			"use strict";
			t.exports = function(t, e) {
				return function() {
					for (var r = new Array(arguments.length), n = 0; n < r.length; n++) r[n] = arguments[n];
					return t.apply(e, r)
				}
			}
		},
		"1d80": function(t, e, r) {
			var n = r("da84"),
				i = n.TypeError;
			t.exports = function(t) {
				if (void 0 == t) throw i("Can't call method on " + t);
				return t
			}
		},
		"1dde": function(t, e, r) {
			var n = r("d039"),
				i = r("b622"),
				o = r("2d00"),
				a = i("species");
			t.exports = function(t) {
				return o >= 51 || !n((function() {
					var e = [],
						r = e.constructor = {};
					return r[a] = function() {
							return {
								foo: 1
							}
						}, 1 !== e[t](Boolean)
						.foo
				}))
			}
		},
		"1f4a": function(t, e, r) {
			r("99af"), r("d3b7"), r("a4d3"), r("b636"), r("e01a"), r("dc8d"), r("efe9"), r("d28b"), r("2a1b"), r("8edd"), r("80e0"), r("6b9e"), r("197b"), r("2351"), r("8172"), r("944a"), r("81b8"), r("0c47"), r("23dc"), r("f8c9");
			var n = r("428f");
			t.exports = n.Symbol
		},
		"1fb5": function(t, e, r) {
			"use strict";
			e.byteLength = d, e.toByteArray = f, e.fromByteArray = m;
			for (var n = [], i = [], o = "undefined" !== typeof Uint8Array ? Uint8Array : Array, a = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", s = 0, c = a.length; s < c; ++s) n[s] = a[s], i[a.charCodeAt(s)] = s;

			function u(t) {
				var e = t.length;
				if (e % 4 > 0) throw new Error("Invalid string. Length must be a multiple of 4");
				var r = t.indexOf("="); - 1 === r && (r = e);
				var n = r === e ? 0 : 4 - r % 4;
				return [r, n]
			}

			function d(t) {
				var e = u(t),
					r = e[0],
					n = e[1];
				return 3 * (r + n) / 4 - n
			}

			function l(t, e, r) {
				return 3 * (e + r) / 4 - r
			}

			function f(t) {
				var e, r, n = u(t),
					a = n[0],
					s = n[1],
					c = new o(l(t, a, s)),
					d = 0,
					f = s > 0 ? a - 4 : a;
				for (r = 0; r < f; r += 4) e = i[t.charCodeAt(r)] << 18 | i[t.charCodeAt(r + 1)] << 12 | i[t.charCodeAt(r + 2)] << 6 | i[t.charCodeAt(r + 3)], c[d++] = e >> 16 & 255, c[d++] = e >> 8 & 255, c[d++] = 255 & e;
				return 2 === s && (e = i[t.charCodeAt(r)] << 2 | i[t.charCodeAt(r + 1)] >> 4, c[d++] = 255 & e), 1 === s && (e = i[t.charCodeAt(r)] << 10 | i[t.charCodeAt(r + 1)] << 4 | i[t.charCodeAt(r + 2)] >> 2, c[d++] = e >> 8 & 255, c[d++] = 255 & e), c
			}

			function h(t) {
				return n[t >> 18 & 63] + n[t >> 12 & 63] + n[t >> 6 & 63] + n[63 & t]
			}

			function p(t, e, r) {
				for (var n, i = [], o = e; o < r; o += 3) n = (t[o] << 16 & 16711680) + (t[o + 1] << 8 & 65280) + (255 & t[o + 2]), i.push(h(n));
				return i.join("")
			}

			function m(t) {
				for (var e, r = t.length, i = r % 3, o = [], a = 16383, s = 0, c = r - i; s < c; s += a) o.push(p(t, s, s + a > c ? c : s + a));
				return 1 === i ? (e = t[r - 1], o.push(n[e >> 2] + n[e << 4 & 63] + "==")) : 2 === i && (e = (t[r - 2] << 8) + t[r - 1], o.push(n[e >> 10] + n[e >> 4 & 63] + n[e << 2 & 63] + "=")), o.join("")
			}
			i["-".charCodeAt(0)] = 62, i["_".charCodeAt(0)] = 63
		},
		"1fe2": function(t, e, r) {
			r("7276")
		},
		2266: function(t, e, r) {
			var n = r("da84"),
				i = r("0366"),
				o = r("c65b"),
				a = r("825a"),
				s = r("0d51"),
				c = r("e95a"),
				u = r("07fa"),
				d = r("3a9b"),
				l = r("9a1f"),
				f = r("35a1"),
				h = r("2a62"),
				p = n.TypeError,
				m = function(t, e) {
					this.stopped = t, this.result = e
				},
				b = m.prototype;
			t.exports = function(t, e, r) {
				var n, g, y, v, S, w, C, _ = r && r.that,
					A = !(!r || !r.AS_ENTRIES),
					I = !(!r || !r.IS_ITERATOR),
					E = !(!r || !r.INTERRUPTED),
					T = i(e, _),
					x = function(t) {
						return n && h(n, "normal", t), new m(!0, t)
					},
					P = function(t) {
						return A ? (a(t), E ? T(t[0], t[1], x) : T(t[0], t[1])) : E ? T(t, x) : T(t)
					};
				if (I) n = t;
				else {
					if (g = f(t), !g) throw p(s(t) + " is not iterable");
					if (c(g)) {
						for (y = 0, v = u(t); v > y; y++)
							if (S = P(t[y]), S && d(b, S)) return S;
						return new m(!1)
					}
					n = l(t, g)
				}
				w = n.next;
				while (!(C = o(w, n))
					.done) {
					try {
						S = P(C.value)
					} catch (k) {
						h(n, "throw", k)
					}
					if ("object" == typeof S && S && d(b, S)) return S
				}
				return new m(!1)
			}
		},
		2351: function(t, e, r) {
			var n = r("746f");
			n("split")
		},
		"23cb": function(t, e, r) {
			var n = r("5926"),
				i = Math.max,
				o = Math.min;
			t.exports = function(t, e) {
				var r = n(t);
				return r < 0 ? i(r + e, 0) : o(r, e)
			}
		},
		"23dc": function(t, e, r) {
			var n = r("d44e");
			n(Math, "Math", !0)
		},
		"23e7": function(t, e, r) {
			var n = r("da84"),
				i = r("06cf")
				.f,
				o = r("9112"),
				a = r("cb2d"),
				s = r("ce4e"),
				c = r("e893"),
				u = r("94ca");
			t.exports = function(t, e) {
				var r, d, l, f, h, p, m = t.target,
					b = t.global,
					g = t.stat;
				if (d = b ? n : g ? n[m] || s(m, {}) : (n[m] || {})
					.prototype, d)
					for (l in e) {
						if (h = e[l], t.noTargetGet ? (p = i(d, l), f = p && p.value) : f = d[l], r = u(b ? l : m + (g ? "." : "#") + l, t.forced), !r && void 0 !== f) {
							if (typeof h == typeof f) continue;
							c(h, f)
						}(t.sham || f && f.sham) && o(h, "sham", !0), a(d, l, h, t)
					}
			}
		},
		2418: function(t, e, r) {
			r("cca6");
			var n = r("428f");
			t.exports = n.Object.assign
		},
		"241c": function(t, e, r) {
			var n = r("ca84"),
				i = r("7839"),
				o = i.concat("length", "prototype");
			e.f = Object.getOwnPropertyNames || function(t) {
				return n(t, o)
			}
		},
		2444: function(t, e, r) {
			"use strict";
			(function(e) {
				var n = r("c532"),
					i = r("c8af"),
					o = {
						"Content-Type": "application/x-www-form-urlencoded"
					};

				function a(t, e) {
					!n.isUndefined(t) && n.isUndefined(t["Content-Type"]) && (t["Content-Type"] = e)
				}

				function s() {
					var t;
					return ("undefined" !== typeof XMLHttpRequest || "undefined" !== typeof e && "[object process]" === Object.prototype.toString.call(e)) && (t = r("b50d")), t
				}
				var c = {
					adapter: s(),
					transformRequest: [function(t, e) {
						return i(e, "Accept"), i(e, "Content-Type"), n.isFormData(t) || n.isArrayBuffer(t) || n.isBuffer(t) || n.isStream(t) || n.isFile(t) || n.isBlob(t) ? t : n.isArrayBufferView(t) ? t.buffer : n.isURLSearchParams(t) ? (a(e, "application/x-www-form-urlencoded;charset=utf-8"), t.toString()) : n.isObject(t) ? (a(e, "application/json;charset=utf-8"), JSON.stringify(t)) : t
					}],
					transformResponse: [function(t) {
						if ("string" === typeof t) try {
							t = JSON.parse(t)
						} catch (e) {}
						return t
					}],
					timeout: 0,
					xsrfCookieName: "XSRF-TOKEN",
					xsrfHeaderName: "X-XSRF-TOKEN",
					maxContentLength: -1,
					maxBodyLength: -1,
					validateStatus: function(t) {
						return t >= 200 && t < 300
					},
					headers: {
						common: {
							Accept: "application/json, text/plain, */*"
						}
					}
				};
				n.forEach(["delete", "get", "head"], (function(t) {
					c.headers[t] = {}
				})), n.forEach(["post", "put", "patch"], (function(t) {
					c.headers[t] = n.merge(o)
				})), t.exports = c
			})
			.call(this, r("4362"))
		},
		2532: function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("e330"),
				o = r("5a34"),
				a = r("1d80"),
				s = r("577e"),
				c = r("ab13"),
				u = i("".indexOf);
			n({
				target: "String",
				proto: !0,
				forced: !c("includes")
			}, {
				includes: function(t) {
					return !!~u(s(a(this)), s(o(t)), arguments.length > 1 ? arguments[1] : void 0)
				}
			})
		},
		2626: function(t, e, r) {
			"use strict";
			var n = r("d066"),
				i = r("9bf2"),
				o = r("b622"),
				a = r("83ab"),
				s = o("species");
			t.exports = function(t) {
				var e = n(t),
					r = i.f;
				a && e && !e[s] && r(e, s, {
					configurable: !0,
					get: function() {
						return this
					}
				})
			}
		},
		2954: function(t, e, r) {
			"use strict";
			var n = r("ebb5"),
				i = r("b6b7"),
				o = r("d039"),
				a = r("f36a"),
				s = n.aTypedArray,
				c = n.exportTypedArrayMethod,
				u = o((function() {
					new Int8Array(1)
						.slice()
				}));
			c("slice", (function(t, e) {
				var r = a(s(this), t, e),
					n = i(this),
					o = 0,
					c = r.length,
					u = new n(c);
				while (c > o) u[o] = r[o++];
				return u
			}), u)
		},
		"2a1b": function(t, e, r) {
			var n = r("746f");
			n("match")
		},
		"2a62": function(t, e, r) {
			var n = r("c65b"),
				i = r("825a"),
				o = r("dc4a");
			t.exports = function(t, e, r) {
				var a, s;
				i(t);
				try {
					if (a = o(t, "return"), !a) {
						if ("throw" === e) throw r;
						return r
					}
					a = n(a, t)
				} catch (c) {
					s = !0, a = c
				}
				if ("throw" === e) throw r;
				if (s) throw a;
				return i(a), r
			}
		},
		"2b3d": function(t, e, r) {
			r("4002")
		},
		"2ba4": function(t, e, r) {
			var n = r("40d5"),
				i = Function.prototype,
				o = i.apply,
				a = i.call;
			t.exports = "object" == typeof Reflect && Reflect.apply || (n ? a.bind(o) : function() {
				return a.apply(o, arguments)
			})
		},
		"2ca0": function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("e330"),
				o = r("06cf")
				.f,
				a = r("50c4"),
				s = r("577e"),
				c = r("5a34"),
				u = r("1d80"),
				d = r("ab13"),
				l = r("c430"),
				f = i("".startsWith),
				h = i("".slice),
				p = Math.min,
				m = d("startsWith"),
				b = !l && !m && !! function() {
					var t = o(String.prototype, "startsWith");
					return t && !t.writable
				}();
			n({
				target: "String",
				proto: !0,
				forced: !b && !m
			}, {
				startsWith: function(t) {
					var e = s(u(this));
					c(t);
					var r = a(p(arguments.length > 1 ? arguments[1] : void 0, e.length)),
						n = s(t);
					return f ? f(e, n, r) : h(e, r, r + n.length) === n
				}
			})
		},
		"2cf4": function(t, e, r) {
			var n, i, o, a, s = r("da84"),
				c = r("2ba4"),
				u = r("0366"),
				d = r("1626"),
				l = r("1a2d"),
				f = r("d039"),
				h = r("1be4"),
				p = r("f36a"),
				m = r("cc12"),
				b = r("d6d6"),
				g = r("1cdc"),
				y = r("605d"),
				v = s.setImmediate,
				S = s.clearImmediate,
				w = s.process,
				C = s.Dispatch,
				_ = s.Function,
				A = s.MessageChannel,
				I = s.String,
				E = 0,
				T = {},
				x = "onreadystatechange";
			try {
				n = s.location
			} catch (R) {}
			var P = function(t) {
					if (l(T, t)) {
						var e = T[t];
						delete T[t], e()
					}
				},
				k = function(t) {
					return function() {
						P(t)
					}
				},
				D = function(t) {
					P(t.data)
				},
				O = function(t) {
					s.postMessage(I(t), n.protocol + "//" + n.host)
				};
			v && S || (v = function(t) {
				b(arguments.length, 1);
				var e = d(t) ? t : _(t),
					r = p(arguments, 1);
				return T[++E] = function() {
					c(e, void 0, r)
				}, i(E), E
			}, S = function(t) {
				delete T[t]
			}, y ? i = function(t) {
				w.nextTick(k(t))
			} : C && C.now ? i = function(t) {
				C.now(k(t))
			} : A && !g ? (o = new A, a = o.port2, o.port1.onmessage = D, i = u(a.postMessage, a)) : s.addEventListener && d(s.postMessage) && !s.importScripts && n && "file:" !== n.protocol && !f(O) ? (i = O, s.addEventListener("message", D, !1)) : i = x in m("script") ? function(t) {
				h.appendChild(m("script"))[x] = function() {
					h.removeChild(this), P(t)
				}
			} : function(t) {
				setTimeout(k(t), 0)
			}), t.exports = {
				set: v,
				clear: S
			}
		},
		"2d00": function(t, e, r) {
			var n, i, o = r("da84"),
				a = r("342f"),
				s = o.process,
				c = o.Deno,
				u = s && s.versions || c && c.version,
				d = u && u.v8;
			d && (n = d.split("."), i = n[0] > 0 && n[0] < 4 ? 1 : +(n[0] + n[1])), !i && a && (n = a.match(/Edge\/(\d+)/), (!n || n[1] >= 74) && (n = a.match(/Chrome\/(\d+)/), n && (i = +n[1]))), t.exports = i
		},
		"2d83": function(t, e, r) {
			"use strict";
			var n = r("387f");
			t.exports = function(t, e, r, i, o) {
				var a = new Error(t);
				return n(a, e, r, i, o)
			}
		},
		"2e67": function(t, e, r) {
			"use strict";
			t.exports = function(t) {
				return !(!t || !t.__CANCEL__)
			}
		},
		"30b5": function(t, e, r) {
			"use strict";
			var n = r("c532");

			function i(t) {
				return encodeURIComponent(t)
					.replace(/%3A/gi, ":")
					.replace(/%24/g, "$")
					.replace(/%2C/gi, ",")
					.replace(/%20/g, "+")
					.replace(/%5B/gi, "[")
					.replace(/%5D/gi, "]")
			}
			t.exports = function(t, e, r) {
				if (!e) return t;
				var o;
				if (r) o = r(e);
				else if (n.isURLSearchParams(e)) o = e.toString();
				else {
					var a = [];
					n.forEach(e, (function(t, e) {
						null !== t && "undefined" !== typeof t && (n.isArray(t) ? e += "[]" : t = [t], n.forEach(t, (function(t) {
							n.isDate(t) ? t = t.toISOString() : n.isObject(t) && (t = JSON.stringify(t)), a.push(i(e) + "=" + i(t))
						})))
					})), o = a.join("&")
				}
				if (o) {
					var s = t.indexOf("#"); - 1 !== s && (t = t.slice(0, s)), t += (-1 === t.indexOf("?") ? "?" : "&") + o
				}
				return t
			}
		},
		"342f": function(t, e, r) {
			var n = r("d066");
			t.exports = n("navigator", "userAgent") || ""
		},
		3529: function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("c65b"),
				o = r("59ed"),
				a = r("f069"),
				s = r("e667"),
				c = r("2266"),
				u = r("5eed");
			n({
				target: "Promise",
				stat: !0,
				forced: u
			}, {
				race: function(t) {
					var e = this,
						r = a.f(e),
						n = r.reject,
						u = s((function() {
							var a = o(e.resolve);
							c(t, (function(t) {
								i(a, e, t)
									.then(r.resolve, n)
							}))
						}));
					return u.error && n(u.value), r.promise
				}
			})
		},
		"35a1": function(t, e, r) {
			var n = r("f5df"),
				i = r("dc4a"),
				o = r("3f8c"),
				a = r("b622"),
				s = a("iterator");
			t.exports = function(t) {
				if (void 0 != t) return i(t, s) || i(t, "@@iterator") || o[n(t)]
			}
		},
		3662: function(t, e, r) {
			"use strict";

			function n(t) {
				return n = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t) {
					return typeof t
				} : function(t) {
					return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
				}, n(t)
			}

			function i() {
				/*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */
				i = function() {
					return t
				};
				var t = {},
					e = Object.prototype,
					r = e.hasOwnProperty,
					o = "function" == typeof Symbol ? Symbol : {},
					a = o.iterator || "@@iterator",
					s = o.asyncIterator || "@@asyncIterator",
					c = o.toStringTag || "@@toStringTag";

				function u(t, e, r) {
					return Object.defineProperty(t, e, {
						value: r,
						enumerable: !0,
						configurable: !0,
						writable: !0
					}), t[e]
				}
				try {
					u({}, "")
				} catch (x) {
					u = function(t, e, r) {
						return t[e] = r
					}
				}

				function d(t, e, r, n) {
					var i = e && e.prototype instanceof h ? e : h,
						o = Object.create(i.prototype),
						a = new I(n || []);
					return o._invoke = function(t, e, r) {
						var n = "suspendedStart";
						return function(i, o) {
							if ("executing" === n) throw new Error("Generator is already running");
							if ("completed" === n) {
								if ("throw" === i) throw o;
								return T()
							}
							for (r.method = i, r.arg = o;;) {
								var a = r.delegate;
								if (a) {
									var s = C(a, r);
									if (s) {
										if (s === f) continue;
										return s
									}
								}
								if ("next" === r.method) r.sent = r._sent = r.arg;
								else if ("throw" === r.method) {
									if ("suspendedStart" === n) throw n = "completed", r.arg;
									r.dispatchException(r.arg)
								} else "return" === r.method && r.abrupt("return", r.arg);
								n = "executing";
								var c = l(t, e, r);
								if ("normal" === c.type) {
									if (n = r.done ? "completed" : "suspendedYield", c.arg === f) continue;
									return {
										value: c.arg,
										done: r.done
									}
								}
								"throw" === c.type && (n = "completed", r.method = "throw", r.arg = c.arg)
							}
						}
					}(t, r, a), o
				}

				function l(t, e, r) {
					try {
						return {
							type: "normal",
							arg: t.call(e, r)
						}
					} catch (x) {
						return {
							type: "throw",
							arg: x
						}
					}
				}
				t.wrap = d;
				var f = {};

				function h() {}

				function p() {}

				function m() {}
				var b = {};
				u(b, a, (function() {
					return this
				}));
				var g = Object.getPrototypeOf,
					y = g && g(g(E([])));
				y && y !== e && r.call(y, a) && (b = y);
				var v = m.prototype = h.prototype = Object.create(b);

				function S(t) {
					["next", "throw", "return"].forEach((function(e) {
						u(t, e, (function(t) {
							return this._invoke(e, t)
						}))
					}))
				}

				function w(t, e) {
					function i(o, a, s, c) {
						var u = l(t[o], t, a);
						if ("throw" !== u.type) {
							var d = u.arg,
								f = d.value;
							return f && "object" == n(f) && r.call(f, "__await") ? e.resolve(f.__await)
								.then((function(t) {
									i("next", t, s, c)
								}), (function(t) {
									i("throw", t, s, c)
								})) : e.resolve(f)
								.then((function(t) {
									d.value = t, s(d)
								}), (function(t) {
									return i("throw", t, s, c)
								}))
						}
						c(u.arg)
					}
					var o;
					this._invoke = function(t, r) {
						function n() {
							return new e((function(e, n) {
								i(t, r, e, n)
							}))
						}
						return o = o ? o.then(n, n) : n()
					}
				}

				function C(t, e) {
					var r = t.iterator[e.method];
					if (void 0 === r) {
						if (e.delegate = null, "throw" === e.method) {
							if (t.iterator.return && (e.method = "return", e.arg = void 0, C(t, e), "throw" === e.method)) return f;
							e.method = "throw", e.arg = new TypeError("The iterator does not provide a 'throw' method")
						}
						return f
					}
					var n = l(r, t.iterator, e.arg);
					if ("throw" === n.type) return e.method = "throw", e.arg = n.arg, e.delegate = null, f;
					var i = n.arg;
					return i ? i.done ? (e[t.resultName] = i.value, e.next = t.nextLoc, "return" !== e.method && (e.method = "next", e.arg = void 0), e.delegate = null, f) : i : (e.method = "throw", e.arg = new TypeError("iterator result is not an object"), e.delegate = null, f)
				}

				function _(t) {
					var e = {
						tryLoc: t[0]
					};
					1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e)
				}

				function A(t) {
					var e = t.completion || {};
					e.type = "normal", delete e.arg, t.completion = e
				}

				function I(t) {
					this.tryEntries = [{
						tryLoc: "root"
					}], t.forEach(_, this), this.reset(!0)
				}

				function E(t) {
					if (t) {
						var e = t[a];
						if (e) return e.call(t);
						if ("function" == typeof t.next) return t;
						if (!isNaN(t.length)) {
							var n = -1,
								i = function e() {
									for (; ++n < t.length;)
										if (r.call(t, n)) return e.value = t[n], e.done = !1, e;
									return e.value = void 0, e.done = !0, e
								};
							return i.next = i
						}
					}
					return {
						next: T
					}
				}

				function T() {
					return {
						value: void 0,
						done: !0
					}
				}
				return p.prototype = m, u(v, "constructor", m), u(m, "constructor", p), p.displayName = u(m, c, "GeneratorFunction"), t.isGeneratorFunction = function(t) {
					var e = "function" == typeof t && t.constructor;
					return !!e && (e === p || "GeneratorFunction" === (e.displayName || e.name))
				}, t.mark = function(t) {
					return Object.setPrototypeOf ? Object.setPrototypeOf(t, m) : (t.__proto__ = m, u(t, c, "GeneratorFunction")), t.prototype = Object.create(v), t
				}, t.awrap = function(t) {
					return {
						__await: t
					}
				}, S(w.prototype), u(w.prototype, s, (function() {
					return this
				})), t.AsyncIterator = w, t.async = function(e, r, n, i, o) {
					void 0 === o && (o = Promise);
					var a = new w(d(e, r, n, i), o);
					return t.isGeneratorFunction(r) ? a : a.next()
						.then((function(t) {
							return t.done ? t.value : a.next()
						}))
				}, S(v), u(v, c, "Generator"), u(v, a, (function() {
					return this
				})), u(v, "toString", (function() {
					return "[object Generator]"
				})), t.keys = function(t) {
					var e = [];
					for (var r in t) e.push(r);
					return e.reverse(),
						function r() {
							for (; e.length;) {
								var n = e.pop();
								if (n in t) return r.value = n, r.done = !1, r
							}
							return r.done = !0, r
						}
				}, t.values = E, I.prototype = {
					constructor: I,
					reset: function(t) {
						if (this.prev = 0, this.next = 0, this.sent = this._sent = void 0, this.done = !1, this.delegate = null, this.method = "next", this.arg = void 0, this.tryEntries.forEach(A), !t)
							for (var e in this) "t" === e.charAt(0) && r.call(this, e) && !isNaN(+e.slice(1)) && (this[e] = void 0)
					},
					stop: function() {
						this.done = !0;
						var t = this.tryEntries[0].completion;
						if ("throw" === t.type) throw t.arg;
						return this.rval
					},
					dispatchException: function(t) {
						if (this.done) throw t;
						var e = this;

						function n(r, n) {
							return a.type = "throw", a.arg = t, e.next = r, n && (e.method = "next", e.arg = void 0), !!n
						}
						for (var i = this.tryEntries.length - 1; i >= 0; --i) {
							var o = this.tryEntries[i],
								a = o.completion;
							if ("root" === o.tryLoc) return n("end");
							if (o.tryLoc <= this.prev) {
								var s = r.call(o, "catchLoc"),
									c = r.call(o, "finallyLoc");
								if (s && c) {
									if (this.prev < o.catchLoc) return n(o.catchLoc, !0);
									if (this.prev < o.finallyLoc) return n(o.finallyLoc)
								} else if (s) {
									if (this.prev < o.catchLoc) return n(o.catchLoc, !0)
								} else {
									if (!c) throw new Error("try statement without catch or finally");
									if (this.prev < o.finallyLoc) return n(o.finallyLoc)
								}
							}
						}
					},
					abrupt: function(t, e) {
						for (var n = this.tryEntries.length - 1; n >= 0; --n) {
							var i = this.tryEntries[n];
							if (i.tryLoc <= this.prev && r.call(i, "finallyLoc") && this.prev < i.finallyLoc) {
								var o = i;
								break
							}
						}
						o && ("break" === t || "continue" === t) && o.tryLoc <= e && e <= o.finallyLoc && (o = null);
						var a = o ? o.completion : {};
						return a.type = t, a.arg = e, o ? (this.method = "next", this.next = o.finallyLoc, f) : this.complete(a)
					},
					complete: function(t, e) {
						if ("throw" === t.type) throw t.arg;
						return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), f
					},
					finish: function(t) {
						for (var e = this.tryEntries.length - 1; e >= 0; --e) {
							var r = this.tryEntries[e];
							if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), A(r), f
						}
					},
					catch: function(t) {
						for (var e = this.tryEntries.length - 1; e >= 0; --e) {
							var r = this.tryEntries[e];
							if (r.tryLoc === t) {
								var n = r.completion;
								if ("throw" === n.type) {
									var i = n.arg;
									A(r)
								}
								return i
							}
						}
						throw new Error("illegal catch attempt")
					},
					delegateYield: function(t, e, r) {
						return this.delegate = {
							iterator: E(t),
							resultName: e,
							nextLoc: r
						}, "next" === this.method && (this.arg = void 0), f
					}
				}, t
			}

			function o(t, e, r, n, i, o, a) {
				try {
					var s = t[o](a),
						c = s.value
				} catch (u) {
					return void r(u)
				}
				s.done ? e(c) : Promise.resolve(c)
					.then(n, i)
			}

			function a(t) {
				return function() {
					var e = this,
						r = arguments;
					return new Promise((function(n, i) {
						var a = t.apply(e, r);

						function s(t) {
							o(a, n, i, s, c, "next", t)
						}

						function c(t) {
							o(a, n, i, s, c, "throw", t)
						}
						s(void 0)
					}))
				}
			}
			r.d(e, "a", (function() {
				return c
			})), Array.prototype.pipeline = function() {
				var t = a(i()
					.mark((function t(e) {
						var r, n, o;
						return i()
							.wrap((function(t) {
								while (1) switch (t.prev = t.next) {
									case 0:
										if (null !== this && "undefined" !== typeof this) {
											t.next = 2;
											break
										}
										throw new TypeError("Array.prototype.pipeline called on null or undefined");
									case 2:
										if ("function" === typeof e) {
											t.next = 4;
											break
										}
										throw new TypeError(e + " is not a function");
									case 4:
										o = this.length >>> 0, r = 0;
									case 6:
										if (!(o > r)) {
											t.next = 13;
											break
										}
										return t.next = 9, e(n, this[r], r, this);
									case 9:
										n = t.sent;
									case 10:
										++r, t.next = 6;
										break;
									case 13:
										return t.abrupt("return", n);
									case 14:
									case "end":
										return t.stop()
								}
							}), t, this)
					})));
				return function(e) {
					return t.apply(this, arguments)
				}
			}();
			var s = function() {
					for (var t = this, e = arguments.length, r = new Array(e), n = 0; n < e; n++) r[n] = arguments[n];
					return r.pipeline((function(e, r) {
						return r.call(t, e)
					}))
				},
				c = s
		},
		"37e8": function(t, e, r) {
			var n = r("83ab"),
				i = r("aed9"),
				o = r("9bf2"),
				a = r("825a"),
				s = r("fc6a"),
				c = r("df75");
			e.f = n && !i ? Object.defineProperties : function(t, e) {
				a(t);
				var r, n = s(e),
					i = c(e),
					u = i.length,
					d = 0;
				while (u > d) o.f(t, r = i[d++], n[r]);
				return t
			}
		},
		"387f": function(t, e, r) {
			"use strict";
			t.exports = function(t, e, r, n, i) {
				return t.config = e, r && (t.code = r), t.request = n, t.response = i, t.isAxiosError = !0, t.toJSON = function() {
					return {
						message: this.message,
						name: this.name,
						description: this.description,
						number: this.number,
						fileName: this.fileName,
						lineNumber: this.lineNumber,
						columnNumber: this.columnNumber,
						stack: this.stack,
						config: this.config,
						code: this.code
					}
				}, t
			}
		},
		3934: function(t, e, r) {
			"use strict";
			var n = r("c532");
			t.exports = n.isStandardBrowserEnv() ? function() {
				var t, e = /(msie|trident)/i.test(navigator.userAgent),
					r = document.createElement("a");

				function i(t) {
					var n = t;
					return e && (r.setAttribute("href", n), n = r.href), r.setAttribute("href", n), {
						href: r.href,
						protocol: r.protocol ? r.protocol.replace(/:$/, "") : "",
						host: r.host,
						search: r.search ? r.search.replace(/^\?/, "") : "",
						hash: r.hash ? r.hash.replace(/^#/, "") : "",
						hostname: r.hostname,
						port: r.port,
						pathname: "/" === r.pathname.charAt(0) ? r.pathname : "/" + r.pathname
					}
				}
				return t = i(window.location.href),
					function(e) {
						var r = n.isString(e) ? i(e) : e;
						return r.protocol === t.protocol && r.host === t.host
					}
			}() : function() {
				return function() {
					return !0
				}
			}()
		},
		3980: function(t, e, r) {
			r("967a"), r("e260"), r("d3b7"), r("e6cf"), r("820e"), r("dbfa"), r("a79d"), r("3ca3");
			var n = r("428f");
			t.exports = n.Promise
		},
		"3a9b": function(t, e, r) {
			var n = r("e330");
			t.exports = n({}.isPrototypeOf)
		},
		"3bbe": function(t, e, r) {
			var n = r("da84"),
				i = r("1626"),
				o = n.String,
				a = n.TypeError;
			t.exports = function(t) {
				if ("object" == typeof t || i(t)) return t;
				throw a("Can't set " + o(t) + " as a prototype")
			}
		},
		"3ca3": function(t, e, r) {
			"use strict";
			var n = r("6547")
				.charAt,
				i = r("577e"),
				o = r("69f3"),
				a = r("7dd0"),
				s = "String Iterator",
				c = o.set,
				u = o.getterFor(s);
			a(String, "String", (function(t) {
				c(this, {
					type: s,
					string: i(t),
					index: 0
				})
			}), (function() {
				var t, e = u(this),
					r = e.string,
					i = e.index;
				return i >= r.length ? {
					value: void 0,
					done: !0
				} : (t = n(r, i), e.index += t.length, {
					value: t,
					done: !1
				})
			}))
		},
		"3d87": function(t, e, r) {
			var n = r("4930");
			t.exports = n && !!Symbol["for"] && !!Symbol.keyFor
		},
		"3f8c": function(t, e) {
			t.exports = {}
		},
		4002: function(t, e, r) {
			"use strict";
			r("3ca3");
			var n, i = r("23e7"),
				o = r("83ab"),
				a = r("0d3b"),
				s = r("da84"),
				c = r("0366"),
				u = r("e330"),
				d = r("cb2d"),
				l = r("edd0"),
				f = r("19aa"),
				h = r("1a2d"),
				p = r("60da"),
				m = r("4df4"),
				b = r("4dae"),
				g = r("6547")
				.codeAt,
				y = r("5fb2"),
				v = r("577e"),
				S = r("d44e"),
				w = r("d6d6"),
				C = r("5352"),
				_ = r("69f3"),
				A = _.set,
				I = _.getterFor("URL"),
				E = C.URLSearchParams,
				T = C.getState,
				x = s.URL,
				P = s.TypeError,
				k = s.parseInt,
				D = Math.floor,
				O = Math.pow,
				R = u("".charAt),
				N = u(/./.exec),
				M = u([].join),
				B = u(1..toString),
				F = u([].pop),
				j = u([].push),
				K = u("".replace),
				L = u([].shift),
				U = u("".split),
				X = u("".slice),
				z = u("".toLowerCase),
				G = u([].unshift),
				q = "Invalid authority",
				W = "Invalid scheme",
				V = "Invalid host",
				H = "Invalid port",
				Y = /[a-z]/i,
				Z = /[\d+-.a-z]/i,
				Q = /\d/,
				J = /^0x/i,
				$ = /^[0-7]+$/,
				tt = /^\d+$/,
				et = /^[\da-f]+$/i,
				rt = /[\0\t\n\r #%/:<>?@[\\\]^|]/,
				nt = /[\0\t\n\r #/:<>?@[\\\]^|]/,
				it = /^[\u0000-\u0020]+|[\u0000-\u0020]+$/g,
				ot = /[\t\n\r]/g,
				at = function(t) {
					var e, r, n, i, o, a, s, c = U(t, ".");
					if (c.length && "" == c[c.length - 1] && c.length--, e = c.length, e > 4) return t;
					for (r = [], n = 0; n < e; n++) {
						if (i = c[n], "" == i) return t;
						if (o = 10, i.length > 1 && "0" == R(i, 0) && (o = N(J, i) ? 16 : 8, i = X(i, 8 == o ? 1 : 2)), "" === i) a = 0;
						else {
							if (!N(10 == o ? tt : 8 == o ? $ : et, i)) return t;
							a = k(i, o)
						}
						j(r, a)
					}
					for (n = 0; n < e; n++)
						if (a = r[n], n == e - 1) {
							if (a >= O(256, 5 - e)) return null
						} else if (a > 255) return null;
					for (s = F(r), n = 0; n < r.length; n++) s += r[n] * O(256, 3 - n);
					return s
				},
				st = function(t) {
					var e, r, n, i, o, a, s, c = [0, 0, 0, 0, 0, 0, 0, 0],
						u = 0,
						d = null,
						l = 0,
						f = function() {
							return R(t, l)
						};
					if (":" == f()) {
						if (":" != R(t, 1)) return;
						l += 2, u++, d = u
					}
					while (f()) {
						if (8 == u) return;
						if (":" != f()) {
							e = r = 0;
							while (r < 4 && N(et, f())) e = 16 * e + k(f(), 16), l++, r++;
							if ("." == f()) {
								if (0 == r) return;
								if (l -= r, u > 6) return;
								n = 0;
								while (f()) {
									if (i = null, n > 0) {
										if (!("." == f() && n < 4)) return;
										l++
									}
									if (!N(Q, f())) return;
									while (N(Q, f())) {
										if (o = k(f(), 10), null === i) i = o;
										else {
											if (0 == i) return;
											i = 10 * i + o
										}
										if (i > 255) return;
										l++
									}
									c[u] = 256 * c[u] + i, n++, 2 != n && 4 != n || u++
								}
								if (4 != n) return;
								break
							}
							if (":" == f()) {
								if (l++, !f()) return
							} else if (f()) return;
							c[u++] = e
						} else {
							if (null !== d) return;
							l++, u++, d = u
						}
					}
					if (null !== d) {
						a = u - d, u = 7;
						while (0 != u && a > 0) s = c[u], c[u--] = c[d + a - 1], c[d + --a] = s
					} else if (8 != u) return;
					return c
				},
				ct = function(t) {
					for (var e = null, r = 1, n = null, i = 0, o = 0; o < 8; o++) 0 !== t[o] ? (i > r && (e = n, r = i), n = null, i = 0) : (null === n && (n = o), ++i);
					return i > r && (e = n, r = i), e
				},
				ut = function(t) {
					var e, r, n, i;
					if ("number" == typeof t) {
						for (e = [], r = 0; r < 4; r++) G(e, t % 256), t = D(t / 256);
						return M(e, ".")
					}
					if ("object" == typeof t) {
						for (e = "", n = ct(t), r = 0; r < 8; r++) i && 0 === t[r] || (i && (i = !1), n === r ? (e += r ? ":" : "::", i = !0) : (e += B(t[r], 16), r < 7 && (e += ":")));
						return "[" + e + "]"
					}
					return t
				},
				dt = {},
				lt = p({}, dt, {
					" ": 1,
					'"': 1,
					"<": 1,
					">": 1,
					"`": 1
				}),
				ft = p({}, lt, {
					"#": 1,
					"?": 1,
					"{": 1,
					"}": 1
				}),
				ht = p({}, ft, {
					"/": 1,
					":": 1,
					";": 1,
					"=": 1,
					"@": 1,
					"[": 1,
					"\\": 1,
					"]": 1,
					"^": 1,
					"|": 1
				}),
				pt = function(t, e) {
					var r = g(t, 0);
					return r > 32 && r < 127 && !h(e, t) ? t : encodeURIComponent(t)
				},
				mt = {
					ftp: 21,
					file: null,
					http: 80,
					https: 443,
					ws: 80,
					wss: 443
				},
				bt = function(t, e) {
					var r;
					return 2 == t.length && N(Y, R(t, 0)) && (":" == (r = R(t, 1)) || !e && "|" == r)
				},
				gt = function(t) {
					var e;
					return t.length > 1 && bt(X(t, 0, 2)) && (2 == t.length || "/" === (e = R(t, 2)) || "\\" === e || "?" === e || "#" === e)
				},
				yt = function(t) {
					return "." === t || "%2e" === z(t)
				},
				vt = function(t) {
					return t = z(t), ".." === t || "%2e." === t || ".%2e" === t || "%2e%2e" === t
				},
				St = {},
				wt = {},
				Ct = {},
				_t = {},
				At = {},
				It = {},
				Et = {},
				Tt = {},
				xt = {},
				Pt = {},
				kt = {},
				Dt = {},
				Ot = {},
				Rt = {},
				Nt = {},
				Mt = {},
				Bt = {},
				Ft = {},
				jt = {},
				Kt = {},
				Lt = {},
				Ut = function(t, e, r) {
					var n, i, o, a = v(t);
					if (e) {
						if (i = this.parse(a), i) throw P(i);
						this.searchParams = null
					} else {
						if (void 0 !== r && (n = new Ut(r, !0)), i = this.parse(a, null, n), i) throw P(i);
						o = T(new E), o.bindURL(this), this.searchParams = o
					}
				};
			Ut.prototype = {
				type: "URL",
				parse: function(t, e, r) {
					var i, o, a, s, c = this,
						u = e || St,
						d = 0,
						l = "",
						f = !1,
						p = !1,
						g = !1;
					t = v(t), e || (c.scheme = "", c.username = "", c.password = "", c.host = null, c.port = null, c.path = [], c.query = null, c.fragment = null, c.cannotBeABaseURL = !1, t = K(t, it, "")), t = K(t, ot, ""), i = m(t);
					while (d <= i.length) {
						switch (o = i[d], u) {
							case St:
								if (!o || !N(Y, o)) {
									if (e) return W;
									u = Ct;
									continue
								}
								l += z(o), u = wt;
								break;
							case wt:
								if (o && (N(Z, o) || "+" == o || "-" == o || "." == o)) l += z(o);
								else {
									if (":" != o) {
										if (e) return W;
										l = "", u = Ct, d = 0;
										continue
									}
									if (e && (c.isSpecial() != h(mt, l) || "file" == l && (c.includesCredentials() || null !== c.port) || "file" == c.scheme && !c.host)) return;
									if (c.scheme = l, e) return void(c.isSpecial() && mt[c.scheme] == c.port && (c.port = null));
									l = "", "file" == c.scheme ? u = Rt : c.isSpecial() && r && r.scheme == c.scheme ? u = _t : c.isSpecial() ? u = Tt : "/" == i[d + 1] ? (u = At, d++) : (c.cannotBeABaseURL = !0, j(c.path, ""), u = jt)
								}
								break;
							case Ct:
								if (!r || r.cannotBeABaseURL && "#" != o) return W;
								if (r.cannotBeABaseURL && "#" == o) {
									c.scheme = r.scheme, c.path = b(r.path), c.query = r.query, c.fragment = "", c.cannotBeABaseURL = !0, u = Lt;
									break
								}
								u = "file" == r.scheme ? Rt : It;
								continue;
							case _t:
								if ("/" != o || "/" != i[d + 1]) {
									u = It;
									continue
								}
								u = xt, d++;
								break;
							case At:
								if ("/" == o) {
									u = Pt;
									break
								}
								u = Ft;
								continue;
							case It:
								if (c.scheme = r.scheme, o == n) c.username = r.username, c.password = r.password, c.host = r.host, c.port = r.port, c.path = b(r.path), c.query = r.query;
								else if ("/" == o || "\\" == o && c.isSpecial()) u = Et;
								else if ("?" == o) c.username = r.username, c.password = r.password, c.host = r.host, c.port = r.port, c.path = b(r.path), c.query = "", u = Kt;
								else {
									if ("#" != o) {
										c.username = r.username, c.password = r.password, c.host = r.host, c.port = r.port, c.path = b(r.path), c.path.length--, u = Ft;
										continue
									}
									c.username = r.username, c.password = r.password, c.host = r.host, c.port = r.port, c.path = b(r.path), c.query = r.query, c.fragment = "", u = Lt
								}
								break;
							case Et:
								if (!c.isSpecial() || "/" != o && "\\" != o) {
									if ("/" != o) {
										c.username = r.username, c.password = r.password, c.host = r.host, c.port = r.port, u = Ft;
										continue
									}
									u = Pt
								} else u = xt;
								break;
							case Tt:
								if (u = xt, "/" != o || "/" != R(l, d + 1)) continue;
								d++;
								break;
							case xt:
								if ("/" != o && "\\" != o) {
									u = Pt;
									continue
								}
								break;
							case Pt:
								if ("@" == o) {
									f && (l = "%40" + l), f = !0, a = m(l);
									for (var y = 0; y < a.length; y++) {
										var S = a[y];
										if (":" != S || g) {
											var w = pt(S, ht);
											g ? c.password += w : c.username += w
										} else g = !0
									}
									l = ""
								} else if (o == n || "/" == o || "?" == o || "#" == o || "\\" == o && c.isSpecial()) {
									if (f && "" == l) return q;
									d -= m(l)
										.length + 1, l = "", u = kt
								} else l += o;
								break;
							case kt:
							case Dt:
								if (e && "file" == c.scheme) {
									u = Mt;
									continue
								}
								if (":" != o || p) {
									if (o == n || "/" == o || "?" == o || "#" == o || "\\" == o && c.isSpecial()) {
										if (c.isSpecial() && "" == l) return V;
										if (e && "" == l && (c.includesCredentials() || null !== c.port)) return;
										if (s = c.parseHost(l), s) return s;
										if (l = "", u = Bt, e) return;
										continue
									}
									"[" == o ? p = !0 : "]" == o && (p = !1), l += o
								} else {
									if ("" == l) return V;
									if (s = c.parseHost(l), s) return s;
									if (l = "", u = Ot, e == Dt) return
								}
								break;
							case Ot:
								if (!N(Q, o)) {
									if (o == n || "/" == o || "?" == o || "#" == o || "\\" == o && c.isSpecial() || e) {
										if ("" != l) {
											var C = k(l, 10);
											if (C > 65535) return H;
											c.port = c.isSpecial() && C === mt[c.scheme] ? null : C, l = ""
										}
										if (e) return;
										u = Bt;
										continue
									}
									return H
								}
								l += o;
								break;
							case Rt:
								if (c.scheme = "file", "/" == o || "\\" == o) u = Nt;
								else {
									if (!r || "file" != r.scheme) {
										u = Ft;
										continue
									}
									if (o == n) c.host = r.host, c.path = b(r.path), c.query = r.query;
									else if ("?" == o) c.host = r.host, c.path = b(r.path), c.query = "", u = Kt;
									else {
										if ("#" != o) {
											gt(M(b(i, d), "")) || (c.host = r.host, c.path = b(r.path), c.shortenPath()), u = Ft;
											continue
										}
										c.host = r.host, c.path = b(r.path), c.query = r.query, c.fragment = "", u = Lt
									}
								}
								break;
							case Nt:
								if ("/" == o || "\\" == o) {
									u = Mt;
									break
								}
								r && "file" == r.scheme && !gt(M(b(i, d), "")) && (bt(r.path[0], !0) ? j(c.path, r.path[0]) : c.host = r.host), u = Ft;
								continue;
							case Mt:
								if (o == n || "/" == o || "\\" == o || "?" == o || "#" == o) {
									if (!e && bt(l)) u = Ft;
									else if ("" == l) {
										if (c.host = "", e) return;
										u = Bt
									} else {
										if (s = c.parseHost(l), s) return s;
										if ("localhost" == c.host && (c.host = ""), e) return;
										l = "", u = Bt
									}
									continue
								}
								l += o;
								break;
							case Bt:
								if (c.isSpecial()) {
									if (u = Ft, "/" != o && "\\" != o) continue
								} else if (e || "?" != o)
									if (e || "#" != o) {
										if (o != n && (u = Ft, "/" != o)) continue
									} else c.fragment = "", u = Lt;
								else c.query = "", u = Kt;
								break;
							case Ft:
								if (o == n || "/" == o || "\\" == o && c.isSpecial() || !e && ("?" == o || "#" == o)) {
									if (vt(l) ? (c.shortenPath(), "/" == o || "\\" == o && c.isSpecial() || j(c.path, "")) : yt(l) ? "/" == o || "\\" == o && c.isSpecial() || j(c.path, "") : ("file" == c.scheme && !c.path.length && bt(l) && (c.host && (c.host = ""), l = R(l, 0) + ":"), j(c.path, l)), l = "", "file" == c.scheme && (o == n || "?" == o || "#" == o))
										while (c.path.length > 1 && "" === c.path[0]) L(c.path);
									"?" == o ? (c.query = "", u = Kt) : "#" == o && (c.fragment = "", u = Lt)
								} else l += pt(o, ft);
								break;
							case jt:
								"?" == o ? (c.query = "", u = Kt) : "#" == o ? (c.fragment = "", u = Lt) : o != n && (c.path[0] += pt(o, dt));
								break;
							case Kt:
								e || "#" != o ? o != n && ("'" == o && c.isSpecial() ? c.query += "%27" : c.query += "#" == o ? "%23" : pt(o, dt)) : (c.fragment = "", u = Lt);
								break;
							case Lt:
								o != n && (c.fragment += pt(o, lt));
								break
						}
						d++
					}
				},
				parseHost: function(t) {
					var e, r, n;
					if ("[" == R(t, 0)) {
						if ("]" != R(t, t.length - 1)) return V;
						if (e = st(X(t, 1, -1)), !e) return V;
						this.host = e
					} else if (this.isSpecial()) {
						if (t = y(t), N(rt, t)) return V;
						if (e = at(t), null === e) return V;
						this.host = e
					} else {
						if (N(nt, t)) return V;
						for (e = "", r = m(t), n = 0; n < r.length; n++) e += pt(r[n], dt);
						this.host = e
					}
				},
				cannotHaveUsernamePasswordPort: function() {
					return !this.host || this.cannotBeABaseURL || "file" == this.scheme
				},
				includesCredentials: function() {
					return "" != this.username || "" != this.password
				},
				isSpecial: function() {
					return h(mt, this.scheme)
				},
				shortenPath: function() {
					var t = this.path,
						e = t.length;
					!e || "file" == this.scheme && 1 == e && bt(t[0], !0) || t.length--
				},
				serialize: function() {
					var t = this,
						e = t.scheme,
						r = t.username,
						n = t.password,
						i = t.host,
						o = t.port,
						a = t.path,
						s = t.query,
						c = t.fragment,
						u = e + ":";
					return null !== i ? (u += "//", t.includesCredentials() && (u += r + (n ? ":" + n : "") + "@"), u += ut(i), null !== o && (u += ":" + o)) : "file" == e && (u += "//"), u += t.cannotBeABaseURL ? a[0] : a.length ? "/" + M(a, "/") : "", null !== s && (u += "?" + s), null !== c && (u += "#" + c), u
				},
				setHref: function(t) {
					var e = this.parse(t);
					if (e) throw P(e);
					this.searchParams.update()
				},
				getOrigin: function() {
					var t = this.scheme,
						e = this.port;
					if ("blob" == t) try {
						return new Xt(t.path[0])
							.origin
					} catch (r) {
						return "null"
					}
					return "file" != t && this.isSpecial() ? t + "://" + ut(this.host) + (null !== e ? ":" + e : "") : "null"
				},
				getProtocol: function() {
					return this.scheme + ":"
				},
				setProtocol: function(t) {
					this.parse(v(t) + ":", St)
				},
				getUsername: function() {
					return this.username
				},
				setUsername: function(t) {
					var e = m(v(t));
					if (!this.cannotHaveUsernamePasswordPort()) {
						this.username = "";
						for (var r = 0; r < e.length; r++) this.username += pt(e[r], ht)
					}
				},
				getPassword: function() {
					return this.password
				},
				setPassword: function(t) {
					var e = m(v(t));
					if (!this.cannotHaveUsernamePasswordPort()) {
						this.password = "";
						for (var r = 0; r < e.length; r++) this.password += pt(e[r], ht)
					}
				},
				getHost: function() {
					var t = this.host,
						e = this.port;
					return null === t ? "" : null === e ? ut(t) : ut(t) + ":" + e
				},
				setHost: function(t) {
					this.cannotBeABaseURL || this.parse(t, kt)
				},
				getHostname: function() {
					var t = this.host;
					return null === t ? "" : ut(t)
				},
				setHostname: function(t) {
					this.cannotBeABaseURL || this.parse(t, Dt)
				},
				getPort: function() {
					var t = this.port;
					return null === t ? "" : v(t)
				},
				setPort: function(t) {
					this.cannotHaveUsernamePasswordPort() || (t = v(t), "" == t ? this.port = null : this.parse(t, Ot))
				},
				getPathname: function() {
					var t = this.path;
					return this.cannotBeABaseURL ? t[0] : t.length ? "/" + M(t, "/") : ""
				},
				setPathname: function(t) {
					this.cannotBeABaseURL || (this.path = [], this.parse(t, Bt))
				},
				getSearch: function() {
					var t = this.query;
					return t ? "?" + t : ""
				},
				setSearch: function(t) {
					t = v(t), "" == t ? this.query = null : ("?" == R(t, 0) && (t = X(t, 1)), this.query = "", this.parse(t, Kt)), this.searchParams.update()
				},
				getSearchParams: function() {
					return this.searchParams.facade
				},
				getHash: function() {
					var t = this.fragment;
					return t ? "#" + t : ""
				},
				setHash: function(t) {
					t = v(t), "" != t ? ("#" == R(t, 0) && (t = X(t, 1)), this.fragment = "", this.parse(t, Lt)) : this.fragment = null
				},
				update: function() {
					this.query = this.searchParams.serialize() || null
				}
			};
			var Xt = function(t) {
					var e = f(this, zt),
						r = w(arguments.length, 1) > 1 ? arguments[1] : void 0,
						n = A(e, new Ut(t, !1, r));
					o || (e.href = n.serialize(), e.origin = n.getOrigin(), e.protocol = n.getProtocol(), e.username = n.getUsername(), e.password = n.getPassword(), e.host = n.getHost(), e.hostname = n.getHostname(), e.port = n.getPort(), e.pathname = n.getPathname(), e.search = n.getSearch(), e.searchParams = n.getSearchParams(), e.hash = n.getHash())
				},
				zt = Xt.prototype,
				Gt = function(t, e) {
					return {
						get: function() {
							return I(this)[t]()
						},
						set: e && function(t) {
							return I(this)[e](t)
						},
						configurable: !0,
						enumerable: !0
					}
				};
			if (o && (l(zt, "href", Gt("serialize", "setHref")), l(zt, "origin", Gt("getOrigin")), l(zt, "protocol", Gt("getProtocol", "setProtocol")), l(zt, "username", Gt("getUsername", "setUsername")), l(zt, "password", Gt("getPassword", "setPassword")), l(zt, "host", Gt("getHost", "setHost")), l(zt, "hostname", Gt("getHostname", "setHostname")), l(zt, "port", Gt("getPort", "setPort")), l(zt, "pathname", Gt("getPathname", "setPathname")), l(zt, "search", Gt("getSearch", "setSearch")), l(zt, "searchParams", Gt("getSearchParams")), l(zt, "hash", Gt("getHash", "setHash"))), d(zt, "toJSON", (function() {
				return I(this)
					.serialize()
			}), {
				enumerable: !0
			}), d(zt, "toString", (function() {
				return I(this)
					.serialize()
			}), {
				enumerable: !0
			}), x) {
				var qt = x.createObjectURL,
					Wt = x.revokeObjectURL;
				qt && d(Xt, "createObjectURL", c(qt, x)), Wt && d(Xt, "revokeObjectURL", c(Wt, x))
			}
			S(Xt, "URL"), i({
				global: !0,
				constructor: !0,
				forced: !a,
				sham: !o
			}, {
				URL: Xt
			})
		},
		"40d5": function(t, e, r) {
			var n = r("d039");
			t.exports = !n((function() {
				var t = function() {}.bind();
				return "function" != typeof t || t.hasOwnProperty("prototype")
			}))
		},
		"428f": function(t, e, r) {
			var n = r("da84");
			t.exports = n
		},
		4362: function(t, e, r) {
			e.nextTick = function(t) {
					var e = Array.prototype.slice.call(arguments);
					e.shift(), setTimeout((function() {
						t.apply(null, e)
					}), 0)
				}, e.platform = e.arch = e.execPath = e.title = "browser", e.pid = 1, e.browser = !0, e.env = {}, e.argv = [], e.binding = function(t) {
					throw new Error("No such module. (Possibly not yet loaded)")
				},
				function() {
					var t, n = "/";
					e.cwd = function() {
						return n
					}, e.chdir = function(e) {
						t || (t = r("df7c")), n = t.resolve(e, n)
					}
				}(), e.exit = e.kill = e.umask = e.dlopen = e.uptime = e.memoryUsage = e.uvCounters = function() {}, e.features = {}
		},
		"44ad": function(t, e, r) {
			var n = r("da84"),
				i = r("e330"),
				o = r("d039"),
				a = r("c6b6"),
				s = n.Object,
				c = i("".split);
			t.exports = o((function() {
				return !s("z")
					.propertyIsEnumerable(0)
			})) ? function(t) {
				return "String" == a(t) ? c(t, "") : s(t)
			} : s
		},
		"44d2": function(t, e, r) {
			var n = r("b622"),
				i = r("7c73"),
				o = r("9bf2"),
				a = n("unscopables"),
				s = Array.prototype;
			void 0 == s[a] && o.f(s, a, {
				configurable: !0,
				value: i(null)
			}), t.exports = function(t) {
				s[a][t] = !0
			}
		},
		"44de": function(t, e, r) {
			var n = r("da84");
			t.exports = function(t, e) {
				var r = n.console;
				r && r.error && (1 == arguments.length ? r.error(t) : r.error(t, e))
			}
		},
		"44e7": function(t, e, r) {
			var n = r("861d"),
				i = r("c6b6"),
				o = r("b622"),
				a = o("match");
			t.exports = function(t) {
				var e;
				return n(t) && (void 0 !== (e = t[a]) ? !!e : "RegExp" == i(t))
			}
		},
		4661: function(t, e, r) {
			r("2532");
			var n = r("b109");
			t.exports = n("String", "includes")
		},
		"467f": function(t, e, r) {
			"use strict";
			var n = r("2d83");
			t.exports = function(t, e, r) {
				var i = r.config.validateStatus;
				r.status && i && !i(r.status) ? e(n("Request failed with status code " + r.status, r.config, null, r.request, r)) : t(r)
			}
		},
		4738: function(t, e, r) {
			var n = r("da84"),
				i = r("d256"),
				o = r("1626"),
				a = r("94ca"),
				s = r("8925"),
				c = r("b622"),
				u = r("6069"),
				d = r("c430"),
				l = r("2d00"),
				f = i && i.prototype,
				h = c("species"),
				p = !1,
				m = o(n.PromiseRejectionEvent),
				b = a("Promise", (function() {
					var t = s(i),
						e = t !== String(i);
					if (!e && 66 === l) return !0;
					if (d && (!f["catch"] || !f["finally"])) return !0;
					if (l >= 51 && /native code/.test(t)) return !1;
					var r = new i((function(t) {
							t(1)
						})),
						n = function(t) {
							t((function() {}), (function() {}))
						},
						o = r.constructor = {};
					return o[h] = n, p = r.then((function() {})) instanceof n, !p || !e && u && !m
				}));
			t.exports = {
				CONSTRUCTOR: b,
				REJECTION_EVENT: m,
				SUBCLASSING: p
			}
		},
		"476b": function(t, e, r) {
			r("843c");
			var n = r("b109");
			t.exports = n("String", "padEnd")
		},
		4840: function(t, e, r) {
			var n = r("825a"),
				i = r("5087"),
				o = r("b622"),
				a = o("species");
			t.exports = function(t, e) {
				var r, o = n(t)
					.constructor;
				return void 0 === o || void 0 == (r = n(o)[a]) ? e : i(r)
			}
		},
		"485a": function(t, e, r) {
			var n = r("da84"),
				i = r("c65b"),
				o = r("1626"),
				a = r("861d"),
				s = n.TypeError;
			t.exports = function(t, e) {
				var r, n;
				if ("string" === e && o(r = t.toString) && !a(n = i(r, t))) return n;
				if (o(r = t.valueOf) && !a(n = i(r, t))) return n;
				if ("string" !== e && o(r = t.toString) && !a(n = i(r, t))) return n;
				throw s("Can't convert object to primitive value")
			}
		},
		4930: function(t, e, r) {
			var n = r("2d00"),
				i = r("d039");
			t.exports = !!Object.getOwnPropertySymbols && !i((function() {
				var t = Symbol();
				return !String(t) || !(Object(t) instanceof Symbol) || !Symbol.sham && n && n < 41
			}))
		},
		"4a7b": function(t, e, r) {
			"use strict";
			var n = r("c532");
			t.exports = function(t, e) {
				e = e || {};
				var r = {},
					i = ["url", "method", "data"],
					o = ["headers", "auth", "proxy", "params"],
					a = ["baseURL", "transformRequest", "transformResponse", "paramsSerializer", "timeout", "timeoutMessage", "withCredentials", "adapter", "responseType", "xsrfCookieName", "xsrfHeaderName", "onUploadProgress", "onDownloadProgress", "decompress", "maxContentLength", "maxBodyLength", "maxRedirects", "transport", "httpAgent", "httpsAgent", "cancelToken", "socketPath", "responseEncoding"],
					s = ["validateStatus"];

				function c(t, e) {
					return n.isPlainObject(t) && n.isPlainObject(e) ? n.merge(t, e) : n.isPlainObject(e) ? n.merge({}, e) : n.isArray(e) ? e.slice() : e
				}

				function u(i) {
					n.isUndefined(e[i]) ? n.isUndefined(t[i]) || (r[i] = c(void 0, t[i])) : r[i] = c(t[i], e[i])
				}
				n.forEach(i, (function(t) {
					n.isUndefined(e[t]) || (r[t] = c(void 0, e[t]))
				})), n.forEach(o, u), n.forEach(a, (function(i) {
					n.isUndefined(e[i]) ? n.isUndefined(t[i]) || (r[i] = c(void 0, t[i])) : r[i] = c(void 0, e[i])
				})), n.forEach(s, (function(n) {
					n in e ? r[n] = c(t[n], e[n]) : n in t && (r[n] = c(void 0, t[n]))
				}));
				var d = i.concat(o)
					.concat(a)
					.concat(s),
					l = Object.keys(t)
					.concat(Object.keys(e))
					.filter((function(t) {
						return -1 === d.indexOf(t)
					}));
				return n.forEach(l, u), r
			}
		},
		"4d64": function(t, e, r) {
			var n = r("fc6a"),
				i = r("23cb"),
				o = r("07fa"),
				a = function(t) {
					return function(e, r, a) {
						var s, c = n(e),
							u = o(c),
							d = i(a, u);
						if (t && r != r) {
							while (u > d)
								if (s = c[d++], s != s) return !0
						} else
							for (; u > d; d++)
								if ((t || d in c) && c[d] === r) return t || d || 0;
						return !t && -1
					}
				};
			t.exports = {
				includes: a(!0),
				indexOf: a(!1)
			}
		},
		"4d90": function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("0ccb")
				.start,
				o = r("9a0c");
			n({
				target: "String",
				proto: !0,
				forced: o
			}, {
				padStart: function(t) {
					return i(this, t, arguments.length > 1 ? arguments[1] : void 0)
				}
			})
		},
		"4dae": function(t, e, r) {
			var n = r("da84"),
				i = r("23cb"),
				o = r("07fa"),
				a = r("8418"),
				s = n.Array,
				c = Math.max;
			t.exports = function(t, e, r) {
				for (var n = o(t), u = i(e, n), d = i(void 0 === r ? n : r, n), l = s(c(d - u, 0)), f = 0; u < d; u++, f++) a(l, f, t[u]);
				return l.length = f, l
			}
		},
		"4df4": function(t, e, r) {
			"use strict";
			var n = r("da84"),
				i = r("0366"),
				o = r("c65b"),
				a = r("7b0b"),
				s = r("9bdd"),
				c = r("e95a"),
				u = r("68ee"),
				d = r("07fa"),
				l = r("8418"),
				f = r("9a1f"),
				h = r("35a1"),
				p = n.Array;
			t.exports = function(t) {
				var e = a(t),
					r = u(this),
					n = arguments.length,
					m = n > 1 ? arguments[1] : void 0,
					b = void 0 !== m;
				b && (m = i(m, n > 2 ? arguments[2] : void 0));
				var g, y, v, S, w, C, _ = h(e),
					A = 0;
				if (!_ || this == p && c(_))
					for (g = d(e), y = r ? new this(g) : p(g); g > A; A++) C = b ? m(e[A], A) : e[A], l(y, A, C);
				else
					for (S = f(e, _), w = S.next, y = r ? new this : []; !(v = o(w, S))
						.done; A++) C = b ? s(S, m, [v.value, A], !0) : v.value, l(y, A, C);
				return y.length = A, y
			}
		},
		"4e28": function(t, e, r) {
			r("07ac");
			var n = r("428f");
			t.exports = n.Object.values
		},
		"4ec9": function(t, e, r) {
			r("6f48")
		},
		"4fad": function(t, e, r) {
			var n = r("d039"),
				i = r("861d"),
				o = r("c6b6"),
				a = r("d86b"),
				s = Object.isExtensible,
				c = n((function() {
					s(1)
				}));
			t.exports = c || a ? function(t) {
				return !!i(t) && ((!a || "ArrayBuffer" != o(t)) && (!s || s(t)))
			} : s
		},
		"4fadc": function(t, e, r) {
			var n = r("23e7"),
				i = r("6f53")
				.entries;
			n({
				target: "Object",
				stat: !0
			}, {
				entries: function(t) {
					return i(t)
				}
			})
		},
		5087: function(t, e, r) {
			var n = r("da84"),
				i = r("68ee"),
				o = r("0d51"),
				a = n.TypeError;
			t.exports = function(t) {
				if (i(t)) return t;
				throw a(o(t) + " is not a constructor")
			}
		},
		"50c4": function(t, e, r) {
			var n = r("5926"),
				i = Math.min;
			t.exports = function(t) {
				return t > 0 ? i(n(t), 9007199254740991) : 0
			}
		},
		5270: function(t, e, r) {
			"use strict";
			var n = r("c532"),
				i = r("c401"),
				o = r("2e67"),
				a = r("2444");

			function s(t) {
				t.cancelToken && t.cancelToken.throwIfRequested()
			}
			t.exports = function(t) {
				s(t), t.headers = t.headers || {}, t.data = i(t.data, t.headers, t.transformRequest), t.headers = n.merge(t.headers.common || {}, t.headers[t.method] || {}, t.headers), n.forEach(["delete", "get", "head", "post", "put", "patch", "common"], (function(e) {
					delete t.headers[e]
				}));
				var e = t.adapter || a.adapter;
				return e(t)
					.then((function(e) {
						return s(t), e.data = i(e.data, e.headers, t.transformResponse), e
					}), (function(e) {
						return o(e) || (s(t), e && e.response && (e.response.data = i(e.response.data, e.response.headers, t.transformResponse))), Promise.reject(e)
					}))
			}
		},
		5352: function(t, e, r) {
			"use strict";
			r("e260");
			var n = r("23e7"),
				i = r("da84"),
				o = r("c65b"),
				a = r("e330"),
				s = r("83ab"),
				c = r("0d3b"),
				u = r("cb2d"),
				d = r("6964"),
				l = r("d44e"),
				f = r("9ed3"),
				h = r("69f3"),
				p = r("19aa"),
				m = r("1626"),
				b = r("1a2d"),
				g = r("0366"),
				y = r("f5df"),
				v = r("825a"),
				S = r("861d"),
				w = r("577e"),
				C = r("7c73"),
				_ = r("5c6c"),
				A = r("9a1f"),
				I = r("35a1"),
				E = r("d6d6"),
				T = r("b622"),
				x = r("addb"),
				P = T("iterator"),
				k = "URLSearchParams",
				D = k + "Iterator",
				O = h.set,
				R = h.getterFor(k),
				N = h.getterFor(D),
				M = Object.getOwnPropertyDescriptor,
				B = function(t) {
					if (!s) return i[t];
					var e = M(i, t);
					return e && e.value
				},
				F = B("fetch"),
				j = B("Request"),
				K = B("Headers"),
				L = j && j.prototype,
				U = K && K.prototype,
				X = i.RegExp,
				z = i.TypeError,
				G = i.decodeURIComponent,
				q = i.encodeURIComponent,
				W = a("".charAt),
				V = a([].join),
				H = a([].push),
				Y = a("".replace),
				Z = a([].shift),
				Q = a([].splice),
				J = a("".split),
				$ = a("".slice),
				tt = /\+/g,
				et = Array(4),
				rt = function(t) {
					return et[t - 1] || (et[t - 1] = X("((?:%[\\da-f]{2}){" + t + "})", "gi"))
				},
				nt = function(t) {
					try {
						return G(t)
					} catch (e) {
						return t
					}
				},
				it = function(t) {
					var e = Y(t, tt, " "),
						r = 4;
					try {
						return G(e)
					} catch (n) {
						while (r) e = Y(e, rt(r--), nt);
						return e
					}
				},
				ot = /[!'()~]|%20/g,
				at = {
					"!": "%21",
					"'": "%27",
					"(": "%28",
					")": "%29",
					"~": "%7E",
					"%20": "+"
				},
				st = function(t) {
					return at[t]
				},
				ct = function(t) {
					return Y(q(t), ot, st)
				},
				ut = f((function(t, e) {
					O(this, {
						type: D,
						iterator: A(R(t)
							.entries),
						kind: e
					})
				}), "Iterator", (function() {
					var t = N(this),
						e = t.kind,
						r = t.iterator.next(),
						n = r.value;
					return r.done || (r.value = "keys" === e ? n.key : "values" === e ? n.value : [n.key, n.value]), r
				}), !0),
				dt = function(t) {
					this.entries = [], this.url = null, void 0 !== t && (S(t) ? this.parseObject(t) : this.parseQuery("string" == typeof t ? "?" === W(t, 0) ? $(t, 1) : t : w(t)))
				};
			dt.prototype = {
				type: k,
				bindURL: function(t) {
					this.url = t, this.update()
				},
				parseObject: function(t) {
					var e, r, n, i, a, s, c, u = I(t);
					if (u) {
						e = A(t, u), r = e.next;
						while (!(n = o(r, e))
							.done) {
							if (i = A(v(n.value)), a = i.next, (s = o(a, i))
								.done || (c = o(a, i))
								.done || !o(a, i)
								.done) throw z("Expected sequence with length 2");
							H(this.entries, {
								key: w(s.value),
								value: w(c.value)
							})
						}
					} else
						for (var d in t) b(t, d) && H(this.entries, {
							key: d,
							value: w(t[d])
						})
				},
				parseQuery: function(t) {
					if (t) {
						var e, r, n = J(t, "&"),
							i = 0;
						while (i < n.length) e = n[i++], e.length && (r = J(e, "="), H(this.entries, {
							key: it(Z(r)),
							value: it(V(r, "="))
						}))
					}
				},
				serialize: function() {
					var t, e = this.entries,
						r = [],
						n = 0;
					while (n < e.length) t = e[n++], H(r, ct(t.key) + "=" + ct(t.value));
					return V(r, "&")
				},
				update: function() {
					this.entries.length = 0, this.parseQuery(this.url.query)
				},
				updateURL: function() {
					this.url && this.url.update()
				}
			};
			var lt = function() {
					p(this, ft);
					var t = arguments.length > 0 ? arguments[0] : void 0;
					O(this, new dt(t))
				},
				ft = lt.prototype;
			if (d(ft, {
				append: function(t, e) {
					E(arguments.length, 2);
					var r = R(this);
					H(r.entries, {
						key: w(t),
						value: w(e)
					}), r.updateURL()
				},
				delete: function(t) {
					E(arguments.length, 1);
					var e = R(this),
						r = e.entries,
						n = w(t),
						i = 0;
					while (i < r.length) r[i].key === n ? Q(r, i, 1) : i++;
					e.updateURL()
				},
				get: function(t) {
					E(arguments.length, 1);
					for (var e = R(this)
						.entries, r = w(t), n = 0; n < e.length; n++)
						if (e[n].key === r) return e[n].value;
					return null
				},
				getAll: function(t) {
					E(arguments.length, 1);
					for (var e = R(this)
						.entries, r = w(t), n = [], i = 0; i < e.length; i++) e[i].key === r && H(n, e[i].value);
					return n
				},
				has: function(t) {
					E(arguments.length, 1);
					var e = R(this)
						.entries,
						r = w(t),
						n = 0;
					while (n < e.length)
						if (e[n++].key === r) return !0;
					return !1
				},
				set: function(t, e) {
					E(arguments.length, 1);
					for (var r, n = R(this), i = n.entries, o = !1, a = w(t), s = w(e), c = 0; c < i.length; c++) r = i[c], r.key === a && (o ? Q(i, c--, 1) : (o = !0, r.value = s));
					o || H(i, {
						key: a,
						value: s
					}), n.updateURL()
				},
				sort: function() {
					var t = R(this);
					x(t.entries, (function(t, e) {
						return t.key > e.key ? 1 : -1
					})), t.updateURL()
				},
				forEach: function(t) {
					var e, r = R(this)
						.entries,
						n = g(t, arguments.length > 1 ? arguments[1] : void 0),
						i = 0;
					while (i < r.length) e = r[i++], n(e.value, e.key, this)
				},
				keys: function() {
					return new ut(this, "keys")
				},
				values: function() {
					return new ut(this, "values")
				},
				entries: function() {
					return new ut(this, "entries")
				}
			}, {
				enumerable: !0
			}), u(ft, P, ft.entries, {
				name: "entries"
			}), u(ft, "toString", (function() {
				return R(this)
					.serialize()
			}), {
				enumerable: !0
			}), l(lt, k), n({
				global: !0,
				constructor: !0,
				forced: !c
			}, {
				URLSearchParams: lt
			}), !c && m(K)) {
				var ht = a(U.has),
					pt = a(U.set),
					mt = function(t) {
						if (S(t)) {
							var e, r = t.body;
							if (y(r) === k) return e = t.headers ? new K(t.headers) : new K, ht(e, "content-type") || pt(e, "content-type", "application/x-www-form-urlencoded;charset=UTF-8"), C(t, {
								body: _(0, w(r)),
								headers: _(0, e)
							})
						}
						return t
					};
				if (m(F) && n({
					global: !0,
					enumerable: !0,
					noTargetGet: !0,
					forced: !0
				}, {
					fetch: function(t) {
						return F(t, arguments.length > 1 ? mt(arguments[1]) : {})
					}
				}), m(j)) {
					var bt = function(t) {
						return p(this, L), new j(t, arguments.length > 1 ? mt(arguments[1]) : {})
					};
					L.constructor = bt, bt.prototype = L, n({
						global: !0,
						constructor: !0,
						noTargetGet: !0,
						forced: !0
					}, {
						Request: bt
					})
				}
			}
			t.exports = {
				URLSearchParams: lt,
				getState: R
			}
		},
		5486: function(t, e, r) {
			"use strict";
			(function(t) {
				const n = r("90da"),
					i = function(e, r) {
						const o = {};
						if (!(e.child && !n.isEmptyObject(e.child) || e.attrsMap && !n.isEmptyObject(e.attrsMap))) return n.isExist(e.val) ? e.val : "";
						n.isExist(e.val) && ("string" !== typeof e.val || "" !== e.val && e.val !== r.cdataPositionChar) && ("strict" === r.arrayMode ? o[r.textNodeName] = [e.val] : o[r.textNodeName] = e.val), n.merge(o, e.attrsMap, r.arrayMode);
						const a = Object.keys(e.child);
						for (let n = 0; n < a.length; n++) {
							var s = a[n];
							if (e.child[s] && e.child[s].length > 1)
								for (var c in o[s] = [], e.child[s]) t.xmlParseFlag = t.xmlParseFlag + 1, o[s].push(i(e.child[s][c], r));
							else if (!0 === r.arrayMode) {
								t.xmlParseFlag = t.xmlParseFlag + 1;
								const n = i(e.child[s][0], r);
								o[s] = "object" === typeof n ? [n] : n
							} else "strict" === r.arrayMode ? (t.xmlParseFlag = t.xmlParseFlag + 1, o[s] = [i(e.child[s][0], r)]) : (t.xmlParseFlag = t.xmlParseFlag + 1, o[s] = i(e.child[s][0], r))
						}
						let u = o;
						return "object" === typeof u && (u["pfIndex"] = t.xmlParseFlag), o
					};
				e.convertToJson = i
			})
			.call(this, r("c8ba"))
		},
		5692: function(t, e, r) {
			var n = r("c430"),
				i = r("c6cd");
			(t.exports = function(t, e) {
				return i[t] || (i[t] = void 0 !== e ? e : {})
			})("versions", [])
			.push({
				version: "3.22.5",
				mode: n ? "pure" : "global",
				copyright: "© 2014-2022 Denis Pushkarev (zloirock.ru)",
				license: "https://github.com/zloirock/core-js/blob/v3.22.5/LICENSE",
				source: "https://github.com/zloirock/core-js"
			})
		},
		"56ef": function(t, e, r) {
			var n = r("d066"),
				i = r("e330"),
				o = r("241c"),
				a = r("7418"),
				s = r("825a"),
				c = i([].concat);
			t.exports = n("Reflect", "ownKeys") || function(t) {
				var e = o.f(s(t)),
					r = a.f;
				return r ? c(e, r(t)) : e
			}
		},
		"577e": function(t, e, r) {
			var n = r("da84"),
				i = r("f5df"),
				o = n.String;
			t.exports = function(t) {
				if ("Symbol" === i(t)) throw TypeError("Cannot convert a Symbol value to a string");
				return o(t)
			}
		},
		"57b9": function(t, e, r) {
			var n = r("c65b"),
				i = r("d066"),
				o = r("b622"),
				a = r("cb2d");
			t.exports = function() {
				var t = i("Symbol"),
					e = t && t.prototype,
					r = e && e.valueOf,
					s = o("toPrimitive");
				e && !e[s] && a(e, s, (function(t) {
					return n(r, this)
				}), {
					arity: 1
				})
			}
		},
		5926: function(t, e) {
			var r = Math.ceil,
				n = Math.floor;
			t.exports = function(t) {
				var e = +t;
				return e !== e || 0 === e ? 0 : (e > 0 ? n : r)(e)
			}
		},
		"59ed": function(t, e, r) {
			var n = r("da84"),
				i = r("1626"),
				o = r("0d51"),
				a = n.TypeError;
			t.exports = function(t) {
				if (i(t)) return t;
				throw a(o(t) + " is not a function")
			}
		},
		"5a34": function(t, e, r) {
			var n = r("da84"),
				i = r("44e7"),
				o = n.TypeError;
			t.exports = function(t) {
				if (i(t)) throw o("The method doesn't accept regular expressions");
				return t
			}
		},
		"5a47": function(t, e, r) {
			var n = r("23e7"),
				i = r("4930"),
				o = r("d039"),
				a = r("7418"),
				s = r("7b0b"),
				c = !i || o((function() {
					a.f(1)
				}));
			n({
				target: "Object",
				stat: !0,
				forced: c
			}, {
				getOwnPropertySymbols: function(t) {
					var e = a.f;
					return e ? e(s(t)) : []
				}
			})
		},
		"5a79": function(t, e, r) {
			"use strict";
			const n = r("90da"),
				i = r("90da")
				.buildOptions,
				o = r("8a24"),
				a = function(t, e) {
					return e = i(e, o.defaultOptions, o.props), e.indentBy = e.indentBy || "", s(t, e, 0)
				},
				s = function(t, e, r) {
					let i = "{";
					const o = Object.keys(t.child);
					for (let n = 0; n < o.length; n++) {
						var a = o[n];
						if (t.child[a] && t.child[a].length > 1) {
							for (var u in i += '"' + a + '" : [ ', t.child[a]) i += s(t.child[a][u], e) + " , ";
							i = i.substr(0, i.length - 1) + " ] "
						} else i += '"' + a + '" : ' + s(t.child[a][0], e) + " ,"
					}
					return n.merge(i, t.attrsMap), n.isEmptyObject(i) ? n.isExist(t.val) ? t.val : "" : (n.isExist(t.val) && ("string" !== typeof t.val || "" !== t.val && t.val !== e.cdataPositionChar) && (i += '"' + e.textNodeName + '" : ' + c(t.val)), "," === i[i.length - 1] && (i = i.substr(0, i.length - 2)), i + "}")
				};

			function c(t) {
				return !0 !== t && !1 !== t && isNaN(t) ? '"' + t + '"' : t
			}
			e.convertToJsonString = a
		},
		"5c6c": function(t, e) {
			t.exports = function(t, e) {
				return {
					enumerable: !(1 & t),
					configurable: !(2 & t),
					writable: !(4 & t),
					value: e
				}
			}
		},
		"5e77": function(t, e, r) {
			var n = r("83ab"),
				i = r("1a2d"),
				o = Function.prototype,
				a = n && Object.getOwnPropertyDescriptor,
				s = i(o, "name"),
				c = s && "something" === function() {}.name,
				u = s && (!n || n && a(o, "name")
					.configurable);
			t.exports = {
				EXISTS: s,
				PROPER: c,
				CONFIGURABLE: u
			}
		},
		"5e7e": function(t, e, r) {
			"use strict";
			var n, i, o, a, s = r("23e7"),
				c = r("c430"),
				u = r("605d"),
				d = r("da84"),
				l = r("c65b"),
				f = r("cb2d"),
				h = r("d2bb"),
				p = r("d44e"),
				m = r("2626"),
				b = r("59ed"),
				g = r("1626"),
				y = r("861d"),
				v = r("19aa"),
				S = r("4840"),
				w = r("2cf4")
				.set,
				C = r("b575"),
				_ = r("44de"),
				A = r("e667"),
				I = r("01b4"),
				E = r("69f3"),
				T = r("d256"),
				x = r("4738"),
				P = r("f069"),
				k = "Promise",
				D = x.CONSTRUCTOR,
				O = x.REJECTION_EVENT,
				R = x.SUBCLASSING,
				N = E.getterFor(k),
				M = E.set,
				B = T && T.prototype,
				F = T,
				j = B,
				K = d.TypeError,
				L = d.document,
				U = d.process,
				X = P.f,
				z = X,
				G = !!(L && L.createEvent && d.dispatchEvent),
				q = "unhandledrejection",
				W = "rejectionhandled",
				V = 0,
				H = 1,
				Y = 2,
				Z = 1,
				Q = 2,
				J = function(t) {
					var e;
					return !(!y(t) || !g(e = t.then)) && e
				},
				$ = function(t, e) {
					var r, n, i, o = e.value,
						a = e.state == H,
						s = a ? t.ok : t.fail,
						c = t.resolve,
						u = t.reject,
						d = t.domain;
					try {
						s ? (a || (e.rejection === Q && it(e), e.rejection = Z), !0 === s ? r = o : (d && d.enter(), r = s(o), d && (d.exit(), i = !0)), r === t.promise ? u(K("Promise-chain cycle")) : (n = J(r)) ? l(n, r, c, u) : c(r)) : u(o)
					} catch (f) {
						d && !i && d.exit(), u(f)
					}
				},
				tt = function(t, e) {
					t.notified || (t.notified = !0, C((function() {
						var r, n = t.reactions;
						while (r = n.get()) $(r, t);
						t.notified = !1, e && !t.rejection && rt(t)
					})))
				},
				et = function(t, e, r) {
					var n, i;
					G ? (n = L.createEvent("Event"), n.promise = e, n.reason = r, n.initEvent(t, !1, !0), d.dispatchEvent(n)) : n = {
						promise: e,
						reason: r
					}, !O && (i = d["on" + t]) ? i(n) : t === q && _("Unhandled promise rejection", r)
				},
				rt = function(t) {
					l(w, d, (function() {
						var e, r = t.facade,
							n = t.value,
							i = nt(t);
						if (i && (e = A((function() {
							u ? U.emit("unhandledRejection", n, r) : et(q, r, n)
						})), t.rejection = u || nt(t) ? Q : Z, e.error)) throw e.value
					}))
				},
				nt = function(t) {
					return t.rejection !== Z && !t.parent
				},
				it = function(t) {
					l(w, d, (function() {
						var e = t.facade;
						u ? U.emit("rejectionHandled", e) : et(W, e, t.value)
					}))
				},
				ot = function(t, e, r) {
					return function(n) {
						t(e, n, r)
					}
				},
				at = function(t, e, r) {
					t.done || (t.done = !0, r && (t = r), t.value = e, t.state = Y, tt(t, !0))
				},
				st = function(t, e, r) {
					if (!t.done) {
						t.done = !0, r && (t = r);
						try {
							if (t.facade === e) throw K("Promise can't be resolved itself");
							var n = J(e);
							n ? C((function() {
								var r = {
									done: !1
								};
								try {
									l(n, e, ot(st, r, t), ot(at, r, t))
								} catch (i) {
									at(r, i, t)
								}
							})) : (t.value = e, t.state = H, tt(t, !1))
						} catch (i) {
							at({
								done: !1
							}, i, t)
						}
					}
				};
			if (D && (F = function(t) {
				v(this, j), b(t), l(n, this);
				var e = N(this);
				try {
					t(ot(st, e), ot(at, e))
				} catch (r) {
					at(e, r)
				}
			}, j = F.prototype, n = function(t) {
				M(this, {
					type: k,
					done: !1,
					notified: !1,
					parent: !1,
					reactions: new I,
					rejection: !1,
					state: V,
					value: void 0
				})
			}, n.prototype = f(j, "then", (function(t, e) {
				var r = N(this),
					n = X(S(this, F));
				return r.parent = !0, n.ok = !g(t) || t, n.fail = g(e) && e, n.domain = u ? U.domain : void 0, r.state == V ? r.reactions.add(n) : C((function() {
					$(n, r)
				})), n.promise
			})), i = function() {
				var t = new n,
					e = N(t);
				this.promise = t, this.resolve = ot(st, e), this.reject = ot(at, e)
			}, P.f = X = function(t) {
				return t === F || t === o ? new i(t) : z(t)
			}, !c && g(T) && B !== Object.prototype)) {
				a = B.then, R || f(B, "then", (function(t, e) {
					var r = this;
					return new F((function(t, e) {
							l(a, r, t, e)
						}))
						.then(t, e)
				}), {
					unsafe: !0
				});
				try {
					delete B.constructor
				} catch (ct) {}
				h && h(B, j)
			}
			s({
				global: !0,
				constructor: !0,
				wrap: !0,
				forced: D
			}, {
				Promise: F
			}), p(F, k, !1, !0), m(k)
		},
		"5eed": function(t, e, r) {
			var n = r("d256"),
				i = r("1c7e"),
				o = r("4738")
				.CONSTRUCTOR;
			t.exports = o || !i((function(t) {
				n.all(t)
					.then(void 0, (function() {}))
			}))
		},
		"5eff": function(t, e, r) {
			r("e260"), r("4ec9"), r("d3b7"), r("3ca3");
			var n = r("428f");
			t.exports = n.Map
		},
		"5fb2": function(t, e, r) {
			"use strict";
			var n = r("da84"),
				i = r("e330"),
				o = 2147483647,
				a = 36,
				s = 1,
				c = 26,
				u = 38,
				d = 700,
				l = 72,
				f = 128,
				h = "-",
				p = /[^\0-\u007E]/,
				m = /[.\u3002\uFF0E\uFF61]/g,
				b = "Overflow: input needs wider integers to process",
				g = a - s,
				y = n.RangeError,
				v = i(m.exec),
				S = Math.floor,
				w = String.fromCharCode,
				C = i("".charCodeAt),
				_ = i([].join),
				A = i([].push),
				I = i("".replace),
				E = i("".split),
				T = i("".toLowerCase),
				x = function(t) {
					var e = [],
						r = 0,
						n = t.length;
					while (r < n) {
						var i = C(t, r++);
						if (i >= 55296 && i <= 56319 && r < n) {
							var o = C(t, r++);
							56320 == (64512 & o) ? A(e, ((1023 & i) << 10) + (1023 & o) + 65536) : (A(e, i), r--)
						} else A(e, i)
					}
					return e
				},
				P = function(t) {
					return t + 22 + 75 * (t < 26)
				},
				k = function(t, e, r) {
					var n = 0;
					t = r ? S(t / d) : t >> 1, t += S(t / e);
					while (t > g * c >> 1) t = S(t / g), n += a;
					return S(n + (g + 1) * t / (t + u))
				},
				D = function(t) {
					var e = [];
					t = x(t);
					var r, n, i = t.length,
						u = f,
						d = 0,
						p = l;
					for (r = 0; r < t.length; r++) n = t[r], n < 128 && A(e, w(n));
					var m = e.length,
						g = m;
					m && A(e, h);
					while (g < i) {
						var v = o;
						for (r = 0; r < t.length; r++) n = t[r], n >= u && n < v && (v = n);
						var C = g + 1;
						if (v - u > S((o - d) / C)) throw y(b);
						for (d += (v - u) * C, u = v, r = 0; r < t.length; r++) {
							if (n = t[r], n < u && ++d > o) throw y(b);
							if (n == u) {
								var I = d,
									E = a;
								while (1) {
									var T = E <= p ? s : E >= p + c ? c : E - p;
									if (I < T) break;
									var D = I - T,
										O = a - T;
									A(e, w(P(T + D % O))), I = S(D / O), E += a
								}
								A(e, w(P(I))), p = k(d, C, g == m), d = 0, g++
							}
						}
						d++, u++
					}
					return _(e, "")
				};
			t.exports = function(t) {
				var e, r, n = [],
					i = E(I(T(t), m, "."), ".");
				for (e = 0; e < i.length; e++) r = i[e], A(n, v(p, r) ? "xn--" + D(r) : r);
				return _(n, ".")
			}
		},
		"605d": function(t, e, r) {
			var n = r("c6b6"),
				i = r("da84");
			t.exports = "process" == n(i.process)
		},
		6062: function(t, e, r) {
			r("1c59")
		},
		6069: function(t, e) {
			t.exports = "object" == typeof window && "object" != typeof Deno
		},
		"60da": function(t, e, r) {
			"use strict";
			var n = r("83ab"),
				i = r("e330"),
				o = r("c65b"),
				a = r("d039"),
				s = r("df75"),
				c = r("7418"),
				u = r("d1e7"),
				d = r("7b0b"),
				l = r("44ad"),
				f = Object.assign,
				h = Object.defineProperty,
				p = i([].concat);
			t.exports = !f || a((function() {
				if (n && 1 !== f({
						b: 1
					}, f(h({}, "a", {
						enumerable: !0,
						get: function() {
							h(this, "b", {
								value: 3,
								enumerable: !1
							})
						}
					}), {
						b: 2
					}))
					.b) return !0;
				var t = {},
					e = {},
					r = Symbol(),
					i = "abcdefghijklmnopqrst";
				return t[r] = 7, i.split("")
					.forEach((function(t) {
						e[t] = t
					})), 7 != f({}, t)[r] || s(f({}, e))
					.join("") != i
			})) ? function(t, e) {
				var r = d(t),
					i = arguments.length,
					a = 1,
					f = c.f,
					h = u.f;
				while (i > a) {
					var m, b = l(arguments[a++]),
						g = f ? p(s(b), f(b)) : s(b),
						y = g.length,
						v = 0;
					while (y > v) m = g[v++], n && !o(h, b, m) || (r[m] = b[m])
				}
				return r
			} : f
		},
		"64c1": function(t, e, r) {
			var n;
			n = function() {
				"use strict";
				var t, e = {},
					r = "function" == typeof Uint8Array;
				return e.decode = function(e) {
					var n, i = "string" == typeof e;
					if (void 0 === t) {
						var o = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/",
							a = "= \f\n\r\t \u2028\u2029";
						for (t = [], n = 0; n < 64; ++n) t[o.charCodeAt(n)] = n;
						for (n = 0; n < a.length; ++n) t[a.charCodeAt(n)] = -1;
						t["-".charCodeAt(0)] = t["+".charCodeAt(0)], t["_".charCodeAt(0)] = t["/".charCodeAt(0)]
					}
					var s = r ? new Uint8Array(3 * e.length >> 2) : [],
						c = 0,
						u = 0,
						d = 0;
					for (n = 0; n < e.length; ++n) {
						var l = i ? e.charCodeAt(n) : e[n];
						if (61 == l) break;
						if (l = t[l], -1 != l) {
							if (void 0 === l) throw "Illegal character at offset " + n;
							c |= l, ++u >= 4 ? (s[d++] = c >> 16, s[d++] = c >> 8 & 255, s[d++] = 255 & c, c = 0, u = 0) : c <<= 6
						}
					}
					switch (u) {
						case 1:
							throw "Base64 encoding incomplete: at least 2 bits missing";
						case 2:
							s[d++] = c >> 10;
							break;
						case 3:
							s[d++] = c >> 16, s[d++] = c >> 8 & 255;
							break
					}
					return r && s.length > d && (s = s.subarray(0, d)), s
				}, e.pretty = function(t) {
					return t.length % 4 > 0 && (t = (t + "===")
							.slice(0, t.length + t.length % 4)), t = t.replace(/-/g, "+")
						.replace(/_/g, "/"), t.replace(/(.{80})/g, "$1\n")
				}, e.re = /-----BEGIN [^-]+-----([A-Za-z0-9+/=\s]+)-----END [^-]+-----|begin-base64[^\n]+\n([A-Za-z0-9+/=\s]+)====|^([A-Za-z0-9+/=\s]+)$/, e.unarmor = function(t) {
					var r = e.re.exec(t);
					if (r)
						if (r[1]) t = r[1];
						else if (r[2]) t = r[2];
					else {
						if (!r[3]) throw "RegExp out of sync";
						t = r[3]
					}
					return e.decode(t)
				}, e
			}.call(e, r, e, t), void 0 === n || (t.exports = n)
		},
		6547: function(t, e, r) {
			var n = r("e330"),
				i = r("5926"),
				o = r("577e"),
				a = r("1d80"),
				s = n("".charAt),
				c = n("".charCodeAt),
				u = n("".slice),
				d = function(t) {
					return function(e, r) {
						var n, d, l = o(a(e)),
							f = i(r),
							h = l.length;
						return f < 0 || f >= h ? t ? "" : void 0 : (n = c(l, f), n < 55296 || n > 56319 || f + 1 === h || (d = c(l, f + 1)) < 56320 || d > 57343 ? t ? s(l, f) : n : t ? u(l, f, f + 2) : d - 56320 + (n - 55296 << 10) + 65536)
					}
				};
			t.exports = {
				codeAt: d(!1),
				charAt: d(!0)
			}
		},
		6566: function(t, e, r) {
			"use strict";
			var n = r("9bf2")
				.f,
				i = r("7c73"),
				o = r("6964"),
				a = r("0366"),
				s = r("19aa"),
				c = r("2266"),
				u = r("7dd0"),
				d = r("2626"),
				l = r("83ab"),
				f = r("f183")
				.fastKey,
				h = r("69f3"),
				p = h.set,
				m = h.getterFor;
			t.exports = {
				getConstructor: function(t, e, r, u) {
					var d = t((function(t, n) {
							s(t, h), p(t, {
								type: e,
								index: i(null),
								first: void 0,
								last: void 0,
								size: 0
							}), l || (t.size = 0), void 0 != n && c(n, t[u], {
								that: t,
								AS_ENTRIES: r
							})
						})),
						h = d.prototype,
						b = m(e),
						g = function(t, e, r) {
							var n, i, o = b(t),
								a = y(t, e);
							return a ? a.value = r : (o.last = a = {
								index: i = f(e, !0),
								key: e,
								value: r,
								previous: n = o.last,
								next: void 0,
								removed: !1
							}, o.first || (o.first = a), n && (n.next = a), l ? o.size++ : t.size++, "F" !== i && (o.index[i] = a)), t
						},
						y = function(t, e) {
							var r, n = b(t),
								i = f(e);
							if ("F" !== i) return n.index[i];
							for (r = n.first; r; r = r.next)
								if (r.key == e) return r
						};
					return o(h, {
						clear: function() {
							var t = this,
								e = b(t),
								r = e.index,
								n = e.first;
							while (n) n.removed = !0, n.previous && (n.previous = n.previous.next = void 0), delete r[n.index], n = n.next;
							e.first = e.last = void 0, l ? e.size = 0 : t.size = 0
						},
						delete: function(t) {
							var e = this,
								r = b(e),
								n = y(e, t);
							if (n) {
								var i = n.next,
									o = n.previous;
								delete r.index[n.index], n.removed = !0, o && (o.next = i), i && (i.previous = o), r.first == n && (r.first = i), r.last == n && (r.last = o), l ? r.size-- : e.size--
							}
							return !!n
						},
						forEach: function(t) {
							var e, r = b(this),
								n = a(t, arguments.length > 1 ? arguments[1] : void 0);
							while (e = e ? e.next : r.first) {
								n(e.value, e.key, this);
								while (e && e.removed) e = e.previous
							}
						},
						has: function(t) {
							return !!y(this, t)
						}
					}), o(h, r ? {
						get: function(t) {
							var e = y(this, t);
							return e && e.value
						},
						set: function(t, e) {
							return g(this, 0 === t ? 0 : t, e)
						}
					} : {
						add: function(t) {
							return g(this, t = 0 === t ? 0 : t, t)
						}
					}), l && n(h, "size", {
						get: function() {
							return b(this)
								.size
						}
					}), d
				},
				setStrong: function(t, e, r) {
					var n = e + " Iterator",
						i = m(e),
						o = m(n);
					u(t, e, (function(t, e) {
						p(this, {
							type: n,
							target: t,
							state: i(t),
							kind: e,
							last: void 0
						})
					}), (function() {
						var t = o(this),
							e = t.kind,
							r = t.last;
						while (r && r.removed) r = r.previous;
						return t.target && (t.last = r = r ? r.next : t.state.first) ? "keys" == e ? {
							value: r.key,
							done: !1
						} : "values" == e ? {
							value: r.value,
							done: !1
						} : {
							value: [r.key, r.value],
							done: !1
						} : (t.target = void 0, {
							value: void 0,
							done: !0
						})
					}), r ? "entries" : "values", !r, !0), d(e)
				}
			}
		},
		"65f0": function(t, e, r) {
			var n = r("0b42");
			t.exports = function(t, e) {
				return new(n(t))(0 === e ? 0 : e)
			}
		},
        "67d3": function(t, e, r) {
            "use strict";
            (function(t) {
                r.d(e, "d", (function() {
                    return C
                }
                )),
                r.d(e, "b", (function() {
                    return _
                }
                )),
                r.d(e, "c", (function() {
                    return A
                }
                ));
                var n = r("3662")
                  , i = r("c4e3")
                  , o = r.n(i)
                  , a = r("6b33")
                  , s = r("73fd")
                  , c = r("a9c6");
                function u(t) {
                    return u = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t) {
                        return typeof t
                    }
                    : function(t) {
                        return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
                    }
                    ,
                    u(t)
                }
                function d(t, e, r) {
                    return e in t ? Object.defineProperty(t, e, {
                        value: r,
                        enumerable: !0,
                        configurable: !0,
                        writable: !0
                    }) : t[e] = r,
                    t
                }
                function l(t, e) {
                    var r = "undefined" !== typeof Symbol && t[Symbol.iterator] || t["@@iterator"];
                    if (!r) {
                        if (Array.isArray(t) || (r = p(t)) || e && t && "number" === typeof t.length) {
                            r && (t = r);
                            var n = 0
                              , i = function() {};
                            return {
                                s: i,
                                n: function() {
                                    return n >= t.length ? {
                                        done: !0
                                    } : {
                                        done: !1,
                                        value: t[n++]
                                    }
                                },
                                e: function(t) {
                                    throw t
                                },
                                f: i
                            }
                        }
                        throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                    }
                    var o, a = !0, s = !1;
                    return {
                        s: function() {
                            r = r.call(t)
                        },
                        n: function() {
                            var t = r.next();
                            return a = t.done,
                            t
                        },
                        e: function(t) {
                            s = !0,
                            o = t
                        },
                        f: function() {
                            try {
                                a || null == r.return || r.return()
                            } finally {
                                if (s)
                                    throw o
                            }
                        }
                    }
                }
                function f(t, e) {
                    return g(t) || b(t, e) || p(t, e) || h()
                }
                function h() {
                    throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
                }
                function p(t, e) {
                    if (t) {
                        if ("string" === typeof t)
                            return m(t, e);
                        var r = Object.prototype.toString.call(t).slice(8, -1);
                        return "Object" === r && t.constructor && (r = t.constructor.name),
                        "Map" === r || "Set" === r ? Array.from(t) : "Arguments" === r || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r) ? m(t, e) : void 0
                    }
                }
                function m(t, e) {
                    (null == e || e > t.length) && (e = t.length);
                    for (var r = 0, n = new Array(e); r < e; r++)
                        n[r] = t[r];
                    return n
                }
                function b(t, e) {
                    var r = null == t ? null : "undefined" !== typeof Symbol && t[Symbol.iterator] || t["@@iterator"];
                    if (null != r) {
                        var n, i, o = [], a = !0, s = !1;
                        try {
                            for (r = r.call(t); !(a = (n = r.next()).done); a = !0)
                                if (o.push(n.value),
                                e && o.length === e)
                                    break
                        } catch (c) {
                            s = !0,
                            i = c
                        } finally {
                            try {
                                a || null == r["return"] || r["return"]()
                            } finally {
                                if (s)
                                    throw i
                            }
                        }
                        return o
                    }
                }
                function g(t) {
                    if (Array.isArray(t))
                        return t
                }
                function y() {
                    /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */
                    y = function() {
                        return t
                    }
                    ;
                    var t = {}
                      , e = Object.prototype
                      , r = e.hasOwnProperty
                      , n = "function" == typeof Symbol ? Symbol : {}
                      , i = n.iterator || "@@iterator"
                      , o = n.asyncIterator || "@@asyncIterator"
                      , a = n.toStringTag || "@@toStringTag";
                    function s(t, e, r) {
                        return Object.defineProperty(t, e, {
                            value: r,
                            enumerable: !0,
                            configurable: !0,
                            writable: !0
                        }),
                        t[e]
                    }
                    try {
                        s({}, "")
                    } catch (x) {
                        s = function(t, e, r) {
                            return t[e] = r
                        }
                    }
                    function c(t, e, r, n) {
                        var i = e && e.prototype instanceof f ? e : f
                          , o = Object.create(i.prototype)
                          , a = new I(n || []);
                        return o._invoke = function(t, e, r) {
                            var n = "suspendedStart";
                            return function(i, o) {
                                if ("executing" === n)
                                    throw new Error("Generator is already running");
                                if ("completed" === n) {
                                    if ("throw" === i)
                                        throw o;
                                    return T()
                                }
                                for (r.method = i,
                                r.arg = o; ; ) {
                                    var a = r.delegate;
                                    if (a) {
                                        var s = C(a, r);
                                        if (s) {
                                            if (s === l)
                                                continue;
                                            return s
                                        }
                                    }
                                    if ("next" === r.method)
                                        r.sent = r._sent = r.arg;
                                    else if ("throw" === r.method) {
                                        if ("suspendedStart" === n)
                                            throw n = "completed",
                                            r.arg;
                                        r.dispatchException(r.arg)
                                    } else
                                        "return" === r.method && r.abrupt("return", r.arg);
                                    n = "executing";
                                    var c = d(t, e, r);
                                    if ("normal" === c.type) {
                                        if (n = r.done ? "completed" : "suspendedYield",
                                        c.arg === l)
                                            continue;
                                        return {
                                            value: c.arg,
                                            done: r.done
                                        }
                                    }
                                    "throw" === c.type && (n = "completed",
                                    r.method = "throw",
                                    r.arg = c.arg)
                                }
                            }
                        }(t, r, a),
                        o
                    }
                    function d(t, e, r) {
                        try {
                            return {
                                type: "normal",
                                arg: t.call(e, r)
                            }
                        } catch (x) {
                            return {
                                type: "throw",
                                arg: x
                            }
                        }
                    }
                    t.wrap = c;
                    var l = {};
                    function f() {}
                    function h() {}
                    function p() {}
                    var m = {};
                    s(m, i, (function() {
                        return this
                    }
                    ));
                    var b = Object.getPrototypeOf
                      , g = b && b(b(E([])));
                    g && g !== e && r.call(g, i) && (m = g);
                    var v = p.prototype = f.prototype = Object.create(m);
                    function S(t) {
                        ["next", "throw", "return"].forEach((function(e) {
                            s(t, e, (function(t) {
                                return this._invoke(e, t)
                            }
                            ))
                        }
                        ))
                    }
                    function w(t, e) {
                        function n(i, o, a, s) {
                            var c = d(t[i], t, o);
                            if ("throw" !== c.type) {
                                var l = c.arg
                                  , f = l.value;
                                return f && "object" == u(f) && r.call(f, "__await") ? e.resolve(f.__await).then((function(t) {
                                    n("next", t, a, s)
                                }
                                ), (function(t) {
                                    n("throw", t, a, s)
                                }
                                )) : e.resolve(f).then((function(t) {
                                    l.value = t,
                                    a(l)
                                }
                                ), (function(t) {
                                    return n("throw", t, a, s)
                                }
                                ))
                            }
                            s(c.arg)
                        }
                        var i;
                        this._invoke = function(t, r) {
                            function o() {
                                return new e((function(e, i) {
                                    n(t, r, e, i)
                                }
                                ))
                            }
                            return i = i ? i.then(o, o) : o()
                        }
                    }
                    function C(t, e) {
                        var r = t.iterator[e.method];
                        if (void 0 === r) {
                            if (e.delegate = null,
                            "throw" === e.method) {
                                if (t.iterator.return && (e.method = "return",
                                e.arg = void 0,
                                C(t, e),
                                "throw" === e.method))
                                    return l;
                                e.method = "throw",
                                e.arg = new TypeError("The iterator does not provide a 'throw' method")
                            }
                            return l
                        }
                        var n = d(r, t.iterator, e.arg);
                        if ("throw" === n.type)
                            return e.method = "throw",
                            e.arg = n.arg,
                            e.delegate = null,
                            l;
                        var i = n.arg;
                        return i ? i.done ? (e[t.resultName] = i.value,
                        e.next = t.nextLoc,
                        "return" !== e.method && (e.method = "next",
                        e.arg = void 0),
                        e.delegate = null,
                        l) : i : (e.method = "throw",
                        e.arg = new TypeError("iterator result is not an object"),
                        e.delegate = null,
                        l)
                    }
                    function _(t) {
                        var e = {
                            tryLoc: t[0]
                        };
                        1 in t && (e.catchLoc = t[1]),
                        2 in t && (e.finallyLoc = t[2],
                        e.afterLoc = t[3]),
                        this.tryEntries.push(e)
                    }
                    function A(t) {
                        var e = t.completion || {};
                        e.type = "normal",
                        delete e.arg,
                        t.completion = e
                    }
                    function I(t) {
                        this.tryEntries = [{
                            tryLoc: "root"
                        }],
                        t.forEach(_, this),
                        this.reset(!0)
                    }
                    function E(t) {
                        if (t) {
                            var e = t[i];
                            if (e)
                                return e.call(t);
                            if ("function" == typeof t.next)
                                return t;
                            if (!isNaN(t.length)) {
                                var n = -1
                                  , o = function e() {
                                    for (; ++n < t.length; )
                                        if (r.call(t, n))
                                            return e.value = t[n],
                                            e.done = !1,
                                            e;
                                    return e.value = void 0,
                                    e.done = !0,
                                    e
                                };
                                return o.next = o
                            }
                        }
                        return {
                            next: T
                        }
                    }
                    function T() {
                        return {
                            value: void 0,
                            done: !0
                        }
                    }
                    return h.prototype = p,
                    s(v, "constructor", p),
                    s(p, "constructor", h),
                    h.displayName = s(p, a, "GeneratorFunction"),
                    t.isGeneratorFunction = function(t) {
                        var e = "function" == typeof t && t.constructor;
                        return !!e && (e === h || "GeneratorFunction" === (e.displayName || e.name))
                    }
                    ,
                    t.mark = function(t) {
                        return Object.setPrototypeOf ? Object.setPrototypeOf(t, p) : (t.__proto__ = p,
                        s(t, a, "GeneratorFunction")),
                        t.prototype = Object.create(v),
                        t
                    }
                    ,
                    t.awrap = function(t) {
                        return {
                            __await: t
                        }
                    }
                    ,
                    S(w.prototype),
                    s(w.prototype, o, (function() {
                        return this
                    }
                    )),
                    t.AsyncIterator = w,
                    t.async = function(e, r, n, i, o) {
                        void 0 === o && (o = Promise);
                        var a = new w(c(e, r, n, i),o);
                        return t.isGeneratorFunction(r) ? a : a.next().then((function(t) {
                            return t.done ? t.value : a.next()
                        }
                        ))
                    }
                    ,
                    S(v),
                    s(v, a, "Generator"),
                    s(v, i, (function() {
                        return this
                    }
                    )),
                    s(v, "toString", (function() {
                        return "[object Generator]"
                    }
                    )),
                    t.keys = function(t) {
                        var e = [];
                        for (var r in t)
                            e.push(r);
                        return e.reverse(),
                        function r() {
                            for (; e.length; ) {
                                var n = e.pop();
                                if (n in t)
                                    return r.value = n,
                                    r.done = !1,
                                    r
                            }
                            return r.done = !0,
                            r
                        }
                    }
                    ,
                    t.values = E,
                    I.prototype = {
                        constructor: I,
                        reset: function(t) {
                            if (this.prev = 0,
                            this.next = 0,
                            this.sent = this._sent = void 0,
                            this.done = !1,
                            this.delegate = null,
                            this.method = "next",
                            this.arg = void 0,
                            this.tryEntries.forEach(A),
                            !t)
                                for (var e in this)
                                    "t" === e.charAt(0) && r.call(this, e) && !isNaN(+e.slice(1)) && (this[e] = void 0)
                        },
                        stop: function() {
                            this.done = !0;
                            var t = this.tryEntries[0].completion;
                            if ("throw" === t.type)
                                throw t.arg;
                            return this.rval
                        },
                        dispatchException: function(t) {
                            if (this.done)
                                throw t;
                            var e = this;
                            function n(r, n) {
                                return a.type = "throw",
                                a.arg = t,
                                e.next = r,
                                n && (e.method = "next",
                                e.arg = void 0),
                                !!n
                            }
                            for (var i = this.tryEntries.length - 1; i >= 0; --i) {
                                var o = this.tryEntries[i]
                                  , a = o.completion;
                                if ("root" === o.tryLoc)
                                    return n("end");
                                if (o.tryLoc <= this.prev) {
                                    var s = r.call(o, "catchLoc")
                                      , c = r.call(o, "finallyLoc");
                                    if (s && c) {
                                        if (this.prev < o.catchLoc)
                                            return n(o.catchLoc, !0);
                                        if (this.prev < o.finallyLoc)
                                            return n(o.finallyLoc)
                                    } else if (s) {
                                        if (this.prev < o.catchLoc)
                                            return n(o.catchLoc, !0)
                                    } else {
                                        if (!c)
                                            throw new Error("try statement without catch or finally");
                                        if (this.prev < o.finallyLoc)
                                            return n(o.finallyLoc)
                                    }
                                }
                            }
                        },
                        abrupt: function(t, e) {
                            for (var n = this.tryEntries.length - 1; n >= 0; --n) {
                                var i = this.tryEntries[n];
                                if (i.tryLoc <= this.prev && r.call(i, "finallyLoc") && this.prev < i.finallyLoc) {
                                    var o = i;
                                    break
                                }
                            }
                            o && ("break" === t || "continue" === t) && o.tryLoc <= e && e <= o.finallyLoc && (o = null);
                            var a = o ? o.completion : {};
                            return a.type = t,
                            a.arg = e,
                            o ? (this.method = "next",
                            this.next = o.finallyLoc,
                            l) : this.complete(a)
                        },
                        complete: function(t, e) {
                            if ("throw" === t.type)
                                throw t.arg;
                            return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg,
                            this.method = "return",
                            this.next = "end") : "normal" === t.type && e && (this.next = e),
                            l
                        },
                        finish: function(t) {
                            for (var e = this.tryEntries.length - 1; e >= 0; --e) {
                                var r = this.tryEntries[e];
                                if (r.finallyLoc === t)
                                    return this.complete(r.completion, r.afterLoc),
                                    A(r),
                                    l
                            }
                        },
                        catch: function(t) {
                            for (var e = this.tryEntries.length - 1; e >= 0; --e) {
                                var r = this.tryEntries[e];
                                if (r.tryLoc === t) {
                                    var n = r.completion;
                                    if ("throw" === n.type) {
                                        var i = n.arg;
                                        A(r)
                                    }
                                    return i
                                }
                            }
                            throw new Error("illegal catch attempt")
                        },
                        delegateYield: function(t, e, r) {
                            return this.delegate = {
                                iterator: E(t),
                                resultName: e,
                                nextLoc: r
                            },
                            "next" === this.method && (this.arg = void 0),
                            l
                        }
                    },
                    t
                }
                function v(t, e, r, n, i, o, a) {
                    try {
                        var s = t[o](a)
                          , c = s.value
                    } catch (u) {
                        return void r(u)
                    }
                    s.done ? e(c) : Promise.resolve(c).then(n, i)
                }
                function S(t) {
                    return function() {
                        var e = this
                          , r = arguments;
                        return new Promise((function(n, i) {
                            var o = t.apply(e, r);
                            function a(t) {
                                v(o, n, i, a, s, "next", t)
                            }
                            function s(t) {
                                v(o, n, i, a, s, "throw", t)
                            }
                            a(void 0)
                        }
                        ))
                    }
                }
                var w = r("74db")
                  , C = function(t) {
                    return new Promise((function(e, r) {
                        o.a.loadAsync(t).then((function(t) {
                            e(t)
                        }
                        ), (function(t) {
                            r(t)
                        }
                        ))
                    }
                    ))
                }
                  , _ = function() {
                    var t = S(y().mark((function t(e) {
                        var r, n, i;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    return t.next = 2,
                                    U(e, "OFD.xml");
                                case 2:
                                    return r = t.sent,
                                    n = r["json"]["ofd:OFD"]["ofd:DocBody"],
                                    i = [],
                                    i = i.concat(n),
                                    t.abrupt("return", [e, i]);
                                case 7:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t)
                    }
                    )));
                    return function(e) {
                        return t.apply(this, arguments)
                    }
                }()
                  , A = function() {
                    var t = S(y().mark((function t(e) {
                        var r, n, i, o, a, s, c, u;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    r = f(e, 2),
                                    n = r[0],
                                    i = r[1],
                                    o = [],
                                    a = l(i),
                                    t.prev = 3,
                                    a.s();
                                case 5:
                                    if ((s = a.n()).done) {
                                        t.next = 30;
                                        break
                                    }
                                    if (c = s.value,
                                    !c) {
                                        t.next = 28;
                                        break
                                    }
                                    return t.next = 10,
                                    I(n, c);
                                case 10:
                                    return u = t.sent,
                                    t.next = 13,
                                    E(u);
                                case 13:
                                    return u = t.sent,
                                    t.next = 16,
                                    x(u);
                                case 16:
                                    return u = t.sent,
                                    t.next = 19,
                                    P(u);
                                case 19:
                                    return u = t.sent,
                                    t.next = 22,
                                    k(u);
                                case 22:
                                    return u = t.sent,
                                    t.next = 25,
                                    D(u);
                                case 25:
                                    u = t.sent,
                                    u.docInfo = c["ofd:DocInfo"],
                                    o.push(u);
                                case 28:
                                    t.next = 5;
                                    break;
                                case 30:
                                    t.next = 35;
                                    break;
                                case 32:
                                    t.prev = 32,
                                    t.t0 = t["catch"](3),
                                    a.e(t.t0);
                                case 35:
                                    return t.prev = 35,
                                    a.f(),
                                    t.finish(35);
                                case 38:
                                    return t.abrupt("return", o);
                                case 39:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t, null, [[3, 32, 35, 38]])
                    }
                    )));
                    return function(e) {
                        return t.apply(this, arguments)
                    }
                }()
                  , I = function() {
                    var t = S(y().mark((function t(e, r) {
                        var n, i, o, s, c, u, d, f, h, p, m, b, g, v, w, C, _, A, I, E, T, x, P, k, D, O, R;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    return n = r["ofd:DocRoot"],
                                    n = Object(a["l"])(n),
                                    i = n.split("/")[0],
                                    o = r["ofd:Signatures"],
                                    t.next = 6,
                                    F(e, o, i);
                                case 6:
                                    s = t.sent,
                                    c = {},
                                    u = l(s),
                                    t.prev = 9,
                                    u.s();
                                case 11:
                                    if ((d = u.n()).done) {
                                        t.next = 57;
                                        break
                                    }
                                    if (f = d.value,
                                    !(f.sealObj && Object.keys(f.sealObj).length > 0)) {
                                        t.next = 55;
                                        break
                                    }
                                    if ("ofd" !== f.sealObj.type) {
                                        t.next = 22;
                                        break
                                    }
                                    return t.next = 17,
                                    L(f);
                                case 17:
                                    h = t.sent,
                                    p = l(h);
                                    try {
                                        for (p.s(); !(m = p.n()).done; )
                                            b = m.value,
                                            f.stampAnnot.boundary = Object(a["k"])(f.stampAnnot["@_Boundary"]),
                                            f.stampAnnot.pageRef = f.stampAnnot["@_PageRef"],
                                            c[f.stampAnnot["@_PageRef"]] || (c[f.stampAnnot["@_PageRef"]] = []),
                                            c[f.stampAnnot["@_PageRef"]].push({
                                                type: "ofd",
                                                obj: b,
                                                stamp: f
                                            })
                                    } catch (N) {
                                        p.e(N)
                                    } finally {
                                        p.f()
                                    }
                                    t.next = 55;
                                    break;
                                case 22:
                                    if ("png" !== f.sealObj.type && "gif" !== f.sealObj.type && "jpg" !== f.sealObj.type && "jpeg" !== f.sealObj.type && 0 != f.sealObj.type.indexOf("png") && "bmp" !== f.sealObj.type) {
                                        t.next = 54;
                                        break
                                    }
                                    if (g = function() {
                                        var t = S(y().mark((function t(e) {
                                            var r, n;
                                            return y().wrap((function(t) {
                                                while (1)
                                                    switch (t.prev = t.next) {
                                                    case 0:
                                                        return r = Object.assign(new Image, {
                                                            src: e
                                                        }),
                                                        t.next = 3,
                                                        new Promise((function(t) {
                                                            return r.addEventListener("load", (function() {
                                                                return t()
                                                            }
                                                            ))
                                                        }
                                                        ));
                                                    case 3:
                                                        return n = Object.assign(document.createElement("canvas"), {
                                                            width: r.width,
                                                            height: r.height
                                                        }).getContext("2d"),
                                                        n.imageSmoothingEnabled = !1,
                                                        n.drawImage(r, 0, 0),
                                                        t.abrupt("return", n.getImageData(0, 0, r.width, r.height));
                                                    case 7:
                                                    case "end":
                                                        return t.stop()
                                                    }
                                            }
                                            ), t)
                                        }
                                        )));
                                        return function(e) {
                                            return t.apply(this, arguments)
                                        }
                                    }(),
                                    v = void 0,
                                    "bmp" !== f.sealObj.type) {
                                        t.next = 38;
                                        break
                                    }
                                    return t.next = 28,
                                    g("data:image/bmp;base64," + Object(a["o"])(f.sealObj.ofdArray));
                                case 28:
                                    for (w = t.sent,
                                    C = document.createElement("canvas"),
                                    C.width = w.width,
                                    C.height = w.height,
                                    _ = C.getContext("2d"),
                                    A = 0; A < w.data.length / 4; A++)
                                        w.data[4 * A] > 250 && w.data[4 * A + 1] > 250 && w.data[4 * A + 2] > 250 && (w.data[4 * A + 3] = 0);
                                    _.putImageData(w, 0, 0),
                                    v = C.toDataURL("image/png", 1),
                                    t.next = 48;
                                    break;
                                case 38:
                                    return t.next = 40,
                                    g("data:image/png;base64," + Object(a["o"])(f.sealObj.ofdArray));
                                case 40:
                                    for (I = t.sent,
                                    E = document.createElement("canvas"),
                                    E.width = I.width,
                                    E.height = I.height,
                                    T = E.getContext("2d"),
                                    x = !1,
                                    A = 0; A < I.data.length / 4; A++)
                                        I.data[4 * A] > 250 && I.data[4 * A + 1] > 250 && I.data[4 * A + 2] > 250 && (I.data[4 * A + 3] = 0,
                                        x = !0);
                                    x ? (T.putImageData(I, 0, 0),
                                    v = E.toDataURL("image/png", 1)) : v = "data:image/png;base64," + Object(a["o"])(f.sealObj.ofdArray);
                                case 48:
                                    P = [],
                                    P = P.concat(f.stampAnnot),
                                    k = l(P);
                                    try {
                                        for (k.s(); !(D = k.n()).done; )
                                            O = D.value,
                                            O && (R = {
                                                img: v,
                                                pageId: O["@_PageRef"],
                                                boundary: Object(a["k"])(O["@_Boundary"]),
                                                clip: Object(a["k"])(O["@_Clip"])
                                            },
                                            c[O["@_PageRef"]] || (c[O["@_PageRef"]] = []),
                                            c[O["@_PageRef"]].push({
                                                type: "png",
                                                obj: R,
                                                stamp: f
                                            }))
                                    } catch (N) {
                                        k.e(N)
                                    } finally {
                                        k.f()
                                    }
                                    t.next = 55;
                                    break;
                                case 54:
                                    console.log(f.sealObj.type);
                                case 55:
                                    t.next = 11;
                                    break;
                                case 57:
                                    t.next = 62;
                                    break;
                                case 59:
                                    t.prev = 59,
                                    t.t0 = t["catch"](9),
                                    u.e(t.t0);
                                case 62:
                                    return t.prev = 62,
                                    u.f(),
                                    t.finish(62);
                                case 65:
                                    return t.abrupt("return", [e, i, n, c]);
                                case 66:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t, null, [[9, 59, 62, 65]])
                    }
                    )));
                    return function(e, r) {
                        return t.apply(this, arguments)
                    }
                }()
                  , E = function() {
                    var t = S(y().mark((function t(e) {
                        var r, n, i, o, a, s, c, u, d, l, h;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    return r = f(e, 4),
                                    n = r[0],
                                    i = r[1],
                                    o = r[2],
                                    a = r[3],
                                    t.next = 3,
                                    U(n, o);
                                case 3:
                                    if (s = t.sent,
                                    c = s["json"]["ofd:Document"],
                                    u = c["ofd:Annotations"],
                                    d = [],
                                    !u) {
                                        t.next = 16;
                                        break
                                    }
                                    if (-1 !== u.indexOf("/") && (l = u.substring(0, u.indexOf("/"))),
                                    -1 === u.indexOf(i) && (u = "".concat(i, "/").concat(u)),
                                    0 === u.indexOf("/") && (u = u.substring(1)),
                                    !n.files[u]) {
                                        t.next = 16;
                                        break
                                    }
                                    return t.next = 14,
                                    U(n, u);
                                case 14:
                                    u = t.sent,
                                    d = d.concat(u["json"]["ofd:Annotations"]["ofd:Page"]);
                                case 16:
                                    return t.next = 18,
                                    T(l, d, i, n);
                                case 18:
                                    return h = t.sent,
                                    t.abrupt("return", [n, i, c, a, h]);
                                case 20:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t)
                    }
                    )));
                    return function(e) {
                        return t.apply(this, arguments)
                    }
                }()
                  , T = function() {
                    var t = S(y().mark((function t(e, r, n, i) {
                        var o, s, c, u, d, f, h, p, m, b, g, v, S, w, C;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    o = {},
                                    s = l(r),
                                    t.prev = 2,
                                    s.s();
                                case 4:
                                    if ((c = s.n()).done) {
                                        t.next = 44;
                                        break
                                    }
                                    if (u = c.value,
                                    u) {
                                        t.next = 8;
                                        break
                                    }
                                    return t.abrupt("continue", 42);
                                case 8:
                                    if (d = u["@_PageID"],
                                    f = u["ofd:FileLoc"],
                                    f = Object(a["l"])(f),
                                    e && -1 === f.indexOf(e) && (f = "".concat(e, "/").concat(f)),
                                    -1 === f.indexOf(n) && (f = "".concat(n, "/").concat(f)),
                                    !i.files[f]) {
                                        t.next = 42;
                                        break
                                    }
                                    return t.next = 16,
                                    U(i, f);
                                case 16:
                                    h = t.sent,
                                    p = [],
                                    p = p.concat(h["json"]["ofd:PageAnnot"]["ofd:Annot"]),
                                    o[d] || (o[d] = []),
                                    m = l(p),
                                    t.prev = 21,
                                    m.s();
                                case 23:
                                    if ((b = m.n()).done) {
                                        t.next = 34;
                                        break
                                    }
                                    if (g = b.value,
                                    g) {
                                        t.next = 27;
                                        break
                                    }
                                    return t.abrupt("continue", 32);
                                case 27:
                                    v = g["@_Type"],
                                    S = !g["@_Visible"] || g["@_Visible"],
                                    w = g["ofd:Appearance"],
                                    C = {
                                        type: v,
                                        appearance: w,
                                        visible: S
                                    },
                                    o[d].push(C);
                                case 32:
                                    t.next = 23;
                                    break;
                                case 34:
                                    t.next = 39;
                                    break;
                                case 36:
                                    t.prev = 36,
                                    t.t0 = t["catch"](21),
                                    m.e(t.t0);
                                case 39:
                                    return t.prev = 39,
                                    m.f(),
                                    t.finish(39);
                                case 42:
                                    t.next = 4;
                                    break;
                                case 44:
                                    t.next = 49;
                                    break;
                                case 46:
                                    t.prev = 46,
                                    t.t1 = t["catch"](2),
                                    s.e(t.t1);
                                case 49:
                                    return t.prev = 49,
                                    s.f(),
                                    t.finish(49);
                                case 52:
                                    return t.abrupt("return", o);
                                case 53:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t, null, [[2, 46, 49, 52], [21, 36, 39, 42]])
                    }
                    )));
                    return function(e, r, n, i) {
                        return t.apply(this, arguments)
                    }
                }()
                  , x = function() {
                    var t = S(y().mark((function t(e) {
                        var r, n, i, o, a, s, c, u, d, l, h, p, m;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    if (r = f(e, 5),
                                    n = r[0],
                                    i = r[1],
                                    o = r[2],
                                    a = r[3],
                                    s = r[4],
                                    c = o["ofd:CommonData"]["ofd:DocumentRes"],
                                    u = {},
                                    d = {},
                                    l = {},
                                    h = [],
                                    !c) {
                                        t.next = 23;
                                        break
                                    }
                                    if (-1 == c.indexOf(i) && (c = "".concat(i, "/").concat(c)),
                                    !n.files[c]) {
                                        t.next = 23;
                                        break
                                    }
                                    return t.next = 11,
                                    U(n, c);
                                case 11:
                                    return p = t.sent,
                                    m = p["json"]["ofd:Res"],
                                    t.next = 15,
                                    O(m, n, i);
                                case 15:
                                    return u = t.sent,
                                    t.next = 18,
                                    R(m);
                                case 18:
                                    return d = t.sent,
                                    t.next = 21,
                                    N(n, m, i);
                                case 21:
                                    l = t.sent,
                                    h = M(m);
                                case 23:
                                    return t.abrupt("return", [n, i, o, a, s, u, d, l, h]);
                                case 24:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t)
                    }
                    )));
                    return function(e) {
                        return t.apply(this, arguments)
                    }
                }()
                  , P = function() {
                    var t = S(y().mark((function t(e) {
                        var r, n, i, o, a, s, c, u, d, h, p, m, b, g, v, S, w, C, _, A, I, E, T;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    if (r = f(e, 9),
                                    n = r[0],
                                    i = r[1],
                                    o = r[2],
                                    a = r[3],
                                    s = r[4],
                                    c = r[5],
                                    u = r[6],
                                    d = r[7],
                                    h = r[8],
                                    p = o["ofd:CommonData"]["ofd:PublicRes"],
                                    !p) {
                                        t.next = 30;
                                        break
                                    }
                                    if (m = [],
                                    p instanceof Array) {
                                        b = l(p);
                                        try {
                                            for (b.s(); !(g = b.n()).done; )
                                                v = g.value,
                                                v && m.push(v)
                                        } catch (y) {
                                            b.e(y)
                                        } finally {
                                            b.f()
                                        }
                                    } else
                                        m.push(p);
                                    S = 0,
                                    w = m;
                                case 6:
                                    if (!(S < w.length)) {
                                        t.next = 30;
                                        break
                                    }
                                    if (C = w[S],
                                    -1 == C.indexOf(i) && (C = "".concat(i, "/").concat(C)),
                                    !n.files[C]) {
                                        t.next = 27;
                                        break
                                    }
                                    return t.next = 12,
                                    U(n, C);
                                case 12:
                                    return _ = t.sent,
                                    A = _["json"]["ofd:Res"],
                                    t.next = 16,
                                    O(A, n, i);
                                case 16:
                                    return I = t.sent,
                                    c = Object.assign(c, I),
                                    t.next = 20,
                                    R(A);
                                case 20:
                                    return E = t.sent,
                                    u = Object.assign(u, E),
                                    t.next = 24,
                                    N(n, A, i);
                                case 24:
                                    T = t.sent,
                                    d = Object.assign(d, T),
                                    h = h.concat(M(A));
                                case 27:
                                    S++,
                                    t.next = 6;
                                    break;
                                case 30:
                                    return t.abrupt("return", [n, i, o, a, s, c, u, d, h]);
                                case 31:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t)
                    }
                    )));
                    return function(e) {
                        return t.apply(this, arguments)
                    }
                }()
                  , k = function() {
                    var t = S(y().mark((function t(e) {
                        var r, n, i, o, a, s, c, u, d, h, p, m, b, g, v, S, w;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    r = f(e, 9),
                                    n = r[0],
                                    i = r[1],
                                    o = r[2],
                                    a = r[3],
                                    s = r[4],
                                    c = r[5],
                                    u = r[6],
                                    d = r[7],
                                    h = r[8],
                                    p = o["ofd:CommonData"]["ofd:TemplatePage"],
                                    m = [],
                                    m = m.concat(p),
                                    b = {},
                                    g = l(m),
                                    t.prev = 6,
                                    g.s();
                                case 8:
                                    if ((v = g.n()).done) {
                                        t.next = 17;
                                        break
                                    }
                                    if (S = v.value,
                                    !S) {
                                        t.next = 15;
                                        break
                                    }
                                    return t.next = 13,
                                    B(n, S, i);
                                case 13:
                                    w = t.sent,
                                    w && (b[Object.keys(w)[0]] = w[Object.keys(w)[0]]);
                                case 15:
                                    t.next = 8;
                                    break;
                                case 17:
                                    t.next = 22;
                                    break;
                                case 19:
                                    t.prev = 19,
                                    t.t0 = t["catch"](6),
                                    g.e(t.t0);
                                case 22:
                                    return t.prev = 22,
                                    g.f(),
                                    t.finish(22);
                                case 25:
                                    return t.abrupt("return", [n, i, o, a, s, b, c, u, d, h]);
                                case 26:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t, null, [[6, 19, 22, 25]])
                    }
                    )));
                    return function(e) {
                        return t.apply(this, arguments)
                    }
                }()
                  , D = function() {
                    var t = S(y().mark((function t(e) {
                        var r, n, i, o, a, s, c, u, d, h, p, m, b, g, v, S, w, C, _, A, I;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    r = f(e, 10),
                                    n = r[0],
                                    i = r[1],
                                    o = r[2],
                                    a = r[3],
                                    s = r[4],
                                    c = r[5],
                                    u = r[6],
                                    d = r[7],
                                    h = r[8],
                                    p = r[9],
                                    m = o["ofd:Pages"]["ofd:Page"],
                                    b = [],
                                    b = b.concat(m),
                                    g = [],
                                    v = l(b),
                                    t.prev = 6,
                                    v.s();
                                case 8:
                                    if ((S = v.n()).done) {
                                        t.next = 17;
                                        break
                                    }
                                    if (w = S.value,
                                    !w) {
                                        t.next = 15;
                                        break
                                    }
                                    return t.next = 13,
                                    B(n, w, i);
                                case 13:
                                    C = t.sent,
                                    C && (_ = Object.keys(C)[0],
                                    A = a[_],
                                    A && (C[_].stamp = A),
                                    I = s[_],
                                    I && (C[_].annotation = I),
                                    g.push(C));
                                case 15:
                                    t.next = 8;
                                    break;
                                case 17:
                                    t.next = 22;
                                    break;
                                case 19:
                                    t.prev = 19,
                                    t.t0 = t["catch"](6),
                                    v.e(t.t0);
                                case 22:
                                    return t.prev = 22,
                                    v.f(),
                                    t.finish(22);
                                case 25:
                                    return t.abrupt("return", {
                                        doc: i,
                                        document: o,
                                        pages: g,
                                        tpls: c,
                                        stampAnnot: a,
                                        fontResObj: u,
                                        drawParamResObj: d,
                                        multiMediaResObj: h,
                                        compositeGraphicUnits: p
                                    });
                                case 26:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t, null, [[6, 19, 22, 25]])
                    }
                    )));
                    return function(e) {
                        return t.apply(this, arguments)
                    }
                }()
                  , O = function() {
                    var t = S(y().mark((function t(e, r, n) {
                        var i, o, a, s, c, u, d, f, h, p, m, b, g, v;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    if (i = e["ofd:Fonts"],
                                    o = {},
                                    !i) {
                                        t.next = 31;
                                        break
                                    }
                                    if (a = [],
                                    i instanceof Array) {
                                        s = l(i);
                                        try {
                                            for (s.s(); !(c = s.n()).done; )
                                                if (u = c.value,
                                                u)
                                                    if (u["ofd:Font"]instanceof Array) {
                                                        d = l(u["ofd:Font"]);
                                                        try {
                                                            for (d.s(); !(f = d.n()).done; )
                                                                h = f.value,
                                                                a.push(h)
                                                        } catch (y) {
                                                            d.e(y)
                                                        } finally {
                                                            d.f()
                                                        }
                                                    } else
                                                        a.push(u["ofd:Font"])
                                        } catch (y) {
                                            s.e(y)
                                        } finally {
                                            s.f()
                                        }
                                    } else
                                        a = a.concat(i["ofd:Font"]);
                                    p = l(a),
                                    t.prev = 6,
                                    p.s();
                                case 8:
                                    if ((m = p.n()).done) {
                                        t.next = 23;
                                        break
                                    }
                                    if (b = m.value,
                                    !b) {
                                        t.next = 21;
                                        break
                                    }
                                    if (g = null,
                                    !b["ofd:FontFile"]) {
                                        t.next = 20;
                                        break
                                    }
                                    return v = b["ofd:FontFile"],
                                    e["@_BaseLoc"] && -1 === v.indexOf(e["@_BaseLoc"]) && (v = "".concat(e["@_BaseLoc"], "/").concat(v)),
                                    -1 === v.indexOf(n) && (v = "".concat(n, "/").concat(v)),
                                    0 === v.indexOf("/") && (v = v.substring(1)),
                                    t.next = 19,
                                    q(r, v);
                                case 19:
                                    g = t.sent;
                                case 20:
                                    o[b["@_ID"]] = {
                                        familyName: b["@_FamilyName"],
                                        fontName: b["@_FontName"],
                                        fontByte: g
                                    };
                                case 21:
                                    t.next = 8;
                                    break;
                                case 23:
                                    t.next = 28;
                                    break;
                                case 25:
                                    t.prev = 25,
                                    t.t0 = t["catch"](6),
                                    p.e(t.t0);
                                case 28:
                                    return t.prev = 28,
                                    p.f(),
                                    t.finish(28);
                                case 31:
                                    return t.abrupt("return", o);
                                case 32:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t, null, [[6, 25, 28, 31]])
                    }
                    )));
                    return function(e, r, n) {
                        return t.apply(this, arguments)
                    }
                }()
                  , R = function() {
                    var t = S(y().mark((function t(e) {
                        var r, n, i, o, a, s;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    if (r = e["ofd:DrawParams"],
                                    n = {},
                                    r) {
                                        i = [],
                                        i = i.concat(r["ofd:DrawParam"]),
                                        o = l(i);
                                        try {
                                            for (o.s(); !(a = o.n()).done; )
                                                s = a.value,
                                                s && (n[s["@_ID"]] = {
                                                    LineWidth: s["@_LineWidth"],
                                                    FillColor: s["ofd:FillColor"] ? s["ofd:FillColor"]["@_Value"] : "",
                                                    StrokeColor: s["ofd:StrokeColor"] ? s["ofd:StrokeColor"]["@_Value"] : "",
                                                    relative: s["@_Relative"]
                                                })
                                        } catch (c) {
                                            o.e(c)
                                        } finally {
                                            o.f()
                                        }
                                    }
                                    return t.abrupt("return", n);
                                case 4:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t)
                    }
                    )));
                    return function(e) {
                        return t.apply(this, arguments)
                    }
                }()
                  , N = function() {
                    var t = S(y().mark((function t(e, r, n) {
                        var i, o, s, c, u, d, f, h, p, m, b, g, v, S, w, C, _, A, I;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    if (i = r["ofd:MultiMedias"],
                                    o = {},
                                    !i) {
                                        t.next = 57;
                                        break
                                    }
                                    if (s = [],
                                    i instanceof Array) {
                                        c = l(i);
                                        try {
                                            for (c.s(); !(u = c.n()).done; )
                                                if (d = u.value,
                                                d)
                                                    if (d["ofd:MultiMedia"]instanceof Array) {
                                                        f = l(d["ofd:MultiMedia"]);
                                                        try {
                                                            for (f.s(); !(h = f.n()).done; )
                                                                p = h.value,
                                                                s.push(p)
                                                        } catch (y) {
                                                            f.e(y)
                                                        } finally {
                                                            f.f()
                                                        }
                                                    } else
                                                        s.push(d["ofd:MultiMedia"])
                                        } catch (y) {
                                            c.e(y)
                                        } finally {
                                            c.f()
                                        }
                                    } else
                                        s = s.concat(i["ofd:MultiMedia"]);
                                    m = l(s),
                                    t.prev = 6,
                                    m.s();
                                case 8:
                                    if ((b = m.n()).done) {
                                        t.next = 49;
                                        break
                                    }
                                    if (g = b.value,
                                    null === g || void 0 === g || !g) {
                                        t.next = 47;
                                        break
                                    }
                                    if (v = g["ofd:MediaFile"],
                                    void 0 !== v) {
                                        t.next = 14;
                                        break
                                    }
                                    return t.abrupt("continue", 47);
                                case 14:
                                    if (r["@_BaseLoc"] && -1 === v.indexOf(r["@_BaseLoc"]) && (v = "".concat(r["@_BaseLoc"], "/").concat(v)),
                                    -1 === v.indexOf(n) && (v = "".concat(n, "/").concat(v)),
                                    "image" !== g["@_Type"].toLowerCase()) {
                                        t.next = 46;
                                        break
                                    }
                                    if (S = g["@_Format"],
                                    w = Object(a["f"])(v),
                                    (!S || "gbig2" !== S.toLowerCase() && "jb2" !== S.toLowerCase()) && (!w || "jb2" !== w.toLowerCase() && "gbig2" !== w.toLowerCase())) {
                                        t.next = 26;
                                        break
                                    }
                                    return t.next = 22,
                                    X(e, v);
                                case 22:
                                    C = t.sent,
                                    o[g["@_ID"]] = C,
                                    t.next = 44;
                                    break;
                                case 26:
                                    if ((!S || "jpg" !== S.toLowerCase() && "jpeg" !== S.toLowerCase()) && (!w || "jpg" !== w.toLowerCase() && "jpeg" !== w.toLowerCase())) {
                                        t.next = 33;
                                        break
                                    }
                                    return t.next = 29,
                                    z(e, v);
                                case 29:
                                    _ = t.sent,
                                    o[g["@_ID"]] = {
                                        img: _,
                                        format: "jpeg"
                                    },
                                    t.next = 44;
                                    break;
                                case 33:
                                    if (!(S && "jp2" === S.toLowerCase() || w && "jp2" === w.toLowerCase())) {
                                        t.next = 40;
                                        break
                                    }
                                    return t.next = 36,
                                    G(e, v);
                                case 36:
                                    A = t.sent,
                                    o[g["@_ID"]] = {
                                        img: A,
                                        format: "jp2"
                                    },
                                    t.next = 44;
                                    break;
                                case 40:
                                    return t.next = 42,
                                    W(e, v);
                                case 42:
                                    I = t.sent,
                                    o[g["@_ID"]] = {
                                        img: I,
                                        format: "png"
                                    };
                                case 44:
                                    t.next = 47;
                                    break;
                                case 46:
                                    o[g["@_ID"]] = v;
                                case 47:
                                    t.next = 8;
                                    break;
                                case 49:
                                    t.next = 54;
                                    break;
                                case 51:
                                    t.prev = 51,
                                    t.t0 = t["catch"](6),
                                    m.e(t.t0);
                                case 54:
                                    return t.prev = 54,
                                    m.f(),
                                    t.finish(54);
                                case 57:
                                    return t.abrupt("return", o);
                                case 58:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t, null, [[6, 51, 54, 57]])
                    }
                    )));
                    return function(e, r, n) {
                        return t.apply(this, arguments)
                    }
                }()
                  , M = function(t) {
                    var e = t["ofd:CompositeGraphicUnits"]
                      , r = [];
                    if (e) {
                        var n = [];
                        n = n.concat(e["ofd:CompositeGraphicUnit"]);
                        var i, o = l(n);
                        try {
                            for (o.s(); !(i = o.n()).done; ) {
                                var a = i.value;
                                a && r.push(a)
                            }
                        } catch (s) {
                            o.e(s)
                        } finally {
                            o.f()
                        }
                    }
                    return r
                }
                  , B = function() {
                    var t = S(y().mark((function t(e, r, n) {
                        var i, o, a, s;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    i = r["@_BaseLoc"],
                                    -1 == i.indexOf(n) && (i = "".concat(n, "/").concat(i)),
                                    t.t0 = y().keys(e.files);
                                case 3:
                                    if ((t.t1 = t.t0()).done) {
                                        t.next = 10;
                                        break
                                    }
                                    if (o = t.t1.value,
                                    o.toLowerCase() != i.toLowerCase()) {
                                        t.next = 8;
                                        break
                                    }
                                    return i = o,
                                    t.abrupt("break", 10);
                                case 8:
                                    t.next = 3;
                                    break;
                                case 10:
                                    if (e.files[i]) {
                                        t.next = 12;
                                        break
                                    }
                                    return t.abrupt("return", null);
                                case 12:
                                    return t.next = 14,
                                    U(e, i);
                                case 14:
                                    return a = t.sent,
                                    s = {},
                                    s[r["@_ID"]] = {
                                        json: a["json"]["ofd:Page"],
                                        xml: a["xml"]
                                    },
                                    t.abrupt("return", s);
                                case 18:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t)
                    }
                    )));
                    return function(e, r, n) {
                        return t.apply(this, arguments)
                    }
                }()
                  , F = function() {
                    var t = S(y().mark((function t(e, r, n) {
                        var i, o, s, c, u, d, f, h, p;
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    if (i = [],
                                    !r) {
                                        t.next = 37;
                                        break
                                    }
                                    if (r = Object(a["l"])(r),
                                    -1 === r.indexOf(n) && (r = "".concat(n, "/").concat(r)),
                                    !e.files[r]) {
                                        t.next = 37;
                                        break
                                    }
                                    return t.next = 7,
                                    U(e, r);
                                case 7:
                                    o = t.sent,
                                    s = o["json"]["ofd:Signatures"]["ofd:Signature"],
                                    c = [],
                                    c = c.concat(s),
                                    u = l(c),
                                    t.prev = 12,
                                    u.s();
                                case 14:
                                    if ((d = u.n()).done) {
                                        t.next = 29;
                                        break
                                    }
                                    if (f = d.value,
                                    !f) {
                                        t.next = 27;
                                        break
                                    }
                                    return h = f["@_BaseLoc"],
                                    p = f["@_ID"],
                                    h = Object(a["l"])(h),
                                    -1 === h.indexOf("Signs") && (h = "Signs/".concat(h)),
                                    -1 === h.indexOf(n) && (h = "".concat(n, "/").concat(h)),
                                    t.t0 = i,
                                    t.next = 25,
                                    K(e, h, p);
                                case 25:
                                    t.t1 = t.sent,
                                    t.t0.push.call(t.t0, t.t1);
                                case 27:
                                    t.next = 14;
                                    break;
                                case 29:
                                    t.next = 34;
                                    break;
                                case 31:
                                    t.prev = 31,
                                    t.t2 = t["catch"](12),
                                    u.e(t.t2);
                                case 34:
                                    return t.prev = 34,
                                    u.f(),
                                    t.finish(34);
                                case 37:
                                    return t.abrupt("return", i);
                                case 38:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t, null, [[12, 31, 34, 37]])
                    }
                    )));
                    return function(e, r, n) {
                        return t.apply(this, arguments)
                    }
                }()
                  , j = function() {
                    var t = S(y().mark((function t(e, r) {
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    return t.abrupt("return", e.files[r].async("uint8array"));
                                case 1:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t)
                    }
                    )));
                    return function(e, r) {
                        return t.apply(this, arguments)
                    }
                }()
                  , K = function() {
                    var e = S(y().mark((function e(r, n, i) {
                        var o, a, s, u, l, f;
                        return y().wrap((function(e) {
                            while (1)
                                switch (e.prev = e.next) {
                                case 0:
                                    return e.next = 2,
                                    U(r, n);
                                case 2:
                                    return o = e.sent,
                                    s = o["json"]["ofd:Signature"]["ofd:SignedValue"],
                                    s = s.toString().replace("/", ""),
                                    r.files[s] || (s = "".concat(n.substring(0, n.lastIndexOf("/")), "/").concat(s)),
                                    e.next = 8,
                                    Object(c["a"])(r, s);
                                case 8:
                                    if (a = e.sent,
                                    void 0 !== a.type || null == o["json"]["ofd:Signature"]["ofd:SignedInfo"]["ofd:Seal"]) {
                                        e.next = 16;
                                        break
                                    }
                                    return u = o["json"]["ofd:Signature"]["ofd:SignedInfo"]["ofd:Seal"]["ofd:BaseLoc"],
                                    0 === u.indexOf("/") && (u = u.substring(1)),
                                    r.files[u] || (u = "".concat(n.substring(0, n.lastIndexOf("/")), "/").concat(u)),
                                    e.next = 15,
                                    Object(c["a"])(r, u);
                                case 15:
                                    a = e.sent;
                                case 16:
                                    return l = o["json"]["ofd:Signature"]["ofd:SignedInfo"]["ofd:References"]["@_CheckMethod"],
                                    t.toBeChecked = new Map,
                                    f = new Array,
                                    o["json"]["ofd:Signature"]["ofd:SignedInfo"]["ofd:References"]["ofd:Reference"].forEach(function() {
                                        var t = S(y().mark((function t(e) {
                                            var n, i, o, a;
                                            return y().wrap((function(t) {
                                                while (1)
                                                    switch (t.prev = t.next) {
                                                    case 0:
                                                        if (0 != Object.keys(e).length && 0 != Object.keys(e["@_FileRef"]).length) {
                                                            t.next = 2;
                                                            break
                                                        }
                                                        return t.abrupt("return", !0);
                                                    case 2:
                                                        if (n = e["ofd:CheckValue"],
                                                        i = e["@_FileRef"].replace("/", ""),
                                                        !r.files[i]) {
                                                            t.next = 11;
                                                            break
                                                        }
                                                        return t.next = 7,
                                                        j(r, i);
                                                    case 7:
                                                        o = t.sent,
                                                        f.push({
                                                            fileData: o,
                                                            hashed: n,
                                                            checkMethod: l
                                                        }),
                                                        t.next = 12;
                                                        break;
                                                    case 11:
                                                        f.push((a = {
                                                            hashed: n
                                                        },
                                                        d(a, "hashed", n),
                                                        d(a, "checkMethod", l),
                                                        a));
                                                    case 12:
                                                    case "end":
                                                        return t.stop()
                                                    }
                                            }
                                            ), t)
                                        }
                                        )));
                                        return function(e) {
                                            return t.apply(this, arguments)
                                        }
                                    }()),
                                    t.toBeChecked.set(i, f),
                                    e.abrupt("return", {
                                        stampAnnot: o["json"]["ofd:Signature"]["ofd:SignedInfo"]["ofd:StampAnnot"],
                                        sealObj: a,
                                        signedInfo: {
                                            signatureID: i,
                                            VerifyRet: a.verifyRet,
                                            Provider: o["json"]["ofd:Signature"]["ofd:SignedInfo"]["ofd:Provider"],
                                            SignatureMethod: o["json"]["ofd:Signature"]["ofd:SignedInfo"]["ofd:SignatureMethod"],
                                            SignatureDateTime: o["json"]["ofd:Signature"]["ofd:SignedInfo"]["ofd:SignatureDateTime"]
                                        }
                                    });
                                case 22:
                                case "end":
                                    return e.stop()
                                }
                        }
                        ), e)
                    }
                    )));
                    return function(t, r, n) {
                        return e.apply(this, arguments)
                    }
                }()
                  , L = function(t) {
                    var e = this;
                    return new Promise((function(r, i) {
                        n["a"].call(e, S(y().mark((function e() {
                            return y().wrap((function(e) {
                                while (1)
                                    switch (e.prev = e.next) {
                                    case 0:
                                        return e.next = 2,
                                        C(t.sealObj.ofdArray);
                                    case 2:
                                        return e.abrupt("return", e.sent);
                                    case 3:
                                    case "end":
                                        return e.stop()
                                    }
                            }
                            ), e)
                        }
                        ))), _, A).then((function(t) {
                            r(t)
                        }
                        )).catch((function(t) {
                            i(t)
                        }
                        ))
                    }
                    ))
                }
                  , U = function() {
                    var t = S(y().mark((function t(e, r) {
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    return t.abrupt("return", new Promise((function(t, n) {
                                        e.files[r].async("string").then((function(e) {
                                            var r = {
                                                attributeNamePrefix: "@_",
                                                ignoreAttributes: !1,
                                                parseNodeValue: !1,
                                                trimValues: !1
                                            }
                                              , n = w.parse(e, r)
                                              , i = {
                                                xml: e,
                                                json: n
                                            };
                                            t(i)
                                        }
                                        ), (function(t) {
                                            n(t)
                                        }
                                        ))
                                    }
                                    )));
                                case 1:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t)
                    }
                    )));
                    return function(e, r) {
                        return t.apply(this, arguments)
                    }
                }()
                  , X = function() {
                    var t = S(y().mark((function t(e, r) {
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    return t.abrupt("return", new Promise((function(t, n) {
                                        e.files[r].async("uint8array").then((function(e) {
                                            var r = new s["a"]
                                              , n = r.parse(e);
                                            t({
                                                img: n,
                                                width: r.width,
                                                height: r.height,
                                                format: "gbig2"
                                            })
                                        }
                                        ), (function(t) {
                                            n(t)
                                        }
                                        ))
                                    }
                                    )));
                                case 1:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t)
                    }
                    )));
                    return function(e, r) {
                        return t.apply(this, arguments)
                    }
                }()
                  , z = function() {
                    var t = S(y().mark((function t(e, r) {
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    return t.abrupt("return", new Promise((function(t, n) {
                                        e.files[r].async("base64").then((function(e) {
                                            var r = "data:image/jpeg;base64," + e
                                              , n = new Image;
                                            n.src = r,
                                            n.onload = function() {
                                                t({
                                                    width: n.width,
                                                    height: n.height,
                                                    img: r
                                                })
                                            }
                                            ,
                                            t(r)
                                        }
                                        ), (function(t) {
                                            n(t)
                                        }
                                        ))
                                    }
                                    )));
                                case 1:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t)
                    }
                    )));
                    return function(e, r) {
                        return t.apply(this, arguments)
                    }
                }()
                  , G = function() {
                    var t = S(y().mark((function t(e, r) {
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    return t.abrupt("return", new Promise((function(t, n) {
                                        e.files[r].async("base64").then((function(e) {
                                            var r = "data:image/jp2;base64," + e
                                              , n = new Image;
                                            n.src = r,
                                            n.onload = function() {
                                                t({
                                                    width: n.width,
                                                    height: n.height,
                                                    img: r
                                                })
                                            }
                                            ,
                                            t(r)
                                        }
                                        ), (function(t) {
                                            n(t)
                                        }
                                        ))
                                    }
                                    )));
                                case 1:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t)
                    }
                    )));
                    return function(e, r) {
                        return t.apply(this, arguments)
                    }
                }()
                  , W = function() {
                    var t = S(y().mark((function t(e, r) {
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    if (null != e.files[r]) {
                                        t.next = 2;
                                        break
                                    }
                                    return t.abrupt("return", null);
                                case 2:
                                    return t.abrupt("return", new Promise((function(t, n) {
                                        e.files[r].async("base64").then((function(e) {
                                            var r = "data:image/png;base64," + e
                                              , n = new Image;
                                            n.src = r,
                                            n.onload = function() {
                                                t({
                                                    width: n.width,
                                                    height: n.height,
                                                    img: r
                                                })
                                            }
                                            ,
                                            t(r)
                                        }
                                        ), (function(t) {
                                            n(t)
                                        }
                                        ))
                                    }
                                    )));
                                case 3:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t)
                    }
                    )));
                    return function(e, r) {
                        return t.apply(this, arguments)
                    }
                }()
                  , q = function() {
                    var t = S(y().mark((function t(e, r) {
                        return y().wrap((function(t) {
                            while (1)
                                switch (t.prev = t.next) {
                                case 0:
                                    return t.abrupt("return", new Promise((function(t, n) {
                                        e.files[r].async("arraybuffer").then((function(e) {
                                            t(e)
                                        }
                                        ), (function(t) {
                                            n(t)
                                        }
                                        ))
                                    }
                                    )));
                                case 1:
                                case "end":
                                    return t.stop()
                                }
                        }
                        ), t)
                    }
                    )));
                    return function(e, r) {
                        return t.apply(this, arguments)
                    }
                }()
            }
            ).call(this, r("c8ba"))
        },
		"68ee": function(t, e, r) {
			var n = r("e330"),
				i = r("d039"),
				o = r("1626"),
				a = r("f5df"),
				s = r("d066"),
				c = r("8925"),
				u = function() {},
				d = [],
				l = s("Reflect", "construct"),
				f = /^\s*(?:class|function)\b/,
				h = n(f.exec),
				p = !f.exec(u),
				m = function(t) {
					if (!o(t)) return !1;
					try {
						return l(u, d, t), !0
					} catch (e) {
						return !1
					}
				},
				b = function(t) {
					if (!o(t)) return !1;
					switch (a(t)) {
						case "AsyncFunction":
						case "GeneratorFunction":
						case "AsyncGeneratorFunction":
							return !1
					}
					try {
						return p || !!h(f, c(t))
					} catch (e) {
						return !0
					}
				};
			b.sham = !0, t.exports = !l || i((function() {
				var t;
				return m(m.call) || !m(Object) || !m((function() {
					t = !0
				})) || t
			})) ? b : m
		},
		6964: function(t, e, r) {
			var n = r("cb2d");
			t.exports = function(t, e, r) {
				for (var i in e) n(t, i, e[i], r);
				return t
			}
		},
		"699f": function(t, e, r) {
			var n;
			n = function() {
				"use strict";
				return {
					"0.2.262.1.10": {
						d: "Telesec",
						c: "Deutsche Telekom"
					},
					"0.2.262.1.10.0": {
						d: "extension",
						c: "Telesec"
					},
					"0.2.262.1.10.1": {
						d: "mechanism",
						c: "Telesec"
					},
					"0.2.262.1.10.1.0": {
						d: "authentication",
						c: "Telesec mechanism"
					},
					"0.2.262.1.10.1.0.1": {
						d: "passwordAuthentication",
						c: "Telesec authentication"
					},
					"0.2.262.1.10.1.0.2": {
						d: "protectedPasswordAuthentication",
						c: "Telesec authentication"
					},
					"0.2.262.1.10.1.0.3": {
						d: "oneWayX509Authentication",
						c: "Telesec authentication"
					},
					"0.2.262.1.10.1.0.4": {
						d: "twoWayX509Authentication",
						c: "Telesec authentication"
					},
					"0.2.262.1.10.1.0.5": {
						d: "threeWayX509Authentication",
						c: "Telesec authentication"
					},
					"0.2.262.1.10.1.0.6": {
						d: "oneWayISO9798Authentication",
						c: "Telesec authentication"
					},
					"0.2.262.1.10.1.0.7": {
						d: "twoWayISO9798Authentication",
						c: "Telesec authentication"
					},
					"0.2.262.1.10.1.0.8": {
						d: "telekomAuthentication",
						c: "Telesec authentication"
					},
					"0.2.262.1.10.1.1": {
						d: "signature",
						c: "Telesec mechanism"
					},
					"0.2.262.1.10.1.1.1": {
						d: "md4WithRSAAndISO9697",
						c: "Telesec mechanism"
					},
					"0.2.262.1.10.1.1.2": {
						d: "md4WithRSAAndTelesecSignatureStandard",
						c: "Telesec mechanism"
					},
					"0.2.262.1.10.1.1.3": {
						d: "md5WithRSAAndISO9697",
						c: "Telesec mechanism"
					},
					"0.2.262.1.10.1.1.4": {
						d: "md5WithRSAAndTelesecSignatureStandard",
						c: "Telesec mechanism"
					},
					"0.2.262.1.10.1.1.5": {
						d: "ripemd160WithRSAAndTelekomSignatureStandard",
						c: "Telesec mechanism"
					},
					"0.2.262.1.10.1.1.9": {
						d: "hbciRsaSignature",
						c: "Telesec signature"
					},
					"0.2.262.1.10.1.2": {
						d: "encryption",
						c: "Telesec mechanism"
					},
					"0.2.262.1.10.1.2.0": {
						d: "none",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.1": {
						d: "rsaTelesec",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.2": {
						d: "des",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.2.1": {
						d: "desECB",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.2.2": {
						d: "desCBC",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.2.3": {
						d: "desOFB",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.2.4": {
						d: "desCFB8",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.2.5": {
						d: "desCFB64",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.3": {
						d: "des3",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.3.1": {
						d: "des3ECB",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.3.2": {
						d: "des3CBC",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.3.3": {
						d: "des3OFB",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.3.4": {
						d: "des3CFB8",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.3.5": {
						d: "des3CFB64",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.4": {
						d: "magenta",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.5": {
						d: "idea",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.5.1": {
						d: "ideaECB",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.5.2": {
						d: "ideaCBC",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.5.3": {
						d: "ideaOFB",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.5.4": {
						d: "ideaCFB8",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.2.5.5": {
						d: "ideaCFB64",
						c: "Telesec encryption"
					},
					"0.2.262.1.10.1.3": {
						d: "oneWayFunction",
						c: "Telesec mechanism"
					},
					"0.2.262.1.10.1.3.1": {
						d: "md4",
						c: "Telesec one-way function"
					},
					"0.2.262.1.10.1.3.2": {
						d: "md5",
						c: "Telesec one-way function"
					},
					"0.2.262.1.10.1.3.3": {
						d: "sqModNX509",
						c: "Telesec one-way function"
					},
					"0.2.262.1.10.1.3.4": {
						d: "sqModNISO",
						c: "Telesec one-way function"
					},
					"0.2.262.1.10.1.3.5": {
						d: "ripemd128",
						c: "Telesec one-way function"
					},
					"0.2.262.1.10.1.3.6": {
						d: "hashUsingBlockCipher",
						c: "Telesec one-way function"
					},
					"0.2.262.1.10.1.3.7": {
						d: "mac",
						c: "Telesec one-way function"
					},
					"0.2.262.1.10.1.3.8": {
						d: "ripemd160",
						c: "Telesec one-way function"
					},
					"0.2.262.1.10.1.4": {
						d: "fecFunction",
						c: "Telesec mechanism"
					},
					"0.2.262.1.10.1.4.1": {
						d: "reedSolomon",
						c: "Telesec mechanism"
					},
					"0.2.262.1.10.2": {
						d: "module",
						c: "Telesec"
					},
					"0.2.262.1.10.2.0": {
						d: "algorithms",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.1": {
						d: "attributeTypes",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.2": {
						d: "certificateTypes",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.3": {
						d: "messageTypes",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.4": {
						d: "plProtocol",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.5": {
						d: "smeAndComponentsOfSme",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.6": {
						d: "fec",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.7": {
						d: "usefulDefinitions",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.8": {
						d: "stefiles",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.9": {
						d: "sadmib",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.10": {
						d: "electronicOrder",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.11": {
						d: "telesecTtpAsymmetricApplication",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.12": {
						d: "telesecTtpBasisApplication",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.13": {
						d: "telesecTtpMessages",
						c: "Telesec module"
					},
					"0.2.262.1.10.2.14": {
						d: "telesecTtpTimeStampApplication",
						c: "Telesec module"
					},
					"0.2.262.1.10.3": {
						d: "objectClass",
						c: "Telesec"
					},
					"0.2.262.1.10.3.0": {
						d: "telesecOtherName",
						c: "Telesec object class"
					},
					"0.2.262.1.10.3.1": {
						d: "directory",
						c: "Telesec object class"
					},
					"0.2.262.1.10.3.2": {
						d: "directoryType",
						c: "Telesec object class"
					},
					"0.2.262.1.10.3.3": {
						d: "directoryGroup",
						c: "Telesec object class"
					},
					"0.2.262.1.10.3.4": {
						d: "directoryUser",
						c: "Telesec object class"
					},
					"0.2.262.1.10.3.5": {
						d: "symmetricKeyEntry",
						c: "Telesec object class"
					},
					"0.2.262.1.10.4": {
						d: "package",
						c: "Telesec"
					},
					"0.2.262.1.10.5": {
						d: "parameter",
						c: "Telesec"
					},
					"0.2.262.1.10.6": {
						d: "nameBinding",
						c: "Telesec"
					},
					"0.2.262.1.10.7": {
						d: "attribute",
						c: "Telesec"
					},
					"0.2.262.1.10.7.0": {
						d: "applicationGroupIdentifier",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.1": {
						d: "certificateType",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.2": {
						d: "telesecCertificate",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.3": {
						d: "certificateNumber",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.4": {
						d: "certificateRevocationList",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.5": {
						d: "creationDate",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.6": {
						d: "issuer",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.7": {
						d: "namingAuthority",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.8": {
						d: "publicKeyDirectory",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.9": {
						d: "securityDomain",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.10": {
						d: "subject",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.11": {
						d: "timeOfRevocation",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.12": {
						d: "userGroupReference",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.13": {
						d: "validity",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.14": {
						d: "zert93",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.15": {
						d: "securityMessEnv",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.16": {
						d: "anonymizedPublicKeyDirectory",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.17": {
						d: "telesecGivenName",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.18": {
						d: "nameAdditions",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.19": {
						d: "telesecPostalCode",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.20": {
						d: "nameDistinguisher",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.21": {
						d: "telesecCertificateList",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.22": {
						d: "teletrustCertificateList",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.23": {
						d: "x509CertificateList",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.24": {
						d: "timeOfIssue",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.25": {
						d: "physicalCardNumber",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.26": {
						d: "fileType",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.27": {
						d: "ctlFileIsArchive",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.28": {
						d: "emailAddress",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.29": {
						d: "certificateTemplateList",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.30": {
						d: "directoryName",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.31": {
						d: "directoryTypeName",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.32": {
						d: "directoryGroupName",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.33": {
						d: "directoryUserName",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.34": {
						d: "revocationFlag",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.35": {
						d: "symmetricKeyEntryName",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.36": {
						d: "glNumber",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.37": {
						d: "goNumber",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.38": {
						d: "gKeyData",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.39": {
						d: "zKeyData",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.40": {
						d: "ktKeyData",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.41": {
						d: "ktKeyNumber",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.51": {
						d: "timeOfRevocationGen",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.7.52": {
						d: "liabilityText",
						c: "Telesec attribute"
					},
					"0.2.262.1.10.8": {
						d: "attributeGroup",
						c: "Telesec"
					},
					"0.2.262.1.10.9": {
						d: "action",
						c: "Telesec"
					},
					"0.2.262.1.10.10": {
						d: "notification",
						c: "Telesec"
					},
					"0.2.262.1.10.11": {
						d: "snmp-mibs",
						c: "Telesec"
					},
					"0.2.262.1.10.11.1": {
						d: "securityApplication",
						c: "Telesec SNMP MIBs"
					},
					"0.2.262.1.10.12": {
						d: "certAndCrlExtensionDefinitions",
						c: "Telesec"
					},
					"0.2.262.1.10.12.0": {
						d: "liabilityLimitationFlag",
						c: "Telesec cert/CRL extension"
					},
					"0.2.262.1.10.12.1": {
						d: "telesecCertIdExt",
						c: "Telesec cert/CRL extension"
					},
					"0.2.262.1.10.12.2": {
						d: "Telesec policyIdentifier",
						c: "Telesec cert/CRL extension"
					},
					"0.2.262.1.10.12.3": {
						d: "telesecPolicyQualifierID",
						c: "Telesec cert/CRL extension"
					},
					"0.2.262.1.10.12.4": {
						d: "telesecCRLFilteredExt",
						c: "Telesec cert/CRL extension"
					},
					"0.2.262.1.10.12.5": {
						d: "telesecCRLFilterExt",
						c: "Telesec cert/CRL extension"
					},
					"0.2.262.1.10.12.6": {
						d: "telesecNamingAuthorityExt",
						c: "Telesec cert/CRL extension"
					},
					"0.4.0.127.0.7": {
						d: "bsi",
						c: "BSI TR-03110/TR-03111"
					},
					"0.4.0.127.0.7.1": {
						d: "bsiEcc",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1": {
						d: "bsifieldType",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.1": {
						d: "bsiPrimeField",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.2": {
						d: "bsiCharacteristicTwoField",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.2.2": {
						d: "bsiECTLVKeyFormat",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.2.2.1": {
						d: "bsiECTLVPublicKey",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.2.3": {
						d: "bsiCharacteristicTwoBasis",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.2.3.1": {
						d: "bsiGnBasis",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.2.3.2": {
						d: "bsiTpBasis",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.2.3.3": {
						d: "bsiPpBasis",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.4.1": {
						d: "bsiEcdsaSignatures",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.4.1.1": {
						d: "bsiEcdsaWithSHA1",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.4.1.2": {
						d: "bsiEcdsaWithSHA224",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.4.1.3": {
						d: "bsiEcdsaWithSHA256",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.4.1.4": {
						d: "bsiEcdsaWithSHA384",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.4.1.5": {
						d: "bsiEcdsaWithSHA512",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.4.1.6": {
						d: "bsiEcdsaWithRIPEMD160",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.1.1": {
						d: "bsiEckaEgX963KDF",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.1.1.1": {
						d: "bsiEckaEgX963KDFWithSHA1",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.1.1.2": {
						d: "bsiEckaEgX963KDFWithSHA224",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.1.1.3": {
						d: "bsiEckaEgX963KDFWithSHA256",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.1.1.4": {
						d: "bsiEckaEgX963KDFWithSHA384",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.1.1.5": {
						d: "bsiEckaEgX963KDFWithSHA512",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.1.1.6": {
						d: "bsiEckaEgX963KDFWithRIPEMD160",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.1.2": {
						d: "bsiEckaEgSessionKDF",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.1.2.1": {
						d: "bsiEckaEgSessionKDFWith3DES",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.1.2.2": {
						d: "bsiEckaEgSessionKDFWithAES128",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.1.2.3": {
						d: "bsiEckaEgSessionKDFWithAES192",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.1.2.4": {
						d: "bsiEckaEgSessionKDFWithAES256",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.2": {
						d: "bsiEckaDH",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.2.1": {
						d: "bsiEckaDHX963KDF",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.2.1.1": {
						d: "bsiEckaDHX963KDFWithSHA1",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.2.1.2": {
						d: "bsiEckaDHX963KDFWithSHA224",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.2.1.3": {
						d: "bsiEckaDHX963KDFWithSHA256",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.2.1.4": {
						d: "bsiEckaDHX963KDFWithSHA384",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.2.1.5": {
						d: "bsiEckaDHX963KDFWithSHA512",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.2.1.6": {
						d: "bsiEckaDHX963KDFWithRIPEMD160",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.2.2": {
						d: "bsiEckaDHSessionKDF",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.2.2.1": {
						d: "bsiEckaDHSessionKDFWith3DES",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.2.2.2": {
						d: "bsiEckaDHSessionKDFWithAES128",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.2.2.3": {
						d: "bsiEckaDHSessionKDFWithAES192",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.1.5.2.2.4": {
						d: "bsiEckaDHSessionKDFWithAES256",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.2": {
						d: "bsiEcKeyType",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.2.1": {
						d: "bsiEcPublicKey",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.5.1": {
						d: "bsiKaeg",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.5.1.1": {
						d: "bsiKaegWithX963KDF",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.1.5.1.2": {
						d: "bsiKaegWith3DESKDF",
						c: "BSI TR-03111"
					},
					"0.4.0.127.0.7.2.2.1": {
						d: "bsiPK",
						c: "BSI TR-03110. Formerly known as bsiCA, now moved to ...2.2.3.x"
					},
					"0.4.0.127.0.7.2.2.1.1": {
						d: "bsiPK_DH",
						c: "BSI TR-03110. Formerly known as bsiCA_DH, now moved to ...2.2.3.x"
					},
					"0.4.0.127.0.7.2.2.1.2": {
						d: "bsiPK_ECDH",
						c: "BSI TR-03110. Formerly known as bsiCA_ECDH, now moved to ...2.2.3.x"
					},
					"0.4.0.127.0.7.2.2.2": {
						d: "bsiTA",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.2.1": {
						d: "bsiTA_RSA",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.2.1.1": {
						d: "bsiTA_RSAv1_5_SHA1",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.2.1.2": {
						d: "bsiTA_RSAv1_5_SHA256",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.2.1.3": {
						d: "bsiTA_RSAPSS_SHA1",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.2.1.4": {
						d: "bsiTA_RSAPSS_SHA256",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.2.1.5": {
						d: "bsiTA_RSAv1_5_SHA512",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.2.1.6": {
						d: "bsiTA_RSAPSS_SHA512",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.2.2": {
						d: "bsiTA_ECDSA",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.2.2.1": {
						d: "bsiTA_ECDSA_SHA1",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.2.2.2": {
						d: "bsiTA_ECDSA_SHA224",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.2.2.3": {
						d: "bsiTA_ECDSA_SHA256",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.2.2.4": {
						d: "bsiTA_ECDSA_SHA384",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.2.2.5": {
						d: "bsiTA_ECDSA_SHA512",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.3": {
						d: "bsiCA",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.3.1": {
						d: "bsiCA_DH",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.3.1.1": {
						d: "bsiCA_DH_3DES_CBC_CBC",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.3.1.2": {
						d: "bsiCA_DH_AES_CBC_CMAC_128",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.3.1.3": {
						d: "bsiCA_DH_AES_CBC_CMAC_192",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.3.1.4": {
						d: "bsiCA_DH_AES_CBC_CMAC_256",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.3.2": {
						d: "bsiCA_ECDH",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.3.2.1": {
						d: "bsiCA_ECDH_3DES_CBC_CBC",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.3.2.2": {
						d: "bsiCA_ECDH_AES_CBC_CMAC_128",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.3.2.3": {
						d: "bsiCA_ECDH_AES_CBC_CMAC_192",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.3.2.4": {
						d: "bsiCA_ECDH_AES_CBC_CMAC_256",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4": {
						d: "bsiPACE",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.1": {
						d: "bsiPACE_DH_GM",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.1.1": {
						d: "bsiPACE_DH_GM_3DES_CBC_CBC",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.1.2": {
						d: "bsiPACE_DH_GM_AES_CBC_CMAC_128",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.1.3": {
						d: "bsiPACE_DH_GM_AES_CBC_CMAC_192",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.1.4": {
						d: "bsiPACE_DH_GM_AES_CBC_CMAC_256",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.2": {
						d: "bsiPACE_ECDH_GM",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.2.1": {
						d: "bsiPACE_ECDH_GM_3DES_CBC_CBC",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.2.2": {
						d: "bsiPACE_ECDH_GM_AES_CBC_CMAC_128",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.2.3": {
						d: "bsiPACE_ECDH_GM_AES_CBC_CMAC_192",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.2.4": {
						d: "bsiPACE_ECDH_GM_AES_CBC_CMAC_256",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.3": {
						d: "bsiPACE_DH_IM",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.3.1": {
						d: "bsiPACE_DH_IM_3DES_CBC_CBC",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.3.2": {
						d: "bsiPACE_DH_IM_AES_CBC_CMAC_128",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.3.3": {
						d: "bsiPACE_DH_IM_AES_CBC_CMAC_192",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.3.4": {
						d: "bsiPACE_DH_IM_AES_CBC_CMAC_256",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.4": {
						d: "bsiPACE_ECDH_IM",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.4.1": {
						d: "bsiPACE_ECDH_IM_3DES_CBC_CBC",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.4.2": {
						d: "bsiPACE_ECDH_IM_AES_CBC_CMAC_128",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.4.3": {
						d: "bsiPACE_ECDH_IM_AES_CBC_CMAC_192",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.4.4.4": {
						d: "bsiPACE_ECDH_IM_AES_CBC_CMAC_256",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.5": {
						d: "bsiRI",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.5.1": {
						d: "bsiRI_DH",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.5.1.1": {
						d: "bsiRI_DH_SHA1",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.5.1.2": {
						d: "bsiRI_DH_SHA224",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.5.1.3": {
						d: "bsiRI_DH_SHA256",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.5.1.4": {
						d: "bsiRI_DH_SHA384",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.5.1.5": {
						d: "bsiRI_DH_SHA512",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.5.2": {
						d: "bsiRI_ECDH",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.5.2.1": {
						d: "bsiRI_ECDH_SHA1",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.5.2.2": {
						d: "bsiRI_ECDH_SHA224",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.5.2.3": {
						d: "bsiRI_ECDH_SHA256",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.5.2.4": {
						d: "bsiRI_ECDH_SHA384",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.5.2.5": {
						d: "bsiRI_ECDH_SHA512",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.6": {
						d: "bsiCardInfo",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.7": {
						d: "bsiEidSecurity",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.2.2.8": {
						d: "bsiPT",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.2": {
						d: "bsiEACRoles",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.2.1": {
						d: "bsiEACRolesIS",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.2.2": {
						d: "bsiEACRolesAT",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.2.3": {
						d: "bsiEACRolesST",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.3": {
						d: "bsiTAv2ce",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.3.1": {
						d: "bsiTAv2ceDescription",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.3.1.1": {
						d: "bsiTAv2ceDescriptionPlainText",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.3.1.2": {
						d: "bsiTAv2ceDescriptionIA5String",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.3.1.3": {
						d: "bsiTAv2ceDescriptionOctetString",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.3.2": {
						d: "bsiTAv2ceTerminalSector",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.4": {
						d: "bsiAuxData",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.4.1": {
						d: "bsiAuxDataBirthday",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.4.2": {
						d: "bsiAuxDataExpireDate",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.4.3": {
						d: "bsiAuxDataCommunityID",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5": {
						d: "bsiDefectList",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.1": {
						d: "bsiDefectAuthDefect",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.1.1": {
						d: "bsiDefectCertRevoked",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.1.2": {
						d: "bsiDefectCertReplaced",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.1.3": {
						d: "bsiDefectChipAuthKeyRevoked",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.1.4": {
						d: "bsiDefectActiveAuthKeyRevoked",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.2": {
						d: "bsiDefectEPassportDefect",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.2.1": {
						d: "bsiDefectEPassportDGMalformed",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.2.2": {
						d: "bsiDefectSODInvalid",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.3": {
						d: "bsiDefectEIDDefect",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.3.1": {
						d: "bsiDefectEIDDGMalformed",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.3.2": {
						d: "bsiDefectEIDIntegrity",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.4": {
						d: "bsiDefectDocumentDefect",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.4.1": {
						d: "bsiDefectCardSecurityMalformed",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.4.2": {
						d: "bsiDefectChipSecurityMalformed",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.5.4.3": {
						d: "bsiDefectPowerDownReq",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.1.6": {
						d: "bsiListContentDescription",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.2.1": {
						d: "bsiSecurityObject",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.2.2": {
						d: "bsiBlackList",
						c: "BSI TR-03110"
					},
					"0.4.0.127.0.7.3.4.2.2": {
						d: "bsiSignedUpdateDeviceAdmin",
						c: "BSI TR-03109"
					},
					"0.4.0.127.0.7.4.1.1.1": {
						d: "bsiCertReqMsgs",
						c: "BSI TR-03109"
					},
					"0.4.0.127.0.7.4.1.1.2": {
						d: "bsiCertReqMsgswithOuterSignature",
						c: "BSI TR-03109"
					},
					"0.4.0.127.0.7.4.1.1.3": {
						d: "bsiAuthorizedCertReqMsgs",
						c: "BSI TR-03109"
					},
					"0.4.0.127.0.7.4.1.2.2": {
						d: "bsiSignedRevReqs",
						c: "BSI TR-03109"
					},
					"0.4.0.1862": {
						d: "etsiQcsProfile",
						c: "ETSI TS 101 862 qualified certificates"
					},
					"0.4.0.1862.1": {
						d: "etsiQcs",
						c: "ETSI TS 101 862 qualified certificates"
					},
					"0.4.0.1862.1.1": {
						d: "etsiQcsCompliance",
						c: "ETSI TS 101 862 qualified certificates"
					},
					"0.4.0.1862.1.2": {
						d: "etsiQcsLimitValue",
						c: "ETSI TS 101 862 qualified certificates"
					},
					"0.4.0.1862.1.3": {
						d: "etsiQcsRetentionPeriod",
						c: "ETSI TS 101 862 qualified certificates"
					},
					"0.4.0.1862.1.4": {
						d: "etsiQcsQcSSCD",
						c: "ETSI TS 101 862 qualified certificates"
					},
					"0.9.2342.19200300.100.1.1": {
						d: "userID",
						c: "Some oddball X.500 attribute collection"
					},
					"0.9.2342.19200300.100.1.3": {
						d: "rfc822Mailbox",
						c: "Some oddball X.500 attribute collection"
					},
					"0.9.2342.19200300.100.1.25": {
						d: "domainComponent",
						c: "Men are from Mars, this OID is from Pluto"
					},
					"1.0.10118.3.0.49": {
						d: "ripemd160",
						c: "ISO 10118-3 hash function"
					},
					"1.0.10118.3.0.50": {
						d: "ripemd128",
						c: "ISO 10118-3 hash function"
					},
					"1.0.10118.3.0.55": {
						d: "whirlpool",
						c: "ISO 10118-3 hash function"
					},
					"1.0.18033.2": {
						d: "iso18033-2",
						c: "ISO 18033-2"
					},
					"1.0.18033.2.2": {
						d: "kem",
						c: "ISO 18033-2 algorithms"
					},
					"1.0.18033.2.2.4": {
						d: "kemRSA",
						c: "ISO 18033-2 KEM algorithms"
					},
					"1.2.36.1.3.1.1.1": {
						d: "qgpki",
						c: "Queensland Government PKI"
					},
					"1.2.36.1.3.1.1.1.1": {
						d: "qgpkiPolicies",
						c: "QGPKI policies"
					},
					"1.2.36.1.3.1.1.1.1.1": {
						d: "qgpkiMedIntermedCA",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.1.1": {
						d: "qgpkiMedIntermedIndividual",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.1.2": {
						d: "qgpkiMedIntermedDeviceControl",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.1.3": {
						d: "qgpkiMedIntermedDevice",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.1.4": {
						d: "qgpkiMedIntermedAuthorisedParty",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.1.5": {
						d: "qgpkiMedIntermedDeviceSystem",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.2": {
						d: "qgpkiMedIssuingCA",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.2.1": {
						d: "qgpkiMedIssuingIndividual",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.2.2": {
						d: "qgpkiMedIssuingDeviceControl",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.2.3": {
						d: "qgpkiMedIssuingDevice",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.2.4": {
						d: "qgpkiMedIssuingAuthorisedParty",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.2.5": {
						d: "qgpkiMedIssuingClientAuth",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.2.6": {
						d: "qgpkiMedIssuingServerAuth",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.2.7": {
						d: "qgpkiMedIssuingDataProt",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.2.8": {
						d: "qgpkiMedIssuingTokenAuth",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.3": {
						d: "qgpkiBasicIntermedCA",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.3.1": {
						d: "qgpkiBasicIntermedDeviceSystem",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.4": {
						d: "qgpkiBasicIssuingCA",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.4.1": {
						d: "qgpkiBasicIssuingClientAuth",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.4.2": {
						d: "qgpkiBasicIssuingServerAuth",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.1.4.3": {
						d: "qgpkiBasicIssuingDataSigning",
						c: "QGPKI policy"
					},
					"1.2.36.1.3.1.1.1.2": {
						d: "qgpkiAssuranceLevel",
						c: "QGPKI assurance level"
					},
					"1.2.36.1.3.1.1.1.2.1": {
						d: "qgpkiAssuranceRudimentary",
						c: "QGPKI assurance level"
					},
					"1.2.36.1.3.1.1.1.2.2": {
						d: "qgpkiAssuranceBasic",
						c: "QGPKI assurance level"
					},
					"1.2.36.1.3.1.1.1.2.3": {
						d: "qgpkiAssuranceMedium",
						c: "QGPKI assurance level"
					},
					"1.2.36.1.3.1.1.1.2.4": {
						d: "qgpkiAssuranceHigh",
						c: "QGPKI assurance level"
					},
					"1.2.36.1.3.1.1.1.3": {
						d: "qgpkiCertFunction",
						c: "QGPKI policies"
					},
					"1.2.36.1.3.1.1.1.3.1": {
						d: "qgpkiFunctionIndividual",
						c: "QGPKI policies"
					},
					"1.2.36.1.3.1.1.1.3.2": {
						d: "qgpkiFunctionDevice",
						c: "QGPKI policies"
					},
					"1.2.36.1.3.1.1.1.3.3": {
						d: "qgpkiFunctionAuthorisedParty",
						c: "QGPKI policies"
					},
					"1.2.36.1.3.1.1.1.3.4": {
						d: "qgpkiFunctionDeviceControl",
						c: "QGPKI policies"
					},
					"1.2.36.1.3.1.2": {
						d: "qpspki",
						c: "Queensland Police PKI"
					},
					"1.2.36.1.3.1.2.1": {
						d: "qpspkiPolicies",
						c: "Queensland Police PKI"
					},
					"1.2.36.1.3.1.2.1.2": {
						d: "qpspkiPolicyBasic",
						c: "Queensland Police PKI"
					},
					"1.2.36.1.3.1.2.1.3": {
						d: "qpspkiPolicyMedium",
						c: "Queensland Police PKI"
					},
					"1.2.36.1.3.1.2.1.4": {
						d: "qpspkiPolicyHigh",
						c: "Queensland Police PKI"
					},
					"1.2.36.1.3.1.3.2": {
						d: "qtmrpki",
						c: "Queensland Transport PKI"
					},
					"1.2.36.1.3.1.3.2.1": {
						d: "qtmrpkiPolicies",
						c: "Queensland Transport PKI"
					},
					"1.2.36.1.3.1.3.2.2": {
						d: "qtmrpkiPurpose",
						c: "Queensland Transport PKI"
					},
					"1.2.36.1.3.1.3.2.2.1": {
						d: "qtmrpkiIndividual",
						c: "Queensland Transport PKI purpose"
					},
					"1.2.36.1.3.1.3.2.2.2": {
						d: "qtmrpkiDeviceControl",
						c: "Queensland Transport PKI purpose"
					},
					"1.2.36.1.3.1.3.2.2.3": {
						d: "qtmrpkiDevice",
						c: "Queensland Transport PKI purpose"
					},
					"1.2.36.1.3.1.3.2.2.4": {
						d: "qtmrpkiAuthorisedParty",
						c: "Queensland Transport PKI purpose"
					},
					"1.2.36.1.3.1.3.2.2.5": {
						d: "qtmrpkiDeviceSystem",
						c: "Queensland Transport PKI purpose"
					},
					"1.2.36.1.3.1.3.2.3": {
						d: "qtmrpkiDevice",
						c: "Queensland Transport PKI"
					},
					"1.2.36.1.3.1.3.2.3.1": {
						d: "qtmrpkiDriverLicense",
						c: "Queensland Transport PKI device"
					},
					"1.2.36.1.3.1.3.2.3.2": {
						d: "qtmrpkiIndustryAuthority",
						c: "Queensland Transport PKI device"
					},
					"1.2.36.1.3.1.3.2.3.3": {
						d: "qtmrpkiMarineLicense",
						c: "Queensland Transport PKI device"
					},
					"1.2.36.1.3.1.3.2.3.4": {
						d: "qtmrpkiAdultProofOfAge",
						c: "Queensland Transport PKI device"
					},
					"1.2.36.1.3.1.3.2.3.5": {
						d: "qtmrpkiSam",
						c: "Queensland Transport PKI device"
					},
					"1.2.36.1.3.1.3.2.4": {
						d: "qtmrpkiAuthorisedParty",
						c: "Queensland Transport PKI"
					},
					"1.2.36.1.3.1.3.2.4.1": {
						d: "qtmrpkiTransportInspector",
						c: "Queensland Transport PKI authorised party"
					},
					"1.2.36.1.3.1.3.2.4.2": {
						d: "qtmrpkiPoliceOfficer",
						c: "Queensland Transport PKI authorised party"
					},
					"1.2.36.1.3.1.3.2.4.3": {
						d: "qtmrpkiSystem",
						c: "Queensland Transport PKI authorised party"
					},
					"1.2.36.1.3.1.3.2.4.4": {
						d: "qtmrpkiLiquorLicensingInspector",
						c: "Queensland Transport PKI authorised party"
					},
					"1.2.36.1.3.1.3.2.4.5": {
						d: "qtmrpkiMarineEnforcementOfficer",
						c: "Queensland Transport PKI authorised party"
					},
					"1.2.36.1.333.1": {
						d: "australianBusinessNumber",
						c: "Australian Government corporate taxpayer ID"
					},
					"1.2.36.68980861.1.1.2": {
						d: "signetPersonal",
						c: "Signet CA"
					},
					"1.2.36.68980861.1.1.3": {
						d: "signetBusiness",
						c: "Signet CA"
					},
					"1.2.36.68980861.1.1.4": {
						d: "signetLegal",
						c: "Signet CA"
					},
					"1.2.36.68980861.1.1.10": {
						d: "signetPilot",
						c: "Signet CA"
					},
					"1.2.36.68980861.1.1.11": {
						d: "signetIntraNet",
						c: "Signet CA"
					},
					"1.2.36.68980861.1.1.20": {
						d: "signetPolicy",
						c: "Signet CA"
					},
					"1.2.36.75878867.1.100.1.1": {
						d: "certificatesAustraliaPolicy",
						c: "Certificates Australia CA"
					},
					"1.2.156.10197.1": {
						d: "gmtCryptographicAlgorithm",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.100": {
						d: "gmtBlockCipher",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.102": {
						d: "sm1Cipher",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.103": {
						d: "ssf33Cipher",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.104": {
						d: "sm4Cipher",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.200": {
						d: "gmtStreamCipher",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.201": {
						d: "zucCipher",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.300": {
						d: "gmtPublicKeyCryptography",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.301": {
						d: "sm2ECC",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.301.1": {
						d: "sm2-1DigitalSignature",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.301.2": {
						d: "sm2-2KeyExchange",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.301.3": {
						d: "sm2-3PublicKeyEncryption",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.302": {
						d: "gmtSM9IBE",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.302.1": {
						d: "sm9-1DigitalSignature",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.302.2": {
						d: "sm9-2KeyExchange",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.302.3": {
						d: "sm9-3PublicKeyEncryption",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.400": {
						d: "gmtHashAlgorithm",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.401": {
						d: "sm3Hash",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.401.1": {
						d: "sm3HashWithoutKey",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.401.2": {
						d: "sm3HashWithKey",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.500": {
						d: "gmtDigestSigning",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.501": {
						d: "sm2withSM3",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.1.504": {
						d: "rsaWithSM3",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.4.3": {
						d: "gmtCertificateAuthority",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6": {
						d: "gmtStandardClass",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.1": {
						d: "gmtFoundationClass",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.1.1": {
						d: "gmtAlgorithmClass",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.1.1.1": {
						d: "zucStandard",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.1.1.2": {
						d: "sm4Standard",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.1.1.3": {
						d: "sm2Standard",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.1.1.4": {
						d: "sm3Standard",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.1.2": {
						d: "gmtIDClass",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.1.2.1": {
						d: "gmtCryptoID",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.1.3": {
						d: "gmtOperationModes",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.1.4": {
						d: "gmtSecurityMechanism",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.1.4.1": {
						d: "gmtSM2Specification",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.1.4.2": {
						d: "gmtSM2CryptographicMessageSyntax",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.2": {
						d: "gmtDeviceClass",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.3": {
						d: "gmtServiceClass",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.4": {
						d: "gmtInfrastructure",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.5": {
						d: "gmtTestingClass",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.5.1": {
						d: "gmtRandomTestingClass",
						c: "China GM Standards Committee"
					},
					"1.2.156.10197.6.6": {
						d: "gmtManagementClass",
						c: "China GM Standards Committee"
					},
					"1.2.392.200011.61.1.1.1": {
						d: "mitsubishiSecurityAlgorithm",
						c: "Mitsubishi security algorithm"
					},
					"1.2.392.200011.61.1.1.1.1": {
						d: "misty1-cbc",
						c: "Mitsubishi security algorithm"
					},
					"1.2.410.200004.1": {
						d: "kisaAlgorithm",
						c: "KISA algorithm"
					},
					"1.2.410.200004.1.1": {
						d: "kcdsa",
						c: "Korean DSA"
					},
					"1.2.410.200004.1.2": {
						d: "has160",
						c: "Korean hash algorithm"
					},
					"1.2.410.200004.1.3": {
						d: "seedECB",
						c: "Korean SEED algorithm, ECB mode"
					},
					"1.2.410.200004.1.4": {
						d: "seedCBC",
						c: "Korean SEED algorithm, CBC mode"
					},
					"1.2.410.200004.1.5": {
						d: "seedOFB",
						c: "Korean SEED algorithm, OFB mode"
					},
					"1.2.410.200004.1.6": {
						d: "seedCFB",
						c: "Korean SEED algorithm, CFB mode"
					},
					"1.2.410.200004.1.7": {
						d: "seedMAC",
						c: "Korean SEED algorithm, MAC mode"
					},
					"1.2.410.200004.1.8": {
						d: "kcdsaWithHAS160",
						c: "Korean signature algorithm"
					},
					"1.2.410.200004.1.9": {
						d: "kcdsaWithSHA1",
						c: "Korean signature algorithm"
					},
					"1.2.410.200004.1.10": {
						d: "pbeWithHAS160AndSEED-ECB",
						c: "Korean SEED algorithm, PBE key derivation"
					},
					"1.2.410.200004.1.11": {
						d: "pbeWithHAS160AndSEED-CBC",
						c: "Korean SEED algorithm, PBE key derivation"
					},
					"1.2.410.200004.1.12": {
						d: "pbeWithHAS160AndSEED-CFB",
						c: "Korean SEED algorithm, PBE key derivation"
					},
					"1.2.410.200004.1.13": {
						d: "pbeWithHAS160AndSEED-OFB",
						c: "Korean SEED algorithm, PBE key derivation"
					},
					"1.2.410.200004.1.14": {
						d: "pbeWithSHA1AndSEED-ECB",
						c: "Korean SEED algorithm, PBE key derivation"
					},
					"1.2.410.200004.1.15": {
						d: "pbeWithSHA1AndSEED-CBC",
						c: "Korean SEED algorithm, PBE key derivation"
					},
					"1.2.410.200004.1.16": {
						d: "pbeWithSHA1AndSEED-CFB",
						c: "Korean SEED algorithm, PBE key derivation"
					},
					"1.2.410.200004.1.17": {
						d: "pbeWithSHA1AndSEED-OFB",
						c: "Korean SEED algorithm, PBE key derivation"
					},
					"1.2.410.200004.1.20": {
						d: "rsaWithHAS160",
						c: "Korean signature algorithm"
					},
					"1.2.410.200004.1.21": {
						d: "kcdsa1",
						c: "Korean DSA"
					},
					"1.2.410.200004.2": {
						d: "npkiCP",
						c: "KISA NPKI certificate policies"
					},
					"1.2.410.200004.2.1": {
						d: "npkiSignaturePolicy",
						c: "KISA NPKI certificate policies"
					},
					"1.2.410.200004.3": {
						d: "npkiKP",
						c: "KISA NPKI key usage"
					},
					"1.2.410.200004.4": {
						d: "npkiAT",
						c: "KISA NPKI attribute"
					},
					"1.2.410.200004.5": {
						d: "npkiLCA",
						c: "KISA NPKI licensed CA"
					},
					"1.2.410.200004.5.1": {
						d: "npkiSignKorea",
						c: "KISA NPKI licensed CA"
					},
					"1.2.410.200004.5.2": {
						d: "npkiSignGate",
						c: "KISA NPKI licensed CA"
					},
					"1.2.410.200004.5.3": {
						d: "npkiNcaSign",
						c: "KISA NPKI licensed CA"
					},
					"1.2.410.200004.6": {
						d: "npkiON",
						c: "KISA NPKI otherName"
					},
					"1.2.410.200004.7": {
						d: "npkiAPP",
						c: "KISA NPKI application"
					},
					"1.2.410.200004.7.1": {
						d: "npkiSMIME",
						c: "KISA NPKI application"
					},
					"1.2.410.200004.7.1.1": {
						d: "npkiSMIMEAlgo",
						c: "KISA NPKI application"
					},
					"1.2.410.200004.7.1.1.1": {
						d: "npkiCmsSEEDWrap",
						c: "KISA NPKI application"
					},
					"1.2.410.200004.10": {
						d: "npki",
						c: "KISA NPKI"
					},
					"1.2.410.200004.10.1": {
						d: "npkiAttribute",
						c: "KISA NPKI attribute"
					},
					"1.2.410.200004.10.1.1": {
						d: "npkiIdentifyData",
						c: "KISA NPKI attribute"
					},
					"1.2.410.200004.10.1.1.1": {
						d: "npkiVID",
						c: "KISA NPKI attribute"
					},
					"1.2.410.200004.10.1.1.2": {
						d: "npkiEncryptedVID",
						c: "KISA NPKI attribute"
					},
					"1.2.410.200004.10.1.1.3": {
						d: "npkiRandomNum",
						c: "KISA NPKI attribute"
					},
					"1.2.410.200004.10.1.1.4": {
						d: "npkiVID",
						c: "KISA NPKI attribute"
					},
					"1.2.410.200046.1.1": {
						d: "aria1AlgorithmModes",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.1": {
						d: "aria128-ecb",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.2": {
						d: "aria128-cbc",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.3": {
						d: "aria128-cfb",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.4": {
						d: "aria128-ofb",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.5": {
						d: "aria128-ctr",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.6": {
						d: "aria192-ecb",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.7": {
						d: "aria192-cbc",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.8": {
						d: "aria192-cfb",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.9": {
						d: "aria192-ofb",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.10": {
						d: "aria192-ctr",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.11": {
						d: "aria256-ecb",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.12": {
						d: "aria256-cbc",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.13": {
						d: "aria256-cfb",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.14": {
						d: "aria256-ofb",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.15": {
						d: "aria256-ctr",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.21": {
						d: "aria128-cmac",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.22": {
						d: "aria192-cmac",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.23": {
						d: "aria256-cmac",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.31": {
						d: "aria128-ocb2",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.32": {
						d: "aria192-ocb2",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.33": {
						d: "aria256-ocb2",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.34": {
						d: "aria128-gcm",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.35": {
						d: "aria192-gcm",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.36": {
						d: "aria256-gcm",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.37": {
						d: "aria128-ccm",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.38": {
						d: "aria192-ccm",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.39": {
						d: "aria256-ccm",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.40": {
						d: "aria128-keywrap",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.41": {
						d: "aria192-keywrap",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.42": {
						d: "aria256-keywrap",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.43": {
						d: "aria128-keywrapWithPad",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.44": {
						d: "aria192-keywrapWithPad",
						c: "ARIA algorithm modes"
					},
					"1.2.410.200046.1.1.45": {
						d: "aria256-keywrapWithPad",
						c: "ARIA algorithm modes"
					},
					"1.2.643.2.2.3": {
						d: "gostSignature",
						c: "GOST R 34.10-2001 + GOST R 34.11-94 signature"
					},
					"1.2.643.2.2.4": {
						d: "gost94Signature",
						c: "GOST R 34.10-94 + GOST R 34.11-94 signature. Obsoleted by GOST R 34.10-2001",
						w: !0
					},
					"1.2.643.2.2.19": {
						d: "gostPublicKey",
						c: "GOST R 34.10-2001 (ECC) public key"
					},
					"1.2.643.2.2.20": {
						d: "gost94PublicKey",
						c: "GOST R 34.10-94 public key. Obsoleted by GOST R 34.10-2001",
						w: !0
					},
					"1.2.643.2.2.21": {
						d: "gostCipher",
						c: "GOST 28147-89 (symmetric key block cipher)"
					},
					"1.2.643.2.2.31.0": {
						d: "testCipherParams",
						c: "Test params for GOST 28147-89"
					},
					"1.2.643.2.2.31.1": {
						d: "cryptoProCipherA",
						c: "CryptoPro params A (default, variant 'Verba-O') for GOST 28147-89"
					},
					"1.2.643.2.2.31.2": {
						d: "cryptoProCipherB",
						c: "CryptoPro params B (variant 1) for GOST 28147-89"
					},
					"1.2.643.2.2.31.3": {
						d: "cryptoProCipherC",
						c: "CryptoPro params C (variant 2) for GOST 28147-89"
					},
					"1.2.643.2.2.31.4": {
						d: "cryptoProCipherD",
						c: "CryptoPro params D (variant 3) for GOST 28147-89"
					},
					"1.2.643.2.2.31.5": {
						d: "oscar11Cipher",
						c: "Oscar-1.1 params for GOST 28147-89"
					},
					"1.2.643.2.2.31.6": {
						d: "oscar10Cipher",
						c: "Oscar-1.0 params for GOST 28147-89"
					},
					"1.2.643.2.2.31.7": {
						d: "ric1Cipher",
						c: "RIC-1 params for GOST 28147-89"
					},
					"1.2.643.2.2.31.12": {
						d: "tc26CipherA",
						c: "TC26 params 2 for GOST 28147-89"
					},
					"1.2.643.2.2.31.13": {
						d: "tc26CipherB",
						c: "TC26 params 1 for GOST 28147-89"
					},
					"1.2.643.2.2.31.14": {
						d: "tc26CipherC",
						c: "TC26 params 3 for GOST 28147-89"
					},
					"1.2.643.2.2.31.15": {
						d: "tc26CipherD",
						c: "TC26 params 4 for GOST 28147-89"
					},
					"1.2.643.2.2.31.16": {
						d: "tc26CipherE",
						c: "TC26 params 5 for GOST 28147-89"
					},
					"1.2.643.2.2.31.17": {
						d: "tc26CipherF",
						c: "TC26 params 6 for GOST 28147-89"
					},
					"1.2.643.7.1.2.5.1.1": {
						d: "tc26CipherZ",
						c: "TC26 params Z for GOST 28147-89"
					},
					"1.2.643.2.2.9": {
						d: "gostDigest",
						c: "GOST R 34.11-94 digest"
					},
					"1.2.643.2.2.30.0": {
						d: "testDigestParams",
						c: "Test params for GOST R 34.11-94"
					},
					"1.2.643.2.2.30.1": {
						d: "cryptoProDigestA",
						c: "CryptoPro digest params A (default, variant 'Verba-O') for GOST R 34.11-94"
					},
					"1.2.643.2.2.30.2": {
						d: "cryptoProDigestB",
						c: "CryptoPro digest params B (variant 1) for GOST R 34.11-94"
					},
					"1.2.643.2.2.30.3": {
						d: "cryptoProDigestC",
						c: "CryptoPro digest params C (variant 2) for GOST R 34.11-94"
					},
					"1.2.643.2.2.30.4": {
						d: "cryptoProDigestD",
						c: "CryptoPro digest params D (variant 3) for GOST R 34.11-94"
					},
					"1.2.643.2.2.32.2": {
						d: "cryptoPro94SignA",
						c: "CryptoPro sign params A (default, variant 'Verba-O') for GOST R 34.10-94"
					},
					"1.2.643.2.2.32.3": {
						d: "cryptoPro94SignB",
						c: "CryptoPro sign params B (variant 1) for GOST R 34.10-94"
					},
					"1.2.643.2.2.32.4": {
						d: "cryptoPro94SignC",
						c: "CryptoPro sign params C (variant 2) for GOST R 34.10-94"
					},
					"1.2.643.2.2.32.5": {
						d: "cryptoPro94SignD",
						c: "CryptoPro sign params D (variant 3) for GOST R 34.10-94"
					},
					"1.2.643.2.2.33.1": {
						d: "cryptoPro94SignXA",
						c: "CryptoPro sign params XA (variant 1) for GOST R 34.10-94"
					},
					"1.2.643.2.2.33.2": {
						d: "cryptoPro94SignXB",
						c: "CryptoPro sign params XB (variant 2) for GOST R 34.10-94"
					},
					"1.2.643.2.2.33.3": {
						d: "cryptoPro94SignXC",
						c: "CryptoPro sign params XC (variant 3) for GOST R 34.10-94"
					},
					"1.2.643.2.2.35.0": {
						d: "testSignParams",
						c: "Test elliptic curve for GOST R 34.10-2001"
					},
					"1.2.643.2.2.35.1": {
						d: "cryptoProSignA",
						c: "CryptoPro ell.curve A for GOST R 34.10-2001"
					},
					"1.2.643.2.2.35.2": {
						d: "cryptoProSignB",
						c: "CryptoPro ell.curve B for GOST R 34.10-2001"
					},
					"1.2.643.2.2.35.3": {
						d: "cryptoProSignC",
						c: "CryptoPro ell.curve C for GOST R 34.10-2001"
					},
					"1.2.643.2.2.36.0": {
						d: "cryptoProSignXA",
						c: "CryptoPro ell.curve XA for GOST R 34.10-2001"
					},
					"1.2.643.2.2.36.1": {
						d: "cryptoProSignXB",
						c: "CryptoPro ell.curve XB for GOST R 34.10-2001"
					},
					"1.2.643.7.1.2.1.1.1": {
						d: "cryptoPro2012Sign256A",
						c: "CryptoPro ell.curve A for GOST R 34.10-2012 256 bit"
					},
					"1.2.643.7.1.2.1.2.1": {
						d: "cryptoPro2012Sign512A",
						c: "CryptoPro ell.curve A (default) for GOST R 34.10-2012 512 bit"
					},
					"1.2.643.7.1.2.1.2.2": {
						d: "cryptoPro2012Sign512B",
						c: "CryptoPro ell.curve B for GOST R 34.10-2012 512 bit"
					},
					"1.2.643.7.1.2.1.2.3": {
						d: "cryptoPro2012Sign512C",
						c: "CryptoPro ell.curve C for GOST R 34.10-2012 512 bit"
					},
					"1.2.643.2.2.14.0": {
						d: "nullMeshing",
						c: "Do not mesh state of GOST 28147-89 cipher"
					},
					"1.2.643.2.2.14.1": {
						d: "cryptoProMeshing",
						c: "CryptoPro meshing of state of GOST 28147-89 cipher"
					},
					"1.2.643.2.2.10": {
						d: "hmacGost",
						c: "HMAC with GOST R 34.11-94"
					},
					"1.2.643.2.2.13.0": {
						d: "gostWrap",
						c: "Wrap key using GOST 28147-89 key"
					},
					"1.2.643.2.2.13.1": {
						d: "cryptoProWrap",
						c: "Wrap key using diversified GOST 28147-89 key"
					},
					"1.2.643.2.2.96": {
						d: "cryptoProECDHWrap",
						c: "Wrap key using ECC DH on GOST R 34.10-2001 keys (VKO)"
					},
					"1.2.643.7.1.1.1.1": {
						d: "gost2012PublicKey256",
						c: "GOST R 34.10-2012 256 bit public key"
					},
					"1.2.643.7.1.1.1.2": {
						d: "gost2012PublicKey512",
						c: "GOST R 34.10-2012 512 bit public key"
					},
					"1.2.643.7.1.1.2.2": {
						d: "gost2012Digest256",
						c: "GOST R 34.11-2012 256 bit digest"
					},
					"1.2.643.7.1.1.2.3": {
						d: "gost2012Digest512",
						c: "GOST R 34.11-2012 512 bit digest"
					},
					"1.2.643.7.1.1.3.2": {
						d: "gost2012Signature256",
						c: "GOST R 34.10-2012 256 bit signature"
					},
					"1.2.643.7.1.1.3.3": {
						d: "gost2012Signature512",
						c: "GOST R 34.10-2012 512 bit signature"
					},
					"1.2.643.7.1.1.6.1": {
						d: "cryptoProECDH256",
						c: "CryptoPro ECC DH algorithm for GOST R 34.10-2012 256 bit key"
					},
					"1.2.643.7.1.1.6.2": {
						d: "cryptoProECDH512",
						c: "CryptoPro ECC DH algorithm for GOST R 34.10-2012 512 bit key"
					},
					"1.2.752.34.1": {
						d: "seis-cp",
						c: "SEIS Project"
					},
					"1.2.752.34.1.1": {
						d: "SEIS high-assurance policyIdentifier",
						c: "SEIS Project certificate policies"
					},
					"1.2.752.34.1.2": {
						d: "SEIS GAK policyIdentifier",
						c: "SEIS Project certificate policies"
					},
					"1.2.752.34.2": {
						d: "SEIS pe",
						c: "SEIS Project"
					},
					"1.2.752.34.3": {
						d: "SEIS at",
						c: "SEIS Project"
					},
					"1.2.752.34.3.1": {
						d: "SEIS at-personalIdentifier",
						c: "SEIS Project attribute"
					},
					"1.2.840.10040.1": {
						d: "module",
						c: "ANSI X9.57"
					},
					"1.2.840.10040.1.1": {
						d: "x9f1-cert-mgmt",
						c: "ANSI X9.57 module"
					},
					"1.2.840.10040.2": {
						d: "holdinstruction",
						c: "ANSI X9.57"
					},
					"1.2.840.10040.2.1": {
						d: "holdinstruction-none",
						c: "ANSI X9.57 hold instruction"
					},
					"1.2.840.10040.2.2": {
						d: "callissuer",
						c: "ANSI X9.57 hold instruction"
					},
					"1.2.840.10040.2.3": {
						d: "reject",
						c: "ANSI X9.57 hold instruction"
					},
					"1.2.840.10040.2.4": {
						d: "pickupToken",
						c: "ANSI X9.57 hold instruction"
					},
					"1.2.840.10040.3": {
						d: "attribute",
						c: "ANSI X9.57"
					},
					"1.2.840.10040.3.1": {
						d: "countersignature",
						c: "ANSI X9.57 attribute"
					},
					"1.2.840.10040.3.2": {
						d: "attribute-cert",
						c: "ANSI X9.57 attribute"
					},
					"1.2.840.10040.4": {
						d: "algorithm",
						c: "ANSI X9.57"
					},
					"1.2.840.10040.4.1": {
						d: "dsa",
						c: "ANSI X9.57 algorithm"
					},
					"1.2.840.10040.4.2": {
						d: "dsa-match",
						c: "ANSI X9.57 algorithm"
					},
					"1.2.840.10040.4.3": {
						d: "dsaWithSha1",
						c: "ANSI X9.57 algorithm"
					},
					"1.2.840.10045.1": {
						d: "fieldType",
						c: "ANSI X9.62. This OID is also assigned as ecdsa-with-SHA1"
					},
					"1.2.840.10045.1.1": {
						d: "prime-field",
						c: "ANSI X9.62 field type"
					},
					"1.2.840.10045.1.2": {
						d: "characteristic-two-field",
						c: "ANSI X9.62 field type"
					},
					"1.2.840.10045.1.2.3": {
						d: "characteristic-two-basis",
						c: "ANSI X9.62 field type"
					},
					"1.2.840.10045.1.2.3.1": {
						d: "onBasis",
						c: "ANSI X9.62 field basis"
					},
					"1.2.840.10045.1.2.3.2": {
						d: "tpBasis",
						c: "ANSI X9.62 field basis"
					},
					"1.2.840.10045.1.2.3.3": {
						d: "ppBasis",
						c: "ANSI X9.62 field basis"
					},
					"1.2.840.10045.2": {
						d: "publicKeyType",
						c: "ANSI X9.62"
					},
					"1.2.840.10045.2.1": {
						d: "ecPublicKey",
						c: "ANSI X9.62 public key type"
					},
					"1.2.840.10045.3.0.1": {
						d: "c2pnb163v1",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.0.2": {
						d: "c2pnb163v2",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.0.3": {
						d: "c2pnb163v3",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.0.5": {
						d: "c2tnb191v1",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.0.6": {
						d: "c2tnb191v2",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.0.7": {
						d: "c2tnb191v3",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.0.10": {
						d: "c2pnb208w1",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.0.11": {
						d: "c2tnb239v1",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.0.12": {
						d: "c2tnb239v2",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.0.13": {
						d: "c2tnb239v3",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.0.16": {
						d: "c2pnb272w1",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.0.18": {
						d: "c2tnb359v1",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.0.19": {
						d: "c2pnb368w1",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.0.20": {
						d: "c2tnb431r1",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.1.1": {
						d: "prime192v1",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.1.2": {
						d: "prime192v2",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.1.3": {
						d: "prime192v3",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.1.4": {
						d: "prime239v1",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.1.5": {
						d: "prime239v2",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.1.6": {
						d: "prime239v3",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.3.1.7": {
						d: "prime256v1",
						c: "ANSI X9.62 named elliptic curve"
					},
					"1.2.840.10045.4.1": {
						d: "ecdsaWithSHA1",
						c: "ANSI X9.62 ECDSA algorithm with SHA1"
					},
					"1.2.840.10045.4.2": {
						d: "ecdsaWithRecommended",
						c: "ANSI X9.62 ECDSA algorithm with Recommended"
					},
					"1.2.840.10045.4.3": {
						d: "ecdsaWithSpecified",
						c: "ANSI X9.62 ECDSA algorithm with Specified"
					},
					"1.2.840.10045.4.3.1": {
						d: "ecdsaWithSHA224",
						c: "ANSI X9.62 ECDSA algorithm with SHA224"
					},
					"1.2.840.10045.4.3.2": {
						d: "ecdsaWithSHA256",
						c: "ANSI X9.62 ECDSA algorithm with SHA256"
					},
					"1.2.840.10045.4.3.3": {
						d: "ecdsaWithSHA384",
						c: "ANSI X9.62 ECDSA algorithm with SHA384"
					},
					"1.2.840.10045.4.3.4": {
						d: "ecdsaWithSHA512",
						c: "ANSI X9.62 ECDSA algorithm with SHA512"
					},
					"1.2.840.10046.1": {
						d: "fieldType",
						c: "ANSI X9.42"
					},
					"1.2.840.10046.1.1": {
						d: "gf-prime",
						c: "ANSI X9.42 field type"
					},
					"1.2.840.10046.2": {
						d: "numberType",
						c: "ANSI X9.42"
					},
					"1.2.840.10046.2.1": {
						d: "dhPublicKey",
						c: "ANSI X9.42 number type"
					},
					"1.2.840.10046.3": {
						d: "scheme",
						c: "ANSI X9.42"
					},
					"1.2.840.10046.3.1": {
						d: "dhStatic",
						c: "ANSI X9.42 scheme"
					},
					"1.2.840.10046.3.2": {
						d: "dhEphem",
						c: "ANSI X9.42 scheme"
					},
					"1.2.840.10046.3.3": {
						d: "dhHybrid1",
						c: "ANSI X9.42 scheme"
					},
					"1.2.840.10046.3.4": {
						d: "dhHybrid2",
						c: "ANSI X9.42 scheme"
					},
					"1.2.840.10046.3.5": {
						d: "mqv2",
						c: "ANSI X9.42 scheme"
					},
					"1.2.840.10046.3.6": {
						d: "mqv1",
						c: "ANSI X9.42 scheme"
					},
					"1.2.840.10065.2.2": {
						d: "?",
						c: "ASTM 31.20"
					},
					"1.2.840.10065.2.3": {
						d: "healthcareLicense",
						c: "ASTM 31.20"
					},
					"1.2.840.10065.2.3.1.1": {
						d: "license?",
						c: "ASTM 31.20 healthcare license type"
					},
					"1.2.840.10070": {
						d: "iec62351",
						c: "IEC 62351"
					},
					"1.2.840.10070.8": {
						d: "iec62351_8",
						c: "IEC 62351-8"
					},
					"1.2.840.10070.8.1": {
						d: "iecUserRoles",
						c: "IEC 62351-8"
					},
					"1.2.840.113533.7": {
						d: "nsn",
						c: ""
					},
					"1.2.840.113533.7.65": {
						d: "nsn-ce",
						c: ""
					},
					"1.2.840.113533.7.65.0": {
						d: "entrustVersInfo",
						c: "Nortel Secure Networks ce"
					},
					"1.2.840.113533.7.66": {
						d: "nsn-alg",
						c: ""
					},
					"1.2.840.113533.7.66.3": {
						d: "cast3CBC",
						c: "Nortel Secure Networks alg"
					},
					"1.2.840.113533.7.66.10": {
						d: "cast5CBC",
						c: "Nortel Secure Networks alg"
					},
					"1.2.840.113533.7.66.11": {
						d: "cast5MAC",
						c: "Nortel Secure Networks alg"
					},
					"1.2.840.113533.7.66.12": {
						d: "pbeWithMD5AndCAST5-CBC",
						c: "Nortel Secure Networks alg"
					},
					"1.2.840.113533.7.66.13": {
						d: "passwordBasedMac",
						c: "Nortel Secure Networks alg"
					},
					"1.2.840.113533.7.67": {
						d: "nsn-oc",
						c: ""
					},
					"1.2.840.113533.7.67.0": {
						d: "entrustUser",
						c: "Nortel Secure Networks oc"
					},
					"1.2.840.113533.7.68": {
						d: "nsn-at",
						c: ""
					},
					"1.2.840.113533.7.68.0": {
						d: "entrustCAInfo",
						c: "Nortel Secure Networks at"
					},
					"1.2.840.113533.7.68.10": {
						d: "attributeCertificate",
						c: "Nortel Secure Networks at"
					},
					"1.2.840.113549.1.1": {
						d: "pkcs-1",
						c: ""
					},
					"1.2.840.113549.1.1.1": {
						d: "rsaEncryption",
						c: "PKCS #1"
					},
					"1.2.840.113549.1.1.2": {
						d: "md2WithRSAEncryption",
						c: "PKCS #1"
					},
					"1.2.840.113549.1.1.3": {
						d: "md4WithRSAEncryption",
						c: "PKCS #1"
					},
					"1.2.840.113549.1.1.4": {
						d: "md5WithRSAEncryption",
						c: "PKCS #1"
					},
					"1.2.840.113549.1.1.5": {
						d: "sha1WithRSAEncryption",
						c: "PKCS #1"
					},
					"1.2.840.113549.1.1.7": {
						d: "rsaOAEP",
						c: "PKCS #1"
					},
					"1.2.840.113549.1.1.8": {
						d: "pkcs1-MGF",
						c: "PKCS #1"
					},
					"1.2.840.113549.1.1.9": {
						d: "rsaOAEP-pSpecified",
						c: "PKCS #1"
					},
					"1.2.840.113549.1.1.10": {
						d: "rsaPSS",
						c: "PKCS #1"
					},
					"1.2.840.113549.1.1.11": {
						d: "sha256WithRSAEncryption",
						c: "PKCS #1"
					},
					"1.2.840.113549.1.1.12": {
						d: "sha384WithRSAEncryption",
						c: "PKCS #1"
					},
					"1.2.840.113549.1.1.13": {
						d: "sha512WithRSAEncryption",
						c: "PKCS #1"
					},
					"1.2.840.113549.1.1.14": {
						d: "sha224WithRSAEncryption",
						c: "PKCS #1"
					},
					"1.2.840.113549.1.1.6": {
						d: "rsaOAEPEncryptionSET",
						c: "PKCS #1. This OID may also be assigned as ripemd160WithRSAEncryption"
					},
					"1.2.840.113549.1.2": {
						d: "bsafeRsaEncr",
						c: "Obsolete BSAFE OID",
						w: !0
					},
					"1.2.840.113549.1.3": {
						d: "pkcs-3",
						c: ""
					},
					"1.2.840.113549.1.3.1": {
						d: "dhKeyAgreement",
						c: "PKCS #3"
					},
					"1.2.840.113549.1.5": {
						d: "pkcs-5",
						c: ""
					},
					"1.2.840.113549.1.5.1": {
						d: "pbeWithMD2AndDES-CBC",
						c: "PKCS #5"
					},
					"1.2.840.113549.1.5.3": {
						d: "pbeWithMD5AndDES-CBC",
						c: "PKCS #5"
					},
					"1.2.840.113549.1.5.4": {
						d: "pbeWithMD2AndRC2-CBC",
						c: "PKCS #5"
					},
					"1.2.840.113549.1.5.6": {
						d: "pbeWithMD5AndRC2-CBC",
						c: "PKCS #5"
					},
					"1.2.840.113549.1.5.9": {
						d: "pbeWithMD5AndXOR",
						c: "PKCS #5, used in BSAFE only",
						w: !0
					},
					"1.2.840.113549.1.5.10": {
						d: "pbeWithSHAAndDES-CBC",
						c: "PKCS #5"
					},
					"1.2.840.113549.1.5.12": {
						d: "pkcs5PBKDF2",
						c: "PKCS #5 v2.0"
					},
					"1.2.840.113549.1.5.13": {
						d: "pkcs5PBES2",
						c: "PKCS #5 v2.0"
					},
					"1.2.840.113549.1.5.14": {
						d: "pkcs5PBMAC1",
						c: "PKCS #5 v2.0"
					},
					"1.2.840.113549.1.7": {
						d: "pkcs-7",
						c: ""
					},
					"1.2.840.113549.1.7.1": {
						d: "data",
						c: "PKCS #7"
					},
					"1.2.840.113549.1.7.2": {
						d: "signedData",
						c: "PKCS #7"
					},
					"1.2.840.113549.1.7.3": {
						d: "envelopedData",
						c: "PKCS #7"
					},
					"1.2.840.113549.1.7.4": {
						d: "signedAndEnvelopedData",
						c: "PKCS #7"
					},
					"1.2.840.113549.1.7.5": {
						d: "digestedData",
						c: "PKCS #7"
					},
					"1.2.840.113549.1.7.6": {
						d: "encryptedData",
						c: "PKCS #7"
					},
					"1.2.840.113549.1.7.7": {
						d: "dataWithAttributes",
						c: "PKCS #7 experimental",
						w: !0
					},
					"1.2.840.113549.1.7.8": {
						d: "encryptedPrivateKeyInfo",
						c: "PKCS #7 experimental",
						w: !0
					},
					"1.2.840.113549.1.9": {
						d: "pkcs-9",
						c: ""
					},
					"1.2.840.113549.1.9.1": {
						d: "emailAddress",
						c: "PKCS #9. Deprecated, use an altName extension instead"
					},
					"1.2.840.113549.1.9.2": {
						d: "unstructuredName",
						c: "PKCS #9"
					},
					"1.2.840.113549.1.9.3": {
						d: "contentType",
						c: "PKCS #9"
					},
					"1.2.840.113549.1.9.4": {
						d: "messageDigest",
						c: "PKCS #9"
					},
					"1.2.840.113549.1.9.5": {
						d: "signingTime",
						c: "PKCS #9"
					},
					"1.2.840.113549.1.9.6": {
						d: "countersignature",
						c: "PKCS #9"
					},
					"1.2.840.113549.1.9.7": {
						d: "challengePassword",
						c: "PKCS #9"
					},
					"1.2.840.113549.1.9.8": {
						d: "unstructuredAddress",
						c: "PKCS #9"
					},
					"1.2.840.113549.1.9.9": {
						d: "extendedCertificateAttributes",
						c: "PKCS #9"
					},
					"1.2.840.113549.1.9.10": {
						d: "issuerAndSerialNumber",
						c: "PKCS #9 experimental",
						w: !0
					},
					"1.2.840.113549.1.9.11": {
						d: "passwordCheck",
						c: "PKCS #9 experimental",
						w: !0
					},
					"1.2.840.113549.1.9.12": {
						d: "publicKey",
						c: "PKCS #9 experimental",
						w: !0
					},
					"1.2.840.113549.1.9.13": {
						d: "signingDescription",
						c: "PKCS #9"
					},
					"1.2.840.113549.1.9.14": {
						d: "extensionRequest",
						c: "PKCS #9 via CRMF"
					},
					"1.2.840.113549.1.9.15": {
						d: "sMIMECapabilities",
						c: "PKCS #9. This OID was formerly assigned as symmetricCapabilities, then reassigned as SMIMECapabilities, then renamed to the current name"
					},
					"1.2.840.113549.1.9.15.1": {
						d: "preferSignedData",
						c: "sMIMECapabilities"
					},
					"1.2.840.113549.1.9.15.2": {
						d: "canNotDecryptAny",
						c: "sMIMECapabilities"
					},
					"1.2.840.113549.1.9.15.3": {
						d: "receiptRequest",
						c: "sMIMECapabilities. Deprecated, use (1 2 840 113549 1 9 16 2 1) instead",
						w: !0
					},
					"1.2.840.113549.1.9.15.4": {
						d: "receipt",
						c: "sMIMECapabilities. Deprecated, use (1 2 840 113549 1 9 16 1 1) instead",
						w: !0
					},
					"1.2.840.113549.1.9.15.5": {
						d: "contentHints",
						c: "sMIMECapabilities. Deprecated, use (1 2 840 113549 1 9 16 2 4) instead",
						w: !0
					},
					"1.2.840.113549.1.9.15.6": {
						d: "mlExpansionHistory",
						c: "sMIMECapabilities. Deprecated, use (1 2 840 113549 1 9 16 2 3) instead",
						w: !0
					},
					"1.2.840.113549.1.9.16": {
						d: "id-sMIME",
						c: "PKCS #9"
					},
					"1.2.840.113549.1.9.16.0": {
						d: "id-mod",
						c: "id-sMIME"
					},
					"1.2.840.113549.1.9.16.0.1": {
						d: "id-mod-cms",
						c: "S/MIME Modules"
					},
					"1.2.840.113549.1.9.16.0.2": {
						d: "id-mod-ess",
						c: "S/MIME Modules"
					},
					"1.2.840.113549.1.9.16.0.3": {
						d: "id-mod-oid",
						c: "S/MIME Modules"
					},
					"1.2.840.113549.1.9.16.0.4": {
						d: "id-mod-msg-v3",
						c: "S/MIME Modules"
					},
					"1.2.840.113549.1.9.16.0.5": {
						d: "id-mod-ets-eSignature-88",
						c: "S/MIME Modules"
					},
					"1.2.840.113549.1.9.16.0.6": {
						d: "id-mod-ets-eSignature-97",
						c: "S/MIME Modules"
					},
					"1.2.840.113549.1.9.16.0.7": {
						d: "id-mod-ets-eSigPolicy-88",
						c: "S/MIME Modules"
					},
					"1.2.840.113549.1.9.16.0.8": {
						d: "id-mod-ets-eSigPolicy-88",
						c: "S/MIME Modules"
					},
					"1.2.840.113549.1.9.16.1": {
						d: "contentType",
						c: "S/MIME"
					},
					"1.2.840.113549.1.9.16.1.0": {
						d: "anyContentType",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.1": {
						d: "receipt",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.2": {
						d: "authData",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.3": {
						d: "publishCert",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.4": {
						d: "tSTInfo",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.5": {
						d: "tDTInfo",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.6": {
						d: "contentInfo",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.7": {
						d: "dVCSRequestData",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.8": {
						d: "dVCSResponseData",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.9": {
						d: "compressedData",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.10": {
						d: "scvpCertValRequest",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.11": {
						d: "scvpCertValResponse",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.12": {
						d: "scvpValPolRequest",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.13": {
						d: "scvpValPolResponse",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.14": {
						d: "attrCertEncAttrs",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.15": {
						d: "tSReq",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.16": {
						d: "firmwarePackage",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.17": {
						d: "firmwareLoadReceipt",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.18": {
						d: "firmwareLoadError",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.19": {
						d: "contentCollection",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.20": {
						d: "contentWithAttrs",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.21": {
						d: "encKeyWithID",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.22": {
						d: "encPEPSI",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.23": {
						d: "authEnvelopedData",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.24": {
						d: "routeOriginAttest",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.25": {
						d: "symmetricKeyPackage",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.26": {
						d: "rpkiManifest",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.27": {
						d: "asciiTextWithCRLF",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.28": {
						d: "xml",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.29": {
						d: "pdf",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.30": {
						d: "postscript",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.31": {
						d: "timestampedData",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.32": {
						d: "asAdjacencyAttest",
						c: "S/MIME Content Types",
						w: !0
					},
					"1.2.840.113549.1.9.16.1.33": {
						d: "rpkiTrustAnchor",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.34": {
						d: "trustAnchorList",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.35": {
						d: "rpkiGhostbusters",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.36": {
						d: "resourceTaggedAttest",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.37": {
						d: "utf8TextWithCRLF",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.38": {
						d: "htmlWithCRLF",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.39": {
						d: "epub",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.40": {
						d: "animaJSONVoucher",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.41": {
						d: "mudType",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.42": {
						d: "sztpConveyedInfoXML",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.43": {
						d: "sztpConveyedInfoJSON",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.44": {
						d: "cbor",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.45": {
						d: "cborSequence",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.1.46": {
						d: "animaCBORVoucher",
						c: "S/MIME Content Types",
						w: !0
					},
					"1.2.840.113549.1.9.16.1.47": {
						d: "geofeedCSVwithCRLF",
						c: "S/MIME Content Types"
					},
					"1.2.840.113549.1.9.16.2": {
						d: "authenticatedAttributes",
						c: "S/MIME"
					},
					"1.2.840.113549.1.9.16.2.1": {
						d: "receiptRequest",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.2": {
						d: "securityLabel",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.3": {
						d: "mlExpandHistory",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.4": {
						d: "contentHint",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.5": {
						d: "msgSigDigest",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.6": {
						d: "encapContentType",
						c: "S/MIME Authenticated Attributes.  Obsolete",
						w: !0
					},
					"1.2.840.113549.1.9.16.2.7": {
						d: "contentIdentifier",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.8": {
						d: "macValue",
						c: "S/MIME Authenticated Attributes.  Obsolete",
						w: !0
					},
					"1.2.840.113549.1.9.16.2.9": {
						d: "equivalentLabels",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.10": {
						d: "contentReference",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.11": {
						d: "encrypKeyPref",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.12": {
						d: "signingCertificate",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.13": {
						d: "smimeEncryptCerts",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.14": {
						d: "timeStampToken",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.15": {
						d: "sigPolicyId",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.16": {
						d: "commitmentType",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.17": {
						d: "signerLocation",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.18": {
						d: "signerAttr",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.19": {
						d: "otherSigCert",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.20": {
						d: "contentTimestamp",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.21": {
						d: "certificateRefs",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.22": {
						d: "revocationRefs",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.23": {
						d: "certValues",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.24": {
						d: "revocationValues",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.25": {
						d: "escTimeStamp",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.26": {
						d: "certCRLTimestamp",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.27": {
						d: "archiveTimeStamp",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.28": {
						d: "signatureType",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.29": {
						d: "dvcsDvc",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.30": {
						d: "cekReference",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.31": {
						d: "maxCEKDecrypts",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.32": {
						d: "kekDerivationAlg",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.33": {
						d: "intendedRecipients",
						c: "S/MIME Authenticated Attributes.  Obsolete",
						w: !0
					},
					"1.2.840.113549.1.9.16.2.34": {
						d: "cmcUnsignedData",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.35": {
						d: "fwPackageID",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.36": {
						d: "fwTargetHardwareIDs",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.37": {
						d: "fwDecryptKeyID",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.38": {
						d: "fwImplCryptAlgs",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.39": {
						d: "fwWrappedFirmwareKey",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.40": {
						d: "fwCommunityIdentifiers",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.41": {
						d: "fwPkgMessageDigest",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.42": {
						d: "fwPackageInfo",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.43": {
						d: "fwImplCompressAlgs",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.44": {
						d: "etsAttrCertificateRefs",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.45": {
						d: "etsAttrRevocationRefs",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.46": {
						d: "binarySigningTime",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.47": {
						d: "signingCertificateV2",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.48": {
						d: "etsArchiveTimeStampV2",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.49": {
						d: "erInternal",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.50": {
						d: "erExternal",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.51": {
						d: "multipleSignatures",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.52": {
						d: "cmsAlgorithmProtect",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.53": {
						d: "setKeyInformation",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.54": {
						d: "asymmDecryptKeyID",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.55": {
						d: "secureHeaderFieldsIdentifier",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.56": {
						d: "otpChallenge",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.57": {
						d: "revocationChallenge",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.2.58": {
						d: "estIdentityLinking",
						c: "S/MIME Authenticated Attributes"
					},
					"1.2.840.113549.1.9.16.3.1": {
						d: "esDHwith3DES",
						c: "S/MIME Algorithms. Obsolete",
						w: !0
					},
					"1.2.840.113549.1.9.16.3.2": {
						d: "esDHwithRC2",
						c: "S/MIME Algorithms. Obsolete",
						w: !0
					},
					"1.2.840.113549.1.9.16.3.3": {
						d: "3desWrap",
						c: "S/MIME Algorithms. Obsolete",
						w: !0
					},
					"1.2.840.113549.1.9.16.3.4": {
						d: "rc2Wrap",
						c: "S/MIME Algorithms. Obsolete",
						w: !0
					},
					"1.2.840.113549.1.9.16.3.5": {
						d: "esDH",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.6": {
						d: "cms3DESwrap",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.7": {
						d: "cmsRC2wrap",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.8": {
						d: "zlib",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.9": {
						d: "pwriKEK",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.10": {
						d: "ssDH",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.11": {
						d: "hmacWith3DESwrap",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.12": {
						d: "hmacWithAESwrap",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.13": {
						d: "md5XorExperiment",
						c: "S/MIME Algorithms.  Experimental",
						w: !0
					},
					"1.2.840.113549.1.9.16.3.14": {
						d: "rsaKEM",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.15": {
						d: "authEnc128",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.16": {
						d: "authEnc256",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.17": {
						d: "hssLmsHashSig",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.18": {
						d: "chaCha20Poly1305",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.19": {
						d: "ecdhHKDF-SHA256",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.20": {
						d: "ecdhHKDF-SHA384",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.21": {
						d: "ecdhHKDF-SHA512",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.22": {
						d: "aesSIV-CMAC-256",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.23": {
						d: "aesSIV-CMAC-384",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.24": {
						d: "aesSIV-CMAC-512",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.25": {
						d: "aesSIV-CMAC-wrap256",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.26": {
						d: "aesSIV-CMAC-wrap384",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.27": {
						d: "aesSIV-CMAC-wrap512",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.28": {
						d: "hkdfWithSha256",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.29": {
						d: "hkdfWithSha384",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.3.30": {
						d: "hkdfWithSha512",
						c: "S/MIME Algorithms"
					},
					"1.2.840.113549.1.9.16.4.1": {
						d: "certDist-ldap",
						c: "S/MIME Certificate Distribution"
					},
					"1.2.840.113549.1.9.16.5.1": {
						d: "sigPolicyQualifier-spuri x",
						c: "S/MIME Signature Policy Qualifiers"
					},
					"1.2.840.113549.1.9.16.5.2": {
						d: "sigPolicyQualifier-spUserNotice",
						c: "S/MIME Signature Policy Qualifiers"
					},
					"1.2.840.113549.1.9.16.6.1": {
						d: "proofOfOrigin",
						c: "S/MIME Commitment Type Identifiers"
					},
					"1.2.840.113549.1.9.16.6.2": {
						d: "proofOfReceipt",
						c: "S/MIME Commitment Type Identifiers"
					},
					"1.2.840.113549.1.9.16.6.3": {
						d: "proofOfDelivery",
						c: "S/MIME Commitment Type Identifiers"
					},
					"1.2.840.113549.1.9.16.6.4": {
						d: "proofOfSender",
						c: "S/MIME Commitment Type Identifiers"
					},
					"1.2.840.113549.1.9.16.6.5": {
						d: "proofOfApproval",
						c: "S/MIME Commitment Type Identifiers"
					},
					"1.2.840.113549.1.9.16.6.6": {
						d: "proofOfCreation",
						c: "S/MIME Commitment Type Identifiers"
					},
					"1.2.840.113549.1.9.16.7.1": {
						d: "testAmoco",
						c: "S/MIMETest Security Policies"
					},
					"1.2.840.113549.1.9.16.7.2": {
						d: "testCaterpillar",
						c: "S/MIMETest Security Policies"
					},
					"1.2.840.113549.1.9.16.7.3": {
						d: "testWhirlpool",
						c: "S/MIMETest Security Policies"
					},
					"1.2.840.113549.1.9.16.7.4": {
						d: "testWhirlpoolCategories",
						c: "S/MIMETest Security Policies"
					},
					"1.2.840.113549.1.9.16.8.1": {
						d: "glUseKEK",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.8.2": {
						d: "glDelete",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.8.3": {
						d: "glAddMember",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.8.4": {
						d: "glDeleteMember",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.8.5": {
						d: "glRekey",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.8.6": {
						d: "glAddOwner",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.8.7": {
						d: "glRemoveOwner",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.8.8": {
						d: "glkCompromise",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.8.9": {
						d: "glkRefresh",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.8.10": {
						d: "glFailInfo",
						c: "S/MIME Symmetric Key Distribution Attributes.  Obsolete",
						w: !0
					},
					"1.2.840.113549.1.9.16.8.11": {
						d: "glaQueryRequest",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.8.12": {
						d: "glaQueryResponse",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.8.13": {
						d: "glProvideCert",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.8.14": {
						d: "glUpdateCert",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.8.15": {
						d: "glKey",
						c: "S/MIME Symmetric Key Distribution Attributes"
					},
					"1.2.840.113549.1.9.16.9": {
						d: "signatureTypeIdentifier",
						c: "S/MIME"
					},
					"1.2.840.113549.1.9.16.9.1": {
						d: "originatorSig",
						c: "S/MIME Signature Type Identifier"
					},
					"1.2.840.113549.1.9.16.9.2": {
						d: "domainSig",
						c: "S/MIME Signature Type Identifier"
					},
					"1.2.840.113549.1.9.16.9.3": {
						d: "additionalAttributesSig",
						c: "S/MIME Signature Type Identifier"
					},
					"1.2.840.113549.1.9.16.9.4": {
						d: "reviewSig",
						c: "S/MIME Signature Type Identifier"
					},
					"1.2.840.113549.1.9.16.10.1": {
						d: "envelopedData",
						c: "S/MIME X.400 Encoded Information Types"
					},
					"1.2.840.113549.1.9.16.10.2": {
						d: "signedData",
						c: "S/MIME X.400 Encoded Information Types"
					},
					"1.2.840.113549.1.9.16.10.3": {
						d: "certsOnly",
						c: "S/MIME X.400 Encoded Information Types"
					},
					"1.2.840.113549.1.9.16.10.4": {
						d: "signedReceipt",
						c: "S/MIME X.400 Encoded Information Types"
					},
					"1.2.840.113549.1.9.16.10.5": {
						d: "envelopedX400",
						c: "S/MIME X.400 Encoded Information Types"
					},
					"1.2.840.113549.1.9.16.10.6": {
						d: "signedX400",
						c: "S/MIME X.400 Encoded Information Types"
					},
					"1.2.840.113549.1.9.16.10.7": {
						d: "compressedData",
						c: "S/MIME X.400 Encoded Information Types"
					},
					"1.2.840.113549.1.9.16.11": {
						d: "capabilities",
						c: "S/MIME"
					},
					"1.2.840.113549.1.9.16.11.1": {
						d: "preferBinaryInside",
						c: "S/MIME Capability"
					},
					"1.2.840.113549.1.9.16.12": {
						d: "pskcAttributes",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.1": {
						d: "pskcManufacturer",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.2": {
						d: "pskcSerialNo",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.3": {
						d: "pskcModel",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.4": {
						d: "pskcIssueno",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.5": {
						d: "pskcDevicebinding",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.6": {
						d: "pskcDevicestartdate",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.7": {
						d: "pskcDeviceexpirydate",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.8": {
						d: "pskcModuleid",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.9": {
						d: "pskcKeyid",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.10": {
						d: "pskcAlgorithm",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.11": {
						d: "pskcIssuer",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.12": {
						d: "pskcKeyprofileid",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.13": {
						d: "pskcKeyreference",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.14": {
						d: "pskcFriendlyname",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.15": {
						d: "pskcAlgorithmparams",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.16": {
						d: "pskcCounter",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.17": {
						d: "pskcTime",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.18": {
						d: "pskcTimeinterval",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.19": {
						d: "pskcTimedrift",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.20": {
						d: "pskcValuemac",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.21": {
						d: "pskcKeystartdate",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.22": {
						d: "pskcKeyexpirydate",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.23": {
						d: "pskcNooftransactions",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.24": {
						d: "pskcKeyusages",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.25": {
						d: "pskcPinpolicy",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.26": {
						d: "pskcDeviceuserid",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.12.27": {
						d: "pskcKeyuserid",
						c: "S/MIME Portable Symmetric Key Container Attributes"
					},
					"1.2.840.113549.1.9.16.13": {
						d: "otherRecipientInfoIds",
						c: "S/MIME Other Recipient Info Identifiers"
					},
					"1.2.840.113549.1.9.16.13.1": {
						d: "keyTransPSK",
						c: "S/MIME Other Recipient Info Identifiers"
					},
					"1.2.840.113549.1.9.16.13.2": {
						d: "keyAgreePSK",
						c: "S/MIME Other Recipient Info Identifiers"
					},
					"1.2.840.113549.1.9.20": {
						d: "friendlyName (for PKCS #12)",
						c: "PKCS #9 via PKCS #12"
					},
					"1.2.840.113549.1.9.21": {
						d: "localKeyID (for PKCS #12)",
						c: "PKCS #9 via PKCS #12"
					},
					"1.2.840.113549.1.9.22": {
						d: "certTypes (for PKCS #12)",
						c: "PKCS #9 via PKCS #12"
					},
					"1.2.840.113549.1.9.22.1": {
						d: "x509Certificate (for PKCS #12)",
						c: "PKCS #9 via PKCS #12"
					},
					"1.2.840.113549.1.9.22.2": {
						d: "sdsiCertificate (for PKCS #12)",
						c: "PKCS #9 via PKCS #12"
					},
					"1.2.840.113549.1.9.23": {
						d: "crlTypes (for PKCS #12)",
						c: "PKCS #9 via PKCS #12"
					},
					"1.2.840.113549.1.9.23.1": {
						d: "x509Crl (for PKCS #12)",
						c: "PKCS #9 via PKCS #12"
					},
					"1.2.840.113549.1.9.24": {
						d: "pkcs9objectClass",
						c: "PKCS #9/RFC 2985"
					},
					"1.2.840.113549.1.9.25": {
						d: "pkcs9attributes",
						c: "PKCS #9/RFC 2985"
					},
					"1.2.840.113549.1.9.25.1": {
						d: "pkcs15Token",
						c: "PKCS #9/RFC 2985 attribute"
					},
					"1.2.840.113549.1.9.25.2": {
						d: "encryptedPrivateKeyInfo",
						c: "PKCS #9/RFC 2985 attribute"
					},
					"1.2.840.113549.1.9.25.3": {
						d: "randomNonce",
						c: "PKCS #9/RFC 2985 attribute"
					},
					"1.2.840.113549.1.9.25.4": {
						d: "sequenceNumber",
						c: "PKCS #9/RFC 2985 attribute"
					},
					"1.2.840.113549.1.9.25.5": {
						d: "pkcs7PDU",
						c: "PKCS #9/RFC 2985 attribute"
					},
					"1.2.840.113549.1.9.26": {
						d: "pkcs9syntax",
						c: "PKCS #9/RFC 2985"
					},
					"1.2.840.113549.1.9.27": {
						d: "pkcs9matchingRules",
						c: "PKCS #9/RFC 2985"
					},
					"1.2.840.113549.1.9.52": {
						d: "cmsAlgorithmProtection",
						c: "RFC 6211"
					},
					"1.2.840.113549.1.12": {
						d: "pkcs-12",
						c: ""
					},
					"1.2.840.113549.1.12.1": {
						d: "pkcs-12-PbeIds",
						c: "This OID was formerly assigned as PKCS #12 modeID"
					},
					"1.2.840.113549.1.12.1.1": {
						d: "pbeWithSHAAnd128BitRC4",
						c: "PKCS #12 PbeIds. This OID was formerly assigned as pkcs-12-OfflineTransportMode"
					},
					"1.2.840.113549.1.12.1.2": {
						d: "pbeWithSHAAnd40BitRC4",
						c: "PKCS #12 PbeIds. This OID was formerly assigned as pkcs-12-OnlineTransportMode"
					},
					"1.2.840.113549.1.12.1.3": {
						d: "pbeWithSHAAnd3-KeyTripleDES-CBC",
						c: "PKCS #12 PbeIds"
					},
					"1.2.840.113549.1.12.1.4": {
						d: "pbeWithSHAAnd2-KeyTripleDES-CBC",
						c: "PKCS #12 PbeIds"
					},
					"1.2.840.113549.1.12.1.5": {
						d: "pbeWithSHAAnd128BitRC2-CBC",
						c: "PKCS #12 PbeIds"
					},
					"1.2.840.113549.1.12.1.6": {
						d: "pbeWithSHAAnd40BitRC2-CBC",
						c: "PKCS #12 PbeIds"
					},
					"1.2.840.113549.1.12.2": {
						d: "pkcs-12-ESPVKID",
						c: "Deprecated",
						w: !0
					},
					"1.2.840.113549.1.12.2.1": {
						d: "pkcs-12-PKCS8KeyShrouding",
						c: "PKCS #12 ESPVKID. Deprecated, use (1 2 840 113549 1 12 3 5) instead",
						w: !0
					},
					"1.2.840.113549.1.12.3": {
						d: "pkcs-12-BagIds",
						c: ""
					},
					"1.2.840.113549.1.12.3.1": {
						d: "pkcs-12-keyBagId",
						c: "PKCS #12 BagIds"
					},
					"1.2.840.113549.1.12.3.2": {
						d: "pkcs-12-certAndCRLBagId",
						c: "PKCS #12 BagIds"
					},
					"1.2.840.113549.1.12.3.3": {
						d: "pkcs-12-secretBagId",
						c: "PKCS #12 BagIds"
					},
					"1.2.840.113549.1.12.3.4": {
						d: "pkcs-12-safeContentsId",
						c: "PKCS #12 BagIds"
					},
					"1.2.840.113549.1.12.3.5": {
						d: "pkcs-12-pkcs-8ShroudedKeyBagId",
						c: "PKCS #12 BagIds"
					},
					"1.2.840.113549.1.12.4": {
						d: "pkcs-12-CertBagID",
						c: "Deprecated",
						w: !0
					},
					"1.2.840.113549.1.12.4.1": {
						d: "pkcs-12-X509CertCRLBagID",
						c: "PKCS #12 CertBagID. This OID was formerly assigned as pkcs-12-X509CertCRLBag"
					},
					"1.2.840.113549.1.12.4.2": {
						d: "pkcs-12-SDSICertBagID",
						c: "PKCS #12 CertBagID. This OID was formerly assigned as pkcs-12-SDSICertBag"
					},
					"1.2.840.113549.1.12.5": {
						d: "pkcs-12-OID",
						c: "",
						w: !0
					},
					"1.2.840.113549.1.12.5.1": {
						d: "pkcs-12-PBEID",
						c: "PKCS #12 OID. Deprecated, use the partially compatible (1 2 840 113549 1 12 1) OIDs instead",
						w: !0
					},
					"1.2.840.113549.1.12.5.1.1": {
						d: "pkcs-12-PBEWithSha1And128BitRC4",
						c: "PKCS #12 OID PBEID. Deprecated, use (1 2 840 113549 1 12 1 1) instead",
						w: !0
					},
					"1.2.840.113549.1.12.5.1.2": {
						d: "pkcs-12-PBEWithSha1And40BitRC4",
						c: "PKCS #12 OID PBEID. Deprecated, use (1 2 840 113549 1 12 1 2) instead",
						w: !0
					},
					"1.2.840.113549.1.12.5.1.3": {
						d: "pkcs-12-PBEWithSha1AndTripleDESCBC",
						c: "PKCS #12 OID PBEID. Deprecated, use the incompatible but similar (1 2 840 113549 1 12 1 3) or (1 2 840 113549 1 12 1 4) instead",
						w: !0
					},
					"1.2.840.113549.1.12.5.1.4": {
						d: "pkcs-12-PBEWithSha1And128BitRC2CBC",
						c: "PKCS #12 OID PBEID. Deprecated, use (1 2 840 113549 1 12 1 5) instead",
						w: !0
					},
					"1.2.840.113549.1.12.5.1.5": {
						d: "pkcs-12-PBEWithSha1And40BitRC2CBC",
						c: "PKCS #12 OID PBEID. Deprecated, use (1 2 840 113549 1 12 1 6) instead",
						w: !0
					},
					"1.2.840.113549.1.12.5.1.6": {
						d: "pkcs-12-PBEWithSha1AndRC4",
						c: "PKCS #12 OID PBEID. Deprecated, use the incompatible but similar (1 2 840 113549 1 12 1 1) or (1 2 840 113549 1 12 1 2) instead",
						w: !0
					},
					"1.2.840.113549.1.12.5.1.7": {
						d: "pkcs-12-PBEWithSha1AndRC2CBC",
						c: "PKCS #12 OID PBEID. Deprecated, use the incompatible but similar (1 2 840 113549 1 12 1 5) or (1 2 840 113549 1 12 1 6) instead",
						w: !0
					},
					"1.2.840.113549.1.12.5.2": {
						d: "pkcs-12-EnvelopingID",
						c: "PKCS #12 OID. Deprecated, use the conventional PKCS #1 OIDs instead"
					},
					"1.2.840.113549.1.12.5.2.1": {
						d: "pkcs-12-RSAEncryptionWith128BitRC4",
						c: "PKCS #12 OID EnvelopingID. Deprecated, use the conventional PKCS #1 OIDs instead",
						w: !0
					},
					"1.2.840.113549.1.12.5.2.2": {
						d: "pkcs-12-RSAEncryptionWith40BitRC4",
						c: "PKCS #12 OID EnvelopingID. Deprecated, use the conventional PKCS #1 OIDs instead",
						w: !0
					},
					"1.2.840.113549.1.12.5.2.3": {
						d: "pkcs-12-RSAEncryptionWithTripleDES",
						c: "PKCS #12 OID EnvelopingID. Deprecated, use the conventional PKCS #1 OIDs instead",
						w: !0
					},
					"1.2.840.113549.1.12.5.3": {
						d: "pkcs-12-SignatureID",
						c: "PKCS #12 OID EnvelopingID. Deprecated, use the conventional PKCS #1 OIDs instead",
						w: !0
					},
					"1.2.840.113549.1.12.5.3.1": {
						d: "pkcs-12-RSASignatureWithSHA1Digest",
						c: "PKCS #12 OID SignatureID. Deprecated, use the conventional PKCS #1 OIDs instead",
						w: !0
					},
					"1.2.840.113549.1.12.10": {
						d: "pkcs-12Version1",
						c: ""
					},
					"1.2.840.113549.1.12.10.1": {
						d: "pkcs-12BadIds",
						c: ""
					},
					"1.2.840.113549.1.12.10.1.1": {
						d: "pkcs-12-keyBag",
						c: "PKCS #12 BagIds"
					},
					"1.2.840.113549.1.12.10.1.2": {
						d: "pkcs-12-pkcs-8ShroudedKeyBag",
						c: "PKCS #12 BagIds"
					},
					"1.2.840.113549.1.12.10.1.3": {
						d: "pkcs-12-certBag",
						c: "PKCS #12 BagIds"
					},
					"1.2.840.113549.1.12.10.1.4": {
						d: "pkcs-12-crlBag",
						c: "PKCS #12 BagIds"
					},
					"1.2.840.113549.1.12.10.1.5": {
						d: "pkcs-12-secretBag",
						c: "PKCS #12 BagIds"
					},
					"1.2.840.113549.1.12.10.1.6": {
						d: "pkcs-12-safeContentsBag",
						c: "PKCS #12 BagIds"
					},
					"1.2.840.113549.1.15.1": {
						d: "pkcs15modules",
						c: "PKCS #15"
					},
					"1.2.840.113549.1.15.2": {
						d: "pkcs15attributes",
						c: "PKCS #15"
					},
					"1.2.840.113549.1.15.3": {
						d: "pkcs15contentType",
						c: "PKCS #15"
					},
					"1.2.840.113549.1.15.3.1": {
						d: "pkcs15content",
						c: "PKCS #15 content type"
					},
					"1.2.840.113549.2": {
						d: "digestAlgorithm",
						c: ""
					},
					"1.2.840.113549.2.2": {
						d: "md2",
						c: "RSADSI digestAlgorithm"
					},
					"1.2.840.113549.2.4": {
						d: "md4",
						c: "RSADSI digestAlgorithm"
					},
					"1.2.840.113549.2.5": {
						d: "md5",
						c: "RSADSI digestAlgorithm"
					},
					"1.2.840.113549.2.7": {
						d: "hmacWithSHA1",
						c: "RSADSI digestAlgorithm"
					},
					"1.2.840.113549.2.8": {
						d: "hmacWithSHA224",
						c: "RSADSI digestAlgorithm"
					},
					"1.2.840.113549.2.9": {
						d: "hmacWithSHA256",
						c: "RSADSI digestAlgorithm"
					},
					"1.2.840.113549.2.10": {
						d: "hmacWithSHA384",
						c: "RSADSI digestAlgorithm"
					},
					"1.2.840.113549.2.11": {
						d: "hmacWithSHA512",
						c: "RSADSI digestAlgorithm"
					},
					"1.2.840.113549.3": {
						d: "encryptionAlgorithm",
						c: ""
					},
					"1.2.840.113549.3.2": {
						d: "rc2CBC",
						c: "RSADSI encryptionAlgorithm"
					},
					"1.2.840.113549.3.3": {
						d: "rc2ECB",
						c: "RSADSI encryptionAlgorithm"
					},
					"1.2.840.113549.3.4": {
						d: "rc4",
						c: "RSADSI encryptionAlgorithm"
					},
					"1.2.840.113549.3.5": {
						d: "rc4WithMAC",
						c: "RSADSI encryptionAlgorithm"
					},
					"1.2.840.113549.3.6": {
						d: "desx-CBC",
						c: "RSADSI encryptionAlgorithm"
					},
					"1.2.840.113549.3.7": {
						d: "des-EDE3-CBC",
						c: "RSADSI encryptionAlgorithm"
					},
					"1.2.840.113549.3.8": {
						d: "rc5CBC",
						c: "RSADSI encryptionAlgorithm"
					},
					"1.2.840.113549.3.9": {
						d: "rc5-CBCPad",
						c: "RSADSI encryptionAlgorithm"
					},
					"1.2.840.113549.3.10": {
						d: "desCDMF",
						c: "RSADSI encryptionAlgorithm. Formerly called CDMFCBCPad"
					},
					"1.2.840.114021.1.6.1": {
						d: "Identrus unknown policyIdentifier",
						c: "Identrus"
					},
					"1.2.840.114021.4.1": {
						d: "identrusOCSP",
						c: "Identrus"
					},
					"1.2.840.113556.1.2.241": {
						d: "deliveryMechanism",
						c: "Microsoft Exchange Server - attribute"
					},
					"1.2.840.113556.1.2.281": {
						d: "ntSecurityDescriptor",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.3.0": {
						d: "site-Addressing",
						c: "Microsoft Exchange Server - object class"
					},
					"1.2.840.113556.1.3.13": {
						d: "classSchema",
						c: "Microsoft Exchange Server - object class"
					},
					"1.2.840.113556.1.3.14": {
						d: "attributeSchema",
						c: "Microsoft Exchange Server - object class"
					},
					"1.2.840.113556.1.3.17": {
						d: "mailbox-Agent",
						c: "Microsoft Exchange Server - object class"
					},
					"1.2.840.113556.1.3.22": {
						d: "mailbox",
						c: "Microsoft Exchange Server - object class"
					},
					"1.2.840.113556.1.3.23": {
						d: "container",
						c: "Microsoft Exchange Server - object class"
					},
					"1.2.840.113556.1.3.46": {
						d: "mailRecipient",
						c: "Microsoft Exchange Server - object class"
					},
					"1.2.840.113556.1.4.145": {
						d: "revision",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1327": {
						d: "pKIDefaultKeySpec",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1328": {
						d: "pKIKeyUsage",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1329": {
						d: "pKIMaxIssuingDepth",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1330": {
						d: "pKICriticalExtensions",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1331": {
						d: "pKIExpirationPeriod",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1332": {
						d: "pKIOverlapPeriod",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1333": {
						d: "pKIExtendedKeyUsage",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1334": {
						d: "pKIDefaultCSPs",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1335": {
						d: "pKIEnrollmentAccess",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1429": {
						d: "msPKI-RA-Signature",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1430": {
						d: "msPKI-Enrollment-Flag",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1431": {
						d: "msPKI-Private-Key-Flag",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1432": {
						d: "msPKI-Certificate-Name-Flag",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1433": {
						d: "msPKI-Minimal-Key-Size",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1434": {
						d: "msPKI-Template-Schema-Version",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1435": {
						d: "msPKI-Template-Minor-Revision",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1436": {
						d: "msPKI-Cert-Template-OID",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1437": {
						d: "msPKI-Supersede-Templates",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1438": {
						d: "msPKI-RA-Policies",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1439": {
						d: "msPKI-Certificate-Policy",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1674": {
						d: "msPKI-Certificate-Application-Policy",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.1.4.1675": {
						d: "msPKI-RA-Application-Policies",
						c: "Microsoft Cert Template - attribute"
					},
					"1.2.840.113556.4.3": {
						d: "microsoftExcel",
						c: "Microsoft"
					},
					"1.2.840.113556.4.4": {
						d: "titledWithOID",
						c: "Microsoft"
					},
					"1.2.840.113556.4.5": {
						d: "microsoftPowerPoint",
						c: "Microsoft"
					},
					"1.2.840.113583.1": {
						d: "adobeAcrobat",
						c: "Adobe Acrobat"
					},
					"1.2.840.113583.1.1": {
						d: "acrobatSecurity",
						c: "Adobe Acrobat security"
					},
					"1.2.840.113583.1.1.1": {
						d: "pdfPassword",
						c: "Adobe Acrobat security"
					},
					"1.2.840.113583.1.1.2": {
						d: "pdfDefaultSigningCredential",
						c: "Adobe Acrobat security"
					},
					"1.2.840.113583.1.1.3": {
						d: "pdfDefaultEncryptionCredential",
						c: "Adobe Acrobat security"
					},
					"1.2.840.113583.1.1.4": {
						d: "pdfPasswordTimeout",
						c: "Adobe Acrobat security"
					},
					"1.2.840.113583.1.1.5": {
						d: "pdfAuthenticDocumentsTrust",
						c: "Adobe Acrobat security"
					},
					"1.2.840.113583.1.1.6": {
						d: "pdfDynamicContentTrust",
						c: "Adobe Acrobat security",
						w: !0
					},
					"1.2.840.113583.1.1.7": {
						d: "pdfUbiquityTrust",
						c: "Adobe Acrobat security"
					},
					"1.2.840.113583.1.1.8": {
						d: "pdfRevocationInfoArchival",
						c: "Adobe Acrobat security"
					},
					"1.2.840.113583.1.1.9": {
						d: "pdfX509Extension",
						c: "Adobe Acrobat security"
					},
					"1.2.840.113583.1.1.9.1": {
						d: "pdfTimeStamp",
						c: "Adobe Acrobat security"
					},
					"1.2.840.113583.1.1.9.2": {
						d: "pdfArchiveRevInfo",
						c: "Adobe Acrobat security"
					},
					"1.2.840.113583.1.1.10": {
						d: "pdfPPLKLiteCredential",
						c: "Adobe Acrobat security"
					},
					"1.2.840.113583.1.2": {
						d: "acrobatCPS",
						c: "Adobe Acrobat CPS"
					},
					"1.2.840.113583.1.2.1": {
						d: "pdfAuthenticDocumentsCPS",
						c: "Adobe Acrobat CPS"
					},
					"1.2.840.113583.1.2.2": {
						d: "pdfTestCPS",
						c: "Adobe Acrobat CPS"
					},
					"1.2.840.113583.1.2.3": {
						d: "pdfUbiquityCPS",
						c: "Adobe Acrobat CPS"
					},
					"1.2.840.113583.1.2.4": {
						d: "pdfAdhocCPS",
						c: "Adobe Acrobat CPS"
					},
					"1.2.840.113583.1.7": {
						d: "acrobatUbiquity",
						c: "Adobe Acrobat ubiquity"
					},
					"1.2.840.113583.1.7.1": {
						d: "pdfUbiquitySubRights",
						c: "Adobe Acrobat ubiquity"
					},
					"1.2.840.113583.1.9": {
						d: "acrobatExtension",
						c: "Adobe Acrobat X.509 extension"
					},
					"1.2.840.113628.114.1.7": {
						d: "adobePKCS7",
						c: "Adobe"
					},
					"1.2.840.113635.100": {
						d: "appleDataSecurity",
						c: "Apple"
					},
					"1.2.840.113635.100.1": {
						d: "appleTrustPolicy",
						c: "Apple"
					},
					"1.2.840.113635.100.1.1": {
						d: "appleISignTP",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.2": {
						d: "appleX509Basic",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.3": {
						d: "appleSSLPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.4": {
						d: "appleLocalCertGenPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.5": {
						d: "appleCSRGenPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.6": {
						d: "appleCRLPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.7": {
						d: "appleOCSPPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.8": {
						d: "appleSMIMEPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.9": {
						d: "appleEAPPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.10": {
						d: "appleSWUpdateSigningPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.11": {
						d: "appleIPSecPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.12": {
						d: "appleIChatPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.13": {
						d: "appleResourceSignPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.14": {
						d: "applePKINITClientPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.15": {
						d: "applePKINITServerPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.16": {
						d: "appleCodeSigningPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.1.17": {
						d: "applePackageSigningPolicy",
						c: "Apple trust policy"
					},
					"1.2.840.113635.100.2": {
						d: "appleSecurityAlgorithm",
						c: "Apple"
					},
					"1.2.840.113635.100.2.1": {
						d: "appleFEE",
						c: "Apple security algorithm"
					},
					"1.2.840.113635.100.2.2": {
						d: "appleASC",
						c: "Apple security algorithm"
					},
					"1.2.840.113635.100.2.3": {
						d: "appleFEE_MD5",
						c: "Apple security algorithm"
					},
					"1.2.840.113635.100.2.4": {
						d: "appleFEE_SHA1",
						c: "Apple security algorithm"
					},
					"1.2.840.113635.100.2.5": {
						d: "appleFEED",
						c: "Apple security algorithm"
					},
					"1.2.840.113635.100.2.6": {
						d: "appleFEEDEXP",
						c: "Apple security algorithm"
					},
					"1.2.840.113635.100.2.7": {
						d: "appleECDSA",
						c: "Apple security algorithm"
					},
					"1.2.840.113635.100.3": {
						d: "appleDotMacCertificate",
						c: "Apple"
					},
					"1.2.840.113635.100.3.1": {
						d: "appleDotMacCertificateRequest",
						c: "Apple dotMac certificate"
					},
					"1.2.840.113635.100.3.2": {
						d: "appleDotMacCertificateExtension",
						c: "Apple dotMac certificate"
					},
					"1.2.840.113635.100.3.3": {
						d: "appleDotMacCertificateRequestValues",
						c: "Apple dotMac certificate"
					},
					"1.2.840.113635.100.4": {
						d: "appleExtendedKeyUsage",
						c: "Apple"
					},
					"1.2.840.113635.100.4.1": {
						d: "appleCodeSigning",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.1.1": {
						d: "appleCodeSigningDevelopment",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.1.2": {
						d: "appleSoftwareUpdateSigning",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.1.3": {
						d: "appleCodeSigningThirdParty",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.1.4": {
						d: "appleResourceSigning",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.2": {
						d: "appleIChatSigning",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.3": {
						d: "appleIChatEncryption",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.4": {
						d: "appleSystemIdentity",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.5": {
						d: "appleCryptoEnv",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.5.1": {
						d: "appleCryptoProductionEnv",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.5.2": {
						d: "appleCryptoMaintenanceEnv",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.5.3": {
						d: "appleCryptoTestEnv",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.5.4": {
						d: "appleCryptoDevelopmentEnv",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.6": {
						d: "appleCryptoQoS",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.6.1": {
						d: "appleCryptoTier0QoS",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.6.2": {
						d: "appleCryptoTier1QoS",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.6.3": {
						d: "appleCryptoTier2QoS",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.4.6.4": {
						d: "appleCryptoTier3QoS",
						c: "Apple extended key usage"
					},
					"1.2.840.113635.100.5": {
						d: "appleCertificatePolicies",
						c: "Apple"
					},
					"1.2.840.113635.100.5.1": {
						d: "appleCertificatePolicyID",
						c: "Apple"
					},
					"1.2.840.113635.100.5.2": {
						d: "appleDotMacCertificatePolicyID",
						c: "Apple"
					},
					"1.2.840.113635.100.5.3": {
						d: "appleADCCertificatePolicyID",
						c: "Apple"
					},
					"1.2.840.113635.100.6": {
						d: "appleCertificateExtensions",
						c: "Apple"
					},
					"1.2.840.113635.100.6.1": {
						d: "appleCertificateExtensionCodeSigning",
						c: "Apple certificate extension"
					},
					"1.2.840.113635.100.6.1.1": {
						d: "appleCertificateExtensionAppleSigning",
						c: "Apple certificate extension"
					},
					"1.2.840.113635.100.6.1.2": {
						d: "appleCertificateExtensionADCDeveloperSigning",
						c: "Apple certificate extension"
					},
					"1.2.840.113635.100.6.1.3": {
						d: "appleCertificateExtensionADCAppleSigning",
						c: "Apple certificate extension"
					},
					"1.2.840.113635.100.15.1": {
						d: "appleCustomCertificateExtension1",
						c: "Apple custom certificate extension"
					},
					"1.2.840.113635.100.15.2": {
						d: "appleCustomCertificateExtension2",
						c: "Apple custom certificate extension"
					},
					"1.2.840.113635.100.15.3": {
						d: "appleCustomCertificateExtension3",
						c: "Apple custom certificate extension"
					},
					"1.3.6.1.4.1.311.2.1.4": {
						d: "spcIndirectDataContext",
						c: "Microsoft code signing"
					},
					"1.3.6.1.4.1.311.2.1.10": {
						d: "spcAgencyInfo",
						c: "Microsoft code signing. Also known as policyLink"
					},
					"1.3.6.1.4.1.311.2.1.11": {
						d: "spcStatementType",
						c: "Microsoft code signing"
					},
					"1.3.6.1.4.1.311.2.1.12": {
						d: "spcSpOpusInfo",
						c: "Microsoft code signing"
					},
					"1.3.6.1.4.1.311.2.1.14": {
						d: "certReqExtensions",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.2.1.15": {
						d: "spcPEImageData",
						c: "Microsoft code signing"
					},
					"1.3.6.1.4.1.311.2.1.18": {
						d: "spcRawFileData",
						c: "Microsoft code signing"
					},
					"1.3.6.1.4.1.311.2.1.19": {
						d: "spcStructuredStorageData",
						c: "Microsoft code signing"
					},
					"1.3.6.1.4.1.311.2.1.20": {
						d: "spcJavaClassData (type 1)",
						c: 'Microsoft code signing. Formerly "link extension" aka "glue extension"'
					},
					"1.3.6.1.4.1.311.2.1.21": {
						d: "individualCodeSigning",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.2.1.22": {
						d: "commercialCodeSigning",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.2.1.25": {
						d: "spcLink (type 2)",
						c: 'Microsoft code signing. Also known as "glue extension"'
					},
					"1.3.6.1.4.1.311.2.1.26": {
						d: "spcMinimalCriteriaInfo",
						c: "Microsoft code signing"
					},
					"1.3.6.1.4.1.311.2.1.27": {
						d: "spcFinancialCriteriaInfo",
						c: "Microsoft code signing"
					},
					"1.3.6.1.4.1.311.2.1.28": {
						d: "spcLink (type 3)",
						c: 'Microsoft code signing.  Also known as "glue extension"'
					},
					"1.3.6.1.4.1.311.2.1.29": {
						d: "spcHashInfoObjID",
						c: "Microsoft code signing"
					},
					"1.3.6.1.4.1.311.2.1.30": {
						d: "spcSipInfoObjID",
						c: "Microsoft code signing"
					},
					"1.3.6.1.4.1.311.2.2": {
						d: "ctl",
						c: "Microsoft CTL"
					},
					"1.3.6.1.4.1.311.2.2.1": {
						d: "ctlTrustedCodesigningCAList",
						c: "Microsoft CTL"
					},
					"1.3.6.1.4.1.311.2.2.2": {
						d: "ctlTrustedClientAuthCAList",
						c: "Microsoft CTL"
					},
					"1.3.6.1.4.1.311.2.2.3": {
						d: "ctlTrustedServerAuthCAList",
						c: "Microsoft CTL"
					},
					"1.3.6.1.4.1.311.3.2.1": {
						d: "timestampRequest",
						c: "Microsoft code signing"
					},
					"1.3.6.1.4.1.311.10.1": {
						d: "certTrustList",
						c: "Microsoft contentType"
					},
					"1.3.6.1.4.1.311.10.1.1": {
						d: "sortedCtl",
						c: "Microsoft contentType"
					},
					"1.3.6.1.4.1.311.10.2": {
						d: "nextUpdateLocation",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.10.3.1": {
						d: "certTrustListSigning",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.2": {
						d: "timeStampSigning",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.3": {
						d: "serverGatedCrypto",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.3.1": {
						d: "serialized",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.10.3.4": {
						d: "encryptedFileSystem",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.5": {
						d: "whqlCrypto",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.6": {
						d: "nt5Crypto",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.7": {
						d: "oemWHQLCrypto",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.8": {
						d: "embeddedNTCrypto",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.9": {
						d: "rootListSigner",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.10": {
						d: "qualifiedSubordination",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.11": {
						d: "keyRecovery",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.12": {
						d: "documentSigning",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.13": {
						d: "lifetimeSigning",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.14": {
						d: "mobileDeviceSoftware",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.15": {
						d: "smartDisplay",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.16": {
						d: "cspSignature",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.3.4.1": {
						d: "efsRecovery",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.4.1": {
						d: "yesnoTrustAttr",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.10.5.1": {
						d: "drm",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.5.2": {
						d: "drmIndividualization",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.6.1": {
						d: "licenses",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.6.2": {
						d: "licenseServer",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.10.7.1": {
						d: "keyidRdn",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.10.8.1": {
						d: "removeCertificate",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.10.9.1": {
						d: "crossCertDistPoints",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.10.10.1": {
						d: "cmcAddAttributes",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.10.11": {
						d: "certPropIdPrefix",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.10.11.4": {
						d: "certMd5HashPropId",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.10.11.20": {
						d: "certKeyIdentifierPropId",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.10.11.28": {
						d: "certIssuerSerialNumberMd5HashPropId",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.10.11.29": {
						d: "certSubjectNameMd5HashPropId",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.10.12.1": {
						d: "anyApplicationPolicy",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.12": {
						d: "catalog",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.12.1.1": {
						d: "catalogList",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.12.1.2": {
						d: "catalogListMember",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.12.2.1": {
						d: "catalogNameValueObjID",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.12.2.2": {
						d: "catalogMemberInfoObjID",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.13.1": {
						d: "renewalCertificate",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.13.2.1": {
						d: "enrolmentNameValuePair",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.13.2.2": {
						d: "enrolmentCSP",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.13.2.3": {
						d: "osVersion",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.16.4": {
						d: "microsoftRecipientInfo",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.17.1": {
						d: "pkcs12KeyProviderNameAttr",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.17.2": {
						d: "localMachineKeyset",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.17.3": {
						d: "pkcs12ExtendedAttributes",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.20.1": {
						d: "autoEnrollCtlUsage",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.20.2": {
						d: "enrollCerttypeExtension",
						c: "Microsoft CAPICOM certificate template, V1"
					},
					"1.3.6.1.4.1.311.20.2.1": {
						d: "enrollmentAgent",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.20.2.2": {
						d: "smartcardLogon",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.20.2.3": {
						d: "universalPrincipalName",
						c: "Microsoft UPN"
					},
					"1.3.6.1.4.1.311.20.3": {
						d: "certManifold",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.21.1": {
						d: "cAKeyCertIndexPair",
						c: "Microsoft attribute.  Also known as certsrvCaVersion"
					},
					"1.3.6.1.4.1.311.21.2": {
						d: "certSrvPreviousCertHash",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.21.3": {
						d: "crlVirtualBase",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.21.4": {
						d: "crlNextPublish",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.21.5": {
						d: "caExchange",
						c: "Microsoft extended key usage",
						w: !0
					},
					"1.3.6.1.4.1.311.21.6": {
						d: "keyRecovery",
						c: "Microsoft extended key usage",
						w: !0
					},
					"1.3.6.1.4.1.311.21.7": {
						d: "certificateTemplate",
						c: "Microsoft CAPICOM certificate template, V2"
					},
					"1.3.6.1.4.1.311.21.9": {
						d: "rdnDummySigner",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.21.10": {
						d: "applicationCertPolicies",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.21.11": {
						d: "applicationPolicyMappings",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.21.12": {
						d: "applicationPolicyConstraints",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.21.13": {
						d: "archivedKey",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.21.14": {
						d: "crlSelfCDP",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.21.15": {
						d: "requireCertChainPolicy",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.21.16": {
						d: "archivedKeyCertHash",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.21.17": {
						d: "issuedCertHash",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.21.19": {
						d: "dsEmailReplication",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.21.20": {
						d: "requestClientInfo",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.21.21": {
						d: "encryptedKeyHash",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.21.22": {
						d: "certsrvCrossCaVersion",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.25.1": {
						d: "ntdsReplication",
						c: "Microsoft"
					},
					"1.3.6.1.4.1.311.31.1": {
						d: "productUpdate",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.47.1.1": {
						d: "systemHealth",
						c: "Microsoft extended key usage"
					},
					"1.3.6.1.4.1.311.47.1.3": {
						d: "systemHealthLoophole",
						c: "Microsoft extended key usage"
					},
					"1.3.6.1.4.1.311.60.1.1": {
						d: "rootProgramFlags",
						c: "Microsoft policy attribute"
					},
					"1.3.6.1.4.1.311.61.1.1": {
						d: "kernelModeCodeSigning",
						c: "Microsoft enhanced key usage"
					},
					"1.3.6.1.4.1.311.60.2.1.1": {
						d: "jurisdictionOfIncorporationL",
						c: "Microsoft (???)"
					},
					"1.3.6.1.4.1.311.60.2.1.2": {
						d: "jurisdictionOfIncorporationSP",
						c: "Microsoft (???)"
					},
					"1.3.6.1.4.1.311.60.2.1.3": {
						d: "jurisdictionOfIncorporationC",
						c: "Microsoft (???)"
					},
					"1.3.6.1.4.1.311.76.509.1.1": {
						d: "microsoftCPS",
						c: "Microsoft PKI services"
					},
					"1.3.6.1.4.1.311.88": {
						d: "capiCom",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.88.1": {
						d: "capiComVersion",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.88.2": {
						d: "capiComAttribute",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.88.2.1": {
						d: "capiComDocumentName",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.88.2.2": {
						d: "capiComDocumentDescription",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.88.3": {
						d: "capiComEncryptedData",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.311.88.3.1": {
						d: "capiComEncryptedContent",
						c: "Microsoft attribute"
					},
					"1.3.6.1.4.1.188.7.1.1": {
						d: "ascom",
						c: "Ascom Systech"
					},
					"1.3.6.1.4.1.188.7.1.1.1": {
						d: "ideaECB",
						c: "Ascom Systech"
					},
					"1.3.6.1.4.1.188.7.1.1.2": {
						d: "ideaCBC",
						c: "Ascom Systech"
					},
					"1.3.6.1.4.1.188.7.1.1.3": {
						d: "ideaCFB",
						c: "Ascom Systech"
					},
					"1.3.6.1.4.1.188.7.1.1.4": {
						d: "ideaOFB",
						c: "Ascom Systech"
					},
					"1.3.6.1.4.1.2428.10.1.1": {
						d: "UNINETT policyIdentifier",
						c: "UNINETT PCA"
					},
					"1.3.6.1.4.1.2712.10": {
						d: "ICE-TEL policyIdentifier",
						c: "ICE-TEL CA"
					},
					"1.3.6.1.4.1.2786.1.1.1": {
						d: "ICE-TEL Italian policyIdentifier",
						c: "ICE-TEL CA policy"
					},
					"1.3.6.1.4.1.3029.1.1.1": {
						d: "blowfishECB",
						c: "cryptlib encryption algorithm"
					},
					"1.3.6.1.4.1.3029.1.1.2": {
						d: "blowfishCBC",
						c: "cryptlib encryption algorithm"
					},
					"1.3.6.1.4.1.3029.1.1.3": {
						d: "blowfishCFB",
						c: "cryptlib encryption algorithm"
					},
					"1.3.6.1.4.1.3029.1.1.4": {
						d: "blowfishOFB",
						c: "cryptlib encryption algorithm"
					},
					"1.3.6.1.4.1.3029.1.2.1": {
						d: "elgamal",
						c: "cryptlib public-key algorithm"
					},
					"1.3.6.1.4.1.3029.1.2.1.1": {
						d: "elgamalWithSHA-1",
						c: "cryptlib public-key algorithm"
					},
					"1.3.6.1.4.1.3029.1.2.1.2": {
						d: "elgamalWithRIPEMD-160",
						c: "cryptlib public-key algorithm"
					},
					"1.3.6.1.4.1.3029.3.1.1": {
						d: "cryptlibPresenceCheck",
						c: "cryptlib attribute type"
					},
					"1.3.6.1.4.1.3029.3.1.2": {
						d: "pkiBoot",
						c: "cryptlib attribute type"
					},
					"1.3.6.1.4.1.3029.3.1.4": {
						d: "crlExtReason",
						c: "cryptlib attribute type"
					},
					"1.3.6.1.4.1.3029.3.1.5": {
						d: "keyFeatures",
						c: "cryptlib attribute type"
					},
					"1.3.6.1.4.1.3029.4.1": {
						d: "cryptlibContent",
						c: "cryptlib"
					},
					"1.3.6.1.4.1.3029.4.1.1": {
						d: "cryptlibConfigData",
						c: "cryptlib content type"
					},
					"1.3.6.1.4.1.3029.4.1.2": {
						d: "cryptlibUserIndex",
						c: "cryptlib content type"
					},
					"1.3.6.1.4.1.3029.4.1.3": {
						d: "cryptlibUserInfo",
						c: "cryptlib content type"
					},
					"1.3.6.1.4.1.3029.4.1.4": {
						d: "rtcsRequest",
						c: "cryptlib content type"
					},
					"1.3.6.1.4.1.3029.4.1.5": {
						d: "rtcsResponse",
						c: "cryptlib content type"
					},
					"1.3.6.1.4.1.3029.4.1.6": {
						d: "rtcsResponseExt",
						c: "cryptlib content type"
					},
					"1.3.6.1.4.1.3029.42.11172.1": {
						d: "mpeg-1",
						c: "cryptlib special MPEG-of-cat OID"
					},
					"1.3.6.1.4.1.3029.54.11940.54": {
						d: 'TSA policy "Anything that arrives, we sign"',
						c: "cryptlib TSA policy"
					},
					"1.3.6.1.4.1.3029.88.89.90.90.89": {
						d: "xYZZY policyIdentifier",
						c: "cryptlib certificate policy"
					},
					"1.3.6.1.4.1.3401.8.1.1": {
						d: "pgpExtension",
						c: "PGP key information"
					},
					"1.3.6.1.4.1.3576.7": {
						d: "eciaAscX12Edi",
						c: "TMN EDI for Interactive Agents"
					},
					"1.3.6.1.4.1.3576.7.1": {
						d: "plainEDImessage",
						c: "TMN EDI for Interactive Agents"
					},
					"1.3.6.1.4.1.3576.7.2": {
						d: "signedEDImessage",
						c: "TMN EDI for Interactive Agents"
					},
					"1.3.6.1.4.1.3576.7.5": {
						d: "integrityEDImessage",
						c: "TMN EDI for Interactive Agents"
					},
					"1.3.6.1.4.1.3576.7.65": {
						d: "iaReceiptMessage",
						c: "TMN EDI for Interactive Agents"
					},
					"1.3.6.1.4.1.3576.7.97": {
						d: "iaStatusMessage",
						c: "TMN EDI for Interactive Agents"
					},
					"1.3.6.1.4.1.3576.8": {
						d: "eciaEdifact",
						c: "TMN EDI for Interactive Agents"
					},
					"1.3.6.1.4.1.3576.9": {
						d: "eciaNonEdi",
						c: "TMN EDI for Interactive Agents"
					},
					"1.3.6.1.4.1.4146": {
						d: "Globalsign",
						c: "Globalsign"
					},
					"1.3.6.1.4.1.4146.1": {
						d: "globalsignPolicy",
						c: "Globalsign"
					},
					"1.3.6.1.4.1.4146.1.10": {
						d: "globalsignDVPolicy",
						c: "Globalsign policy"
					},
					"1.3.6.1.4.1.4146.1.20": {
						d: "globalsignOVPolicy",
						c: "Globalsign policy"
					},
					"1.3.6.1.4.1.4146.1.30": {
						d: "globalsignTSAPolicy",
						c: "Globalsign policy"
					},
					"1.3.6.1.4.1.4146.1.40": {
						d: "globalsignClientCertPolicy",
						c: "Globalsign policy"
					},
					"1.3.6.1.4.1.4146.1.50": {
						d: "globalsignCodeSignPolicy",
						c: "Globalsign policy"
					},
					"1.3.6.1.4.1.4146.1.60": {
						d: "globalsignRootSignPolicy",
						c: "Globalsign policy"
					},
					"1.3.6.1.4.1.4146.1.70": {
						d: "globalsignTrustedRootPolicy",
						c: "Globalsign policy"
					},
					"1.3.6.1.4.1.4146.1.80": {
						d: "globalsignEDIClientPolicy",
						c: "Globalsign policy"
					},
					"1.3.6.1.4.1.4146.1.81": {
						d: "globalsignEDIServerPolicy",
						c: "Globalsign policy"
					},
					"1.3.6.1.4.1.4146.1.90": {
						d: "globalsignTPMRootPolicy",
						c: "Globalsign policy"
					},
					"1.3.6.1.4.1.4146.1.95": {
						d: "globalsignOCSPPolicy",
						c: "Globalsign policy"
					},
					"1.3.6.1.4.1.5309.1": {
						d: "edelWebPolicy",
						c: "EdelWeb policy"
					},
					"1.3.6.1.4.1.5309.1.2": {
						d: "edelWebCustomerPolicy",
						c: "EdelWeb policy"
					},
					"1.3.6.1.4.1.5309.1.2.1": {
						d: "edelWebClepsydrePolicy",
						c: "EdelWeb policy"
					},
					"1.3.6.1.4.1.5309.1.2.2": {
						d: "edelWebExperimentalTSAPolicy",
						c: "EdelWeb policy"
					},
					"1.3.6.1.4.1.5309.1.2.3": {
						d: "edelWebOpenEvidenceTSAPolicy",
						c: "EdelWeb policy"
					},
					"1.3.6.1.4.1.5472": {
						d: "timeproof",
						c: "enterprise"
					},
					"1.3.6.1.4.1.5472.1": {
						d: "tss",
						c: "timeproof"
					},
					"1.3.6.1.4.1.5472.1.1": {
						d: "tss80",
						c: "timeproof TSS"
					},
					"1.3.6.1.4.1.5472.1.2": {
						d: "tss380",
						c: "timeproof TSS"
					},
					"1.3.6.1.4.1.5472.1.3": {
						d: "tss400",
						c: "timeproof TSS"
					},
					"1.3.6.1.4.1.5770.0.3": {
						d: "secondaryPractices",
						c: "MEDePass"
					},
					"1.3.6.1.4.1.5770.0.4": {
						d: "physicianIdentifiers",
						c: "MEDePass"
					},
					"1.3.6.1.4.1.6449.1.2.1.3.1": {
						d: "comodoPolicy",
						c: "Comodo CA"
					},
					"1.3.6.1.4.1.6449.1.2.2.15": {
						d: "wotrustPolicy",
						c: "WoTrust (Comodo) CA"
					},
					"1.3.6.1.4.1.6449.1.3.5.2": {
						d: "comodoCertifiedDeliveryService",
						c: "Comodo CA"
					},
					"1.3.6.1.4.1.6449.2.1.1": {
						d: "comodoTimestampingPolicy",
						c: "Comodo CA"
					},
					"1.3.6.1.4.1.8301.3.5.1": {
						d: "validityModelChain",
						c: "TU Darmstadt ValidityModel"
					},
					"1.3.6.1.4.1.8301.3.5.2": {
						d: "validityModelShell",
						c: "ValidityModel"
					},
					"1.3.6.1.4.1.8231.1": {
						d: "rolUnicoNacional",
						c: "Chilean Government national unique roll number"
					},
					"1.3.6.1.4.1.11591": {
						d: "gnu",
						c: "GNU Project (see https://www.gnupg.org/oids.html)"
					},
					"1.3.6.1.4.1.11591.1": {
						d: "gnuRadius",
						c: "GNU Radius"
					},
					"1.3.6.1.4.1.11591.3": {
						d: "gnuRadar",
						c: "GNU Radar"
					},
					"1.3.6.1.4.1.11591.4.11": {
						d: "scrypt",
						c: "GNU Generic Security Service"
					},
					"1.3.6.1.4.1.11591.12": {
						d: "gnuDigestAlgorithm",
						c: "GNU digest algorithm"
					},
					"1.3.6.1.4.1.11591.12.2": {
						d: "tiger",
						c: "GNU digest algorithm"
					},
					"1.3.6.1.4.1.11591.13": {
						d: "gnuEncryptionAlgorithm",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.13.2": {
						d: "serpent",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.13.2.1": {
						d: "serpent128_ECB",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.13.2.2": {
						d: "serpent128_CBC",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.13.2.3": {
						d: "serpent128_OFB",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.13.2.4": {
						d: "serpent128_CFB",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.13.2.21": {
						d: "serpent192_ECB",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.13.2.22": {
						d: "serpent192_CBC",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.13.2.23": {
						d: "serpent192_OFB",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.13.2.24": {
						d: "serpent192_CFB",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.13.2.41": {
						d: "serpent256_ECB",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.13.2.42": {
						d: "serpent256_CBC",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.13.2.43": {
						d: "serpent256_OFB",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.13.2.44": {
						d: "serpent256_CFB",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.15.1": {
						d: "curve25519",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.15.2": {
						d: "curve448",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.15.3": {
						d: "curve25519ph",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.11591.15.4": {
						d: "curve448ph",
						c: "GNU encryption algorithm"
					},
					"1.3.6.1.4.1.16334.509.1.1": {
						d: "Northrop Grumman extKeyUsage?",
						c: "Northrop Grumman extended key usage"
					},
					"1.3.6.1.4.1.16334.509.2.1": {
						d: "ngcClass1",
						c: "Northrop Grumman policy"
					},
					"1.3.6.1.4.1.16334.509.2.2": {
						d: "ngcClass2",
						c: "Northrop Grumman policy"
					},
					"1.3.6.1.4.1.16334.509.2.3": {
						d: "ngcClass3",
						c: "Northrop Grumman policy"
					},
					"1.3.6.1.4.1.23629.1.4.2.1.1": {
						d: "safenetUsageLimit",
						c: "SafeNet"
					},
					"1.3.6.1.4.1.23629.1.4.2.1.2": {
						d: "safenetEndDate",
						c: "SafeNet"
					},
					"1.3.6.1.4.1.23629.1.4.2.1.3": {
						d: "safenetStartDate",
						c: "SafeNet"
					},
					"1.3.6.1.4.1.23629.1.4.2.1.4": {
						d: "safenetAdminCert",
						c: "SafeNet"
					},
					"1.3.6.1.4.1.23629.1.4.2.2.1": {
						d: "safenetKeyDigest",
						c: "SafeNet"
					},
					"1.3.6.1.4.1.51483.2.1": {
						d: "hashOfRootKey",
						c: "CTIA"
					},
					"1.3.6.1.5.2.3.1": {
						d: "authData",
						c: "Kerberos"
					},
					"1.3.6.1.5.2.3.2": {
						d: "dHKeyData",
						c: "Kerberos"
					},
					"1.3.6.1.5.2.3.3": {
						d: "rkeyData",
						c: "Kerberos"
					},
					"1.3.6.1.5.2.3.4": {
						d: "keyPurposeClientAuth",
						c: "Kerberos"
					},
					"1.3.6.1.5.2.3.5": {
						d: "keyPurposeKdc",
						c: "Kerberos"
					},
					"1.3.6.1.5.2.3.6": {
						d: "kdf",
						c: "Kerberos"
					},
					"1.3.6.1.5.5.7": {
						d: "pkix",
						c: ""
					},
					"1.3.6.1.5.5.7.0.12": {
						d: "attributeCert",
						c: "PKIX"
					},
					"1.3.6.1.5.5.7.1": {
						d: "privateExtension",
						c: "PKIX"
					},
					"1.3.6.1.5.5.7.1.1": {
						d: "authorityInfoAccess",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.2": {
						d: "biometricInfo",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.3": {
						d: "qcStatements",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.4": {
						d: "acAuditIdentity",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.5": {
						d: "acTargeting",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.6": {
						d: "acAaControls",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.7": {
						d: "ipAddrBlocks",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.8": {
						d: "autonomousSysIds",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.9": {
						d: "routerIdentifier",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.10": {
						d: "acProxying",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.11": {
						d: "subjectInfoAccess",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.12": {
						d: "logoType",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.13": {
						d: "wlanSSID",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.14": {
						d: "proxyCertInfo",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.15": {
						d: "acPolicies",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.16": {
						d: "certificateWarranty",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.18": {
						d: "cmsContentConstraints",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.19": {
						d: "otherCerts",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.20": {
						d: "wrappedApexContinKey",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.21": {
						d: "clearanceConstraints",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.22": {
						d: "skiSemantics",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.23": {
						d: "noSecrecyAfforded",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.24": {
						d: "tlsFeature",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.25": {
						d: "manufacturerUsageDescription",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.26": {
						d: "tnAuthList",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.27": {
						d: "jwtClaimConstraints",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.28": {
						d: "ipAddrBlocksV2",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.29": {
						d: "autonomousSysIdsV2",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.30": {
						d: "manufacturerUsageDescriptionSigner",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.31": {
						d: "acmeIdentifier",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.1.32": {
						d: "masaURL",
						c: "PKIX private extension"
					},
					"1.3.6.1.5.5.7.2": {
						d: "policyQualifierIds",
						c: "PKIX"
					},
					"1.3.6.1.5.5.7.2.1": {
						d: "cps",
						c: "PKIX policy qualifier"
					},
					"1.3.6.1.5.5.7.2.2": {
						d: "unotice",
						c: "PKIX policy qualifier"
					},
					"1.3.6.1.5.5.7.2.3": {
						d: "textNotice",
						c: "PKIX policy qualifier"
					},
					"1.3.6.1.5.5.7.2.4": {
						d: "acps",
						c: "PKIX policy qualifier"
					},
					"1.3.6.1.5.5.7.2.5": {
						d: "acunotice",
						c: "PKIX policy qualifier"
					},
					"1.3.6.1.5.5.7.3": {
						d: "keyPurpose",
						c: "PKIX"
					},
					"1.3.6.1.5.5.7.3.1": {
						d: "serverAuth",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.2": {
						d: "clientAuth",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.3": {
						d: "codeSigning",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.4": {
						d: "emailProtection",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.5": {
						d: "ipsecEndSystem",
						c: "PKIX key purpose",
						w: !0
					},
					"1.3.6.1.5.5.7.3.6": {
						d: "ipsecTunnel",
						c: "PKIX key purpose",
						w: !0
					},
					"1.3.6.1.5.5.7.3.7": {
						d: "ipsecUser",
						c: "PKIX key purpose",
						w: !0
					},
					"1.3.6.1.5.5.7.3.8": {
						d: "timeStamping",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.9": {
						d: "ocspSigning",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.10": {
						d: "dvcs",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.11": {
						d: "sbgpCertAAServerAuth",
						c: "PKIX key purpose",
						w: !0
					},
					"1.3.6.1.5.5.7.3.12": {
						d: "scvpResponder",
						c: "PKIX key purpose",
						w: !0
					},
					"1.3.6.1.5.5.7.3.13": {
						d: "eapOverPPP",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.14": {
						d: "eapOverLAN",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.15": {
						d: "scvpServer",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.16": {
						d: "scvpClient",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.17": {
						d: "ipsecIKE",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.18": {
						d: "capwapAC",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.19": {
						d: "capwapWTP",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.20": {
						d: "sipDomain",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.21": {
						d: "secureShellClient",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.22": {
						d: "secureShellServer",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.23": {
						d: "sendRouter",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.24": {
						d: "sendProxiedRouter",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.25": {
						d: "sendOwner",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.26": {
						d: "sendProxiedOwner",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.27": {
						d: "cmcCA",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.28": {
						d: "cmcRA",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.29": {
						d: "cmcArchive",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.30": {
						d: "bgpsecRouter",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.31": {
						d: "bimi",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.32": {
						d: "cmKGA",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.33": {
						d: "rpcTLSClient",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.3.34": {
						d: "rpcTLSServer",
						c: "PKIX key purpose"
					},
					"1.3.6.1.5.5.7.4": {
						d: "cmpInformationTypes",
						c: "PKIX"
					},
					"1.3.6.1.5.5.7.4.1": {
						d: "caProtEncCert",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.4.2": {
						d: "signKeyPairTypes",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.4.3": {
						d: "encKeyPairTypes",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.4.4": {
						d: "preferredSymmAlg",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.4.5": {
						d: "caKeyUpdateInfo",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.4.6": {
						d: "currentCRL",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.4.7": {
						d: "unsupportedOIDs",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.4.10": {
						d: "keyPairParamReq",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.4.11": {
						d: "keyPairParamRep",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.4.12": {
						d: "revPassphrase",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.4.13": {
						d: "implicitConfirm",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.4.14": {
						d: "confirmWaitTime",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.4.15": {
						d: "origPKIMessage",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.4.16": {
						d: "suppLangTags",
						c: "PKIX CMP information"
					},
					"1.3.6.1.5.5.7.5": {
						d: "crmfRegistration",
						c: "PKIX"
					},
					"1.3.6.1.5.5.7.5.1": {
						d: "regCtrl",
						c: "PKIX CRMF registration"
					},
					"1.3.6.1.5.5.7.5.1.1": {
						d: "regToken",
						c: "PKIX CRMF registration control"
					},
					"1.3.6.1.5.5.7.5.1.2": {
						d: "authenticator",
						c: "PKIX CRMF registration control"
					},
					"1.3.6.1.5.5.7.5.1.3": {
						d: "pkiPublicationInfo",
						c: "PKIX CRMF registration control"
					},
					"1.3.6.1.5.5.7.5.1.4": {
						d: "pkiArchiveOptions",
						c: "PKIX CRMF registration control"
					},
					"1.3.6.1.5.5.7.5.1.5": {
						d: "oldCertID",
						c: "PKIX CRMF registration control"
					},
					"1.3.6.1.5.5.7.5.1.6": {
						d: "protocolEncrKey",
						c: "PKIX CRMF registration control"
					},
					"1.3.6.1.5.5.7.5.1.7": {
						d: "altCertTemplate",
						c: "PKIX CRMF registration control"
					},
					"1.3.6.1.5.5.7.5.1.8": {
						d: "wtlsTemplate",
						c: "PKIX CRMF registration control"
					},
					"1.3.6.1.5.5.7.5.2": {
						d: "utf8Pairs",
						c: "PKIX CRMF registration"
					},
					"1.3.6.1.5.5.7.5.2.1": {
						d: "utf8Pairs",
						c: "PKIX CRMF registration control"
					},
					"1.3.6.1.5.5.7.5.2.2": {
						d: "certReq",
						c: "PKIX CRMF registration control"
					},
					"1.3.6.1.5.5.7.6": {
						d: "algorithms",
						c: "PKIX"
					},
					"1.3.6.1.5.5.7.6.1": {
						d: "des40",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.2": {
						d: "noSignature",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.3": {
						d: "dhSigHmacSha1",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.4": {
						d: "dhPop",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.5": {
						d: "dhPopSha224",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.6": {
						d: "dhPopSha256",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.7": {
						d: "dhPopSha384",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.8": {
						d: "dhPopSha512",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.15": {
						d: "dhPopStaticSha224HmacSha224",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.16": {
						d: "dhPopStaticSha256HmacSha256",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.17": {
						d: "dhPopStaticSha384HmacSha384",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.18": {
						d: "dhPopStaticSha512HmacSha512",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.25": {
						d: "ecdhPopStaticSha224HmacSha224",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.26": {
						d: "ecdhPopStaticSha256HmacSha256",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.27": {
						d: "ecdhPopStaticSha384HmacSha384",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.6.28": {
						d: "ecdhPopStaticSha512HmacSha512",
						c: "PKIX algorithm"
					},
					"1.3.6.1.5.5.7.7": {
						d: "cmcControls",
						c: "PKIX"
					},
					"1.3.6.1.5.5.7.8": {
						d: "otherNames",
						c: "PKIX"
					},
					"1.3.6.1.5.5.7.8.1": {
						d: "personalData",
						c: "PKIX other name"
					},
					"1.3.6.1.5.5.7.8.2": {
						d: "userGroup",
						c: "PKIX other name"
					},
					"1.3.6.1.5.5.7.8.3": {
						d: "permanentIdentifier",
						c: "PKIX other name"
					},
					"1.3.6.1.5.5.7.8.5": {
						d: "xmppAddr",
						c: "PKIX other name"
					},
					"1.3.6.1.5.5.7.8.6": {
						d: "SIM",
						c: "PKIX other name"
					},
					"1.3.6.1.5.5.7.9": {
						d: "personalData",
						c: "PKIX qualified certificates"
					},
					"1.3.6.1.5.5.7.9.1": {
						d: "dateOfBirth",
						c: "PKIX personal data"
					},
					"1.3.6.1.5.5.7.9.2": {
						d: "placeOfBirth",
						c: "PKIX personal data"
					},
					"1.3.6.1.5.5.7.9.3": {
						d: "gender",
						c: "PKIX personal data"
					},
					"1.3.6.1.5.5.7.9.4": {
						d: "countryOfCitizenship",
						c: "PKIX personal data"
					},
					"1.3.6.1.5.5.7.9.5": {
						d: "countryOfResidence",
						c: "PKIX personal data"
					},
					"1.3.6.1.5.5.7.10": {
						d: "attributeCertificate",
						c: "PKIX"
					},
					"1.3.6.1.5.5.7.10.1": {
						d: "authenticationInfo",
						c: "PKIX attribute certificate extension"
					},
					"1.3.6.1.5.5.7.10.2": {
						d: "accessIdentity",
						c: "PKIX attribute certificate extension"
					},
					"1.3.6.1.5.5.7.10.3": {
						d: "chargingIdentity",
						c: "PKIX attribute certificate extension"
					},
					"1.3.6.1.5.5.7.10.4": {
						d: "group",
						c: "PKIX attribute certificate extension"
					},
					"1.3.6.1.5.5.7.10.5": {
						d: "role",
						c: "PKIX attribute certificate extension"
					},
					"1.3.6.1.5.5.7.10.6": {
						d: "wlanSSID",
						c: "PKIX attribute-certificate extension"
					},
					"1.3.6.1.5.5.7.11": {
						d: "personalData",
						c: "PKIX qualified certificates"
					},
					"1.3.6.1.5.5.7.11.1": {
						d: "pkixQCSyntax-v1",
						c: "PKIX qualified certificates"
					},
					"1.3.6.1.5.5.7.11.2": {
						d: "pkixQCSyntax-v2",
						c: "PKIX qualified certificates"
					},
					"1.3.6.1.5.5.7.12": {
						d: "pkixCCT",
						c: "PKIX CMC Content Types"
					},
					"1.3.6.1.5.5.7.12.2": {
						d: "pkiData",
						c: "PKIX CMC Content Types"
					},
					"1.3.6.1.5.5.7.12.3": {
						d: "pkiResponse",
						c: "PKIX CMC Content Types"
					},
					"1.3.6.1.5.5.7.14.2": {
						d: "resourceCertificatePolicy",
						c: "PKIX policies"
					},
					"1.3.6.1.5.5.7.20": {
						d: "logo",
						c: "PKIX qualified certificates"
					},
					"1.3.6.1.5.5.7.20.1": {
						d: "logoLoyalty",
						c: "PKIX"
					},
					"1.3.6.1.5.5.7.20.2": {
						d: "logoBackground",
						c: "PKIX"
					},
					"1.3.6.1.5.5.7.48.1": {
						d: "ocsp",
						c: "PKIX"
					},
					"1.3.6.1.5.5.7.48.1.1": {
						d: "ocspBasic",
						c: "OCSP"
					},
					"1.3.6.1.5.5.7.48.1.2": {
						d: "ocspNonce",
						c: "OCSP"
					},
					"1.3.6.1.5.5.7.48.1.3": {
						d: "ocspCRL",
						c: "OCSP"
					},
					"1.3.6.1.5.5.7.48.1.4": {
						d: "ocspResponse",
						c: "OCSP"
					},
					"1.3.6.1.5.5.7.48.1.5": {
						d: "ocspNoCheck",
						c: "OCSP"
					},
					"1.3.6.1.5.5.7.48.1.6": {
						d: "ocspArchiveCutoff",
						c: "OCSP"
					},
					"1.3.6.1.5.5.7.48.1.7": {
						d: "ocspServiceLocator",
						c: "OCSP"
					},
					"1.3.6.1.5.5.7.48.2": {
						d: "caIssuers",
						c: "PKIX subject/authority info access descriptor"
					},
					"1.3.6.1.5.5.7.48.3": {
						d: "timeStamping",
						c: "PKIX subject/authority info access descriptor"
					},
					"1.3.6.1.5.5.7.48.4": {
						d: "dvcs",
						c: "PKIX subject/authority info access descriptor"
					},
					"1.3.6.1.5.5.7.48.5": {
						d: "caRepository",
						c: "PKIX subject/authority info access descriptor"
					},
					"1.3.6.1.5.5.7.48.7": {
						d: "signedObjectRepository",
						c: "PKIX subject/authority info access descriptor"
					},
					"1.3.6.1.5.5.7.48.10": {
						d: "rpkiManifest",
						c: "PKIX subject/authority info access descriptor"
					},
					"1.3.6.1.5.5.7.48.11": {
						d: "signedObject",
						c: "PKIX subject/authority info access descriptor"
					},
					"1.3.6.1.5.5.8.1.1": {
						d: "hmacMD5",
						c: "ISAKMP HMAC algorithm"
					},
					"1.3.6.1.5.5.8.1.2": {
						d: "hmacSHA",
						c: "ISAKMP HMAC algorithm"
					},
					"1.3.6.1.5.5.8.1.3": {
						d: "hmacTiger",
						c: "ISAKMP HMAC algorithm"
					},
					"1.3.6.1.5.5.8.2.2": {
						d: "iKEIntermediate",
						c: "IKE ???"
					},
					"1.3.12.2.1011.7.1": {
						d: "decEncryptionAlgorithm",
						c: "DASS algorithm"
					},
					"1.3.12.2.1011.7.1.2": {
						d: "decDEA",
						c: "DASS encryption algorithm"
					},
					"1.3.12.2.1011.7.2": {
						d: "decHashAlgorithm",
						c: "DASS algorithm"
					},
					"1.3.12.2.1011.7.2.1": {
						d: "decMD2",
						c: "DASS hash algorithm"
					},
					"1.3.12.2.1011.7.2.2": {
						d: "decMD4",
						c: "DASS hash algorithm"
					},
					"1.3.12.2.1011.7.3": {
						d: "decSignatureAlgorithm",
						c: "DASS algorithm"
					},
					"1.3.12.2.1011.7.3.1": {
						d: "decMD2withRSA",
						c: "DASS signature algorithm"
					},
					"1.3.12.2.1011.7.3.2": {
						d: "decMD4withRSA",
						c: "DASS signature algorithm"
					},
					"1.3.12.2.1011.7.3.3": {
						d: "decDEAMAC",
						c: "DASS signature algorithm"
					},
					"1.3.14.2.26.5": {
						d: "sha",
						c: "Unsure about this OID"
					},
					"1.3.14.3.2.1.1": {
						d: "rsa",
						c: "X.509. Unsure about this OID"
					},
					"1.3.14.3.2.2": {
						d: "md4WitRSA",
						c: "Oddball OIW OID"
					},
					"1.3.14.3.2.3": {
						d: "md5WithRSA",
						c: "Oddball OIW OID"
					},
					"1.3.14.3.2.4": {
						d: "md4WithRSAEncryption",
						c: "Oddball OIW OID"
					},
					"1.3.14.3.2.2.1": {
						d: "sqmod-N",
						c: "X.509. Deprecated",
						w: !0
					},
					"1.3.14.3.2.3.1": {
						d: "sqmod-NwithRSA",
						c: "X.509. Deprecated",
						w: !0
					},
					"1.3.14.3.2.6": {
						d: "desECB",
						c: ""
					},
					"1.3.14.3.2.7": {
						d: "desCBC",
						c: ""
					},
					"1.3.14.3.2.8": {
						d: "desOFB",
						c: ""
					},
					"1.3.14.3.2.9": {
						d: "desCFB",
						c: ""
					},
					"1.3.14.3.2.10": {
						d: "desMAC",
						c: ""
					},
					"1.3.14.3.2.11": {
						d: "rsaSignature",
						c: "ISO 9796-2, also X9.31 Part 1"
					},
					"1.3.14.3.2.12": {
						d: "dsa",
						c: "OIW?, supposedly from an incomplete version of SDN.701 (doesn't match final SDN.701)",
						w: !0
					},
					"1.3.14.3.2.13": {
						d: "dsaWithSHA",
						c: "Oddball OIW OID.  Incorrectly used by JDK 1.1 in place of (1 3 14 3 2 27)",
						w: !0
					},
					"1.3.14.3.2.14": {
						d: "mdc2WithRSASignature",
						c: "Oddball OIW OID using 9796-2 padding rules"
					},
					"1.3.14.3.2.15": {
						d: "shaWithRSASignature",
						c: "Oddball OIW OID using 9796-2 padding rules"
					},
					"1.3.14.3.2.16": {
						d: "dhWithCommonModulus",
						c: "Oddball OIW OID. Deprecated, use a plain DH OID instead",
						w: !0
					},
					"1.3.14.3.2.17": {
						d: "desEDE",
						c: "Oddball OIW OID. Mode is ECB"
					},
					"1.3.14.3.2.18": {
						d: "sha",
						c: "Oddball OIW OID"
					},
					"1.3.14.3.2.19": {
						d: "mdc-2",
						c: "Oddball OIW OID, DES-based hash, planned for X9.31 Part 2"
					},
					"1.3.14.3.2.20": {
						d: "dsaCommon",
						c: "Oddball OIW OID.  Deprecated, use a plain DSA OID instead",
						w: !0
					},
					"1.3.14.3.2.21": {
						d: "dsaCommonWithSHA",
						c: "Oddball OIW OID.  Deprecated, use a plain dsaWithSHA OID instead",
						w: !0
					},
					"1.3.14.3.2.22": {
						d: "rsaKeyTransport",
						c: "Oddball OIW OID"
					},
					"1.3.14.3.2.23": {
						d: "keyed-hash-seal",
						c: "Oddball OIW OID"
					},
					"1.3.14.3.2.24": {
						d: "md2WithRSASignature",
						c: "Oddball OIW OID using 9796-2 padding rules"
					},
					"1.3.14.3.2.25": {
						d: "md5WithRSASignature",
						c: "Oddball OIW OID using 9796-2 padding rules"
					},
					"1.3.14.3.2.26": {
						d: "sha1",
						c: "OIW"
					},
					"1.3.14.3.2.27": {
						d: "dsaWithSHA1",
						c: "OIW. This OID may also be assigned as ripemd-160"
					},
					"1.3.14.3.2.28": {
						d: "dsaWithCommonSHA1",
						c: "OIW"
					},
					"1.3.14.3.2.29": {
						d: "sha-1WithRSAEncryption",
						c: "Oddball OIW OID"
					},
					"1.3.14.3.3.1": {
						d: "simple-strong-auth-mechanism",
						c: "Oddball OIW OID"
					},
					"1.3.14.7.2.1.1": {
						d: "ElGamal",
						c: "Unsure about this OID"
					},
					"1.3.14.7.2.3.1": {
						d: "md2WithRSA",
						c: "Unsure about this OID"
					},
					"1.3.14.7.2.3.2": {
						d: "md2WithElGamal",
						c: "Unsure about this OID"
					},
					"1.3.36.1": {
						d: "document",
						c: "Teletrust document"
					},
					"1.3.36.1.1": {
						d: "finalVersion",
						c: "Teletrust document"
					},
					"1.3.36.1.2": {
						d: "draft",
						c: "Teletrust document"
					},
					"1.3.36.2": {
						d: "sio",
						c: "Teletrust sio"
					},
					"1.3.36.2.1": {
						d: "sedu",
						c: "Teletrust sio"
					},
					"1.3.36.3": {
						d: "algorithm",
						c: "Teletrust algorithm"
					},
					"1.3.36.3.1": {
						d: "encryptionAlgorithm",
						c: "Teletrust algorithm"
					},
					"1.3.36.3.1.1": {
						d: "des",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.1.1": {
						d: "desECB_pad",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.1.1.1": {
						d: "desECB_ISOpad",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.1.2.1": {
						d: "desCBC_pad",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.1.2.1.1": {
						d: "desCBC_ISOpad",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.3": {
						d: "des_3",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.3.1.1": {
						d: "des_3ECB_pad",
						c: "Teletrust encryption algorithm. EDE triple DES"
					},
					"1.3.36.3.1.3.1.1.1": {
						d: "des_3ECB_ISOpad",
						c: "Teletrust encryption algorithm. EDE triple DES"
					},
					"1.3.36.3.1.3.2.1": {
						d: "des_3CBC_pad",
						c: "Teletrust encryption algorithm. EDE triple DES"
					},
					"1.3.36.3.1.3.2.1.1": {
						d: "des_3CBC_ISOpad",
						c: "Teletrust encryption algorithm. EDE triple DES"
					},
					"1.3.36.3.1.2": {
						d: "idea",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.2.1": {
						d: "ideaECB",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.2.1.1": {
						d: "ideaECB_pad",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.2.1.1.1": {
						d: "ideaECB_ISOpad",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.2.2": {
						d: "ideaCBC",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.2.2.1": {
						d: "ideaCBC_pad",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.2.2.1.1": {
						d: "ideaCBC_ISOpad",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.2.3": {
						d: "ideaOFB",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.2.4": {
						d: "ideaCFB",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.4": {
						d: "rsaEncryption",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.4.512.17": {
						d: "rsaEncryptionWithlmod512expe17",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.5": {
						d: "bsi-1",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.5.1": {
						d: "bsi_1ECB_pad",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.5.2": {
						d: "bsi_1CBC_pad",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.1.5.2.1": {
						d: "bsi_1CBC_PEMpad",
						c: "Teletrust encryption algorithm"
					},
					"1.3.36.3.2": {
						d: "hashAlgorithm",
						c: "Teletrust algorithm"
					},
					"1.3.36.3.2.1": {
						d: "ripemd160",
						c: "Teletrust hash algorithm"
					},
					"1.3.36.3.2.2": {
						d: "ripemd128",
						c: "Teletrust hash algorithm"
					},
					"1.3.36.3.2.3": {
						d: "ripemd256",
						c: "Teletrust hash algorithm"
					},
					"1.3.36.3.2.4": {
						d: "mdc2singleLength",
						c: "Teletrust hash algorithm"
					},
					"1.3.36.3.2.5": {
						d: "mdc2doubleLength",
						c: "Teletrust hash algorithm"
					},
					"1.3.36.3.3": {
						d: "signatureAlgorithm",
						c: "Teletrust algorithm"
					},
					"1.3.36.3.3.1": {
						d: "rsaSignature",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.3.3.1.1": {
						d: "rsaSignatureWithsha1",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.3.3.1.1.1024.11": {
						d: "rsaSignatureWithsha1_l1024_l11",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.3.3.1.2": {
						d: "rsaSignatureWithripemd160",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.3.3.1.2.1024.11": {
						d: "rsaSignatureWithripemd160_l1024_l11",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.3.3.1.3": {
						d: "rsaSignatureWithrimpemd128",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.3.3.1.4": {
						d: "rsaSignatureWithrimpemd256",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.3.3.2": {
						d: "ecsieSign",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.3.3.2.1": {
						d: "ecsieSignWithsha1",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.3.3.2.2": {
						d: "ecsieSignWithripemd160",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.3.3.2.3": {
						d: "ecsieSignWithmd2",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.3.3.2.4": {
						d: "ecsieSignWithmd5",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.3.3.2.8.1.1.1": {
						d: "brainpoolP160r1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.3.2.8.1.1.2": {
						d: "brainpoolP160t1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.3.2.8.1.1.3": {
						d: "brainpoolP192r1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.3.2.8.1.1.4": {
						d: "brainpoolP192t1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.3.2.8.1.1.5": {
						d: "brainpoolP224r1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.3.2.8.1.1.6": {
						d: "brainpoolP224t1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.3.2.8.1.1.7": {
						d: "brainpoolP256r1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.3.2.8.1.1.8": {
						d: "brainpoolP256t1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.3.2.8.1.1.9": {
						d: "brainpoolP320r1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.3.2.8.1.1.10": {
						d: "brainpoolP320t1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.3.2.8.1.1.11": {
						d: "brainpoolP384r1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.3.2.8.1.1.12": {
						d: "brainpoolP384t1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.3.2.8.1.1.13": {
						d: "brainpoolP512r1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.3.2.8.1.1.14": {
						d: "brainpoolP512t1",
						c: "ECC Brainpool Standard Curves and Curve Generation"
					},
					"1.3.36.3.4": {
						d: "signatureScheme",
						c: "Teletrust algorithm"
					},
					"1.3.36.3.4.1": {
						d: "sigS_ISO9796-1",
						c: "Teletrust signature scheme"
					},
					"1.3.36.3.4.2": {
						d: "sigS_ISO9796-2",
						c: "Teletrust signature scheme"
					},
					"1.3.36.3.4.2.1": {
						d: "sigS_ISO9796-2Withred",
						c: "Teletrust signature scheme. Unsure what this is supposed to be"
					},
					"1.3.36.3.4.2.2": {
						d: "sigS_ISO9796-2Withrsa",
						c: "Teletrust signature scheme. Unsure what this is supposed to be"
					},
					"1.3.36.3.4.2.3": {
						d: "sigS_ISO9796-2Withrnd",
						c: "Teletrust signature scheme. 9796-2 with random number in padding field"
					},
					"1.3.36.4": {
						d: "attribute",
						c: "Teletrust attribute"
					},
					"1.3.36.5": {
						d: "policy",
						c: "Teletrust policy"
					},
					"1.3.36.6": {
						d: "api",
						c: "Teletrust API"
					},
					"1.3.36.6.1": {
						d: "manufacturer-specific_api",
						c: "Teletrust API"
					},
					"1.3.36.6.1.1": {
						d: "utimaco-api",
						c: "Teletrust API"
					},
					"1.3.36.6.2": {
						d: "functionality-specific_api",
						c: "Teletrust API"
					},
					"1.3.36.7": {
						d: "keymgmnt",
						c: "Teletrust key management"
					},
					"1.3.36.7.1": {
						d: "keyagree",
						c: "Teletrust key management"
					},
					"1.3.36.7.1.1": {
						d: "bsiPKE",
						c: "Teletrust key management"
					},
					"1.3.36.7.2": {
						d: "keytrans",
						c: "Teletrust key management"
					},
					"1.3.36.7.2.1": {
						d: "encISO9796-2Withrsa",
						c: "Teletrust key management. 9796-2 with key stored in hash field"
					},
					"1.3.36.8.1.1": {
						d: "Teletrust SigGConform policyIdentifier",
						c: "Teletrust policy"
					},
					"1.3.36.8.2.1": {
						d: "directoryService",
						c: "Teletrust extended key usage"
					},
					"1.3.36.8.3.1": {
						d: "dateOfCertGen",
						c: "Teletrust attribute"
					},
					"1.3.36.8.3.2": {
						d: "procuration",
						c: "Teletrust attribute"
					},
					"1.3.36.8.3.3": {
						d: "admission",
						c: "Teletrust attribute"
					},
					"1.3.36.8.3.4": {
						d: "monetaryLimit",
						c: "Teletrust attribute"
					},
					"1.3.36.8.3.5": {
						d: "declarationOfMajority",
						c: "Teletrust attribute"
					},
					"1.3.36.8.3.6": {
						d: "integratedCircuitCardSerialNumber",
						c: "Teletrust attribute"
					},
					"1.3.36.8.3.7": {
						d: "pKReference",
						c: "Teletrust attribute"
					},
					"1.3.36.8.3.8": {
						d: "restriction",
						c: "Teletrust attribute"
					},
					"1.3.36.8.3.9": {
						d: "retrieveIfAllowed",
						c: "Teletrust attribute"
					},
					"1.3.36.8.3.10": {
						d: "requestedCertificate",
						c: "Teletrust attribute"
					},
					"1.3.36.8.3.11": {
						d: "namingAuthorities",
						c: "Teletrust attribute"
					},
					"1.3.36.8.3.11.1": {
						d: "rechtWirtschaftSteuern",
						c: "Teletrust naming authorities"
					},
					"1.3.36.8.3.11.1.1": {
						d: "rechtsanwaeltin",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.2": {
						d: "rechtsanwalt",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.3": {
						d: "rechtsBeistand",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.4": {
						d: "steuerBeraterin",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.5": {
						d: "steuerBerater",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.6": {
						d: "steuerBevollmaechtigte",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.7": {
						d: "steuerBevollmaechtigter",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.8": {
						d: "notarin",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.9": {
						d: "notar",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.10": {
						d: "notarVertreterin",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.11": {
						d: "notarVertreter",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.12": {
						d: "notariatsVerwalterin",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.13": {
						d: "notariatsVerwalter",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.14": {
						d: "wirtschaftsPrueferin",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.15": {
						d: "wirtschaftsPruefer",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.16": {
						d: "vereidigteBuchprueferin",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.17": {
						d: "vereidigterBuchpruefer",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.18": {
						d: "patentAnwaeltin",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.11.1.19": {
						d: "patentAnwalt",
						c: "Teletrust ProfessionInfo"
					},
					"1.3.36.8.3.12": {
						d: "certInDirSince",
						c: "Teletrust OCSP attribute (obsolete)",
						w: !0
					},
					"1.3.36.8.3.13": {
						d: "certHash",
						c: "Teletrust OCSP attribute"
					},
					"1.3.36.8.3.14": {
						d: "nameAtBirth",
						c: "Teletrust attribute"
					},
					"1.3.36.8.3.15": {
						d: "additionalInformation",
						c: "Teletrust attribute"
					},
					"1.3.36.8.4.1": {
						d: "personalData",
						c: "Teletrust OtherName attribute"
					},
					"1.3.36.8.4.8": {
						d: "restriction",
						c: "Teletrust attribute certificate attribute"
					},
					"1.3.36.8.5.1.1.1": {
						d: "rsaIndicateSHA1",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.8.5.1.1.2": {
						d: "rsaIndicateRIPEMD160",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.8.5.1.1.3": {
						d: "rsaWithSHA1",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.8.5.1.1.4": {
						d: "rsaWithRIPEMD160",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.8.5.1.2.1": {
						d: "dsaExtended",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.8.5.1.2.2": {
						d: "dsaWithRIPEMD160",
						c: "Teletrust signature algorithm"
					},
					"1.3.36.8.6.1": {
						d: "cert",
						c: "Teletrust signature attributes"
					},
					"1.3.36.8.6.2": {
						d: "certRef",
						c: "Teletrust signature attributes"
					},
					"1.3.36.8.6.3": {
						d: "attrCert",
						c: "Teletrust signature attributes"
					},
					"1.3.36.8.6.4": {
						d: "attrRef",
						c: "Teletrust signature attributes"
					},
					"1.3.36.8.6.5": {
						d: "fileName",
						c: "Teletrust signature attributes"
					},
					"1.3.36.8.6.6": {
						d: "storageTime",
						c: "Teletrust signature attributes"
					},
					"1.3.36.8.6.7": {
						d: "fileSize",
						c: "Teletrust signature attributes"
					},
					"1.3.36.8.6.8": {
						d: "location",
						c: "Teletrust signature attributes"
					},
					"1.3.36.8.6.9": {
						d: "sigNumber",
						c: "Teletrust signature attributes"
					},
					"1.3.36.8.6.10": {
						d: "autoGen",
						c: "Teletrust signature attributes"
					},
					"1.3.36.8.7.1.1": {
						d: "ptAdobeILL",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.2": {
						d: "ptAmiPro",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.3": {
						d: "ptAutoCAD",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.4": {
						d: "ptBinary",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.5": {
						d: "ptBMP",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.6": {
						d: "ptCGM",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.7": {
						d: "ptCorelCRT",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.8": {
						d: "ptCorelDRW",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.9": {
						d: "ptCorelEXC",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.10": {
						d: "ptCorelPHT",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.11": {
						d: "ptDraw",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.12": {
						d: "ptDVI",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.13": {
						d: "ptEPS",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.14": {
						d: "ptExcel",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.15": {
						d: "ptGEM",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.16": {
						d: "ptGIF",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.17": {
						d: "ptHPGL",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.18": {
						d: "ptJPEG",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.19": {
						d: "ptKodak",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.20": {
						d: "ptLaTeX",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.21": {
						d: "ptLotus",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.22": {
						d: "ptLotusPIC",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.23": {
						d: "ptMacPICT",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.24": {
						d: "ptMacWord",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.25": {
						d: "ptMSWfD",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.26": {
						d: "ptMSWord",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.27": {
						d: "ptMSWord2",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.28": {
						d: "ptMSWord6",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.29": {
						d: "ptMSWord8",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.30": {
						d: "ptPDF",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.31": {
						d: "ptPIF",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.32": {
						d: "ptPostscript",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.33": {
						d: "ptRTF",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.34": {
						d: "ptSCITEX",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.35": {
						d: "ptTAR",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.36": {
						d: "ptTarga",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.37": {
						d: "ptTeX",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.38": {
						d: "ptText",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.39": {
						d: "ptTIFF",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.40": {
						d: "ptTIFF-FC",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.41": {
						d: "ptUID",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.42": {
						d: "ptUUEncode",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.43": {
						d: "ptWMF",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.44": {
						d: "ptWordPerfect",
						c: "Teletrust presentation types"
					},
					"1.3.36.8.7.1.45": {
						d: "ptWPGrph",
						c: "Teletrust presentation types"
					},
					"1.3.101.1.4": {
						d: "thawte-ce",
						c: "Thawte"
					},
					"1.3.101.1.4.1": {
						d: "strongExtranet",
						c: "Thawte certificate extension"
					},
					"1.3.101.110": {
						d: "curveX25519",
						c: "ECDH 25519 key agreement algorithm"
					},
					"1.3.101.111": {
						d: "curveX448",
						c: "ECDH 448 key agreement algorithm"
					},
					"1.3.101.112": {
						d: "curveEd25519",
						c: "EdDSA 25519 signature algorithm"
					},
					"1.3.101.113": {
						d: "curveEd448",
						c: "EdDSA 448 signature algorithm"
					},
					"1.3.101.114": {
						d: "curveEd25519ph",
						c: "EdDSA 25519 pre-hash signature algorithm"
					},
					"1.3.101.115": {
						d: "curveEd448ph",
						c: "EdDSA 448 pre-hash signature algorithm"
					},
					"1.3.132.0.1": {
						d: "sect163k1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.2": {
						d: "sect163r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.3": {
						d: "sect239k1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.4": {
						d: "sect113r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.5": {
						d: "sect113r2",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.6": {
						d: "secp112r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.7": {
						d: "secp112r2",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.8": {
						d: "secp160r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.9": {
						d: "secp160k1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.10": {
						d: "secp256k1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.15": {
						d: "sect163r2",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.16": {
						d: "sect283k1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.17": {
						d: "sect283r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.22": {
						d: "sect131r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.23": {
						d: "sect131r2",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.24": {
						d: "sect193r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.25": {
						d: "sect193r2",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.26": {
						d: "sect233k1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.27": {
						d: "sect233r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.28": {
						d: "secp128r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.29": {
						d: "secp128r2",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.30": {
						d: "secp160r2",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.31": {
						d: "secp192k1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.32": {
						d: "secp224k1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.33": {
						d: "secp224r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.34": {
						d: "secp384r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.35": {
						d: "secp521r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.36": {
						d: "sect409k1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.37": {
						d: "sect409r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.38": {
						d: "sect571k1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.0.39": {
						d: "sect571r1",
						c: "SECG (Certicom) named elliptic curve"
					},
					"1.3.132.1.11.1": {
						d: "ecdhX963KDF-SHA256",
						c: "SECG (Certicom) elliptic curve key agreement"
					},
					"1.3.132.1.11.2": {
						d: "ecdhX963KDF-SHA384",
						c: "SECG (Certicom) elliptic curve key agreement"
					},
					"1.3.132.1.11.3": {
						d: "ecdhX963KDF-SHA512",
						c: "SECG (Certicom) elliptic curve key agreement"
					},
					"1.3.133.16.840.9.44": {
						d: "x944",
						c: "X9.44"
					},
					"1.3.133.16.840.9.44.1": {
						d: "x944Components",
						c: "X9.44"
					},
					"1.3.133.16.840.9.44.1.1": {
						d: "x944Kdf2",
						c: "X9.44"
					},
					"1.3.133.16.840.9.44.1.2": {
						d: "x944Kdf3",
						c: "X9.44"
					},
					"1.3.133.16.840.9.84": {
						d: "x984",
						c: "X9.84"
					},
					"1.3.133.16.840.9.84.0": {
						d: "x984Module",
						c: "X9.84"
					},
					"1.3.133.16.840.9.84.0.1": {
						d: "x984Biometrics",
						c: "X9.84 Module"
					},
					"1.3.133.16.840.9.84.0.2": {
						d: "x984CMS",
						c: "X9.84 Module"
					},
					"1.3.133.16.840.9.84.0.3": {
						d: "x984Identifiers",
						c: "X9.84 Module"
					},
					"1.3.133.16.840.9.84.1": {
						d: "x984Biometric",
						c: "X9.84"
					},
					"1.3.133.16.840.9.84.1.0": {
						d: "biometricUnknownType",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.1": {
						d: "biometricBodyOdor",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.2": {
						d: "biometricDNA",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.3": {
						d: "biometricEarShape",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.4": {
						d: "biometricFacialFeatures",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.5": {
						d: "biometricFingerImage",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.6": {
						d: "biometricFingerGeometry",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.7": {
						d: "biometricHandGeometry",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.8": {
						d: "biometricIrisFeatures",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.9": {
						d: "biometricKeystrokeDynamics",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.10": {
						d: "biometricPalm",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.11": {
						d: "biometricRetina",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.12": {
						d: "biometricSignature",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.13": {
						d: "biometricSpeechPattern",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.14": {
						d: "biometricThermalImage",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.15": {
						d: "biometricVeinPattern",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.16": {
						d: "biometricThermalFaceImage",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.17": {
						d: "biometricThermalHandImage",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.18": {
						d: "biometricLipMovement",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.1.19": {
						d: "biometricGait",
						c: "X9.84 Biometric"
					},
					"1.3.133.16.840.9.84.3": {
						d: "x984MatchingMethod",
						c: "X9.84"
					},
					"1.3.133.16.840.9.84.4": {
						d: "x984FormatOwner",
						c: "X9.84"
					},
					"1.3.133.16.840.9.84.4.0": {
						d: "x984CbeffOwner",
						c: "X9.84 Format Owner"
					},
					"1.3.133.16.840.9.84.4.1": {
						d: "x984IbiaOwner",
						c: "X9.84 Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.1": {
						d: "ibiaOwnerSAFLINK",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.2": {
						d: "ibiaOwnerBioscrypt",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.3": {
						d: "ibiaOwnerVisionics",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.4": {
						d: "ibiaOwnerInfineonTechnologiesAG",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.5": {
						d: "ibiaOwnerIridianTechnologies",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.6": {
						d: "ibiaOwnerVeridicom",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.7": {
						d: "ibiaOwnerCyberSIGN",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.8": {
						d: "ibiaOwnereCryp",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.9": {
						d: "ibiaOwnerFingerprintCardsAB",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.10": {
						d: "ibiaOwnerSecuGen",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.11": {
						d: "ibiaOwnerPreciseBiometric",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.12": {
						d: "ibiaOwnerIdentix",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.13": {
						d: "ibiaOwnerDERMALOG",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.14": {
						d: "ibiaOwnerLOGICO",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.15": {
						d: "ibiaOwnerNIST",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.16": {
						d: "ibiaOwnerA3Vision",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.17": {
						d: "ibiaOwnerNEC",
						c: "X9.84 IBIA Format Owner"
					},
					"1.3.133.16.840.9.84.4.1.18": {
						d: "ibiaOwnerSTMicroelectronics",
						c: "X9.84 IBIA Format Owner"
					},
					"2.5.4.0": {
						d: "objectClass",
						c: "X.520 DN component"
					},
					"2.5.4.1": {
						d: "aliasedEntryName",
						c: "X.520 DN component"
					},
					"2.5.4.2": {
						d: "knowledgeInformation",
						c: "X.520 DN component"
					},
					"2.5.4.3": {
						d: "commonName",
						c: "X.520 DN component"
					},
					"2.5.4.4": {
						d: "surname",
						c: "X.520 DN component"
					},
					"2.5.4.5": {
						d: "serialNumber",
						c: "X.520 DN component"
					},
					"2.5.4.6": {
						d: "countryName",
						c: "X.520 DN component"
					},
					"2.5.4.7": {
						d: "localityName",
						c: "X.520 DN component"
					},
					"2.5.4.7.1": {
						d: "collectiveLocalityName",
						c: "X.520 DN component"
					},
					"2.5.4.8": {
						d: "stateOrProvinceName",
						c: "X.520 DN component"
					},
					"2.5.4.8.1": {
						d: "collectiveStateOrProvinceName",
						c: "X.520 DN component"
					},
					"2.5.4.9": {
						d: "streetAddress",
						c: "X.520 DN component"
					},
					"2.5.4.9.1": {
						d: "collectiveStreetAddress",
						c: "X.520 DN component"
					},
					"2.5.4.10": {
						d: "organizationName",
						c: "X.520 DN component"
					},
					"2.5.4.10.1": {
						d: "collectiveOrganizationName",
						c: "X.520 DN component"
					},
					"2.5.4.11": {
						d: "organizationalUnitName",
						c: "X.520 DN component"
					},
					"2.5.4.11.1": {
						d: "collectiveOrganizationalUnitName",
						c: "X.520 DN component"
					},
					"2.5.4.12": {
						d: "title",
						c: "X.520 DN component"
					},
					"2.5.4.13": {
						d: "description",
						c: "X.520 DN component"
					},
					"2.5.4.14": {
						d: "searchGuide",
						c: "X.520 DN component"
					},
					"2.5.4.15": {
						d: "businessCategory",
						c: "X.520 DN component"
					},
					"2.5.4.16": {
						d: "postalAddress",
						c: "X.520 DN component"
					},
					"2.5.4.16.1": {
						d: "collectivePostalAddress",
						c: "X.520 DN component"
					},
					"2.5.4.17": {
						d: "postalCode",
						c: "X.520 DN component"
					},
					"2.5.4.17.1": {
						d: "collectivePostalCode",
						c: "X.520 DN component"
					},
					"2.5.4.18": {
						d: "postOfficeBox",
						c: "X.520 DN component"
					},
					"2.5.4.18.1": {
						d: "collectivePostOfficeBox",
						c: "X.520 DN component"
					},
					"2.5.4.19": {
						d: "physicalDeliveryOfficeName",
						c: "X.520 DN component"
					},
					"2.5.4.19.1": {
						d: "collectivePhysicalDeliveryOfficeName",
						c: "X.520 DN component"
					},
					"2.5.4.20": {
						d: "telephoneNumber",
						c: "X.520 DN component"
					},
					"2.5.4.20.1": {
						d: "collectiveTelephoneNumber",
						c: "X.520 DN component"
					},
					"2.5.4.21": {
						d: "telexNumber",
						c: "X.520 DN component"
					},
					"2.5.4.21.1": {
						d: "collectiveTelexNumber",
						c: "X.520 DN component"
					},
					"2.5.4.22": {
						d: "teletexTerminalIdentifier",
						c: "X.520 DN component"
					},
					"2.5.4.22.1": {
						d: "collectiveTeletexTerminalIdentifier",
						c: "X.520 DN component"
					},
					"2.5.4.23": {
						d: "facsimileTelephoneNumber",
						c: "X.520 DN component"
					},
					"2.5.4.23.1": {
						d: "collectiveFacsimileTelephoneNumber",
						c: "X.520 DN component"
					},
					"2.5.4.24": {
						d: "x121Address",
						c: "X.520 DN component"
					},
					"2.5.4.25": {
						d: "internationalISDNNumber",
						c: "X.520 DN component"
					},
					"2.5.4.25.1": {
						d: "collectiveInternationalISDNNumber",
						c: "X.520 DN component"
					},
					"2.5.4.26": {
						d: "registeredAddress",
						c: "X.520 DN component"
					},
					"2.5.4.27": {
						d: "destinationIndicator",
						c: "X.520 DN component"
					},
					"2.5.4.28": {
						d: "preferredDeliveryMehtod",
						c: "X.520 DN component"
					},
					"2.5.4.29": {
						d: "presentationAddress",
						c: "X.520 DN component"
					},
					"2.5.4.30": {
						d: "supportedApplicationContext",
						c: "X.520 DN component"
					},
					"2.5.4.31": {
						d: "member",
						c: "X.520 DN component"
					},
					"2.5.4.32": {
						d: "owner",
						c: "X.520 DN component"
					},
					"2.5.4.33": {
						d: "roleOccupant",
						c: "X.520 DN component"
					},
					"2.5.4.34": {
						d: "seeAlso",
						c: "X.520 DN component"
					},
					"2.5.4.35": {
						d: "userPassword",
						c: "X.520 DN component"
					},
					"2.5.4.36": {
						d: "userCertificate",
						c: "X.520 DN component"
					},
					"2.5.4.37": {
						d: "caCertificate",
						c: "X.520 DN component"
					},
					"2.5.4.38": {
						d: "authorityRevocationList",
						c: "X.520 DN component"
					},
					"2.5.4.39": {
						d: "certificateRevocationList",
						c: "X.520 DN component"
					},
					"2.5.4.40": {
						d: "crossCertificatePair",
						c: "X.520 DN component"
					},
					"2.5.4.41": {
						d: "name",
						c: "X.520 DN component"
					},
					"2.5.4.42": {
						d: "givenName",
						c: "X.520 DN component"
					},
					"2.5.4.43": {
						d: "initials",
						c: "X.520 DN component"
					},
					"2.5.4.44": {
						d: "generationQualifier",
						c: "X.520 DN component"
					},
					"2.5.4.45": {
						d: "uniqueIdentifier",
						c: "X.520 DN component"
					},
					"2.5.4.46": {
						d: "dnQualifier",
						c: "X.520 DN component"
					},
					"2.5.4.47": {
						d: "enhancedSearchGuide",
						c: "X.520 DN component"
					},
					"2.5.4.48": {
						d: "protocolInformation",
						c: "X.520 DN component"
					},
					"2.5.4.49": {
						d: "distinguishedName",
						c: "X.520 DN component"
					},
					"2.5.4.50": {
						d: "uniqueMember",
						c: "X.520 DN component"
					},
					"2.5.4.51": {
						d: "houseIdentifier",
						c: "X.520 DN component"
					},
					"2.5.4.52": {
						d: "supportedAlgorithms",
						c: "X.520 DN component"
					},
					"2.5.4.53": {
						d: "deltaRevocationList",
						c: "X.520 DN component"
					},
					"2.5.4.54": {
						d: "dmdName",
						c: "X.520 DN component"
					},
					"2.5.4.55": {
						d: "clearance",
						c: "X.520 DN component"
					},
					"2.5.4.56": {
						d: "defaultDirQop",
						c: "X.520 DN component"
					},
					"2.5.4.57": {
						d: "attributeIntegrityInfo",
						c: "X.520 DN component"
					},
					"2.5.4.58": {
						d: "attributeCertificate",
						c: "X.520 DN component"
					},
					"2.5.4.59": {
						d: "attributeCertificateRevocationList",
						c: "X.520 DN component"
					},
					"2.5.4.60": {
						d: "confKeyInfo",
						c: "X.520 DN component"
					},
					"2.5.4.61": {
						d: "aACertificate",
						c: "X.520 DN component"
					},
					"2.5.4.62": {
						d: "attributeDescriptorCertificate",
						c: "X.520 DN component"
					},
					"2.5.4.63": {
						d: "attributeAuthorityRevocationList",
						c: "X.520 DN component"
					},
					"2.5.4.64": {
						d: "familyInformation",
						c: "X.520 DN component"
					},
					"2.5.4.65": {
						d: "pseudonym",
						c: "X.520 DN component"
					},
					"2.5.4.66": {
						d: "communicationsService",
						c: "X.520 DN component"
					},
					"2.5.4.67": {
						d: "communicationsNetwork",
						c: "X.520 DN component"
					},
					"2.5.4.68": {
						d: "certificationPracticeStmt",
						c: "X.520 DN component"
					},
					"2.5.4.69": {
						d: "certificatePolicy",
						c: "X.520 DN component"
					},
					"2.5.4.70": {
						d: "pkiPath",
						c: "X.520 DN component"
					},
					"2.5.4.71": {
						d: "privPolicy",
						c: "X.520 DN component"
					},
					"2.5.4.72": {
						d: "role",
						c: "X.520 DN component"
					},
					"2.5.4.73": {
						d: "delegationPath",
						c: "X.520 DN component"
					},
					"2.5.4.74": {
						d: "protPrivPolicy",
						c: "X.520 DN component"
					},
					"2.5.4.75": {
						d: "xMLPrivilegeInfo",
						c: "X.520 DN component"
					},
					"2.5.4.76": {
						d: "xmlPrivPolicy",
						c: "X.520 DN component"
					},
					"2.5.4.77": {
						d: "uuidpair",
						c: "X.520 DN component"
					},
					"2.5.4.78": {
						d: "tagOid",
						c: "X.520 DN component"
					},
					"2.5.4.79": {
						d: "uiiFormat",
						c: "X.520 DN component"
					},
					"2.5.4.80": {
						d: "uiiInUrh",
						c: "X.520 DN component"
					},
					"2.5.4.81": {
						d: "contentUrl",
						c: "X.520 DN component"
					},
					"2.5.4.82": {
						d: "permission",
						c: "X.520 DN component"
					},
					"2.5.4.83": {
						d: "uri",
						c: "X.520 DN component"
					},
					"2.5.4.84": {
						d: "pwdAttribute",
						c: "X.520 DN component"
					},
					"2.5.4.85": {
						d: "userPwd",
						c: "X.520 DN component"
					},
					"2.5.4.86": {
						d: "urn",
						c: "X.520 DN component"
					},
					"2.5.4.87": {
						d: "url",
						c: "X.520 DN component"
					},
					"2.5.4.88": {
						d: "utmCoordinates",
						c: "X.520 DN component"
					},
					"2.5.4.89": {
						d: "urnC",
						c: "X.520 DN component"
					},
					"2.5.4.90": {
						d: "uii",
						c: "X.520 DN component"
					},
					"2.5.4.91": {
						d: "epc",
						c: "X.520 DN component"
					},
					"2.5.4.92": {
						d: "tagAfi",
						c: "X.520 DN component"
					},
					"2.5.4.93": {
						d: "epcFormat",
						c: "X.520 DN component"
					},
					"2.5.4.94": {
						d: "epcInUrn",
						c: "X.520 DN component"
					},
					"2.5.4.95": {
						d: "ldapUrl",
						c: "X.520 DN component"
					},
					"2.5.4.96": {
						d: "tagLocation",
						c: "X.520 DN component"
					},
					"2.5.4.97": {
						d: "organizationIdentifier",
						c: "X.520 DN component"
					},
					"2.5.4.98": {
						d: "countryCode3c",
						c: "X.520 DN component"
					},
					"2.5.4.99": {
						d: "countryCode3n",
						c: "X.520 DN component"
					},
					"2.5.4.100": {
						d: "dnsName",
						c: "X.520 DN component"
					},
					"2.5.4.101": {
						d: "eepkCertificateRevocationList",
						c: "X.520 DN component"
					},
					"2.5.4.102": {
						d: "eeAttrCertificateRevocationList",
						c: "X.520 DN component"
					},
					"2.5.4.103": {
						d: "supportedPublicKeyAlgorithms",
						c: "X.520 DN component"
					},
					"2.5.4.104": {
						d: "intEmail",
						c: "X.520 DN component"
					},
					"2.5.4.105": {
						d: "jid",
						c: "X.520 DN component"
					},
					"2.5.4.106": {
						d: "objectIdentifier",
						c: "X.520 DN component"
					},
					"2.5.6.0": {
						d: "top",
						c: "X.520 objectClass"
					},
					"2.5.6.1": {
						d: "alias",
						c: "X.520 objectClass"
					},
					"2.5.6.2": {
						d: "country",
						c: "X.520 objectClass"
					},
					"2.5.6.3": {
						d: "locality",
						c: "X.520 objectClass"
					},
					"2.5.6.4": {
						d: "organization",
						c: "X.520 objectClass"
					},
					"2.5.6.5": {
						d: "organizationalUnit",
						c: "X.520 objectClass"
					},
					"2.5.6.6": {
						d: "person",
						c: "X.520 objectClass"
					},
					"2.5.6.7": {
						d: "organizationalPerson",
						c: "X.520 objectClass"
					},
					"2.5.6.8": {
						d: "organizationalRole",
						c: "X.520 objectClass"
					},
					"2.5.6.9": {
						d: "groupOfNames",
						c: "X.520 objectClass"
					},
					"2.5.6.10": {
						d: "residentialPerson",
						c: "X.520 objectClass"
					},
					"2.5.6.11": {
						d: "applicationProcess",
						c: "X.520 objectClass"
					},
					"2.5.6.12": {
						d: "applicationEntity",
						c: "X.520 objectClass"
					},
					"2.5.6.13": {
						d: "dSA",
						c: "X.520 objectClass"
					},
					"2.5.6.14": {
						d: "device",
						c: "X.520 objectClass"
					},
					"2.5.6.15": {
						d: "strongAuthenticationUser",
						c: "X.520 objectClass"
					},
					"2.5.6.16": {
						d: "certificateAuthority",
						c: "X.520 objectClass"
					},
					"2.5.6.17": {
						d: "groupOfUniqueNames",
						c: "X.520 objectClass"
					},
					"2.5.6.21": {
						d: "pkiUser",
						c: "X.520 objectClass"
					},
					"2.5.6.22": {
						d: "pkiCA",
						c: "X.520 objectClass"
					},
					"2.5.8.1.1": {
						d: "rsa",
						c: "X.500 algorithms.  Ambiguous, since no padding rules specified",
						w: !0
					},
					"2.5.29.1": {
						d: "authorityKeyIdentifier",
						c: "X.509 extension.  Deprecated, use 2 5 29 35 instead",
						w: !0
					},
					"2.5.29.2": {
						d: "keyAttributes",
						c: "X.509 extension.  Obsolete, use keyUsage/extKeyUsage instead",
						w: !0
					},
					"2.5.29.3": {
						d: "certificatePolicies",
						c: "X.509 extension.  Deprecated, use 2 5 29 32 instead",
						w: !0
					},
					"2.5.29.4": {
						d: "keyUsageRestriction",
						c: "X.509 extension.  Obsolete, use keyUsage/extKeyUsage instead",
						w: !0
					},
					"2.5.29.5": {
						d: "policyMapping",
						c: "X.509 extension.  Deprecated, use 2 5 29 33 instead",
						w: !0
					},
					"2.5.29.6": {
						d: "subtreesConstraint",
						c: "X.509 extension.  Obsolete, use nameConstraints instead",
						w: !0
					},
					"2.5.29.7": {
						d: "subjectAltName",
						c: "X.509 extension.  Deprecated, use 2 5 29 17 instead",
						w: !0
					},
					"2.5.29.8": {
						d: "issuerAltName",
						c: "X.509 extension.  Deprecated, use 2 5 29 18 instead",
						w: !0
					},
					"2.5.29.9": {
						d: "subjectDirectoryAttributes",
						c: "X.509 extension"
					},
					"2.5.29.10": {
						d: "basicConstraints",
						c: "X.509 extension.  Deprecated, use 2 5 29 19 instead",
						w: !0
					},
					"2.5.29.11": {
						d: "nameConstraints",
						c: "X.509 extension.  Deprecated, use 2 5 29 30 instead",
						w: !0
					},
					"2.5.29.12": {
						d: "policyConstraints",
						c: "X.509 extension.  Deprecated, use 2 5 29 36 instead",
						w: !0
					},
					"2.5.29.13": {
						d: "basicConstraints",
						c: "X.509 extension.  Deprecated, use 2 5 29 19 instead",
						w: !0
					},
					"2.5.29.14": {
						d: "subjectKeyIdentifier",
						c: "X.509 extension"
					},
					"2.5.29.15": {
						d: "keyUsage",
						c: "X.509 extension"
					},
					"2.5.29.16": {
						d: "privateKeyUsagePeriod",
						c: "X.509 extension"
					},
					"2.5.29.17": {
						d: "subjectAltName",
						c: "X.509 extension"
					},
					"2.5.29.18": {
						d: "issuerAltName",
						c: "X.509 extension"
					},
					"2.5.29.19": {
						d: "basicConstraints",
						c: "X.509 extension"
					},
					"2.5.29.20": {
						d: "cRLNumber",
						c: "X.509 extension"
					},
					"2.5.29.21": {
						d: "cRLReason",
						c: "X.509 extension"
					},
					"2.5.29.22": {
						d: "expirationDate",
						c: "X.509 extension.  Deprecated, alternative OID uncertain",
						w: !0
					},
					"2.5.29.23": {
						d: "instructionCode",
						c: "X.509 extension"
					},
					"2.5.29.24": {
						d: "invalidityDate",
						c: "X.509 extension"
					},
					"2.5.29.25": {
						d: "cRLDistributionPoints",
						c: "X.509 extension.  Deprecated, use 2 5 29 31 instead",
						w: !0
					},
					"2.5.29.26": {
						d: "issuingDistributionPoint",
						c: "X.509 extension.  Deprecated, use 2 5 29 28 instead",
						w: !0
					},
					"2.5.29.27": {
						d: "deltaCRLIndicator",
						c: "X.509 extension"
					},
					"2.5.29.28": {
						d: "issuingDistributionPoint",
						c: "X.509 extension"
					},
					"2.5.29.29": {
						d: "certificateIssuer",
						c: "X.509 extension"
					},
					"2.5.29.30": {
						d: "nameConstraints",
						c: "X.509 extension"
					},
					"2.5.29.31": {
						d: "cRLDistributionPoints",
						c: "X.509 extension"
					},
					"2.5.29.32": {
						d: "certificatePolicies",
						c: "X.509 extension"
					},
					"2.5.29.32.0": {
						d: "anyPolicy",
						c: "X.509 certificate policy"
					},
					"2.5.29.33": {
						d: "policyMappings",
						c: "X.509 extension"
					},
					"2.5.29.34": {
						d: "policyConstraints",
						c: "X.509 extension.  Deprecated, use 2 5 29 36 instead",
						w: !0
					},
					"2.5.29.35": {
						d: "authorityKeyIdentifier",
						c: "X.509 extension"
					},
					"2.5.29.36": {
						d: "policyConstraints",
						c: "X.509 extension"
					},
					"2.5.29.37": {
						d: "extKeyUsage",
						c: "X.509 extension"
					},
					"2.5.29.37.0": {
						d: "anyExtendedKeyUsage",
						c: "X.509 extended key usage"
					},
					"2.5.29.38": {
						d: "authorityAttributeIdentifier",
						c: "X.509 extension"
					},
					"2.5.29.39": {
						d: "roleSpecCertIdentifier",
						c: "X.509 extension"
					},
					"2.5.29.40": {
						d: "cRLStreamIdentifier",
						c: "X.509 extension"
					},
					"2.5.29.41": {
						d: "basicAttConstraints",
						c: "X.509 extension"
					},
					"2.5.29.42": {
						d: "delegatedNameConstraints",
						c: "X.509 extension"
					},
					"2.5.29.43": {
						d: "timeSpecification",
						c: "X.509 extension"
					},
					"2.5.29.44": {
						d: "cRLScope",
						c: "X.509 extension"
					},
					"2.5.29.45": {
						d: "statusReferrals",
						c: "X.509 extension"
					},
					"2.5.29.46": {
						d: "freshestCRL",
						c: "X.509 extension"
					},
					"2.5.29.47": {
						d: "orderedList",
						c: "X.509 extension"
					},
					"2.5.29.48": {
						d: "attributeDescriptor",
						c: "X.509 extension"
					},
					"2.5.29.49": {
						d: "userNotice",
						c: "X.509 extension"
					},
					"2.5.29.50": {
						d: "sOAIdentifier",
						c: "X.509 extension"
					},
					"2.5.29.51": {
						d: "baseUpdateTime",
						c: "X.509 extension"
					},
					"2.5.29.52": {
						d: "acceptableCertPolicies",
						c: "X.509 extension"
					},
					"2.5.29.53": {
						d: "deltaInfo",
						c: "X.509 extension"
					},
					"2.5.29.54": {
						d: "inhibitAnyPolicy",
						c: "X.509 extension"
					},
					"2.5.29.55": {
						d: "targetInformation",
						c: "X.509 extension"
					},
					"2.5.29.56": {
						d: "noRevAvail",
						c: "X.509 extension"
					},
					"2.5.29.57": {
						d: "acceptablePrivilegePolicies",
						c: "X.509 extension"
					},
					"2.5.29.58": {
						d: "toBeRevoked",
						c: "X.509 extension"
					},
					"2.5.29.59": {
						d: "revokedGroups",
						c: "X.509 extension"
					},
					"2.5.29.60": {
						d: "expiredCertsOnCRL",
						c: "X.509 extension"
					},
					"2.5.29.61": {
						d: "indirectIssuer",
						c: "X.509 extension"
					},
					"2.5.29.62": {
						d: "noAssertion",
						c: "X.509 extension"
					},
					"2.5.29.63": {
						d: "aAissuingDistributionPoint",
						c: "X.509 extension"
					},
					"2.5.29.64": {
						d: "issuedOnBehalfOf",
						c: "X.509 extension"
					},
					"2.5.29.65": {
						d: "singleUse",
						c: "X.509 extension"
					},
					"2.5.29.66": {
						d: "groupAC",
						c: "X.509 extension"
					},
					"2.5.29.67": {
						d: "allowedAttAss",
						c: "X.509 extension"
					},
					"2.5.29.68": {
						d: "attributeMappings",
						c: "X.509 extension"
					},
					"2.5.29.69": {
						d: "holderNameConstraints",
						c: "X.509 extension"
					},
					"2.16.724.1.2.2.4.1": {
						d: "personalDataInfo",
						c: "Spanish Government PKI?"
					},
					"2.16.840.1.101.2.1.1.1": {
						d: "sdnsSignatureAlgorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.1.2": {
						d: "fortezzaSignatureAlgorithm",
						c: "SDN.700 INFOSEC algorithms.  Formerly known as mosaicSignatureAlgorithm, this OID is better known as dsaWithSHA-1."
					},
					"2.16.840.1.101.2.1.1.3": {
						d: "sdnsConfidentialityAlgorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.1.4": {
						d: "fortezzaConfidentialityAlgorithm",
						c: "SDN.700 INFOSEC algorithms.  Formerly known as mosaicConfidentialityAlgorithm"
					},
					"2.16.840.1.101.2.1.1.5": {
						d: "sdnsIntegrityAlgorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.1.6": {
						d: "fortezzaIntegrityAlgorithm",
						c: "SDN.700 INFOSEC algorithms.  Formerly known as mosaicIntegrityAlgorithm"
					},
					"2.16.840.1.101.2.1.1.7": {
						d: "sdnsTokenProtectionAlgorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.1.8": {
						d: "fortezzaTokenProtectionAlgorithm",
						c: "SDN.700 INFOSEC algorithms.  Formerly know as mosaicTokenProtectionAlgorithm"
					},
					"2.16.840.1.101.2.1.1.9": {
						d: "sdnsKeyManagementAlgorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.1.10": {
						d: "fortezzaKeyManagementAlgorithm",
						c: "SDN.700 INFOSEC algorithms.  Formerly known as mosaicKeyManagementAlgorithm"
					},
					"2.16.840.1.101.2.1.1.11": {
						d: "sdnsKMandSigAlgorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.1.12": {
						d: "fortezzaKMandSigAlgorithm",
						c: "SDN.700 INFOSEC algorithms.  Formerly known as mosaicKMandSigAlgorithm"
					},
					"2.16.840.1.101.2.1.1.13": {
						d: "suiteASignatureAlgorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.1.14": {
						d: "suiteAConfidentialityAlgorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.1.15": {
						d: "suiteAIntegrityAlgorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.1.16": {
						d: "suiteATokenProtectionAlgorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.1.17": {
						d: "suiteAKeyManagementAlgorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.1.18": {
						d: "suiteAKMandSigAlgorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.1.19": {
						d: "fortezzaUpdatedSigAlgorithm",
						c: "SDN.700 INFOSEC algorithms.  Formerly known as mosaicUpdatedSigAlgorithm"
					},
					"2.16.840.1.101.2.1.1.20": {
						d: "fortezzaKMandUpdSigAlgorithms",
						c: "SDN.700 INFOSEC algorithms.  Formerly known as mosaicKMandUpdSigAlgorithms"
					},
					"2.16.840.1.101.2.1.1.21": {
						d: "fortezzaUpdatedIntegAlgorithm",
						c: "SDN.700 INFOSEC algorithms.  Formerly known as mosaicUpdatedIntegAlgorithm"
					},
					"2.16.840.1.101.2.1.1.22": {
						d: "keyExchangeAlgorithm",
						c: "SDN.700 INFOSEC algorithms.  Formerly known as mosaicKeyEncryptionAlgorithm"
					},
					"2.16.840.1.101.2.1.1.23": {
						d: "fortezzaWrap80Algorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.1.24": {
						d: "kEAKeyEncryptionAlgorithm",
						c: "SDN.700 INFOSEC algorithms"
					},
					"2.16.840.1.101.2.1.2.1": {
						d: "rfc822MessageFormat",
						c: "SDN.700 INFOSEC format"
					},
					"2.16.840.1.101.2.1.2.2": {
						d: "emptyContent",
						c: "SDN.700 INFOSEC format"
					},
					"2.16.840.1.101.2.1.2.3": {
						d: "cspContentType",
						c: "SDN.700 INFOSEC format"
					},
					"2.16.840.1.101.2.1.2.42": {
						d: "mspRev3ContentType",
						c: "SDN.700 INFOSEC format"
					},
					"2.16.840.1.101.2.1.2.48": {
						d: "mspContentType",
						c: "SDN.700 INFOSEC format"
					},
					"2.16.840.1.101.2.1.2.49": {
						d: "mspRekeyAgentProtocol",
						c: "SDN.700 INFOSEC format"
					},
					"2.16.840.1.101.2.1.2.50": {
						d: "mspMMP",
						c: "SDN.700 INFOSEC format"
					},
					"2.16.840.1.101.2.1.2.66": {
						d: "mspRev3-1ContentType",
						c: "SDN.700 INFOSEC format"
					},
					"2.16.840.1.101.2.1.2.72": {
						d: "forwardedMSPMessageBodyPart",
						c: "SDN.700 INFOSEC format"
					},
					"2.16.840.1.101.2.1.2.73": {
						d: "mspForwardedMessageParameters",
						c: "SDN.700 INFOSEC format"
					},
					"2.16.840.1.101.2.1.2.74": {
						d: "forwardedCSPMsgBodyPart",
						c: "SDN.700 INFOSEC format"
					},
					"2.16.840.1.101.2.1.2.75": {
						d: "cspForwardedMessageParameters",
						c: "SDN.700 INFOSEC format"
					},
					"2.16.840.1.101.2.1.2.76": {
						d: "mspMMP2",
						c: "SDN.700 INFOSEC format"
					},
					"2.16.840.1.101.2.1.2.78.2": {
						d: "encryptedKeyPackage",
						c: "SDN.700 INFOSEC format and RFC 6032"
					},
					"2.16.840.1.101.2.1.2.78.3": {
						d: "keyPackageReceipt",
						c: "SDN.700 INFOSEC format and RFC 7191"
					},
					"2.16.840.1.101.2.1.2.78.6": {
						d: "keyPackageError",
						c: "SDN.700 INFOSEC format and RFC 7191"
					},
					"2.16.840.1.101.2.1.3.1": {
						d: "sdnsSecurityPolicy",
						c: "SDN.700 INFOSEC policy"
					},
					"2.16.840.1.101.2.1.3.2": {
						d: "sdnsPRBAC",
						c: "SDN.700 INFOSEC policy"
					},
					"2.16.840.1.101.2.1.3.3": {
						d: "mosaicPRBAC",
						c: "SDN.700 INFOSEC policy"
					},
					"2.16.840.1.101.2.1.3.10": {
						d: "siSecurityPolicy",
						c: "SDN.700 INFOSEC policy"
					},
					"2.16.840.1.101.2.1.3.10.0": {
						d: "siNASP",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.10.1": {
						d: "siELCO",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.10.2": {
						d: "siTK",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.10.3": {
						d: "siDSAP",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.10.4": {
						d: "siSSSS",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.10.5": {
						d: "siDNASP",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.10.6": {
						d: "siBYEMAN",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.10.7": {
						d: "siREL-US",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.10.8": {
						d: "siREL-AUS",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.10.9": {
						d: "siREL-CAN",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.10.10": {
						d: "siREL_UK",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.10.11": {
						d: "siREL-NZ",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.10.12": {
						d: "siGeneric",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.11": {
						d: "genser",
						c: "SDN.700 INFOSEC policy"
					},
					"2.16.840.1.101.2.1.3.11.0": {
						d: "genserNations",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.11.1": {
						d: "genserComsec",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.11.2": {
						d: "genserAcquisition",
						c: "SDN.700 INFOSEC policy (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.3.11.3": {
						d: "genserSecurityCategories",
						c: "SDN.700 INFOSEC policy"
					},
					"2.16.840.1.101.2.1.3.11.3.0": {
						d: "genserTagSetName",
						c: "SDN.700 INFOSEC GENSER policy"
					},
					"2.16.840.1.101.2.1.3.12": {
						d: "defaultSecurityPolicy",
						c: "SDN.700 INFOSEC policy"
					},
					"2.16.840.1.101.2.1.3.13": {
						d: "capcoMarkings",
						c: "SDN.700 INFOSEC policy"
					},
					"2.16.840.1.101.2.1.3.13.0": {
						d: "capcoSecurityCategories",
						c: "SDN.700 INFOSEC policy CAPCO markings"
					},
					"2.16.840.1.101.2.1.3.13.0.1": {
						d: "capcoTagSetName1",
						c: "SDN.700 INFOSEC policy CAPCO markings"
					},
					"2.16.840.1.101.2.1.3.13.0.2": {
						d: "capcoTagSetName2",
						c: "SDN.700 INFOSEC policy CAPCO markings"
					},
					"2.16.840.1.101.2.1.3.13.0.3": {
						d: "capcoTagSetName3",
						c: "SDN.700 INFOSEC policy CAPCO markings"
					},
					"2.16.840.1.101.2.1.3.13.0.4": {
						d: "capcoTagSetName4",
						c: "SDN.700 INFOSEC policy CAPCO markings"
					},
					"2.16.840.1.101.2.1.5.1": {
						d: "sdnsKeyManagementCertificate",
						c: "SDN.700 INFOSEC attributes (superseded)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.2": {
						d: "sdnsUserSignatureCertificate",
						c: "SDN.700 INFOSEC attributes (superseded)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.3": {
						d: "sdnsKMandSigCertificate",
						c: "SDN.700 INFOSEC attributes (superseded)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.4": {
						d: "fortezzaKeyManagementCertificate",
						c: "SDN.700 INFOSEC attributes (superseded)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.5": {
						d: "fortezzaKMandSigCertificate",
						c: "SDN.700 INFOSEC attributes (superseded)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.6": {
						d: "fortezzaUserSignatureCertificate",
						c: "SDN.700 INFOSEC attributes (superseded)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.7": {
						d: "fortezzaCASignatureCertificate",
						c: "SDN.700 INFOSEC attributes (superseded)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.8": {
						d: "sdnsCASignatureCertificate",
						c: "SDN.700 INFOSEC attributes (superseded)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.10": {
						d: "auxiliaryVector",
						c: "SDN.700 INFOSEC attributes (superseded)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.11": {
						d: "mlReceiptPolicy",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.12": {
						d: "mlMembership",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.13": {
						d: "mlAdministrators",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.14": {
						d: "alid",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.20": {
						d: "janUKMs",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.21": {
						d: "febUKMs",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.22": {
						d: "marUKMs",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.23": {
						d: "aprUKMs",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.24": {
						d: "mayUKMs",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.25": {
						d: "junUKMs",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.26": {
						d: "julUKMs",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.27": {
						d: "augUKMs",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.28": {
						d: "sepUKMs",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.29": {
						d: "octUKMs",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.30": {
						d: "novUKMs",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.31": {
						d: "decUKMs",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.40": {
						d: "metaSDNSckl",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.41": {
						d: "sdnsCKL",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.42": {
						d: "metaSDNSsignatureCKL",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.43": {
						d: "sdnsSignatureCKL",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.44": {
						d: "sdnsCertificateRevocationList",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.45": {
						d: "fortezzaCertificateRevocationList",
						c: "SDN.700 INFOSEC attributes (superseded)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.46": {
						d: "fortezzaCKL",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.47": {
						d: "alExemptedAddressProcessor",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.48": {
						d: "guard",
						c: "SDN.700 INFOSEC attributes (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.49": {
						d: "algorithmsSupported",
						c: "SDN.700 INFOSEC attributes (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.50": {
						d: "suiteAKeyManagementCertificate",
						c: "SDN.700 INFOSEC attributes (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.51": {
						d: "suiteAKMandSigCertificate",
						c: "SDN.700 INFOSEC attributes (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.52": {
						d: "suiteAUserSignatureCertificate",
						c: "SDN.700 INFOSEC attributes (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.53": {
						d: "prbacInfo",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.54": {
						d: "prbacCAConstraints",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.55": {
						d: "sigOrKMPrivileges",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.56": {
						d: "commPrivileges",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.57": {
						d: "labeledAttribute",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.58": {
						d: "policyInformationFile",
						c: "SDN.700 INFOSEC attributes (obsolete)",
						w: !0
					},
					"2.16.840.1.101.2.1.5.59": {
						d: "secPolicyInformationFile",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.60": {
						d: "cAClearanceConstraint",
						c: "SDN.700 INFOSEC attributes"
					},
					"2.16.840.1.101.2.1.5.65": {
						d: "keyPkgIdAndReceiptReq",
						c: "SDN.700 INFOSEC attributes and RFC 7191"
					},
					"2.16.840.1.101.2.1.5.66": {
						d: "contentDecryptKeyID",
						c: "SDN.700 INFOSEC attributes and RFC 6032"
					},
					"2.16.840.1.101.2.1.5.70": {
						d: "kpCrlPointers",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.5.71": {
						d: "kpKeyProvinceV2",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.5.72": {
						d: "kpManifest",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.7.1": {
						d: "cspExtns",
						c: "SDN.700 INFOSEC extensions"
					},
					"2.16.840.1.101.2.1.7.1.0": {
						d: "cspCsExtn",
						c: "SDN.700 INFOSEC extensions"
					},
					"2.16.840.1.101.2.1.8.1": {
						d: "mISSISecurityCategories",
						c: "SDN.700 INFOSEC security category"
					},
					"2.16.840.1.101.2.1.8.2": {
						d: "standardSecurityLabelPrivileges",
						c: "SDN.700 INFOSEC security category"
					},
					"2.16.840.1.101.2.1.8.3.1": {
						d: "enumeratedPermissiveAttrs",
						c: "SDN.700 INFOSEC security category from RFC 7906"
					},
					"2.16.840.1.101.2.1.8.3.3": {
						d: "informativeAttrs",
						c: "SDN.700 INFOSEC security category from RFC 7906"
					},
					"2.16.840.1.101.2.1.8.3.4": {
						d: "enumeratedRestrictiveAttrs",
						c: "SDN.700 INFOSEC security category from RFC 7906"
					},
					"2.16.840.1.101.2.1.10.1": {
						d: "sigPrivileges",
						c: "SDN.700 INFOSEC privileges"
					},
					"2.16.840.1.101.2.1.10.2": {
						d: "kmPrivileges",
						c: "SDN.700 INFOSEC privileges"
					},
					"2.16.840.1.101.2.1.10.3": {
						d: "namedTagSetPrivilege",
						c: "SDN.700 INFOSEC privileges"
					},
					"2.16.840.1.101.2.1.11.1": {
						d: "ukDemo",
						c: "SDN.700 INFOSEC certificate policy"
					},
					"2.16.840.1.101.2.1.11.2": {
						d: "usDODClass2",
						c: "SDN.700 INFOSEC certificate policy"
					},
					"2.16.840.1.101.2.1.11.3": {
						d: "usMediumPilot",
						c: "SDN.700 INFOSEC certificate policy"
					},
					"2.16.840.1.101.2.1.11.4": {
						d: "usDODClass4",
						c: "SDN.700 INFOSEC certificate policy"
					},
					"2.16.840.1.101.2.1.11.5": {
						d: "usDODClass3",
						c: "SDN.700 INFOSEC certificate policy"
					},
					"2.16.840.1.101.2.1.11.6": {
						d: "usDODClass5",
						c: "SDN.700 INFOSEC certificate policy"
					},
					"2.16.840.1.101.2.1.12.0": {
						d: "testSecurityPolicy",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.1": {
						d: "tsp1",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.1.0": {
						d: "tsp1SecurityCategories",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.1.0.0": {
						d: "tsp1TagSetZero",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.1.0.1": {
						d: "tsp1TagSetOne",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.1.0.2": {
						d: "tsp1TagSetTwo",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.2": {
						d: "tsp2",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.2.0": {
						d: "tsp2SecurityCategories",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.2.0.0": {
						d: "tsp2TagSetZero",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.2.0.1": {
						d: "tsp2TagSetOne",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.2.0.2": {
						d: "tsp2TagSetTwo",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.3": {
						d: "kafka",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.3.0": {
						d: "kafkaSecurityCategories",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.3.0.1": {
						d: "kafkaTagSetName1",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.3.0.2": {
						d: "kafkaTagSetName2",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.0.3.0.3": {
						d: "kafkaTagSetName3",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.12.1.1": {
						d: "tcp1",
						c: "SDN.700 INFOSEC test objects"
					},
					"2.16.840.1.101.2.1.13.1": {
						d: "kmaKeyAlgorithm",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.3": {
						d: "kmaTSECNomenclature",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.5": {
						d: "kmaKeyDistPeriod",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.6": {
						d: "kmaKeyValidityPeriod",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.7": {
						d: "kmaKeyDuration",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.11": {
						d: "kmaSplitID",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.12": {
						d: "kmaKeyPkgType",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.13": {
						d: "kmaKeyPurpose",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.14": {
						d: "kmaKeyUse",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.15": {
						d: "kmaTransportKey",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.16": {
						d: "kmaKeyPkgReceiversV2",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.19": {
						d: "kmaOtherCertFormats",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.20": {
						d: "kmaUsefulCerts",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.21": {
						d: "kmaKeyWrapAlgorithm",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.13.22": {
						d: "kmaSigUsageV3",
						c: "SDN.700 INFOSEC attributes and RFC 7906"
					},
					"2.16.840.1.101.2.1.16.0": {
						d: "dn",
						c: "SDN.700 INFOSEC attributes and RFC 7191"
					},
					"2.16.840.1.101.2.1.22": {
						d: "errorCodes",
						c: "RFC 7906 key attribute error codes"
					},
					"2.16.840.1.101.2.1.22.1": {
						d: "missingKeyType",
						c: "RFC 7906 key attribute error codes"
					},
					"2.16.840.1.101.2.1.22.2": {
						d: "privacyMarkTooLong",
						c: "RFC 7906 key attribute error codes"
					},
					"2.16.840.1.101.2.1.22.3": {
						d: "unrecognizedSecurityPolicy",
						c: "RFC 7906 key attribute error codes"
					},
					"2.16.840.1.101.3.1": {
						d: "slabel",
						c: "CSOR GAK",
						w: !0
					},
					"2.16.840.1.101.3.2": {
						d: "pki",
						c: "NIST",
						w: !0
					},
					"2.16.840.1.101.3.2.1": {
						d: "NIST policyIdentifier",
						c: "NIST policies",
						w: !0
					},
					"2.16.840.1.101.3.2.1.3.1": {
						d: "fbcaRudimentaryPolicy",
						c: "Federal Bridge CA Policy"
					},
					"2.16.840.1.101.3.2.1.3.2": {
						d: "fbcaBasicPolicy",
						c: "Federal Bridge CA Policy"
					},
					"2.16.840.1.101.3.2.1.3.3": {
						d: "fbcaMediumPolicy",
						c: "Federal Bridge CA Policy"
					},
					"2.16.840.1.101.3.2.1.3.4": {
						d: "fbcaHighPolicy",
						c: "Federal Bridge CA Policy"
					},
					"2.16.840.1.101.3.2.1.48.1": {
						d: "nistTestPolicy1",
						c: "NIST PKITS policies"
					},
					"2.16.840.1.101.3.2.1.48.2": {
						d: "nistTestPolicy2",
						c: "NIST PKITS policies"
					},
					"2.16.840.1.101.3.2.1.48.3": {
						d: "nistTestPolicy3",
						c: "NIST PKITS policies"
					},
					"2.16.840.1.101.3.2.1.48.4": {
						d: "nistTestPolicy4",
						c: "NIST PKITS policies"
					},
					"2.16.840.1.101.3.2.1.48.5": {
						d: "nistTestPolicy5",
						c: "NIST PKITS policies"
					},
					"2.16.840.1.101.3.2.1.48.6": {
						d: "nistTestPolicy6",
						c: "NIST PKITS policies"
					},
					"2.16.840.1.101.3.2.2": {
						d: "gak",
						c: "CSOR GAK extended key usage",
						w: !0
					},
					"2.16.840.1.101.3.2.2.1": {
						d: "kRAKey",
						c: "CSOR GAK extended key usage",
						w: !0
					},
					"2.16.840.1.101.3.2.3": {
						d: "extensions",
						c: "CSOR GAK extensions",
						w: !0
					},
					"2.16.840.1.101.3.2.3.1": {
						d: "kRTechnique",
						c: "CSOR GAK extensions",
						w: !0
					},
					"2.16.840.1.101.3.2.3.2": {
						d: "kRecoveryCapable",
						c: "CSOR GAK extensions",
						w: !0
					},
					"2.16.840.1.101.3.2.3.3": {
						d: "kR",
						c: "CSOR GAK extensions",
						w: !0
					},
					"2.16.840.1.101.3.2.4": {
						d: "keyRecoverySchemes",
						c: "CSOR GAK",
						w: !0
					},
					"2.16.840.1.101.3.2.5": {
						d: "krapola",
						c: "CSOR GAK",
						w: !0
					},
					"2.16.840.1.101.3.3": {
						d: "arpa",
						c: "CSOR GAK",
						w: !0
					},
					"2.16.840.1.101.3.4": {
						d: "nistAlgorithm",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1": {
						d: "aes",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.1": {
						d: "aes128-ECB",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.2": {
						d: "aes128-CBC",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.3": {
						d: "aes128-OFB",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.4": {
						d: "aes128-CFB",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.5": {
						d: "aes128-wrap",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.6": {
						d: "aes128-GCM",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.7": {
						d: "aes128-CCM",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.8": {
						d: "aes128-wrap-pad",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.9": {
						d: "aes128-GMAC",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.21": {
						d: "aes192-ECB",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.22": {
						d: "aes192-CBC",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.23": {
						d: "aes192-OFB",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.24": {
						d: "aes192-CFB",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.25": {
						d: "aes192-wrap",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.26": {
						d: "aes192-GCM",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.27": {
						d: "aes192-CCM",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.28": {
						d: "aes192-wrap-pad",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.29": {
						d: "aes192-GMAC",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.41": {
						d: "aes256-ECB",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.42": {
						d: "aes256-CBC",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.43": {
						d: "aes256-OFB",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.44": {
						d: "aes256-CFB",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.45": {
						d: "aes256-wrap",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.46": {
						d: "aes256-GCM",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.47": {
						d: "aes256-CCM",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.48": {
						d: "aes256-wrap-pad",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.1.49": {
						d: "aes256-GMAC",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2": {
						d: "hashAlgos",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.1": {
						d: "sha-256",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.2": {
						d: "sha-384",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.3": {
						d: "sha-512",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.4": {
						d: "sha-224",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.7": {
						d: "sha3-224",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.8": {
						d: "sha3-256",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.9": {
						d: "sha3-384",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.10": {
						d: "sha3-512",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.11": {
						d: "shake128",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.12": {
						d: "shake256",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.17": {
						d: "shake128len",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.18": {
						d: "shake256len",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.19": {
						d: "kmacShake128",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.2.20": {
						d: "kmacShake256",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.3.1": {
						d: "dsaWithSha224",
						c: "NIST Algorithm"
					},
					"2.16.840.1.101.3.4.3.2": {
						d: "dsaWithSha256",
						c: "NIST Algorithm"
					},
					"2.16.840.1.113719.1.2.8": {
						d: "novellAlgorithm",
						c: "Novell"
					},
					"2.16.840.1.113719.1.2.8.22": {
						d: "desCbcIV8",
						c: "Novell encryption algorithm"
					},
					"2.16.840.1.113719.1.2.8.23": {
						d: "desCbcPadIV8",
						c: "Novell encryption algorithm"
					},
					"2.16.840.1.113719.1.2.8.24": {
						d: "desEDE2CbcIV8",
						c: "Novell encryption algorithm"
					},
					"2.16.840.1.113719.1.2.8.25": {
						d: "desEDE2CbcPadIV8",
						c: "Novell encryption algorithm"
					},
					"2.16.840.1.113719.1.2.8.26": {
						d: "desEDE3CbcIV8",
						c: "Novell encryption algorithm"
					},
					"2.16.840.1.113719.1.2.8.27": {
						d: "desEDE3CbcPadIV8",
						c: "Novell encryption algorithm"
					},
					"2.16.840.1.113719.1.2.8.28": {
						d: "rc5CbcPad",
						c: "Novell encryption algorithm"
					},
					"2.16.840.1.113719.1.2.8.29": {
						d: "md2WithRSAEncryptionBSafe1",
						c: "Novell signature algorithm"
					},
					"2.16.840.1.113719.1.2.8.30": {
						d: "md5WithRSAEncryptionBSafe1",
						c: "Novell signature algorithm"
					},
					"2.16.840.1.113719.1.2.8.31": {
						d: "sha1WithRSAEncryptionBSafe1",
						c: "Novell signature algorithm"
					},
					"2.16.840.1.113719.1.2.8.32": {
						d: "lmDigest",
						c: "Novell digest algorithm"
					},
					"2.16.840.1.113719.1.2.8.40": {
						d: "md2",
						c: "Novell digest algorithm"
					},
					"2.16.840.1.113719.1.2.8.50": {
						d: "md5",
						c: "Novell digest algorithm"
					},
					"2.16.840.1.113719.1.2.8.51": {
						d: "ikeHmacWithSHA1-RSA",
						c: "Novell signature algorithm"
					},
					"2.16.840.1.113719.1.2.8.52": {
						d: "ikeHmacWithMD5-RSA",
						c: "Novell signature algorithm"
					},
					"2.16.840.1.113719.1.2.8.69": {
						d: "rc2CbcPad",
						c: "Novell encryption algorithm"
					},
					"2.16.840.1.113719.1.2.8.82": {
						d: "sha-1",
						c: "Novell digest algorithm"
					},
					"2.16.840.1.113719.1.2.8.92": {
						d: "rc2BSafe1Cbc",
						c: "Novell encryption algorithm"
					},
					"2.16.840.1.113719.1.2.8.95": {
						d: "md4",
						c: "Novell digest algorithm"
					},
					"2.16.840.1.113719.1.2.8.130": {
						d: "md4Packet",
						c: "Novell keyed hash"
					},
					"2.16.840.1.113719.1.2.8.131": {
						d: "rsaEncryptionBsafe1",
						c: "Novell encryption algorithm"
					},
					"2.16.840.1.113719.1.2.8.132": {
						d: "nwPassword",
						c: "Novell encryption algorithm"
					},
					"2.16.840.1.113719.1.2.8.133": {
						d: "novellObfuscate-1",
						c: "Novell encryption algorithm"
					},
					"2.16.840.1.113719.1.9": {
						d: "pki",
						c: "Novell"
					},
					"2.16.840.1.113719.1.9.4": {
						d: "pkiAttributeType",
						c: "Novell PKI"
					},
					"2.16.840.1.113719.1.9.4.1": {
						d: "securityAttributes",
						c: "Novell PKI attribute type"
					},
					"2.16.840.1.113719.1.9.4.2": {
						d: "relianceLimit",
						c: "Novell PKI attribute type"
					},
					"2.16.840.1.113730.1": {
						d: "cert-extension",
						c: "Netscape"
					},
					"2.16.840.1.113730.1.1": {
						d: "netscape-cert-type",
						c: "Netscape certificate extension"
					},
					"2.16.840.1.113730.1.2": {
						d: "netscape-base-url",
						c: "Netscape certificate extension"
					},
					"2.16.840.1.113730.1.3": {
						d: "netscape-revocation-url",
						c: "Netscape certificate extension"
					},
					"2.16.840.1.113730.1.4": {
						d: "netscape-ca-revocation-url",
						c: "Netscape certificate extension"
					},
					"2.16.840.1.113730.1.7": {
						d: "netscape-cert-renewal-url",
						c: "Netscape certificate extension"
					},
					"2.16.840.1.113730.1.8": {
						d: "netscape-ca-policy-url",
						c: "Netscape certificate extension"
					},
					"2.16.840.1.113730.1.9": {
						d: "HomePage-url",
						c: "Netscape certificate extension"
					},
					"2.16.840.1.113730.1.10": {
						d: "EntityLogo",
						c: "Netscape certificate extension"
					},
					"2.16.840.1.113730.1.11": {
						d: "UserPicture",
						c: "Netscape certificate extension"
					},
					"2.16.840.1.113730.1.12": {
						d: "netscape-ssl-server-name",
						c: "Netscape certificate extension"
					},
					"2.16.840.1.113730.1.13": {
						d: "netscape-comment",
						c: "Netscape certificate extension"
					},
					"2.16.840.1.113730.2": {
						d: "data-type",
						c: "Netscape"
					},
					"2.16.840.1.113730.2.1": {
						d: "dataGIF",
						c: "Netscape data type"
					},
					"2.16.840.1.113730.2.2": {
						d: "dataJPEG",
						c: "Netscape data type"
					},
					"2.16.840.1.113730.2.3": {
						d: "dataURL",
						c: "Netscape data type"
					},
					"2.16.840.1.113730.2.4": {
						d: "dataHTML",
						c: "Netscape data type"
					},
					"2.16.840.1.113730.2.5": {
						d: "certSequence",
						c: "Netscape data type"
					},
					"2.16.840.1.113730.2.6": {
						d: "certURL",
						c: "Netscape certificate extension"
					},
					"2.16.840.1.113730.3": {
						d: "directory",
						c: "Netscape"
					},
					"2.16.840.1.113730.3.1": {
						d: "ldapDefinitions",
						c: "Netscape directory"
					},
					"2.16.840.1.113730.3.1.1": {
						d: "carLicense",
						c: "Netscape LDAP definitions"
					},
					"2.16.840.1.113730.3.1.2": {
						d: "departmentNumber",
						c: "Netscape LDAP definitions"
					},
					"2.16.840.1.113730.3.1.3": {
						d: "employeeNumber",
						c: "Netscape LDAP definitions"
					},
					"2.16.840.1.113730.3.1.4": {
						d: "employeeType",
						c: "Netscape LDAP definitions"
					},
					"2.16.840.1.113730.3.1.216": {
						d: "userPKCS12",
						c: "Netscape LDAP definitions"
					},
					"2.16.840.1.113730.3.2.2": {
						d: "inetOrgPerson",
						c: "Netscape LDAP definitions"
					},
					"2.16.840.1.113730.4.1": {
						d: "serverGatedCrypto",
						c: "Netscape"
					},
					"2.16.840.1.113733.1.6.3": {
						d: "verisignCZAG",
						c: "Verisign extension"
					},
					"2.16.840.1.113733.1.6.6": {
						d: "verisignInBox",
						c: "Verisign extension"
					},
					"2.16.840.1.113733.1.6.11": {
						d: "verisignOnsiteJurisdictionHash",
						c: "Verisign extension"
					},
					"2.16.840.1.113733.1.6.13": {
						d: "Unknown Verisign VPN extension",
						c: "Verisign extension"
					},
					"2.16.840.1.113733.1.6.15": {
						d: "verisignServerID",
						c: "Verisign extension"
					},
					"2.16.840.1.113733.1.7.1.1": {
						d: "verisignCertPolicies95Qualifier1",
						c: "Verisign policy"
					},
					"2.16.840.1.113733.1.7.1.1.1": {
						d: "verisignCPSv1notice",
						c: "Verisign policy (obsolete)"
					},
					"2.16.840.1.113733.1.7.1.1.2": {
						d: "verisignCPSv1nsi",
						c: "Verisign policy (obsolete)"
					},
					"2.16.840.1.113733.1.8.1": {
						d: "verisignISSStrongCrypto",
						c: "Verisign"
					},
					"2.16.840.1.113733.1": {
						d: "pki",
						c: "Verisign extension"
					},
					"2.16.840.1.113733.1.9": {
						d: "pkcs7Attribute",
						c: "Verisign PKI extension"
					},
					"2.16.840.1.113733.1.9.2": {
						d: "messageType",
						c: "Verisign PKCS #7 attribute"
					},
					"2.16.840.1.113733.1.9.3": {
						d: "pkiStatus",
						c: "Verisign PKCS #7 attribute"
					},
					"2.16.840.1.113733.1.9.4": {
						d: "failInfo",
						c: "Verisign PKCS #7 attribute"
					},
					"2.16.840.1.113733.1.9.5": {
						d: "senderNonce",
						c: "Verisign PKCS #7 attribute"
					},
					"2.16.840.1.113733.1.9.6": {
						d: "recipientNonce",
						c: "Verisign PKCS #7 attribute"
					},
					"2.16.840.1.113733.1.9.7": {
						d: "transID",
						c: "Verisign PKCS #7 attribute"
					},
					"2.16.840.1.113733.1.9.8": {
						d: "extensionReq",
						c: "Verisign PKCS #7 attribute.  Use PKCS #9 extensionRequest instead",
						w: !0
					},
					"2.16.840.1.113741.2": {
						d: "intelCDSA",
						c: "Intel CDSA"
					},
					"2.16.840.1.114412.1": {
						d: "digiCertNonEVCerts",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.1.1": {
						d: "digiCertOVCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.1.2": {
						d: "digiCertDVCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.1.11": {
						d: "digiCertFederatedDeviceCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.1.3.0.1": {
						d: "digiCertGlobalCAPolicy",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.1.3.0.2": {
						d: "digiCertHighAssuranceEVCAPolicy",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.1.3.0.3": {
						d: "digiCertGlobalRootCAPolicy",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.1.3.0.4": {
						d: "digiCertAssuredIDRootCAPolicy",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.2": {
						d: "digiCertEVCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.3": {
						d: "digiCertObjectSigningCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.3.1": {
						d: "digiCertCodeSigningCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.3.2": {
						d: "digiCertEVCodeSigningCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.3.11": {
						d: "digiCertKernelCodeSigningCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.3.21": {
						d: "digiCertDocumentSigningCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.4": {
						d: "digiCertClientCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.4.1.1": {
						d: "digiCertLevel1PersonalClientCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.4.1.2": {
						d: "digiCertLevel1EnterpriseClientCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.4.2": {
						d: "digiCertLevel2ClientCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.4.3.1": {
						d: "digiCertLevel3USClientCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.4.3.2": {
						d: "digiCertLevel3CBPClientCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.4.4.1": {
						d: "digiCertLevel4USClientCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.4.4.2": {
						d: "digiCertLevel4CBPClientCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.4.5.1": {
						d: "digiCertPIVHardwareCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.4.5.2": {
						d: "digiCertPIVCardAuthCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.2.4.5.3": {
						d: "digiCertPIVContentSigningCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.4.31": {
						d: "digiCertGridClassicCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.4.31.5": {
						d: "digiCertGridIntegratedCert",
						c: "Digicert CA policy"
					},
					"2.16.840.1.114412.31.4.31.1": {
						d: "digiCertGridHostCert",
						c: "Digicert CA policy"
					},
					"2.23.42.0": {
						d: "contentType",
						c: "SET"
					},
					"2.23.42.0.0": {
						d: "panData",
						c: "SET contentType"
					},
					"2.23.42.0.1": {
						d: "panToken",
						c: "SET contentType"
					},
					"2.23.42.0.2": {
						d: "panOnly",
						c: "SET contentType"
					},
					"2.23.42.1": {
						d: "msgExt",
						c: "SET"
					},
					"2.23.42.2": {
						d: "field",
						c: "SET"
					},
					"2.23.42.2.0": {
						d: "fullName",
						c: "SET field"
					},
					"2.23.42.2.1": {
						d: "givenName",
						c: "SET field"
					},
					"2.23.42.2.2": {
						d: "familyName",
						c: "SET field"
					},
					"2.23.42.2.3": {
						d: "birthFamilyName",
						c: "SET field"
					},
					"2.23.42.2.4": {
						d: "placeName",
						c: "SET field"
					},
					"2.23.42.2.5": {
						d: "identificationNumber",
						c: "SET field"
					},
					"2.23.42.2.6": {
						d: "month",
						c: "SET field"
					},
					"2.23.42.2.7": {
						d: "date",
						c: "SET field"
					},
					"2.23.42.2.8": {
						d: "address",
						c: "SET field"
					},
					"2.23.42.2.9": {
						d: "telephone",
						c: "SET field"
					},
					"2.23.42.2.10": {
						d: "amount",
						c: "SET field"
					},
					"2.23.42.2.11": {
						d: "accountNumber",
						c: "SET field"
					},
					"2.23.42.2.12": {
						d: "passPhrase",
						c: "SET field"
					},
					"2.23.42.3": {
						d: "attribute",
						c: "SET"
					},
					"2.23.42.3.0": {
						d: "cert",
						c: "SET attribute"
					},
					"2.23.42.3.0.0": {
						d: "rootKeyThumb",
						c: "SET cert attribute"
					},
					"2.23.42.3.0.1": {
						d: "additionalPolicy",
						c: "SET cert attribute"
					},
					"2.23.42.4": {
						d: "algorithm",
						c: "SET"
					},
					"2.23.42.5": {
						d: "policy",
						c: "SET"
					},
					"2.23.42.5.0": {
						d: "root",
						c: "SET policy"
					},
					"2.23.42.6": {
						d: "module",
						c: "SET"
					},
					"2.23.42.7": {
						d: "certExt",
						c: "SET"
					},
					"2.23.42.7.0": {
						d: "hashedRootKey",
						c: "SET cert extension"
					},
					"2.23.42.7.1": {
						d: "certificateType",
						c: "SET cert extension"
					},
					"2.23.42.7.2": {
						d: "merchantData",
						c: "SET cert extension"
					},
					"2.23.42.7.3": {
						d: "cardCertRequired",
						c: "SET cert extension"
					},
					"2.23.42.7.4": {
						d: "tunneling",
						c: "SET cert extension"
					},
					"2.23.42.7.5": {
						d: "setExtensions",
						c: "SET cert extension"
					},
					"2.23.42.7.6": {
						d: "setQualifier",
						c: "SET cert extension"
					},
					"2.23.42.8": {
						d: "brand",
						c: "SET"
					},
					"2.23.42.8.1": {
						d: "IATA-ATA",
						c: "SET brand"
					},
					"2.23.42.8.4": {
						d: "VISA",
						c: "SET brand"
					},
					"2.23.42.8.5": {
						d: "MasterCard",
						c: "SET brand"
					},
					"2.23.42.8.30": {
						d: "Diners",
						c: "SET brand"
					},
					"2.23.42.8.34": {
						d: "AmericanExpress",
						c: "SET brand"
					},
					"2.23.42.8.6011": {
						d: "Novus",
						c: "SET brand"
					},
					"2.23.42.9": {
						d: "vendor",
						c: "SET"
					},
					"2.23.42.9.0": {
						d: "GlobeSet",
						c: "SET vendor"
					},
					"2.23.42.9.1": {
						d: "IBM",
						c: "SET vendor"
					},
					"2.23.42.9.2": {
						d: "CyberCash",
						c: "SET vendor"
					},
					"2.23.42.9.3": {
						d: "Terisa",
						c: "SET vendor"
					},
					"2.23.42.9.4": {
						d: "RSADSI",
						c: "SET vendor"
					},
					"2.23.42.9.5": {
						d: "VeriFone",
						c: "SET vendor"
					},
					"2.23.42.9.6": {
						d: "TrinTech",
						c: "SET vendor"
					},
					"2.23.42.9.7": {
						d: "BankGate",
						c: "SET vendor"
					},
					"2.23.42.9.8": {
						d: "GTE",
						c: "SET vendor"
					},
					"2.23.42.9.9": {
						d: "CompuSource",
						c: "SET vendor"
					},
					"2.23.42.9.10": {
						d: "Griffin",
						c: "SET vendor"
					},
					"2.23.42.9.11": {
						d: "Certicom",
						c: "SET vendor"
					},
					"2.23.42.9.12": {
						d: "OSS",
						c: "SET vendor"
					},
					"2.23.42.9.13": {
						d: "TenthMountain",
						c: "SET vendor"
					},
					"2.23.42.9.14": {
						d: "Antares",
						c: "SET vendor"
					},
					"2.23.42.9.15": {
						d: "ECC",
						c: "SET vendor"
					},
					"2.23.42.9.16": {
						d: "Maithean",
						c: "SET vendor"
					},
					"2.23.42.9.17": {
						d: "Netscape",
						c: "SET vendor"
					},
					"2.23.42.9.18": {
						d: "Verisign",
						c: "SET vendor"
					},
					"2.23.42.9.19": {
						d: "BlueMoney",
						c: "SET vendor"
					},
					"2.23.42.9.20": {
						d: "Lacerte",
						c: "SET vendor"
					},
					"2.23.42.9.21": {
						d: "Fujitsu",
						c: "SET vendor"
					},
					"2.23.42.9.22": {
						d: "eLab",
						c: "SET vendor"
					},
					"2.23.42.9.23": {
						d: "Entrust",
						c: "SET vendor"
					},
					"2.23.42.9.24": {
						d: "VIAnet",
						c: "SET vendor"
					},
					"2.23.42.9.25": {
						d: "III",
						c: "SET vendor"
					},
					"2.23.42.9.26": {
						d: "OpenMarket",
						c: "SET vendor"
					},
					"2.23.42.9.27": {
						d: "Lexem",
						c: "SET vendor"
					},
					"2.23.42.9.28": {
						d: "Intertrader",
						c: "SET vendor"
					},
					"2.23.42.9.29": {
						d: "Persimmon",
						c: "SET vendor"
					},
					"2.23.42.9.30": {
						d: "NABLE",
						c: "SET vendor"
					},
					"2.23.42.9.31": {
						d: "espace-net",
						c: "SET vendor"
					},
					"2.23.42.9.32": {
						d: "Hitachi",
						c: "SET vendor"
					},
					"2.23.42.9.33": {
						d: "Microsoft",
						c: "SET vendor"
					},
					"2.23.42.9.34": {
						d: "NEC",
						c: "SET vendor"
					},
					"2.23.42.9.35": {
						d: "Mitsubishi",
						c: "SET vendor"
					},
					"2.23.42.9.36": {
						d: "NCR",
						c: "SET vendor"
					},
					"2.23.42.9.37": {
						d: "e-COMM",
						c: "SET vendor"
					},
					"2.23.42.9.38": {
						d: "Gemplus",
						c: "SET vendor"
					},
					"2.23.42.10": {
						d: "national",
						c: "SET"
					},
					"2.23.42.10.392": {
						d: "Japan",
						c: "SET national"
					},
					"2.23.43.1.4": {
						d: "wTLS-ECC",
						c: "WAP WTLS"
					},
					"2.23.43.1.4.1": {
						d: "wTLS-ECC-curve1",
						c: "WAP WTLS"
					},
					"2.23.43.1.4.6": {
						d: "wTLS-ECC-curve6",
						c: "WAP WTLS"
					},
					"2.23.43.1.4.8": {
						d: "wTLS-ECC-curve8",
						c: "WAP WTLS"
					},
					"2.23.43.1.4.9": {
						d: "wTLS-ECC-curve9",
						c: "WAP WTLS"
					},
					"2.23.133": {
						d: "tCPA",
						c: "TCPA"
					},
					"2.23.133.1": {
						d: "tcpaSpecVersion",
						c: "TCPA"
					},
					"2.23.133.2": {
						d: "tcpaAttribute",
						c: "TCPA"
					},
					"2.23.133.2.1": {
						d: "tcpaTpmManufacturer",
						c: "TCPA Attribute"
					},
					"2.23.133.2.2": {
						d: "tcpaTpmModel",
						c: "TCPA Attribute"
					},
					"2.23.133.2.3": {
						d: "tcpaTpmVersion",
						c: "TCPA Attribute"
					},
					"2.23.133.2.4": {
						d: "tcpaPlatformManufacturer",
						c: "TCPA Attribute"
					},
					"2.23.133.2.5": {
						d: "tcpaPlatformModel",
						c: "TCPA Attribute"
					},
					"2.23.133.2.6": {
						d: "tcpaPlatformVersion",
						c: "TCPA Attribute"
					},
					"2.23.133.2.7": {
						d: "tcpaComponentManufacturer",
						c: "TCPA Attribute"
					},
					"2.23.133.2.8": {
						d: "tcpaComponentModel",
						c: "TCPA Attribute"
					},
					"2.23.133.2.9": {
						d: "tcpaComponentVersion",
						c: "TCPA Attribute"
					},
					"2.23.133.2.10": {
						d: "tcpaSecurityQualities",
						c: "TCPA Attribute"
					},
					"2.23.133.2.11": {
						d: "tcpaTpmProtectionProfile",
						c: "TCPA Attribute"
					},
					"2.23.133.2.12": {
						d: "tcpaTpmSecurityTarget",
						c: "TCPA Attribute"
					},
					"2.23.133.2.13": {
						d: "tcpaFoundationProtectionProfile",
						c: "TCPA Attribute"
					},
					"2.23.133.2.14": {
						d: "tcpaFoundationSecurityTarget",
						c: "TCPA Attribute"
					},
					"2.23.133.2.15": {
						d: "tcpaTpmIdLabel",
						c: "TCPA Attribute"
					},
					"2.23.133.3": {
						d: "tcpaProtocol",
						c: "TCPA"
					},
					"2.23.133.3.1": {
						d: "tcpaPrttTpmIdProtocol",
						c: "TCPA Protocol"
					},
					"2.23.134.1.4.2.1": {
						d: "postSignumRootQCA",
						c: "PostSignum CA"
					},
					"2.23.134.1.2.2.3": {
						d: "postSignumPublicCA",
						c: "PostSignum CA"
					},
					"2.23.134.1.2.1.8.210": {
						d: "postSignumCommercialServerPolicy",
						c: "PostSignum CA"
					},
					"2.23.136.1.1.1": {
						d: "mRTDSignatureData",
						c: "ICAO MRTD"
					},
					"2.54.1775.2": {
						d: "hashedRootKey",
						c: "SET.  Deprecated, use (2 23 42 7 0) instead",
						w: !0
					},
					"2.54.1775.3": {
						d: "certificateType",
						c: "SET.  Deprecated, use (2 23 42 7 0) instead",
						w: !0
					},
					"2.54.1775.4": {
						d: "merchantData",
						c: "SET.  Deprecated, use (2 23 42 7 0) instead",
						w: !0
					},
					"2.54.1775.5": {
						d: "cardCertRequired",
						c: "SET.  Deprecated, use (2 23 42 7 0) instead",
						w: !0
					},
					"2.54.1775.6": {
						d: "tunneling",
						c: "SET.  Deprecated, use (2 23 42 7 0) instead",
						w: !0
					},
					"2.54.1775.7": {
						d: "setQualifier",
						c: "SET.  Deprecated, use (2 23 42 7 0) instead",
						w: !0
					},
					"2.54.1775.99": {
						d: "setData",
						c: "SET.  Deprecated, use (2 23 42 7 0) instead",
						w: !0
					},
					"1.2.40.0.17.1.22": {
						d: "A-Trust EV policy",
						c: "A-Trust CA Root"
					},
					"1.3.6.1.4.1.34697.2.1": {
						d: "AffirmTrust EV policy",
						c: "AffirmTrust Commercial"
					},
					"1.3.6.1.4.1.34697.2.2": {
						d: "AffirmTrust EV policy",
						c: "AffirmTrust Networking"
					},
					"1.3.6.1.4.1.34697.2.3": {
						d: "AffirmTrust EV policy",
						c: "AffirmTrust Premium"
					},
					"1.3.6.1.4.1.34697.2.4": {
						d: "AffirmTrust EV policy",
						c: "AffirmTrust Premium ECC"
					},
					"2.16.578.1.26.1.3.3": {
						d: "BuyPass EV policy",
						c: "BuyPass Class 3 EV"
					},
					"1.3.6.1.4.1.17326.10.14.2.1.2": {
						d: "Camerfirma EV policy",
						c: "Camerfirma CA Root"
					},
					"1.3.6.1.4.1.17326.10.8.12.1.2": {
						d: "Camerfirma EV policy",
						c: "Camerfirma CA Root"
					},
					"1.3.6.1.4.1.22234.2.5.2.3.1": {
						d: "CertPlus EV policy",
						c: "CertPlus Class 2 Primary CA (formerly Keynectis)"
					},
					"1.3.6.1.4.1.6449.1.2.1.5.1": {
						d: "Comodo EV policy",
						c: "COMODO Certification Authority"
					},
					"1.3.6.1.4.1.6334.1.100.1": {
						d: "Cybertrust EV policy",
						c: "Cybertrust Global Root (now Verizon Business)"
					},
					"1.3.6.1.4.1.4788.2.202.1": {
						d: "D-TRUST EV policy",
						c: "D-TRUST Root Class 3 CA 2 EV 2009"
					},
					"2.16.840.1.114412.2.1": {
						d: "DigiCert EV policy",
						c: "DigiCert High Assurance EV Root CA"
					},
					"2.16.528.1.1001.1.1.1.12.6.1.1.1": {
						d: "DigiNotar EV policy",
						c: "DigiNotar Root CA"
					},
					"2.16.840.1.114028.10.1.2": {
						d: "Entrust EV policy",
						c: "Entrust Root Certification Authority"
					},
					"1.3.6.1.4.1.14370.1.6": {
						d: "GeoTrust EV policy",
						c: "GeoTrust Primary Certification Authority (formerly Equifax)"
					},
					"1.3.6.1.4.1.4146.1.1": {
						d: "GlobalSign EV policy",
						c: "GlobalSign"
					},
					"2.16.840.1.114413.1.7.23.3": {
						d: "GoDaddy EV policy",
						c: "GoDaddy Class 2 Certification Authority (formerly ValiCert)"
					},
					"1.3.6.1.4.1.14777.6.1.1": {
						d: "Izenpe EV policy",
						c: "Certificado de Servidor Seguro SSL EV"
					},
					"1.3.6.1.4.1.14777.6.1.2": {
						d: "Izenpe EV policy",
						c: "Certificado de Sede Electronica EV"
					},
					"1.3.6.1.4.1.782.1.2.1.8.1": {
						d: "Network Solutions EV policy",
						c: "Network Solutions Certificate Authority"
					},
					"1.3.6.1.4.1.8024.0.2.100.1.2": {
						d: "QuoVadis EV policy",
						c: "QuoVadis Root CA 2"
					},
					"1.2.392.200091.100.721.1": {
						d: "Security Communication (SECOM) EV policy",
						c: "Security Communication RootCA1"
					},
					"2.16.840.1.114414.1.7.23.3": {
						d: "Starfield EV policy",
						c: "Starfield Class 2 Certification Authority"
					},
					"1.3.6.1.4.1.23223.1.1.1": {
						d: "StartCom EV policy",
						c: "StartCom Certification Authority"
					},
					"2.16.756.1.89.1.2.1.1": {
						d: "SwissSign EV policy",
						c: "SwissSign Gold CA - G2"
					},
					"1.3.6.1.4.1.7879.13.24.1": {
						d: "T-TeleSec EV policy",
						c: "T-TeleSec GlobalRoot Class 3"
					},
					"2.16.840.1.113733.1.7.48.1": {
						d: "Thawte EV policy",
						c: "Thawte Premium Server CA"
					},
					"2.16.840.1.114404.1.1.2.4.1": {
						d: "TrustWave EV policy",
						c: "TrustWave CA, formerly SecureTrust, before that XRamp"
					},
					"1.3.6.1.4.1.40869.1.1.22.3": {
						d: "TWCA EV policy",
						c: "TWCA Root Certification Authority"
					},
					"2.16.840.1.113733.1.7.23.6": {
						d: "VeriSign EV policy",
						c: "VeriSign Class 3 Public Primary Certification Authority"
					},
					"2.16.840.1.114171.500.9": {
						d: "Wells Fargo EV policy",
						c: "Wells Fargo WellsSecure Public Root Certificate Authority"
					},
					END: ""
				}
			}.call(e, r, e, t), void 0 === n || (t.exports = n)
		},
		"69f3": function(t, e, r) {
			var n, i, o, a = r("7f9a"),
				s = r("da84"),
				c = r("e330"),
				u = r("861d"),
				d = r("9112"),
				l = r("1a2d"),
				f = r("c6cd"),
				h = r("f772"),
				p = r("d012"),
				m = "Object already initialized",
				b = s.TypeError,
				g = s.WeakMap,
				y = function(t) {
					return o(t) ? i(t) : n(t, {})
				},
				v = function(t) {
					return function(e) {
						var r;
						if (!u(e) || (r = i(e))
							.type !== t) throw b("Incompatible receiver, " + t + " required");
						return r
					}
				};
			if (a || f.state) {
				var S = f.state || (f.state = new g),
					w = c(S.get),
					C = c(S.has),
					_ = c(S.set);
				n = function(t, e) {
					if (C(S, t)) throw new b(m);
					return e.facade = t, _(S, t, e), e
				}, i = function(t) {
					return w(S, t) || {}
				}, o = function(t) {
					return C(S, t)
				}
			} else {
				var A = h("state");
				p[A] = !0, n = function(t, e) {
					if (l(t, A)) throw new b(m);
					return e.facade = t, d(t, A, e), e
				}, i = function(t) {
					return l(t, A) ? t[A] : {}
				}, o = function(t) {
					return l(t, A)
				}
			}
			t.exports = {
				set: n,
				get: i,
				has: o,
				enforce: y,
				getterFor: v
			}
		},
		"6b33": function(t, e, r) {
			"use strict";

			function n(t, e) {
				var r = "undefined" !== typeof Symbol && t[Symbol.iterator] || t["@@iterator"];
				if (!r) {
					if (Array.isArray(t) || (r = i(t)) || e && t && "number" === typeof t.length) {
						r && (t = r);
						var n = 0,
							o = function() {};
						return {
							s: o,
							n: function() {
								return n >= t.length ? {
									done: !0
								} : {
									done: !1,
									value: t[n++]
								}
							},
							e: function(t) {
								throw t
							},
							f: o
						}
					}
					throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
				}
				var a, s = !0,
					c = !1;
				return {
					s: function() {
						r = r.call(t)
					},
					n: function() {
						var t = r.next();
						return s = t.done, t
					},
					e: function(t) {
						c = !0, a = t
					},
					f: function() {
						try {
							s || null == r.return || r.return()
						} finally {
							if (c) throw a
						}
					}
				}
			}

			function i(t, e) {
				if (t) {
					if ("string" === typeof t) return o(t, e);
					var r = Object.prototype.toString.call(t)
						.slice(8, -1);
					return "Object" === r && t.constructor && (r = t.constructor.name), "Map" === r || "Set" === r ? Array.from(t) : "Arguments" === r || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r) ? o(t, e) : void 0
				}
			}

			function o(t, e) {
				(null == e || e > t.length) && (e = t.length);
				for (var r = 0, n = new Array(e); r < e; r++) n[r] = t[r];
				return n
			}
			r.d(e, "c", (function() {
				return a
			})), r.d(e, "a", (function() {
				return s
			})), r.d(e, "m", (function() {
				return f
			})), r.d(e, "n", (function() {
				return h
			})), r.d(e, "h", (function() {
				return p
			})), r.d(e, "e", (function() {
				return m
			})), r.d(e, "b", (function() {
				return g
			})), r.d(e, "l", (function() {
				return y
			})), r.d(e, "f", (function() {
				return v
			})), r.d(e, "g", (function() {
				return A
			})), r.d(e, "k", (function() {
				return I
			})), r.d(e, "j", (function() {
				return E
			})), r.d(e, "i", (function() {
				return T
			})), r.d(e, "d", (function() {
				return x
			})), r.d(e, "o", (function() {
				return P
			}));
			var a = function(t) {
					var e = t.split(" "),
						r = [],
						n = 0;
					while (n < e.length) {
						if ("M" === e[n] || "S" === e[n]) {
							var i = {
								type: "M",
								x: parseFloat(e[n + 1]),
								y: parseFloat(e[n + 2])
							};
							n += 3, r.push(i)
						}
						if ("L" === e[n]) {
							var o = {
								type: "L",
								x: parseFloat(e[n + 1]),
								y: parseFloat(e[n + 2])
							};
							n += 3, r.push(o)
						} else if ("C" === e[n]) {
							var a = {
								type: "C",
								x: 0,
								y: 0
							};
							r.push(a), n++
						} else if ("B" === e[n]) {
							var s = {
								type: "B",
								x1: parseFloat(e[n + 1]),
								y1: parseFloat(e[n + 2]),
								x2: parseFloat(e[n + 3]),
								y2: parseFloat(e[n + 4]),
								x3: parseFloat(e[n + 5]),
								y3: parseFloat(e[n + 6])
							};
							n += 7, r.push(s)
						} else if ("Q" === e[n]) {
							var c = {
								type: "Q",
								x1: parseFloat(e[n + 1]),
								y1: parseFloat(e[n + 2]),
								x2: parseFloat(e[n + 3]),
								y2: parseFloat(e[n + 4])
							};
							n += 5, r.push(c)
						} else if ("A" === e[n]) {
							var u = {
								type: "A",
								rx: parseFloat(e[n + 1]),
								ry: parseFloat(e[n + 2]),
								rotation: parseFloat(e[n + 3]),
								arc: parseFloat(e[n + 4]),
								sweep: parseFloat(e[n + 5]),
								x: parseFloat(e[n + 6]),
								y: parseFloat(e[n + 7])
							};
							n += 8, r.push(u)
						} else n++
					}
					return r
				},
				s = function(t) {
					for (var e = [], r = 0; r < t.length; r++) {
						var n = t[r];
						if ("M" === n.type || "L" === n.type || "C" === n.type) {
							var i = 0,
								o = 0;
							i = n.x, o = n.y, n.x = m(i), n.y = m(o), e.push(n)
						} else if ("B" === n.type) {
							var a = n.x1,
								s = n.y1,
								c = n.x2,
								u = n.y2,
								d = n.x3,
								l = n.y3,
								f = {
									type: "B",
									x1: m(a),
									y1: m(s),
									x2: m(c),
									y2: m(u),
									x3: m(d),
									y3: m(l)
								};
							e.push(f)
						} else if ("Q" === n.type) {
							var h = n.x1,
								p = n.y1,
								b = n.x2,
								g = n.y2,
								y = {
									type: "Q",
									x1: m(h),
									y1: m(p),
									x2: m(b),
									y2: m(g)
								};
							e.push(y)
						} else if ("A" === n.type) {
							var v = n.rx,
								S = n.ry,
								w = n.rotation,
								C = n.arc,
								_ = n.sweep,
								A = n.x,
								I = n.y,
								E = {
									type: "A",
									rx: m(v),
									ry: m(S),
									rotation: w,
									arc: C,
									sweep: _,
									x: m(A),
									y: m(I)
								};
							e.push(E)
						}
					}
					return e
				},
				c = function(t, e) {
					return t * e / 25.4
				},
				u = 10,
				d = 1,
				l = u,
				f = function(t) {},
				h = function(t) {
					l = t > .1 ? t : .1, l = l > u ? u : l, d = t
				},
				p = function() {
					return d
				},
				m = function(t) {
					return c(t, 96 * l)
				},
				b = function(t) {
					if (-1 === t.indexOf("g")) {
						var e, r = [],
							i = n(t.split(" "));
						try {
							for (i.s(); !(e = i.n())
								.done;) {
								var o = e.value;
								r.push(parseFloat(o))
							}
						} catch (m) {
							i.e(m)
						} finally {
							i.f()
						}
						return r
					}
					var a, s = t.split(" "),
						c = !1,
						u = !1,
						d = 0,
						l = [],
						f = n(s);
					try {
						for (f.s(); !(a = f.n())
							.done;) {
							var h = a.value;
							if ("g" === h) c = !0;
							else {
								if (!h || 0 == h.trim()
									.length) continue;
								if (c) d = parseInt(h), u = !0, c = !1;
								else if (u) {
									for (var p = 0; p < d; p++) l.push(parseFloat(h));
									u = !1
								} else l.push(parseFloat(h))
							}
						}
					} catch (m) {
						f.e(m)
					} finally {
						f.f()
					}
					return l
				},
				g = function(t) {
					var e = 0,
						r = 0,
						i = [];
					if (!t) return i;
					var o, a = n(t);
					try {
						for (a.s(); !(o = a.n())
							.done;) {
							var s = o.value;
							if (s) {
								e = parseFloat(s["@_X"]), r = parseFloat(s["@_Y"]), isNaN(e) && (e = 0), isNaN(r) && (r = 0);
								var c = [],
									u = [];
								s["@_DeltaX"] && s["@_DeltaX"].length > 0 && (c = b(s["@_DeltaX"])), s["@_DeltaY"] && s["@_DeltaY"].length > 0 && (u = b(s["@_DeltaY"]));
								var d = s["#text"];
								if ("undefined" == typeof d && "string" == typeof s && (d = s), d) {
									d += "", d = C(d), d = d.replace(/&#x20;/g, " ");
									for (var l = 0; l < d.length; l++) {
										l > 0 && c.length > 0 && (l <= c.length ? e += c[l - 1] : e += c[c.length - 1]), l > 0 && u.length > 0 && (r += u[l - 1]);
										var f = d.substring(l, l + 1),
											h = {
												x: m(e),
												y: m(r),
												text: f
											};
										i.push(h)
									}
								}
							}
						}
					} catch (p) {
						a.e(p)
					} finally {
						a.f()
					}
					return i
				},
				y = function(t) {
					return t && 0 === t.indexOf("/") && (t = t.replace("/", "")), t
				},
				v = function(t) {
					return t || "string" === typeof t ? t.substring(t.lastIndexOf(".") + 1) : ""
				},
				S = /&\w+;|&#(\d+);/g,
				w = {
					"&lt;": "<",
					"&gt;": ">",
					"&amp;": "&",
					"&nbsp;": " ",
					"&quot;": '"',
					"&copy;": "",
					"&apos;": "'"
				},
				C = function(t) {
					return t = void 0 != t ? t : this.toString(), "string" != typeof t ? t : t.replace(S, (function(t, e) {
						var r = w[t];
						return void 0 == r && (r = isNaN(e) ? t : String.fromCharCode(160 == e ? 32 : e)), r
					}))
				},
				_ = {
					"楷体": "楷体, KaiTi, Kai, simkai",
					kaiti: "楷体, KaiTi, Kai, simkai",
					Kai: "楷体, KaiTi, Kai",
					simsun: "SimSun, simsun, Songti SC",
					"宋体": "SimSun, simsun, Songti SC",
					"黑体": "SimHei, STHeiti, simhei",
					"仿宋": "FangSong, STFangsong, simfang",
					"小标宋体": "sSun",
					"方正小标宋简体": "FZXiaoBiaoSong-B05S",
					"方正小标宋_gbk": "FZXiaoBiaoSong-B05",
					"仿宋_gb2312": "FangSong, STFangsong, simfang",
					"楷体_gb2312": "楷体, KaiTi, Kai, simkai",
					couriernew: "Courier New",
					"courier new": "Courier New"
				},
				A = function(t) {
					var e = "simsun";
					"undefined" != typeof t && (e = t.familyName), e || (e = t.fontName), _[e.toLowerCase()] && (e = _[e.toLowerCase()]);
					for (var r = 0, n = Object.keys(_); r < n.length; r++) {
						var i = n[r];
						if (-1 != e.toLowerCase()
							.indexOf(i.toLowerCase())) return _[i]
					}
					return e
				},
				I = function(t) {
					if (t) {
						var e = t.split(" ");
						return {
							x: parseFloat(e[0]),
							y: parseFloat(e[1]),
							w: parseFloat(e[2]),
							h: parseFloat(e[3])
						}
					}
					return null
				},
				E = function(t) {
					var e = t.split(" ");
					return e
				},
				T = function(t) {
					if (t && t.length > 0) {
						if (-1 !== t.indexOf("#")) return t = t.replace(/#/g, ""), t = t.replace(/ /g, ""), t = "#" + t.toString(), t;
						var e = t.split(" ");
						return "rgb(".concat(e[0], ", ")
							.concat(e[1], ", ")
							.concat(e[2], ")")
					}
					return "rgb(0, 0, 0)"
				},
				x = function(t) {
					return {
						x: m(t.x),
						y: m(t.y),
						w: m(t.w),
						h: m(t.h)
					}
				},
				P = function(t) {
					for (var e = t.byteLength, r = ["A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "+", "/"], n = "", i = 0; e - i >= 3; i += 3) {
						var o = t[i],
							a = t[i + 1],
							s = t[i + 2];
						n += r[o >>> 2] + r[(3 & o) << 4 | a >>> 4] + r[(15 & a) << 2 | s >>> 6] + r[63 & s]
					}
					var c = e - i;
					if (1 === c) {
						var u = t[i];
						n += r[u >>> 2] + r[(3 & u) << 4] + "=="
					} else if (2 === c) {
						u = t[i];
						var d = t[i + 1];
						n += r[u >>> 2] + r[(3 & u) << 4 | d >>> 4] + r[(15 & d) << 2] + "="
					}
					return n
				}
		},
		"6b84": function(t, e, r) {
			r("3ca3"), r("a630");
			var n = r("428f");
			t.exports = n.Array.from
		},
		"6b9e": function(t, e, r) {
			var n = r("746f");
			n("search")
		},
		"6c57": function(t, e, r) {
			var n = r("23e7"),
				i = r("da84");
			n({
				global: !0
			}, {
				globalThis: i
			})
		},
		"6d61": function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("da84"),
				o = r("e330"),
				a = r("94ca"),
				s = r("cb2d"),
				c = r("f183"),
				u = r("2266"),
				d = r("19aa"),
				l = r("1626"),
				f = r("861d"),
				h = r("d039"),
				p = r("1c7e"),
				m = r("d44e"),
				b = r("7156");
			t.exports = function(t, e, r) {
				var g = -1 !== t.indexOf("Map"),
					y = -1 !== t.indexOf("Weak"),
					v = g ? "set" : "add",
					S = i[t],
					w = S && S.prototype,
					C = S,
					_ = {},
					A = function(t) {
						var e = o(w[t]);
						s(w, t, "add" == t ? function(t) {
							return e(this, 0 === t ? 0 : t), this
						} : "delete" == t ? function(t) {
							return !(y && !f(t)) && e(this, 0 === t ? 0 : t)
						} : "get" == t ? function(t) {
							return y && !f(t) ? void 0 : e(this, 0 === t ? 0 : t)
						} : "has" == t ? function(t) {
							return !(y && !f(t)) && e(this, 0 === t ? 0 : t)
						} : function(t, r) {
							return e(this, 0 === t ? 0 : t, r), this
						})
					},
					I = a(t, !l(S) || !(y || w.forEach && !h((function() {
						(new S)
						.entries()
							.next()
					}))));
				if (I) C = r.getConstructor(e, t, g, v), c.enable();
				else if (a(t, !0)) {
					var E = new C,
						T = E[v](y ? {} : -0, 1) != E,
						x = h((function() {
							E.has(1)
						})),
						P = p((function(t) {
							new S(t)
						})),
						k = !y && h((function() {
							var t = new S,
								e = 5;
							while (e--) t[v](e, e);
							return !t.has(-0)
						}));
					P || (C = e((function(t, e) {
						d(t, w);
						var r = b(new S, t, C);
						return void 0 != e && u(e, r[v], {
							that: r,
							AS_ENTRIES: g
						}), r
					})), C.prototype = w, w.constructor = C), (x || k) && (A("delete"), A("has"), g && A("get")), (k || T) && A(v), y && w.clear && delete w.clear
				}
				return _[t] = C, n({
					global: !0,
					constructor: !0,
					forced: C != S
				}, _), m(C, t), y || r.setStrong(C, t, g), C
			}
		},
		"6f48": function(t, e, r) {
			"use strict";
			var n = r("6d61"),
				i = r("6566");
			n("Map", (function(t) {
				return function() {
					return t(this, arguments.length ? arguments[0] : void 0)
				}
			}), i)
		},
		"6f53": function(t, e, r) {
			var n = r("83ab"),
				i = r("e330"),
				o = r("df75"),
				a = r("fc6a"),
				s = r("d1e7")
				.f,
				c = i(s),
				u = i([].push),
				d = function(t) {
					return function(e) {
						var r, i = a(e),
							s = o(i),
							d = s.length,
							l = 0,
							f = [];
						while (d > l) r = s[l++], n && !c(i, r) || u(f, t ? [r, i[r]] : i[r]);
						return f
					}
				};
			t.exports = {
				entries: d(!0),
				values: d(!1)
			}
		},
		"6f9c": function(t, e, r) {
			var n;
			n = function() {
				"use strict";
				var t, e = {},
					r = "function" == typeof Uint8Array;
				return e.decode = function(e) {
					var n, i = "string" == typeof e;
					if (void 0 === t) {
						var o = "0123456789ABCDEF",
							a = " \f\n\r\t \u2028\u2029";
						for (t = [], n = 0; n < 16; ++n) t[o.charCodeAt(n)] = n;
						for (o = o.toLowerCase(), n = 10; n < 16; ++n) t[o.charCodeAt(n)] = n;
						for (n = 0; n < a.length; ++n) t[a.charCodeAt(n)] = -1
					}
					var s = r ? new Uint8Array(e.length >> 1) : [],
						c = 0,
						u = 0,
						d = 0;
					for (n = 0; n < e.length; ++n) {
						var l = i ? e.charCodeAt(n) : e[n];
						if (l = t[l], -1 != l) {
							if (void 0 === l) throw "Illegal character at offset " + n;
							c |= l, ++u >= 2 ? (s[d++] = c, c = 0, u = 0) : c <<= 4
						}
					}
					if (u) throw "Hex encoding incomplete: 4 bits missing";
					return r && s.length > d && (s = s.subarray(0, d)), s
				}, e
			}.call(e, r, e, t), void 0 === n || (t.exports = n)
		},
		7149: function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("d066"),
				o = r("c430"),
				a = r("d256"),
				s = r("4738")
				.CONSTRUCTOR,
				c = r("cdf9"),
				u = i("Promise"),
				d = o && !s;
			n({
				target: "Promise",
				stat: !0,
				forced: o || s
			}, {
				resolve: function(t) {
					return c(d && this === u ? a : this, t)
				}
			})
		},
		7156: function(t, e, r) {
			var n = r("1626"),
				i = r("861d"),
				o = r("d2bb");
			t.exports = function(t, e, r) {
				var a, s;
				return o && n(a = e.constructor) && a !== r && i(s = a.prototype) && s !== r.prototype && o(t, s), t
			}
		},
		7276: function(t, e, r) {
			"use strict";
			var n = r("6d61"),
				i = r("acac");
			n("WeakSet", (function(t) {
				return function() {
					return t(this, arguments.length ? arguments[0] : void 0)
				}
			}), i)
		},
		"73fd": function(t, e, r) {
			"use strict";
			r.d(e, "a", (function() {
				return D
			}));
			r("7f3b");
			var n = {
					ERRORS: 0,
					WARNINGS: 1,
					INFOS: 5
				},
				i = n.WARNINGS;

			function o(t) {
				i >= n.INFOS && console.log("Info: ".concat(t))
			}

			function a(t) {
				throw new Error(t)
			}

			function s(t, e, r) {
				return Object.defineProperty(t, e, {
					value: r,
					enumerable: !0,
					configurable: !0,
					writable: !1
				}), r
			}
			var c = function() {
				function t(e) {
					this.constructor === t && a("Cannot initialize BaseException."), this.message = e, this.name = this.constructor.name
				}
				return t.prototype = new Error, t.constructor = t, t
			}();
			(function() {
				var t = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/="
			})();

			function u(t) {
				return t <= 0 ? 0 : Math.ceil(Math.log2(t))
			}

			function d(t, e) {
				return t[e] << 24 >> 24
			}

			function l(t, e) {
				return t[e] << 8 | t[e + 1]
			}

			function f(t, e) {
				return (t[e] << 24 | t[e + 1] << 16 | t[e + 2] << 8 | t[e + 3]) >>> 0
			}

			function h(t, e) {
				if (!(t instanceof e)) throw new TypeError("Cannot call a class as a function")
			}

			function p(t, e) {
				for (var r = 0; r < e.length; r++) {
					var n = e[r];
					n.enumerable = n.enumerable || !1, n.configurable = !0, "value" in n && (n.writable = !0), Object.defineProperty(t, n.key, n)
				}
			}

			function m(t, e, r) {
				return e && p(t.prototype, e), r && p(t, r), Object.defineProperty(t, "prototype", {
					writable: !1
				}), t
			}
			var b = [{
					qe: 22017,
					nmps: 1,
					nlps: 1,
					switchFlag: 1
				}, {
					qe: 13313,
					nmps: 2,
					nlps: 6,
					switchFlag: 0
				}, {
					qe: 6145,
					nmps: 3,
					nlps: 9,
					switchFlag: 0
				}, {
					qe: 2753,
					nmps: 4,
					nlps: 12,
					switchFlag: 0
				}, {
					qe: 1313,
					nmps: 5,
					nlps: 29,
					switchFlag: 0
				}, {
					qe: 545,
					nmps: 38,
					nlps: 33,
					switchFlag: 0
				}, {
					qe: 22017,
					nmps: 7,
					nlps: 6,
					switchFlag: 1
				}, {
					qe: 21505,
					nmps: 8,
					nlps: 14,
					switchFlag: 0
				}, {
					qe: 18433,
					nmps: 9,
					nlps: 14,
					switchFlag: 0
				}, {
					qe: 14337,
					nmps: 10,
					nlps: 14,
					switchFlag: 0
				}, {
					qe: 12289,
					nmps: 11,
					nlps: 17,
					switchFlag: 0
				}, {
					qe: 9217,
					nmps: 12,
					nlps: 18,
					switchFlag: 0
				}, {
					qe: 7169,
					nmps: 13,
					nlps: 20,
					switchFlag: 0
				}, {
					qe: 5633,
					nmps: 29,
					nlps: 21,
					switchFlag: 0
				}, {
					qe: 22017,
					nmps: 15,
					nlps: 14,
					switchFlag: 1
				}, {
					qe: 21505,
					nmps: 16,
					nlps: 14,
					switchFlag: 0
				}, {
					qe: 20737,
					nmps: 17,
					nlps: 15,
					switchFlag: 0
				}, {
					qe: 18433,
					nmps: 18,
					nlps: 16,
					switchFlag: 0
				}, {
					qe: 14337,
					nmps: 19,
					nlps: 17,
					switchFlag: 0
				}, {
					qe: 13313,
					nmps: 20,
					nlps: 18,
					switchFlag: 0
				}, {
					qe: 12289,
					nmps: 21,
					nlps: 19,
					switchFlag: 0
				}, {
					qe: 10241,
					nmps: 22,
					nlps: 19,
					switchFlag: 0
				}, {
					qe: 9217,
					nmps: 23,
					nlps: 20,
					switchFlag: 0
				}, {
					qe: 8705,
					nmps: 24,
					nlps: 21,
					switchFlag: 0
				}, {
					qe: 7169,
					nmps: 25,
					nlps: 22,
					switchFlag: 0
				}, {
					qe: 6145,
					nmps: 26,
					nlps: 23,
					switchFlag: 0
				}, {
					qe: 5633,
					nmps: 27,
					nlps: 24,
					switchFlag: 0
				}, {
					qe: 5121,
					nmps: 28,
					nlps: 25,
					switchFlag: 0
				}, {
					qe: 4609,
					nmps: 29,
					nlps: 26,
					switchFlag: 0
				}, {
					qe: 4353,
					nmps: 30,
					nlps: 27,
					switchFlag: 0
				}, {
					qe: 2753,
					nmps: 31,
					nlps: 28,
					switchFlag: 0
				}, {
					qe: 2497,
					nmps: 32,
					nlps: 29,
					switchFlag: 0
				}, {
					qe: 2209,
					nmps: 33,
					nlps: 30,
					switchFlag: 0
				}, {
					qe: 1313,
					nmps: 34,
					nlps: 31,
					switchFlag: 0
				}, {
					qe: 1089,
					nmps: 35,
					nlps: 32,
					switchFlag: 0
				}, {
					qe: 673,
					nmps: 36,
					nlps: 33,
					switchFlag: 0
				}, {
					qe: 545,
					nmps: 37,
					nlps: 34,
					switchFlag: 0
				}, {
					qe: 321,
					nmps: 38,
					nlps: 35,
					switchFlag: 0
				}, {
					qe: 273,
					nmps: 39,
					nlps: 36,
					switchFlag: 0
				}, {
					qe: 133,
					nmps: 40,
					nlps: 37,
					switchFlag: 0
				}, {
					qe: 73,
					nmps: 41,
					nlps: 38,
					switchFlag: 0
				}, {
					qe: 37,
					nmps: 42,
					nlps: 39,
					switchFlag: 0
				}, {
					qe: 21,
					nmps: 43,
					nlps: 40,
					switchFlag: 0
				}, {
					qe: 9,
					nmps: 44,
					nlps: 41,
					switchFlag: 0
				}, {
					qe: 5,
					nmps: 45,
					nlps: 42,
					switchFlag: 0
				}, {
					qe: 1,
					nmps: 45,
					nlps: 43,
					switchFlag: 0
				}, {
					qe: 22017,
					nmps: 46,
					nlps: 46,
					switchFlag: 0
				}],
				g = function() {
					function t(e, r, n) {
						h(this, t), this.data = e, this.bp = r, this.dataEnd = n, this.chigh = e[r], this.clow = 0, this.byteIn(), this.chigh = this.chigh << 7 & 65535 | this.clow >> 9 & 127, this.clow = this.clow << 7 & 65535, this.ct -= 7, this.a = 32768
					}
					return m(t, [{
						key: "byteIn",
						value: function() {
							var t = this.data,
								e = this.bp;
							255 === t[e] ? t[e + 1] > 143 ? (this.clow += 65280, this.ct = 8) : (e++, this.clow += t[e] << 9, this.ct = 7, this.bp = e) : (e++, this.clow += e < this.dataEnd ? t[e] << 8 : 65280, this.ct = 8, this.bp = e), this.clow > 65535 && (this.chigh += this.clow >> 16, this.clow &= 65535)
						}
					}, {
						key: "readBit",
						value: function(t, e) {
							var r, n = t[e] >> 1,
								i = 1 & t[e],
								o = b[n],
								a = o.qe,
								s = this.a - a;
							if (this.chigh < a) s < a ? (s = a, r = i, n = o.nmps) : (s = a, r = 1 ^ i, 1 === o.switchFlag && (i = r), n = o.nlps);
							else {
								if (this.chigh -= a, 0 !== (32768 & s)) return this.a = s, i;
								s < a ? (r = 1 ^ i, 1 === o.switchFlag && (i = r), n = o.nlps) : (r = i, n = o.nmps)
							}
							do {
								0 === this.ct && this.byteIn(), s <<= 1, this.chigh = this.chigh << 1 & 65535 | this.clow >> 15 & 1, this.clow = this.clow << 1 & 65535, this.ct--
							} while (0 === (32768 & s));
							return this.a = s, t[e] = n << 1 | i, r
						}
					}]), t
				}(),
				y = function() {
					var t = -2,
						e = -1,
						r = 0,
						n = 1,
						i = 2,
						a = 3,
						s = 4,
						c = 5,
						u = 6,
						d = 7,
						l = 8,
						f = [
							[-1, -1],
							[-1, -1],
							[7, l],
							[7, d],
							[6, u],
							[6, u],
							[6, c],
							[6, c],
							[4, r],
							[4, r],
							[4, r],
							[4, r],
							[4, r],
							[4, r],
							[4, r],
							[4, r],
							[3, n],
							[3, n],
							[3, n],
							[3, n],
							[3, n],
							[3, n],
							[3, n],
							[3, n],
							[3, n],
							[3, n],
							[3, n],
							[3, n],
							[3, n],
							[3, n],
							[3, n],
							[3, n],
							[3, s],
							[3, s],
							[3, s],
							[3, s],
							[3, s],
							[3, s],
							[3, s],
							[3, s],
							[3, s],
							[3, s],
							[3, s],
							[3, s],
							[3, s],
							[3, s],
							[3, s],
							[3, s],
							[3, a],
							[3, a],
							[3, a],
							[3, a],
							[3, a],
							[3, a],
							[3, a],
							[3, a],
							[3, a],
							[3, a],
							[3, a],
							[3, a],
							[3, a],
							[3, a],
							[3, a],
							[3, a],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i],
							[1, i]
						],
						h = [
							[-1, -1],
							[12, t],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[11, 1792],
							[11, 1792],
							[12, 1984],
							[12, 2048],
							[12, 2112],
							[12, 2176],
							[12, 2240],
							[12, 2304],
							[11, 1856],
							[11, 1856],
							[11, 1920],
							[11, 1920],
							[12, 2368],
							[12, 2432],
							[12, 2496],
							[12, 2560]
						],
						p = [
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[8, 29],
							[8, 29],
							[8, 30],
							[8, 30],
							[8, 45],
							[8, 45],
							[8, 46],
							[8, 46],
							[7, 22],
							[7, 22],
							[7, 22],
							[7, 22],
							[7, 23],
							[7, 23],
							[7, 23],
							[7, 23],
							[8, 47],
							[8, 47],
							[8, 48],
							[8, 48],
							[6, 13],
							[6, 13],
							[6, 13],
							[6, 13],
							[6, 13],
							[6, 13],
							[6, 13],
							[6, 13],
							[7, 20],
							[7, 20],
							[7, 20],
							[7, 20],
							[8, 33],
							[8, 33],
							[8, 34],
							[8, 34],
							[8, 35],
							[8, 35],
							[8, 36],
							[8, 36],
							[8, 37],
							[8, 37],
							[8, 38],
							[8, 38],
							[7, 19],
							[7, 19],
							[7, 19],
							[7, 19],
							[8, 31],
							[8, 31],
							[8, 32],
							[8, 32],
							[6, 1],
							[6, 1],
							[6, 1],
							[6, 1],
							[6, 1],
							[6, 1],
							[6, 1],
							[6, 1],
							[6, 12],
							[6, 12],
							[6, 12],
							[6, 12],
							[6, 12],
							[6, 12],
							[6, 12],
							[6, 12],
							[8, 53],
							[8, 53],
							[8, 54],
							[8, 54],
							[7, 26],
							[7, 26],
							[7, 26],
							[7, 26],
							[8, 39],
							[8, 39],
							[8, 40],
							[8, 40],
							[8, 41],
							[8, 41],
							[8, 42],
							[8, 42],
							[8, 43],
							[8, 43],
							[8, 44],
							[8, 44],
							[7, 21],
							[7, 21],
							[7, 21],
							[7, 21],
							[7, 28],
							[7, 28],
							[7, 28],
							[7, 28],
							[8, 61],
							[8, 61],
							[8, 62],
							[8, 62],
							[8, 63],
							[8, 63],
							[8, 0],
							[8, 0],
							[8, 320],
							[8, 320],
							[8, 384],
							[8, 384],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 10],
							[5, 11],
							[5, 11],
							[5, 11],
							[5, 11],
							[5, 11],
							[5, 11],
							[5, 11],
							[5, 11],
							[5, 11],
							[5, 11],
							[5, 11],
							[5, 11],
							[5, 11],
							[5, 11],
							[5, 11],
							[5, 11],
							[7, 27],
							[7, 27],
							[7, 27],
							[7, 27],
							[8, 59],
							[8, 59],
							[8, 60],
							[8, 60],
							[9, 1472],
							[9, 1536],
							[9, 1600],
							[9, 1728],
							[7, 18],
							[7, 18],
							[7, 18],
							[7, 18],
							[7, 24],
							[7, 24],
							[7, 24],
							[7, 24],
							[8, 49],
							[8, 49],
							[8, 50],
							[8, 50],
							[8, 51],
							[8, 51],
							[8, 52],
							[8, 52],
							[7, 25],
							[7, 25],
							[7, 25],
							[7, 25],
							[8, 55],
							[8, 55],
							[8, 56],
							[8, 56],
							[8, 57],
							[8, 57],
							[8, 58],
							[8, 58],
							[6, 192],
							[6, 192],
							[6, 192],
							[6, 192],
							[6, 192],
							[6, 192],
							[6, 192],
							[6, 192],
							[6, 1664],
							[6, 1664],
							[6, 1664],
							[6, 1664],
							[6, 1664],
							[6, 1664],
							[6, 1664],
							[6, 1664],
							[8, 448],
							[8, 448],
							[8, 512],
							[8, 512],
							[9, 704],
							[9, 768],
							[8, 640],
							[8, 640],
							[8, 576],
							[8, 576],
							[9, 832],
							[9, 896],
							[9, 960],
							[9, 1024],
							[9, 1088],
							[9, 1152],
							[9, 1216],
							[9, 1280],
							[9, 1344],
							[9, 1408],
							[7, 256],
							[7, 256],
							[7, 256],
							[7, 256],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 2],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[4, 3],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 128],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 8],
							[5, 9],
							[5, 9],
							[5, 9],
							[5, 9],
							[5, 9],
							[5, 9],
							[5, 9],
							[5, 9],
							[5, 9],
							[5, 9],
							[5, 9],
							[5, 9],
							[5, 9],
							[5, 9],
							[5, 9],
							[5, 9],
							[6, 16],
							[6, 16],
							[6, 16],
							[6, 16],
							[6, 16],
							[6, 16],
							[6, 16],
							[6, 16],
							[6, 17],
							[6, 17],
							[6, 17],
							[6, 17],
							[6, 17],
							[6, 17],
							[6, 17],
							[6, 17],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 4],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[6, 14],
							[6, 14],
							[6, 14],
							[6, 14],
							[6, 14],
							[6, 14],
							[6, 14],
							[6, 14],
							[6, 15],
							[6, 15],
							[6, 15],
							[6, 15],
							[6, 15],
							[6, 15],
							[6, 15],
							[6, 15],
							[5, 64],
							[5, 64],
							[5, 64],
							[5, 64],
							[5, 64],
							[5, 64],
							[5, 64],
							[5, 64],
							[5, 64],
							[5, 64],
							[5, 64],
							[5, 64],
							[5, 64],
							[5, 64],
							[5, 64],
							[5, 64],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7],
							[4, 7]
						],
						m = [
							[-1, -1],
							[-1, -1],
							[12, t],
							[12, t],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[11, 1792],
							[11, 1792],
							[11, 1792],
							[11, 1792],
							[12, 1984],
							[12, 1984],
							[12, 2048],
							[12, 2048],
							[12, 2112],
							[12, 2112],
							[12, 2176],
							[12, 2176],
							[12, 2240],
							[12, 2240],
							[12, 2304],
							[12, 2304],
							[11, 1856],
							[11, 1856],
							[11, 1856],
							[11, 1856],
							[11, 1920],
							[11, 1920],
							[11, 1920],
							[11, 1920],
							[12, 2368],
							[12, 2368],
							[12, 2432],
							[12, 2432],
							[12, 2496],
							[12, 2496],
							[12, 2560],
							[12, 2560],
							[10, 18],
							[10, 18],
							[10, 18],
							[10, 18],
							[10, 18],
							[10, 18],
							[10, 18],
							[10, 18],
							[12, 52],
							[12, 52],
							[13, 640],
							[13, 704],
							[13, 768],
							[13, 832],
							[12, 55],
							[12, 55],
							[12, 56],
							[12, 56],
							[13, 1280],
							[13, 1344],
							[13, 1408],
							[13, 1472],
							[12, 59],
							[12, 59],
							[12, 60],
							[12, 60],
							[13, 1536],
							[13, 1600],
							[11, 24],
							[11, 24],
							[11, 24],
							[11, 24],
							[11, 25],
							[11, 25],
							[11, 25],
							[11, 25],
							[13, 1664],
							[13, 1728],
							[12, 320],
							[12, 320],
							[12, 384],
							[12, 384],
							[12, 448],
							[12, 448],
							[13, 512],
							[13, 576],
							[12, 53],
							[12, 53],
							[12, 54],
							[12, 54],
							[13, 896],
							[13, 960],
							[13, 1024],
							[13, 1088],
							[13, 1152],
							[13, 1216],
							[10, 64],
							[10, 64],
							[10, 64],
							[10, 64],
							[10, 64],
							[10, 64],
							[10, 64],
							[10, 64]
						],
						b = [
							[8, 13],
							[8, 13],
							[8, 13],
							[8, 13],
							[8, 13],
							[8, 13],
							[8, 13],
							[8, 13],
							[8, 13],
							[8, 13],
							[8, 13],
							[8, 13],
							[8, 13],
							[8, 13],
							[8, 13],
							[8, 13],
							[11, 23],
							[11, 23],
							[12, 50],
							[12, 51],
							[12, 44],
							[12, 45],
							[12, 46],
							[12, 47],
							[12, 57],
							[12, 58],
							[12, 61],
							[12, 256],
							[10, 16],
							[10, 16],
							[10, 16],
							[10, 16],
							[10, 17],
							[10, 17],
							[10, 17],
							[10, 17],
							[12, 48],
							[12, 49],
							[12, 62],
							[12, 63],
							[12, 30],
							[12, 31],
							[12, 32],
							[12, 33],
							[12, 40],
							[12, 41],
							[11, 22],
							[11, 22],
							[8, 14],
							[8, 14],
							[8, 14],
							[8, 14],
							[8, 14],
							[8, 14],
							[8, 14],
							[8, 14],
							[8, 14],
							[8, 14],
							[8, 14],
							[8, 14],
							[8, 14],
							[8, 14],
							[8, 14],
							[8, 14],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 10],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[7, 11],
							[9, 15],
							[9, 15],
							[9, 15],
							[9, 15],
							[9, 15],
							[9, 15],
							[9, 15],
							[9, 15],
							[12, 128],
							[12, 192],
							[12, 26],
							[12, 27],
							[12, 28],
							[12, 29],
							[11, 19],
							[11, 19],
							[11, 20],
							[11, 20],
							[12, 34],
							[12, 35],
							[12, 36],
							[12, 37],
							[12, 38],
							[12, 39],
							[11, 21],
							[11, 21],
							[12, 42],
							[12, 43],
							[10, 0],
							[10, 0],
							[10, 0],
							[10, 0],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12],
							[7, 12]
						],
						g = [
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[-1, -1],
							[6, 9],
							[6, 8],
							[5, 7],
							[5, 7],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 6],
							[4, 5],
							[4, 5],
							[4, 5],
							[4, 5],
							[3, 1],
							[3, 1],
							[3, 1],
							[3, 1],
							[3, 1],
							[3, 1],
							[3, 1],
							[3, 1],
							[3, 4],
							[3, 4],
							[3, 4],
							[3, 4],
							[3, 4],
							[3, 4],
							[3, 4],
							[3, 4],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 3],
							[2, 2],
							[2, 2],
							[2, 2],
							[2, 2],
							[2, 2],
							[2, 2],
							[2, 2],
							[2, 2],
							[2, 2],
							[2, 2],
							[2, 2],
							[2, 2],
							[2, 2],
							[2, 2],
							[2, 2],
							[2, 2]
						];

					function y(t) {
						var e = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {};
						if (!t || "function" !== typeof t.next) throw new Error('CCITTFaxDecoder - invalid "source" parameter.');
						this.source = t, this.eof = !1, this.encoding = e.K || 0, this.eoline = e.EndOfLine || !1, this.byteAlign = e.EncodedByteAlign || !1, this.columns = e.Columns || 1728, this.rows = e.Rows || 0;
						var r, n = e.EndOfBlock;
						null !== n && void 0 !== n || (n = !0), this.eoblock = n, this.black = e.BlackIs1 || !1, this.codingLine = new Uint32Array(this.columns + 1), this.refLine = new Uint32Array(this.columns + 2), this.codingLine[0] = this.columns, this.codingPos = 0, this.row = 0, this.nextLine2D = this.encoding < 0, this.inputBits = 0, this.inputBuf = 0, this.outputBits = 0, this.rowsDone = !1;
						while (0 === (r = this._lookBits(12))) this._eatBits(1);
						1 === r && this._eatBits(12), this.encoding > 0 && (this.nextLine2D = !this._lookBits(1), this._eatBits(1))
					}
					return y.prototype = {
						readNextChar: function() {
							if (this.eof) return -1;
							var t, f, h, p, m, b = this.refLine,
								g = this.codingLine,
								y = this.columns;
							if (0 === this.outputBits) {
								if (this.rowsDone && (this.eof = !0), this.eof) return -1;
								var v, S, w;
								if (this.err = !1, this.nextLine2D) {
									for (p = 0; g[p] < y; ++p) b[p] = g[p];
									b[p++] = y, b[p] = y, g[0] = 0, this.codingPos = 0, t = 0, f = 0;
									while (g[this.codingPos] < y) switch (v = this._getTwoDimCode(), v) {
										case r:
											this._addPixels(b[t + 1], f), b[t + 1] < y && (t += 2);
											break;
										case n:
											if (v = S = 0, f) {
												do {
													v += w = this._getBlackCode()
												} while (w >= 64);
												do {
													S += w = this._getWhiteCode()
												} while (w >= 64)
											} else {
												do {
													v += w = this._getWhiteCode()
												} while (w >= 64);
												do {
													S += w = this._getBlackCode()
												} while (w >= 64)
											}
											this._addPixels(g[this.codingPos] + v, f), g[this.codingPos] < y && this._addPixels(g[this.codingPos] + S, 1 ^ f);
											while (b[t] <= g[this.codingPos] && b[t] < y) t += 2;
											break;
										case d:
											if (this._addPixels(b[t] + 3, f), f ^= 1, g[this.codingPos] < y) {
												++t;
												while (b[t] <= g[this.codingPos] && b[t] < y) t += 2
											}
											break;
										case c:
											if (this._addPixels(b[t] + 2, f), f ^= 1, g[this.codingPos] < y) {
												++t;
												while (b[t] <= g[this.codingPos] && b[t] < y) t += 2
											}
											break;
										case a:
											if (this._addPixels(b[t] + 1, f), f ^= 1, g[this.codingPos] < y) {
												++t;
												while (b[t] <= g[this.codingPos] && b[t] < y) t += 2
											}
											break;
										case i:
											if (this._addPixels(b[t], f), f ^= 1, g[this.codingPos] < y) {
												++t;
												while (b[t] <= g[this.codingPos] && b[t] < y) t += 2
											}
											break;
										case l:
											if (this._addPixelsNeg(b[t] - 3, f), f ^= 1, g[this.codingPos] < y) {
												t > 0 ? --t : ++t;
												while (b[t] <= g[this.codingPos] && b[t] < y) t += 2
											}
											break;
										case u:
											if (this._addPixelsNeg(b[t] - 2, f), f ^= 1, g[this.codingPos] < y) {
												t > 0 ? --t : ++t;
												while (b[t] <= g[this.codingPos] && b[t] < y) t += 2
											}
											break;
										case s:
											if (this._addPixelsNeg(b[t] - 1, f), f ^= 1, g[this.codingPos] < y) {
												t > 0 ? --t : ++t;
												while (b[t] <= g[this.codingPos] && b[t] < y) t += 2
											}
											break;
										case e:
											this._addPixels(y, 0), this.eof = !0;
											break;
										default:
											o("bad 2d code"), this._addPixels(y, 0), this.err = !0
									}
								} else {
									g[0] = 0, this.codingPos = 0, f = 0;
									while (g[this.codingPos] < y) {
										if (v = 0, f)
											do {
												v += w = this._getBlackCode()
											} while (w >= 64);
										else
											do {
												v += w = this._getWhiteCode()
											} while (w >= 64);
										this._addPixels(g[this.codingPos] + v, f), f ^= 1
									}
								}
								var C = !1;
								if (this.byteAlign && (this.inputBits &= -8), this.eoblock || this.row !== this.rows - 1) {
									if (v = this._lookBits(12), this.eoline)
										while (v !== e && 1 !== v) this._eatBits(1), v = this._lookBits(12);
									else
										while (0 === v) this._eatBits(1), v = this._lookBits(12);
									1 === v ? (this._eatBits(12), C = !0) : v === e && (this.eof = !0)
								} else this.rowsDone = !0;
								if (!this.eof && this.encoding > 0 && !this.rowsDone && (this.nextLine2D = !this._lookBits(1), this._eatBits(1)), this.eoblock && C && this.byteAlign) {
									if (v = this._lookBits(12), 1 === v) {
										if (this._eatBits(12), this.encoding > 0 && (this._lookBits(1), this._eatBits(1)), this.encoding >= 0)
											for (p = 0; p < 4; ++p) v = this._lookBits(12), 1 !== v && o("bad rtc code: " + v), this._eatBits(12), this.encoding > 0 && (this._lookBits(1), this._eatBits(1));
										this.eof = !0
									}
								} else if (this.err && this.eoline) {
									while (1) {
										if (v = this._lookBits(13), v === e) return this.eof = !0, -1;
										if (v >> 1 === 1) break;
										this._eatBits(1)
									}
									this._eatBits(12), this.encoding > 0 && (this._eatBits(1), this.nextLine2D = !(1 & v))
								}
								g[0] > 0 ? this.outputBits = g[this.codingPos = 0] : this.outputBits = g[this.codingPos = 1], this.row++
							}
							if (this.outputBits >= 8) m = 1 & this.codingPos ? 0 : 255, this.outputBits -= 8, 0 === this.outputBits && g[this.codingPos] < y && (this.codingPos++, this.outputBits = g[this.codingPos] - g[this.codingPos - 1]);
							else {
								h = 8, m = 0;
								do {
									this.outputBits > h ? (m <<= h, 1 & this.codingPos || (m |= 255 >> 8 - h), this.outputBits -= h, h = 0) : (m <<= this.outputBits, 1 & this.codingPos || (m |= 255 >> 8 - this.outputBits), h -= this.outputBits, this.outputBits = 0, g[this.codingPos] < y ? (this.codingPos++, this.outputBits = g[this.codingPos] - g[this.codingPos - 1]) : h > 0 && (m <<= h, h = 0))
								} while (h)
							}
							return this.black && (m ^= 255), m
						},
						_addPixels: function(t, e) {
							var r = this.codingLine,
								n = this.codingPos;
							t > r[n] && (t > this.columns && (o("row is wrong length"), this.err = !0, t = this.columns), 1 & n ^ e && ++n, r[n] = t), this.codingPos = n
						},
						_addPixelsNeg: function(t, e) {
							var r = this.codingLine,
								n = this.codingPos;
							if (t > r[n]) t > this.columns && (o("row is wrong length"), this.err = !0, t = this.columns), 1 & n ^ e && ++n, r[n] = t;
							else if (t < r[n]) {
								t < 0 && (o("invalid code"), this.err = !0, t = 0);
								while (n > 0 && t < r[n - 1]) --n;
								r[n] = t
							}
							this.codingPos = n
						},
						_findTableCode: function(t, r, n, i) {
							for (var o = i || 0, a = t; a <= r; ++a) {
								var s = this._lookBits(a);
								if (s === e) return [!0, 1, !1];
								if (a < r && (s <<= r - a), !o || s >= o) {
									var c = n[s - o];
									if (c[0] === a) return this._eatBits(a), [!0, c[1], !0]
								}
							}
							return [!1, 0, !1]
						},
						_getTwoDimCode: function() {
							var t, r = 0;
							if (this.eoblock) {
								if (r = this._lookBits(7), t = f[r], t && t[0] > 0) return this._eatBits(t[0]), t[1]
							} else {
								var n = this._findTableCode(1, 7, f);
								if (n[0] && n[2]) return n[1]
							}
							return o("Bad two dim code"), e
						},
						_getWhiteCode: function() {
							var t, r = 0;
							if (this.eoblock) {
								if (r = this._lookBits(12), r === e) return 1;
								if (t = r >> 5 === 0 ? h[r] : p[r >> 3], t[0] > 0) return this._eatBits(t[0]), t[1]
							} else {
								var n = this._findTableCode(1, 9, p);
								if (n[0]) return n[1];
								if (n = this._findTableCode(11, 12, h), n[0]) return n[1]
							}
							return o("bad white code"), this._eatBits(1), 1
						},
						_getBlackCode: function() {
							var t, r;
							if (this.eoblock) {
								if (t = this._lookBits(13), t === e) return 1;
								if (r = t >> 7 === 0 ? m[t] : t >> 9 === 0 && t >> 7 !== 0 ? b[(t >> 1) - 64] : g[t >> 7], r[0] > 0) return this._eatBits(r[0]), r[1]
							} else {
								var n = this._findTableCode(2, 6, g);
								if (n[0]) return n[1];
								if (n = this._findTableCode(7, 12, b, 64), n[0]) return n[1];
								if (n = this._findTableCode(10, 13, m), n[0]) return n[1]
							}
							return o("bad black code"), this._eatBits(1), 1
						},
						_lookBits: function(t) {
							var r;
							while (this.inputBits < t) {
								if (-1 === (r = this.source.next())) return 0 === this.inputBits ? e : this.inputBuf << t - this.inputBits & 65535 >> 16 - t;
								this.inputBuf = this.inputBuf << 8 | r, this.inputBits += 8
							}
							return this.inputBuf >> this.inputBits - t & 65535 >> 16 - t
						},
						_eatBits: function(t) {
							(this.inputBits -= t) < 0 && (this.inputBits = 0)
						}
					}, y
				}();

			function v(t) {
				return v = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t) {
					return typeof t
				} : function(t) {
					return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
				}, v(t)
			}

			function S(t, e) {
				for (var r = 0; r < e.length; r++) {
					var n = e[r];
					n.enumerable = n.enumerable || !1, n.configurable = !0, "value" in n && (n.writable = !0), Object.defineProperty(t, n.key, n)
				}
			}

			function w(t, e, r) {
				return e && S(t.prototype, e), r && S(t, r), Object.defineProperty(t, "prototype", {
					writable: !1
				}), t
			}

			function C(t, e) {
				if (!(t instanceof e)) throw new TypeError("Cannot call a class as a function")
			}

			function _(t, e) {
				if ("function" !== typeof e && null !== e) throw new TypeError("Super expression must either be null or a function");
				t.prototype = Object.create(e && e.prototype, {
					constructor: {
						value: t,
						writable: !0,
						configurable: !0
					}
				}), Object.defineProperty(t, "prototype", {
					writable: !1
				}), e && A(t, e)
			}

			function A(t, e) {
				return A = Object.setPrototypeOf || function(t, e) {
					return t.__proto__ = e, t
				}, A(t, e)
			}

			function I(t) {
				var e = x();
				return function() {
					var r, n = P(t);
					if (e) {
						var i = P(this)
							.constructor;
						r = Reflect.construct(n, arguments, i)
					} else r = n.apply(this, arguments);
					return E(this, r)
				}
			}

			function E(t, e) {
				if (e && ("object" === v(e) || "function" === typeof e)) return e;
				if (void 0 !== e) throw new TypeError("Derived constructors may only return object or undefined");
				return T(t)
			}

			function T(t) {
				if (void 0 === t) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
				return t
			}

			function x() {
				if ("undefined" === typeof Reflect || !Reflect.construct) return !1;
				if (Reflect.construct.sham) return !1;
				if ("function" === typeof Proxy) return !0;
				try {
					return Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], (function() {}))), !0
				} catch (t) {
					return !1
				}
			}

			function P(t) {
				return P = Object.setPrototypeOf ? Object.getPrototypeOf : function(t) {
					return t.__proto__ || Object.getPrototypeOf(t)
				}, P(t)
			}
			var k = function(t) {
					_(r, t);
					var e = I(r);

					function r(t) {
						return C(this, r), e.call(this, "JBIG2 error: ".concat(t))
					}
					return w(r)
				}(c),
				D = function() {
					function t() {}

					function e(t, e, r) {
						this.data = t, this.start = e, this.end = r
					}

					function r(t, e, r) {
						var n = t.getContexts(e),
							i = 1;

						function o(t) {
							for (var e = 0, o = 0; o < t; o++) {
								var a = r.readBit(n, i);
								i = i < 256 ? i << 1 | a : 511 & (i << 1 | a) | 256, e = e << 1 | a
							}
							return e >>> 0
						}
						var a = o(1),
							s = o(1) ? o(1) ? o(1) ? o(1) ? o(1) ? o(32) + 4436 : o(12) + 340 : o(8) + 84 : o(6) + 20 : o(4) + 4 : o(2);
						return 0 === a ? s : s > 0 ? -s : null
					}

					function n(t, e, r) {
						for (var n = t.getContexts("IAID"), i = 1, o = 0; o < r; o++) {
							var a = e.readBit(n, i);
							i = i << 1 | a
						}
						return r < 31 ? i & (1 << r) - 1 : 2147483647 & i
					}
					t.prototype = {
						getContexts: function(t) {
							return t in this ? this[t] : this[t] = new Int8Array(65536)
						}
					}, e.prototype = {
						get decoder() {
							var t = new g(this.data, this.start, this.end);
							return s(this, "decoder", t)
						},
						get contextCache() {
							var e = new t;
							return s(this, "contextCache", e)
						}
					};
					var i = ["SymbolDictionary", null, null, null, "IntermediateTextRegion", null, "ImmediateTextRegion", "ImmediateLosslessTextRegion", null, null, null, null, null, null, null, null, "PatternDictionary", null, null, null, "IntermediateHalftoneRegion", null, "ImmediateHalftoneRegion", "ImmediateLosslessHalftoneRegion", null, null, null, null, null, null, null, null, null, null, null, null, "IntermediateGenericRegion", null, "ImmediateGenericRegion", "ImmediateLosslessGenericRegion", "IntermediateGenericRefinementRegion", null, "ImmediateGenericRefinementRegion", "ImmediateLosslessGenericRefinementRegion", null, null, null, null, "PageInformation", "EndOfPage", "EndOfStripe", "EndOfFile", "Profiles", "Tables", null, null, null, null, null, null, null, null, "Extension"],
						o = [
							[{
								x: -1,
								y: -2
							}, {
								x: 0,
								y: -2
							}, {
								x: 1,
								y: -2
							}, {
								x: -2,
								y: -1
							}, {
								x: -1,
								y: -1
							}, {
								x: 0,
								y: -1
							}, {
								x: 1,
								y: -1
							}, {
								x: 2,
								y: -1
							}, {
								x: -4,
								y: 0
							}, {
								x: -3,
								y: 0
							}, {
								x: -2,
								y: 0
							}, {
								x: -1,
								y: 0
							}],
							[{
								x: -1,
								y: -2
							}, {
								x: 0,
								y: -2
							}, {
								x: 1,
								y: -2
							}, {
								x: 2,
								y: -2
							}, {
								x: -2,
								y: -1
							}, {
								x: -1,
								y: -1
							}, {
								x: 0,
								y: -1
							}, {
								x: 1,
								y: -1
							}, {
								x: 2,
								y: -1
							}, {
								x: -3,
								y: 0
							}, {
								x: -2,
								y: 0
							}, {
								x: -1,
								y: 0
							}],
							[{
								x: -1,
								y: -2
							}, {
								x: 0,
								y: -2
							}, {
								x: 1,
								y: -2
							}, {
								x: -2,
								y: -1
							}, {
								x: -1,
								y: -1
							}, {
								x: 0,
								y: -1
							}, {
								x: 1,
								y: -1
							}, {
								x: -2,
								y: 0
							}, {
								x: -1,
								y: 0
							}],
							[{
								x: -3,
								y: -1
							}, {
								x: -2,
								y: -1
							}, {
								x: -1,
								y: -1
							}, {
								x: 0,
								y: -1
							}, {
								x: 1,
								y: -1
							}, {
								x: -4,
								y: 0
							}, {
								x: -3,
								y: 0
							}, {
								x: -2,
								y: 0
							}, {
								x: -1,
								y: 0
							}]
						],
						a = [{
							coding: [{
								x: 0,
								y: -1
							}, {
								x: 1,
								y: -1
							}, {
								x: -1,
								y: 0
							}],
							reference: [{
								x: 0,
								y: -1
							}, {
								x: 1,
								y: -1
							}, {
								x: -1,
								y: 0
							}, {
								x: 0,
								y: 0
							}, {
								x: 1,
								y: 0
							}, {
								x: -1,
								y: 1
							}, {
								x: 0,
								y: 1
							}, {
								x: 1,
								y: 1
							}]
						}, {
							coding: [{
								x: -1,
								y: -1
							}, {
								x: 0,
								y: -1
							}, {
								x: 1,
								y: -1
							}, {
								x: -1,
								y: 0
							}],
							reference: [{
								x: 0,
								y: -1
							}, {
								x: -1,
								y: 0
							}, {
								x: 0,
								y: 0
							}, {
								x: 1,
								y: 0
							}, {
								x: 0,
								y: 1
							}, {
								x: 1,
								y: 1
							}]
						}],
						c = [39717, 1941, 229, 405],
						h = [32, 8];

					function p(t, e, r) {
						var n, i, o, a, s, c, u, d = r.decoder,
							l = r.contextCache.getContexts("GB"),
							f = [],
							h = 31735;
						for (i = 0; i < e; i++)
							for (s = f[i] = new Uint8Array(t), c = i < 1 ? s : f[i - 1], u = i < 2 ? s : f[i - 2], n = u[0] << 13 | u[1] << 12 | u[2] << 11 | c[0] << 7 | c[1] << 6 | c[2] << 5 | c[3] << 4, o = 0; o < t; o++) s[o] = a = d.readBit(l, n), n = (n & h) << 1 | (o + 3 < t ? u[o + 3] << 11 : 0) | (o + 4 < t ? c[o + 4] << 4 : 0) | a;
						return f
					}

					function m(t, e, r, n, i, a, s, u) {
						if (t) {
							var d = new K(u.data, u.start, u.end);
							return G(d, e, r, !1)
						}
						if (0 === n && !a && !i && 4 === s.length && 3 === s[0].x && -1 === s[0].y && -3 === s[1].x && -1 === s[1].y && 2 === s[2].x && -2 === s[2].y && -2 === s[3].x && -2 === s[3].y) return p(e, r, u);
						var l = !!a,
							f = o[n].concat(s);
						f.sort((function(t, e) {
							return t.y - e.y || t.x - e.x
						}));
						var h, m, b = f.length,
							g = new Int8Array(b),
							y = new Int8Array(b),
							v = [],
							S = 0,
							w = 0,
							C = 0,
							_ = 0;
						for (m = 0; m < b; m++) g[m] = f[m].x, y[m] = f[m].y, w = Math.min(w, f[m].x), C = Math.max(C, f[m].x), _ = Math.min(_, f[m].y), m < b - 1 && f[m].y === f[m + 1].y && f[m].x === f[m + 1].x - 1 ? S |= 1 << b - 1 - m : v.push(m);
						var A = v.length,
							I = new Int8Array(A),
							E = new Int8Array(A),
							T = new Uint16Array(A);
						for (h = 0; h < A; h++) m = v[h], I[h] = f[m].x, E[h] = f[m].y, T[h] = 1 << b - 1 - m;
						for (var x, P, k, D, O, R = -w, N = -_, M = e - C, B = c[n], F = new Uint8Array(e), j = [], L = u.decoder, U = u.contextCache.getContexts("GB"), X = 0, z = 0, q = 0; q < r; q++) {
							if (i) {
								var W = L.readBit(U, B);
								if (X ^= W, X) {
									j.push(F);
									continue
								}
							}
							for (F = new Uint8Array(F), j.push(F), x = 0; x < e; x++)
								if (l && a[q][x]) F[x] = 0;
								else {
									if (x >= R && x < M && q >= N)
										for (z = z << 1 & S, m = 0; m < A; m++) P = q + E[m], k = x + I[m], D = j[P][k], D && (D = T[m], z |= D);
									else
										for (z = 0, O = b - 1, m = 0; m < b; m++, O--) k = x + g[m], k >= 0 && k < e && (P = q + y[m], P >= 0 && (D = j[P][k], D && (z |= D << O)));
									var V = L.readBit(U, z);
									F[x] = V
								}
						}
						return j
					}

					function b(t, e, r, n, i, o, s, c, u) {
						var d = a[r].coding;
						0 === r && (d = d.concat([c[0]]));
						var l, f = d.length,
							p = new Int32Array(f),
							m = new Int32Array(f);
						for (l = 0; l < f; l++) p[l] = d[l].x, m[l] = d[l].y;
						var b = a[r].reference;
						0 === r && (b = b.concat([c[1]]));
						var g = b.length,
							y = new Int32Array(g),
							v = new Int32Array(g);
						for (l = 0; l < g; l++) y[l] = b[l].x, v[l] = b[l].y;
						for (var S = n[0].length, w = n.length, C = h[r], _ = [], A = u.decoder, I = u.contextCache.getContexts("GR"), E = 0, T = 0; T < e; T++) {
							if (s) {
								var x = A.readBit(I, C);
								if (E ^= x, E) throw new k("prediction is not supported")
							}
							var P = new Uint8Array(t);
							_.push(P);
							for (var D = 0; D < t; D++) {
								var O, R, N = 0;
								for (l = 0; l < f; l++) O = T + m[l], R = D + p[l], O < 0 || R < 0 || R >= t ? N <<= 1 : N = N << 1 | _[O][R];
								for (l = 0; l < g; l++) O = T + v[l] - o, R = D + y[l] - i, O < 0 || O >= w || R < 0 || R >= S ? N <<= 1 : N = N << 1 | n[O][R];
								var M = A.readBit(I, N);
								P[D] = M
							}
						}
						return _
					}

					function v(t, e, i, o, a, s, c, d, l, f, h, p) {
						if (t && e) throw new k("symbol refinement with Huffman is not supported");
						var g, y, v = [],
							w = 0,
							C = u(i.length + o),
							_ = h.decoder,
							A = h.contextCache;
						t && (g = j(1), y = [], C = Math.max(C, 1));
						while (v.length < o) {
							var I = t ? s.tableDeltaHeight.decode(p) : r(A, "IADH", _);
							w += I;
							var E = 0,
								T = 0,
								x = t ? y.length : 0;
							while (1) {
								var P, D = t ? s.tableDeltaWidth.decode(p) : r(A, "IADW", _);
								if (null === D) break;
								if (E += D, T += E, e) {
									var O = r(A, "IAAI", _);
									if (O > 1) P = S(t, e, E, w, 0, O, 1, i.concat(v), C, 0, 0, 1, 0, s, l, f, h, 0, p);
									else {
										var R = n(A, _, C),
											N = r(A, "IARDX", _),
											M = r(A, "IARDY", _),
											B = R < i.length ? i[R] : v[R - i.length];
										P = b(E, w, l, B, N, M, !1, f, h)
									}
									v.push(P)
								} else t ? y.push(E) : (P = m(!1, E, w, c, !1, null, d, h), v.push(P))
							}
							if (t && !e) {
								var F = s.tableBitmapSize.decode(p);
								p.byteAlign();
								var K = void 0;
								if (0 === F) K = z(p, T, w);
								else {
									var L = p.end,
										U = p.position + F;
									p.end = U, K = G(p, T, w, !1), p.end = L, p.position = U
								}
								var X = y.length;
								if (x === X - 1) v.push(K);
								else {
									var q = void 0,
										W = void 0,
										V = 0,
										H = void 0,
										Y = void 0,
										Z = void 0;
									for (q = x; q < X; q++) {
										for (Y = y[q], H = V + Y, Z = [], W = 0; W < w; W++) Z.push(K[W].subarray(V, H));
										v.push(Z), V = H
									}
								}
							}
						}
						var Q = [],
							J = [],
							$ = !1,
							tt = i.length + o;
						while (J.length < tt) {
							var et = t ? g.decode(p) : r(A, "IAEX", _);
							while (et--) J.push($);
							$ = !$
						}
						for (var rt = 0, nt = i.length; rt < nt; rt++) J[rt] && Q.push(i[rt]);
						for (var it = 0; it < o; rt++, it++) J[rt] && Q.push(v[it]);
						return Q
					}

					function S(t, e, i, o, a, s, c, u, d, l, f, h, p, m, g, y, v, S, w) {
						if (t && e) throw new k("refinement with Huffman is not supported");
						var C, _, A = [];
						for (C = 0; C < o; C++) {
							if (_ = new Uint8Array(i), a)
								for (var I = 0; I < i; I++) _[I] = a;
							A.push(_)
						}
						var E = v.decoder,
							T = v.contextCache,
							x = t ? -m.tableDeltaT.decode(w) : -r(T, "IADT", E),
							P = 0;
						C = 0;
						while (C < s) {
							var D = t ? m.tableDeltaT.decode(w) : r(T, "IADT", E);
							x += D;
							var O = t ? m.tableFirstS.decode(w) : r(T, "IAFS", E);
							P += O;
							var R = P;
							do {
								var N = 0;
								c > 1 && (N = t ? w.readBits(S) : r(T, "IAIT", E));
								var M = c * x + N,
									B = t ? m.symbolIDTable.decode(w) : n(T, E, d),
									F = e && (t ? w.readBit() : r(T, "IARI", E)),
									j = u[B],
									K = j[0].length,
									L = j.length;
								if (F) {
									var U = r(T, "IARDW", E),
										X = r(T, "IARDH", E),
										z = r(T, "IARDX", E),
										G = r(T, "IARDY", E);
									K += U, L += X, j = b(K, L, g, j, (U >> 1) + z, (X >> 1) + G, !1, y, v)
								}
								var q, W, V, H = M - (1 & h ? 0 : L - 1),
									Y = R - (2 & h ? K - 1 : 0);
								if (l) {
									for (q = 0; q < L; q++)
										if (_ = A[Y + q], _) {
											V = j[q];
											var Z = Math.min(i - H, K);
											switch (p) {
												case 0:
													for (W = 0; W < Z; W++) _[H + W] |= V[W];
													break;
												case 2:
													for (W = 0; W < Z; W++) _[H + W] ^= V[W];
													break;
												default:
													throw new k("operator ".concat(p, " is not supported"))
											}
										} R += L - 1
								} else {
									for (W = 0; W < L; W++)
										if (_ = A[H + W], _) switch (V = j[W], p) {
											case 0:
												for (q = 0; q < K; q++) _[Y + q] |= V[q];
												break;
											case 2:
												for (q = 0; q < K; q++) _[Y + q] ^= V[q];
												break;
											default:
												throw new k("operator ".concat(p, " is not supported"))
										}
									R += K - 1
								}
								C++;
								var Q = t ? m.tableDeltaS.decode(w) : r(T, "IADS", E);
								if (null === Q) break;
								R += Q + f
							} while (1)
						}
						return A
					}

					function w(t, e, r, n, i, o) {
						var a = [];
						t || (a.push({
							x: -e,
							y: 0
						}), 0 === i && (a.push({
							x: -3,
							y: -1
						}), a.push({
							x: 2,
							y: -2
						}), a.push({
							x: -2,
							y: -2
						})));
						for (var s = (n + 1) * e, c = m(t, s, r, i, !1, null, a, o), u = [], d = 0; d <= n; d++) {
							for (var l = [], f = e * d, h = f + e, p = 0; p < r; p++) l.push(c[p].subarray(f, h));
							u.push(l)
						}
						return u
					}

					function C(t, e, r, n, i, o, a, s, c, d, l, f, h, p, b) {
						var g = null;
						if (a) throw new k("skip is not supported");
						if (0 !== s) throw new k("operator " + s + " is not supported in halftone region");
						var y, v, S, w = [];
						for (y = 0; y < i; y++) {
							if (S = new Uint8Array(n), o)
								for (v = 0; v < n; v++) S[v] = o;
							w.push(S)
						}
						var C = e.length,
							_ = e[0],
							A = _[0].length,
							I = _.length,
							E = u(C),
							T = [];
						t || (T.push({
							x: r <= 1 ? 3 : 2,
							y: -1
						}), 0 === r && (T.push({
							x: -3,
							y: -1
						}), T.push({
							x: 2,
							y: -2
						}), T.push({
							x: -2,
							y: -2
						})));
						var x, P, D, O, R, N, M, B, F, j, L, U = [];
						for (t && (x = new K(b.data, b.start, b.end)), y = E - 1; y >= 0; y--) P = t ? G(x, c, d, !0) : m(!1, c, d, r, !1, g, T, b), U[y] = P;
						for (D = 0; D < d; D++)
							for (O = 0; O < c; O++) {
								for (R = 0, N = 0, v = E - 1; v >= 0; v--) R = U[v][D][O] ^ R, N |= R << v;
								if (M = e[N], B = l + D * p + O * h >> 8, F = f + D * h - O * p >> 8, B >= 0 && B + A <= n && F >= 0 && F + I <= i)
									for (y = 0; y < I; y++)
										for (L = w[F + y], j = M[y], v = 0; v < A; v++) L[B + v] |= j[v];
								else {
									var X = void 0,
										z = void 0;
									for (y = 0; y < I; y++)
										if (z = F + y, !(z < 0 || z >= i))
											for (L = w[z], j = M[y], v = 0; v < A; v++) X = B + v, X >= 0 && X < n && (L[X] |= j[v])
								}
							}
						return w
					}

					function _(t, e) {
						var r = {};
						r.number = f(t, e);
						var n = t[e + 4],
							o = 63 & n;
						if (!i[o]) throw new k("invalid segment type: " + o);
						r.type = o, r.typeName = i[o], r.deferredNonRetain = !!(128 & n);
						var a = !!(64 & n),
							s = t[e + 5],
							c = s >> 5 & 7,
							u = [31 & s],
							d = e + 6;
						if (7 === s) {
							c = 536870911 & f(t, d - 1), d += 3;
							var h = c + 7 >> 3;
							u[0] = t[d++];
							while (--h > 0) u.push(t[d++])
						} else if (5 === s || 6 === s) throw new k("invalid referred-to flags");
						r.retainBits = u;
						var p = 4;
						r.number <= 256 ? p = 1 : r.number <= 65536 && (p = 2);
						var m, b, g = [];
						for (m = 0; m < c; m++) {
							var y = void 0;
							y = 1 === p ? t[d] : 2 === p ? l(t, d) : f(t, d), g.push(y), d += p
						}
						if (r.referredTo = g, a ? (r.pageAssociation = f(t, d), d += 4) : r.pageAssociation = t[d++], r.length = f(t, d), d += 4, 4294967295 === r.length) {
							if (38 !== o) throw new k("invalid unknown segment length");
							var v = I(t, d),
								S = t[d + E],
								w = !!(1 & S),
								C = 6,
								_ = new Uint8Array(C);
							for (w || (_[0] = 255, _[1] = 172), _[2] = v.height >>> 24 & 255, _[3] = v.height >> 16 & 255, _[4] = v.height >> 8 & 255, _[5] = 255 & v.height, m = d, b = t.length; m < b; m++) {
								var A = 0;
								while (A < C && _[A] === t[m + A]) A++;
								if (A === C) {
									r.length = m + C;
									break
								}
							}
							if (4294967295 === r.length) throw new k("segment end was not found")
						}
						return r.headerEnd = d, r
					}

					function A(t, e, r, n) {
						var i = [],
							o = r;
						while (o < n) {
							var a = _(e, o);
							o = a.headerEnd;
							var s = {
								header: a,
								data: e
							};
							if (t.randomAccess || (s.start = o, o += a.length, s.end = o), i.push(s), 51 === a.type) break
						}
						if (t.randomAccess)
							for (var c = 0, u = i.length; c < u; c++) i[c].start = o, o += i[c].header.length, i[c].end = o;
						return i
					}

					function I(t, e) {
						return {
							width: f(t, e),
							height: f(t, e + 4),
							x: f(t, e + 8),
							y: f(t, e + 12),
							combinationOperator: 7 & t[e + 16]
						}
					}
					var E = 17;

					function T(t, e) {
						var r, n, i, o, a = t.header,
							s = t.data,
							c = t.start,
							u = t.end;
						switch (a.type) {
							case 0:
								var h = {},
									p = l(s, c);
								if (h.huffman = !!(1 & p), h.refinement = !!(2 & p), h.huffmanDHSelector = p >> 2 & 3, h.huffmanDWSelector = p >> 4 & 3, h.bitmapSizeSelector = p >> 6 & 1, h.aggregationInstancesSelector = p >> 7 & 1, h.bitmapCodingContextUsed = !!(256 & p), h.bitmapCodingContextRetained = !!(512 & p), h.template = p >> 10 & 3, h.refinementTemplate = p >> 12 & 1, c += 2, !h.huffman) {
									for (o = 0 === h.template ? 4 : 1, n = [], i = 0; i < o; i++) n.push({
										x: d(s, c),
										y: d(s, c + 1)
									}), c += 2;
									h.at = n
								}
								if (h.refinement && !h.refinementTemplate) {
									for (n = [], i = 0; i < 2; i++) n.push({
										x: d(s, c),
										y: d(s, c + 1)
									}), c += 2;
									h.refinementAt = n
								}
								h.numberOfExportedSymbols = f(s, c), c += 4, h.numberOfNewSymbols = f(s, c), c += 4, r = [h, a.number, a.referredTo, s, c, u];
								break;
							case 6:
							case 7:
								var m = {};
								m.info = I(s, c), c += E;
								var b = l(s, c);
								if (c += 2, m.huffman = !!(1 & b), m.refinement = !!(2 & b), m.logStripSize = b >> 2 & 3, m.stripSize = 1 << m.logStripSize, m.referenceCorner = b >> 4 & 3, m.transposed = !!(64 & b), m.combinationOperator = b >> 7 & 3, m.defaultPixelValue = b >> 9 & 1, m.dsOffset = b << 17 >> 27, m.refinementTemplate = b >> 15 & 1, m.huffman) {
									var g = l(s, c);
									c += 2, m.huffmanFS = 3 & g, m.huffmanDS = g >> 2 & 3, m.huffmanDT = g >> 4 & 3, m.huffmanRefinementDW = g >> 6 & 3, m.huffmanRefinementDH = g >> 8 & 3, m.huffmanRefinementDX = g >> 10 & 3, m.huffmanRefinementDY = g >> 12 & 3, m.huffmanRefinementSizeSelector = !!(16384 & g)
								}
								if (m.refinement && !m.refinementTemplate) {
									for (n = [], i = 0; i < 2; i++) n.push({
										x: d(s, c),
										y: d(s, c + 1)
									}), c += 2;
									m.refinementAt = n
								}
								m.numberOfSymbolInstances = f(s, c), c += 4, r = [m, a.referredTo, s, c, u];
								break;
							case 16:
								var y = {},
									v = s[c++];
								y.mmr = !!(1 & v), y.template = v >> 1 & 3, y.patternWidth = s[c++], y.patternHeight = s[c++], y.maxPatternIndex = f(s, c), c += 4, r = [y, a.number, s, c, u];
								break;
							case 22:
							case 23:
								var S = {};
								S.info = I(s, c), c += E;
								var w = s[c++];
								S.mmr = !!(1 & w), S.template = w >> 1 & 3, S.enableSkip = !!(8 & w), S.combinationOperator = w >> 4 & 7, S.defaultPixelValue = w >> 7 & 1, S.gridWidth = f(s, c), c += 4, S.gridHeight = f(s, c), c += 4, S.gridOffsetX = 4294967295 & f(s, c), c += 4, S.gridOffsetY = 4294967295 & f(s, c), c += 4, S.gridVectorX = l(s, c), c += 2, S.gridVectorY = l(s, c), c += 2, r = [S, a.referredTo, s, c, u];
								break;
							case 38:
							case 39:
								var C = {};
								C.info = I(s, c), c += E;
								var _ = s[c++];
								if (C.mmr = !!(1 & _), C.template = _ >> 1 & 3, C.prediction = !!(8 & _), !C.mmr) {
									for (o = 0 === C.template ? 4 : 1, n = [], i = 0; i < o; i++) n.push({
										x: d(s, c),
										y: d(s, c + 1)
									}), c += 2;
									C.at = n
								}
								r = [C, s, c, u];
								break;
							case 48:
								var A = {
									width: f(s, c),
									height: f(s, c + 4),
									resolutionX: f(s, c + 8),
									resolutionY: f(s, c + 12)
								};
								4294967295 === A.height && delete A.height;
								var T = s[c + 16];
								l(s, c + 17), A.lossless = !!(1 & T), A.refinement = !!(2 & T), A.defaultPixelValue = T >> 2 & 1, A.combinationOperator = T >> 3 & 3, A.requiresBuffer = !!(32 & T), A.combinationOperatorOverride = !!(64 & T), r = [A];
								break;
							case 49:
								break;
							case 50:
								break;
							case 51:
								break;
							case 53:
								r = [a.number, s, c, u];
								break;
							case 62:
								break;
							default:
								throw new k("segment type ".concat(a.typeName, "(")
									.concat(a.type, ")") + " is not implemented")
						}
						var x = "on" + a.typeName;
						x in e && e[x].apply(e, r)
					}

					function x(t, e) {
						for (var r = 0, n = t.length; r < n; r++) T(t[r], e)
					}

					function P(t) {
						for (var e = new O, r = 0, n = t.length; r < n; r++) {
							var i = t[r],
								o = A({}, i.data, i.start, i.end);
							x(o, e)
						}
						return e.buffer
					}

					function D(t) {
						var e = t.length,
							r = 0;
						if (151 !== t[r] || 74 !== t[r + 1] || 66 !== t[r + 2] || 50 !== t[r + 3] || 13 !== t[r + 4] || 10 !== t[r + 5] || 26 !== t[r + 6] || 10 !== t[r + 7]) throw new k("parseJbig2 - invalid header.");
						var n = Object.create(null);
						r += 8;
						var i = t[r++];
						n.randomAccess = !(1 & i), 2 & i || (n.numberOfPages = f(t, r), r += 4);
						var o = A(n, t, r, e),
							a = new O;
						x(o, a);
						for (var s = a.currentPageInfo, c = s.width, u = s.height, d = a.buffer, l = new Uint8ClampedArray(c * u), h = 0, p = 0, m = 0; m < u; m++)
							for (var b = 0, g = void 0, y = 0; y < c; y++) b || (b = 128, g = d[p++]), l[h++] = g & b ? 0 : 255, b >>= 1;
						return {
							imgData: l,
							width: c,
							height: u
						}
					}

					function O() {}

					function R(t) {
						2 === t.length ? (this.isOOB = !0, this.rangeLow = 0, this.prefixLength = t[0], this.rangeLength = 0, this.prefixCode = t[1], this.isLowerRange = !1) : (this.isOOB = !1, this.rangeLow = t[0], this.prefixLength = t[1], this.rangeLength = t[2], this.prefixCode = t[3], this.isLowerRange = "lower" === t[4])
					}

					function N(t) {
						this.children = [], t ? (this.isLeaf = !0, this.rangeLength = t.rangeLength, this.rangeLow = t.rangeLow, this.isLowerRange = t.isLowerRange, this.isOOB = t.isOOB) : this.isLeaf = !1
					}

					function M(t, e) {
						e || this.assignPrefixCodes(t), this.rootNode = new N(null);
						for (var r = 0, n = t.length; r < n; r++) {
							var i = t[r];
							i.prefixLength > 0 && this.rootNode.buildTree(i, i.prefixLength - 1)
						}
					}

					function B(t, e, r) {
						var n, i, o = t[e],
							a = 4294967295 & f(t, e + 1),
							s = 4294967295 & f(t, e + 5),
							c = new K(t, e + 9, r),
							u = 1 + (o >> 1 & 7),
							d = 1 + (o >> 4 & 7),
							l = [],
							h = a;
						do {
							n = c.readBits(u), i = c.readBits(d), l.push(new R([h, n, i, 0])), h += 1 << i
						} while (h < s);
						return n = c.readBits(u), l.push(new R([a - 1, n, 32, 0, "lower"])), n = c.readBits(u), l.push(new R([s, n, 32, 0])), 1 & o && (n = c.readBits(u), l.push(new R([n, 0]))), new M(l, !1)
					}
					O.prototype = {
						onPageInformation: function(t) {
							this.currentPageInfo = t;
							var e = t.width + 7 >> 3,
								r = new Uint8ClampedArray(e * t.height);
							if (t.defaultPixelValue)
								for (var n = 0, i = r.length; n < i; n++) r[n] = 255;
							this.buffer = r
						},
						drawBitmap: function(t, e) {
							var r, n, i, o, a = this.currentPageInfo,
								s = t.width,
								c = t.height,
								u = a.width + 7 >> 3,
								d = a.combinationOperatorOverride ? t.combinationOperator : a.combinationOperator,
								l = this.buffer,
								f = 128 >> (7 & t.x),
								h = t.y * u + (t.x >> 3);
							switch (d) {
								case 0:
									for (r = 0; r < c; r++) {
										for (i = f, o = h, n = 0; n < s; n++) e[r][n] && (l[o] |= i), i >>= 1, i || (i = 128, o++);
										h += u
									}
									break;
								case 2:
									for (r = 0; r < c; r++) {
										for (i = f, o = h, n = 0; n < s; n++) e[r][n] && (l[o] ^= i), i >>= 1, i || (i = 128, o++);
										h += u
									}
									break;
								default:
									throw new k("operator ".concat(d, " is not supported"))
							}
						},
						onImmediateGenericRegion: function(t, r, n, i) {
							var o = t.info,
								a = new e(r, n, i),
								s = m(t.mmr, o.width, o.height, t.template, t.prediction, null, t.at, a);
							this.drawBitmap(o, s)
						},
						onImmediateLosslessGenericRegion: function() {
							this.onImmediateGenericRegion.apply(this, arguments)
						},
						onSymbolDictionary: function(t, r, n, i, o, a) {
							var s, c;
							t.huffman && (s = X(t, n, this.customTables), c = new K(i, o, a));
							var u = this.symbols;
							u || (this.symbols = u = {});
							for (var d = [], l = 0, f = n.length; l < f; l++) {
								var h = u[n[l]];
								h && (d = d.concat(h))
							}
							var p = new e(i, o, a);
							u[r] = v(t.huffman, t.refinement, d, t.numberOfNewSymbols, t.numberOfExportedSymbols, s, t.template, t.at, t.refinementTemplate, t.refinementAt, p, c)
						},
						onImmediateTextRegion: function(t, r, n, i, o) {
							for (var a, s, c = t.info, d = this.symbols, l = [], f = 0, h = r.length; f < h; f++) {
								var p = d[r[f]];
								p && (l = l.concat(p))
							}
							var m = u(l.length);
							t.huffman && (s = new K(n, i, o), a = U(t, r, this.customTables, l.length, s));
							var b = new e(n, i, o),
								g = S(t.huffman, t.refinement, c.width, c.height, t.defaultPixelValue, t.numberOfSymbolInstances, t.stripSize, l, m, t.transposed, t.dsOffset, t.referenceCorner, t.combinationOperator, a, t.refinementTemplate, t.refinementAt, b, t.logStripSize, s);
							this.drawBitmap(c, g)
						},
						onImmediateLosslessTextRegion: function() {
							this.onImmediateTextRegion.apply(this, arguments)
						},
						onPatternDictionary: function(t, r, n, i, o) {
							var a = this.patterns;
							a || (this.patterns = a = {});
							var s = new e(n, i, o);
							a[r] = w(t.mmr, t.patternWidth, t.patternHeight, t.maxPatternIndex, t.template, s)
						},
						onImmediateHalftoneRegion: function(t, r, n, i, o) {
							var a = this.patterns[r[0]],
								s = t.info,
								c = new e(n, i, o),
								u = C(t.mmr, a, t.template, s.width, s.height, t.defaultPixelValue, t.enableSkip, t.combinationOperator, t.gridWidth, t.gridHeight, t.gridOffsetX, t.gridOffsetY, t.gridVectorX, t.gridVectorY, c);
							this.drawBitmap(s, u)
						},
						onImmediateLosslessHalftoneRegion: function() {
							this.onImmediateHalftoneRegion.apply(this, arguments)
						},
						onTables: function(t, e, r, n) {
							var i = this.customTables;
							i || (this.customTables = i = {}), i[t] = B(e, r, n)
						}
					}, N.prototype = {
						buildTree: function(t, e) {
							var r = t.prefixCode >> e & 1;
							if (e <= 0) this.children[r] = new N(t);
							else {
								var n = this.children[r];
								n || (this.children[r] = n = new N(null)), n.buildTree(t, e - 1)
							}
						},
						decodeNode: function(t) {
							if (this.isLeaf) {
								if (this.isOOB) return null;
								var e = t.readBits(this.rangeLength);
								return this.rangeLow + (this.isLowerRange ? -e : e)
							}
							var r = this.children[t.readBit()];
							if (!r) throw new k("invalid Huffman data");
							return r.decodeNode(t)
						}
					}, M.prototype = {
						decode: function(t) {
							return this.rootNode.decodeNode(t)
						},
						assignPrefixCodes: function(t) {
							for (var e = t.length, r = 0, n = 0; n < e; n++) r = Math.max(r, t[n].prefixLength);
							for (var i = new Uint32Array(r + 1), o = 0; o < e; o++) i[t[o].prefixLength]++;
							var a, s, c, u = 1,
								d = 0;
							i[0] = 0;
							while (u <= r) {
								d = d + i[u - 1] << 1, a = d, s = 0;
								while (s < e) c = t[s], c.prefixLength === u && (c.prefixCode = a, a++), s++;
								u++
							}
						}
					};
					var F = {};

					function j(t) {
						var e, r = F[t];
						if (r) return r;
						switch (t) {
							case 1:
								e = [
									[0, 1, 4, 0],
									[16, 2, 8, 2],
									[272, 3, 16, 6],
									[65808, 3, 32, 7]
								];
								break;
							case 2:
								e = [
									[0, 1, 0, 0],
									[1, 2, 0, 2],
									[2, 3, 0, 6],
									[3, 4, 3, 14],
									[11, 5, 6, 30],
									[75, 6, 32, 62],
									[6, 63]
								];
								break;
							case 3:
								e = [
									[-256, 8, 8, 254],
									[0, 1, 0, 0],
									[1, 2, 0, 2],
									[2, 3, 0, 6],
									[3, 4, 3, 14],
									[11, 5, 6, 30],
									[-257, 8, 32, 255, "lower"],
									[75, 7, 32, 126],
									[6, 62]
								];
								break;
							case 4:
								e = [
									[1, 1, 0, 0],
									[2, 2, 0, 2],
									[3, 3, 0, 6],
									[4, 4, 3, 14],
									[12, 5, 6, 30],
									[76, 5, 32, 31]
								];
								break;
							case 5:
								e = [
									[-255, 7, 8, 126],
									[1, 1, 0, 0],
									[2, 2, 0, 2],
									[3, 3, 0, 6],
									[4, 4, 3, 14],
									[12, 5, 6, 30],
									[-256, 7, 32, 127, "lower"],
									[76, 6, 32, 62]
								];
								break;
							case 6:
								e = [
									[-2048, 5, 10, 28],
									[-1024, 4, 9, 8],
									[-512, 4, 8, 9],
									[-256, 4, 7, 10],
									[-128, 5, 6, 29],
									[-64, 5, 5, 30],
									[-32, 4, 5, 11],
									[0, 2, 7, 0],
									[128, 3, 7, 2],
									[256, 3, 8, 3],
									[512, 4, 9, 12],
									[1024, 4, 10, 13],
									[-2049, 6, 32, 62, "lower"],
									[2048, 6, 32, 63]
								];
								break;
							case 7:
								e = [
									[-1024, 4, 9, 8],
									[-512, 3, 8, 0],
									[-256, 4, 7, 9],
									[-128, 5, 6, 26],
									[-64, 5, 5, 27],
									[-32, 4, 5, 10],
									[0, 4, 5, 11],
									[32, 5, 5, 28],
									[64, 5, 6, 29],
									[128, 4, 7, 12],
									[256, 3, 8, 1],
									[512, 3, 9, 2],
									[1024, 3, 10, 3],
									[-1025, 5, 32, 30, "lower"],
									[2048, 5, 32, 31]
								];
								break;
							case 8:
								e = [
									[-15, 8, 3, 252],
									[-7, 9, 1, 508],
									[-5, 8, 1, 253],
									[-3, 9, 0, 509],
									[-2, 7, 0, 124],
									[-1, 4, 0, 10],
									[0, 2, 1, 0],
									[2, 5, 0, 26],
									[3, 6, 0, 58],
									[4, 3, 4, 4],
									[20, 6, 1, 59],
									[22, 4, 4, 11],
									[38, 4, 5, 12],
									[70, 5, 6, 27],
									[134, 5, 7, 28],
									[262, 6, 7, 60],
									[390, 7, 8, 125],
									[646, 6, 10, 61],
									[-16, 9, 32, 510, "lower"],
									[1670, 9, 32, 511],
									[2, 1]
								];
								break;
							case 9:
								e = [
									[-31, 8, 4, 252],
									[-15, 9, 2, 508],
									[-11, 8, 2, 253],
									[-7, 9, 1, 509],
									[-5, 7, 1, 124],
									[-3, 4, 1, 10],
									[-1, 3, 1, 2],
									[1, 3, 1, 3],
									[3, 5, 1, 26],
									[5, 6, 1, 58],
									[7, 3, 5, 4],
									[39, 6, 2, 59],
									[43, 4, 5, 11],
									[75, 4, 6, 12],
									[139, 5, 7, 27],
									[267, 5, 8, 28],
									[523, 6, 8, 60],
									[779, 7, 9, 125],
									[1291, 6, 11, 61],
									[-32, 9, 32, 510, "lower"],
									[3339, 9, 32, 511],
									[2, 0]
								];
								break;
							case 10:
								e = [
									[-21, 7, 4, 122],
									[-5, 8, 0, 252],
									[-4, 7, 0, 123],
									[-3, 5, 0, 24],
									[-2, 2, 2, 0],
									[2, 5, 0, 25],
									[3, 6, 0, 54],
									[4, 7, 0, 124],
									[5, 8, 0, 253],
									[6, 2, 6, 1],
									[70, 5, 5, 26],
									[102, 6, 5, 55],
									[134, 6, 6, 56],
									[198, 6, 7, 57],
									[326, 6, 8, 58],
									[582, 6, 9, 59],
									[1094, 6, 10, 60],
									[2118, 7, 11, 125],
									[-22, 8, 32, 254, "lower"],
									[4166, 8, 32, 255],
									[2, 2]
								];
								break;
							case 11:
								e = [
									[1, 1, 0, 0],
									[2, 2, 1, 2],
									[4, 4, 0, 12],
									[5, 4, 1, 13],
									[7, 5, 1, 28],
									[9, 5, 2, 29],
									[13, 6, 2, 60],
									[17, 7, 2, 122],
									[21, 7, 3, 123],
									[29, 7, 4, 124],
									[45, 7, 5, 125],
									[77, 7, 6, 126],
									[141, 7, 32, 127]
								];
								break;
							case 12:
								e = [
									[1, 1, 0, 0],
									[2, 2, 0, 2],
									[3, 3, 1, 6],
									[5, 5, 0, 28],
									[6, 5, 1, 29],
									[8, 6, 1, 60],
									[10, 7, 0, 122],
									[11, 7, 1, 123],
									[13, 7, 2, 124],
									[17, 7, 3, 125],
									[25, 7, 4, 126],
									[41, 8, 5, 254],
									[73, 8, 32, 255]
								];
								break;
							case 13:
								e = [
									[1, 1, 0, 0],
									[2, 3, 0, 4],
									[3, 4, 0, 12],
									[4, 5, 0, 28],
									[5, 4, 1, 13],
									[7, 3, 3, 5],
									[15, 6, 1, 58],
									[17, 6, 2, 59],
									[21, 6, 3, 60],
									[29, 6, 4, 61],
									[45, 6, 5, 62],
									[77, 7, 6, 126],
									[141, 7, 32, 127]
								];
								break;
							case 14:
								e = [
									[-2, 3, 0, 4],
									[-1, 3, 0, 5],
									[0, 1, 0, 0],
									[1, 3, 0, 6],
									[2, 3, 0, 7]
								];
								break;
							case 15:
								e = [
									[-24, 7, 4, 124],
									[-8, 6, 2, 60],
									[-4, 5, 1, 28],
									[-2, 4, 0, 12],
									[-1, 3, 0, 4],
									[0, 1, 0, 0],
									[1, 3, 0, 5],
									[2, 4, 0, 13],
									[3, 5, 1, 29],
									[5, 6, 2, 61],
									[9, 7, 4, 125],
									[-25, 7, 32, 126, "lower"],
									[25, 7, 32, 127]
								];
								break;
							default:
								throw new k("standard table B.".concat(t, " does not exist"))
						}
						for (var n = 0, i = e.length; n < i; n++) e[n] = new R(e[n]);
						return r = new M(e, !0), F[t] = r, r
					}

					function K(t, e, r) {
						this.data = t, this.start = e, this.end = r, this.position = e, this.shift = -1, this.currentByte = 0
					}

					function L(t, e, r) {
						for (var n = 0, i = 0, o = e.length; i < o; i++) {
							var a = r[e[i]];
							if (a) {
								if (t === n) return a;
								n++
							}
						}
						throw new k("can't find custom Huffman table")
					}

					function U(t, e, r, n, i) {
						for (var o = [], a = 0; a <= 34; a++) {
							var s = i.readBits(4);
							o.push(new R([a, s, 0, 0]))
						}
						var c = new M(o, !1);
						o.length = 0;
						for (var u = 0; u < n;) {
							var d = c.decode(i);
							if (d >= 32) {
								var l = void 0,
									f = void 0,
									h = void 0;
								switch (d) {
									case 32:
										if (0 === u) throw new k("no previous value in symbol ID table");
										f = i.readBits(2) + 3, l = o[u - 1].prefixLength;
										break;
									case 33:
										f = i.readBits(3) + 3, l = 0;
										break;
									case 34:
										f = i.readBits(7) + 11, l = 0;
										break;
									default:
										throw new k("invalid code length in symbol ID table")
								}
								for (h = 0; h < f; h++) o.push(new R([u, l, 0, 0])), u++
							} else o.push(new R([u, d, 0, 0])), u++
						}
						i.byteAlign();
						var p, m, b, g = new M(o, !1),
							y = 0;
						switch (t.huffmanFS) {
							case 0:
							case 1:
								p = j(t.huffmanFS + 6);
								break;
							case 3:
								p = L(y, e, r), y++;
								break;
							default:
								throw new k("invalid Huffman FS selector")
						}
						switch (t.huffmanDS) {
							case 0:
							case 1:
							case 2:
								m = j(t.huffmanDS + 8);
								break;
							case 3:
								m = L(y, e, r), y++;
								break;
							default:
								throw new k("invalid Huffman DS selector")
						}
						switch (t.huffmanDT) {
							case 0:
							case 1:
							case 2:
								b = j(t.huffmanDT + 11);
								break;
							case 3:
								b = L(y, e, r), y++;
								break;
							default:
								throw new k("invalid Huffman DT selector")
						}
						if (t.refinement) throw new k("refinement with Huffman is not supported");
						return {
							symbolIDTable: g,
							tableFirstS: p,
							tableDeltaS: m,
							tableDeltaT: b
						}
					}

					function X(t, e, r) {
						var n, i, o, a, s = 0;
						switch (t.huffmanDHSelector) {
							case 0:
							case 1:
								n = j(t.huffmanDHSelector + 4);
								break;
							case 3:
								n = L(s, e, r), s++;
								break;
							default:
								throw new k("invalid Huffman DH selector")
						}
						switch (t.huffmanDWSelector) {
							case 0:
							case 1:
								i = j(t.huffmanDWSelector + 2);
								break;
							case 3:
								i = L(s, e, r), s++;
								break;
							default:
								throw new k("invalid Huffman DW selector")
						}
						return t.bitmapSizeSelector ? (o = L(s, e, r), s++) : o = j(1), a = t.aggregationInstancesSelector ? L(s, e, r) : j(1), {
							tableDeltaHeight: n,
							tableDeltaWidth: i,
							tableBitmapSize: o,
							tableAggregateInstances: a
						}
					}

					function z(t, e, r) {
						for (var n = [], i = 0; i < r; i++) {
							var o = new Uint8Array(e);
							n.push(o);
							for (var a = 0; a < e; a++) o[a] = t.readBit();
							t.byteAlign()
						}
						return n
					}

					function G(t, e, r, n) {
						for (var i, o = {
							K: -1,
							Columns: e,
							Rows: r,
							BlackIs1: !0,
							EndOfBlock: n
						}, a = new y(t, o), s = [], c = !1, u = 0; u < r; u++) {
							var d = new Uint8Array(e);
							s.push(d);
							for (var l = -1, f = 0; f < e; f++) l < 0 && (i = a.readNextChar(), -1 === i && (i = 0, c = !0), l = 7), d[f] = i >> l & 1, l--
						}
						if (n && !c)
							for (var h = 5, p = 0; p < h; p++)
								if (-1 === a.readNextChar()) break;
						return s
					}

					function q() {}
					return K.prototype = {
						readBit: function() {
							if (this.shift < 0) {
								if (this.position >= this.end) throw new k("end of data while reading bit");
								this.currentByte = this.data[this.position++], this.shift = 7
							}
							var t = this.currentByte >> this.shift & 1;
							return this.shift--, t
						},
						readBits: function(t) {
							var e, r = 0;
							for (e = t - 1; e >= 0; e--) r |= this.readBit() << e;
							return r
						},
						byteAlign: function() {
							this.shift = -1
						},
						next: function() {
							return this.position >= this.end ? -1 : this.data[this.position++]
						}
					}, q.prototype = {
						parseChunks: function(t) {
							return P(t)
						},
						parse: function(t) {
							var e = D(t),
								r = e.imgData,
								n = e.width,
								i = e.height;
							return this.width = n, this.height = i, r
						}
					}, q
				}()
		},
		7418: function(t, e) {
			e.f = Object.getOwnPropertySymbols
		},
		"746f": function(t, e, r) {
			var n = r("428f"),
				i = r("1a2d"),
				o = r("e538"),
				a = r("9bf2")
				.f;
			t.exports = function(t) {
				var e = n.Symbol || (n.Symbol = {});
				i(e, t) || a(e, t, {
					value: o.f(t)
				})
			}
		},
		"74db": function(t, e, r) {
			"use strict";
			const n = r("5486"),
				i = r("8a24"),
				o = r("8a24"),
				a = r("90da")
				.buildOptions,
				s = r("adc3");
			e.parse = function(t, e, r) {
					if (r) {
						!0 === r && (r = {});
						const e = s.validate(t, r);
						if (!0 !== e) throw Error(e.err.msg)
					}
					e = a(e, o.defaultOptions, o.props);
					const c = i.getTraversalObj(t, e);
					return n.convertToJson(c, e)
				}, e.convertTonimn = r("8006")
				.convert2nimn, e.getTraversalObj = i.getTraversalObj, e.convertToJson = n.convertToJson, e.convertToJsonString = r("5a79")
				.convertToJsonString, e.validate = s.validate, e.j2xParser = r("cd38"), e.parseToNimn = function(t, r, n) {
					return e.convertTonimn(e.getTraversalObj(t, n), r, n)
				}
		},
		7839: function(t, e) {
			t.exports = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"]
		},
		"7a77": function(t, e, r) {
			"use strict";

			function n(t) {
				this.message = t
			}
			n.prototype.toString = function() {
				return "Cancel" + (this.message ? ": " + this.message : "")
			}, n.prototype.__CANCEL__ = !0, t.exports = n
		},
		"7aac": function(t, e, r) {
			"use strict";
			var n = r("c532");
			t.exports = n.isStandardBrowserEnv() ? function() {
				return {
					write: function(t, e, r, i, o, a) {
						var s = [];
						s.push(t + "=" + encodeURIComponent(e)), n.isNumber(r) && s.push("expires=" + new Date(r)
							.toGMTString()), n.isString(i) && s.push("path=" + i), n.isString(o) && s.push("domain=" + o), !0 === a && s.push("secure"), document.cookie = s.join("; ")
					},
					read: function(t) {
						var e = document.cookie.match(new RegExp("(^|;\\s*)(" + t + ")=([^;]*)"));
						return e ? decodeURIComponent(e[3]) : null
					},
					remove: function(t) {
						this.write(t, "", Date.now() - 864e5)
					}
				}
			}() : function() {
				return {
					write: function() {},
					read: function() {
						return null
					},
					remove: function() {}
				}
			}()
		},
		"7b0b": function(t, e, r) {
			var n = r("da84"),
				i = r("1d80"),
				o = n.Object;
			t.exports = function(t) {
				return o(i(t))
			}
		},
		"7c73": function(t, e, r) {
			var n, i = r("825a"),
				o = r("37e8"),
				a = r("7839"),
				s = r("d012"),
				c = r("1be4"),
				u = r("cc12"),
				d = r("f772"),
				l = ">",
				f = "<",
				h = "prototype",
				p = "script",
				m = d("IE_PROTO"),
				b = function() {},
				g = function(t) {
					return f + p + l + t + f + "/" + p + l
				},
				y = function(t) {
					t.write(g("")), t.close();
					var e = t.parentWindow.Object;
					return t = null, e
				},
				v = function() {
					var t, e = u("iframe"),
						r = "java" + p + ":";
					return e.style.display = "none", c.appendChild(e), e.src = String(r), t = e.contentWindow.document, t.open(), t.write(g("document.F=Object")), t.close(), t.F
				},
				S = function() {
					try {
						n = new ActiveXObject("htmlfile")
					} catch (e) {}
					S = "undefined" != typeof document ? document.domain && n ? y(n) : v() : y(n);
					var t = a.length;
					while (t--) delete S[h][a[t]];
					return S()
				};
			s[m] = !0, t.exports = Object.create || function(t, e) {
				var r;
				return null !== t ? (b[h] = i(t), r = new b, b[h] = null, r[m] = t) : r = S(), void 0 === e ? r : o.f(r, e)
			}
		},
		"7dd0": function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("c65b"),
				o = r("c430"),
				a = r("5e77"),
				s = r("1626"),
				c = r("9ed3"),
				u = r("e163"),
				d = r("d2bb"),
				l = r("d44e"),
				f = r("9112"),
				h = r("cb2d"),
				p = r("b622"),
				m = r("3f8c"),
				b = r("ae93"),
				g = a.PROPER,
				y = a.CONFIGURABLE,
				v = b.IteratorPrototype,
				S = b.BUGGY_SAFARI_ITERATORS,
				w = p("iterator"),
				C = "keys",
				_ = "values",
				A = "entries",
				I = function() {
					return this
				};
			t.exports = function(t, e, r, a, p, b, E) {
				c(r, e, a);
				var T, x, P, k = function(t) {
						if (t === p && M) return M;
						if (!S && t in R) return R[t];
						switch (t) {
							case C:
								return function() {
									return new r(this, t)
								};
							case _:
								return function() {
									return new r(this, t)
								};
							case A:
								return function() {
									return new r(this, t)
								}
						}
						return function() {
							return new r(this)
						}
					},
					D = e + " Iterator",
					O = !1,
					R = t.prototype,
					N = R[w] || R["@@iterator"] || p && R[p],
					M = !S && N || k(p),
					B = "Array" == e && R.entries || N;
				if (B && (T = u(B.call(new t)), T !== Object.prototype && T.next && (o || u(T) === v || (d ? d(T, v) : s(T[w]) || h(T, w, I)), l(T, D, !0, !0), o && (m[D] = I))), g && p == _ && N && N.name !== _ && (!o && y ? f(R, "name", _) : (O = !0, M = function() {
					return i(N, this)
				})), p)
					if (x = {
						values: k(_),
						keys: b ? M : k(C),
						entries: k(A)
					}, E)
						for (P in x)(S || O || !(P in R)) && h(R, P, x[P]);
					else n({
						target: e,
						proto: !0,
						forced: S || O
					}, x);
				return o && !E || R[w] === M || h(R, w, M, {
					name: p
				}), m[e] = M, x
			}
		},
		"7efc": function(t, e, r) {
			"use strict";
			r.d(e, "a", (function() {
				return l
			})), r.d(e, "b", (function() {
				return f
			})), r.d(e, "c", (function() {
				return h
			}));
			var n = r("6b33"),
				i = {
					parse: function(t) {
						var e = function(t, e, r, n) {
								i["B"];
								var o = i["T"],
									a = {
										cmap: o.cmap,
										head: o.head,
										hhea: o.hhea,
										maxp: o.maxp,
										hmtx: o.hmtx,
										name: o.name,
										"OS/2": o.OS2,
										post: o.post,
										loca: o.loca,
										kern: o.kern,
										glyf: o.glyf,
										"CFF ": o.CFF,
										CBLC: o.CBLC,
										CBDT: o.CBDT,
										"SVG ": o.SVG,
										COLR: o.colr,
										CPAL: o.cpal,
										sbix: o.sbix
									},
									s = {
										_data: t,
										_index: e,
										_offset: r
									};
								for (var c in a) {
									var u = i["findTable"](t, c, r);
									if (u) {
										var d = u[0],
											l = n[d];
										null == l && (l = a[c].parseTab(t, d, u[1], s)), s[c] = n[d] = l
									}
								}
								if (!s["head"]) {
									l = a["CFF "].parseTab(t, 0, t.length);
									s["CFF "] = l
								}
								return s
							},
							r = i["B"],
							n = new Uint8Array(t),
							o = {},
							a = r.readASCII(n, 0, 4);
						if ("ttcf" == a) {
							var s = 4;
							r.readUshort(n, s);
							s += 2;
							r.readUshort(n, s);
							s += 2;
							var c = r.readUint(n, s);
							s += 4;
							for (var u = [], d = 0; d < c; d++) {
								var l = r.readUint(n, s);
								s += 4, u.push(e(n, d, l, o))
							}
							return u
						}
						return [e(n, 0, 0, o)]
					},
					findTable: function(t, e, r) {
						for (var n = i["B"], o = n.readUshort(t, r + 4), a = r + 12, s = 0; s < o; s++) {
							var c = n.readASCII(t, a, 4),
								u = (n.readUint(t, a + 4), n.readUint(t, a + 8)),
								d = n.readUint(t, a + 12);
							if (c == e) return [u, d];
							a += 16
						}
						return null
					},
					T: {}
				};
			i["B"] = {
				readFixed: function(t, e) {
					return (t[e] << 8 | t[e + 1]) + (t[e + 2] << 8 | t[e + 3]) / 65540
				},
				readOffset: function(t, e, r) {
					for (var n = 0, i = 0; i < r; i++) n = n << 8 | t[e + i];
					return n
				},
				readF2dot14: function(t, e) {
					var r = i["B"].readShort(t, e);
					return r / 16384
				},
				readInt: function(t, e) {
					var r = i["B"].t.uint8;
					return r[0] = t[e + 3], r[1] = t[e + 2], r[2] = t[e + 1], r[3] = t[e], i["B"].t.int32[0]
				},
				readInt8: function(t, e) {
					var r = i["B"].t.uint8;
					return r[0] = t[e], i["B"].t.int8[0]
				},
				readUint8: function(t, e) {
					return t[e]
				},
				readShort: function(t, e) {
					var r = i["B"].t.uint16;
					return r[0] = t[e] << 8 | t[e + 1], i["B"].t.int16[0]
				},
				readUshort: function(t, e) {
					return t[e] << 8 | t[e + 1]
				},
				writeUshort: function(t, e, r) {
					t[e] = r >> 8 & 255, t[e + 1] = 255 & r
				},
				readUshorts: function(t, e, r) {
					for (var n = [], o = 0; o < r; o++) {
						var a = i["B"].readUshort(t, e + 2 * o);
						n.push(a)
					}
					return n
				},
				readUint: function(t, e) {
					var r = i["B"].t.uint8;
					return r[3] = t[e], r[2] = t[e + 1], r[1] = t[e + 2], r[0] = t[e + 3], i["B"].t.uint32[0]
				},
				writeUint: function(t, e, r) {
					t[e] = r >> 24 & 255, t[e + 1] = r >> 16 & 255, t[e + 2] = r >> 8 & 255, t[e + 3] = r >> 0 & 255
				},
				readUint64: function(t, e) {
					return 4294967296 * i["B"].readUint(t, e) + i["B"].readUint(t, e + 4)
				},
				readASCII: function(t, e, r) {
					for (var n = "", i = 0; i < r; i++) n += String.fromCharCode(t[e + i]);
					return n
				},
				writeASCII: function(t, e, r) {
					for (var n = 0; n < r.length; n++) t[e + n] = r.charCodeAt(n)
				},
				readUnicode: function(t, e, r) {
					for (var n = "", i = 0; i < r; i++) {
						var o = t[e++] << 8 | t[e++];
						n += String.fromCharCode(o)
					}
					return n
				},
				_tdec: window["TextDecoder"] ? new window["TextDecoder"] : null,
				readUTF8: function(t, e, r) {
					var n = i["B"]._tdec;
					return n && 0 == e && r == t.length ? n["decode"](t) : i["B"].readASCII(t, e, r)
				},
				readBytes: function(t, e, r) {
					for (var n = [], i = 0; i < r; i++) n.push(t[e + i]);
					return n
				},
				readASCIIArray: function(t, e, r) {
					for (var n = [], i = 0; i < r; i++) n.push(String.fromCharCode(t[e + i]));
					return n
				},
				t: function() {
					var t = new ArrayBuffer(8);
					return {
						buff: t,
						int8: new Int8Array(t),
						uint8: new Uint8Array(t),
						int16: new Int16Array(t),
						uint16: new Uint16Array(t),
						int32: new Int32Array(t),
						uint32: new Uint32Array(t)
					}
				}()
			}, i["T"].CFF = {
				parseTab: function(t, e, r) {
					var n = i["B"],
						o = i["T"].CFF;
					t = new Uint8Array(t.buffer, e, r), e = 0;
					t[e];
					e++;
					t[e];
					e++;
					t[e];
					e++;
					t[e];
					e++;
					var a = [];
					e = o.readIndex(t, e, a);
					for (var s = [], c = 0; c < a.length - 1; c++) s.push(n.readASCII(t, e + a[c], a[c + 1] - a[c]));
					e += a[a.length - 1];
					var u = [];
					e = o.readIndex(t, e, u);
					var d = [];
					for (c = 0; c < u.length - 1; c++) d.push(o.readDict(t, e + u[c], e + u[c + 1]));
					e += u[u.length - 1];
					var l = d[0],
						f = [];
					e = o.readIndex(t, e, f);
					var h = [];
					for (c = 0; c < f.length - 1; c++) h.push(n.readASCII(t, e + f[c], f[c + 1] - f[c]));
					if (e += f[f.length - 1], o.readSubrs(t, e, l), l["CharStrings"] && (l["CharStrings"] = o.readBytes(t, l["CharStrings"])), l["ROS"]) {
						e = l["FDArray"];
						var p = [];
						e = o.readIndex(t, e, p), l["FDArray"] = [];
						for (c = 0; c < p.length - 1; c++) {
							var m = o.readDict(t, e + p[c], e + p[c + 1]);
							o._readFDict(t, m, h), l["FDArray"].push(m)
						}
						e += p[p.length - 1], e = l["FDSelect"], l["FDSelect"] = [];
						var b = t[e];
						if (e++, 3 != b) throw b;
						var g = n.readUshort(t, e);
						e += 2;
						for (c = 0; c < g + 1; c++) l["FDSelect"].push(n.readUshort(t, e), t[e + 2]), e += 3
					}
					return l["charset"] && (l["charset"] = o.readCharset(t, l["charset"], l["CharStrings"].length)), o._readFDict(t, l, h), l
				},
				_readFDict: function(t, e, r) {
					var n, o = i["T"].CFF;
					for (var a in e["Private"] && (n = e["Private"][1], e["Private"] = o.readDict(t, n, n + e["Private"][0]), e["Private"]["Subrs"] && o.readSubrs(t, n + e["Private"]["Subrs"], e["Private"])), e) - 1 != ["FamilyName", "FontName", "FullName", "Notice", "version", "Copyright"].indexOf(a) && (e[a] = r[e[a] - 426 + 35])
				},
				readSubrs: function(t, e, r) {
					r["Subrs"] = i["T"].CFF.readBytes(t, e);
					var n, o = r["Subrs"].length + 1;
					n = o < 1240 ? 107 : o < 33900 ? 1131 : 32768, r["Bias"] = n
				},
				readBytes: function(t, e) {
					i["B"];
					var r = [];
					e = i["T"].CFF.readIndex(t, e, r);
					for (var n = [], o = r.length - 1, a = t.byteOffset + e, s = 0; s < o; s++) {
						var c = r[s];
						n.push(new Uint8Array(t.buffer, a + c, r[s + 1] - c))
					}
					return n
				},
				tableSE: [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 0, 111, 112, 113, 114, 0, 115, 116, 117, 118, 119, 120, 121, 122, 0, 123, 0, 124, 125, 126, 127, 128, 129, 130, 131, 0, 132, 133, 0, 134, 135, 136, 137, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 0, 139, 0, 0, 0, 0, 140, 141, 142, 143, 0, 0, 0, 0, 0, 144, 0, 0, 0, 145, 0, 0, 146, 147, 148, 149, 0, 0, 0, 0],
				glyphByUnicode: function(t, e) {
					for (var r = 0; r < t["charset"].length; r++)
						if (t["charset"][r] == e) return r;
					return -1
				},
				glyphBySE: function(t, e) {
					return e < 0 || e > 255 ? -1 : i["T"].CFF.glyphByUnicode(t, i["T"].CFF.tableSE[e])
				},
				readCharset: function(t, e, r) {
					var n = i["B"],
						o = [".notdef"],
						a = t[e];
					if (e++, 0 == a)
						for (var s = 0; s < r; s++) {
							var c = n.readUshort(t, e);
							e += 2, o.push(c)
						} else {
							if (1 != a && 2 != a) throw "error: format: " + a;
							while (o.length < r) {
								c = n.readUshort(t, e);
								e += 2;
								var u = 0;
								1 == a ? (u = t[e], e++) : (u = n.readUshort(t, e), e += 2);
								for (s = 0; s <= u; s++) o.push(c), c++
							}
						}
					return o
				},
				readIndex: function(t, e, r) {
					var n = i["B"],
						o = n.readUshort(t, e) + 1;
					e += 2;
					var a = t[e];
					if (e++, 1 == a)
						for (var s = 0; s < o; s++) r.push(t[e + s]);
					else if (2 == a)
						for (s = 0; s < o; s++) r.push(n.readUshort(t, e + 2 * s));
					else if (3 == a)
						for (s = 0; s < o; s++) r.push(16777215 & n.readUint(t, e + 3 * s - 1));
					else if (4 == a)
						for (s = 0; s < o; s++) r.push(n.readUint(t, e + 4 * s));
					else if (1 != o) throw "unsupported offset size: " + a + ", count: " + o;
					return e += o * a, e - 1
				},
				getCharString: function(t, e, r) {
					var n = i["B"],
						o = t[e],
						a = t[e + 1],
						s = (t[e + 2], t[e + 3], t[e + 4], 1),
						c = null,
						u = null;
					o <= 20 && (c = o, s = 1), 12 == o && (c = 100 * o + a, s = 2), 21 <= o && o <= 27 && (c = o, s = 1), 28 == o && (u = n.readShort(t, e + 1), s = 3), 29 <= o && o <= 31 && (c = o, s = 1), 32 <= o && o <= 246 && (u = o - 139, s = 1), 247 <= o && o <= 250 && (u = 256 * (o - 247) + a + 108, s = 2), 251 <= o && o <= 254 && (u = 256 * -(o - 251) - a - 108, s = 2), 255 == o && (u = n.readInt(t, e + 1) / 65535, s = 5), r.val = null != u ? u : "o" + c, r.size = s
				},
				readCharString: function(t, e, r) {
					var n = e + r,
						o = i["B"],
						a = [];
					while (e < n) {
						var s = t[e],
							c = t[e + 1],
							u = (t[e + 2], t[e + 3], t[e + 4], 1),
							d = null,
							l = null;
						s <= 20 && (d = s, u = 1), 12 == s && (d = 100 * s + c, u = 2), 19 != s && 20 != s || (d = s, u = 2), 21 <= s && s <= 27 && (d = s, u = 1), 28 == s && (l = o.readShort(t, e + 1), u = 3), 29 <= s && s <= 31 && (d = s, u = 1), 32 <= s && s <= 246 && (l = s - 139, u = 1), 247 <= s && s <= 250 && (l = 256 * (s - 247) + c + 108, u = 2), 251 <= s && s <= 254 && (l = 256 * -(s - 251) - c - 108, u = 2), 255 == s && (l = o.readInt(t, e + 1) / 65535, u = 5), a.push(null != l ? l : "o" + d), e += u
					}
					return a
				},
				readDict: function(t, e, r) {
					var n = i["B"],
						o = {},
						a = [];
					while (e < r) {
						var s = t[e],
							c = t[e + 1],
							u = (t[e + 2], t[e + 3], t[e + 4], 1),
							d = null,
							l = null;
						if (28 == s && (l = n.readShort(t, e + 1), u = 3), 29 == s && (l = n.readInt(t, e + 1), u = 5), 32 <= s && s <= 246 && (l = s - 139, u = 1), 247 <= s && s <= 250 && (l = 256 * (s - 247) + c + 108, u = 2), 251 <= s && s <= 254 && (l = 256 * -(s - 251) - c - 108, u = 2), 255 == s) throw l = n.readInt(t, e + 1) / 65535, u = 5, "unknown number";
						if (30 == s) {
							var f = [];
							u = 1;
							while (1) {
								var h = t[e + u];
								u++;
								var p = h >> 4,
									m = 15 & h;
								if (15 != p && f.push(p), 15 != m && f.push(m), 15 == m) break
							}
							for (var b = "", g = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, ".", "e", "e-", "reserved", "-", "endOfNumber"], y = 0; y < f.length; y++) b += g[f[y]];
							l = parseFloat(b)
						}
						if (s <= 21) {
							var v = ["version", "Notice", "FullName", "FamilyName", "Weight", "FontBBox", "BlueValues", "OtherBlues", "FamilyBlues", "FamilyOtherBlues", "StdHW", "StdVW", "escape", "UniqueID", "XUID", "charset", "Encoding", "CharStrings", "Private", "Subrs", "defaultWidthX", "nominalWidthX"];
							if (d = v[s], u = 1, 12 == s) {
								v = ["Copyright", "isFixedPitch", "ItalicAngle", "UnderlinePosition", "UnderlineThickness", "PaintType", "CharstringType", "FontMatrix", "StrokeWidth", "BlueScale", "BlueShift", "BlueFuzz", "StemSnapH", "StemSnapV", "ForceBold", "", "", "LanguageGroup", "ExpansionFactor", "initialRandomSeed", "SyntheticBase", "PostScript", "BaseFontName", "BaseFontBlend", "", "", "", "", "", "", "ROS", "CIDFontVersion", "CIDFontRevision", "CIDFontType", "CIDCount", "UIDBase", "FDArray", "FDSelect", "FontName"];
								d = v[c], u = 2
							}
						}
						null != d ? (o[d] = 1 == a.length ? a[0] : a, a = []) : a.push(l), e += u
					}
					return o
				}
			}, i["T"].cmap = {
				parseTab: function(t, e, r) {
					var n = {
						tables: [],
						ids: {},
						off: e
					};
					t = new Uint8Array(t.buffer, e, r), e = 0;
					var o = i["B"],
						a = o.readUshort,
						s = i["T"].cmap;
					a(t, e);
					e += 2;
					var c = a(t, e);
					e += 2;
					for (var u = [], d = 0; d < c; d++) {
						var l = a(t, e);
						e += 2;
						var f = a(t, e);
						e += 2;
						var h = o.readUint(t, e);
						e += 4;
						var p = "p" + l + "e" + f,
							m = u.indexOf(h);
						if (-1 == m) {
							m = n.tables.length;
							var b = {};
							u.push(h);
							var g = b.format = a(t, h);
							0 == g ? b = s.parse0(t, h, b) : 4 == g ? b = s.parse4(t, h, b) : 6 == g ? b = s.parse6(t, h, b) : 12 == g && (b = s.parse12(t, h, b)), n.tables.push(b)
						}
						null != n.ids[p] && console.log("multiple tables for one platform+encoding: " + p), n.ids[p] = m
					}
					return n
				},
				parse0: function(t, e, r) {
					var n = i["B"];
					e += 2;
					var o = n.readUshort(t, e);
					e += 2;
					n.readUshort(t, e);
					e += 2, r.map = [];
					for (var a = 0; a < o - 6; a++) r.map.push(t[e + a]);
					return r
				},
				parse4: function(t, e, r) {
					var n = i["B"],
						o = n.readUshort,
						a = n.readUshorts,
						s = e;
					e += 2;
					var c = o(t, e);
					e += 2;
					o(t, e);
					e += 2;
					var u = o(t, e);
					e += 2;
					var d = u >>> 1;
					r.searchRange = o(t, e), e += 2, r.entrySelector = o(t, e), e += 2, r.rangeShift = o(t, e), e += 2, r.endCount = a(t, e, d), e += 2 * d, e += 2, r.startCount = a(t, e, d), e += 2 * d, r.idDelta = [];
					for (var l = 0; l < d; l++) r.idDelta.push(n.readShort(t, e)), e += 2;
					return r.idRangeOffset = a(t, e, d), e += 2 * d, r.glyphIdArray = a(t, e, s + c - e >>> 1), r
				},
				parse6: function(t, e, r) {
					var n = i["B"];
					e += 2;
					n.readUshort(t, e);
					e += 2;
					n.readUshort(t, e);
					e += 2, r.firstCode = n.readUshort(t, e), e += 2;
					var o = n.readUshort(t, e);
					e += 2, r.glyphIdArray = [];
					for (var a = 0; a < o; a++) r.glyphIdArray.push(n.readUshort(t, e)), e += 2;
					return r
				},
				parse12: function(t, e, r) {
					var n = i["B"],
						o = n.readUint;
					e += 4;
					o(t, e);
					e += 4;
					o(t, e);
					e += 4;
					var a = 3 * o(t, e);
					e += 4;
					for (var s = r.groups = new Uint32Array(a), c = 0; c < a; c += 3) s[c] = o(t, e + (c << 2)), s[c + 1] = o(t, e + (c << 2) + 4), s[c + 2] = o(t, e + (c << 2) + 8);
					return r
				}
			}, i["T"].CBLC = {
				parseTab: function(t, e, r) {
					var n = i["B"],
						o = e;
					n.readUshort(t, e);
					e += 2;
					n.readUshort(t, e);
					e += 2;
					var a = n.readUint(t, e);
					e += 4;
					for (var s = [], c = 0; c < a; c++) {
						var u = n.readUint(t, e);
						e += 4;
						n.readUint(t, e);
						e += 4;
						n.readUint(t, e);
						e += 4, e += 4, e += 24;
						n.readUshort(t, e);
						e += 2;
						n.readUshort(t, e);
						e += 2, e += 4;
						for (var d = o + u, l = 0; l < 3; l++) {
							var f = n.readUshort(t, d);
							d += 2;
							var h = n.readUshort(t, d);
							d += 2;
							var p = n.readUint(t, d);
							d += 4;
							var m = h - f + 1,
								b = o + u + p,
								g = n.readUshort(t, b);
							if (b += 2, 1 != g) throw g;
							var y = n.readUshort(t, b);
							b += 2;
							var v = n.readUint(t, b);
							b += 4;
							for (var S = [], w = 0; w < m; w++) {
								var C = n.readUint(t, b + 4 * w);
								S.push(v + C)
							}
							s.push([f, h, y, S])
						}
					}
					return s
				}
			}, i["T"].CBDT = {
				parseTab: function(t, e, r) {
					i["B"];
					return new Uint8Array(t.buffer, t.byteOffset + e, r)
				}
			}, i["T"].glyf = {
				parseTab: function(t, e, r, n) {
					for (var i = [], o = n["maxp"]["numGlyphs"], a = 0; a < o; a++) i.push(null);
					return i
				},
				_parseGlyf: function(t, e) {
					var r = i["B"],
						n = t["_data"],
						o = t["loca"];
					if (o[e] == o[e + 1]) return null;
					var a = i["findTable"](n, "glyf", t["_offset"])[0] + o[e],
						s = {};
					if (s.noc = r.readShort(n, a), a += 2, s.xMin = r.readShort(n, a), a += 2, s.yMin = r.readShort(n, a), a += 2, s.xMax = r.readShort(n, a), a += 2, s.yMax = r.readShort(n, a), a += 2, s.xMin >= s.xMax || s.yMin >= s.yMax) return null;
					if (s.noc > 0) {
						s.endPts = [];
						for (var c = 0; c < s.noc; c++) s.endPts.push(r.readUshort(n, a)), a += 2;
						var u = r.readUshort(n, a);
						if (a += 2, n.length - a < u) return null;
						s.instructions = r.readBytes(n, a, u), a += u;
						var d = s.endPts[s.noc - 1] + 1;
						s.flags = [];
						for (c = 0; c < d; c++) {
							var l = n[a];
							if (a++, s.flags.push(l), 0 != (8 & l)) {
								var f = n[a];
								a++;
								for (var h = 0; h < f; h++) s.flags.push(l), c++
							}
						}
						s.xs = [];
						for (c = 0; c < d; c++) {
							var p = 0 != (2 & s.flags[c]),
								m = 0 != (16 & s.flags[c]);
							p ? (s.xs.push(m ? n[a] : -n[a]), a++) : m ? s.xs.push(0) : (s.xs.push(r.readShort(n, a)), a += 2)
						}
						s.ys = [];
						for (c = 0; c < d; c++) {
							p = 0 != (4 & s.flags[c]), m = 0 != (32 & s.flags[c]);
							p ? (s.ys.push(m ? n[a] : -n[a]), a++) : m ? s.ys.push(0) : (s.ys.push(r.readShort(n, a)), a += 2)
						}
						var b = 0,
							g = 0;
						for (c = 0; c < d; c++) b += s.xs[c], g += s.ys[c], s.xs[c] = b, s.ys[c] = g
					} else {
						var y, v = 1,
							S = 2,
							w = 8,
							C = 32,
							_ = 64,
							A = 128,
							I = 256;
						s.parts = [];
						do {
							y = r.readUshort(n, a), a += 2;
							var E = {
								m: {
									a: 1,
									b: 0,
									c: 0,
									d: 1,
									tx: 0,
									ty: 0
								},
								p1: -1,
								p2: -1
							};
							if (s.parts.push(E), E.glyphIndex = r.readUshort(n, a), a += 2, y & v) {
								var T = r.readShort(n, a);
								a += 2;
								var x = r.readShort(n, a);
								a += 2
							} else {
								T = r.readInt8(n, a);
								a++;
								x = r.readInt8(n, a);
								a++
							}
							y & S ? (E.m.tx = T, E.m.ty = x) : (E.p1 = T, E.p2 = x), y & w ? (E.m.a = E.m.d = r.readF2dot14(n, a), a += 2) : y & _ ? (E.m.a = r.readF2dot14(n, a), a += 2, E.m.d = r.readF2dot14(n, a), a += 2) : y & A && (E.m.a = r.readF2dot14(n, a), a += 2, E.m.b = r.readF2dot14(n, a), a += 2, E.m.c = r.readF2dot14(n, a), a += 2, E.m.d = r.readF2dot14(n, a), a += 2)
						} while (y & C);
						if (y & I) {
							var P = r.readUshort(n, a);
							a += 2, s.instr = [];
							for (c = 0; c < P; c++) s.instr.push(n[a]), a++
						}
					}
					return s
				},
				_parseGlyf2: function(t, e) {
					var r = i["B"],
						n = t["_data"],
						o = 0;
					r.readASCII(n, 0, 4);
					o += 4;
					for (var a = function(t) {
						var e = r.readShort(t, o);
						if (o += 2, 0 === e) return null;
						var n = new ArrayBuffer(e + 1),
							i = r.readBytes(t, o, 1)[0];
						o += 1;
						for (var a = 0; a <= e; a++) {
							var s = r.readOffset(t, o, i);
							if (o += i, s > t.length) throw "illegal offset value " + s + " in CFF font";
							n[a] = s
						}
						var c = new ArrayBuffer(e);
						for (a = 0; a < e; a++) {
							var u = n[a + 1] - n[a];
							if (u < 0) throw "Negative index data length + " + u + " at " + a + ": offsets[" + (a + 1) + "]=" + n[a + 1] + ", offsets[" + a + "]=" + n[a];
							c[a] = r.readASCII(t, o, u), o += u
						}
						return c
					}, s = function(t) {
						var e = r.readShort(t, o);
						if (o += 2, 0 === e) return null;
						var n = new ArrayBuffer(e + 1),
							i = r.readBytes(t, o, 1)[0];
						o += 1;
						for (var a = 0; a <= e; a++) {
							var s = r.readOffset(t, o, i);
							if (o += i, s > t.length) throw "illegal offset value " + s + " in CFF font";
							n[a] = s
						}
						var c = new ArrayBuffer(e);
						for (a = 0; a < e; a++) {
							var u = n[a + 1] - n[a];
							c[a] = r.readBytes(t, o, u), o += u
						}
						return c
					}, c = a(n), u = s(n), d = (a(n), s(n), function(t) {
						for (var e, n = 0, i = t.length, o = 0; o <= i; o++) {
							var a = new ArrayBuffer(3),
								s = 0;
							while (1) {
								var c = r.readUint8(t, n);
								if (n += 1, c >= 0 && c <= 21) {
									if (12 == c) {
										c = r.readUint8(t, n);
										n += 1
									}
									var u = ["version", "Notice", "FullName", "FamilyName", "Weight", "FontBBox", "BlueValues", "OtherBlues", "FamilyBlues", "FamilyOtherBl", "StdHW", "StdVW", "", "UniqueID", "XUID", "charset", "Encoding", "CharStrings", "Private", "Subrs", "defaultWidthX", "nominalWidthX"];
									u[c];
									break
								}
								if (28 == c || 29 == c || c >= 32 && c <= 254) {
									var d;
									if (28 == c) d = r.readShort(t, n), n += 2;
									else if (29 == c) d = r.readInt(t, n), n += 4;
									else if (c >= 32 && c <= 246) d = c - 139;
									else if (c >= 247 && c <= 250) {
										var l = r.readUint8(t, n);
										n += 1, d = 256 * (c - 247) + l + 108
									} else {
										if (!(c >= 251 && c <= 254)) throw "IllegalArgumentExceptionnew";
										l = r.readUint8(t, n);
										n += 1, d = 256 * -(c - 251) - l - 108
									}
									a[s] = d, s += 1
								} else if (30 != c) throw "invalid DICT data b0 byte: " + c
							}
						}
						return e
					}), l = (new ArrayBuffer(c.byteLength), 0); l <= c.byteLength; l++) d(u[l]);
					var f = {};
					if (f.noc = r.readShort(n, o), o += 2, f.xMin = r.readShort(n, o), o += 2, f.yMin = r.readShort(n, o), o += 2, f.xMax = r.readShort(n, o), o += 2, f.yMax = r.readShort(n, o), o += 2, f.noc > 0) {
						f.endPts = [];
						for (l = 0; l < f.noc; l++) f.endPts.push(r.readUshort(n, o)), o += 2;
						var h = r.readUshort(n, o);
						if (o += 2, n.length - o < h) return null;
						f.instructions = r.readBytes(n, o, h), o += h;
						var p = f.endPts[f.noc - 1] + 1;
						f.flags = [];
						for (l = 0; l < p; l++) {
							var m = n[o];
							if (o++, f.flags.push(m), 0 != (8 & m)) {
								var b = n[o];
								o++;
								for (var g = 0; g < b; g++) f.flags.push(m), l++
							}
						}
						f.xs = [];
						for (l = 0; l < p; l++) {
							var y = 0 != (2 & f.flags[l]),
								v = 0 != (16 & f.flags[l]);
							y ? (f.xs.push(v ? n[o] : -n[o]), o++) : v ? f.xs.push(0) : (f.xs.push(r.readShort(n, o)), o += 2)
						}
						f.ys = [];
						for (l = 0; l < p; l++) {
							y = 0 != (4 & f.flags[l]), v = 0 != (32 & f.flags[l]);
							y ? (f.ys.push(v ? n[o] : -n[o]), o++) : v ? f.ys.push(0) : (f.ys.push(r.readShort(n, o)), o += 2)
						}
						var S = 0,
							w = 0;
						for (l = 0; l < p; l++) S += f.xs[l], w += f.ys[l], f.xs[l] = S, f.ys[l] = w
					} else {
						var C, _ = 1,
							A = 2,
							I = 8,
							E = 32,
							T = 64,
							x = 128,
							P = 256;
						f.parts = [];
						do {
							C = r.readUshort(n, o), o += 2;
							var k = {
								m: {
									a: 1,
									b: 0,
									c: 0,
									d: 1,
									tx: 0,
									ty: 0
								},
								p1: -1,
								p2: -1
							};
							if (f.parts.push(k), k.glyphIndex = r.readUshort(n, o), o += 2, C & _) {
								var D = r.readShort(n, o);
								o += 2;
								var O = r.readShort(n, o);
								o += 2
							} else {
								D = r.readInt8(n, o);
								o++;
								O = r.readInt8(n, o);
								o++
							}
							C & A ? (k.m.tx = D, k.m.ty = O) : (k.p1 = D, k.p2 = O), C & I ? (k.m.a = k.m.d = r.readF2dot14(n, o), o += 2) : C & T ? (k.m.a = r.readF2dot14(n, o), o += 2, k.m.d = r.readF2dot14(n, o), o += 2) : C & x && (k.m.a = r.readF2dot14(n, o), o += 2, k.m.b = r.readF2dot14(n, o), o += 2, k.m.c = r.readF2dot14(n, o), o += 2, k.m.d = r.readF2dot14(n, o), o += 2)
						} while (C & E);
						if (C & P) {
							var R = r.readUshort(n, o);
							o += 2, f.instr = [];
							for (l = 0; l < R; l++) f.instr.push(n[o]), o++
						}
					}
					return f
				}
			}, i["T"].head = {
				parseTab: function(t, e, r) {
					var n = i["B"],
						o = {};
					n.readFixed(t, e);
					e += 4, o["fontRevision"] = n.readFixed(t, e), e += 4;
					n.readUint(t, e);
					e += 4;
					n.readUint(t, e);
					return e += 4, o["flags"] = n.readUshort(t, e), e += 2, o["unitsPerEm"] = n.readUshort(t, e), e += 2, o["created"] = n.readUint64(t, e), e += 8, o["modified"] = n.readUint64(t, e), e += 8, o["xMin"] = n.readShort(t, e), e += 2, o["yMin"] = n.readShort(t, e), e += 2, o["xMax"] = n.readShort(t, e), e += 2, o["yMax"] = n.readShort(t, e), e += 2, o["macStyle"] = n.readUshort(t, e), e += 2, o["lowestRecPPEM"] = n.readUshort(t, e), e += 2, o["fontDirectionHint"] = n.readShort(t, e), e += 2, o["indexToLocFormat"] = n.readShort(t, e), e += 2, o["glyphDataFormat"] = n.readShort(t, e), e += 2, o
				}
			}, i["T"].hhea = {
				parseTab: function(t, e, r) {
					var n = i["B"],
						o = {};
					n.readFixed(t, e);
					e += 4;
					for (var a = ["ascender", "descender", "lineGap", "advanceWidthMax", "minLeftSideBearing", "minRightSideBearing", "xMaxExtent", "caretSlopeRise", "caretSlopeRun", "caretOffset", "res0", "res1", "res2", "res3", "metricDataFormat", "numberOfHMetrics"], s = 0; s < a.length; s++) {
						var c = a[s],
							u = "advanceWidthMax" == c || "numberOfHMetrics" == c ? n.readUshort : n.readShort;
						o[c] = u(t, e + 2 * s)
					}
					return o
				}
			}, i["T"].hmtx = {
				parseTab: function(t, e, r, n) {
					var o = i["B"],
						a = [],
						s = [],
						c = n["maxp"]["numGlyphs"],
						u = n["hhea"]["numberOfHMetrics"],
						d = 0,
						l = 0,
						f = 0;
					while (f < u) d = o.readUshort(t, e + (f << 2)), l = o.readShort(t, e + (f << 2) + 2), a.push(d), s.push(l), f++;
					while (f < c) a.push(d), s.push(l), f++;
					return {
						aWidth: a,
						lsBearing: s
					}
				}
			}, i["T"].kern = {
				parseTab: function(t, e, r, n) {
					var o = i["B"],
						a = i["T"].kern,
						s = o.readUshort(t, e);
					if (1 == s) return a.parseV1(t, e, r, n);
					var c = o.readUshort(t, e + 2);
					e += 4;
					for (var u = {
						glyph1: [],
						rval: []
					}, d = 0; d < c; d++) {
						e += 2;
						r = o.readUshort(t, e);
						e += 2;
						var l = o.readUshort(t, e);
						e += 2;
						var f = l >>> 8;
						f &= 15, 0 == f && (e = a.readFormat0(t, e, u))
					}
					return u
				},
				parseV1: function(t, e, r, n) {
					var o = i["B"],
						a = i["T"].kern,
						s = (o.readFixed(t, e), o.readUint(t, e + 4));
					e += 8;
					for (var c = {
						glyph1: [],
						rval: []
					}, u = 0; u < s; u++) {
						o.readUint(t, e);
						e += 4;
						var d = o.readUshort(t, e);
						e += 2;
						o.readUshort(t, e);
						e += 2;
						var l = 255 & d;
						0 == l && (e = a.readFormat0(t, e, c))
					}
					return c
				},
				readFormat0: function(t, e, r) {
					var n = i["B"],
						o = n.readUshort,
						a = -1,
						s = o(t, e);
					o(t, e + 2), o(t, e + 4), o(t, e + 6);
					e += 8;
					for (var c = 0; c < s; c++) {
						var u = o(t, e);
						e += 2;
						var d = o(t, e);
						e += 2;
						var l = n.readShort(t, e);
						e += 2, u != a && (r.glyph1.push(u), r.rval.push({
							glyph2: [],
							vals: []
						}));
						var f = r.rval[r.rval.length - 1];
						f.glyph2.push(d), f.vals.push(l), a = u
					}
					return e
				}
			}, i["T"].loca = {
				parseTab: function(t, e, r, n) {
					var o = i["B"],
						a = [],
						s = n["head"]["indexToLocFormat"],
						c = n["maxp"]["numGlyphs"] + 1;
					if (0 == s)
						for (var u = 0; u < c; u++) a.push(o.readUshort(t, e + (u << 1)) << 1);
					if (1 == s)
						for (u = 0; u < c; u++) a.push(o.readUint(t, e + (u << 2)));
					return a
				}
			}, i["T"].maxp = {
				parseTab: function(t, e, r) {
					var n = i["B"],
						o = n.readUshort,
						a = {};
					n.readUint(t, e);
					return e += 4, a["numGlyphs"] = o(t, e), e += 2, a
				}
			}, i["T"].name = {
				parseTab: function(t, e, r) {
					var n = i["B"],
						o = {};
					n.readUshort(t, e);
					e += 2;
					var a = n.readUshort(t, e);
					e += 2;
					n.readUshort(t, e);
					e += 2;
					for (var s = ["copyright", "fontFamily", "fontSubfamily", "ID", "fullName", "version", "postScriptName", "trademark", "manufacturer", "designer", "description", "urlVendor", "urlDesigner", "licence", "licenceURL", "---", "typoFamilyName", "typoSubfamilyName", "compatibleFull", "sampleText", "postScriptCID", "wwsFamilyName", "wwsSubfamilyName", "lightPalette", "darkPalette"], c = e, u = n.readUshort, d = 0; d < a; d++) {
						var l = u(t, e);
						e += 2;
						var f = u(t, e);
						e += 2;
						var h = u(t, e);
						e += 2;
						var p = u(t, e);
						e += 2;
						var m = u(t, e);
						e += 2;
						var b = u(t, e);
						e += 2;
						var g, y = c + 12 * a + b;
						0 == l || 3 == l && 0 == f || 1 == l && 25 == f ? g = n.readUnicode(t, y, m / 2) : 0 == f ? g = n.readASCII(t, y, m) : 1 == f || 3 == f || 4 == f || 5 == f || 10 == f ? g = n.readUnicode(t, y, m / 2) : 1 == l ? (g = n.readASCII(t, y, m), console.log("reading unknown MAC encoding " + f + " as ASCII")) : (console.log("unknown encoding " + f + ", platformID: " + l), g = n.readASCII(t, y, m));
						var v = "p" + l + "," + h.toString(16);
						null == o[v] && (o[v] = {}), o[v][s[p]] = g, o[v]["_lang"] = h
					}
					var S = i["T"].name.selectOne(o),
						w = "fontFamily";
					if (null == S[w])
						for (var C in o) null != o[C][w] && (S[w] = o[C][w]);
					return S
				},
				selectOne: function(t) {
					var e, r = "postScriptName";
					for (var n in t)
						if (null != t[n][r] && 1033 == t[n]["_lang"]) return t[n];
					for (var n in t)
						if (null != t[n][r] && 0 == t[n]["_lang"]) return t[n];
					for (var n in t)
						if (null != t[n][r] && 3084 == t[n]["_lang"]) return t[n];
					for (var n in t)
						if (null != t[n][r]) return t[n];
					for (var n in t) {
						e = t[n];
						break
					}
					return console.log("returning name table with languageID " + e._lang), null == e[r] && null != e["ID"] && (e[r] = e["ID"]), e
				}
			}, i["T"].OS2 = {
				parseTab: function(t, e, r) {
					var n = i["B"],
						o = n.readUshort(t, e);
					e += 2;
					var a = i["T"].OS2,
						s = {};
					if (0 == o) a.version0(t, e, s);
					else if (1 == o) a.version1(t, e, s);
					else if (2 == o || 3 == o || 4 == o) a.version2(t, e, s);
					else {
						if (5 != o) throw "unknown OS/2 table version: " + o;
						a.version5(t, e, s)
					}
					return s
				},
				version0: function(t, e, r) {
					var n = i["B"];
					return r["xAvgCharWidth"] = n.readShort(t, e), e += 2, r["usWeightClass"] = n.readUshort(t, e), e += 2, r["usWidthClass"] = n.readUshort(t, e), e += 2, r["fsType"] = n.readUshort(t, e), e += 2, r["ySubscriptXSize"] = n.readShort(t, e), e += 2, r["ySubscriptYSize"] = n.readShort(t, e), e += 2, r["ySubscriptXOffset"] = n.readShort(t, e), e += 2, r["ySubscriptYOffset"] = n.readShort(t, e), e += 2, r["ySuperscriptXSize"] = n.readShort(t, e), e += 2, r["ySuperscriptYSize"] = n.readShort(t, e), e += 2, r["ySuperscriptXOffset"] = n.readShort(t, e), e += 2, r["ySuperscriptYOffset"] = n.readShort(t, e), e += 2, r["yStrikeoutSize"] = n.readShort(t, e), e += 2, r["yStrikeoutPosition"] = n.readShort(t, e), e += 2, r["sFamilyClass"] = n.readShort(t, e), e += 2, r["panose"] = n.readBytes(t, e, 10), e += 10, r["ulUnicodeRange1"] = n.readUint(t, e), e += 4, r["ulUnicodeRange2"] = n.readUint(t, e), e += 4, r["ulUnicodeRange3"] = n.readUint(t, e), e += 4, r["ulUnicodeRange4"] = n.readUint(t, e), e += 4, r["achVendID"] = n.readASCII(t, e, 4), e += 4, r["fsSelection"] = n.readUshort(t, e), e += 2, r["usFirstCharIndex"] = n.readUshort(t, e), e += 2, r["usLastCharIndex"] = n.readUshort(t, e), e += 2, r["sTypoAscender"] = n.readShort(t, e), e += 2, r["sTypoDescender"] = n.readShort(t, e), e += 2, r["sTypoLineGap"] = n.readShort(t, e), e += 2, r["usWinAscent"] = n.readUshort(t, e), e += 2, r["usWinDescent"] = n.readUshort(t, e), e += 2, e
				},
				version1: function(t, e, r) {
					var n = i["B"];
					return e = i["T"].OS2.version0(t, e, r), r["ulCodePageRange1"] = n.readUint(t, e), e += 4, r["ulCodePageRange2"] = n.readUint(t, e), e += 4, e
				},
				version2: function(t, e, r) {
					var n = i["B"],
						o = n.readUshort;
					return e = i["T"].OS2.version1(t, e, r), r["sxHeight"] = n.readShort(t, e), e += 2, r["sCapHeight"] = n.readShort(t, e), e += 2, r["usDefault"] = o(t, e), e += 2, r["usBreak"] = o(t, e), e += 2, r["usMaxContext"] = o(t, e), e += 2, e
				},
				version5: function(t, e, r) {
					var n = i["B"].readUshort;
					return e = i["T"].OS2.version2(t, e, r), r["usLowerOpticalPointSize"] = n(t, e), e += 2, r["usUpperOpticalPointSize"] = n(t, e), e += 2, e
				}
			}, i["T"].post = {
				parseTab: function(t, e, r) {
					var n = i["B"],
						o = {};
					return o["version"] = n.readFixed(t, e), e += 4, o["italicAngle"] = n.readFixed(t, e), e += 4, o["underlinePosition"] = n.readShort(t, e), e += 2, o["underlineThickness"] = n.readShort(t, e), e += 2, o
				}
			}, i["T"].SVG = {
				parseTab: function(t, e, r) {
					var n = i["B"],
						o = {
							entries: []
						},
						a = e;
					n.readUshort(t, e);
					e += 2;
					var s = n.readUint(t, e);
					e += 4;
					n.readUint(t, e);
					e += 4, e = s + a;
					var c = n.readUshort(t, e);
					e += 2;
					for (var u = 0; u < c; u++) {
						var d = n.readUshort(t, e);
						e += 2;
						var l = n.readUshort(t, e);
						e += 2;
						var f = n.readUint(t, e);
						e += 4;
						var h = n.readUint(t, e);
						e += 4;
						var p = new Uint8Array(t.buffer, a + f + s, h);
						31 == p[0] && 139 == p[1] && 8 == p[2] && (p = pako["inflate"](p));
						for (var m = n.readUTF8(p, 0, p.length), b = d; b <= l; b++) o.entries[b] = m
					}
					return o
				}
			}, i["T"].sbix = {
				parseTab: function(t, e, r, n) {
					for (var o = n["maxp"]["numGlyphs"], a = e, s = i["B"], c = s.readUint(t, e + 4), u = [], d = c - 1; d < c; d++)
						for (var l = a + s.readUint(t, e + 8 + 4 * d), f = 0; f < o; f++) {
							var h = s.readUint(t, l + 4 + 4 * f),
								p = s.readUint(t, l + 4 + 4 * f + 4);
							if (h != p) {
								var m = l + h,
									b = s.readASCII(t, m + 4, 4);
								if ("png " != b) throw b;
								u[f] = new Uint8Array(t.buffer, t.byteOffset + m + 8, p - h - 8)
							} else u[f] = null
						}
					return u
				}
			}, i["T"].colr = {
				parseTab: function(t, e, r) {
					var n = i["B"],
						o = e;
					e += 2;
					var a = n.readUshort(t, e);
					e += 2;
					var s = n.readUint(t, e);
					e += 4;
					var c = n.readUint(t, e);
					e += 4;
					var u = n.readUshort(t, e);
					e += 2;
					for (var d = {}, l = o + s, f = 0; f < a; f++) d["g" + n.readUshort(t, l)] = [n.readUshort(t, l + 2), n.readUshort(t, l + 4)], l += 6;
					var h = [];
					l = o + c;
					for (f = 0; f < u; f++) h.push(n.readUshort(t, l), n.readUshort(t, l + 2)), l += 4;
					return [d, h]
				}
			}, i["T"].cpal = {
				parseTab: function(t, e, r) {
					var n = i["B"],
						o = e,
						a = n.readUshort(t, e);
					if (e += 2, 0 == a) {
						n.readUshort(t, e);
						e += 2;
						n.readUshort(t, e);
						e += 2;
						var s = n.readUshort(t, e);
						e += 2;
						var c = n.readUint(t, e);
						return e += 4, new Uint8Array(t.buffer, o + c, 4 * s)
					}
					throw a
				}
			}, i["U"] = {
				shape: function(t, e, r) {
					for (var n = function(t, e, r, n) {
						var i = e[r],
							o = e[r + 1],
							a = t["kern"];
						if (a) {
							var s = a.glyph1.indexOf(i);
							if (-1 != s) {
								var c = a.rval[s].glyph2.indexOf(o);
								if (-1 != c) return [0, 0, a.rval[s].vals[c], 0]
							}
						}
						return [0, 0, 0, 0]
					}, o = [], a = 0; a < e.length; a++) {
						var s = e.codePointAt(a);
						s > 65535 && a++, o.push(i["U"]["codeToGlyph"](t, s))
					}
					var c = [];
					for (a = 0; a < o.length; a++) {
						var u = n(t, o, a, r),
							d = o[a],
							l = t["hmtx"].aWidth[d] + u[2];
						c.push({
							g: d,
							cl: a,
							dx: 0,
							dy: 0,
							ax: l,
							ay: 0
						}), l
					}
					return c
				},
				shapeToPath: function(t, e, r) {
					for (var n = {
						cmds: [],
						crds: []
					}, o = 0, a = 0, s = 0; s < e.length; s++) {
						for (var c = e[s], u = i["U"]["glyphToPath"](t, c["g"]), d = u["crds"], l = 0; l < d.length; l += 2) n.crds.push(d[l] + o + c["dx"]), n.crds.push(d[l + 1] + a + c["dy"]);
						r && n.cmds.push(r);
						for (l = 0; l < u["cmds"].length; l++) n.cmds.push(u["cmds"][l]);
						var f = n.cmds.length;
						r && 0 != f && "X" != n.cmds[f - 1] && n.cmds.push("X"), o += c["ax"], a += c["ay"]
					}
					return {
						cmds: n.cmds,
						crds: n.crds
					}
				},
				codeToGlyph: function() {
					function t(t, e, r) {
						var n = 0,
							i = ~~(t.length / e);
						while (n + 1 != i) {
							var o = n + (i - n >>> 1);
							t[o * e] <= r ? n = o : i = o
						}
						return n * e
					}
					for (var e = [9, 10, 11, 12, 13, 32, 133, 160, 5760, 6158, 8232, 8233, 8239, 8288, 12288, 65279], r = {}, n = 0; n < e.length; n++) r[e[n]] = 1;
					for (n = 8192; n <= 8205; n++) r[n] = 1;

					function i(e, n) {
						if (null == e["_ctab"]) {
							for (var i = e["cmap"], o = -1, a = ["p3e10", "p0e4", "p3e1", "p1e0", "p0e3", "p0e1", "p3e0", "p3e5"], s = 0; s < a.length; s++)
								if (null != i.ids[a[s]]) {
									o = i.ids[a[s]];
									break
								} if (-1 == o) throw "no familiar platform and encoding!";
							e["_ctab"] = i.tables[o]
						}
						var c = e["_ctab"],
							u = c.format,
							d = -1;
						if (0 == u) d = n >= c.map.length ? 0 : c.map[n];
						else if (4 == u) {
							var l = c.endCount;
							if (d = 0, n <= l[l.length - 1]) {
								var f = t(l, 1, n);
								if (l[f] < n && f++, n >= c.startCount[f]) {
									var h = 0;
									h = 0 != c.idRangeOffset[f] ? c.glyphIdArray[n - c.startCount[f] + (c.idRangeOffset[f] >> 1) - (c.idRangeOffset.length - f)] : n + c.idDelta[f], d = 65535 & h
								}
							}
						} else if (6 == u) {
							var p = n - c.firstCode,
								m = c.glyphIdArray;
							d = p < 0 || p >= m.length ? 0 : m[p]
						} else {
							if (12 != u) throw "unknown cmap table format " + c.format;
							var b = c.groups;
							if (d = 0, n <= b[b.length - 2]) {
								s = t(b, 3, n);
								b[s] <= n && n <= b[s + 1] && (d = b[s + 2] + (n - b[s]))
							}
						}
						var g = e["SVG "],
							y = e["loca"];
						return 0 == d || null != e["CFF "] || null != g && null != g.entries[d] || !y || y[d] != y[d + 1] || null != r[n] || (d = 0), d
					}
					return i
				}(),
				glyphToPath: function(t, e, r) {
					var n = {
							cmds: [],
							crds: []
						},
						o = t["SVG "],
						a = t["CFF "],
						s = t["COLR"],
						c = t["CBLC"],
						u = t["CBDT"],
						d = t["sbix"],
						l = window["UPNG"],
						f = i["U"],
						h = null;
					if (c && l)
						for (var p = 0; p < c.length; p++) c[p][0] <= e && e <= c[p][1] && (h = c[p]);
					if (h || d && d[e]) {
						if (h && 17 != h[2]) throw "not a PNG";
						null == t["__tmp"] && (t["__tmp"] = {});
						var m = t["__tmp"]["g" + e];
						if (null == m) {
							var b, g;
							if (d) b = d[e], g = b.length;
							else {
								var y = h[3][e - h[0]] + 5;
								g = u[y + 1] << 16 | u[y + 2] << 8 | u[y + 3], y += 4, b = new Uint8Array(u.buffer, u.byteOffset + y, g)
							}
							var v = "";
							for (p = 0; p < g; p++) v += String.fromCharCode(b[p]);
							m = t["__tmp"]["g" + e] = "data:image/png;base64," + btoa(v)
						}
						n.cmds.push(m);
						var S = 1.15 * t["head"]["unitsPerEm"],
							w = Math.round(S),
							C = Math.round(S),
							_ = Math.round(.15 * -C);
						n.crds.push(0, C + _, w, C + _, w, _, 0, _)
					} else if (o && o.entries[e]) {
						var A = o.entries[e];
						null != A && ("string" == typeof A && (A = f["SVG"].toPath(A), o.entries[e] = A), n = A)
					} else if (1 != r && s && s[0]["g" + e] && s[0]["g" + e][1] > 1) {
						var I = function(t) {
								var e = t.toString(16);
								return (1 == e.length ? "0" : "") + e
							},
							E = t["CPAL"],
							T = s[0]["g" + e];
						for (p = 0; p < T[1]; p++) {
							var x = T[0] + p,
								P = s[1][2 * x],
								k = 4 * s[1][2 * x + 1],
								D = i["U"]["glyphToPath"](t, P, P == e),
								O = "#" + I(E[k + 2]) + I(E[k + 1]) + I(E[k + 0]);
							n.cmds.push(O), n.cmds = n.cmds.concat(D["cmds"]), n.crds = n.crds.concat(D["crds"]), n.cmds.push("X")
						}
					} else if (a) {
						var R = a["Private"],
							N = {
								x: 0,
								y: 0,
								stack: [],
								nStems: 0,
								haveWidth: !1,
								width: R ? R["defaultWidthX"] : 0,
								open: !1
							};
						if (a["ROS"]) {
							var M = 0;
							while (a["FDSelect"][M + 2] <= e) M += 2;
							R = a["FDArray"][a["FDSelect"][M + 1]]["Private"]
						}
						f["_drawCFF"](a["CharStrings"][e], N, a, R, n)
					} else if (t["glyf"]) f["_drawGlyf"](e, t, n);
					else {
						T = i["T"].glyf._parseGlyf2(t, e);
						null != T && (T.noc > -1 ? i["U"]["_simpleGlyph"](T, n) : i["U"]["_compoGlyph"](T, t, n))
					}
					return {
						cmds: n.cmds,
						crds: n.crds
					}
				},
				_drawGlyf: function(t, e, r) {
					var n = e["glyf"][t];
					null == n && (n = e["glyf"][t] = i["T"].glyf._parseGlyf(e, t)), null != n && (n.noc > -1 ? i["U"]["_simpleGlyph"](n, r) : i["U"]["_compoGlyph"](n, e, r))
				},
				_simpleGlyph: function(t, e) {
					for (var r = i["U"]["P"], n = 0; n < t.noc; n++) {
						for (var o = 0 == n ? 0 : t.endPts[n - 1] + 1, a = t.endPts[n], s = o; s <= a; s++) {
							var c = s == o ? a : s - 1,
								u = s == a ? o : s + 1,
								d = 1 & t.flags[s],
								l = 1 & t.flags[c],
								f = 1 & t.flags[u],
								h = t.xs[s],
								p = t.ys[s];
							if (s == o)
								if (d) {
									if (!l) {
										r.MoveTo(e, h, p);
										continue
									}
									r.MoveTo(e, t.xs[c], t.ys[c])
								} else l ? r.MoveTo(e, t.xs[c], t.ys[c]) : r.MoveTo(e, Math.floor(.5 * (t.xs[c] + h)), Math.floor(.5 * (t.ys[c] + p)));
							d ? l && r.LineTo(e, h, p) : f ? r.qCurveTo(e, h, p, t.xs[u], t.ys[u]) : r.qCurveTo(e, h, p, Math.floor(.5 * (h + t.xs[u])), Math.floor(.5 * (p + t.ys[u])))
						}
						r.ClosePath(e)
					}
				},
				_compoGlyph: function(t, e, r) {
					for (var n = 0; n < t.parts.length; n++) {
						var o = {
								cmds: [],
								crds: []
							},
							a = t.parts[n];
						i["U"]["_drawGlyf"](a.glyphIndex, e, o);
						for (var s = a.m, c = 0; c < o.crds.length; c += 2) {
							var u = o.crds[c],
								d = o.crds[c + 1];
							r.crds.push(u * s.a + d * s.c + s.tx), r.crds.push(u * s.b + d * s.d + s.ty)
						}
						for (c = 0; c < o.cmds.length; c++) r.cmds.push(o.cmds[c])
					}
				},
				pathToSVG: function(t, e) {
					var r = t["cmds"],
						n = t["crds"];

					function i(t) {
						return parseFloat(t.toFixed(e))
					}

					function o(t) {
						for (var e = [], r = !1, n = "", i = 0; i < t.length; i++) {
							var o = t[i],
								a = "number" == typeof o;
							if (!a) {
								if (o == n && 1 == o.length && "m" != o) continue;
								n = o
							}
							r && a && o >= 0 && e.push(" "), e.push(o), r = a
						}
						return e.join("")
					}
					null == e && (e = 5);
					for (var a = [], s = 0, c = {
						M: 2,
						L: 2,
						Q: 4,
						C: 6
					}, u = 0, d = 0, l = 0, f = 0, h = 0, p = 0, m = 0; m < r.length; m++) {
						var b, g, y, v, S = r[m],
							w = c[S] ? c[S] : 0,
							C = [];
						if ("L" == S) b = n[s] - u, g = n[s + 1] - d, y = i(b + l), v = i(g + f), "Z" == r[m + 1] && n[s] == h && n[s + 1] == p ? (y = b, v = g) : 0 == y && 0 == v || (0 == y ? C.push("v", v) : 0 == v ? C.push("h", y) : C.push("l", y, v));
						else {
							C.push(S.toLowerCase());
							for (var _ = 0; _ < w; _ += 2) b = n[s + _] - u, g = n[s + _ + 1] - d, y = i(b + l), v = i(g + f), C.push(y, v)
						}
						0 != w && (l += b - y, f += g - v);
						var A = C;
						for (_ = 0; _ < A.length; _++) a.push(A[_]);
						0 != w && (s += w, u = n[s - 2], d = n[s - 1]), "M" == S && (h = u, p = d), "Z" == S && (u = h, d = p)
					}
					return o(a)
				},
				SVGToPath: function(t) {
					var e = {
						cmds: [],
						crds: []
					};
					return i["U"]["SVG"].svgToPath(t, e), {
						cmds: e.cmds,
						crds: e.crds
					}
				},
				pathToContext: function() {
					var t, e;

					function r(r, n) {
						for (var i = 0, o = r["cmds"], a = r["crds"], s = 0; s < o.length; s++) {
							var c = o[s];
							if ("M" == c) n.moveTo(a[i], a[i + 1]), i += 2;
							else if ("L" == c) n.lineTo(a[i], a[i + 1]), i += 2;
							else if ("C" == c) n.bezierCurveTo(a[i], a[i + 1], a[i + 2], a[i + 3], a[i + 4], a[i + 5]), i += 6;
							else if ("Q" == c) n.quadraticCurveTo(a[i], a[i + 1], a[i + 2], a[i + 3]), i += 4;
							else if ("d" == c[0]) {
								var u = window["UPNG"],
									d = a[i],
									l = a[i + 1],
									f = a[i + 2],
									h = a[i + 3],
									p = a[i + 4],
									m = a[i + 5],
									b = a[i + 6],
									g = a[i + 7];
								if (i += 8, null == u) {
									n.moveTo(d, l), n.lineTo(f, h), n.lineTo(p, m), n.lineTo(b, g), n.closePath();
									continue
								}
								n.save();
								for (var y = f - d, v = h - l, S = Math.sqrt(y * y + v * v), w = Math.atan2(v, y), C = b - d, _ = g - l, A = Math.sqrt(C * C + _ * _), I = Math.sign(y * _ - v * C), E = atob(c.slice(22)), T = [], x = 0; x < E.length; x++) T[x] = E.charCodeAt(x);
								var P = u["decode"](new Uint8Array(T)),
									k = P["width"],
									D = P["height"],
									O = new Uint8Array(u["toRGBA8"](P)[0]);
								null == t && (t = document.createElement("canvas"), e = t.getContext("2d")), t.width == k && t.height == D || (t.width = k, t.height = D), e.putImageData(new ImageData(new Uint8ClampedArray(O.buffer), k, D), 0, 0), n.translate(d, l), n.rotate(w), n.scale(S * (k / D) / k, I * A / D), n.drawImage(t, 0, 0), n.restore()
							} else if ("#" == c.charAt(0) || "r" == c.charAt(0)) n.beginPath(), n.fillStyle = c;
							else if ("O" == c.charAt(0) && "OX" != c) {
								n.beginPath();
								var R = c.split("-");
								n.lineWidth = parseFloat(R[2]), n.strokeStyle = R[1]
							} else "Z" == c ? n.closePath() : "X" == c ? n.fill() : "OX" == c && n.stroke()
						}
					}
					return r
				}(),
				P: {
					MoveTo: function(t, e, r) {
						t.cmds.push("M"), t.crds.push(e, r)
					},
					LineTo: function(t, e, r) {
						t.cmds.push("L"), t.crds.push(e, r)
					},
					CurveTo: function(t, e, r, n, i, o, a) {
						t.cmds.push("C"), t.crds.push(e, r, n, i, o, a)
					},
					qCurveTo: function(t, e, r, n, i) {
						t.cmds.push("Q"), t.crds.push(e, r, n, i)
					},
					ClosePath: function(t) {
						t.cmds.push("Z")
					}
				},
				_drawCFF: function(t, e, r, n, o) {
					var a = e.stack,
						s = e.nStems,
						c = e.haveWidth,
						u = e.width,
						d = e.open,
						l = 0,
						f = e.x,
						h = e.y,
						p = 0,
						m = 0,
						b = 0,
						g = 0,
						y = 0,
						v = 0,
						S = 0,
						w = 0,
						C = 0,
						_ = 0,
						A = i["T"].CFF,
						I = i["U"]["P"],
						E = n["nominalWidthX"],
						T = {
							val: 0,
							size: 0
						};
					while (t && l < t.length) {
						A.getCharString(t, l, T);
						var x = T.val;
						if (l += T.size, "o1" == x || "o18" == x) L = a.length % 2 !== 0, L && !c && (u = a.shift() + E), s += a.length >> 1, a.length = 0, c = !0;
						else if ("o3" == x || "o23" == x) {
							L = a.length % 2 !== 0, L && !c && (u = a.shift() + E), s += a.length >> 1, a.length = 0, c = !0
						} else if ("o4" == x) a.length > 1 && !c && (u = a.shift() + E, c = !0), d && I.ClosePath(o), h += a.pop(), I.MoveTo(o, f, h), d = !0;
						else if ("o5" == x)
							while (a.length > 0) f += a.shift(), h += a.shift(), I.LineTo(o, f, h);
						else if ("o6" == x || "o7" == x)
							for (var P = a.length, k = "o6" == x, D = 0; D < P; D++) {
								var O = a.shift();
								k ? f += O : h += O, k = !k, I.LineTo(o, f, h)
							} else if ("o8" == x || "o24" == x) {
								P = a.length;
								var R = 0;
								while (R + 6 <= P) p = f + a.shift(), m = h + a.shift(), b = p + a.shift(), g = m + a.shift(), f = b + a.shift(), h = g + a.shift(), I.CurveTo(o, p, m, b, g, f, h), R += 6;
								"o24" == x && (f += a.shift(), h += a.shift(), I.LineTo(o, f, h))
							} else {
								if ("o11" == x) break;
								if ("o1234" == x || "o1235" == x || "o1236" == x || "o1237" == x) "o1234" == x && (p = f + a.shift(), m = h, b = p + a.shift(), g = m + a.shift(), C = b + a.shift(), _ = g, y = C + a.shift(), v = g, S = y + a.shift(), w = h, f = S + a.shift(), I.CurveTo(o, p, m, b, g, C, _), I.CurveTo(o, y, v, S, w, f, h)), "o1235" == x && (p = f + a.shift(), m = h + a.shift(), b = p + a.shift(), g = m + a.shift(), C = b + a.shift(), _ = g + a.shift(), y = C + a.shift(), v = _ + a.shift(), S = y + a.shift(), w = v + a.shift(), f = S + a.shift(), h = w + a.shift(), a.shift(), I.CurveTo(o, p, m, b, g, C, _), I.CurveTo(o, y, v, S, w, f, h)), "o1236" == x && (p = f + a.shift(), m = h + a.shift(), b = p + a.shift(), g = m + a.shift(), C = b + a.shift(), _ = g, y = C + a.shift(), v = g, S = y + a.shift(), w = v + a.shift(), f = S + a.shift(), I.CurveTo(o, p, m, b, g, C, _), I.CurveTo(o, y, v, S, w, f, h)), "o1237" == x && (p = f + a.shift(), m = h + a.shift(), b = p + a.shift(), g = m + a.shift(), C = b + a.shift(), _ = g + a.shift(), y = C + a.shift(), v = _ + a.shift(), S = y + a.shift(), w = v + a.shift(), Math.abs(S - f) > Math.abs(w - h) ? f = S + a.shift() : h = w + a.shift(), I.CurveTo(o, p, m, b, g, C, _), I.CurveTo(o, y, v, S, w, f, h));
								else if ("o14" == x) {
									if (a.length > 0 && 4 != a.length && !c && (u = a.shift() + r["nominalWidthX"], c = !0), 4 == a.length) {
										var N = a.shift(),
											M = a.shift(),
											B = a.shift(),
											F = a.shift(),
											j = A.glyphBySE(r, B),
											K = A.glyphBySE(r, F);
										i["U"]["_drawCFF"](r["CharStrings"][j], e, r, n, o), e.x = N, e.y = M, i["U"]["_drawCFF"](r["CharStrings"][K], e, r, n, o)
									}
									d && (I.ClosePath(o), d = !1)
								} else if ("o19" == x || "o20" == x) {
									var L;
									L = a.length % 2 !== 0, L && !c && (u = a.shift() + E), s += a.length >> 1, a.length = 0, c = !0, l += s + 7 >> 3
								} else if ("o21" == x) a.length > 2 && !c && (u = a.shift() + E, c = !0), h += a.pop(), f += a.pop(), d && I.ClosePath(o), I.MoveTo(o, f, h), d = !0;
								else if ("o22" == x) a.length > 1 && !c && (u = a.shift() + E, c = !0), f += a.pop(), d && I.ClosePath(o), I.MoveTo(o, f, h), d = !0;
								else if ("o25" == x) {
									while (a.length > 6) f += a.shift(), h += a.shift(), I.LineTo(o, f, h);
									p = f + a.shift(), m = h + a.shift(), b = p + a.shift(), g = m + a.shift(), f = b + a.shift(), h = g + a.shift(), I.CurveTo(o, p, m, b, g, f, h)
								} else if ("o26" == x) {
									a.length % 2 && (f += a.shift());
									while (a.length > 0) p = f, m = h + a.shift(), b = p + a.shift(), g = m + a.shift(), f = b, h = g + a.shift(), I.CurveTo(o, p, m, b, g, f, h)
								} else if ("o27" == x) {
									a.length % 2 && (h += a.shift());
									while (a.length > 0) p = f + a.shift(), m = h, b = p + a.shift(), g = m + a.shift(), f = b + a.shift(), h = g, I.CurveTo(o, p, m, b, g, f, h)
								} else if ("o10" == x || "o29" == x) {
									var U = "o10" == x ? n : r;
									if (0 == a.length) console.log("error: empty stack");
									else {
										var X = a.pop(),
											z = U["Subrs"][X + U["Bias"]];
										e.x = f, e.y = h, e.nStems = s, e.haveWidth = c, e.width = u, e.open = d, i["U"]["_drawCFF"](z, e, r, n, o), f = e.x, h = e.y, s = e.nStems, c = e.haveWidth, u = e.width, d = e.open
									}
								} else if ("o30" == x || "o31" == x) {
									var G = a.length,
										q = (R = 0, "o31" == x);
									P = -3 & G, R += G - P;
									while (R < P) q ? (p = f + a.shift(), m = h, b = p + a.shift(), g = m + a.shift(), h = g + a.shift(), P - R == 5 ? (f = b + a.shift(), R++) : f = b, q = !1) : (p = f, m = h + a.shift(), b = p + a.shift(), g = m + a.shift(), f = b + a.shift(), P - R == 5 ? (h = g + a.shift(), R++) : h = g, q = !0), I.CurveTo(o, p, m, b, g, f, h), R += 4
								} else {
									if ("o" == (x + "")
										.charAt(0)) throw console.log("Unknown operation: " + x, t), x;
									a.push(x)
								}
							}
					}
					e.x = f, e.y = h, e.nStems = s, e.haveWidth = c, e.width = u, e.open = d
				},
				SVG: function() {
					var t = {
						getScale: function(t) {
							return Math.sqrt(Math.abs(t[0] * t[3] - t[1] * t[2]))
						},
						translate: function(e, r, n) {
							t.concat(e, [1, 0, 0, 1, r, n])
						},
						rotate: function(e, r) {
							t.concat(e, [Math.cos(r), -Math.sin(r), Math.sin(r), Math.cos(r), 0, 0])
						},
						scale: function(e, r, n) {
							t.concat(e, [r, 0, 0, n, 0, 0])
						},
						concat: function(t, e) {
							var r = t[0],
								n = t[1],
								i = t[2],
								o = t[3],
								a = t[4],
								s = t[5];
							t[0] = r * e[0] + n * e[2], t[1] = r * e[1] + n * e[3], t[2] = i * e[0] + o * e[2], t[3] = i * e[1] + o * e[3], t[4] = a * e[0] + s * e[2] + e[4], t[5] = a * e[1] + s * e[3] + e[5]
						},
						invert: function(t) {
							var e = t[0],
								r = t[1],
								n = t[2],
								i = t[3],
								o = t[4],
								a = t[5],
								s = e * i - r * n;
							t[0] = i / s, t[1] = -r / s, t[2] = -n / s, t[3] = e / s, t[4] = (n * a - i * o) / s, t[5] = (r * o - e * a) / s
						},
						multPoint: function(t, e) {
							var r = e[0],
								n = e[1];
							return [r * t[0] + n * t[2] + t[4], r * t[1] + n * t[3] + t[5]]
						},
						multArray: function(t, e) {
							for (var r = 0; r < e.length; r += 2) {
								var n = e[r],
									i = e[r + 1];
								e[r] = n * t[0] + i * t[2] + t[4], e[r + 1] = n * t[1] + i * t[3] + t[5]
							}
						}
					};

					function e(t, e, r) {
						var n = [],
							i = 0,
							o = 0,
							a = 0;
						while (1) {
							var s = t.indexOf(e, o),
								c = t.indexOf(r, o);
							if (-1 == s && -1 == c) break; - 1 == c || -1 != s && s < c ? (0 == a && (n.push(t.slice(i, s)
								.trim()), i = s + 1), a++, o = s + 1) : (-1 == s || -1 != c && c < s) && (a--, 0 == a && (n.push(t.slice(i, c)
								.trim()), i = c + 1), o = c + 1)
						}
						return n
					}

					function r(t) {
						for (var r = e(t, "{", "}"), n = {}, i = 0; i < r.length; i += 2)
							for (var o = r[i].split(","), a = 0; a < o.length; a++) {
								var s = o[a].trim();
								null == n[s] && (n[s] = ""), n[s] += r[i + 1]
							}
						return n
					}

					function n(r) {
						for (var n = e(r, "(", ")"), o = [1, 0, 0, 1, 0, 0], a = 0; a < n.length; a += 2) {
							var s = o;
							o = i(n[a], n[a + 1]), t.concat(o, s)
						}
						return o
					}

					function i(e, r) {
						for (var n = [1, 0, 0, 1, 0, 0], i = !0, o = 0; o < r.length; o++) {
							var a = r.charAt(o);
							"," == a || " " == a ? i = !0 : "." == a ? (i || (r = r.slice(0, o) + "," + r.slice(o), o++), i = !1) : "-" == a && o > 0 && "e" != r[o - 1] && (r = r.slice(0, o) + " " + r.slice(o), o++, i = !0)
						}
						if (r = r.split(/\s*[\s,]\s*/)
							.map(parseFloat), "translate" == e) 1 == r.length ? t.translate(n, r[0], 0) : t.translate(n, r[0], r[1]);
						else if ("scale" == e) 1 == r.length ? t.scale(n, r[0], r[0]) : t.scale(n, r[0], r[1]);
						else if ("rotate" == e) {
							var s = 0,
								c = 0;
							1 != r.length && (s = r[1], c = r[2]), t.translate(n, -s, -c), t.rotate(n, -Math.PI * r[0] / 180), t.translate(n, s, c)
						} else "matrix" == e ? n = r : console.log("unknown transform: ", e);
						return n
					}

					function o(t) {
						var e = {
							cmds: [],
							crds: []
						};
						if (null == t) return e;
						var r = new DOMParser,
							n = r["parseFromString"](t, "image/svg+xml"),
							i = n.getElementsByTagName("svg")[0],
							o = i.getAttribute("viewBox");
						o = o ? o.trim()
							.split(" ")
							.map(parseFloat) : [0, 0, 1e3, 1e3], a(i.children, e);
						for (var s = 0; s < e.crds.length; s += 2) {
							var c = e.crds[s],
								u = e.crds[s + 1];
							c -= o[0], u -= o[1], u = -u, e.crds[s] = c, e.crds[s + 1] = u
						}
						return e
					}

					function a(e, r, i) {
						for (var o = 0; o < e.length; o++) {
							var s = e[o],
								c = s.tagName,
								d = s.getAttribute("fill");
							if (null == d && (d = i), "g" == c) {
								var l = {
									crds: [],
									cmds: []
								};
								a(s.children, l, d);
								var f = s.getAttribute("transform");
								if (f) {
									var h = n(f);
									t.multArray(h, l.crds)
								}
								r.crds = r.crds.concat(l.crds), r.cmds = r.cmds.concat(l.cmds)
							} else if ("path" == c || "circle" == c || "ellipse" == c) {
								var p;
								if (r.cmds.push(d || "#000000"), "path" == c && (p = s.getAttribute("d")), "circle" == c || "ellipse" == c) {
									for (var m = [0, 0, 0, 0], b = ["cx", "cy", "rx", "ry", "r"], g = 0; g < 5; g++) {
										var y = s.getAttribute(b[g]);
										y && (y = parseFloat(y), g < 4 ? m[g] = y : m[2] = m[3] = y)
									}
									var v = m[0],
										S = m[1],
										w = m[2],
										C = m[3];
									p = ["M", v - w, S, "a", w, C, 0, 1, 0, 2 * w, 0, "a", w, C, 0, 1, 0, 2 * -w, 0].join(" ")
								}
								u(p, r), r.cmds.push("X")
							} else "defs" == c || console.log(c, s)
						}
					}

					function s(t) {
						var e = [],
							r = 0,
							n = !1,
							i = "",
							o = "",
							a = "",
							s = 0;
						while (r < t.length) {
							var c = t.charCodeAt(r),
								u = t.charAt(r);
							r++;
							var d = 48 <= c && c <= 57 || "." == u || "-" == u || "+" == u || "e" == u || "E" == u;
							n ? ("+" == u || "-" == u) && "e" != o || "." == u && -1 != i.indexOf(".") || d && ("a" == a || "A" == a) && (s % 7 == 3 || s % 7 == 4) ? (e.push(parseFloat(i)), s++, i = u) : d ? i += u : (e.push(parseFloat(i)), s++, "," != u && " " != u && (e.push(u), a = u, s = 0), n = !1) : d ? (i = u, n = !0) : "," != u && " " != u && (e.push(u), a = u, s = 0), o = u
						}
						return n && e.push(parseFloat(i)), e
					}

					function c(t, e, r) {
						var n = e;
						while (n < t.length) {
							if ("string" == typeof t[n]) break;
							n += r
						}
						return (n - e) / r
					}

					function u(t, e) {
						var r = s(t),
							n = 0,
							i = 0,
							o = 0,
							a = 0,
							u = 0,
							d = e.crds.length,
							l = {
								M: 2,
								L: 2,
								H: 1,
								V: 1,
								T: 2,
								S: 4,
								A: 7,
								Q: 4,
								C: 6
							},
							f = e.cmds,
							h = e.crds;
						while (n < r.length) {
							var p = r[n];
							n++;
							var m = p.toUpperCase();
							if ("Z" == m) f.push("Z"), i = a, o = u;
							else
								for (var b = l[m], g = c(r, n, b), y = 0; y < g; y++) {
									1 == y && "M" == m && (p = p == m ? "L" : "l", m = "L");
									var v = 0,
										S = 0;
									if (p != m && (v = i, S = o), "M" == m) i = v + r[n++], o = S + r[n++], f.push("M"), h.push(i, o), a = i, u = o;
									else if ("L" == m) i = v + r[n++], o = S + r[n++], f.push("L"), h.push(i, o);
									else if ("H" == m) i = v + r[n++], f.push("L"), h.push(i, o);
									else if ("V" == m) o = S + r[n++], f.push("L"), h.push(i, o);
									else if ("Q" == m) {
										var w = v + r[n++],
											C = S + r[n++],
											_ = v + r[n++],
											A = S + r[n++];
										f.push("Q"), h.push(w, C, _, A), i = _, o = A
									} else if ("T" == m) {
										var I = Math.max(h.length - ("Q" == f[f.length - 1] ? 4 : 2), d);
										w = i + i - h[I], C = o + o - h[I + 1], _ = v + r[n++], A = S + r[n++];
										f.push("Q"), h.push(w, C, _, A), i = _, o = A
									} else if ("C" == m) {
										w = v + r[n++], C = S + r[n++], _ = v + r[n++], A = S + r[n++];
										var E = v + r[n++],
											T = S + r[n++];
										f.push("C"), h.push(w, C, _, A, E, T), i = E, o = T
									} else if ("S" == m) {
										I = Math.max(h.length - ("C" == f[f.length - 1] ? 4 : 2), d), w = i + i - h[I], C = o + o - h[I + 1], _ = v + r[n++], A = S + r[n++], E = v + r[n++], T = S + r[n++];
										f.push("C"), h.push(w, C, _, A, E, T), i = E, o = T
									} else if ("A" == m) {
										w = i, C = o;
										var x = r[n++],
											P = r[n++],
											k = r[n++] * (Math.PI / 180),
											D = r[n++],
											O = r[n++];
										_ = v + r[n++], A = S + r[n++];
										if (_ == i && A == o && 0 == x && 0 == P) continue;
										var R = (w - _) / 2,
											N = (C - A) / 2,
											M = Math.cos(k),
											B = Math.sin(k),
											F = M * R + B * N,
											j = -B * R + M * N,
											K = x * x,
											L = P * P,
											U = F * F,
											X = j * j,
											z = (K * L - K * X - L * U) / (K * X + L * U),
											G = (D != O ? 1 : -1) * Math.sqrt(Math.max(z, 0)),
											q = G * (x * j) / P,
											W = P * F * -G / x,
											V = M * q - B * W + (w + _) / 2,
											H = B * q + M * W + (C + A) / 2,
											Y = function(t, e, r, n) {
												var i = Math.sqrt(t * t + e * e),
													o = Math.sqrt(r * r + n * n),
													a = (t * r + e * n) / (i * o);
												return (t * n - e * r >= 0 ? 1 : -1) * Math.acos(Math.max(-1, Math.min(1, a)))
											},
											Z = (F - q) / x,
											Q = (j - W) / P,
											J = Y(1, 0, Z, Q),
											$ = Y(Z, Q, (-F - q) / x, (-j - W) / P);
										$ %= 2 * Math.PI;
										var tt = function(t, e, r, n, i, o, a) {
												var s = function(t, e) {
														var r = Math.sin(e),
															n = Math.cos(e),
															i = (e = t[0], t[1]),
															o = t[2],
															a = t[3];
														t[0] = e * n + i * r, t[1] = -e * r + i * n, t[2] = o * n + a * r, t[3] = -o * r + a * n
													},
													c = function(t, e) {
														for (var r = 0; r < e.length; r += 2) {
															var n = e[r],
																i = e[r + 1];
															e[r] = t[0] * n + t[2] * i + t[4], e[r + 1] = t[1] * n + t[3] * i + t[5]
														}
													},
													u = function(t, e) {
														for (var r = 0; r < e.length; r++) t.push(e[r])
													},
													d = function(t, e) {
														u(t.cmds, e.cmds), u(t.crds, e.crds)
													};
												if (a)
													while (o > i) o -= 2 * Math.PI;
												else
													while (o < i) o += 2 * Math.PI;
												var l = (o - i) / 4,
													f = Math.cos(l / 2),
													h = -Math.sin(l / 2),
													p = (4 - f) / 3,
													m = 0 == h ? h : (1 - f) * (3 - f) / (3 * h),
													b = p,
													g = -m,
													y = f,
													v = -h,
													S = [p, m, b, g, y, v],
													w = {
														cmds: ["C", "C", "C", "C"],
														crds: S.slice(0)
													},
													C = [1, 0, 0, 1, 0, 0];
												s(C, -l);
												for (var _ = 0; _ < 3; _++) c(C, S), u(w.crds, S);
												s(C, l / 2 - i), C[0] *= n, C[1] *= n, C[2] *= n, C[3] *= n, C[4] = e, C[5] = r, c(C, w.crds), c(t.ctm, w.crds), d(t.pth, w)
											},
											et = {
												pth: e,
												ctm: [x * M, x * B, -P * B, P * M, V, H]
											};
										tt(et, 0, 0, 1, J, J + $, 0 == O), i = _, o = A
									} else console.log("Unknown SVG command " + p)
								}
						}
					}
					return {
						cssMap: r,
						readTrnf: n,
						svgToPath: u,
						toPath: o
					}
				}(),
				initHB: function(t, e) {
					var r = function(t) {
						var e = 0;
						return 0 == (4294967168 & t) ? e = 1 : 0 == (4294965248 & t) ? e = 2 : 0 == (4294901760 & t) ? e = 3 : 0 == (4292870144 & t) && (e = 4), e
					};
					fetch(t)
						.then((function(t) {
							return t["arrayBuffer"]()
						}))
						.then((function(t) {
							return WebAssembly["instantiate"](t)
						}))
						.then((function(t) {
							console.log("HB ready");
							var n, o, a, s, c, u, d, l, f = t["instance"]["exports"],
								h = f["memory"];
							i["U"]["shapeHB"] = function() {
								var t, e = function(t) {
									for (var e = f["hb_buffer_get_length"](t), r = [], n = f["hb_buffer_get_glyph_infos"](t, 0) >>> 2, i = f["hb_buffer_get_glyph_positions"](t, 0) >>> 2, s = 0; s < e; ++s) {
										var c = n + 5 * s,
											u = i + 5 * s;
										r.push({
											g: o[c + 0],
											cl: o[c + 2],
											ax: a[u + 0],
											ay: a[u + 1],
											dx: a[u + 2],
											dy: a[u + 3]
										})
									}
									return r
								};
								return function(i, p, m) {
									var b = i["_data"],
										g = i["name"]["postScriptName"],
										y = h.buffer.byteLength,
										v = 2 * b.length + 16 * p.length + 4e6;
									if (y < v && h["grow"](4 + (v - y >>> 16)), n = new Uint8Array(h.buffer), o = new Uint32Array(h.buffer), a = new Int32Array(h.buffer), s != g && (null != c && (f["hb_blob_destroy"](c), f["free"](u), f["hb_face_destroy"](d), f["hb_font_destroy"](l)), u = f["malloc"](b.byteLength), n.set(b, u), c = f["hb_blob_create"](u, b.byteLength, 2, 0, 0), d = f["hb_face_create"](c, 0), l = f["hb_font_create"](d), s = g), null != window["TextEncoder"]) {
										null == t && (t = new window["TextEncoder"]("utf8"));
										var S = f["hb_buffer_create"](),
											w = t["encode"](p),
											C = w.length,
											_ = f["malloc"](C);
										n.set(w, _), f["hb_buffer_add_utf8"](S, _, C, 0, C), f["free"](_), f["hb_buffer_set_direction"](S, m ? 4 : 5), f["hb_buffer_guess_segment_properties"](S), f["hb_shape"](l, S, 0, 0);
										var A = e(S);
										f["hb_buffer_destroy"](S);
										var I = A.slice(0);
										m || I.reverse();
										for (var E = 0, T = 0, x = 1; x < I.length; x++) {
											var P = I[x],
												k = P["cl"];
											while (1) {
												var D = p.codePointAt(E),
													O = r(D);
												if (!(T + O <= k)) break;
												T += O, E += D <= 65535 ? 1 : 2
											}
											P["cl"] = E
										}
										return A
									}
									alert("Your browser is too old. Please, update it.")
								}
							}(), e()
						}))
				}
			};
			var o = i;
			(function(t) {
				function e(t) {
					return "number" === typeof t
				}

				function r(t) {
					return e(t) && (0 | t) === t
				}

				function n(t) {
					return t instanceof Array
				}

				function i(t) {
					for (var r = 0; r < t.length; r++)
						if (!e(t[r])) return !1;
					return !0
				}

				function o(t, r) {
					return e(t) ? t : r
				}

				function a(t, e) {
					return "string" === typeof t ? t : e
				}

				function s(t, e) {
					return "boolean" === typeof t ? t : e
				}

				function c(t) {
					return 1 === t.dim("min")
				}

				function u(t) {
					if (n(t)) return t;
					if (!c(t)) throw new f(f.ErrorCodes.DIMENSION_MISMATCH, "Argument has to be vector");
					for (var e = t.dim("max") === t.rows() ? t.__getColumn(1) : t.__getRow(1), r = [], i = 1; i <= e.length; i++) r.push(e[i - 1]);
					return r
				}

				function d(t) {
					return [].slice.call(t)
				}

				function l() {
					throw new Error("This cannot be instantiated")
				}

				function f(t, e) {
					this.name = "MatrixError", this.code = t, this.message = e, this.toString = function() {
						return this.name + " [" + this.code + "]: " + (this.message || "No message")
					}
				}

				function h(t) {
					var o, a, s = d(arguments),
						c = [];
					return this.___get = function(t, e) {
							return c[a * (t - 1) + e - 1]
						}, this.___set = function(t, e, r) {
							return c[a * (t - 1) + e - 1] = r, this
						}, this.rows = function() {
							return o
						}, this.columns = function() {
							return a
						}, this.___getElements = function() {
							return c
						},
						function() {
							if (1 === s.length && n(s[0]) && 0 !== s[0].length && n(s[0][0])) {
								o = s[0].length, a = -1;
								for (var t = 0; t < s[0].length; t++) {
									if (s[0][t].length !== a && -1 !== a) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Number of columns must be the same for all rows");
									if (!i(s[0][t])) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Elements must be numbers");
									a = Math.max(a, s[0][t].length), c = c.concat(s[0][t])
								}
							} else if (s.length >= 1 && s.length <= 3 && n(s[0]) && (0 === s[0].length || e(s[0][0]))) {
								if (!i(s[0])) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Elements must be numbers");
								c = s[0];
								var u = s[1],
									d = s[2];
								if (e(u) || e(d)) !e(u) && r(d) ? u = c.length / d : r(u) && !e(d) && (d = c.length / u);
								else {
									var h = Math.sqrt(c.length);
									u = h, d = h
								}
								if (!r(u) || !r(d)) throw new f(f.ErrorCodes.OUT_OF_BOUNDS, "Array must represent square matrix if no size is given");
								o = u, a = d
							} else if (1 === s.length && r(s[0])) o = s[0], a = s[0], c = l.repeat(o * a, 0);
							else {
								if (2 !== s.length || !r(s[0]) || !r(s[1])) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Parameters must match a supported signature");
								o = s[0], a = s[1], c = l.repeat(o * a, 0)
							}
						}(), this
				}

				function p(t) {
					var e, i, o = d(arguments),
						a = [],
						s = [],
						c = [];
					return this.___get = function(t, e) {
							for (var r = c[t - 1]; r < c[t]; r++)
								if (s[r] === e) return a[r];
							return 0
						}, this.___set = function(t, e, r) {
							for (var n, i = !1, o = c[t - 1]; o <= c[t]; o++)
								if (n = o, s[o] === e && o !== c[t]) {
									i = !0;
									break
								} if (i || 0 === r) {
								if (i && 0 !== r) a.splice(n, 1, r), s.splice(n, 1, e);
								else if (i) {
									for (u = t; u < c.length; u++) c[u] -= 1;
									a.splice(n, 1), s.splice(n, 1)
								}
							} else {
								for (var u = t; u < c.length; u++) c[u] += 1;
								a.splice(n, 0, r), s.splice(n, 0, e)
							}
							return this
						}, this.___getElements = function() {
							return a
						}, this.___getColumnIndicator = function() {
							return s
						}, this.___getRowPointer = function() {
							return c
						}, this.rows = function() {
							return e
						}, this.columns = function() {
							return i
						},
						function() {
							if (o.length >= 1 && o.length <= 2 && r(o[0]) && (1 === o.length || r(o[1]))) e = o[0], i = o[1] || e, a = [], s = [], c = l.repeat(e + 1, 0);
							else {
								if (!(5 === o.length && r(o[0]) && r(o[1]) && n(o[2]) && n(o[3]) && n(o[4]))) {
									if (1 === o.length && o[0] instanceof b) return o[0].build();
									throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Parameters must match a supported signature")
								}
								if (e = o[0], i = o[1], a = o[2], s = o[3], c = o[4], -1 !== a.indexOf(0)) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Values must not be 0");
								if (e != c.length - 1) throw new f(f.ErrorCodes.OUT_OF_BOUNDS, "Number of rows is too small");
								if (a.length !== s.length) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Arrays for values and column indicators have to be the same size");
								if (Math.max.apply(this, s) > i) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Number of columns has to be bigger than the biggest column index")
							}
						}(), this
				}

				function m(t) {
					d(arguments);
					var e, r = [];
					return this.___get = function(t, n) {
						return r[e ? t - 1 : n - 1]
					}, this.___set = function(t, n, i) {
						return r[e ? t - 1 : n - 1] = i, this
					}, this.rows = function() {
						return e ? r.length : 1
					}, this.columns = function() {
						return e ? 1 : r.length
					}, this
				}

				function b() {
					var t, n, i = [];

					function a(t, e, r) {
						i.push({
							row: t,
							column: e,
							value: r
						})
					}
					this.size = function(e, r) {
						return t = e, n = o(r, e), this
					}, this.set = function(o, s, c) {
						if (!r(t) || !r(n)) throw new f(f.ErrorCodes.SIZE_NOT_GIVEN, "Size has to be specified first");
						if (!e(c)) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Value is not numeric");
						var u = i.filter((function(t) {
								return t.row === o && t.column === s
							}))
							.length;
						if (0 !== u) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Cannot set same entry multiple times");
						if (o > t || s > n) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
						return 0 !== c && a(o, s, c), this
					}, this.build = function() {
						i.sort((function(t, e) {
							return t.row != e.row ? t.row < e.row ? -1 : 1 : t.column != e.column ? t.column < e.column ? -1 : 1 : 0
						}));
						for (var e = [], r = l.repeat(t + 1, 0), o = [], a = 1, s = 0; s < i.length; s++) {
							var c = i[s];
							if (e[s] = c.value, o[s] = c.column, 0 === r[c.row])
								for (var u = a + 1; u <= c.row; u++) r[u] = r[u - 1];
							r[c.row]++, a = c.row
						}
						return r[t] = o.length, new p(t, n, e, o, r)
					}
				}
				f.ErrorCodes = {
					INVALID_PARAMETERS: "Invalid parameters",
					OUT_OF_BOUNDS: "Out of bounds",
					DIMENSION_MISMATCH: "Dimension mismatch",
					MATRIX_IS_SINGULAR: "Matrix is singular",
					UNKNOWN_TYPE: "Unknown type",
					SIZE_NOT_GIVEN: "Size not given"
				}, h.prototype.get = function(t, e) {
					if (!this.isInRange(t, e)) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					return this.___get(t, e)
				}, h.prototype.set = function(t, r, n) {
					if (!this.isInRange(t, r)) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					if (!e(n)) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Value has to be a number");
					return this.___set(t, r, n)
				}, h.prototype.getRow = function(t) {
					if (!this.isInRange(t, null)) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					return this.__getRow(t)
				}, h.prototype.__getRow = function(t) {
					for (var e = [], r = this.columns(), n = 1; n <= r; n++) e.push(this.___get(t, n));
					return e
				}, h.prototype.setRow = function(t, e) {
					if (e = u(e), !this.isInRange(t, null)) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					if (e.length !== this.columns()) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Wrong number of columns in row.");
					return this.__setRow(t, e)
				}, h.prototype.__setRow = function(t, e) {
					for (var r = this.columns(), n = 1; n <= r; n++) this.___set(t, n, e[n - 1]);
					return this
				}, h.prototype.getColumn = function(t) {
					if (!this.isInRange(null, t)) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					return this.__getColumn(t)
				}, h.prototype.__getColumn = function(t) {
					for (var e = [], r = this.rows(), n = 1; n <= r; n++) e.push(this.___get(n, t));
					return e
				}, h.prototype.setColumn = function(t, e) {
					if (e = u(e), !this.isInRange(null, t)) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					if (e.length !== this.rows()) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Wrong number of rows in column");
					return this.__setColumn(t, e)
				}, h.prototype.__setColumn = function(t, e) {
					for (var r = this.rows(), n = 1; n <= r; n++) this.___set(n, t, e[n - 1]);
					return this
				}, h.prototype.isSameSizeAs = function(t) {
					return this.rows() === t.rows() && this.columns() === t.columns()
				}, h.prototype.isSquare = function() {
					return this.rows() === this.columns()
				}, h.prototype.isSymmetric = function() {
					if (!this.isSquare()) throw new f(f.ErrorCodes.DIMENSION_MISMATCH, "Matrix must be square");
					for (var t = this.rows(), e = 2; e <= t; e++)
						for (var r = 1; r < e; r++)
							if (this.___get(e, r) !== this.___get(r, e)) return !1;
					return !0
				}, h.prototype.isTriangular = function(t) {
					if (t = a(t, l.options.isTriangular.mode), !this.isSquare()) throw new f(f.ErrorCodes.DIMENSION_MISMATCH, "Matrix must be square");
					switch (t.toLowerCase()) {
						case "lower":
							return this.__isTriangular(!1);
						case "upper":
							return this.__isTriangular(!0);
						case "both":
							return this.__isTriangular(!0) || this.__isTriangular(!1);
						default:
							throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Mode not supported")
					}
				}, h.prototype.__isTriangular = function(t) {
					for (var e, r, n = t ? 1 : -1, i = this.rows(), o = 1; o < i; o++) {
						e = this.diag(n * o), r = e.length;
						for (var a = 0; a < r; a++)
							if (0 !== e[a]) return !1
					}
					return !0
				}, h.prototype.copy = function() {
					return new h(this.toArray(), this.rows(), this.columns())
				}, h.prototype.size = function() {
					return this.rows() * this.columns()
				}, h.prototype.dim = function(t) {
					switch (t) {
						case 1:
						case "rows":
							return this.rows();
						case 2:
						case "columns":
							return this.columns();
						case "max":
							return Math.max(this.rows(), this.columns());
						case "min":
							return Math.min(this.rows(), this.columns());
						default:
							throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Parameter must match a known value")
					}
				}, h.prototype.add = function(t) {
					var e = this.rows(),
						r = this.columns();
					if (arguments.length > 1) {
						var n = d(arguments);
						return this.add.apply(this.add(n.shift()), n)
					}
					if (!this.isSameSizeAs(t)) throw new f(f.ErrorCodes.DIMENSION_MISMATCH, "Matrices must be of the same size");
					for (var i, o, a = new h(e, r), s = 1; s <= e; s++) {
						i = this.__getRow(s), o = t.__getRow(s);
						for (var c = 0; c < r; c++) i[c] += o[c];
						a.__setRow(s, i)
					}
					return a
				}, h.prototype.subtract = function(t) {
					var e = this.rows(),
						r = this.columns();
					if (arguments.length > 1) {
						var n = d(arguments);
						return this.subtract.apply(this.subtract(n.shift()), n)
					}
					if (!this.isSameSizeAs(t)) throw new f(f.ErrorCodes.DIMENSION_MISMATCH, "Matrices must be of the same size");
					for (var i, o, a = new h(e, r), s = 1; s <= e; s++) {
						i = this.__getRow(s), o = t.__getRow(s);
						for (var c = 0; c < r; c++) i[c] -= o[c];
						a.__setRow(s, i)
					}
					return a
				}, h.prototype.scale = function(t) {
					if (!e(t)) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Parameter must be a number");
					var r = this.rows(),
						n = this.columns();
					return 0 === t ? new h(r, n) : 1 === t ? this : this.fun((function(e) {
						return t * e
					}))
				}, h.prototype.multiply = function(t) {
					var e = this.rows(),
						r = this.columns(),
						n = t.columns();
					if (r !== t.rows()) throw new f(f.ErrorCodes.DIMENSION_MISMATCH, "Inner dimensions must match");
					for (var i = new h(e, n), o = 1; o <= e; o++)
						for (var a = 1; a <= n; a++) {
							for (var s = 0, c = this.__getRow(o), u = t.__getColumn(a), d = 0; d < r; d++) s += c[d] * u[d];
							i.___set(o, a, s)
						}
					return i
				}, h.prototype.transpose = function() {
					for (var t = this.rows(), e = new h(this.columns(), t), r = 1; r <= t; r++) e.__setColumn(r, this.__getRow(r));
					return e
				}, h.prototype.trace = function() {
					if (!this.isSquare()) throw new f(f.ErrorCodes.DIMENSION_MISMATCH, "Matrix must be square");
					for (var t = this.rows(), e = 0, r = 1; r <= t; r++) e += this.___get(r, r);
					return e
				}, h.prototype.decomposeLU = function() {
					var t, e, r, n, i, o, a, s, c, u, d = 0,
						l = this.copy(),
						h = this.rows(),
						p = this.columns();
					for (r = 1; r <= h; r++) {
						for (a = 0, s = -1, i = l.__getColumn(r), t = r; t <= h; t++) c = Math.abs(i[t - 1]), c >= s && (a = t, s = c);
						if (0 === i[a - 1]) throw new f(f.ErrorCodes.MATRIX_IS_SINGULAR);
						for (a !== r && (u = l.__getRow(a), l.__setRow(a, l.__getRow(r)), l.__setRow(r, u), d++), n = l.__getRow(r), t = r + 1; t <= h; t++) {
							for (o = l.__getRow(t), e = r; e < p; e++) o[e] = o[e] - n[e] * o[r - 1] / n[r - 1];
							o[r - 1] = 0, l.__setRow(t, o)
						}
					}
					return l.swappedRows = d, l
				}, h.prototype.det = function() {
					var t, e, r, n = this.rows();
					if (!this.isSquare()) throw new f(f.ErrorCodes.DIMENSION_MISMATCH, "Matrix must be square");
					if (this.isTriangular())
						for (e = 1, r = this.diag(), t = 0; t < n; t++) e *= r[t];
					else {
						try {
							var i = this.decomposeLU()
						} catch (o) {
							if (o.code && o.code === f.ErrorCodes.MATRIX_IS_SINGULAR) return 0;
							throw o
						}
						for (e = Math.pow(-1, i.swappedRows), r = i.diag(), t = 0; t < n; t++) e *= r[t]
					}
					return e
				}, h.prototype.inverse = function() {
					if (!this.isSquare()) throw new f(f.ErrorCodes.DIMENSION_MISMATCH, "Matrix must be square");
					var t, e, r, n, i, o, a, s, c, u = this.augment(h.eye(this.rows()));
					try {
						for (u = u.decomposeLU(), s = u.rows(), c = u.columns(), n = s; n > 1; n--) {
							for (e = u.__getRow(n - 1), t = u.__getRow(n), a = e[n - 1] / t[n - 1], r = [], o = 0; o < c; o++) r[o] = e[o] - t[o] * a;
							u.__setRow(n - 1, r)
						}
						for (i = 1; i <= s; i++) {
							for (t = u.__getRow(i), r = [], o = 0; o < c; o++) r[o] = t[o] / t[i - 1];
							u.__setRow(i, r)
						}
					} catch (d) {
						throw new f(f.ErrorCodes.MATRIX_IS_SINGULAR)
					}
					return u.submatrix(1, s, this.columns() + 1, c)
				}, h.prototype.submatrix = function(t, e, r, n) {
					if (!this.isInRange(t, r) || !this.isInRange(e, n) || t > e || r > n) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					for (var i = e - t + 1, o = n - r + 1, a = new h(i, o), s = t; s <= e; s++) a.__setRow(s - t + 1, this.__getRow(s)
						.slice(r - 1, n));
					return a
				}, h.prototype.augment = function(t) {
					var e = this.rows(),
						r = this.columns(),
						n = t.columns();
					if (e !== t.rows()) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Number of rows must match");
					for (var i = new h(e, r + n), o = 1; o <= r; o++) i.__setColumn(o, this.__getColumn(o));
					for (var a = 1; a <= n; a++) i.__setColumn(a + r, t.__getColumn(a));
					return i
				}, h.prototype.round = function() {
					return this.roundTo(0)
				}, h.prototype.roundTo = function(t) {
					t = o(t, l.options.roundTo.digits);
					var e = Math.pow(10, t);
					return this.fun((function(t) {
						return Math.round(t * e) / e
					}))
				}, h.prototype.abs = function() {
					return this.fun((function(t) {
						return Math.abs(t)
					}))
				}, h.prototype.addRow = function(t) {
					t = u(t);
					for (var e = this.rows(), r = new h(e + 1, this.columns()), n = 1; n <= e; n++) r.__setRow(n, this.__getRow(n));
					return r.__setRow(e + 1, t), r
				}, h.prototype.addColumn = function(t) {
					return this.copy()
						.augment(new h(u(t), null, 1))
				}, h.prototype.contains = function(t, r) {
					r = o(r, 0);
					var n, i = this.rows(),
						a = this.columns();
					if (!e(t) || !e(r)) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Parameter must be a number");
					for (var s = 1; s <= i; s++) {
						n = this.__getRow(s);
						for (var c = 0; c < a; c++)
							if (0 === r) {
								if (n[c] === t) return !0
							} else if (Math.abs(n[c] - t) <= r) return !0
					}
					return !1
				}, h.prototype.stringify = function(t, e) {
					t = a(t, l.options.stringify.rowSeparator), e = a(e, l.options.stringify.columnSeparator);
					for (var r, n = [], i = this.rows(), o = 1; o <= i; o++) r = this.__getRow(o), n.push(r.join(e));
					return n.join(t)
				}, h.prototype.equals = function(t) {
					var e, r, n = this.rows(),
						i = this.columns();
					if (!this.isSameSizeAs(t)) return !1;
					for (var o = 1; o <= n; o++) {
						e = this.__getRow(o), r = t.__getRow(o);
						for (var a = 0; a < i; a++)
							if (e[a] !== r[a]) return !1
					}
					return !0
				}, h.prototype.fun = function(t, e) {
					if (e = e || l.filters.all, "function" !== typeof t) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Applicator must be a function");
					if ("function" !== typeof e) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Filter must be a function");
					for (var r, n, i = this.rows(), o = this.columns(), a = new h(i, o), s = 1; s <= i; s++) {
						n = this.__getRow(s);
						for (var c = 1; c <= o; c++) r = n[c - 1], e(r, s, c) && (n[c - 1] = t(r, s, c));
						a.__setRow(s, n)
					}
					return a
				}, h.prototype.spfun = function(t) {
					return this.fun(t, l.filters.nonZero)
				}, h.prototype.pw_exp = function() {
					return this.fun(l.applicators.exp, null)
				}, h.prototype.pw_pow = function(t) {
					return this.fun((function(e) {
						return Math.pow(e, t)
					}), null)
				}, h.prototype.norm = function(t, e) {
					switch (t = a(t, l.options.norm.which), e = e || {}, t.toLowerCase()) {
						case "p":
						case "pnorm":
							return this.pnorm(Number(e));
						case "frobenius":
							return this.pnorm(2);
						case "rows":
						case "rowsum":
							return this.rownorm();
						case "columns":
						case "columnsum":
							return this.columnnorm();
						case "max":
							return this.maxnorm();
						default:
							throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Norm not supported")
					}
				}, h.prototype.pnorm = function(t) {
					if (!r(t)) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Parameter must be an integer");
					for (var e, n = 0, i = this.rows(), o = this.columns(), a = 1; a <= i; a++) {
						e = this.__getRow(a);
						for (var s = 0; s < o; s++) n += Math.pow(Math.abs(e[s]), t)
					}
					return Math.pow(n, 1 / t)
				}, h.prototype.maxnorm = function() {
					for (var t, e = 0, r = this.rows(), n = this.columns(), i = 1; i <= r; i++) {
						t = this.__getRow(i);
						for (var o = 0; o < n; o++) e = Math.max(e, Math.abs(t[o]))
					}
					return e
				}, h.prototype.rownorm = function() {
					for (var t = 0, e = this.rows(), r = 1; r <= e; r++) t = Math.max(t, this.__getRow(r)
						.toMatrix(1)
						.pnorm(1));
					return t
				}, h.prototype.columnnorm = function() {
					for (var t = 0, e = this.columns(), r = 1; r <= e; r++) t = Math.max(t, this.__getColumn(r)
						.toMatrix(null, 1)
						.pnorm(1));
					return t
				}, h.prototype.diag = function(t) {
					t = o(t, 0);
					var e = [],
						r = -Math.min(t, 0),
						n = Math.max(t, 0),
						i = 0 === r ? this.columns() - n : this.rows() - r;
					if (i <= 0) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					for (var a = 1; a <= i; a++) e.push(this.___get(a + r, a + n));
					return e
				}, h.prototype.isInRange = function(t, r) {
					return (!e(t) || t >= 1 && t <= this.rows()) && (!e(r) || r >= 1 && r <= this.columns())
				}, h.prototype.toArray = function() {
					return d(this.___getElements())
				}, h.zeros = function(t, e) {
					return e = o(e, t), new h(t, e)
				}, h.ones = function(t, e) {
					e = o(e, t);
					for (var r = new h(t, e), n = 1; n <= t; n++)
						for (var i = 1; i <= e; i++) r.___set(n, i, 1);
					return r
				}, h.eye = function(t) {
					for (var e = new h(t, t), r = 1; r <= t; r++) e.___set(r, r, 1);
					return e
				}, h.diag = function(t, e) {
					t = u(t), e = o(e, 0);
					for (var r = new h(t.length + Math.abs(e)), n = -Math.min(e, 0), i = Math.max(e, 0), a = 1; a <= t.length; a++) r.___set(a + n, a + i, t[a - 1]);
					return r
				}, h.random = function(t, e, r, n, i) {
					e = o(e, t), r = o(r, l.options.random.minVal), n = o(n, l.options.random.maxVal), i = s(i, l.options.random.onlyInteger);
					for (var a, c = new h(t, e), u = n - r + (i ? 1 : 0), d = 1; d <= t; d++)
						for (var f = 1; f <= e; f++) a = r + Math.random() * u, i && (a |= 0), c.___set(d, f, a);
					return c
				}, p.prototype.get = function(t, e) {
					if (!this.isInRange(t, e)) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					return this.___get(t, e)
				}, p.prototype.set = function(t, r, n) {
					if (!this.isInRange(t, r)) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					if (!e(n)) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Value has to be a number");
					return this.___set(t, r, n)
				}, p.prototype.getRow = function(t) {
					if (!this.isInRange(t, null)) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					return this.__getRow(t)
				}, p.prototype.__getRow = function(t) {
					for (var e = l.repeat(this.columns(), 0), r = this.___getRowPointer(), n = this.___getColumnIndicator(), i = this.___getElements(), o = r[t - 1]; o < r[t]; o++) e[n[o] - 1] = i[o];
					return e
				}, p.prototype.setRow = function(t, e) {
					if (!this.isInRange(t, null)) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					if (e.length !== this.columns()) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Wrong number of columns in row.");
					return this.__setRow(t, e)
				}, p.prototype.__setRow = function(t, e) {
					for (var r = this.columns(), n = 1; n <= r; n++) this.___set(t, n, e[n - 1]);
					return this
				}, p.prototype.getColumn = function(t) {
					if (!this.isInRange(null, t)) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					return this.__getColumn(t)
				}, p.prototype.__getColumn = function(t) {
					for (var e = [], r = this.rows(), n = 1; n <= r; n++) e.push(this.___get(n, t));
					return e
				}, p.prototype.setColumn = function(t, e) {
					if (!this.isInRange(null, t)) throw new f(f.ErrorCodes.OUT_OF_BOUNDS);
					if (e.length !== this.rows()) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Wrong number of rows in column");
					return this.__setColumn(t, e)
				}, p.prototype.__setColumn = function(t, e) {
					for (var r = this.rows(), n = 1; n <= r; n++) this.___set(n, t, e[n - 1]);
					return this
				}, p.prototype.isSameSizeAs = function(t) {
					return this.rows() === t.rows() && this.columns() === t.columns()
				}, p.prototype.isSquare = function() {
					return this.rows() === this.columns()
				}, p.prototype.isSymmetric = function() {
					if (!this.isSquare()) throw new f(f.ErrorCodes.DIMENSION_MISMATCH, "Matrix must be square");
					for (var t = this.rows(), e = 2; e <= t; e++)
						for (var r = 1; r < e; r++)
							if (this.___get(e, r) !== this.___get(r, e)) return !1;
					return !0
				}, p.prototype.dim = function(t) {
					switch (t) {
						case 1:
						case "rows":
							return this.rows();
						case 2:
						case "columns":
							return this.columns();
						case "max":
							return Math.max(this.rows(), this.columns());
						case "min":
							return Math.min(this.rows(), this.columns());
						default:
							throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Parameter must match a known value")
					}
				}, p.prototype.add = function(t) {
					var e = this.rows(),
						r = this.columns();
					if (arguments.length > 1) {
						var n = d(arguments);
						return this.add.apply(this.add(n.shift()), n)
					}
					if (!this.isSameSizeAs(t)) throw new f(f.ErrorCodes.DIMENSION_MISMATCH, "Matrices must be of the same size");
					for (var i, o, a = (new b)
						.size(e, r), s = 1; s <= e; s++) {
						i = this.__getRow(s), o = t.__getRow(s);
						for (var c = 1; c <= r; c++) a.set(s, c, i[c - 1] + o[c - 1])
					}
					return a.build()
				}, p.prototype.subtract = function(t) {
					var e = this.rows(),
						r = this.columns();
					if (arguments.length > 1) {
						var n = d(arguments);
						return this.subtract.apply(this.subtract(n.shift()), n)
					}
					if (!this.isSameSizeAs(t)) throw new f(f.ErrorCodes.DIMENSION_MISMATCH, "Matrices must be of the same size");
					for (var i, o, a = (new b)
						.size(e, r), s = 1; s <= e; s++) {
						i = this.__getRow(s), o = t.__getRow(s);
						for (var c = 1; c <= r; c++) a.set(s, c, i[c - 1] - o[c - 1])
					}
					return a.build()
				}, p.prototype.scale = function(t) {
					if (!e(t)) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Parameter must be a number");
					var r = this.rows(),
						n = this.columns();
					if (0 === t) return new p(r, n);
					if (1 === t) return this;
					for (var i = d(this.___getElements()), o = 0; o < i.length; o++) i[o] *= t;
					return new p(r, n, i, d(this.___getColumnIndicator()), d(this.___getRowPointer()))
				}, p.prototype.copy = function() {
					return new p(this.rows(), this.columns(), d(this.___getElements()), d(this.___getColumnIndicator()), d(this.___getRowPointer()))
				}, p.prototype.equals = function(t) {
					if (!this.isSameSizeAs(t)) return !1;
					for (var e = this.___getElements(), r = t.___getElements(), n = this.___getColumnIndicator(), i = t.___getColumnIndicator(), o = 0; o < e.length; o++)
						if (e[o] !== r[o] || n[o] !== i[o]) return !1;
					for (var a = this.___getRowPointer(), s = t.___getRowPointer(), c = 0; c < a.length; c++)
						if (a[c] !== s[c]) return !1;
					return !0
				}, p.prototype.stringify = function(t, e) {
					t = a(t, l.options.stringify.rowSeparator), e = a(e, l.options.stringify.columnSeparator);
					for (var r, n = [], i = this.rows(), o = this.columns(), s = 1; s <= i; s++) {
						r = [];
						for (var c = 1; c <= o; c++) r[c - 1] = this.___get(s, c);
						n.push(r.join(e))
					}
					return n.join(t)
				}, p.prototype.isInRange = function(t, r) {
					return (!e(t) || t >= 1 && t <= this.rows()) && (!e(r) || r >= 1 && r <= this.columns())
				}, p.zeros = function(t, e) {
					return e = o(e, t), new p(t, e)
				}, p.eye = function(t) {
					var e = l.repeat(t, 1),
						r = l.linspace(1, t),
						n = l.linspace(0, t);
					return new p(t, t, e, r, n)
				}, p.diag = function(t, e) {
					t = u(t), e = o(e, 0);
					for (var r = (new b)
						.size(t.length + Math.abs(e)), n = -Math.min(e, 0), i = Math.max(e, 0), a = 1; a <= t.length; a++) r.set(a + n, a + i, t[a - 1]);
					return r.build()
				}, l.options = {
					stringify: {
						rowSeparator: "\r\n",
						columnSeparator: "\t"
					},
					isTriangular: {
						mode: "both"
					},
					roundTo: {
						digits: 0
					},
					norm: {
						which: "max"
					},
					random: {
						minVal: 0,
						maxVal: 1,
						onlyInteger: !0
					}
				}, l.linspace = function(t, e, r) {
					r = o(r, 1);
					for (var n = [], i = t; i <= e; i += r) n.push(i);
					return n
				}, l.repeat = function(t, e) {
					for (var r = [], n = 1; n <= t; n++) r[n - 1] = e;
					return r
				}, l.filters = {
					all: function() {
						return !0
					},
					nonZero: function(t) {
						return 0 !== t
					},
					diag: function(t, e, r) {
						return e === r
					}
				}, l.applicators = {
					exp: function(t) {
						return Math.exp(t)
					},
					square: function(t) {
						return t * t
					}
				}, Array.prototype.toMatrix = function(t, e) {
					return new h(this, t, e)
				}, Array.prototype.toVector = function(t) {
					return t = s(t, !1), new h(this, t ? 1 : this.length, t ? this.length : 1)
				}, String.prototype.toMatrix = function(t, e) {
					t = a(t, "\r\n"), e = a(e, "\t");
					for (var r, n = this.split(t), i = 0, o = new h(0), s = 0; s < n.length; s++) {
						if (r = n[s].split(e), 0 === i && (i = r.length, o = new h(n.length, i)), r.length !== i) throw new f(f.ErrorCodes.INVALID_PARAMETERS, "Number of columns is inconsistent");
						for (var c = 1; c <= i; c++) o.___set(s + 1, c, Number(r[c - 1]))
					}
					return o
				}, t.Matrix = h, t.SparseMatrix = p, t.Vector = m, t.MatrixUtils = l, t.SparseBuilder = b
			})(window);
			var a = Matrix;

			function s(t) {
				return s = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t) {
					return typeof t
				} : function(t) {
					return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
				}, s(t)
			}

			function c(t, e) {
				var r = "undefined" !== typeof Symbol && t[Symbol.iterator] || t["@@iterator"];
				if (!r) {
					if (Array.isArray(t) || (r = u(t)) || e && t && "number" === typeof t.length) {
						r && (t = r);
						var n = 0,
							i = function() {};
						return {
							s: i,
							n: function() {
								return n >= t.length ? {
									done: !0
								} : {
									done: !1,
									value: t[n++]
								}
							},
							e: function(t) {
								throw t
							},
							f: i
						}
					}
					throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
				}
				var o, a = !0,
					s = !1;
				return {
					s: function() {
						r = r.call(t)
					},
					n: function() {
						var t = r.next();
						return a = t.done, t
					},
					e: function(t) {
						s = !0, o = t
					},
					f: function() {
						try {
							a || null == r.return || r.return()
						} finally {
							if (s) throw o
						}
					}
				}
			}

			function u(t, e) {
				if (t) {
					if ("string" === typeof t) return d(t, e);
					var r = Object.prototype.toString.call(t)
						.slice(8, -1);
					return "Object" === r && t.constructor && (r = t.constructor.name), "Map" === r || "Set" === r ? Array.from(t) : "Arguments" === r || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r) ? d(t, e) : void 0
				}
			}

			function d(t, e) {
				(null == e || e > t.length) && (e = t.length);
				for (var r = 0, n = new Array(e); r < e; r++) n[r] = t[r];
				return n
			}
			var l = function(t, e, r) {
					var i, o = r[Object.keys(r)[0]]["json"]["ofd:Area"];
					if (o) {
						var a = o["ofd:PhysicalBox"];
						if (a) i = a;
						else {
							var s = o["ofd:ApplicationBox"];
							if (s) i = s;
							else {
								var c = o["ofd:ContentBox"];
								c && (i = c)
							}
						}
					} else {
						var u = e["ofd:CommonData"]["ofd:PageArea"];
						"undefined" === typeof u && (u = e["ofd:CommonData"]["PageArea"]);
						var d = u["ofd:PhysicalBox"];
						if ("undefined" === typeof d && (d = u["PhysicalBox"]), d) i = d;
						else {
							var l = u["ofd:ApplicationBox"];
							if (l) i = l;
							else {
								var f = u["ofd:ContentBox"];
								f && (i = f)
							}
						}
					}
					var h = i.split(" "),
						p = ((t - 30) / parseFloat(h[2]))
						.toFixed(1) / 96 * 25.4;
					return Object(n["m"])(p), Object(n["n"])(p), i = Object(n["k"])(i), i = Object(n["d"])(i), i
				},
				f = function(t, e) {
					var r, i = e[Object.keys(e)[0]]["json"]["ofd:Area"];
					if (i) {
						var o = i["ofd:PhysicalBox"];
						if (o) r = o;
						else {
							var a = i["ofd:ApplicationBox"];
							if (a) r = a;
							else {
								var s = i["ofd:ContentBox"];
								s && (r = s)
							}
						}
					} else {
						var c = t["ofd:CommonData"]["ofd:PageArea"];
						"undefined" === typeof c && (c = t["ofd:CommonData"]["PageArea"]);
						var u = c["ofd:PhysicalBox"];
						if ("undefined" === typeof u && (u = c["PhysicalBox"]), u) r = u;
						else {
							var d = c["ofd:ApplicationBox"];
							if (d) r = d;
							else {
								var l = c["ofd:ContentBox"];
								l && (r = l)
							}
						}
					}
					return r = Object(n["k"])(r), r = Object(n["d"])(r), r
				},
				h = function(t, e, r, i, o, a, s) {
					var u = Object.keys(e)[0],
						d = e[u]["json"]["ofd:Template"];
					if (d) {
						var l = [];
						if (r[d["@_TemplateID"]]) {
							var f = r[d["@_TemplateID"]]["json"]["ofd:Content"]["ofd:Layer"];
							l = l.concat(f)
						}
						var h, g = c(l);
						try {
							for (g.s(); !(h = g.n())
								.done;) {
								var y = h.value;
								y && b(t, i, o, a, s, y, !1, null, null, null, !0)
							}
						} catch (B) {
							g.e(B)
						} finally {
							g.f()
						}
					}
					if (e[u]["json"]["ofd:Content"]) {
						var S = e[u]["json"]["ofd:Content"]["ofd:Layer"],
							w = [];
						w = w.concat(S);
						var C, _ = c(w);
						try {
							for (_.s(); !(C = _.n())
								.done;) {
								var A = C.value;
								A && b(t, i, o, a, s, A, !1)
							}
						} catch (B) {
							_.e(B)
						} finally {
							_.f()
						}
					}
					if (e[u].stamp) {
						var I, E = e[u].json.pfIndex,
							T = c(e[u].stamp);
						try {
							for (T.s(); !(I = T.n())
								.done;) {
								var x = I.value;
								if ("ofd" === x.type) m(t, x.obj.pages, x.obj.tpls, !0, x.stamp.stampAnnot, x.obj.fontResObj, x.obj.drawParamResObj, x.obj.multiMediaResObj, s, x.stamp.sealObj.SES_Signature, x.stamp.signedInfo, E);
								else if ("png" === x.type) {
									var P = Object(n["d"])(x.obj.boundary),
										k = (Array.isArray(x.stamp.stampAnnot) ? x.stamp.stampAnnot[0]["@_ID"] : x.stamp.stampAnnot["@_ID"]) + E,
										D = v(t.style.width, t.style.height, a, x.obj.img, P, x.obj.clip, !0, x.stamp.sealObj.SES_Signature, x.stamp.signedInfo, k);
									t.appendChild(D)
								}
							}
						} catch (B) {
							T.e(B)
						} finally {
							T.f()
						}
					}
					if (e[u].annotation) {
						var O, R = e[u].json.pfIndex,
							N = c(e[u].annotation);
						try {
							for (N.s(); !(O = N.n())
								.done;) {
								var M = O.value;
								p(t, M, i, o, a, s, R)
							}
						} catch (B) {
							N.e(B)
						} finally {
							N.f()
						}
					}
				},
				p = function(t, e, r, i, o, a, s) {
					var c = document.createElement("div");
					if (c.setAttribute("style", "overflow: hidden;z-index:0;position:relative;"), "undefined" != typeof e["appearance"]) {
						var u = e["appearance"]["@_Boundary"];
						if (u) {
							var d = Object(n["d"])(Object(n["k"])(u));
							c.setAttribute("style", "overflow: hidden;z-index:0;position:absolute; left: ".concat(d.x, "px; top: ")
								.concat(d.y, "px; width: ")
								.concat(d.w, "px; height: ")
								.concat(d.h, "px"))
						} else c.setAttribute("style", "overflow: visible;z-index:".concat(e["@_ID"] + s, ";position:absolute; left: 0px; top: 0px; width: 1px; height: 1px"));
						var l = e["appearance"];
						b(c, r, i, o, a, l, !1), t.appendChild(c)
					}
				},
				m = function(t, e, r, i, o, a, s, u, d, l, f, h) {
					var p, m = c(e);
					try {
						for (m.s(); !(p = m.n())
							.done;) {
							var g = p.value,
								y = Object.keys(g)[0],
								v = {
									x: 0,
									y: 0,
									w: 0,
									h: 0
								};
							i && o && (v = o.boundary);
							var S = Object(n["d"])(v),
								w = document.createElement("div");
							w.setAttribute("name", "seal_img_div"), w.setAttribute("style", "z-index:".concat(h + 1e4, ";cursor: pointer; position:relative; left: ")
								.concat(S.x, "px; top: ")
								.concat(S.y, "px; width: ")
								.concat(S.w, "px; height: ")
								.concat(S.h, "px")), w.setAttribute("data-ses-signature", "".concat(JSON.stringify(l))), w.setAttribute("data-signed-info", "".concat(JSON.stringify(f)));
							var C = g[y]["json"]["ofd:Template"];
							if (C) {
								var _ = r[C["@_TemplateID"]]["json"]["ofd:Content"]["ofd:Layer"],
									A = [];
								A = A.concat(_);
								var I, E = c(A);
								try {
									for (E.s(); !(I = E.n())
										.done;) {
										var T = I.value;
										T && b(w, a, s, u, d, T, i)
									}
								} catch (R) {
									E.e(R)
								} finally {
									E.f()
								}
							}
							var x = g[y]["json"]["ofd:Content"]["ofd:Layer"],
								P = [];
							P = P.concat(x);
							var k, D = c(P);
							try {
								for (D.s(); !(k = D.n())
									.done;) {
									var O = k.value;
									O && b(w, a, s, u, d, O, i)
								}
							} catch (R) {
								D.e(R)
							} finally {
								D.f()
							}
							t.appendChild(w)
						}
					} catch (R) {
						m.e(R)
					} finally {
						m.f()
					}
				},
				b = function t(e, r, i, o, a, s, u, d, l, f, h) {
					var p = null,
						m = null,
						b = Object(n["e"])(.353),
						y = s["@_DrawParam"];
					if (y && Object.keys(i)
						.length > 0 && i[y]) {
						if (i[y]["relative"]) {
							var v = i[y]["relative"];
							i[v]["FillColor"] && (p = Object(n["i"])(i[v]["FillColor"])), i[v]["StrokeColor"] && (m = Object(n["i"])(i[v]["StrokeColor"])), i[v]["LineWidth"] && (b = Object(n["e"])(i[v]["LineWidth"]))
						}
						i[y]["FillColor"] && (p = Object(n["i"])(i[y]["FillColor"])), i[y]["StrokeColor"] && (m = Object(n["i"])(i[y]["StrokeColor"])), i[y]["LineWidth"] && (b = Object(n["e"])(i[y]["LineWidth"]))
					}
					var C = s["ofd:ImageObject"],
						_ = [];
					_ = _.concat(C);
					var A, I = c(_);
					try {
						for (I.s(); !(A = I.n())
							.done;) {
							var E = A.value;
							if (E) {
								var T = E["@_ResourceID"];
								if (null === o[T] || void 0 === o[T]) continue;
								var x = g(e.style.width, e.style.height, o, E, u, l, h);
								e.appendChild(x)
							}
						}
					} catch (ot) {
						I.e(ot)
					} finally {
						I.f()
					}
					var P = s["ofd:PathObject"],
						k = [];
					k = k.concat(P);
					var D, O = c(k);
					try {
						for (O.s(); !(D = O.n())
							.done;) {
							var R = D.value;
							if (R) {
								var N = w(i, R, p, m, b, u, d, l, f);
								e.appendChild(N)
							}
						}
					} catch (ot) {
						O.e(ot)
					} finally {
						O.f()
					}
					var M = s["ofd:TextObject"],
						B = [];
					B = B.concat(M);
					var F, j = c(B);
					try {
						for (j.s(); !(F = j.n())
							.done;) {
							var K = F.value;
							if (K) {
								var L = S(r, K, p, m, i);
								e.appendChild(L)
							}
						}
					} catch (ot) {
						j.e(ot)
					} finally {
						j.f()
					}
					var U = s["ofd:CompositeObject"],
						X = [];
					X = X.concat(U);
					var z, G = c(X);
					try {
						for (G.s(); !(z = G.n())
							.done;) {
							var q = z.value;
							if (q) {
								var W, V = c(a);
								try {
									for (V.s(); !(W = V.n())
										.done;) {
										var H = W.value;
										if (H["@_ID"] === q["@_ResourceID"]) {
											var Y = q["@_Alpha"],
												Z = q["@_Boundary"],
												Q = q["@_CTM"];
											if (Z) {
												var J = Object(n["d"])(Object(n["k"])(Z)),
													$ = document.createElement("div");
												$.setAttribute("style", "position:absolute; left: ".concat(J.x, "px; top: ")
													.concat(J.y, "px; width: ")
													.concat(J.w, "px; height: ")
													.concat(J.h, "px")), e.appendChild($), t($, r, i, o, a, H["ofd:Content"], !1, Y, null, Q)
											} else t(e, r, i, o, a, H["ofd:Content"], !1, Y, Z, Q);
											break
										}
									}
								} catch (ot) {
									V.e(ot)
								} finally {
									V.f()
								}
							}
						}
					} catch (ot) {
						G.e(ot)
					} finally {
						G.f()
					}
					var tt = s["ofd:PageBlock"],
						et = [];
					et = et.concat(tt);
					var rt, nt = c(et);
					try {
						for (nt.s(); !(rt = nt.n())
							.done;) {
							var it = rt.value;
							it && t(e, r, i, o, a, it, u)
						}
					} catch (ot) {
						nt.e(ot)
					} finally {
						nt.f()
					}
				},
				g = function(t, e, r, i, o, a, s) {
					var c = Object(n["k"])(i["@_Boundary"]);
					c = Object(n["d"])(c);
					var u = i["@_ResourceID"];
					if ("gbig2" === r[u].format) {
						var d = r[u].img,
							l = r[u].width,
							f = r[u].height;
						return y(d, l, f, c, i["@_ID"])
					}
					var h = i["@_CTM"];
					return v(t, e, r, r[u].img, c, !1, o, null, null, i["@_ID"], h, a, s, i)
				},
				y = function(t, e, r, n, i) {
					for (var o = new Uint8ClampedArray(4 * e * r), a = 0; a < t.length; a++) o[4 * a] = t[a], o[4 * a + 1] = t[a], o[4 * a + 2] = t[a], o[4 * a + 3] = 255;
					var s = new ImageData(o, e, r),
						c = document.createElement("canvas");
					c.width = e, c.height = r;
					var u = c.getContext("2d");
					return u.putImageData(s, 0, 0), c.setAttribute("style", "left: ".concat(n.x, "px; top: ")
						.concat(n.y, "px; width: ")
						.concat(n.w, "px; height: ")
						.concat(n.h, "px;z-index: ")
						.concat(i)), c.style.position = "absolute", c
				},
				v = function(t, e, r, i, o, a, c, u, d, l, f, h, p, m) {
					var b = document.createElement("div");
					c && (b.setAttribute("name", "seal_img_div"), b.setAttribute("data-ses-signature", "".concat(JSON.stringify(u))), b.setAttribute("data-signed-info", "".concat(JSON.stringify(d))));
					var g = document.createElement("img");
					if ("object" === s(i) ? g.src = i.img : g.src = i, c && (g.setAttribute("width", "100%"), g.setAttribute("height", "100%"), g.setAttribute("style", "opacity:0.85")), "undefined" != typeof m) {
						var y = m["@_Alpha"];
						"undefined" != typeof y && g.setAttribute("style", "opacity:".concat(y / 255, ";"))
					}
					var v = 0,
						S = 0,
						w = 0,
						C = 0,
						_ = "";
					if (f) {
						var A = Object(n["j"])(f);
						if (g.setAttribute("width", "".concat(Object(n["e"])(A[0]), "px")), g.setAttribute("height", "".concat(Object(n["e"])(A[3]), "px")), w = Object(n["e"])(A[0]), C = Object(n["e"])(A[3]), v = Object(n["e"])(A[4]), S = Object(n["e"])(A[5]), 0 == A[1] && 0 == A[2] && A[0] * A[3] < 0 && (g.setAttribute("style", "transform:rotateX(180deg);"), S += Object(n["e"])(A[3])), 0 != A[1] && 0 != A[2] && A[1] * A[2] < 0) {
							var I = -1 * Math.atan2(Math.sqrt(-1 * A[1] * A[2]), Math.sqrt(A[0] * A[3])) * 180 / Math.PI;
							_ = "transform:rotate(".concat(I, "deg);")
						}
					}
					h && (g.setAttribute("width", "100%"), g.setAttribute("height", "100%"), g.removeAttribute("transform")), b.appendChild(g);
					var E = parseFloat(t.replace("px", "")),
						T = parseFloat(e.replace("px", "")),
						x = o.w > E ? E : o.w,
						P = o.h > T ? T : o.h,
						k = "";
					a && (a = Object(n["d"])(a), k = "clip: rect(".concat(a.y, "px, ")
						.concat(a.w + a.x, "px, ")
						.concat(a.h + a.y, "px, ")
						.concat(a.x, "px)"));
					var D = 0,
						O = 0;
					return k ? (D = o.x, O = o.y) : (D = o.x + v < 0 ? 0 : o.x + v, O = o.y + S < 0 ? 0 : o.y + S), w > 0 && (x = w, P = C), p ? b.setAttribute("style", "cursor: pointer; overflow: hidden; position: absolute; left: ".concat(D, "px; top: ")
						.concat(O, "px; width: ")
						.concat(x, "px; height: ")
						.concat(P, "px; ")
						.concat(k, ";")) : b.setAttribute("style", "cursor: pointer; overflow: hidden; position: absolute; left: ".concat(D, "px; top: ")
						.concat(O, "px; width: ")
						.concat(x, "px; height: ")
						.concat(P, "px; ")
						.concat(k, ";z-index: ")
						.concat(l, "; ")
						.concat(_)), b
				},
				S = function(t, e, r, i, a) {
					var s = 1,
						u = Object(n["k"])(e["@_Boundary"]);
					u = Object(n["d"])(u);
					u.x, u.y;
					var d = e["@_CTM"],
						l = e["@_HScale"],
						f = e["@_Font"],
						h = e["@_Weight"],
						p = "";
					"undefined" != typeof h && (p = "font-weight:".concat(h, ";"));
					var m = e["@_Italic"],
						b = "";
					"true" == m && (b = "font-style:italic;");
					var g = e["@_Alpha"],
						y = "";
					"undefined" != typeof g && (y = "fill-opacity:".concat(g / 255, ";"));
					var v = Object(n["e"])(parseFloat(e["@_Size"])),
						S = [];
					S = S.concat(e["ofd:TextCode"]);
					var w = Object(n["b"])(S),
						_ = document.createElementNS("http://www.w3.org/2000/svg", "svg");
					_.setAttribute("version", "1.1");
					var A = e["ofd:FillColor"],
						I = !1,
						E = e["@_DrawParam"];
					if (E && Object.keys(a)
						.length > 0 && a[E] && a[E]["FillColor"] && (r = Object(n["i"])(a[E]["FillColor"])), A) {
						A["@_Value"] && (r = Object(n["i"])(A["@_Value"]));
						var T = A["@_Alpha"];
						T && (s = T > 1 ? T / 255 : T);
						var x = A["ofd:AxialShd"];
						if (x) {
							I = !0;
							var P = document.createElement("linearGradient");
							P.setAttribute("id", "".concat(e["@_ID"])), P.setAttribute("x1", "0%"), P.setAttribute("y1", "0%"), P.setAttribute("x2", "100%"), P.setAttribute("y2", "100%");
							var k, D = c(x["ofd:Segment"]);
							try {
								for (D.s(); !(k = D.n())
									.done;) {
									var O = k.value;
									if (O) {
										var R = document.createElement("stop");
										R.setAttribute("offset", "".concat(100 * O["@_Position"], "%")), R.setAttribute("style", "stop-color:".concat(Object(n["i"])(O["ofd:Color"]["@_Value"]), ";stop-opacity:1")), P.appendChild(R), r = Object(n["i"])(O["ofd:Color"]["@_Value"])
									}
								}
							} catch (Dt) {
								D.e(Dt)
							} finally {
								D.f()
							}
							_.appendChild(P)
						}
					}
					var N = u.w,
						M = u.h,
						B = u.x,
						F = u.y,
						j = v,
						K = v;
					if (d) {
						var L = Object(n["j"])(d),
							U = L[0],
							X = L[1],
							z = L[2],
							G = L[3],
							q = function(t) {
								return 2 * (t >= 0) - 1
							},
							W = U > 0 ? q(U) * Math.sqrt(U * U + z * z) : Math.sqrt(U * U + z * z),
							V = G > 0 ? q(G) * Math.sqrt(X * X + G * G) : Math.sqrt(X * X + G * G),
							H = Math.atan2(-X, G);
						0 == H && 0 != U && 1 == G || (j *= W, K *= V), 0 == H && l > 0 && (j *= l)
					}
					var Y, Z = e["ofd:CGTransform"];
					if ("undefined" != typeof Z)
						if (Z instanceof Array) {
							var Q, J = "",
								$ = c(Z);
							try {
								for ($.s(); !(Q = $.n())
									.done;) {
									var tt = Q.value;
									tt && (J += tt["ofd:Glyphs"])
								}
							} catch (Dt) {
								$.e(Dt)
							} finally {
								$.f()
							}
							Y = J.split(" ")
						} else {
							var et = Z["ofd:Glyphs"];
							Y = et.split(" ")
						} var rt, nt = 0,
						it = c(w);
					try {
						for (it.s(); !(rt = it.n())
							.done;) {
							var ot = rt.value;
							if (ot && !isNaN(ot.x)) {
								var at = !1;
								if ("undefined" != typeof Z && null != t[f].fontByte && ot.text.charCodeAt() > 32 && 127 != ot.text.charCodeAt()) {
									var st = o.parse(t[f].fontByte)[0];
									if (null != st.head) {
										var ct = Y[nt],
											ut = o.U.glyphToPath(st, ct),
											dt = o.U.pathToSVG(ut),
											lt = document.createElementNS("http://www.w3.org/2000/svg", "g");
										I ? lt.setAttribute("style", "fill:".concat(r, ";stroke:none")) : lt.setAttribute("style", "fill:".concat(r, ";stroke:")
											.concat(i, ";fill-opacity:")
											.concat(s, ";"));
										var ft = j / st.head.unitsPerEm,
											ht = K / st.head.unitsPerEm;
										if (d) {
											var pt = Object(n["j"])(d),
												mt = (ot.x, pt[0], ot.y, pt[2], ot.y, pt[3], Object(n["e"])(pt[5]), C(l, pt, u, ot.x, ot.y, v, st.head.unitsPerEm));
											lt.setAttribute("transform", "matrix(".concat(mt.getRow(1)[0], ", ")
												.concat(mt.getRow(1)[1], ", ")
												.concat(mt.getRow(2)[0], ", ")
												.concat(mt.getRow(2)[1], ", ")
												.concat(mt.getRow(3)[0], ", ")
												.concat(mt.getRow(3)[1], ")"))
										} else {
											var bt = ot.x,
												gt = ot.y;
											lt.setAttribute("transform", "matrix(".concat(ft, ", 0, 0, ")
												.concat(-ht, ", ")
												.concat(bt, ",")
												.concat(gt, ")"))
										}
										var yt = document.createElementNS("http://www.w3.org/2000/svg", "path");
										yt.setAttribute("d", dt), lt.appendChild(yt), _.appendChild(lt), at = !0
									} else {
										ct = Y[nt], ut = o.U.glyphToPath(st, ct), dt = o.U.pathToSVG(ut);
										var vt = document.createElementNS("http://www.w3.org/2000/svg", "g");
										I ? vt.setAttribute("style", "fill:".concat(r, ";stroke:none")) : vt.setAttribute("style", "fill:".concat(r, ";stroke:")
											.concat(i, ";fill-opacity:")
											.concat(s, ";"));
										var St = .001;
										st["CFF "] && st["CFF "].FontMatrix && (St = st["CFF "].FontMatrix[0]);
										var wt = j * St,
											Ct = K * St;
										if (d) {
											var _t = Object(n["j"])(d),
												At = (ot.x, _t[0], ot.y, _t[2], ot.y, _t[3], Object(n["e"])(_t[5]), C(l, _t, u, ot.x, ot.y, v, 1 / St));
											vt.setAttribute("transform", "matrix(".concat(At.getRow(1)[0], ", ")
												.concat(At.getRow(1)[1], ", ")
												.concat(At.getRow(2)[0], ", ")
												.concat(At.getRow(2)[1], ", ")
												.concat(At.getRow(3)[0], ", ")
												.concat(At.getRow(3)[1], ")"))
										} else {
											var It = ot.x,
												Et = ot.y;
											vt.setAttribute("transform", "matrix(".concat(wt, ", 0, 0, ")
												.concat(-Ct, ", ")
												.concat(It, ",")
												.concat(Et, ")"))
										}
										var Tt = document.createElementNS("http://www.w3.org/2000/svg", "path");
										Tt.setAttribute("d", dt), vt.appendChild(Tt), _.appendChild(vt), at = !0
									}
								}
								if (!at) {
									var xt = document.createElementNS("http://www.w3.org/2000/svg", "text");
									xt.setAttribute("x", ot.x), xt.setAttribute("y", ot.y);
									var Pt = document.createTextNode(ot.text);
									if (xt.appendChild(Pt), d) {
										var kt = Object(n["j"])(d);
										xt.setAttribute("transform", "matrix(".concat(kt[0], " ")
											.concat(kt[1], " ")
											.concat(kt[2], " ")
											.concat(kt[3], " ")
											.concat(Object(n["e"])(kt[4]), " ")
											.concat(Object(n["e"])(kt[5]), ")"))
									}
									l && xt.setAttribute("transform", "matrix(".concat(l, ", 0, 0, 1, ")
										.concat((1 - l) * ot.x, ", 0)")), I ? xt.setAttribute("fill", r) : (xt.setAttribute("fill", i), xt.setAttribute("fill", r), xt.setAttribute("fill-opacity", s)), xt.setAttribute("style", "".concat(b, " ")
										.concat(p, " ")
										.concat(y, " font-size:")
										.concat(v, "px;font-family: ")
										.concat(Object(n["g"])(t[f]), ";")), _.appendChild(xt)
								}
							}
							nt++
						}
					} catch (Dt) {
						it.e(Dt)
					} finally {
						it.f()
					}
					return _.setAttribute("style", "overflow:visible;position:absolute;width:".concat(N, "px;height:")
						.concat(M, "px;left:")
						.concat(B, "px;top:")
						.concat(F, "px;z-index:")
						.concat(e["@_ID"])), _
				},
				w = function(t, e, r, i, o, a, s, u, d) {
					var l = document.createElementNS("http://www.w3.org/2000/svg", "svg");
					l.setAttribute("version", "1.1");
					var f = Object(n["k"])(e["@_Boundary"]);
					if (!f) return l;
					f = Object(n["d"])(f);
					var h = e["@_LineWidth"],
						p = e["ofd:AbbreviatedData"];
					if (!p) return l;
					var m = Object(n["a"])(Object(n["c"])(p)),
						b = e["@_CTM"],
						g = document.createElementNS("http://www.w3.org/2000/svg", "path");
					h && (o = Object(n["e"])(h));
					var y = e["@_DrawParam"];
					if (y && t[y] && (h = t[y].LineWidth, h && (o = Object(n["e"])(h))), b) {
						var v = Object(n["j"])(b);
						g.setAttribute("transform", "matrix(".concat(v[0], " ")
							.concat(v[1], " ")
							.concat(v[2], " ")
							.concat(v[3], " ")
							.concat(Object(n["e"])(v[4]), " ")
							.concat(Object(n["e"])(v[5]), ")"))
					}
					var S = e["ofd:StrokeColor"];
					if (S) {
						S["@_Value"] && (i = Object(n["i"])(S["@_Value"]));
						var w = S["ofd:AxialShd"];
						if (w) {
							!0;
							var C = document.createElement("linearGradient");
							C.setAttribute("id", "".concat(e["@_ID"])), C.setAttribute("x1", "0%"), C.setAttribute("y1", "0%"), C.setAttribute("x2", "100%"), C.setAttribute("y2", "100%");
							var _, A = c(w["ofd:Segment"]);
							try {
								for (A.s(); !(_ = A.n())
									.done;) {
									var I = _.value;
									if (I) {
										var E = document.createElement("stop");
										E.setAttribute("offset", "".concat(100 * I["@_Position"], "%")), E.setAttribute("style", "stop-color:".concat(Object(n["i"])(I["ofd:Color"]["@_Value"]), ";stop-opacity:1")), C.appendChild(E), i = Object(n["i"])(I["ofd:Color"]["@_Value"])
									}
								}
							} catch ($) {
								A.e($)
							} finally {
								A.f()
							}
							l.appendChild(C)
						}
					} else y && t[y] && t[y].StrokeColor && (i = Object(n["i"])(t[y].StrokeColor));
					var T = e["ofd:FillColor"];
				    var url = window.location.href;
				    var spliceLength2 = url.lastIndexOf("=");
                    var pathType = url.slice(spliceLength2 + 1);
					if (T) {
							if(pathType ==1){
					T["@_Value"] && ((T["@_Value"])), T["@_Alpha"] && 0 == T["@_Alpha"] && (r = "none");	
					}else{
					T["@_Value"] && (r = Object(n["i"])(T["@_Value"])), T["@_Alpha"] && 0 == T["@_Alpha"] && (r = "none");
					}
						var x = T["ofd:AxialShd"];
						if (x) {
							!0;
							var P = document.createElement("linearGradient");
							P.setAttribute("id", "".concat(e["@_ID"])), P.setAttribute("x1", "0%"), P.setAttribute("y1", "0%"), P.setAttribute("x2", "100%"), P.setAttribute("y2", "100%");
							var k, D = c(x["ofd:Segment"]);
							try {
								for (D.s(); !(k = D.n())
									.done;) {
									var O = k.value;
									if (O) {
										var R = document.createElement("stop");
										R.setAttribute("offset", "".concat(100 * O["@_Position"], "%")), R.setAttribute("style", "stop-color:".concat(Object(n["i"])(O["ofd:Color"]["@_Value"]), ";stop-opacity:1")), P.appendChild(R), r = Object(n["i"])(O["ofd:Color"]["@_Value"])
									}
								}
							} catch ($) {
								D.e($)
							} finally {
								D.f()
							}
							l.appendChild(P)
						}
					} else y && t[y] && t[y].FillColor && (r = Object(n["i"])(t[y].FillColor));
					o > 0 && !i && (i = r, i || (i = "rgb(0, 0, 0)"));
					var N = e["@_Alpha"];
					if ("undefined" != typeof N ? g.setAttribute("fill-opacity", "".concat(N / 255)) : s && g.setAttribute("fill-opacity", "".concat(s / 255)), "false" != e["@_Stroke"] && (g.setAttribute("stroke", "".concat(i)), g.setAttribute("stroke-width", "".concat(o, "px")), g.setAttribute("fill", "none")), e.hasOwnProperty("@_Fill") || (r = "none"), "false" != e["@_Fill"] && g.setAttribute("fill", "".concat(r || "none")), e["@_Join"] && g.setAttribute("stroke-linejoin", "".concat(e["@_Join"])), e["@_Cap"] && g.setAttribute("stroke-linecap", "".concat(e["@_Cap"])), e["@_DashPattern"]) {
						var M = e["@_DashPattern"],
							B = Object(n["j"])(M),
							F = 0;
						e["@_DashOffset"] && (F = e["@_DashOffset"]), g.setAttribute("stroke-dasharray", "".concat(Object(n["e"])(B[0]), ",")
							.concat(Object(n["e"])(B[1]))), g.setAttribute("stroke-dashoffset", "".concat(Object(n["e"])(F), "px"))
					}
					var j, K = "",
						L = c(m);
					try {
						for (L.s(); !(j = L.n())
							.done;) {
							var U = j.value;
							"M" === U.type ? K += "M".concat(U.x, " ")
								.concat(U.y, " ") : "L" === U.type ? K += "L".concat(U.x, " ")
								.concat(U.y, " ") : "B" === U.type ? K += "C".concat(U.x1, " ")
								.concat(U.y1, " ")
								.concat(U.x2, " ")
								.concat(U.y2, " ")
								.concat(U.x3, " ")
								.concat(U.y3, " ") : "Q" === U.type ? K += "Q".concat(U.x1, " ")
								.concat(U.y1, " ")
								.concat(U.x2, " ")
								.concat(U.y2, " ") : "A" === U.type ? K += "A".concat(U.rx, ",")
								.concat(U.ry, " ")
								.concat(U.rotation, " ")
								.concat(U.arc, ",")
								.concat(U.sweep, " ")
								.concat(U.x, ",")
								.concat(U.y) : "C" === U.type && (K += "Z")
						}
					} catch ($) {
						L.e($)
					} finally {
						L.f()
					}
					g.setAttribute("d", K), l.appendChild(g);
					var X = a ? f.w : Math.ceil(f.w),
						z = a ? f.h : Math.ceil(f.h),
						G = f.x,
						q = f.y;
					if (l.setAttribute("style", "overflow:visible;position:absolute;width:".concat(X, "px;height:")
						.concat(z, "px;left:")
						.concat(G, "px;top:")
						.concat(q, "px;z-index:")
						.concat(e["@_ID"])), u) {
						var W = document.createElementNS("http://www.w3.org/2000/svg", "svg");
						W.setAttribute("version", "1.1");
						var V = Object(n["k"])(u);
						V = Object(n["d"])(V);
						var H = Math.ceil(V.w),
							Y = Math.ceil(V.h),
							Z = V.x,
							Q = V.y;
						if (W.setAttribute("style", "overflow:hidden;position:absolute;width:".concat(H, "px;height:")
							.concat(Y, "px;left:")
							.concat(Z, "px;top:")
							.concat(Q, "px;z-index:")
							.concat(e["@_ID"])), d) {
							var J = Object(n["j"])(d);
							l.setAttribute("transform", "matrix(".concat(J[0], " ")
								.concat(J[1], " ")
								.concat(J[2], " ")
								.concat(J[3], " ")
								.concat(Object(n["e"])(J[4]), " ")
								.concat(Object(n["e"])(J[5]), ")"))
						}
						return W.appendChild(l), W
					}
					return l
				},
				C = function(t, e, r, n, i, o, s, c) {
					var u = new a([1, 0, 0, 0, -1, 0, 0, 0, 1]);
					"undefined" == typeof t && (t = 1), u = _(u, Number(t), 1);
					var d = new a([1 / s, 0, 0, 0, 1 / s, 0, 0, 0, 1]);
					if (u = u.multiply(d), u = _(u, o / 3.7795, o / 3.7795), u = A(u, n / 3.7795, i / 3.7795), null != e) {
						var l = new a([Number(e[0]), Number(e[1]), 0, Number(e[2]), Number(e[3]), 0, Number(e[4]), Number(e[5]), 1]);
						u = u.multiply(l)
					}
					return "undefined" == typeof c && (c = new a([3.7795, 0, 0, 0, 3.7795, 0, 0, 0, 1])), u = u.multiply(c), u
				},
				_ = function(t, e, r) {
					var n = new a([e, 0, 0, 0, r, 0, 0, 0, 1]);
					return t.multiply(n)
				},
				A = function(t, e, r) {
					var n = new a([1, 0, 0, 0, 1, 0, e, r, 1]);
					return t.multiply(n)
				}
		},
		"7f3b": function(t, e, r) {
			"use strict";
			(function(t) {
				var e = r("d00a");
				"undefined" !== typeof PDFJSDev && PDFJSDev.test("SKIP_BABEL") || "undefined" !== typeof globalThis && globalThis._pdfjsCompatibilityChecked || ("undefined" !== typeof globalThis && globalThis.Math === Math || (globalThis = r("eb73")), globalThis._pdfjsCompatibilityChecked = !0, function() {
					!globalThis.btoa && e["a"] && (globalThis.btoa = function(e) {
						return t.from(e, "binary")
							.toString("base64")
					})
				}(), function() {
					!globalThis.atob && e["a"] && (globalThis.atob = function(e) {
						return t.from(e, "base64")
							.toString("binary")
					})
				}(), function() {
					String.prototype.startsWith || r("d2a2")
				}(), function() {
					String.prototype.endsWith || r("8f4c")
				}(), function() {
					String.prototype.includes || r("4661")
				}(), function() {
					Array.prototype.includes || r("bf2c")
				}(), function() {
					Array.from || r("6b84")
				}(), function() {
					Object.assign || r("2418")
				}(), function() {
					Object.fromEntries || r("8ac5")
				}(), function() {
					Math.log2 || (Math.log2 = r("dc57"))
				}(), function() {
					Number.isNaN || (Number.isNaN = r("9020"))
				}(), function() {
					Number.isInteger || (Number.isInteger = r("f2e6"))
				}(), function() {
					Uint8Array.prototype.slice || r("8f2a")
				}(), function() {
					"undefined" !== typeof PDFJSDev && PDFJSDev.test("IMAGE_DECODERS") || !(globalThis.Promise == null) && globalThis.Promise.allSettled || (globalThis.Promise = r("3980"))
				}(), function() {
					"undefined" !== typeof PDFJSDev && PDFJSDev.test("PRODUCTION") && PDFJSDev.test("GENERIC") && (PDFJSDev.test("IMAGE_DECODERS") || (globalThis.URL = r("14d8")))
				}(), function() {
					if ("undefined" === typeof PDFJSDev || !PDFJSDev.test("IMAGE_DECODERS")) {
						var t = !1;
						if ("undefined" !== typeof ReadableStream) try {
							new ReadableStream({
								start: function(t) {
									t.close()
								}
							}), t = !0
						} catch (e) {}
						t || (globalThis.ReadableStream = r("87c2")
							.ReadableStream)
					}
				}(), function() {
					globalThis.Map && globalThis.Map.prototype.entries || (globalThis.Map = r("5eff"))
				}(), function() {
					globalThis.Set && globalThis.Set.prototype.entries || (globalThis.Set = r("9a35"))
				}(), function() {
					globalThis.WeakMap || (globalThis.WeakMap = r("ad63"))
				}(), function() {
					globalThis.WeakSet || (globalThis.WeakSet = r("ee42"))
				}(), function() {
					String.prototype.codePointAt || r("d627")
				}(), function() {
					String.fromCodePoint || (String.fromCodePoint = r("1cd7"))
				}(), function() {
					globalThis.Symbol || r("1f4a")
				}(), function() {
					String.prototype.padStart || r("1920")
				}(), function() {
					String.prototype.padEnd || r("476b")
				}(), function() {
					Object.values || (Object.values = r("4e28"))
				}(), function() {
					Object.entries || (Object.entries = r("a960"))
				}())
			})
			.call(this, r("b639")
				.Buffer)
		},
		"7f9a": function(t, e, r) {
			var n = r("da84"),
				i = r("1626"),
				o = r("8925"),
				a = n.WeakMap;
			t.exports = i(a) && /native code/.test(o(a))
		},
		8006: function(t, e, r) {
			"use strict";
			const n = function(t) {
					return String.fromCharCode(t)
				},
				i = {
					nilChar: n(176),
					missingChar: n(201),
					nilPremitive: n(175),
					missingPremitive: n(200),
					emptyChar: n(178),
					emptyValue: n(177),
					boundryChar: n(179),
					objStart: n(198),
					arrStart: n(204),
					arrayEnd: n(185)
				},
				o = [i.nilChar, i.nilPremitive, i.missingChar, i.missingPremitive, i.boundryChar, i.emptyChar, i.emptyValue, i.arrayEnd, i.objStart, i.arrStart],
				a = function(t, e, r) {
					if ("string" === typeof e) return t && t[0] && void 0 !== t[0].val ? s(t[0].val, e) : s(t, e); {
						const n = d(t);
						if (!0 === n) {
							let n = "";
							if (Array.isArray(e)) {
								n += i.arrStart;
								const o = e[0],
									u = t.length;
								if ("string" === typeof o)
									for (let e = 0; e < u; e++) {
										const r = s(t[e].val, o);
										n = c(n, r)
									} else
										for (let e = 0; e < u; e++) {
											const i = a(t[e], o, r);
											n = c(n, i)
										}
								n += i.arrayEnd
							} else {
								n += i.objStart;
								const o = Object.keys(e);
								Array.isArray(t) && (t = t[0]);
								for (let i in o) {
									const s = o[i];
									let u;
									u = !r.ignoreAttributes && t.attrsMap && t.attrsMap[s] ? a(t.attrsMap[s], e[s], r) : s === r.textNodeName ? a(t.val, e[s], r) : a(t.child[s], e[s], r), n = c(n, u)
								}
							}
							return n
						}
						return n
					}
				},
				s = function(t) {
					switch (t) {
						case void 0:
							return i.missingPremitive;
						case null:
							return i.nilPremitive;
						case "":
							return i.emptyValue;
						default:
							return t
					}
				},
				c = function(t, e) {
					return u(e[0]) || u(t[t.length - 1]) || (t += i.boundryChar), t + e
				},
				u = function(t) {
					return -1 !== o.indexOf(t)
				};

			function d(t) {
				return void 0 === t ? i.missingChar : null === t ? i.nilChar : !(t.child && 0 === Object.keys(t.child)
					.length && (!t.attrsMap || 0 === Object.keys(t.attrsMap)
						.length)) || i.emptyChar
			}
			const l = r("8a24"),
				f = r("90da")
				.buildOptions,
				h = function(t, e, r) {
					return r = f(r, l.defaultOptions, l.props), a(t, e, r)
				};
			e.convert2nimn = h
		},
		"80e0": function(t, e, r) {
			var n = r("746f");
			n("replace")
		},
		8172: function(t, e, r) {
			var n = r("746f"),
				i = r("57b9");
			n("toPrimitive"), i()
		},
		"81a2": function(t, e, r) {
			"use strict";
			(function(t) {
				r.d(e, "g", (function() {
					return S
				})), r.d(e, "i", (function() {
					return w
				})), r.d(e, "f", (function() {
					return C
				})), r.d(e, "c", (function() {
					return _
				})), r.d(e, "d", (function() {
					return I
				})), r.d(e, "e", (function() {
					return E
				})), r.d(e, "h", (function() {
					return T
				})), r.d(e, "b", (function() {
					return x
				})), r.d(e, "a", (function() {
					return P
				}));
				var n = r("7efc"),
					i = r("3662"),
					o = r("67d3"),
					a = r("6b33"),
					s = r("0083"),
					c = r("bc3a"),
					u = r.n(c);

				function d(t) {
					return d = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t) {
						return typeof t
					} : function(t) {
						return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
					}, d(t)
				}

				function l(t, e) {
					var r = "undefined" !== typeof Symbol && t[Symbol.iterator] || t["@@iterator"];
					if (!r) {
						if (Array.isArray(t) || (r = f(t)) || e && t && "number" === typeof t.length) {
							r && (t = r);
							var n = 0,
								i = function() {};
							return {
								s: i,
								n: function() {
									return n >= t.length ? {
										done: !0
									} : {
										done: !1,
										value: t[n++]
									}
								},
								e: function(t) {
									throw t
								},
								f: i
							}
						}
						throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")
					}
					var o, a = !0,
						s = !1;
					return {
						s: function() {
							r = r.call(t)
						},
						n: function() {
							var t = r.next();
							return a = t.done, t
						},
						e: function(t) {
							s = !0, o = t
						},
						f: function() {
							try {
								a || null == r.return || r.return()
							} finally {
								if (s) throw o
							}
						}
					}
				}

				function f(t, e) {
					if (t) {
						if ("string" === typeof t) return h(t, e);
						var r = Object.prototype.toString.call(t)
							.slice(8, -1);
						return "Object" === r && t.constructor && (r = t.constructor.name), "Map" === r || "Set" === r ? Array.from(t) : "Arguments" === r || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r) ? h(t, e) : void 0
					}
				}

				function h(t, e) {
					(null == e || e > t.length) && (e = t.length);
					for (var r = 0, n = new Array(e); r < e; r++) n[r] = t[r];
					return n
				}

				function p() {
					/*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */
					p = function() {
						return t
					};
					var t = {},
						e = Object.prototype,
						r = e.hasOwnProperty,
						n = "function" == typeof Symbol ? Symbol : {},
						i = n.iterator || "@@iterator",
						o = n.asyncIterator || "@@asyncIterator",
						a = n.toStringTag || "@@toStringTag";

					function s(t, e, r) {
						return Object.defineProperty(t, e, {
							value: r,
							enumerable: !0,
							configurable: !0,
							writable: !0
						}), t[e]
					}
					try {
						s({}, "")
					} catch (x) {
						s = function(t, e, r) {
							return t[e] = r
						}
					}

					function c(t, e, r, n) {
						var i = e && e.prototype instanceof f ? e : f,
							o = Object.create(i.prototype),
							a = new I(n || []);
						return o._invoke = function(t, e, r) {
							var n = "suspendedStart";
							return function(i, o) {
								if ("executing" === n) throw new Error("Generator is already running");
								if ("completed" === n) {
									if ("throw" === i) throw o;
									return T()
								}
								for (r.method = i, r.arg = o;;) {
									var a = r.delegate;
									if (a) {
										var s = C(a, r);
										if (s) {
											if (s === l) continue;
											return s
										}
									}
									if ("next" === r.method) r.sent = r._sent = r.arg;
									else if ("throw" === r.method) {
										if ("suspendedStart" === n) throw n = "completed", r.arg;
										r.dispatchException(r.arg)
									} else "return" === r.method && r.abrupt("return", r.arg);
									n = "executing";
									var c = u(t, e, r);
									if ("normal" === c.type) {
										if (n = r.done ? "completed" : "suspendedYield", c.arg === l) continue;
										return {
											value: c.arg,
											done: r.done
										}
									}
									"throw" === c.type && (n = "completed", r.method = "throw", r.arg = c.arg)
								}
							}
						}(t, r, a), o
					}

					function u(t, e, r) {
						try {
							return {
								type: "normal",
								arg: t.call(e, r)
							}
						} catch (x) {
							return {
								type: "throw",
								arg: x
							}
						}
					}
					t.wrap = c;
					var l = {};

					function f() {}

					function h() {}

					function m() {}
					var b = {};
					s(b, i, (function() {
						return this
					}));
					var g = Object.getPrototypeOf,
						y = g && g(g(E([])));
					y && y !== e && r.call(y, i) && (b = y);
					var v = m.prototype = f.prototype = Object.create(b);

					function S(t) {
						["next", "throw", "return"].forEach((function(e) {
							s(t, e, (function(t) {
								return this._invoke(e, t)
							}))
						}))
					}

					function w(t, e) {
						function n(i, o, a, s) {
							var c = u(t[i], t, o);
							if ("throw" !== c.type) {
								var l = c.arg,
									f = l.value;
								return f && "object" == d(f) && r.call(f, "__await") ? e.resolve(f.__await)
									.then((function(t) {
										n("next", t, a, s)
									}), (function(t) {
										n("throw", t, a, s)
									})) : e.resolve(f)
									.then((function(t) {
										l.value = t, a(l)
									}), (function(t) {
										return n("throw", t, a, s)
									}))
							}
							s(c.arg)
						}
						var i;
						this._invoke = function(t, r) {
							function o() {
								return new e((function(e, i) {
									n(t, r, e, i)
								}))
							}
							return i = i ? i.then(o, o) : o()
						}
					}

					function C(t, e) {
						var r = t.iterator[e.method];
						if (void 0 === r) {
							if (e.delegate = null, "throw" === e.method) {
								if (t.iterator.return && (e.method = "return", e.arg = void 0, C(t, e), "throw" === e.method)) return l;
								e.method = "throw", e.arg = new TypeError("The iterator does not provide a 'throw' method")
							}
							return l
						}
						var n = u(r, t.iterator, e.arg);
						if ("throw" === n.type) return e.method = "throw", e.arg = n.arg, e.delegate = null, l;
						var i = n.arg;
						return i ? i.done ? (e[t.resultName] = i.value, e.next = t.nextLoc, "return" !== e.method && (e.method = "next", e.arg = void 0), e.delegate = null, l) : i : (e.method = "throw", e.arg = new TypeError("iterator result is not an object"), e.delegate = null, l)
					}

					function _(t) {
						var e = {
							tryLoc: t[0]
						};
						1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e)
					}

					function A(t) {
						var e = t.completion || {};
						e.type = "normal", delete e.arg, t.completion = e
					}

					function I(t) {
						this.tryEntries = [{
							tryLoc: "root"
						}], t.forEach(_, this), this.reset(!0)
					}

					function E(t) {
						if (t) {
							var e = t[i];
							if (e) return e.call(t);
							if ("function" == typeof t.next) return t;
							if (!isNaN(t.length)) {
								var n = -1,
									o = function e() {
										for (; ++n < t.length;)
											if (r.call(t, n)) return e.value = t[n], e.done = !1, e;
										return e.value = void 0, e.done = !0, e
									};
								return o.next = o
							}
						}
						return {
							next: T
						}
					}

					function T() {
						return {
							value: void 0,
							done: !0
						}
					}
					return h.prototype = m, s(v, "constructor", m), s(m, "constructor", h), h.displayName = s(m, a, "GeneratorFunction"), t.isGeneratorFunction = function(t) {
						var e = "function" == typeof t && t.constructor;
						return !!e && (e === h || "GeneratorFunction" === (e.displayName || e.name))
					}, t.mark = function(t) {
						return Object.setPrototypeOf ? Object.setPrototypeOf(t, m) : (t.__proto__ = m, s(t, a, "GeneratorFunction")), t.prototype = Object.create(v), t
					}, t.awrap = function(t) {
						return {
							__await: t
						}
					}, S(w.prototype), s(w.prototype, o, (function() {
						return this
					})), t.AsyncIterator = w, t.async = function(e, r, n, i, o) {
						void 0 === o && (o = Promise);
						var a = new w(c(e, r, n, i), o);
						return t.isGeneratorFunction(r) ? a : a.next()
							.then((function(t) {
								return t.done ? t.value : a.next()
							}))
					}, S(v), s(v, a, "Generator"), s(v, i, (function() {
						return this
					})), s(v, "toString", (function() {
						return "[object Generator]"
					})), t.keys = function(t) {
						var e = [];
						for (var r in t) e.push(r);
						return e.reverse(),
							function r() {
								for (; e.length;) {
									var n = e.pop();
									if (n in t) return r.value = n, r.done = !1, r
								}
								return r.done = !0, r
							}
					}, t.values = E, I.prototype = {
						constructor: I,
						reset: function(t) {
							if (this.prev = 0, this.next = 0, this.sent = this._sent = void 0, this.done = !1, this.delegate = null, this.method = "next", this.arg = void 0, this.tryEntries.forEach(A), !t)
								for (var e in this) "t" === e.charAt(0) && r.call(this, e) && !isNaN(+e.slice(1)) && (this[e] = void 0)
						},
						stop: function() {
							this.done = !0;
							var t = this.tryEntries[0].completion;
							if ("throw" === t.type) throw t.arg;
							return this.rval
						},
						dispatchException: function(t) {
							if (this.done) throw t;
							var e = this;

							function n(r, n) {
								return a.type = "throw", a.arg = t, e.next = r, n && (e.method = "next", e.arg = void 0), !!n
							}
							for (var i = this.tryEntries.length - 1; i >= 0; --i) {
								var o = this.tryEntries[i],
									a = o.completion;
								if ("root" === o.tryLoc) return n("end");
								if (o.tryLoc <= this.prev) {
									var s = r.call(o, "catchLoc"),
										c = r.call(o, "finallyLoc");
									if (s && c) {
										if (this.prev < o.catchLoc) return n(o.catchLoc, !0);
										if (this.prev < o.finallyLoc) return n(o.finallyLoc)
									} else if (s) {
										if (this.prev < o.catchLoc) return n(o.catchLoc, !0)
									} else {
										if (!c) throw new Error("try statement without catch or finally");
										if (this.prev < o.finallyLoc) return n(o.finallyLoc)
									}
								}
							}
						},
						abrupt: function(t, e) {
							for (var n = this.tryEntries.length - 1; n >= 0; --n) {
								var i = this.tryEntries[n];
								if (i.tryLoc <= this.prev && r.call(i, "finallyLoc") && this.prev < i.finallyLoc) {
									var o = i;
									break
								}
							}
							o && ("break" === t || "continue" === t) && o.tryLoc <= e && e <= o.finallyLoc && (o = null);
							var a = o ? o.completion : {};
							return a.type = t, a.arg = e, o ? (this.method = "next", this.next = o.finallyLoc, l) : this.complete(a)
						},
						complete: function(t, e) {
							if ("throw" === t.type) throw t.arg;
							return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), l
						},
						finish: function(t) {
							for (var e = this.tryEntries.length - 1; e >= 0; --e) {
								var r = this.tryEntries[e];
								if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), A(r), l
							}
						},
						catch: function(t) {
							for (var e = this.tryEntries.length - 1; e >= 0; --e) {
								var r = this.tryEntries[e];
								if (r.tryLoc === t) {
									var n = r.completion;
									if ("throw" === n.type) {
										var i = n.arg;
										A(r)
									}
									return i
								}
							}
							throw new Error("illegal catch attempt")
						},
						delegateYield: function(t, e, r) {
							return this.delegate = {
								iterator: E(t),
								resultName: e,
								nextLoc: r
							}, "next" === this.method && (this.arg = void 0), l
						}
					}, t
				}

				function m(t, e, r, n, i, o, a) {
					try {
						var s = t[o](a),
							c = s.value
					} catch (u) {
						return void r(u)
					}
					s.done ? e(c) : Promise.resolve(c)
						.then(n, i)
				}

				function b(t) {
					return function() {
						var e = this,
							r = arguments;
						return new Promise((function(n, i) {
							var o = t.apply(e, r);

							function a(t) {
								m(o, n, i, a, s, "next", t)
							}

							function s(t) {
								m(o, n, i, a, s, "throw", t)
							}
							a(void 0)
						}))
					}
				}
				u.a.defaults.timeout = 3e4;
				var g = "",
					y = !1,
					v = "",
					S = function(t) {
						y = "Server" == t
					},
					w = function(t) {
						v = t
					},
					C = function(t) {
						g = t
					},
					_ = function(t) {
						t.ofd instanceof File || t.ofd instanceof ArrayBuffer ? A(t) : s["getBinaryContent"](t.ofd, (function(e, r) {
							e ? t.fail && t.fail(e) : (t.ofd = r, A(t))
						}))
					},
					A = function(e) {
						if (y && "" != v) {
							var r = new FormData;
							r.append("file", e.ofd), r.append("zoomScale", Object(a["h"])());
							var n = k(new Date, "yyyyMMddhhmmssS") + "-" + Math.round(1e4 * Math.random());
							r.append("accessId", n);
							var s = k(new Date, "yyyy-MM-dd hh:mm:ss");
							r.append("reqTime", s), u.a.post(v + "getPageSvgInfo", r, {
									"Content-type": "multipart/form-data"
								})
								.then((function(t) {
									if (console.log(t), e.success) {
										var r = t.data.data;
										r.pages = t.data.data.listPageSize, r.file = e.ofd, e.success(r)
									}
								}))
								.catch((function(t) {
									console.log(t), e.fail && e.fail(t)
								}))
						} else t.xmlParseFlag = 0, i["a"].call(this, b(p()
								.mark((function t() {
									return p()
										.wrap((function(t) {
											while (1) switch (t.prev = t.next) {
												case 0:
													return t.next = 2, Object(o["d"])(e.ofd, g);
												case 2:
													return t.abrupt("return", t.sent);
												case 3:
												case "end":
													return t.stop()
											}
										}), t)
								}))), o["b"], o["c"])
							.then((function(t) {
								e.success && (t[0].pageCount = t[0].pages.length, e.success(t[0]))
							}))
							.catch((function(t) {
								console.log(t), e.fail && e.fail(t)
							}))
					},
					I = function(t, e) {
						var r = [];
						if (!t) return r;
						if (y && "" != v) {
							var i, o = 0,
								s = l(t.pages);
							try {
								for (s.s(); !(i = s.n())
									.done;) {
									var c = i.value,
										u = Object(a["e"])(c[0]),
										d = Object(a["e"])(c[1]),
										f = document.createElement("div");
									f.id = o, f.setAttribute("style", "margin-top: 15px; position: relative; width: ".concat(u, "px; height: ")
										.concat(d, "px; background: white; box-shadow: 0px 0px 10px 3PX grey;")), f.className = "page-break", f.innerHTML = t.listPageSvg[o], r.push(f), o++
								}
							} catch (w) {
								s.e(w)
							} finally {
								s.f()
							}
						} else {
							var h, p = l(t.pages);
							try {
								for (p.s(); !(h = p.n())
									.done;) {
									var m = h.value,
										b = Object(n["a"])(e, t.document, m),
										g = Object.keys(m)[0],
										S = document.createElement("div");
									S.id = g, S.setAttribute("style", "margin-top: 15px; position: relative; width: ".concat(b.w, "px; height: ")
										.concat(b.h, "px; background: white; box-shadow: 0px 0px 10px 3PX grey;")), S.className = "page-break", Object(n["c"])(S, m, t.tpls, t.fontResObj, t.drawParamResObj, t.multiMediaResObj, t.compositeGraphicUnits), r.push(S)
								}
							} catch (w) {
								p.e(w)
							} finally {
								p.f()
							}
						}
						return r
					},
					E = function(t) {
						var e = [];
						if (!t) return e;
						if (!y || "" == v) {
							var r, i = l(t.pages);
							try {
								for (i.s(); !(r = i.n())
									.done;) {
									var o = r.value,
										a = Object(n["b"])(t.document, o),
										s = Object.keys(o)[0],
										c = document.createElement("div");
									c.id = s, c.setAttribute("style", "overflow: hidden; margin-top: 15px; position: relative; width: ".concat(a.w, "px; height: ")
										.concat(a.h, "px; background: white; box-shadow: 0px 0px 10px 3PX grey;")), Object(n["c"])(c, o, t.tpls, t.fontResObj, t.drawParamResObj, t.multiMediaResObj, t.compositeGraphicUnits), e.push(c)
								}
							} catch (u) {
								i.e(u)
							} finally {
								i.f()
							}
							return e
						}
					},
					T = function(t) {
						Object(a["n"])(t)
					},
					x = function() {
						return Object(a["h"])()
					},
					P = function() {
						return Object(o["getDocProperties"])()
					};

				function k() {
					var t = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : Date.now(),
						e = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : "yyyy-MM-dd hh:mm:ss",
						r = {
							"M+": t.getMonth() + 1,
							"d+": t.getDate(),
							"h+": t.getHours(),
							"m+": t.getMinutes(),
							"s+": t.getSeconds(),
							"q+": Math.floor((t.getMonth() + 3) / 3),
							S: t.getMilliseconds()
						};
					for (var n in /(y+)/.test(e) && (e = e.replace(RegExp.$1, (t.getFullYear() + "")
						.substr(4 - RegExp.$1.length))), r) new RegExp("(" + n + ")")
						.test(e) && (e = e.replace(RegExp.$1, 1 == RegExp.$1.length ? r[n] : ("00" + r[n])
							.substr(("" + r[n])
								.length)));
					return e
				}
			})
			.call(this, r("c8ba"))
		},
		"81b8": function(t, e, r) {
			var n = r("746f");
			n("unscopables")
		},
		"820e": function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("c65b"),
				o = r("59ed"),
				a = r("f069"),
				s = r("e667"),
				c = r("2266");
			n({
				target: "Promise",
				stat: !0
			}, {
				allSettled: function(t) {
					var e = this,
						r = a.f(e),
						n = r.resolve,
						u = r.reject,
						d = s((function() {
							var r = o(e.resolve),
								a = [],
								s = 0,
								u = 1;
							c(t, (function(t) {
								var o = s++,
									c = !1;
								u++, i(r, e, t)
									.then((function(t) {
										c || (c = !0, a[o] = {
											status: "fulfilled",
											value: t
										}, --u || n(a))
									}), (function(t) {
										c || (c = !0, a[o] = {
											status: "rejected",
											reason: t
										}, --u || n(a))
									}))
							})), --u || n(a)
						}));
					return d.error && u(d.value), r.promise
				}
			})
		},
		"825a": function(t, e, r) {
			var n = r("da84"),
				i = r("861d"),
				o = n.String,
				a = n.TypeError;
			t.exports = function(t) {
				if (i(t)) return t;
				throw a(o(t) + " is not an object")
			}
		},
		"83ab": function(t, e, r) {
			var n = r("d039");
			t.exports = !n((function() {
				return 7 != Object.defineProperty({}, 1, {
					get: function() {
						return 7
					}
				})[1]
			}))
		},
		"83b9": function(t, e, r) {
			"use strict";
			var n = r("d925"),
				i = r("e683");
			t.exports = function(t, e) {
				return t && !n(e) ? i(t, e) : e
			}
		},
		8418: function(t, e, r) {
			"use strict";
			var n = r("a04b"),
				i = r("9bf2"),
				o = r("5c6c");
			t.exports = function(t, e, r) {
				var a = n(e);
				a in t ? i.f(t, a, o(0, r)) : t[a] = r
			}
		},
		"843c": function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("0ccb")
				.end,
				o = r("9a0c");
			n({
				target: "String",
				proto: !0,
				forced: o
			}, {
				padEnd: function(t) {
					return i(this, t, arguments.length > 1 ? arguments[1] : void 0)
				}
			})
		},
		"861d": function(t, e, r) {
			var n = r("1626");
			t.exports = function(t) {
				return "object" == typeof t ? null !== t : n(t)
			}
		},
		"87c2": function(t, e, r) {
			(function(t, r) {
				r(e)
			})(0, (function(t) {
				"use strict";
				var e = "function" === typeof Symbol && "symbol" === typeof Symbol.iterator ? Symbol : function(t) {
					return "Symbol(" + t + ")"
				};

				function r() {}
				var n = Number.isNaN || function(t) {
						return t !== t
					},
					i = r;

				function o(t) {
					return "object" === typeof t && null !== t || "function" === typeof t
				}

				function a(t) {
					return t.slice()
				}

				function s(t, e, r, n, i) {
					new Uint8Array(t)
						.set(new Uint8Array(r, n, i), e)
				}

				function c(t) {
					return !1 !== u(t) && t !== 1 / 0
				}

				function u(t) {
					return "number" === typeof t && (!n(t) && !(t < 0))
				}

				function d(t, e, r) {
					if ("function" !== typeof t) throw new TypeError("Argument is not a function");
					return Function.prototype.apply.call(t, e, r)
				}

				function l(t, e, r, n) {
					var i = t[e];
					if (void 0 !== i) {
						if ("function" !== typeof i) throw new TypeError(i + " is not a method");
						switch (r) {
							case 0:
								return function() {
									return h(i, t, n)
								};
							case 1:
								return function(e) {
									var r = [e].concat(n);
									return h(i, t, r)
								}
						}
					}
					return function() {
						return _(void 0)
					}
				}

				function f(t, e, r) {
					var n = t[e];
					if (void 0 !== n) return d(n, t, r)
				}

				function h(t, e, r) {
					try {
						return _(d(t, e, r))
					} catch (n) {
						return A(n)
					}
				}

				function p(t) {
					return t
				}

				function m(t) {
					return !1
				}

				function b(t) {
					if (t = Number(t), n(t) || t < 0) throw new RangeError("highWaterMark property of a queuing strategy must be non-negative and non-NaN");
					return t
				}

				function g(t) {
					if (void 0 === t) return function() {
						return 1
					};
					if ("function" !== typeof t) throw new TypeError("size property of a queuing strategy must be a function");
					return function(e) {
						return t(e)
					}
				}
				var y = Promise,
					v = Promise.prototype.then,
					S = Promise.resolve.bind(y),
					w = Promise.reject.bind(y);

				function C(t) {
					return new y(t)
				}

				function _(t) {
					return S(t)
				}

				function A(t) {
					return w(t)
				}

				function I(t, e, r) {
					return v.call(t, e, r)
				}

				function E(t, e, r) {
					I(I(t, e, r), void 0, i)
				}

				function T(t, e) {
					E(t, e)
				}

				function x(t, e) {
					E(t, void 0, e)
				}

				function P(t, e, r) {
					return I(t, e, r)
				}

				function k(t) {
					I(t, void 0, i)
				}
				var D = 16384,
					O = function() {
						function t() {
							this._cursor = 0, this._size = 0, this._front = {
								_elements: [],
								_next: void 0
							}, this._back = this._front, this._cursor = 0, this._size = 0
						}
						return Object.defineProperty(t.prototype, "length", {
							get: function() {
								return this._size
							},
							enumerable: !0,
							configurable: !0
						}), t.prototype.push = function(t) {
							var e = this._back,
								r = e;
							e._elements.length === D - 1 && (r = {
								_elements: [],
								_next: void 0
							}), e._elements.push(t), r !== e && (this._back = r, e._next = r), ++this._size
						}, t.prototype.shift = function() {
							var t = this._front,
								e = t,
								r = this._cursor,
								n = r + 1,
								i = t._elements,
								o = i[r];
							return n === D && (e = t._next, n = 0), --this._size, this._cursor = n, t !== e && (this._front = e), i[r] = void 0, o
						}, t.prototype.forEach = function(t) {
							var e = this._cursor,
								r = this._front,
								n = r._elements;
							while (e !== n.length || void 0 !== r._next) {
								if (e === n.length && (r = r._next, n = r._elements, e = 0, 0 === n.length)) break;
								t(n[e]), ++e
							}
						}, t.prototype.peek = function() {
							var t = this._front,
								e = this._cursor;
							return t._elements[e]
						}, t
					}();

				function R(t, e, r) {
					var n = null;
					!0 === r && (n = Object.prototype);
					var i = Object.create(n);
					return i.value = t, i.done = e, i
				}

				function N(t, e) {
					t._forAuthorCode = !0, t._ownerReadableStream = e, e._reader = t, "readable" === e._state ? j(t) : "closed" === e._state ? L(t) : K(t, e._storedError)
				}

				function M(t, e) {
					var r = t._ownerReadableStream;
					return Br(r, e)
				}

				function B(t) {
					"readable" === t._ownerReadableStream._state ? U(t, new TypeError("Reader was released and can no longer be used to monitor the stream's closedness")) : X(t, new TypeError("Reader was released and can no longer be used to monitor the stream's closedness")), t._ownerReadableStream._reader = void 0, t._ownerReadableStream = void 0
				}

				function F(t) {
					return new TypeError("Cannot " + t + " a stream using a released reader")
				}

				function j(t) {
					t._closedPromise = C((function(e, r) {
						t._closedPromise_resolve = e, t._closedPromise_reject = r
					}))
				}

				function K(t, e) {
					j(t), U(t, e)
				}

				function L(t) {
					j(t), z(t)
				}

				function U(t, e) {
					k(t._closedPromise), t._closedPromise_reject(e), t._closedPromise_resolve = void 0, t._closedPromise_reject = void 0
				}

				function X(t, e) {
					K(t, e)
				}

				function z(t) {
					t._closedPromise_resolve(void 0), t._closedPromise_resolve = void 0, t._closedPromise_reject = void 0
				}
				var G = e("[[CancelSteps]]"),
					q = e("[[PullSteps]]");

				function W(t, e) {
					void 0 === e && (e = !1);
					var r = new $(t);
					return r._forAuthorCode = e, r
				}

				function V(t) {
					var e = C((function(e, r) {
						var n = {
							_resolve: e,
							_reject: r
						};
						t._reader._readRequests.push(n)
					}));
					return e
				}

				function H(t, e, r) {
					var n = t._reader,
						i = n._readRequests.shift();
					i._resolve(R(e, r, n._forAuthorCode))
				}

				function Y(t) {
					return t._reader._readRequests.length
				}

				function Z(t) {
					var e = t._reader;
					return void 0 !== e && !!tt(e)
				}
				var Q, J, $ = function() {
					function t(t) {
						if (!1 === Nr(t)) throw new TypeError("ReadableStreamDefaultReader can only be constructed with a ReadableStream instance");
						if (!0 === Mr(t)) throw new TypeError("This stream has already been locked for exclusive reading by another reader");
						N(this, t), this._readRequests = new O
					}
					return Object.defineProperty(t.prototype, "closed", {
						get: function() {
							return tt(this) ? this._closedPromise : A(rt("closed"))
						},
						enumerable: !0,
						configurable: !0
					}), t.prototype.cancel = function(t) {
						return tt(this) ? void 0 === this._ownerReadableStream ? A(F("cancel")) : M(this, t) : A(rt("cancel"))
					}, t.prototype.read = function() {
						return tt(this) ? void 0 === this._ownerReadableStream ? A(F("read from")) : et(this) : A(rt("read"))
					}, t.prototype.releaseLock = function() {
						if (!tt(this)) throw rt("releaseLock");
						if (void 0 !== this._ownerReadableStream) {
							if (this._readRequests.length > 0) throw new TypeError("Tried to release a reader lock when that reader has pending read() calls un-settled");
							B(this)
						}
					}, t
				}();

				function tt(t) {
					return !!o(t) && !!Object.prototype.hasOwnProperty.call(t, "_readRequests")
				}

				function et(t) {
					var e = t._ownerReadableStream;
					return e._disturbed = !0, "closed" === e._state ? _(R(void 0, !0, t._forAuthorCode)) : "errored" === e._state ? A(e._storedError) : e._readableStreamController[q]()
				}

				function rt(t) {
					return new TypeError("ReadableStreamDefaultReader.prototype." + t + " can only be used on a ReadableStreamDefaultReader")
				}
				"symbol" === typeof e.asyncIterator && (Q = {}, Q[e.asyncIterator] = function() {
					return this
				}, J = Q, Object.defineProperty(J, e.asyncIterator, {
					enumerable: !1
				}));
				var nt = {
					next: function() {
						if (!1 === ot(this)) return A(at("next"));
						var t = this._asyncIteratorReader;
						return void 0 === t._ownerReadableStream ? A(F("iterate")) : P(et(t), (function(e) {
							var r = e.done;
							r && B(t);
							var n = e.value;
							return R(n, r, !0)
						}))
					},
					return: function(t) {
						if (!1 === ot(this)) return A(at("next"));
						var e = this._asyncIteratorReader;
						if (void 0 === e._ownerReadableStream) return A(F("finish iterating"));
						if (e._readRequests.length > 0) return A(new TypeError("Tried to release a reader lock when that reader has pending read() calls un-settled"));
						if (!1 === this._preventCancel) {
							var r = M(e, t);
							return B(e), P(r, (function() {
								return R(t, !0, !0)
							}))
						}
						return B(e), _(R(t, !0, !0))
					}
				};

				function it(t, e) {
					void 0 === e && (e = !1);
					var r = W(t),
						n = Object.create(nt);
					return n._asyncIteratorReader = r, n._preventCancel = Boolean(e), n
				}

				function ot(t) {
					return !!o(t) && !!Object.prototype.hasOwnProperty.call(t, "_asyncIteratorReader")
				}

				function at(t) {
					return new TypeError("ReadableStreamAsyncIterator." + t + " can only be used on a ReadableSteamAsyncIterator")
				}

				function st(t) {
					var e = t._queue.shift();
					return t._queueTotalSize -= e.size, t._queueTotalSize < 0 && (t._queueTotalSize = 0), e.value
				}

				function ct(t, e, r) {
					if (r = Number(r), !c(r)) throw new RangeError("Size must be a finite, non-NaN, non-negative number.");
					t._queue.push({
						value: e,
						size: r
					}), t._queueTotalSize += r
				}

				function ut(t) {
					var e = t._queue.peek();
					return e.value
				}

				function dt(t) {
					t._queue = new O, t._queueTotalSize = 0
				}
				void 0 !== J && Object.setPrototypeOf(nt, J), Object.defineProperty(nt, "next", {
					enumerable: !1
				}), Object.defineProperty(nt, "return", {
					enumerable: !1
				});
				var lt = e("[[AbortSteps]]"),
					ft = e("[[ErrorSteps]]"),
					ht = function() {
						function t(t, e) {
							void 0 === t && (t = {}), void 0 === e && (e = {}), bt(this);
							var r = e.size,
								n = e.highWaterMark,
								i = t.type;
							if (void 0 !== i) throw new RangeError("Invalid type is specified");
							var o = g(r);
							void 0 === n && (n = 1), n = b(n), Ht(this, t, n, o)
						}
						return Object.defineProperty(t.prototype, "locked", {
							get: function() {
								if (!1 === gt(this)) throw ae("locked");
								return yt(this)
							},
							enumerable: !0,
							configurable: !0
						}), t.prototype.abort = function(t) {
							return !1 === gt(this) ? A(ae("abort")) : !0 === yt(this) ? A(new TypeError("Cannot abort a stream that already has a writer")) : vt(this, t)
						}, t.prototype.close = function() {
							return !1 === gt(this) ? A(ae("close")) : !0 === yt(this) ? A(new TypeError("Cannot close a stream that already has a writer")) : !0 === Pt(this) ? A(new TypeError("Cannot close an already-closing stream")) : St(this)
						}, t.prototype.getWriter = function() {
							if (!1 === gt(this)) throw ae("getWriter");
							return pt(this)
						}, t
					}();

				function pt(t) {
					return new Mt(t)
				}

				function mt(t, e, r, n, i, o) {
					void 0 === i && (i = 1), void 0 === o && (o = function() {
						return 1
					});
					var a = Object.create(ht.prototype);
					bt(a);
					var s = Object.create(qt.prototype);
					return Vt(a, s, t, e, r, n, i, o), a
				}

				function bt(t) {
					t._state = "writable", t._storedError = void 0, t._writer = void 0, t._writableStreamController = void 0, t._writeRequests = new O, t._inFlightWriteRequest = void 0, t._closeRequest = void 0, t._inFlightCloseRequest = void 0, t._pendingAbortRequest = void 0, t._backpressure = !1
				}

				function gt(t) {
					return !!o(t) && !!Object.prototype.hasOwnProperty.call(t, "_writableStreamController")
				}

				function yt(t) {
					return void 0 !== t._writer
				}

				function vt(t, e) {
					var r = t._state;
					if ("closed" === r || "errored" === r) return _(void 0);
					if (void 0 !== t._pendingAbortRequest) return t._pendingAbortRequest._promise;
					var n = !1;
					"erroring" === r && (n = !0, e = void 0);
					var i = C((function(r, i) {
						t._pendingAbortRequest = {
							_promise: void 0,
							_resolve: r,
							_reject: i,
							_reason: e,
							_wasAlreadyErroring: n
						}
					}));
					return t._pendingAbortRequest._promise = i, !1 === n && _t(t, e), i
				}

				function St(t) {
					var e = t._state;
					if ("closed" === e || "errored" === e) return A(new TypeError("The stream (in " + e + " state) is not in the writable state and cannot be closed"));
					var r = C((function(e, r) {
							var n = {
								_resolve: e,
								_reject: r
							};
							t._closeRequest = n
						})),
						n = t._writer;
					return void 0 !== n && !0 === t._backpressure && "writable" === e && we(n), Zt(t._writableStreamController), r
				}

				function wt(t) {
					var e = C((function(e, r) {
						var n = {
							_resolve: e,
							_reject: r
						};
						t._writeRequests.push(n)
					}));
					return e
				}

				function Ct(t, e) {
					var r = t._state;
					"writable" !== r ? At(t) : _t(t, e)
				}

				function _t(t, e) {
					var r = t._writableStreamController;
					t._state = "erroring", t._storedError = e;
					var n = t._writer;
					void 0 !== n && Ut(n, e), !1 === kt(t) && !0 === r._started && At(t)
				}

				function At(t) {
					t._state = "errored", t._writableStreamController[ft]();
					var e = t._storedError;
					if (t._writeRequests.forEach((function(t) {
						t._reject(e)
					})), t._writeRequests = new O, void 0 !== t._pendingAbortRequest) {
						var r = t._pendingAbortRequest;
						if (t._pendingAbortRequest = void 0, !0 === r._wasAlreadyErroring) return r._reject(e), void Rt(t);
						var n = t._writableStreamController[lt](r._reason);
						E(n, (function() {
							r._resolve(), Rt(t)
						}), (function(e) {
							r._reject(e), Rt(t)
						}))
					} else Rt(t)
				}

				function It(t) {
					t._inFlightWriteRequest._resolve(void 0), t._inFlightWriteRequest = void 0
				}

				function Et(t, e) {
					t._inFlightWriteRequest._reject(e), t._inFlightWriteRequest = void 0, Ct(t, e)
				}

				function Tt(t) {
					t._inFlightCloseRequest._resolve(void 0), t._inFlightCloseRequest = void 0;
					var e = t._state;
					"erroring" === e && (t._storedError = void 0, void 0 !== t._pendingAbortRequest && (t._pendingAbortRequest._resolve(), t._pendingAbortRequest = void 0)), t._state = "closed";
					var r = t._writer;
					void 0 !== r && pe(r)
				}

				function xt(t, e) {
					t._inFlightCloseRequest._reject(e), t._inFlightCloseRequest = void 0, void 0 !== t._pendingAbortRequest && (t._pendingAbortRequest._reject(e), t._pendingAbortRequest = void 0), Ct(t, e)
				}

				function Pt(t) {
					return void 0 !== t._closeRequest || void 0 !== t._inFlightCloseRequest
				}

				function kt(t) {
					return void 0 !== t._inFlightWriteRequest || void 0 !== t._inFlightCloseRequest
				}

				function Dt(t) {
					t._inFlightCloseRequest = t._closeRequest, t._closeRequest = void 0
				}

				function Ot(t) {
					t._inFlightWriteRequest = t._writeRequests.shift()
				}

				function Rt(t) {
					void 0 !== t._closeRequest && (t._closeRequest._reject(t._storedError), t._closeRequest = void 0);
					var e = t._writer;
					void 0 !== e && fe(e, t._storedError)
				}

				function Nt(t, e) {
					var r = t._writer;
					void 0 !== r && e !== t._backpressure && (!0 === e ? ve(r) : we(r)), t._backpressure = e
				}
				var Mt = function() {
					function t(t) {
						if (!1 === gt(t)) throw new TypeError("WritableStreamDefaultWriter can only be constructed with a WritableStream instance");
						if (!0 === yt(t)) throw new TypeError("This stream has already been locked for exclusive writing by another writer");
						this._ownerWritableStream = t, t._writer = this;
						var e = t._state;
						if ("writable" === e) !1 === Pt(t) && !0 === t._backpressure ? me(this) : ge(this), ue(this);
						else if ("erroring" === e) be(this, t._storedError), ue(this);
						else if ("closed" === e) ge(this), le(this);
						else {
							var r = t._storedError;
							be(this, r), de(this, r)
						}
					}
					return Object.defineProperty(t.prototype, "closed", {
						get: function() {
							return !1 === Bt(this) ? A(se("closed")) : this._closedPromise
						},
						enumerable: !0,
						configurable: !0
					}), Object.defineProperty(t.prototype, "desiredSize", {
						get: function() {
							if (!1 === Bt(this)) throw se("desiredSize");
							if (void 0 === this._ownerWritableStream) throw ce("desiredSize");
							return Xt(this)
						},
						enumerable: !0,
						configurable: !0
					}), Object.defineProperty(t.prototype, "ready", {
						get: function() {
							return !1 === Bt(this) ? A(se("ready")) : this._readyPromise
						},
						enumerable: !0,
						configurable: !0
					}), t.prototype.abort = function(t) {
						return !1 === Bt(this) ? A(se("abort")) : void 0 === this._ownerWritableStream ? A(ce("abort")) : Ft(this, t)
					}, t.prototype.close = function() {
						if (!1 === Bt(this)) return A(se("close"));
						var t = this._ownerWritableStream;
						return void 0 === t ? A(ce("close")) : !0 === Pt(t) ? A(new TypeError("Cannot close an already-closing stream")) : jt(this)
					}, t.prototype.releaseLock = function() {
						if (!1 === Bt(this)) throw se("releaseLock");
						var t = this._ownerWritableStream;
						void 0 !== t && zt(this)
					}, t.prototype.write = function(t) {
						return !1 === Bt(this) ? A(se("write")) : void 0 === this._ownerWritableStream ? A(ce("write to")) : Gt(this, t)
					}, t
				}();

				function Bt(t) {
					return !!o(t) && !!Object.prototype.hasOwnProperty.call(t, "_ownerWritableStream")
				}

				function Ft(t, e) {
					var r = t._ownerWritableStream;
					return vt(r, e)
				}

				function jt(t) {
					var e = t._ownerWritableStream;
					return St(e)
				}

				function Kt(t) {
					var e = t._ownerWritableStream,
						r = e._state;
					return !0 === Pt(e) || "closed" === r ? _(void 0) : "errored" === r ? A(e._storedError) : jt(t)
				}

				function Lt(t, e) {
					"pending" === t._closedPromiseState ? fe(t, e) : he(t, e)
				}

				function Ut(t, e) {
					"pending" === t._readyPromiseState ? ye(t, e) : Se(t, e)
				}

				function Xt(t) {
					var e = t._ownerWritableStream,
						r = e._state;
					return "errored" === r || "erroring" === r ? null : "closed" === r ? 0 : Jt(e._writableStreamController)
				}

				function zt(t) {
					var e = t._ownerWritableStream,
						r = new TypeError("Writer was released and can no longer be used to monitor the stream's closedness");
					Ut(t, r), Lt(t, r), e._writer = void 0, t._ownerWritableStream = void 0
				}

				function Gt(t, e) {
					var r = t._ownerWritableStream,
						n = r._writableStreamController,
						i = Qt(n, e);
					if (r !== t._ownerWritableStream) return A(ce("write to"));
					var o = r._state;
					if ("errored" === o) return A(r._storedError);
					if (!0 === Pt(r) || "closed" === o) return A(new TypeError("The stream is closing or closed and cannot be written to"));
					if ("erroring" === o) return A(r._storedError);
					var a = wt(r);
					return $t(n, e, i), a
				}
				var qt = function() {
					function t() {
						throw new TypeError("WritableStreamDefaultController cannot be constructed explicitly")
					}
					return t.prototype.error = function(t) {
						if (!1 === Wt(this)) throw new TypeError("WritableStreamDefaultController.prototype.error can only be used on a WritableStreamDefaultController");
						var e = this._controlledWritableStream._state;
						"writable" === e && oe(this, t)
					}, t.prototype[lt] = function(t) {
						var e = this._abortAlgorithm(t);
						return Yt(this), e
					}, t.prototype[ft] = function() {
						dt(this)
					}, t
				}();

				function Wt(t) {
					return !!o(t) && !!Object.prototype.hasOwnProperty.call(t, "_controlledWritableStream")
				}

				function Vt(t, e, r, n, i, o, a, s) {
					e._controlledWritableStream = t, t._writableStreamController = e, e._queue = void 0, e._queueTotalSize = void 0, dt(e), e._started = !1, e._strategySizeAlgorithm = s, e._strategyHWM = a, e._writeAlgorithm = n, e._closeAlgorithm = i, e._abortAlgorithm = o;
					var c = ie(e);
					Nt(t, c);
					var u = r(),
						d = _(u);
					E(d, (function() {
						e._started = !0, te(e)
					}), (function(r) {
						e._started = !0, Ct(t, r)
					}))
				}

				function Ht(t, e, r, n) {
					var i = Object.create(qt.prototype);

					function o() {
						return f(e, "start", [i])
					}
					var a = l(e, "write", 1, [i]),
						s = l(e, "close", 0, []),
						c = l(e, "abort", 1, []);
					Vt(t, i, o, a, s, c, r, n)
				}

				function Yt(t) {
					t._writeAlgorithm = void 0, t._closeAlgorithm = void 0, t._abortAlgorithm = void 0, t._strategySizeAlgorithm = void 0
				}

				function Zt(t) {
					ct(t, "close", 0), te(t)
				}

				function Qt(t, e) {
					try {
						return t._strategySizeAlgorithm(e)
					} catch (r) {
						return ee(t, r), 1
					}
				}

				function Jt(t) {
					return t._strategyHWM - t._queueTotalSize
				}

				function $t(t, e, r) {
					var n = {
						chunk: e
					};
					try {
						ct(t, n, r)
					} catch (a) {
						return void ee(t, a)
					}
					var i = t._controlledWritableStream;
					if (!1 === Pt(i) && "writable" === i._state) {
						var o = ie(t);
						Nt(i, o)
					}
					te(t)
				}

				function te(t) {
					var e = t._controlledWritableStream;
					if (!1 !== t._started && void 0 === e._inFlightWriteRequest) {
						var r = e._state;
						if ("erroring" !== r) {
							if (0 !== t._queue.length) {
								var n = ut(t);
								"close" === n ? re(t) : ne(t, n.chunk)
							}
						} else At(e)
					}
				}

				function ee(t, e) {
					"writable" === t._controlledWritableStream._state && oe(t, e)
				}

				function re(t) {
					var e = t._controlledWritableStream;
					Dt(e), st(t);
					var r = t._closeAlgorithm();
					Yt(t), E(r, (function() {
						Tt(e)
					}), (function(t) {
						xt(e, t)
					}))
				}

				function ne(t, e) {
					var r = t._controlledWritableStream;
					Ot(r);
					var n = t._writeAlgorithm(e);
					E(n, (function() {
						It(r);
						var e = r._state;
						if (st(t), !1 === Pt(r) && "writable" === e) {
							var n = ie(t);
							Nt(r, n)
						}
						te(t)
					}), (function(e) {
						"writable" === r._state && Yt(t), Et(r, e)
					}))
				}

				function ie(t) {
					var e = Jt(t);
					return e <= 0
				}

				function oe(t, e) {
					var r = t._controlledWritableStream;
					Yt(t), _t(r, e)
				}

				function ae(t) {
					return new TypeError("WritableStream.prototype." + t + " can only be used on a WritableStream")
				}

				function se(t) {
					return new TypeError("WritableStreamDefaultWriter.prototype." + t + " can only be used on a WritableStreamDefaultWriter")
				}

				function ce(t) {
					return new TypeError("Cannot " + t + " a stream using a released writer")
				}

				function ue(t) {
					t._closedPromise = C((function(e, r) {
						t._closedPromise_resolve = e, t._closedPromise_reject = r, t._closedPromiseState = "pending"
					}))
				}

				function de(t, e) {
					ue(t), fe(t, e)
				}

				function le(t) {
					ue(t), pe(t)
				}

				function fe(t, e) {
					k(t._closedPromise), t._closedPromise_reject(e), t._closedPromise_resolve = void 0, t._closedPromise_reject = void 0, t._closedPromiseState = "rejected"
				}

				function he(t, e) {
					de(t, e)
				}

				function pe(t) {
					t._closedPromise_resolve(void 0), t._closedPromise_resolve = void 0, t._closedPromise_reject = void 0, t._closedPromiseState = "resolved"
				}

				function me(t) {
					t._readyPromise = C((function(e, r) {
						t._readyPromise_resolve = e, t._readyPromise_reject = r
					})), t._readyPromiseState = "pending"
				}

				function be(t, e) {
					me(t), ye(t, e)
				}

				function ge(t) {
					me(t), we(t)
				}

				function ye(t, e) {
					k(t._readyPromise), t._readyPromise_reject(e), t._readyPromise_resolve = void 0, t._readyPromise_reject = void 0, t._readyPromiseState = "rejected"
				}

				function ve(t) {
					me(t)
				}

				function Se(t, e) {
					be(t, e)
				}

				function we(t) {
					t._readyPromise_resolve(void 0), t._readyPromise_resolve = void 0, t._readyPromise_reject = void 0, t._readyPromiseState = "fulfilled"
				}

				function Ce(t) {
					if ("object" !== typeof t || null === t) return !1;
					try {
						return "boolean" === typeof t.aborted
					} catch (Q) {
						return !1
					}
				}
				var _e = "undefined" !== typeof DOMException ? DOMException : void 0;

				function Ae(t) {
					if ("function" !== typeof t && "object" !== typeof t) return !1;
					try {
						return new t, !0
					} catch (Q) {
						return !1
					}
				}

				function Ie() {
					var t = function(t, e) {
						this.message = t || "", this.name = e || "Error", Error.captureStackTrace && Error.captureStackTrace(this, this.constructor)
					};
					return t.prototype = Object.create(Error.prototype), Object.defineProperty(t.prototype, "constructor", {
						value: t,
						writable: !0,
						configurable: !0
					}), t
				}
				var Ee = Ae(_e) ? _e : Ie();

				function Te(t, e, n, i, o, a) {
					var s = W(t),
						c = pt(e);
					t._disturbed = !0;
					var u = !1,
						d = _(void 0);
					return C((function(l, f) {
						var h;
						if (void 0 !== a) {
							if (h = function() {
								var r = new Ee("Aborted", "AbortError"),
									n = [];
								!1 === i && n.push((function() {
									return "writable" === e._state ? vt(e, r) : _(void 0)
								})), !1 === o && n.push((function() {
									return "readable" === t._state ? Br(t, r) : _(void 0)
								})), S((function() {
									return Promise.all(n.map((function(t) {
										return t()
									})))
								}), !0, r)
							}, !0 === a.aborted) return void h();
							a.addEventListener("abort", h)
						}

						function p() {
							return C((function(t, e) {
								function r(n) {
									n ? t() : I(m(), r, e)
								}
								r(!1)
							}))
						}

						function m() {
							return !0 === u ? _(!0) : I(c._readyPromise, (function() {
								return I(et(s), (function(t) {
									return !0 === t.done || (d = I(Gt(c, t.value), void 0, r), !1)
								}))
							}))
						}
						if (y(t, s._closedPromise, (function(t) {
							!1 === i ? S((function() {
								return vt(e, t)
							}), !0, t) : w(!0, t)
						})), y(e, c._closedPromise, (function(e) {
							!1 === o ? S((function() {
								return Br(t, e)
							}), !0, e) : w(!0, e)
						})), v(t, s._closedPromise, (function() {
							!1 === n ? S((function() {
								return Kt(c)
							})) : w()
						})), !0 === Pt(e) || "closed" === e._state) {
							var b = new TypeError("the destination writable stream closed before all data could be piped to it");
							!1 === o ? S((function() {
								return Br(t, b)
							}), !0, b) : w(!0, b)
						}

						function g() {
							var t = d;
							return I(d, (function() {
								return t !== d ? g() : void 0
							}))
						}

						function y(t, e, r) {
							"errored" === t._state ? r(t._storedError) : x(e, r)
						}

						function v(t, e, r) {
							"closed" === t._state ? r() : T(e, r)
						}

						function S(t, r, n) {
							function i() {
								E(t(), (function() {
									return A(r, n)
								}), (function(t) {
									return A(!0, t)
								}))
							}!0 !== u && (u = !0, "writable" === e._state && !1 === Pt(e) ? T(g(), i) : i())
						}

						function w(t, r) {
							!0 !== u && (u = !0, "writable" === e._state && !1 === Pt(e) ? T(g(), (function() {
								return A(t, r)
							})) : A(t, r))
						}

						function A(t, e) {
							zt(c), B(s), void 0 !== a && a.removeEventListener("abort", h), t ? f(e) : l(void 0)
						}
						k(p())
					}))
				}
				var xe = function() {
					function t() {
						throw new TypeError
					}
					return Object.defineProperty(t.prototype, "desiredSize", {
						get: function() {
							if (!1 === Pe(this)) throw Ue("desiredSize");
							return Be(this)
						},
						enumerable: !0,
						configurable: !0
					}), t.prototype.close = function() {
						if (!1 === Pe(this)) throw Ue("close");
						if (!1 === je(this)) throw new TypeError("The stream is not in a state that permits close");
						Re(this)
					}, t.prototype.enqueue = function(t) {
						if (!1 === Pe(this)) throw Ue("enqueue");
						if (!1 === je(this)) throw new TypeError("The stream is not in a state that permits enqueue");
						return Ne(this, t)
					}, t.prototype.error = function(t) {
						if (!1 === Pe(this)) throw Ue("error");
						Me(this, t)
					}, t.prototype[G] = function(t) {
						dt(this);
						var e = this._cancelAlgorithm(t);
						return Oe(this), e
					}, t.prototype[q] = function() {
						var t = this._controlledReadableStream;
						if (this._queue.length > 0) {
							var e = st(this);
							return !0 === this._closeRequested && 0 === this._queue.length ? (Oe(this), Fr(t)) : ke(this), _(R(e, !1, t._reader._forAuthorCode))
						}
						var r = V(t);
						return ke(this), r
					}, t
				}();

				function Pe(t) {
					return !!o(t) && !!Object.prototype.hasOwnProperty.call(t, "_controlledReadableStream")
				}

				function ke(t) {
					var e = De(t);
					if (!1 !== e)
						if (!0 !== t._pulling) {
							t._pulling = !0;
							var r = t._pullAlgorithm();
							E(r, (function() {
								t._pulling = !1, !0 === t._pullAgain && (t._pullAgain = !1, ke(t))
							}), (function(e) {
								Me(t, e)
							}))
						} else t._pullAgain = !0
				}

				function De(t) {
					var e = t._controlledReadableStream;
					if (!1 === je(t)) return !1;
					if (!1 === t._started) return !1;
					if (!0 === Mr(e) && Y(e) > 0) return !0;
					var r = Be(t);
					return r > 0
				}

				function Oe(t) {
					t._pullAlgorithm = void 0, t._cancelAlgorithm = void 0, t._strategySizeAlgorithm = void 0
				}

				function Re(t) {
					var e = t._controlledReadableStream;
					t._closeRequested = !0, 0 === t._queue.length && (Oe(t), Fr(e))
				}

				function Ne(t, e) {
					var r = t._controlledReadableStream;
					if (!0 === Mr(r) && Y(r) > 0) H(r, e, !1);
					else {
						var n = void 0;
						try {
							n = t._strategySizeAlgorithm(e)
						} catch (i) {
							throw Me(t, i), i
						}
						try {
							ct(t, e, n)
						} catch (o) {
							throw Me(t, o), o
						}
					}
					ke(t)
				}

				function Me(t, e) {
					var r = t._controlledReadableStream;
					"readable" === r._state && (dt(t), Oe(t), jr(r, e))
				}

				function Be(t) {
					var e = t._controlledReadableStream,
						r = e._state;
					return "errored" === r ? null : "closed" === r ? 0 : t._strategyHWM - t._queueTotalSize
				}

				function Fe(t) {
					return !0 !== De(t)
				}

				function je(t) {
					var e = t._controlledReadableStream._state;
					return !1 === t._closeRequested && "readable" === e
				}

				function Ke(t, e, r, n, i, o, a) {
					e._controlledReadableStream = t, e._queue = void 0, e._queueTotalSize = void 0, dt(e), e._started = !1, e._closeRequested = !1, e._pullAgain = !1, e._pulling = !1, e._strategySizeAlgorithm = a, e._strategyHWM = o, e._pullAlgorithm = n, e._cancelAlgorithm = i, t._readableStreamController = e;
					var s = r();
					E(_(s), (function() {
						e._started = !0, ke(e)
					}), (function(t) {
						Me(e, t)
					}))
				}

				function Le(t, e, r, n) {
					var i = Object.create(xe.prototype);

					function o() {
						return f(e, "start", [i])
					}
					var a = l(e, "pull", 0, [i]),
						s = l(e, "cancel", 1, []);
					Ke(t, i, o, a, s, r, n)
				}

				function Ue(t) {
					return new TypeError("ReadableStreamDefaultController.prototype." + t + " can only be used on a ReadableStreamDefaultController")
				}

				function Xe(t, e) {
					var r, n, i, o, s, c = W(t),
						u = !1,
						d = !1,
						l = !1,
						f = C((function(t) {
							s = t
						}));

					function h() {
						if (!0 === u) return _(void 0);
						u = !0;
						var t = P(et(c), (function(t) {
							u = !1;
							var e = t.done;
							if (!0 === e) return !1 === d && Re(i._readableStreamController), void(!1 === l && Re(o._readableStreamController));
							var r = t.value,
								n = r,
								a = r;
							!1 === d && Ne(i._readableStreamController, n), !1 === l && Ne(o._readableStreamController, a)
						}));
						return k(t), _(void 0)
					}

					function p(e) {
						if (d = !0, r = e, !0 === l) {
							var i = a([r, n]),
								o = Br(t, i);
							s(o)
						}
						return f
					}

					function m(e) {
						if (l = !0, n = e, !0 === d) {
							var i = a([r, n]),
								o = Br(t, i);
							s(o)
						}
						return f
					}

					function b() {}
					return i = Or(b, h, p), o = Or(b, h, m), x(c._closedPromise, (function(t) {
						Me(i._readableStreamController, t), Me(o._readableStreamController, t)
					})), [i, o]
				}
				var ze = Number.isInteger || function(t) {
						return "number" === typeof t && isFinite(t) && Math.floor(t) === t
					},
					Ge = function() {
						function t() {
							throw new TypeError("ReadableStreamBYOBRequest cannot be used directly")
						}
						return Object.defineProperty(t.prototype, "view", {
							get: function() {
								if (!1 === Ve(this)) throw Sr("view");
								return this._view
							},
							enumerable: !0,
							configurable: !0
						}), t.prototype.respond = function(t) {
							if (!1 === Ve(this)) throw Sr("respond");
							if (void 0 === this._associatedReadableByteStreamController) throw new TypeError("This BYOB request has been invalidated");
							m(this._view.buffer), mr(this._associatedReadableByteStreamController, t)
						}, t.prototype.respondWithNewView = function(t) {
							if (!1 === Ve(this)) throw Sr("respond");
							if (void 0 === this._associatedReadableByteStreamController) throw new TypeError("This BYOB request has been invalidated");
							if (!ArrayBuffer.isView(t)) throw new TypeError("You can only respond with array buffer views");
							m(t.buffer), br(this._associatedReadableByteStreamController, t)
						}, t
					}(),
					qe = function() {
						function t() {
							throw new TypeError("ReadableByteStreamController constructor cannot be used directly")
						}
						return Object.defineProperty(t.prototype, "byobRequest", {
							get: function() {
								if (!1 === We(this)) throw wr("byobRequest");
								if (void 0 === this._byobRequest && this._pendingPullIntos.length > 0) {
									var t = this._pendingPullIntos.peek(),
										e = new Uint8Array(t.buffer, t.byteOffset + t.bytesFilled, t.byteLength - t.bytesFilled),
										r = Object.create(Ge.prototype);
									vr(r, this, e), this._byobRequest = r
								}
								return this._byobRequest
							},
							enumerable: !0,
							configurable: !0
						}), Object.defineProperty(t.prototype, "desiredSize", {
							get: function() {
								if (!1 === We(this)) throw wr("desiredSize");
								return pr(this)
							},
							enumerable: !0,
							configurable: !0
						}), t.prototype.close = function() {
							if (!1 === We(this)) throw wr("close");
							if (!0 === this._closeRequested) throw new TypeError("The stream has already been closed; do not close it again!");
							var t = this._controlledReadableByteStream._state;
							if ("readable" !== t) throw new TypeError("The stream (in " + t + " state) is not in the readable state and cannot be closed");
							lr(this)
						}, t.prototype.enqueue = function(t) {
							if (!1 === We(this)) throw wr("enqueue");
							if (!0 === this._closeRequested) throw new TypeError("stream is closed or draining");
							var e = this._controlledReadableByteStream._state;
							if ("readable" !== e) throw new TypeError("The stream (in " + e + " state) is not in the readable state and cannot be enqueued to");
							if (!ArrayBuffer.isView(t)) throw new TypeError("You can only enqueue array buffer views when using a ReadableByteStreamController");
							m(t.buffer), fr(this, t)
						}, t.prototype.error = function(t) {
							if (!1 === We(this)) throw wr("error");
							hr(this, t)
						}, t.prototype[G] = function(t) {
							if (this._pendingPullIntos.length > 0) {
								var e = this._pendingPullIntos.peek();
								e.bytesFilled = 0
							}
							dt(this);
							var r = this._cancelAlgorithm(t);
							return dr(this), r
						}, t.prototype[q] = function() {
							var t = this._controlledReadableByteStream;
							if (this._queueTotalSize > 0) {
								var e = this._queue.shift();
								this._queueTotalSize -= e.byteLength, er(this);
								var r = void 0;
								try {
									r = new Uint8Array(e.buffer, e.byteOffset, e.byteLength)
								} catch (s) {
									return A(s)
								}
								return _(R(r, !1, t._reader._forAuthorCode))
							}
							var n = this._autoAllocateChunkSize;
							if (void 0 !== n) {
								var i = void 0;
								try {
									i = new ArrayBuffer(n)
								} catch (c) {
									return A(c)
								}
								var o = {
									buffer: i,
									byteOffset: 0,
									byteLength: n,
									bytesFilled: 0,
									elementSize: 1,
									ctor: Uint8Array,
									readerType: "default"
								};
								this._pendingPullIntos.push(o)
							}
							var a = V(t);
							return He(this), a
						}, t
					}();

				function We(t) {
					return !!o(t) && !!Object.prototype.hasOwnProperty.call(t, "_controlledReadableByteStream")
				}

				function Ve(t) {
					return !!o(t) && !!Object.prototype.hasOwnProperty.call(t, "_associatedReadableByteStreamController")
				}

				function He(t) {
					var e = ur(t);
					if (!1 !== e)
						if (!0 !== t._pulling) {
							t._pulling = !0;
							var r = t._pullAlgorithm();
							E(r, (function() {
								t._pulling = !1, !0 === t._pullAgain && (t._pullAgain = !1, He(t))
							}), (function(e) {
								hr(t, e)
							}))
						} else t._pullAgain = !0
				}

				function Ye(t) {
					rr(t), t._pendingPullIntos = new O
				}

				function Ze(t, e) {
					var r = !1;
					"closed" === t._state && (r = !0);
					var n = Qe(e);
					"default" === e.readerType ? H(t, n, r) : Ar(t, n, r)
				}

				function Qe(t) {
					var e = t.bytesFilled,
						r = t.elementSize;
					return new t.ctor(t.buffer, t.byteOffset, e / r)
				}

				function Je(t, e, r, n) {
					t._queue.push({
						buffer: e,
						byteOffset: r,
						byteLength: n
					}), t._queueTotalSize += n
				}

				function $e(t, e) {
					var r = e.elementSize,
						n = e.bytesFilled - e.bytesFilled % r,
						i = Math.min(t._queueTotalSize, e.byteLength - e.bytesFilled),
						o = e.bytesFilled + i,
						a = o - o % r,
						c = i,
						u = !1;
					a > n && (c = a - e.bytesFilled, u = !0);
					var d = t._queue;
					while (c > 0) {
						var l = d.peek(),
							f = Math.min(c, l.byteLength),
							h = e.byteOffset + e.bytesFilled;
						s(e.buffer, h, l.buffer, l.byteOffset, f), l.byteLength === f ? d.shift() : (l.byteOffset += f, l.byteLength -= f), t._queueTotalSize -= f, tr(t, f, e), c -= f
					}
					return u
				}

				function tr(t, e, r) {
					rr(t), r.bytesFilled += e
				}

				function er(t) {
					0 === t._queueTotalSize && !0 === t._closeRequested ? (dr(t), Fr(t._controlledReadableByteStream)) : He(t)
				}

				function rr(t) {
					void 0 !== t._byobRequest && (t._byobRequest._associatedReadableByteStreamController = void 0, t._byobRequest._view = void 0, t._byobRequest = void 0)
				}

				function nr(t) {
					while (t._pendingPullIntos.length > 0) {
						if (0 === t._queueTotalSize) return;
						var e = t._pendingPullIntos.peek();
						!0 === $e(t, e) && (cr(t), Ze(t._controlledReadableByteStream, e))
					}
				}

				function ir(t, e) {
					var r = t._controlledReadableByteStream,
						n = 1;
					e.constructor !== DataView && (n = e.constructor.BYTES_PER_ELEMENT);
					var i = e.constructor,
						o = p(e.buffer),
						a = {
							buffer: o,
							byteOffset: e.byteOffset,
							byteLength: e.byteLength,
							bytesFilled: 0,
							elementSize: n,
							ctor: i,
							readerType: "byob"
						};
					if (t._pendingPullIntos.length > 0) return t._pendingPullIntos.push(a), _r(r);
					if ("closed" === r._state) {
						var s = new i(a.buffer, a.byteOffset, 0);
						return _(R(s, !0, r._reader._forAuthorCode))
					}
					if (t._queueTotalSize > 0) {
						if (!0 === $e(t, a)) {
							var c = Qe(a);
							return er(t), _(R(c, !1, r._reader._forAuthorCode))
						}
						if (!0 === t._closeRequested) {
							var u = new TypeError("Insufficient bytes to fill elements in the given buffer");
							return hr(t, u), A(u)
						}
					}
					t._pendingPullIntos.push(a);
					var d = _r(r);
					return He(t), d
				}

				function or(t, e) {
					e.buffer = p(e.buffer);
					var r = t._controlledReadableByteStream;
					if (!0 === Er(r))
						while (Ir(r) > 0) {
							var n = cr(t);
							Ze(r, n)
						}
				}

				function ar(t, e, r) {
					if (r.bytesFilled + e > r.byteLength) throw new RangeError("bytesWritten out of range");
					if (tr(t, e, r), !(r.bytesFilled < r.elementSize)) {
						cr(t);
						var n = r.bytesFilled % r.elementSize;
						if (n > 0) {
							var i = r.byteOffset + r.bytesFilled,
								o = r.buffer.slice(i - n, i);
							Je(t, o, 0, o.byteLength)
						}
						r.buffer = p(r.buffer), r.bytesFilled -= n, Ze(t._controlledReadableByteStream, r), nr(t)
					}
				}

				function sr(t, e) {
					var r = t._pendingPullIntos.peek(),
						n = t._controlledReadableByteStream;
					if ("closed" === n._state) {
						if (0 !== e) throw new TypeError("bytesWritten must be 0 when calling respond() on a closed stream");
						or(t, r)
					} else ar(t, e, r);
					He(t)
				}

				function cr(t) {
					var e = t._pendingPullIntos.shift();
					return rr(t), e
				}

				function ur(t) {
					var e = t._controlledReadableByteStream;
					if ("readable" !== e._state) return !1;
					if (!0 === t._closeRequested) return !1;
					if (!1 === t._started) return !1;
					if (!0 === Z(e) && Y(e) > 0) return !0;
					if (!0 === Er(e) && Ir(e) > 0) return !0;
					var r = pr(t);
					return r > 0
				}

				function dr(t) {
					t._pullAlgorithm = void 0, t._cancelAlgorithm = void 0
				}

				function lr(t) {
					var e = t._controlledReadableByteStream;
					if (t._queueTotalSize > 0) t._closeRequested = !0;
					else {
						if (t._pendingPullIntos.length > 0) {
							var r = t._pendingPullIntos.peek();
							if (r.bytesFilled > 0) {
								var n = new TypeError("Insufficient bytes to fill elements in the given buffer");
								throw hr(t, n), n
							}
						}
						dr(t), Fr(e)
					}
				}

				function fr(t, e) {
					var r = t._controlledReadableByteStream,
						n = e.buffer,
						i = e.byteOffset,
						o = e.byteLength,
						a = p(n);
					if (!0 === Z(r))
						if (0 === Y(r)) Je(t, a, i, o);
						else {
							var s = new Uint8Array(a, i, o);
							H(r, s, !1)
						}
					else !0 === Er(r) ? (Je(t, a, i, o), nr(t)) : Je(t, a, i, o);
					He(t)
				}

				function hr(t, e) {
					var r = t._controlledReadableByteStream;
					"readable" === r._state && (Ye(t), dt(t), dr(t), jr(r, e))
				}

				function pr(t) {
					var e = t._controlledReadableByteStream,
						r = e._state;
					return "errored" === r ? null : "closed" === r ? 0 : t._strategyHWM - t._queueTotalSize
				}

				function mr(t, e) {
					if (e = Number(e), !1 === c(e)) throw new RangeError("bytesWritten must be a finite");
					sr(t, e)
				}

				function br(t, e) {
					var r = t._pendingPullIntos.peek();
					if (r.byteOffset + r.bytesFilled !== e.byteOffset) throw new RangeError("The region specified by view does not match byobRequest");
					if (r.byteLength !== e.byteLength) throw new RangeError("The buffer of view has different capacity than byobRequest");
					r.buffer = e.buffer, sr(t, e.byteLength)
				}

				function gr(t, e, r, n, i, o, a) {
					e._controlledReadableByteStream = t, e._pullAgain = !1, e._pulling = !1, e._byobRequest = void 0, e._queue = e._queueTotalSize = void 0, dt(e), e._closeRequested = !1, e._started = !1, e._strategyHWM = b(o), e._pullAlgorithm = n, e._cancelAlgorithm = i, e._autoAllocateChunkSize = a, e._pendingPullIntos = new O, t._readableStreamController = e;
					var s = r();
					E(_(s), (function() {
						e._started = !0, He(e)
					}), (function(t) {
						hr(e, t)
					}))
				}

				function yr(t, e, r) {
					var n = Object.create(qe.prototype);

					function i() {
						return f(e, "start", [n])
					}
					var o = l(e, "pull", 0, [n]),
						a = l(e, "cancel", 1, []),
						s = e.autoAllocateChunkSize;
					if (void 0 !== s && (s = Number(s), !1 === ze(s) || s <= 0)) throw new RangeError("autoAllocateChunkSize must be a positive integer");
					gr(t, n, i, o, a, r, s)
				}

				function vr(t, e, r) {
					t._associatedReadableByteStreamController = e, t._view = r
				}

				function Sr(t) {
					return new TypeError("ReadableStreamBYOBRequest.prototype." + t + " can only be used on a ReadableStreamBYOBRequest")
				}

				function wr(t) {
					return new TypeError("ReadableByteStreamController.prototype." + t + " can only be used on a ReadableByteStreamController")
				}

				function Cr(t, e) {
					void 0 === e && (e = !1);
					var r = new Tr(t);
					return r._forAuthorCode = e, r
				}

				function _r(t) {
					var e = C((function(e, r) {
						var n = {
							_resolve: e,
							_reject: r
						};
						t._reader._readIntoRequests.push(n)
					}));
					return e
				}

				function Ar(t, e, r) {
					var n = t._reader,
						i = n._readIntoRequests.shift();
					i._resolve(R(e, r, n._forAuthorCode))
				}

				function Ir(t) {
					return t._reader._readIntoRequests.length
				}

				function Er(t) {
					var e = t._reader;
					return void 0 !== e && !!xr(e)
				}
				var Tr = function() {
					function t(t) {
						if (!Nr(t)) throw new TypeError("ReadableStreamBYOBReader can only be constructed with a ReadableStream instance given a byte source");
						if (!1 === We(t._readableStreamController)) throw new TypeError("Cannot construct a ReadableStreamBYOBReader for a stream not constructed with a byte source");
						if (Mr(t)) throw new TypeError("This stream has already been locked for exclusive reading by another reader");
						N(this, t), this._readIntoRequests = new O
					}
					return Object.defineProperty(t.prototype, "closed", {
						get: function() {
							return xr(this) ? this._closedPromise : A(kr("closed"))
						},
						enumerable: !0,
						configurable: !0
					}), t.prototype.cancel = function(t) {
						return xr(this) ? void 0 === this._ownerReadableStream ? A(F("cancel")) : M(this, t) : A(kr("cancel"))
					}, t.prototype.read = function(t) {
						return xr(this) ? void 0 === this._ownerReadableStream ? A(F("read from")) : ArrayBuffer.isView(t) ? (m(t.buffer), 0 === t.byteLength ? A(new TypeError("view must have non-zero byteLength")) : Pr(this, t)) : A(new TypeError("view must be an array buffer view")) : A(kr("read"))
					}, t.prototype.releaseLock = function() {
						if (!xr(this)) throw kr("releaseLock");
						if (void 0 !== this._ownerReadableStream) {
							if (this._readIntoRequests.length > 0) throw new TypeError("Tried to release a reader lock when that reader has pending read() calls un-settled");
							B(this)
						}
					}, t
				}();

				function xr(t) {
					return !!o(t) && !!Object.prototype.hasOwnProperty.call(t, "_readIntoRequests")
				}

				function Pr(t, e) {
					var r = t._ownerReadableStream;
					return r._disturbed = !0, "errored" === r._state ? A(r._storedError) : ir(r._readableStreamController, e)
				}

				function kr(t) {
					return new TypeError("ReadableStreamBYOBReader.prototype." + t + " can only be used on a ReadableStreamBYOBReader")
				}
				var Dr = function() {
					function t(t, e) {
						void 0 === t && (t = {}), void 0 === e && (e = {}), Rr(this);
						var r = e.size,
							n = e.highWaterMark,
							i = t.type,
							o = String(i);
						if ("bytes" === o) {
							if (void 0 !== r) throw new RangeError("The strategy for a byte stream cannot have a size function");
							void 0 === n && (n = 0), n = b(n), yr(this, t, n)
						} else {
							if (void 0 !== i) throw new RangeError("Invalid type is specified");
							var a = g(r);
							void 0 === n && (n = 1), n = b(n), Le(this, t, n, a)
						}
					}
					return Object.defineProperty(t.prototype, "locked", {
						get: function() {
							if (!1 === Nr(this)) throw Kr("locked");
							return Mr(this)
						},
						enumerable: !0,
						configurable: !0
					}), t.prototype.cancel = function(t) {
						return !1 === Nr(this) ? A(Kr("cancel")) : !0 === Mr(this) ? A(new TypeError("Cannot cancel a stream that already has a reader")) : Br(this, t)
					}, t.prototype.getReader = function(t) {
						var e = (void 0 === t ? {} : t)
							.mode;
						if (!1 === Nr(this)) throw Kr("getReader");
						if (void 0 === e) return W(this, !0);
						if (e = String(e), "byob" === e) return Cr(this, !0);
						throw new RangeError("Invalid mode is specified")
					}, t.prototype.pipeThrough = function(t, e) {
						var r = t.writable,
							n = t.readable,
							i = void 0 === e ? {} : e,
							o = i.preventClose,
							a = i.preventAbort,
							s = i.preventCancel,
							c = i.signal;
						if (!1 === Nr(this)) throw Kr("pipeThrough");
						if (!1 === gt(r)) throw new TypeError("writable argument to pipeThrough must be a WritableStream");
						if (!1 === Nr(n)) throw new TypeError("readable argument to pipeThrough must be a ReadableStream");
						if (o = Boolean(o), a = Boolean(a), s = Boolean(s), void 0 !== c && !Ce(c)) throw new TypeError("ReadableStream.prototype.pipeThrough's signal option must be an AbortSignal");
						if (!0 === Mr(this)) throw new TypeError("ReadableStream.prototype.pipeThrough cannot be used on a locked ReadableStream");
						if (!0 === yt(r)) throw new TypeError("ReadableStream.prototype.pipeThrough cannot be used on a locked WritableStream");
						var u = Te(this, r, o, a, s, c);
						return k(u), n
					}, t.prototype.pipeTo = function(t, e) {
						var r = void 0 === e ? {} : e,
							n = r.preventClose,
							i = r.preventAbort,
							o = r.preventCancel,
							a = r.signal;
						return !1 === Nr(this) ? A(Kr("pipeTo")) : !1 === gt(t) ? A(new TypeError("ReadableStream.prototype.pipeTo's first argument must be a WritableStream")) : (n = Boolean(n), i = Boolean(i), o = Boolean(o), void 0 === a || Ce(a) ? !0 === Mr(this) ? A(new TypeError("ReadableStream.prototype.pipeTo cannot be used on a locked ReadableStream")) : !0 === yt(t) ? A(new TypeError("ReadableStream.prototype.pipeTo cannot be used on a locked WritableStream")) : Te(this, t, n, i, o, a) : A(new TypeError("ReadableStream.prototype.pipeTo's signal option must be an AbortSignal")))
					}, t.prototype.tee = function() {
						if (!1 === Nr(this)) throw Kr("tee");
						var t = Xe(this);
						return a(t)
					}, t.prototype.getIterator = function(t) {
						var e = (void 0 === t ? {} : t)
							.preventCancel,
							r = void 0 !== e && e;
						if (!1 === Nr(this)) throw Kr("getIterator");
						return it(this, r)
					}, t
				}();

				function Or(t, e, r, n, i) {
					void 0 === n && (n = 1), void 0 === i && (i = function() {
						return 1
					});
					var o = Object.create(Dr.prototype);
					Rr(o);
					var a = Object.create(xe.prototype);
					return Ke(o, a, t, e, r, n, i), o
				}

				function Rr(t) {
					t._state = "readable", t._reader = void 0, t._storedError = void 0, t._disturbed = !1
				}

				function Nr(t) {
					return !!o(t) && !!Object.prototype.hasOwnProperty.call(t, "_readableStreamController")
				}

				function Mr(t) {
					return void 0 !== t._reader
				}

				function Br(t, e) {
					if (t._disturbed = !0, "closed" === t._state) return _(void 0);
					if ("errored" === t._state) return A(t._storedError);
					Fr(t);
					var n = t._readableStreamController[G](e);
					return P(n, r)
				}

				function Fr(t) {
					t._state = "closed";
					var e = t._reader;
					void 0 !== e && (tt(e) && (e._readRequests.forEach((function(t) {
						t._resolve(R(void 0, !0, e._forAuthorCode))
					})), e._readRequests = new O), z(e))
				}

				function jr(t, e) {
					t._state = "errored", t._storedError = e;
					var r = t._reader;
					void 0 !== r && (tt(r) ? (r._readRequests.forEach((function(t) {
						t._reject(e)
					})), r._readRequests = new O) : (r._readIntoRequests.forEach((function(t) {
						t._reject(e)
					})), r._readIntoRequests = new O), U(r, e))
				}

				function Kr(t) {
					return new TypeError("ReadableStream.prototype." + t + " can only be used on a ReadableStream")
				}
				"symbol" === typeof e.asyncIterator && Object.defineProperty(Dr.prototype, e.asyncIterator, {
					value: Dr.prototype.getIterator,
					enumerable: !1,
					writable: !0,
					configurable: !0
				});
				var Lr = function() {
						function t(t) {
							var e = t.highWaterMark;
							this.highWaterMark = e
						}
						return t.prototype.size = function(t) {
							return t.byteLength
						}, t
					}(),
					Ur = function() {
						function t(t) {
							var e = t.highWaterMark;
							this.highWaterMark = e
						}
						return t.prototype.size = function() {
							return 1
						}, t
					}(),
					Xr = function() {
						function t(t, e, r) {
							void 0 === t && (t = {}), void 0 === e && (e = {}), void 0 === r && (r = {});
							var n = e.size,
								i = e.highWaterMark,
								o = r.size,
								a = r.highWaterMark,
								s = t.writableType;
							if (void 0 !== s) throw new RangeError("Invalid writable type specified");
							var c = g(n);
							void 0 === i && (i = 1), i = b(i);
							var u = t.readableType;
							if (void 0 !== u) throw new RangeError("Invalid readable type specified");
							var d, l = g(o);
							void 0 === a && (a = 0), a = b(a);
							var h = C((function(t) {
								d = t
							}));
							zr(this, h, i, c, a, l), Qr(this, t);
							var p = f(t, "start", [this._transformStreamController]);
							d(p)
						}
						return Object.defineProperty(t.prototype, "readable", {
							get: function() {
								if (!1 === Gr(this)) throw un("readable");
								return this._readable
							},
							enumerable: !0,
							configurable: !0
						}), Object.defineProperty(t.prototype, "writable", {
							get: function() {
								if (!1 === Gr(this)) throw un("writable");
								return this._writable
							},
							enumerable: !0,
							configurable: !0
						}), t
					}();

				function zr(t, e, r, n, i, o) {
					function a() {
						return e
					}

					function s(e) {
						return nn(t, e)
					}

					function c(e) {
						return on(t, e)
					}

					function u() {
						return an(t)
					}

					function d() {
						return sn(t)
					}

					function l(e) {
						return Wr(t, e), _(void 0)
					}
					t._writable = mt(a, s, u, c, r, n), t._readable = Or(a, d, l, i, o), t._backpressure = void 0, t._backpressureChangePromise = void 0, t._backpressureChangePromise_resolve = void 0, Vr(t, !0), t._transformStreamController = void 0
				}

				function Gr(t) {
					return !!o(t) && !!Object.prototype.hasOwnProperty.call(t, "_transformStreamController")
				}

				function qr(t, e) {
					Me(t._readable._readableStreamController, e), Wr(t, e)
				}

				function Wr(t, e) {
					Jr(t._transformStreamController), ee(t._writable._writableStreamController, e), !0 === t._backpressure && Vr(t, !1)
				}

				function Vr(t, e) {
					void 0 !== t._backpressureChangePromise && t._backpressureChangePromise_resolve(), t._backpressureChangePromise = C((function(e) {
						t._backpressureChangePromise_resolve = e
					})), t._backpressure = e
				}
				var Hr = function() {
					function t() {
						throw new TypeError("TransformStreamDefaultController instances cannot be created directly")
					}
					return Object.defineProperty(t.prototype, "desiredSize", {
						get: function() {
							if (!1 === Yr(this)) throw cn("desiredSize");
							var t = this._controlledTransformStream._readable._readableStreamController;
							return Be(t)
						},
						enumerable: !0,
						configurable: !0
					}), t.prototype.enqueue = function(t) {
						if (!1 === Yr(this)) throw cn("enqueue");
						$r(this, t)
					}, t.prototype.error = function(t) {
						if (!1 === Yr(this)) throw cn("error");
						tn(this, t)
					}, t.prototype.terminate = function() {
						if (!1 === Yr(this)) throw cn("terminate");
						rn(this)
					}, t
				}();

				function Yr(t) {
					return !!o(t) && !!Object.prototype.hasOwnProperty.call(t, "_controlledTransformStream")
				}

				function Zr(t, e, r, n) {
					e._controlledTransformStream = t, t._transformStreamController = e, e._transformAlgorithm = r, e._flushAlgorithm = n
				}

				function Qr(t, e) {
					var r = Object.create(Hr.prototype),
						n = function(t) {
							try {
								return $r(r, t), _(void 0)
							} catch (e) {
								return A(e)
							}
						},
						i = e.transform;
					if (void 0 !== i) {
						if ("function" !== typeof i) throw new TypeError("transform is not a method");
						n = function(t) {
							return h(i, e, [t, r])
						}
					}
					var o = l(e, "flush", 0, [r]);
					Zr(t, r, n, o)
				}

				function Jr(t) {
					t._transformAlgorithm = void 0, t._flushAlgorithm = void 0
				}

				function $r(t, e) {
					var r = t._controlledTransformStream,
						n = r._readable._readableStreamController;
					if (!1 === je(n)) throw new TypeError("Readable side is not in a state that permits enqueue");
					try {
						Ne(n, e)
					} catch (o) {
						throw Wr(r, o), r._readable._storedError
					}
					var i = Fe(n);
					i !== r._backpressure && Vr(r, !0)
				}

				function tn(t, e) {
					qr(t._controlledTransformStream, e)
				}

				function en(t, e) {
					var r = t._transformAlgorithm(e);
					return P(r, void 0, (function(e) {
						throw qr(t._controlledTransformStream, e), e
					}))
				}

				function rn(t) {
					var e = t._controlledTransformStream,
						r = e._readable._readableStreamController;
					!0 === je(r) && Re(r);
					var n = new TypeError("TransformStream terminated");
					Wr(e, n)
				}

				function nn(t, e) {
					var r = t._transformStreamController;
					if (!0 === t._backpressure) {
						var n = t._backpressureChangePromise;
						return P(n, (function() {
							var n = t._writable,
								i = n._state;
							if ("erroring" === i) throw n._storedError;
							return en(r, e)
						}))
					}
					return en(r, e)
				}

				function on(t, e) {
					return qr(t, e), _(void 0)
				}

				function an(t) {
					var e = t._readable,
						r = t._transformStreamController,
						n = r._flushAlgorithm();
					return Jr(r), P(n, (function() {
						if ("errored" === e._state) throw e._storedError;
						var t = e._readableStreamController;
						!0 === je(t) && Re(t)
					}), (function(r) {
						throw qr(t, r), e._storedError
					}))
				}

				function sn(t) {
					return Vr(t, !1), t._backpressureChangePromise
				}

				function cn(t) {
					return new TypeError("TransformStreamDefaultController.prototype." + t + " can only be used on a TransformStreamDefaultController")
				}

				function un(t) {
					return new TypeError("TransformStream.prototype." + t + " can only be used on a TransformStream")
				}
				t.ByteLengthQueuingStrategy = Lr, t.CountQueuingStrategy = Ur, t.ReadableStream = Dr, t.TransformStream = Xr, t.WritableStream = ht, Object.defineProperty(t, "__esModule", {
					value: !0
				})
			}))
		},
		8875: function(t, e, r) {
			var n, i, o;
			(function(r, a) {
				i = [], n = a, o = "function" === typeof n ? n.apply(e, i) : n, void 0 === o || (t.exports = o)
			})("undefined" !== typeof self && self, (function() {
				function t() {
					var e = Object.getOwnPropertyDescriptor(document, "currentScript");
					if (!e && "currentScript" in document && document.currentScript) return document.currentScript;
					if (e && e.get !== t && document.currentScript) return document.currentScript;
					try {
						throw new Error
					} catch (h) {
						var r, n, i, o = /.*at [^(]*\((.*):(.+):(.+)\)$/gi,
							a = /@([^@]*):(\d+):(\d+)\s*$/gi,
							s = o.exec(h.stack) || a.exec(h.stack),
							c = s && s[1] || !1,
							u = s && s[2] || !1,
							d = document.location.href.replace(document.location.hash, ""),
							l = document.getElementsByTagName("script");
						c === d && (r = document.documentElement.outerHTML, n = new RegExp("(?:[^\\n]+?\\n){0," + (u - 2) + "}[^<]*<script>([\\d\\D]*?)<\\/script>[\\d\\D]*", "i"), i = r.replace(n, "$1")
							.trim());
						for (var f = 0; f < l.length; f++) {
							if ("interactive" === l[f].readyState) return l[f];
							if (l[f].src === c) return l[f];
							if (c === d && l[f].innerHTML && l[f].innerHTML.trim() === i) return l[f]
						}
						return null
					}
				}
				return t
			}))
		},
		8925: function(t, e, r) {
			var n = r("e330"),
				i = r("1626"),
				o = r("c6cd"),
				a = n(Function.toString);
			i(o.inspectSource) || (o.inspectSource = function(t) {
				return a(t)
			}), t.exports = o.inspectSource
		},
		"8a24": function(t, e, r) {
			"use strict";
			const n = r("90da"),
				i = r("90da")
				.buildOptions,
				o = r("f480");
			"<((!\\[CDATA\\[([\\s\\S]*?)(]]>))|((NAME:)?(NAME))([^>]*)>|((\\/)(NAME)\\s*>))([^<]*)".replace(/NAME/g, n.nameRegexp);
			!Number.parseInt && window.parseInt && (Number.parseInt = window.parseInt), !Number.parseFloat && window.parseFloat && (Number.parseFloat = window.parseFloat);
			const a = {
				attributeNamePrefix: "@_",
				attrNodeName: !1,
				textNodeName: "#text",
				ignoreAttributes: !0,
				ignoreNameSpace: !1,
				allowBooleanAttributes: !1,
				parseNodeValue: !0,
				parseAttributeValue: !1,
				arrayMode: !1,
				trimValues: !0,
				cdataTagName: !1,
				cdataPositionChar: "\\c",
				tagValueProcessor: function(t, e) {
					return t
				},
				attrValueProcessor: function(t, e) {
					return t
				},
				stopNodes: []
			};
			e.defaultOptions = a;
			const s = ["attributeNamePrefix", "attrNodeName", "textNodeName", "ignoreAttributes", "ignoreNameSpace", "allowBooleanAttributes", "parseNodeValue", "parseAttributeValue", "arrayMode", "trimValues", "cdataTagName", "cdataPositionChar", "tagValueProcessor", "attrValueProcessor", "parseTrueNumberOnly", "stopNodes"];

			function c(t, e, r) {
				return e && (r.trimValues && (e = e.trim()), e = r.tagValueProcessor(e, t), e = d(e, r.parseNodeValue, r.parseTrueNumberOnly)), e
			}

			function u(t, e) {
				if (e.ignoreNameSpace) {
					const e = t.split(":"),
						r = "/" === t.charAt(0) ? "/" : "";
					if ("xmlns" === e[0]) return "";
					2 === e.length && (t = r + e[1])
				}
				return t
			}

			function d(t, e, r) {
				if (e && "string" === typeof t) {
					let e;
					return "" === t.trim() || isNaN(t) ? e = "true" === t || "false" !== t && t : (-1 !== t.indexOf("0x") ? e = Number.parseInt(t, 16) : -1 !== t.indexOf(".") ? (e = Number.parseFloat(t), t = t.replace(/\.?0+$/, "")) : e = Number.parseInt(t, 10), r && (e = String(e) === t ? e : t)), e
				}
				return n.isExist(t) ? t : ""
			}
			e.props = s;
			const l = new RegExp("([^\\s=]+)\\s*(=\\s*(['\"])(.*?)\\3)?", "g");

			function f(t, e) {
				if (!e.ignoreAttributes && "string" === typeof t) {
					t = t.replace(/\r?\n/g, " ");
					const r = n.getAllMatches(t, l),
						i = r.length,
						o = {};
					for (let t = 0; t < i; t++) {
						const n = u(r[t][1], e);
						n.length && (void 0 !== r[t][4] ? (e.trimValues && (r[t][4] = r[t][4].trim()), r[t][4] = e.attrValueProcessor(r[t][4], n), o[e.attributeNamePrefix + n] = d(r[t][4], e.parseAttributeValue, e.parseTrueNumberOnly)) : e.allowBooleanAttributes && (o[e.attributeNamePrefix + n] = !0))
					}
					if (!Object.keys(o)
						.length) return;
					if (e.attrNodeName) {
						const t = {};
						return t[e.attrNodeName] = o, t
					}
					return o
				}
			}
			const h = function(t, e) {
				t = t.replace(/\r\n?/g, "\n"), e = i(e, a, s);
				const r = new o("!xml");
				let u = r,
					d = "";
				for (let i = 0; i < t.length; i++) {
					const r = t[i];
					if ("<" === r)
						if ("/" === t[i + 1]) {
							const r = m(t, ">", i, "Closing Tag is not closed.");
							let o = t.substring(i + 2, r)
								.trim();
							if (e.ignoreNameSpace) {
								const t = o.indexOf(":"); - 1 !== t && (o = o.substr(t + 1))
							}
							u && (u.val ? u.val = n.getValue(u.val) + "" + c(o, d, e) : u.val = c(o, d, e)), e.stopNodes.length && e.stopNodes.includes(u.tagname) && (u.child = [], void 0 == u.attrsMap && (u.attrsMap = {}), u.val = t.substr(u.startIndex + 1, i - u.startIndex - 1)), u = u.parent, d = "", i = r
						} else if ("?" === t[i + 1]) i = m(t, "?>", i, "Pi Tag is not closed.");
					else if ("!--" === t.substr(i + 1, 3)) i = m(t, "--\x3e", i, "Comment is not closed.");
					else if ("!D" === t.substr(i + 1, 2)) {
						const e = m(t, ">", i, "DOCTYPE is not closed."),
							r = t.substring(i, e);
						i = r.indexOf("[") >= 0 ? t.indexOf("]>", i) + 1 : e
					} else if ("![" === t.substr(i + 1, 2)) {
						const r = m(t, "]]>", i, "CDATA is not closed.") - 2,
							a = t.substring(i + 9, r);
						if (d && (u.val = n.getValue(u.val) + "" + c(u.tagname, d, e), d = ""), e.cdataTagName) {
							const t = new o(e.cdataTagName, u, a);
							u.addChild(t), u.val = n.getValue(u.val) + e.cdataPositionChar, a && (t.val = a)
						} else u.val = (u.val || "") + (a || "");
						i = r + 2
					} else {
						const r = p(t, i + 1);
						let a = r.data;
						const s = r.index,
							l = a.indexOf(" ");
						let h = a;
						if (-1 !== l && (h = a.substr(0, l)
							.replace(/\s\s*$/, ""), a = a.substr(l + 1)), e.ignoreNameSpace) {
							const t = h.indexOf(":"); - 1 !== t && (h = h.substr(t + 1))
						}
						if (u && d && "!xml" !== u.tagname && (u.val = n.getValue(u.val) + "" + c(u.tagname, d, e)), a.length > 0 && a.lastIndexOf("/") === a.length - 1) {
							"/" === h[h.length - 1] ? (h = h.substr(0, h.length - 1), a = h) : a = a.substr(0, a.length - 1);
							const t = new o(h, u, "");
							h !== a && (t.attrsMap = f(a, e)), u.addChild(t)
						} else {
							const t = new o(h, u);
							e.stopNodes.length && e.stopNodes.includes(t.tagname) && (t.startIndex = s), h !== a && (t.attrsMap = f(a, e)), u.addChild(t), u = t
						}
						d = "", i = s
					} else d += t[i]
				}
				return r
			};

			function p(t, e) {
				let r, n = "";
				for (let i = e; i < t.length; i++) {
					let e = t[i];
					if (r) e === r && (r = "");
					else if ('"' === e || "'" === e) r = e;
					else {
						if (">" === e) return {
							data: n,
							index: i
						};
						"\t" === e && (e = " ")
					}
					n += e
				}
			}

			function m(t, e, r, n) {
				const i = t.indexOf(e, r);
				if (-1 === i) throw new Error(n);
				return i + e.length - 1
			}
			e.getTraversalObj = h
		},
		"8a79": function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("e330"),
				o = r("06cf")
				.f,
				a = r("50c4"),
				s = r("577e"),
				c = r("5a34"),
				u = r("1d80"),
				d = r("ab13"),
				l = r("c430"),
				f = i("".endsWith),
				h = i("".slice),
				p = Math.min,
				m = d("endsWith"),
				b = !l && !m && !! function() {
					var t = o(String.prototype, "endsWith");
					return t && !t.writable
				}();
			n({
				target: "String",
				proto: !0,
				forced: !b && !m
			}, {
				endsWith: function(t) {
					var e = s(u(this));
					c(t);
					var r = arguments.length > 1 ? arguments[1] : void 0,
						n = e.length,
						i = void 0 === r ? n : p(a(r), n),
						o = s(t);
					return f ? f(e, o, i) : h(e, i - o.length, i) === o
				}
			})
		},
		"8ac5": function(t, e, r) {
			r("e260"), r("c1f9");
			var n = r("428f");
			t.exports = n.Object.fromEntries
		},
		"8ba4": function(t, e, r) {
			var n = r("23e7"),
				i = r("eac5");
			n({
				target: "Number",
				stat: !0
			}, {
				isInteger: i
			})
		},
		"8df4": function(t, e, r) {
			"use strict";
			var n = r("7a77");

			function i(t) {
				if ("function" !== typeof t) throw new TypeError("executor must be a function.");
				var e;
				this.promise = new Promise((function(t) {
					e = t
				}));
				var r = this;
				t((function(t) {
					r.reason || (r.reason = new n(t), e(r.reason))
				}))
			}
			i.prototype.throwIfRequested = function() {
				if (this.reason) throw this.reason
			}, i.source = function() {
				var t, e = new i((function(e) {
					t = e
				}));
				return {
					token: e,
					cancel: t
				}
			}, t.exports = i
		},
		"8edd": function(t, e, r) {
			var n = r("746f");
			n("matchAll")
		},
		"8f2a": function(t, e, r) {
			r("2954")
		},
		"8f4c": function(t, e, r) {
			r("8a79");
			var n = r("b109");
			t.exports = n("String", "endsWith")
		},
		9020: function(t, e, r) {
			r("9129");
			var n = r("428f");
			t.exports = n.Number.isNaN
		},
		"90d7": function(t, e, r) {
			var n = r("23e7"),
				i = Math.log,
				o = Math.LN2;
			n({
				target: "Math",
				stat: !0
			}, {
				log2: function(t) {
					return i(t) / o
				}
			})
		},
		"90da": function(t, e, r) {
			"use strict";
			const n = ":A-Za-z_\\u00C0-\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02FF\\u0370-\\u037D\\u037F-\\u1FFF\\u200C-\\u200D\\u2070-\\u218F\\u2C00-\\u2FEF\\u3001-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFFD",
				i = n + "\\-.\\d\\u00B7\\u0300-\\u036F\\u203F-\\u2040",
				o = "[" + n + "][" + i + "]*",
				a = new RegExp("^" + o + "$"),
				s = function(t, e) {
					const r = [];
					let n = e.exec(t);
					while (n) {
						const i = [],
							o = n.length;
						for (let t = 0; t < o; t++) i.push(n[t]);
						r.push(i), n = e.exec(t)
					}
					return r
				},
				c = function(t) {
					const e = a.exec(t);
					return !(null === e || "undefined" === typeof e)
				};
			e.isExist = function(t) {
				return "undefined" !== typeof t
			}, e.isEmptyObject = function(t) {
				return 0 === Object.keys(t)
					.length
			}, e.merge = function(t, e, r) {
				if (e) {
					const n = Object.keys(e),
						i = n.length;
					for (let o = 0; o < i; o++) t[n[o]] = "strict" === r ? [e[n[o]]] : e[n[o]]
				}
			}, e.getValue = function(t) {
				return e.isExist(t) ? t : ""
			}, e.buildOptions = function(t, e, r) {
				var n = {};
				if (!t) return e;
				for (let i = 0; i < r.length; i++) void 0 !== t[r[i]] ? n[r[i]] = t[r[i]] : n[r[i]] = e[r[i]];
				return n
			}, e.isName = c, e.getAllMatches = s, e.nameRegexp = o
		},
		"90e3": function(t, e, r) {
			var n = r("e330"),
				i = 0,
				o = Math.random(),
				a = n(1..toString);
			t.exports = function(t) {
				return "Symbol(" + (void 0 === t ? "" : t) + ")_" + a(++i + o, 36)
			}
		},
		9112: function(t, e, r) {
			var n = r("83ab"),
				i = r("9bf2"),
				o = r("5c6c");
			t.exports = n ? function(t, e, r) {
				return i.f(t, e, o(1, r))
			} : function(t, e, r) {
				return t[e] = r, t
			}
		},
		9129: function(t, e, r) {
			var n = r("23e7");
			n({
				target: "Number",
				stat: !0
			}, {
				isNaN: function(t) {
					return t != t
				}
			})
		},
		9152: function(t, e) {
			/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */
			e.read = function(t, e, r, n, i) {
				var o, a, s = 8 * i - n - 1,
					c = (1 << s) - 1,
					u = c >> 1,
					d = -7,
					l = r ? i - 1 : 0,
					f = r ? -1 : 1,
					h = t[e + l];
				for (l += f, o = h & (1 << -d) - 1, h >>= -d, d += s; d > 0; o = 256 * o + t[e + l], l += f, d -= 8);
				for (a = o & (1 << -d) - 1, o >>= -d, d += n; d > 0; a = 256 * a + t[e + l], l += f, d -= 8);
				if (0 === o) o = 1 - u;
				else {
					if (o === c) return a ? NaN : 1 / 0 * (h ? -1 : 1);
					a += Math.pow(2, n), o -= u
				}
				return (h ? -1 : 1) * a * Math.pow(2, o - n)
			}, e.write = function(t, e, r, n, i, o) {
				var a, s, c, u = 8 * o - i - 1,
					d = (1 << u) - 1,
					l = d >> 1,
					f = 23 === i ? Math.pow(2, -24) - Math.pow(2, -77) : 0,
					h = n ? 0 : o - 1,
					p = n ? 1 : -1,
					m = e < 0 || 0 === e && 1 / e < 0 ? 1 : 0;
				for (e = Math.abs(e), isNaN(e) || e === 1 / 0 ? (s = isNaN(e) ? 1 : 0, a = d) : (a = Math.floor(Math.log(e) / Math.LN2), e * (c = Math.pow(2, -a)) < 1 && (a--, c *= 2), e += a + l >= 1 ? f / c : f * Math.pow(2, 1 - l), e * c >= 2 && (a++, c /= 2), a + l >= d ? (s = 0, a = d) : a + l >= 1 ? (s = (e * c - 1) * Math.pow(2, i), a += l) : (s = e * Math.pow(2, l - 1) * Math.pow(2, i), a = 0)); i >= 8; t[r + h] = 255 & s, h += p, s /= 256, i -= 8);
				for (a = a << i | s, u += i; u > 0; t[r + h] = 255 & a, h += p, a /= 256, u -= 8);
				t[r + h - p] |= 128 * m
			}
		},
		"944a": function(t, e, r) {
			var n = r("d066"),
				i = r("746f"),
				o = r("d44e");
			i("toStringTag"), o(n("Symbol"), "Symbol")
		},
		"94ca": function(t, e, r) {
			var n = r("d039"),
				i = r("1626"),
				o = /#|\.prototype\./,
				a = function(t, e) {
					var r = c[s(t)];
					return r == d || r != u && (i(e) ? n(e) : !!e)
				},
				s = a.normalize = function(t) {
					return String(t)
						.replace(o, ".")
						.toLowerCase()
				},
				c = a.data = {},
				u = a.NATIVE = "N",
				d = a.POLYFILL = "P";
			t.exports = a
		},
		"967a": function(t, e, r) {
			r("bb56")
		},
		9861: function(t, e, r) {
			r("5352")
		},
		"99af": function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("da84"),
				o = r("d039"),
				a = r("e8b5"),
				s = r("861d"),
				c = r("7b0b"),
				u = r("07fa"),
				d = r("8418"),
				l = r("65f0"),
				f = r("1dde"),
				h = r("b622"),
				p = r("2d00"),
				m = h("isConcatSpreadable"),
				b = 9007199254740991,
				g = "Maximum allowed index exceeded",
				y = i.TypeError,
				v = p >= 51 || !o((function() {
					var t = [];
					return t[m] = !1, t.concat()[0] !== t
				})),
				S = f("concat"),
				w = function(t) {
					if (!s(t)) return !1;
					var e = t[m];
					return void 0 !== e ? !!e : a(t)
				},
				C = !v || !S;
			n({
				target: "Array",
				proto: !0,
				arity: 1,
				forced: C
			}, {
				concat: function(t) {
					var e, r, n, i, o, a = c(this),
						s = l(a, 0),
						f = 0;
					for (e = -1, n = arguments.length; e < n; e++)
						if (o = -1 === e ? a : arguments[e], w(o)) {
							if (i = u(o), f + i > b) throw y(g);
							for (r = 0; r < i; r++, f++) r in o && d(s, f, o[r])
						} else {
							if (f >= b) throw y(g);
							d(s, f++, o)
						} return s.length = f, s
				}
			})
		},
		"9a0c": function(t, e, r) {
			var n = r("342f");
			t.exports = /Version\/10(?:\.\d+){1,2}(?: [\w./]+)?(?: Mobile\/\w+)? Safari\//.test(n)
		},
		"9a1f": function(t, e, r) {
			var n = r("da84"),
				i = r("c65b"),
				o = r("59ed"),
				a = r("825a"),
				s = r("0d51"),
				c = r("35a1"),
				u = n.TypeError;
			t.exports = function(t, e) {
				var r = arguments.length < 2 ? c(t) : e;
				if (o(r)) return a(i(r, t));
				throw u(s(t) + " is not iterable")
			}
		},
		"9a35": function(t, e, r) {
			r("e260"), r("d3b7"), r("6062"), r("3ca3");
			var n = r("428f");
			t.exports = n.Set
		},
		"9a6e": function(t, e, r) {
			var n, i, o;

			function a(t) {
				return a = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t) {
					return typeof t
				} : function(t) {
					return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
				}, a(t)
			}! function(r, s) {
				"object" == a(e) && "undefined" != typeof t ? s(e) : (i = [e], n = s, o = "function" === typeof n ? n.apply(e, i) : n, void 0 === o || (t.exports = o))
			}(0, (function(t) {
				"use strict";
				var e = "0123456789abcdefghijklmnopqrstuvwxyz";

				function r(t) {
					return e.charAt(t)
				}

				function n(t, e) {
					return t & e
				}

				function i(t, e) {
					return t | e
				}

				function o(t, e) {
					return t ^ e
				}

				function a(t, e) {
					return t & ~e
				}
				var s = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

				function c(t) {
					for (var e, r = "", n = 0; n + 3 <= t.length; n += 3) e = parseInt(t.substring(n, n + 3), 16), r += s.charAt(e >> 6) + s.charAt(63 & e);
					for (n + 1 == t.length ? (e = parseInt(t.substring(n, n + 1), 16), r += s.charAt(e << 2)) : n + 2 == t.length && (e = parseInt(t.substring(n, n + 2), 16), r += s.charAt(e >> 2) + s.charAt((3 & e) << 4)); 0 < (3 & r.length);) r += "=";
					return r
				}

				function u(t) {
					for (var e = "", n = 0, i = 0, o = 0; o < t.length && "=" != t.charAt(o); ++o) {
						var a = s.indexOf(t.charAt(o));
						a < 0 || (n = 0 == n ? (e += r(a >> 2), i = 3 & a, 1) : 1 == n ? (e += r(i << 2 | a >> 4), i = 15 & a, 2) : 2 == n ? (e += r(i), e += r(a >> 2), i = 3 & a, 3) : (e += r(i << 2 | a >> 4), e += r(15 & a), 0))
					}
					return 1 == n && (e += r(i << 2)), e
				}
				var d, l, f = function(t, e) {
						return (f = Object.setPrototypeOf || {
								__proto__: []
							}
							instanceof Array && function(t, e) {
								t.__proto__ = e
							} || function(t, e) {
								for (var r in e) e.hasOwnProperty(r) && (t[r] = e[r])
							})(t, e)
					},
					h = function(t) {
						if (void 0 === d) {
							var e = "0123456789ABCDEF",
								r = " \f\n\r\t \u2028\u2029";
							for (d = {}, a = 0; a < 16; ++a) d[e.charAt(a)] = a;
							for (e = e.toLowerCase(), a = 10; a < 16; ++a) d[e.charAt(a)] = a;
							for (a = 0; a < r.length; ++a) d[r.charAt(a)] = -1
						}
						for (var n = [], i = 0, o = 0, a = 0; a < t.length; ++a) {
							var s = t.charAt(a);
							if ("=" == s) break;
							if (-1 != (s = d[s])) {
								if (void 0 === s) throw new Error("Illegal character at offset " + a);
								i |= s, 2 <= ++o ? (n[n.length] = i, o = i = 0) : i <<= 4
							}
						}
						if (o) throw new Error("Hex encoding incomplete: 4 bits missing");
						return n
					},
					p = {
						decode: function(t) {
							if (void 0 === l) {
								var e = "= \f\n\r\t \u2028\u2029";
								for (l = Object.create(null), o = 0; o < 64; ++o) l["ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(o)] = o;
								for (o = 0; o < e.length; ++o) l[e.charAt(o)] = -1
							}
							for (var r = [], n = 0, i = 0, o = 0; o < t.length; ++o) {
								var a = t.charAt(o);
								if ("=" == a) break;
								if (-1 != (a = l[a])) {
									if (void 0 === a) throw new Error("Illegal character at offset " + o);
									n |= a, 4 <= ++i ? (r[r.length] = n >> 16, r[r.length] = n >> 8 & 255, r[r.length] = 255 & n, i = n = 0) : n <<= 6
								}
							}
							switch (i) {
								case 1:
									throw new Error("Base64 encoding incomplete: at least 2 bits missing");
								case 2:
									r[r.length] = n >> 10;
									break;
								case 3:
									r[r.length] = n >> 16, r[r.length] = n >> 8 & 255
							}
							return r
						},
						re: /-----BEGIN [^-]+-----([A-Za-z0-9+\/=\s]+)-----END [^-]+-----|begin-base64[^\n]+\n([A-Za-z0-9+\/=\s]+)====/,
						unarmor: function(t) {
							var e = p.re.exec(t);
							if (e)
								if (e[1]) t = e[1];
								else {
									if (!e[2]) throw new Error("RegExp out of sync");
									t = e[2]
								} return p.decode(t)
						}
					},
					m = 1e13,
					b = (g.prototype.mulAdd = function(t, e) {
						for (var r, n = this.buf, i = n.length, o = 0; o < i; ++o)(r = n[o] * t + e) < m ? e = 0 : r -= (e = 0 | r / m) * m, n[o] = r;
						0 < e && (n[o] = e)
					}, g.prototype.sub = function(t) {
						for (var e, r = this.buf, n = r.length, i = 0; i < n; ++i) t = (e = r[i] - t) < 0 ? (e += m, 1) : 0, r[i] = e;
						for (; 0 === r[r.length - 1];) r.pop()
					}, g.prototype.toString = function(t) {
						if (10 != (t || 10)) throw new Error("only base 10 is supported");
						for (var e = this.buf, r = e[e.length - 1].toString(), n = e.length - 2; 0 <= n; --n) r += (m + e[n])
							.toString()
							.substring(1);
						return r
					}, g.prototype.valueOf = function() {
						for (var t = this.buf, e = 0, r = t.length - 1; 0 <= r; --r) e = e * m + t[r];
						return e
					}, g.prototype.simplify = function() {
						var t = this.buf;
						return 1 == t.length ? t[0] : this
					}, g);

				function g(t) {
					this.buf = [+t || 0]
				}
				var y = "…",
					v = /^(\d\d)(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])([01]\d|2[0-3])(?:([0-5]\d)(?:([0-5]\d)(?:[.,](\d{1,3}))?)?)?(Z|[-+](?:[0]\d|1[0-2])([0-5]\d)?)?$/,
					S = /^(\d\d\d\d)(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])([01]\d|2[0-3])(?:([0-5]\d)(?:([0-5]\d)(?:[.,](\d{1,3}))?)?)?(Z|[-+](?:[0]\d|1[0-2])([0-5]\d)?)?$/;

				function w(t, e) {
					return t.length > e && (t = t.substring(0, e) + y), t
				}
				var C = (_.prototype.get = function(t) {
					if (void 0 === t && (t = this.pos++), t >= this.enc.length) throw new Error("Requesting byte offset " + t + " on a stream of length " + this.enc.length);
					return "string" == typeof this.enc ? this.enc.charCodeAt(t) : this.enc[t]
				}, _.prototype.hexByte = function(t) {
					return this.hexDigits.charAt(t >> 4 & 15) + this.hexDigits.charAt(15 & t)
				}, _.prototype.hexDump = function(t, e, r) {
					for (var n = "", i = t; i < e; ++i)
						if (n += this.hexByte(this.get(i)), !0 !== r) switch (15 & i) {
							case 7:
								n += "  ";
								break;
							case 15:
								n += "\n";
								break;
							default:
								n += " "
						}
					return n
				}, _.prototype.isASCII = function(t, e) {
					for (var r = t; r < e; ++r) {
						var n = this.get(r);
						if (n < 32 || 176 < n) return !1
					}
					return !0
				}, _.prototype.parseStringISO = function(t, e) {
					for (var r = "", n = t; n < e; ++n) r += String.fromCharCode(this.get(n));
					return r
				}, _.prototype.parseStringUTF = function(t, e) {
					for (var r = "", n = t; n < e;) {
						var i = this.get(n++);
						r += i < 128 ? String.fromCharCode(i) : 191 < i && i < 224 ? String.fromCharCode((31 & i) << 6 | 63 & this.get(n++)) : String.fromCharCode((15 & i) << 12 | (63 & this.get(n++)) << 6 | 63 & this.get(n++))
					}
					return r
				}, _.prototype.parseStringBMP = function(t, e) {
					for (var r, n, i = "", o = t; o < e;) r = this.get(o++), n = this.get(o++), i += String.fromCharCode(r << 8 | n);
					return i
				}, _.prototype.parseTime = function(t, e, r) {
					return t = this.parseStringISO(t, e), e = (r ? v : S)
						.exec(t), e ? (r && (e[1] = +e[1], e[1] += +e[1] < 70 ? 2e3 : 1900), t = e[1] + "-" + e[2] + "-" + e[3] + " " + e[4], e[5] && (t += ":" + e[5], e[6] && (t += ":" + e[6], e[7] && (t += "." + e[7]))), e[8] && (t += " UTC", "Z" != e[8] && (t += e[8], e[9] && (t += ":" + e[9]))), t) : "Unrecognized time: " + t
				}, _.prototype.parseInteger = function(t, e) {
					for (var r, n = this.get(t), i = 127 < n, o = i ? 255 : 0, a = ""; n == o && ++t < e;) n = this.get(t);
					if (0 === (r = e - t)) return i ? -1 : 0;
					if (4 < r) {
						for (a = n, r <<= 3; 0 == (128 & (+a ^ o));) a = +a << 1, --r;
						a = "(" + r + " bit)\n"
					}
					i && (n -= 256);
					for (var s = new b(n), c = t + 1; c < e; ++c) s.mulAdd(256, this.get(c));
					return a + s.toString()
				}, _.prototype.parseBitString = function(t, e, r) {
					for (var n = this.get(t), i = "(" + ((e - t - 1 << 3) - n) + " bit)\n", o = "", a = t + 1; a < e; ++a) {
						for (var s = this.get(a), c = a == e - 1 ? n : 0, u = 7; c <= u; --u) o += s >> u & 1 ? "1" : "0";
						if (o.length > r) return i + w(o, r)
					}
					return i + o
				}, _.prototype.parseOctetString = function(t, e, r) {
					if (this.isASCII(t, e)) return w(this.parseStringISO(t, e), r);
					var n = e - t,
						i = "(" + n + " byte)\n";
					(r /= 2) < n && (e = t + r);
					for (var o = t; o < e; ++o) i += this.hexByte(this.get(o));
					return r < n && (i += y), i
				}, _.prototype.parseOID = function(t, e, r) {
					for (var n = "", i = new b, o = 0, a = t; a < e; ++a) {
						var s = this.get(a);
						if (i.mulAdd(128, 127 & s), o += 7, !(128 & s)) {
							if ("" === n ? n = (i = i.simplify()) instanceof b ? (i.sub(80), "2." + i.toString()) : (s = i < 80 ? i < 40 ? 0 : 1 : 2) + "." + (i - 40 * s) : n += "." + i.toString(), n.length > r) return w(n, r);
							i = new b, o = 0
						}
					}
					return 0 < o && (n += ".incomplete"), n
				}, _);

				function _(t, e) {
					this.hexDigits = "0123456789ABCDEF", t instanceof _ ? (this.enc = t.enc, this.pos = t.pos) : (this.enc = t, this.pos = e)
				}
				var A = (I.prototype.typeName = function() {
					switch (this.tag.tagClass) {
						case 0:
							switch (this.tag.tagNumber) {
								case 0:
									return "EOC";
								case 1:
									return "BOOLEAN";
								case 2:
									return "INTEGER";
								case 3:
									return "BIT_STRING";
								case 4:
									return "OCTET_STRING";
								case 5:
									return "NULL";
								case 6:
									return "OBJECT_IDENTIFIER";
								case 7:
									return "ObjectDescriptor";
								case 8:
									return "EXTERNAL";
								case 9:
									return "REAL";
								case 10:
									return "ENUMERATED";
								case 11:
									return "EMBEDDED_PDV";
								case 12:
									return "UTF8String";
								case 16:
									return "SEQUENCE";
								case 17:
									return "SET";
								case 18:
									return "NumericString";
								case 19:
									return "PrintableString";
								case 20:
									return "TeletexString";
								case 21:
									return "VideotexString";
								case 22:
									return "IA5String";
								case 23:
									return "UTCTime";
								case 24:
									return "GeneralizedTime";
								case 25:
									return "GraphicString";
								case 26:
									return "VisibleString";
								case 27:
									return "GeneralString";
								case 28:
									return "UniversalString";
								case 30:
									return "BMPString"
							}
							return "Universal_" + this.tag.tagNumber.toString();
						case 1:
							return "Application_" + this.tag.tagNumber.toString();
						case 2:
							return "[" + this.tag.tagNumber.toString() + "]";
						case 3:
							return "Private_" + this.tag.tagNumber.toString()
					}
				}, I.prototype.content = function(t) {
					if (void 0 === this.tag) return null;
					void 0 === t && (t = 1 / 0);
					var e = this.posContent(),
						r = Math.abs(this.length);
					if (!this.tag.isUniversal()) return null !== this.sub ? "(" + this.sub.length + " elem)" : this.stream.parseOctetString(e, e + r, t);
					switch (this.tag.tagNumber) {
						case 1:
							return 0 === this.stream.get(e) ? "false" : "true";
						case 2:
							return this.stream.parseInteger(e, e + r);
						case 3:
							return this.sub ? "(" + this.sub.length + " elem)" : this.stream.parseBitString(e, e + r, t);
						case 4:
							return this.sub ? "(" + this.sub.length + " elem)" : this.stream.parseOctetString(e, e + r, t);
						case 6:
							return this.stream.parseOID(e, e + r, t);
						case 16:
						case 17:
							return null !== this.sub ? "(" + this.sub.length + " elem)" : "(no elem)";
						case 12:
							return w(this.stream.parseStringUTF(e, e + r), t);
						case 18:
						case 19:
						case 20:
						case 21:
						case 22:
						case 26:
							return w(this.stream.parseStringISO(e, e + r), t);
						case 30:
							return w(this.stream.parseStringBMP(e, e + r), t);
						case 23:
						case 24:
							return this.stream.parseTime(e, e + r, 23 == this.tag.tagNumber)
					}
					return null
				}, I.prototype.toString = function() {
					return this.typeName() + "@" + this.stream.pos + "[header:" + this.header + ",length:" + this.length + ",sub:" + (null === this.sub ? "null" : this.sub.length) + "]"
				}, I.prototype.toPrettyString = function(t) {
					void 0 === t && (t = "");
					var e = t + this.typeName() + " @" + this.stream.pos;
					if (0 <= this.length && (e += "+"), e += this.length, this.tag.tagConstructed ? e += " (constructed)" : !this.tag.isUniversal() || 3 != this.tag.tagNumber && 4 != this.tag.tagNumber || null === this.sub || (e += " (encapsulates)"), e += "\n", null !== this.sub) {
						t += "  ";
						for (var r = 0, n = this.sub.length; r < n; ++r) e += this.sub[r].toPrettyString(t)
					}
					return e
				}, I.prototype.posStart = function() {
					return this.stream.pos
				}, I.prototype.posContent = function() {
					return this.stream.pos + this.header
				}, I.prototype.posEnd = function() {
					return this.stream.pos + this.header + Math.abs(this.length)
				}, I.prototype.toHexString = function() {
					return this.stream.hexDump(this.posStart(), this.posEnd(), !0)
				}, I.decodeLength = function(t) {
					var e = t.get(),
						r = 127 & e;
					if (r == e) return r;
					if (6 < r) throw new Error("Length over 48 bits not supported at position " + (t.pos - 1));
					if (0 == r) return null;
					for (var n = e = 0; n < r; ++n) e = 256 * e + t.get();
					return e
				}, I.prototype.getHexStringValue = function() {
					var t = this.toHexString(),
						e = 2 * this.header,
						r = 2 * this.length;
					return t.substr(e, r)
				}, I.decode = function(t) {
					function e() {
						var t = [];
						if (null !== o) {
							for (var e = a + o; r.pos < e;) t[t.length] = I.decode(r);
							if (r.pos != e) throw new Error("Content size is not correct for container starting at offset " + a)
						} else try {
							for (;;) {
								var n = I.decode(r);
								if (n.tag.isEOC()) break;
								t[t.length] = n
							}
							o = a - r.pos
						} catch (t) {
							throw new Error("Exception while decoding undefined length content: " + t)
						}
						return t
					}
					var r = t instanceof C ? t : new C(t, 0),
						n = new C(r),
						i = new E(r),
						o = I.decodeLength(r),
						a = r.pos,
						s = (t = a - n.pos, null);
					if (i.tagConstructed) s = e();
					else if (i.isUniversal() && (3 == i.tagNumber || 4 == i.tagNumber)) try {
						if (3 == i.tagNumber && 0 != r.get()) throw new Error("BIT STRINGs with unused bits cannot encapsulate.");
						s = e();
						for (var c = 0; c < s.length; ++c)
							if (s[c].tag.isEOC()) throw new Error("EOC is not supposed to be actual content.")
					} catch (t) {
						s = null
					}
					if (null === s) {
						if (null === o) throw new Error("We can't skip over an invalid tag with undefined length at offset " + a);
						r.pos = a + Math.abs(o)
					}
					return new I(n, t, o, i, s)
				}, I);

				function I(t, e, r, n, i) {
					if (!(n instanceof E)) throw new Error("Invalid tag value.");
					this.stream = t, this.header = e, this.length = r, this.tag = n, this.sub = i
				}
				var E = (T.prototype.isUniversal = function() {
					return 0 === this.tagClass
				}, T.prototype.isEOC = function() {
					return 0 === this.tagClass && 0 === this.tagNumber
				}, T);

				function T(t) {
					var e = t.get();
					if (this.tagClass = e >> 6, this.tagConstructed = 0 != (32 & e), this.tagNumber = 31 & e, 31 == this.tagNumber) {
						for (var r = new b; e = t.get(), r.mulAdd(128, 127 & e), 128 & e;);
						this.tagNumber = r.simplify()
					}
				}
				var x = [2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997],
					P = (1 << 26) / x[x.length - 1],
					k = (D.prototype.toString = function(t) {
						if (this.s < 0) return "-" + this.negate()
							.toString(t);
						var e;
						if (16 == t) e = 4;
						else if (8 == t) e = 3;
						else if (2 == t) e = 1;
						else if (32 == t) e = 5;
						else {
							if (4 != t) return this.toRadix(t);
							e = 2
						}
						var n, i = (1 << e) - 1,
							o = !1,
							a = "",
							s = this.t,
							c = this.DB - s * this.DB % e;
						if (0 < s--)
							for (c < this.DB && 0 < (n = this[s] >> c) && (o = !0, a = r(n)); 0 <= s;) c < e ? (n = (this[s] & (1 << c) - 1) << e - c, n |= this[--s] >> (c += this.DB - e)) : (n = this[s] >> (c -= e) & i, c <= 0 && (c += this.DB, --s)), 0 < n && (o = !0), o && (a += r(n));
						return o ? a : "0"
					}, D.prototype.negate = function() {
						var t = L();
						return D.ZERO.subTo(this, t), t
					}, D.prototype.abs = function() {
						return this.s < 0 ? this.negate() : this
					}, D.prototype.compareTo = function(t) {
						var e = this.s - t.s;
						if (0 != e) return e;
						var r = this.t;
						if (0 != (e = r - t.t)) return this.s < 0 ? -e : e;
						for (; 0 <= --r;)
							if (0 != (e = this[r] - t[r])) return e;
						return 0
					}, D.prototype.bitLength = function() {
						return this.t <= 0 ? 0 : this.DB * (this.t - 1) + V(this[this.t - 1] ^ this.s & this.DM)
					}, D.prototype.mod = function(t) {
						var e = L();
						return this.abs()
							.divRemTo(t, null, e), this.s < 0 && 0 < e.compareTo(D.ZERO) && t.subTo(e, e), e
					}, D.prototype.modPowInt = function(t, e) {
						return e = new(t < 256 || e.isEven() ? N : B)(e), this.exp(t, e)
					}, D.prototype.clone = function() {
						var t = L();
						return this.copyTo(t), t
					}, D.prototype.intValue = function() {
						if (this.s < 0) {
							if (1 == this.t) return this[0] - this.DV;
							if (0 == this.t) return -1
						} else {
							if (1 == this.t) return this[0];
							if (0 == this.t) return 0
						}
						return (this[1] & (1 << 32 - this.DB) - 1) << this.DB | this[0]
					}, D.prototype.byteValue = function() {
						return 0 == this.t ? this.s : this[0] << 24 >> 24
					}, D.prototype.shortValue = function() {
						return 0 == this.t ? this.s : this[0] << 16 >> 16
					}, D.prototype.signum = function() {
						return this.s < 0 ? -1 : this.t <= 0 || 1 == this.t && this[0] <= 0 ? 0 : 1
					}, D.prototype.toByteArray = function() {
						var t = this.t,
							e = [];
						e[0] = this.s;
						var r, n = this.DB - t * this.DB % 8,
							i = 0;
						if (0 < t--)
							for (n < this.DB && (r = this[t] >> n) != (this.s & this.DM) >> n && (e[i++] = r | this.s << this.DB - n); 0 <= t;) n < 8 ? (r = (this[t] & (1 << n) - 1) << 8 - n, r |= this[--t] >> (n += this.DB - 8)) : (r = this[t] >> (n -= 8) & 255, n <= 0 && (n += this.DB, --t)), 0 != (128 & r) && (r |= -256), 0 == i && (128 & this.s) != (128 & r) && ++i, (0 < i || r != this.s) && (e[i++] = r);
						return e
					}, D.prototype.equals = function(t) {
						return 0 == this.compareTo(t)
					}, D.prototype.min = function(t) {
						return this.compareTo(t) < 0 ? this : t
					}, D.prototype.max = function(t) {
						return 0 < this.compareTo(t) ? this : t
					}, D.prototype.and = function(t) {
						var e = L();
						return this.bitwiseTo(t, n, e), e
					}, D.prototype.or = function(t) {
						var e = L();
						return this.bitwiseTo(t, i, e), e
					}, D.prototype.xor = function(t) {
						var e = L();
						return this.bitwiseTo(t, o, e), e
					}, D.prototype.andNot = function(t) {
						var e = L();
						return this.bitwiseTo(t, a, e), e
					}, D.prototype.not = function() {
						for (var t = L(), e = 0; e < this.t; ++e) t[e] = this.DM & ~this[e];
						return t.t = this.t, t.s = ~this.s, t
					}, D.prototype.shiftLeft = function(t) {
						var e = L();
						return t < 0 ? this.rShiftTo(-t, e) : this.lShiftTo(t, e), e
					}, D.prototype.shiftRight = function(t) {
						var e = L();
						return t < 0 ? this.lShiftTo(-t, e) : this.rShiftTo(t, e), e
					}, D.prototype.getLowestSetBit = function() {
						for (var t = 0; t < this.t; ++t)
							if (0 != this[t]) return t * this.DB + function(t) {
								if (0 == t) return -1;
								var e = 0;
								return 0 == (65535 & t) && (t >>= 16, e += 16), 0 == (255 & t) && (t >>= 8, e += 8), 0 == (15 & t) && (t >>= 4, e += 4), 0 == (3 & t) && (t >>= 2, e += 2), 0 == (1 & t) && ++e, e
							}(this[t]);
						return this.s < 0 ? this.t * this.DB : -1
					}, D.prototype.bitCount = function() {
						for (var t = 0, e = this.s & this.DM, r = 0; r < this.t; ++r) t += function(t) {
							for (var e = 0; 0 != t;) t &= t - 1, ++e;
							return e
						}(this[r] ^ e);
						return t
					}, D.prototype.testBit = function(t) {
						var e = Math.floor(t / this.DB);
						return e >= this.t ? 0 != this.s : 0 != (this[e] & 1 << t % this.DB)
					}, D.prototype.setBit = function(t) {
						return this.changeBit(t, i)
					}, D.prototype.clearBit = function(t) {
						return this.changeBit(t, a)
					}, D.prototype.flipBit = function(t) {
						return this.changeBit(t, o)
					}, D.prototype.add = function(t) {
						var e = L();
						return this.addTo(t, e), e
					}, D.prototype.subtract = function(t) {
						var e = L();
						return this.subTo(t, e), e
					}, D.prototype.multiply = function(t) {
						var e = L();
						return this.multiplyTo(t, e), e
					}, D.prototype.divide = function(t) {
						var e = L();
						return this.divRemTo(t, e, null), e
					}, D.prototype.remainder = function(t) {
						var e = L();
						return this.divRemTo(t, null, e), e
					}, D.prototype.divideAndRemainder = function(t) {
						var e = L(),
							r = L();
						return this.divRemTo(t, e, r), [e, r]
					}, D.prototype.modPow = function(t, e) {
						var r, n, i = t.bitLength(),
							o = W(1);
						if (i <= 0) return o;
						r = i < 18 ? 1 : i < 48 ? 3 : i < 144 ? 4 : i < 768 ? 5 : 6, n = new(i < 8 ? N : e.isEven() ? j : B)(e);
						var a = [],
							s = 3,
							c = r - 1,
							u = (1 << r) - 1;
						if (a[1] = n.convert(this), 1 < r) {
							var d = L();
							for (n.sqrTo(a[1], d); s <= u;) a[s] = L(), n.mulTo(d, a[s - 2], a[s]), s += 2
						}
						var l, f, h = t.t - 1,
							p = !0,
							m = L();
						for (i = V(t[h]) - 1; 0 <= h;) {
							for (c <= i ? l = t[h] >> i - c & u : (l = (t[h] & (1 << i + 1) - 1) << c - i, 0 < h && (l |= t[h - 1] >> this.DB + i - c)), s = r; 0 == (1 & l);) l >>= 1, --s;
							if ((i -= s) < 0 && (i += this.DB, --h), p) a[l].copyTo(o), p = !1;
							else {
								for (; 1 < s;) n.sqrTo(o, m), n.sqrTo(m, o), s -= 2;
								0 < s ? n.sqrTo(o, m) : (f = o, o = m, m = f), n.mulTo(m, a[l], o)
							}
							for (; 0 <= h && 0 == (t[h] & 1 << i);) n.sqrTo(o, m), f = o, o = m, m = f, --i < 0 && (i = this.DB - 1, --h)
						}
						return n.revert(o)
					}, D.prototype.modInverse = function(t) {
						var e = t.isEven();
						if (this.isEven() && e || 0 == t.signum()) return D.ZERO;
						for (var r = t.clone(), n = this.clone(), i = W(1), o = W(0), a = W(0), s = W(1); 0 != r.signum();) {
							for (; r.isEven();) r.rShiftTo(1, r), e ? (i.isEven() && o.isEven() || (i.addTo(this, i), o.subTo(t, o)), i.rShiftTo(1, i)) : o.isEven() || o.subTo(t, o), o.rShiftTo(1, o);
							for (; n.isEven();) n.rShiftTo(1, n), e ? (a.isEven() && s.isEven() || (a.addTo(this, a), s.subTo(t, s)), a.rShiftTo(1, a)) : s.isEven() || s.subTo(t, s), s.rShiftTo(1, s);
							0 <= r.compareTo(n) ? (r.subTo(n, r), e && i.subTo(a, i), o.subTo(s, o)) : (n.subTo(r, n), e && a.subTo(i, a), s.subTo(o, s))
						}
						return 0 != n.compareTo(D.ONE) ? D.ZERO : 0 <= s.compareTo(t) ? s.subtract(t) : s.signum() < 0 ? (s.addTo(t, s), s.signum() < 0 ? s.add(t) : s) : s
					}, D.prototype.pow = function(t) {
						return this.exp(t, new O)
					}, D.prototype.gcd = function(t) {
						var e = this.s < 0 ? this.negate() : this.clone(),
							r = t.s < 0 ? t.negate() : t.clone();
						e.compareTo(r) < 0 && (i = e, e = r, r = i);
						var n = e.getLowestSetBit(),
							i = r.getLowestSetBit();
						if (i < 0) return e;
						for (n < i && (i = n), 0 < i && (e.rShiftTo(i, e), r.rShiftTo(i, r)); 0 < e.signum();) 0 < (n = e.getLowestSetBit()) && e.rShiftTo(n, e), 0 < (n = r.getLowestSetBit()) && r.rShiftTo(n, r), 0 <= e.compareTo(r) ? (e.subTo(r, e), e.rShiftTo(1, e)) : (r.subTo(e, r), r.rShiftTo(1, r));
						return 0 < i && r.lShiftTo(i, r), r
					}, D.prototype.isProbablePrime = function(t) {
						var e, r = this.abs();
						if (1 == r.t && r[0] <= x[x.length - 1]) {
							for (e = 0; e < x.length; ++e)
								if (r[0] == x[e]) return !0;
							return !1
						}
						if (r.isEven()) return !1;
						for (e = 1; e < x.length;) {
							for (var n = x[e], i = e + 1; i < x.length && n < P;) n *= x[i++];
							for (n = r.modInt(n); e < i;)
								if (n % x[e++] == 0) return !1
						}
						return r.millerRabin(t)
					}, D.prototype.copyTo = function(t) {
						for (var e = this.t - 1; 0 <= e; --e) t[e] = this[e];
						t.t = this.t, t.s = this.s
					}, D.prototype.fromInt = function(t) {
						this.t = 1, this.s = t < 0 ? -1 : 0, 0 < t ? this[0] = t : t < -1 ? this[0] = t + this.DV : this.t = 0
					}, D.prototype.fromString = function(t, e) {
						var r;
						if (16 == e) r = 4;
						else if (8 == e) r = 3;
						else if (256 == e) r = 8;
						else if (2 == e) r = 1;
						else if (32 == e) r = 5;
						else {
							if (4 != e) return void this.fromRadix(t, e);
							r = 2
						}
						this.t = 0, this.s = 0;
						for (var n = t.length, i = !1, o = 0; 0 <= --n;) {
							var a = 8 == r ? 255 & +t[n] : q(t, n);
							a < 0 ? "-" == t.charAt(n) && (i = !0) : (i = !1, 0 == o ? this[this.t++] = a : o + r > this.DB ? (this[this.t - 1] |= (a & (1 << this.DB - o) - 1) << o, this[this.t++] = a >> this.DB - o) : this[this.t - 1] |= a << o, (o += r) >= this.DB && (o -= this.DB))
						}
						8 == r && 0 != (128 & +t[0]) && (this.s = -1, 0 < o && (this[this.t - 1] |= (1 << this.DB - o) - 1 << o)), this.clamp(), i && D.ZERO.subTo(this, this)
					}, D.prototype.clamp = function() {
						for (var t = this.s & this.DM; 0 < this.t && this[this.t - 1] == t;) --this.t
					}, D.prototype.dlShiftTo = function(t, e) {
						for (var r = this.t - 1; 0 <= r; --r) e[r + t] = this[r];
						for (r = t - 1; 0 <= r; --r) e[r] = 0;
						e.t = this.t + t, e.s = this.s
					}, D.prototype.drShiftTo = function(t, e) {
						for (var r = t; r < this.t; ++r) e[r - t] = this[r];
						e.t = Math.max(this.t - t, 0), e.s = this.s
					}, D.prototype.lShiftTo = function(t, e) {
						for (var r = t % this.DB, n = this.DB - r, i = (1 << n) - 1, o = Math.floor(t / this.DB), a = this.s << r & this.DM, s = this.t - 1; 0 <= s; --s) e[s + o + 1] = this[s] >> n | a, a = (this[s] & i) << r;
						for (s = o - 1; 0 <= s; --s) e[s] = 0;
						e[o] = a, e.t = this.t + o + 1, e.s = this.s, e.clamp()
					}, D.prototype.rShiftTo = function(t, e) {
						e.s = this.s;
						var r = Math.floor(t / this.DB);
						if (r >= this.t) e.t = 0;
						else {
							var n = t % this.DB,
								i = this.DB - n,
								o = (1 << n) - 1;
							e[0] = this[r] >> n;
							for (var a = r + 1; a < this.t; ++a) e[a - r - 1] |= (this[a] & o) << i, e[a - r] = this[a] >> n;
							0 < n && (e[this.t - r - 1] |= (this.s & o) << i), e.t = this.t - r, e.clamp()
						}
					}, D.prototype.subTo = function(t, e) {
						for (var r = 0, n = 0, i = Math.min(t.t, this.t); r < i;) n += this[r] - t[r], e[r++] = n & this.DM, n >>= this.DB;
						if (t.t < this.t) {
							for (n -= t.s; r < this.t;) n += this[r], e[r++] = n & this.DM, n >>= this.DB;
							n += this.s
						} else {
							for (n += this.s; r < t.t;) n -= t[r], e[r++] = n & this.DM, n >>= this.DB;
							n -= t.s
						}
						e.s = n < 0 ? -1 : 0, n < -1 ? e[r++] = this.DV + n : 0 < n && (e[r++] = n), e.t = r, e.clamp()
					}, D.prototype.multiplyTo = function(t, e) {
						var r = this.abs(),
							n = t.abs(),
							i = r.t;
						for (e.t = i + n.t; 0 <= --i;) e[i] = 0;
						for (i = 0; i < n.t; ++i) e[i + r.t] = r.am(0, n[i], e, i, 0, r.t);
						e.s = 0, e.clamp(), this.s != t.s && D.ZERO.subTo(e, e)
					}, D.prototype.squareTo = function(t) {
						for (var e = this.abs(), r = t.t = 2 * e.t; 0 <= --r;) t[r] = 0;
						for (r = 0; r < e.t - 1; ++r) {
							var n = e.am(r, e[r], t, 2 * r, 0, 1);
							(t[r + e.t] += e.am(r + 1, 2 * e[r], t, 2 * r + 1, n, e.t - r - 1)) >= e.DV && (t[r + e.t] -= e.DV, t[r + e.t + 1] = 1)
						}
						0 < t.t && (t[t.t - 1] += e.am(r, e[r], t, 2 * r, 0, 1)), t.s = 0, t.clamp()
					}, D.prototype.divRemTo = function(t, e, r) {
						var n = t.abs();
						if (!(n.t <= 0)) {
							var i = this.abs();
							if (i.t < n.t) return null != e && e.fromInt(0), void(null != r && this.copyTo(r));
							null == r && (r = L());
							var o = L(),
								a = this.s,
								s = t.s;
							t = this.DB - V(n[n.t - 1]);
							0 < t ? (n.lShiftTo(t, o), i.lShiftTo(t, r)) : (n.copyTo(o), i.copyTo(r));
							var c = o.t,
								u = o[c - 1];
							if (0 != u) {
								i = u * (1 << this.F1) + (1 < c ? o[c - 2] >> this.F2 : 0);
								var d = this.FV / i,
									l = (1 << this.F1) / i,
									f = 1 << this.F2,
									h = r.t,
									p = h - c,
									m = null == e ? L() : e;
								for (o.dlShiftTo(p, m), 0 <= r.compareTo(m) && (r[r.t++] = 1, r.subTo(m, r)), D.ONE.dlShiftTo(c, m), m.subTo(o, o); o.t < c;) o[o.t++] = 0;
								for (; 0 <= --p;) {
									var b = r[--h] == u ? this.DM : Math.floor(r[h] * d + (r[h - 1] + f) * l);
									if ((r[h] += o.am(0, b, r, p, 0, c)) < b)
										for (o.dlShiftTo(p, m), r.subTo(m, r); r[h] < --b;) r.subTo(m, r)
								}
								null != e && (r.drShiftTo(c, e), a != s && D.ZERO.subTo(e, e)), r.t = c, r.clamp(), 0 < t && r.rShiftTo(t, r), a < 0 && D.ZERO.subTo(r, r)
							}
						}
					}, D.prototype.invDigit = function() {
						if (this.t < 1) return 0;
						var t = this[0];
						if (0 == (1 & t)) return 0;
						var e = 3 & t;
						return 0 < (e = (e = (e = (e = e * (2 - (15 & t) * e) & 15) * (2 - (255 & t) * e) & 255) * (2 - ((65535 & t) * e & 65535)) & 65535) * (2 - t * e % this.DV) % this.DV) ? this.DV - e : -e
					}, D.prototype.isEven = function() {
						return 0 == (0 < this.t ? 1 & this[0] : this.s)
					}, D.prototype.exp = function(t, e) {
						if (4294967295 < t || t < 1) return D.ONE;
						var r, n = L(),
							i = L(),
							o = e.convert(this),
							a = V(t) - 1;
						for (o.copyTo(n); 0 <= --a;) e.sqrTo(n, i), 0 < (t & 1 << a) ? e.mulTo(i, o, n) : (r = n, n = i, i = r);
						return e.revert(n)
					}, D.prototype.chunkSize = function(t) {
						return Math.floor(Math.LN2 * this.DB / Math.log(t))
					}, D.prototype.toRadix = function(t) {
						if (null == t && (t = 10), 0 == this.signum() || t < 2 || 36 < t) return "0";
						var e = this.chunkSize(t),
							r = Math.pow(t, e),
							n = W(r),
							i = L(),
							o = L(),
							a = "";
						for (this.divRemTo(n, i, o); 0 < i.signum();) a = (r + o.intValue())
							.toString(t)
							.substr(1) + a, i.divRemTo(n, i, o);
						return o.intValue()
							.toString(t) + a
					}, D.prototype.fromRadix = function(t, e) {
						this.fromInt(0), null == e && (e = 10);
						for (var r = this.chunkSize(e), n = Math.pow(e, r), i = !1, o = 0, a = 0, s = 0; s < t.length; ++s) {
							var c = q(t, s);
							c < 0 ? "-" == t.charAt(s) && 0 == this.signum() && (i = !0) : (a = e * a + c, ++o >= r && (this.dMultiply(n), this.dAddOffset(a, 0), a = o = 0))
						}
						0 < o && (this.dMultiply(Math.pow(e, o)), this.dAddOffset(a, 0)), i && D.ZERO.subTo(this, this)
					}, D.prototype.fromNumber = function(t, e, r) {
						if ("number" == typeof e)
							if (t < 2) this.fromInt(1);
							else
								for (this.fromNumber(t, r), this.testBit(t - 1) || this.bitwiseTo(D.ONE.shiftLeft(t - 1), i, this), this.isEven() && this.dAddOffset(1, 0); !this.isProbablePrime(e);) this.dAddOffset(2, 0), this.bitLength() > t && this.subTo(D.ONE.shiftLeft(t - 1), this);
						else {
							var n = [];
							r = 7 & t;
							n.length = 1 + (t >> 3), e.nextBytes(n), 0 < r ? n[0] &= (1 << r) - 1 : n[0] = 0, this.fromString(n, 256)
						}
					}, D.prototype.bitwiseTo = function(t, e, r) {
						for (var n, i = Math.min(t.t, this.t), o = 0; o < i; ++o) r[o] = e(this[o], t[o]);
						if (t.t < this.t) {
							for (n = t.s & this.DM, o = i; o < this.t; ++o) r[o] = e(this[o], n);
							r.t = this.t
						} else {
							for (n = this.s & this.DM, o = i; o < t.t; ++o) r[o] = e(n, t[o]);
							r.t = t.t
						}
						r.s = e(this.s, t.s), r.clamp()
					}, D.prototype.changeBit = function(t, e) {
						return t = D.ONE.shiftLeft(t), this.bitwiseTo(t, e, t), t
					}, D.prototype.addTo = function(t, e) {
						for (var r = 0, n = 0, i = Math.min(t.t, this.t); r < i;) n += this[r] + t[r], e[r++] = n & this.DM, n >>= this.DB;
						if (t.t < this.t) {
							for (n += t.s; r < this.t;) n += this[r], e[r++] = n & this.DM, n >>= this.DB;
							n += this.s
						} else {
							for (n += this.s; r < t.t;) n += t[r], e[r++] = n & this.DM, n >>= this.DB;
							n += t.s
						}
						e.s = n < 0 ? -1 : 0, 0 < n ? e[r++] = n : n < -1 && (e[r++] = this.DV + n), e.t = r, e.clamp()
					}, D.prototype.dMultiply = function(t) {
						this[this.t] = this.am(0, t - 1, this, 0, 0, this.t), ++this.t, this.clamp()
					}, D.prototype.dAddOffset = function(t, e) {
						if (0 != t) {
							for (; this.t <= e;) this[this.t++] = 0;
							for (this[e] += t; this[e] >= this.DV;) this[e] -= this.DV, ++e >= this.t && (this[this.t++] = 0), ++this[e]
						}
					}, D.prototype.multiplyLowerTo = function(t, e, r) {
						var n = Math.min(this.t + t.t, e);
						for (r.s = 0, r.t = n; 0 < n;) r[--n] = 0;
						for (var i = r.t - this.t; n < i; ++n) r[n + this.t] = this.am(0, t[n], r, n, 0, this.t);
						for (i = Math.min(t.t, e); n < i; ++n) this.am(0, t[n], r, n, 0, e - n);
						r.clamp()
					}, D.prototype.multiplyUpperTo = function(t, e, r) {
						--e;
						var n = r.t = this.t + t.t - e;
						for (r.s = 0; 0 <= --n;) r[n] = 0;
						for (n = Math.max(e - this.t, 0); n < t.t; ++n) r[this.t + n - e] = this.am(e - n, t[n], r, 0, 0, this.t + n - e);
						r.clamp(), r.drShiftTo(1, r)
					}, D.prototype.modInt = function(t) {
						if (t <= 0) return 0;
						var e = this.DV % t,
							r = this.s < 0 ? t - 1 : 0;
						if (0 < this.t)
							if (0 == e) r = this[0] % t;
							else
								for (var n = this.t - 1; 0 <= n; --n) r = (e * r + this[n]) % t;
						return r
					}, D.prototype.millerRabin = function(t) {
						var e = this.subtract(D.ONE),
							r = e.getLowestSetBit();
						if (r <= 0) return !1;
						var n = e.shiftRight(r);
						x.length < (t = t + 1 >> 1) && (t = x.length);
						for (var i = L(), o = 0; o < t; ++o) {
							i.fromInt(x[Math.floor(Math.random() * x.length)]);
							var a = i.modPow(n, this);
							if (0 != a.compareTo(D.ONE) && 0 != a.compareTo(e)) {
								for (var s = 1; s++ < r && 0 != a.compareTo(e);)
									if (0 == (a = a.modPowInt(2, this))
										.compareTo(D.ONE)) return !1;
								if (0 != a.compareTo(e)) return !1
							}
						}
						return !0
					}, D.prototype.square = function() {
						var t = L();
						return this.squareTo(t), t
					}, D.prototype.gcda = function(t, e) {
						var r = this.s < 0 ? this.negate() : this.clone(),
							n = t.s < 0 ? t.negate() : t.clone();
						r.compareTo(n) < 0 && (t = r, r = n, n = t);
						var i, o = r.getLowestSetBit(),
							a = n.getLowestSetBit();
						a < 0 ? e(r) : (o < a && (a = o), 0 < a && (r.rShiftTo(a, r), n.rShiftTo(a, n)), i = function() {
							0 < (o = r.getLowestSetBit()) && r.rShiftTo(o, r), 0 < (o = n.getLowestSetBit()) && n.rShiftTo(o, n), 0 <= r.compareTo(n) ? (r.subTo(n, r), r.rShiftTo(1, r)) : (n.subTo(r, n), n.rShiftTo(1, n)), 0 < r.signum() ? setTimeout(i, 0) : (0 < a && n.lShiftTo(a, n), setTimeout((function() {
								e(n)
							}), 0))
						}, setTimeout(i, 10))
					}, D.prototype.fromNumberAsync = function(t, e, r, n) {
						var o, a, s;
						"number" == typeof e ? t < 2 ? this.fromInt(1) : (this.fromNumber(t, r), this.testBit(t - 1) || this.bitwiseTo(D.ONE.shiftLeft(t - 1), i, this), this.isEven() && this.dAddOffset(1, 0), o = this, a = function() {
							o.dAddOffset(2, 0), o.bitLength() > t && o.subTo(D.ONE.shiftLeft(t - 1), o), o.isProbablePrime(e) ? setTimeout((function() {
								n()
							}), 0) : setTimeout(a, 0)
						}, setTimeout(a, 0)) : (s = 7 & t, (r = [])
							.length = 1 + (t >> 3), e.nextBytes(r), 0 < s ? r[0] &= (1 << s) - 1 : r[0] = 0, this.fromString(r, 256))
					}, D);

				function D(t, e, r) {
					null != t && ("number" == typeof t ? this.fromNumber(t, e, r) : null == e && "string" != typeof t ? this.fromString(t, 256) : this.fromString(t, e))
				}
				var O = (R.prototype.convert = function(t) {
					return t
				}, R.prototype.revert = function(t) {
					return t
				}, R.prototype.mulTo = function(t, e, r) {
					t.multiplyTo(e, r)
				}, R.prototype.sqrTo = function(t, e) {
					t.squareTo(e)
				}, R);

				function R() {}
				var N = (M.prototype.convert = function(t) {
					return t.s < 0 || 0 <= t.compareTo(this.m) ? t.mod(this.m) : t
				}, M.prototype.revert = function(t) {
					return t
				}, M.prototype.reduce = function(t) {
					t.divRemTo(this.m, null, t)
				}, M.prototype.mulTo = function(t, e, r) {
					t.multiplyTo(e, r), this.reduce(r)
				}, M.prototype.sqrTo = function(t, e) {
					t.squareTo(e), this.reduce(e)
				}, M);

				function M(t) {
					this.m = t
				}
				var B = (F.prototype.convert = function(t) {
					var e = L();
					return t.abs()
						.dlShiftTo(this.m.t, e), e.divRemTo(this.m, null, e), t.s < 0 && 0 < e.compareTo(k.ZERO) && this.m.subTo(e, e), e
				}, F.prototype.revert = function(t) {
					var e = L();
					return t.copyTo(e), this.reduce(e), e
				}, F.prototype.reduce = function(t) {
					for (; t.t <= this.mt2;) t[t.t++] = 0;
					for (var e = 0; e < this.m.t; ++e) {
						var r = 32767 & t[e],
							n = r * this.mpl + ((r * this.mph + (t[e] >> 15) * this.mpl & this.um) << 15) & t.DM;
						for (t[r = e + this.m.t] += this.m.am(0, n, t, e, 0, this.m.t); t[r] >= t.DV;) t[r] -= t.DV, t[++r]++
					}
					t.clamp(), t.drShiftTo(this.m.t, t), 0 <= t.compareTo(this.m) && t.subTo(this.m, t)
				}, F.prototype.mulTo = function(t, e, r) {
					t.multiplyTo(e, r), this.reduce(r)
				}, F.prototype.sqrTo = function(t, e) {
					t.squareTo(e), this.reduce(e)
				}, F);

				function F(t) {
					this.m = t, this.mp = t.invDigit(), this.mpl = 32767 & this.mp, this.mph = this.mp >> 15, this.um = (1 << t.DB - 15) - 1, this.mt2 = 2 * t.t
				}
				var j = (K.prototype.convert = function(t) {
					if (t.s < 0 || t.t > 2 * this.m.t) return t.mod(this.m);
					if (t.compareTo(this.m) < 0) return t;
					var e = L();
					return t.copyTo(e), this.reduce(e), e
				}, K.prototype.revert = function(t) {
					return t
				}, K.prototype.reduce = function(t) {
					for (t.drShiftTo(this.m.t - 1, this.r2), t.t > this.m.t + 1 && (t.t = this.m.t + 1, t.clamp()), this.mu.multiplyUpperTo(this.r2, this.m.t + 1, this.q3), this.m.multiplyLowerTo(this.q3, this.m.t + 1, this.r2); t.compareTo(this.r2) < 0;) t.dAddOffset(1, this.m.t + 1);
					for (t.subTo(this.r2, t); 0 <= t.compareTo(this.m);) t.subTo(this.m, t)
				}, K.prototype.mulTo = function(t, e, r) {
					t.multiplyTo(e, r), this.reduce(r)
				}, K.prototype.sqrTo = function(t, e) {
					t.squareTo(e), this.reduce(e)
				}, K);

				function K(t) {
					this.m = t, this.r2 = L(), this.q3 = L(), k.ONE.dlShiftTo(2 * t.t, this.r2), this.mu = this.r2.divide(t)
				}

				function L() {
					return new k(null)
				}

				function U(t, e) {
					return new k(t, e)
				}
				lt = "Microsoft Internet Explorer" == navigator.appName ? (k.prototype.am = function(t, e, r, n, i, o) {
					for (var a = 32767 & e, s = e >> 15; 0 <= --o;) {
						var c = 32767 & this[t],
							u = this[t++] >> 15,
							d = s * c + u * a;
						i = ((c = a * c + ((32767 & d) << 15) + r[n] + (1073741823 & i)) >>> 30) + (d >>> 15) + s * u + (i >>> 30), r[n++] = 1073741823 & c
					}
					return i
				}, 30) : "Netscape" != navigator.appName ? (k.prototype.am = function(t, e, r, n, i, o) {
					for (; 0 <= --o;) {
						var a = e * this[t++] + r[n] + i;
						i = Math.floor(a / 67108864), r[n++] = 67108863 & a
					}
					return i
				}, 26) : (k.prototype.am = function(t, e, r, n, i, o) {
					for (var a = 16383 & e, s = e >> 14; 0 <= --o;) {
						var c = 16383 & this[t],
							u = this[t++] >> 14,
							d = s * c + u * a;
						i = ((c = a * c + ((16383 & d) << 14) + r[n] + i) >> 28) + (d >> 14) + s * u, r[n++] = 268435455 & c
					}
					return i
				}, 28), k.prototype.DB = lt, k.prototype.DM = (1 << lt) - 1, k.prototype.DV = 1 << lt, k.prototype.FV = Math.pow(2, 52), k.prototype.F1 = 52 - lt, k.prototype.F2 = 2 * lt - 52;
				for (var X = [], z = "0".charCodeAt(0), G = 0; G <= 9; ++G) X[z++] = G;
				for (z = "a".charCodeAt(0), G = 10; G < 36; ++G) X[z++] = G;
				for (z = "A".charCodeAt(0), G = 10; G < 36; ++G) X[z++] = G;

				function q(t, e) {
					return e = X[t.charCodeAt(e)], null == e ? -1 : e
				}

				function W(t) {
					var e = L();
					return e.fromInt(t), e
				}

				function V(t) {
					var e, r = 1;
					return 0 != (e = t >>> 16) && (t = e, r += 16), 0 != (e = t >> 8) && (t = e, r += 8), 0 != (e = t >> 4) && (t = e, r += 4), 0 != (e = t >> 2) && (t = e, r += 2), 0 != (e = t >> 1) && (t = e, r += 1), r
				}
				k.ZERO = W(0), k.ONE = W(1);
				var H = (Y.prototype.init = function(t) {
					for (var e, r, n = 0; n < 256; ++n) this.S[n] = n;
					for (n = e = 0; n < 256; ++n) e = e + this.S[n] + t[n % t.length] & 255, r = this.S[n], this.S[n] = this.S[e], this.S[e] = r;
					this.i = 0, this.j = 0
				}, Y.prototype.next = function() {
					var t;
					return this.i = this.i + 1 & 255, this.j = this.j + this.S[this.i] & 255, t = this.S[this.i], this.S[this.i] = this.S[this.j], this.S[this.j] = t, this.S[t + this.S[this.i] & 255]
				}, Y);

				function Y() {
					this.i = 0, this.j = 0, this.S = []
				}
				var Z, Q, J = 256,
					$ = null;
				if (null == $) {
					$ = [];
					var tt = void(Q = 0);
					if (window.crypto && window.crypto.getRandomValues) {
						var et = new Uint32Array(256);
						for (window.crypto.getRandomValues(et), tt = 0; tt < et.length; ++tt) $[Q++] = 255 & et[tt]
					}
					var rt = function t(e) {
						if (this.count = this.count || 0, 256 <= this.count || J <= Q) window.removeEventListener ? window.removeEventListener("mousemove", t, !1) : window.detachEvent && window.detachEvent("onmousemove", t);
						else try {
							var r = e.x + e.y;
							$[Q++] = 255 & r, this.count += 1
						} catch (e) {}
					};
					window.addEventListener ? window.addEventListener("mousemove", rt, !1) : window.attachEvent && window.attachEvent("onmousemove", rt)
				}

				function nt() {
					if (null == Z) {
						for (Z = new H; Q < J;) {
							var t = Math.floor(65536 * Math.random());
							$[Q++] = 255 & t
						}
						for (Z.init($), Q = 0; Q < $.length; ++Q) $[Q] = 0;
						Q = 0
					}
					return Z.next()
				}
				var it = (ot.prototype.nextBytes = function(t) {
					for (var e = 0; e < t.length; ++e) t[e] = nt()
				}, ot);

				function ot() {}

				function at(t, e, r) {
					if (e < t.length + 11) return console.error("Message too long for RSA"), null;
					for (var n = [], i = t.length - 1; 0 <= i && 0 < e;) {
						var o = t.charCodeAt(i--);
						o < 128 ? n[--e] = o : 127 < o && o < 2048 ? (n[--e] = 63 & o | 128, n[--e] = o >> 6 | 192) : (n[--e] = 63 & o | 128, n[--e] = o >> 6 & 63 | 128, n[--e] = o >> 12 | 224)
					}
					if (n[--e] = 0, r) {
						for (; 2 < e;) n[--e] = 255;
						n[--e] = 1, n[--e] = 0
					} else {
						for (var a = new it, s = []; 2 < e;) {
							for (s[0] = 0; 0 == s[0];) a.nextBytes(s);
							n[--e] = s[0]
						}
						n[--e] = 2, n[--e] = 0
					}
					return new k(n)
				}

				function st(t, e, r) {
					for (var n = t.toByteArray(), i = 0; i < n.length && 0 == n[i];) ++i;
					if (r) {
						if (n.length - i != e - 1 || 2 != n[i]) return null;
						for (++i; 0 != n[i];)
							if (++i >= n.length) return null
					} else {
						if (n.length - i != e - 1 || 1 != n[i]) return null;
						for (++i; 0 != n[i];)
							if (++i >= n.length) return null
					}
					for (var o = ""; ++i < n.length;) {
						var a = 255 & n[i];
						a < 128 ? o += String.fromCharCode(a) : 191 < a && a < 224 ? (o += String.fromCharCode((31 & a) << 6 | 63 & n[i + 1]), ++i) : (o += String.fromCharCode((15 & a) << 12 | (63 & n[i + 1]) << 6 | 63 & n[i + 2]), i += 2)
					}
					return o
				}
				var ct = (ut.prototype.doPublic = function(t) {
					return t.modPowInt(this.e, this.n)
				}, ut.prototype.doPrivate = function(t) {
					if (null == this.p || null == this.q) return t.modPow(this.d, this.n);
					for (var e = t.mod(this.p)
						.modPow(this.dmp1, this.p), r = t.mod(this.q)
						.modPow(this.dmq1, this.q); e.compareTo(r) < 0;) e = e.add(this.p);
					return e.subtract(r)
						.multiply(this.coeff)
						.mod(this.p)
						.multiply(this.q)
						.add(r)
				}, ut.prototype.setPublic = function(t, e) {
					null != t && null != e && 0 < t.length && 0 < e.length ? (this.n = U(t, 16), this.e = parseInt(e, 16)) : console.error("Invalid RSA public key")
				}, ut.prototype.encrypt = function(t, e) {
					return void 0 === e && (e = !1), t = at(t, this.n.bitLength() + 7 >> 3, e), null == t ? null : (t = e ? this.doPrivate(t) : this.doPublic(t), null == t ? null : (t = t.toString(16), 0 == (1 & t.length) ? t : "0" + t))
				}, ut.prototype.setPrivate = function(t, e, r) {
					null != t && null != e && 0 < t.length && 0 < e.length ? (this.n = U(t, 16), this.e = parseInt(e, 16), this.d = U(r, 16)) : console.error("Invalid RSA private key")
				}, ut.prototype.setPrivateEx = function(t, e, r, n, i, o, a, s) {
					null != t && null != e && 0 < t.length && 0 < e.length ? (this.n = U(t, 16), this.e = parseInt(e, 16), this.d = U(r, 16), this.p = U(n, 16), this.q = U(i, 16), this.dmp1 = U(o, 16), this.dmq1 = U(a, 16), this.coeff = U(s, 16)) : console.error("Invalid RSA private key")
				}, ut.prototype.generate = function(t, e) {
					var r = new it,
						n = t >> 1;
					this.e = parseInt(e, 16);
					for (var i = new k(e, 16);;) {
						for (; this.p = new k(t - n, 1, r), 0 != this.p.subtract(k.ONE)
							.gcd(i)
							.compareTo(k.ONE) || !this.p.isProbablePrime(10););
						for (; this.q = new k(n, 1, r), 0 != this.q.subtract(k.ONE)
							.gcd(i)
							.compareTo(k.ONE) || !this.q.isProbablePrime(10););
						this.p.compareTo(this.q) <= 0 && (s = this.p, this.p = this.q, this.q = s);
						var o = this.p.subtract(k.ONE),
							a = this.q.subtract(k.ONE),
							s = o.multiply(a);
						if (0 == s.gcd(i)
							.compareTo(k.ONE)) {
							this.n = this.p.multiply(this.q), this.d = i.modInverse(s), this.dmp1 = this.d.mod(o), this.dmq1 = this.d.mod(a), this.coeff = this.q.modInverse(this.p);
							break
						}
					}
				}, ut.prototype.decrypt = function(t, e) {
					return void 0 === e && (e = !0), t = U(t, 16), t = e ? this.doPrivate(t) : this.doPublic(t), null == t ? null : st(t, this.n.bitLength() + 7 >> 3, e)
				}, ut.prototype.generateAsync = function(t, e, r) {
					var n = new it,
						i = t >> 1;
					this.e = parseInt(e, 16);
					var o = new k(e, 16),
						a = this,
						s = function e() {
							function s() {
								a.p.compareTo(a.q) <= 0 && (i = a.p, a.p = a.q, a.q = i);
								var t = a.p.subtract(k.ONE),
									n = a.q.subtract(k.ONE),
									i = t.multiply(n);
								0 == i.gcd(o)
									.compareTo(k.ONE) ? (a.n = a.p.multiply(a.q), a.d = o.modInverse(i), a.dmp1 = a.d.mod(t), a.dmq1 = a.d.mod(n), a.coeff = a.q.modInverse(a.p), setTimeout((function() {
										r()
									}), 0)) : setTimeout(e, 0)
							}
							var c = function t() {
									a.q = L(), a.q.fromNumberAsync(i, 1, n, (function() {
										a.q.subtract(k.ONE)
											.gcda(o, (function(e) {
												0 == e.compareTo(k.ONE) && a.q.isProbablePrime(10) ? setTimeout(s, 0) : setTimeout(t, 0)
											}))
									}))
								},
								u = function e() {
									a.p = L(), a.p.fromNumberAsync(t - i, 1, n, (function() {
										a.p.subtract(k.ONE)
											.gcda(o, (function(t) {
												0 == t.compareTo(k.ONE) && a.p.isProbablePrime(10) ? setTimeout(c, 0) : setTimeout(e, 0)
											}))
									}))
								};
							setTimeout(u, 0)
						};
					setTimeout(s, 0)
				}, ut.prototype.sign = function(t, e, r) {
					return t = at((dt[r] || "") + e(t)
						.toString(), this.n.bitLength() + 7 >> 3, !0), null == t ? null : (t = this.doPrivate(t), null == t ? null : (t = t.toString(16), 0 == (1 & t.length) ? t : "0" + t))
				}, ut.prototype.verify = function(t, e, r) {
					return e = U(e, 16), e = this.doPublic(e), null == e ? null : function(t) {
							for (var e in dt)
								if (dt.hasOwnProperty(e)) {
									var r = dt[e],
										n = r.length;
									if (t.substr(0, n) == r) return t.substr(n)
								} return t
						}(st(e, this.n.bitLength() + 7 >> 3, !1)) == r(t)
						.toString()
				}, ut);

				function ut() {
					this.n = null, this.e = 0, this.d = null, this.p = null, this.q = null, this.dmp1 = null, this.dmq1 = null, this.coeff = null
				}
				var dt = {
						md2: "3020300c06082a864886f70d020205000410",
						md5: "3020300c06082a864886f70d020505000410",
						sha1: "3021300906052b0e03021a05000414",
						sha224: "302d300d06096086480165030402040500041c",
						sha256: "3031300d060960864801650304020105000420",
						sha384: "3041300d060960864801650304020205000430",
						sha512: "3051300d060960864801650304020305000440",
						ripemd160: "3021300906052b2403020105000414"
					},
					lt = {};
				lt.lang = {
					extend: function(t, e, r) {
						if (!e || !t) throw new Error("YAHOO.lang.extend failed, please check that all dependencies are included.");

						function n() {}
						if (n.prototype = e.prototype, t.prototype = new n, (t.prototype.constructor = t)
							.superclass = e.prototype, e.prototype.constructor == Object.prototype.constructor && (e.prototype.constructor = e), r) {
							for (var i in r) t.prototype[i] = r[i];
							var o = function() {},
								a = ["toString", "valueOf"];
							try {
								/MSIE/.test(navigator.userAgent) && (o = function(t, e) {
									for (i = 0; i < a.length; i += 1) {
										var r = a[i],
											n = e[r];
										"function" == typeof n && n != Object.prototype[r] && (t[r] = n)
									}
								})
							} catch (t) {}
							o(t.prototype, r)
						}
					}
				};
				var ft = {};
				void 0 !== ft.asn1 && ft.asn1 || (ft.asn1 = {}), ft.asn1.ASN1Util = new function() {
					this.integerToByteHex = function(t) {
						return t = t.toString(16), t.length % 2 == 1 && (t = "0" + t), t
					}, this.bigIntToMinTwosComplementsHex = function(t) {
						if ("-" != (i = t.toString(16))
							.substr(0, 1)) i.length % 2 == 1 ? i = "0" + i : i.match(/^[0-7]/) || (i = "00" + i);
						else {
							var e = i.substr(1)
								.length;
							e % 2 == 1 ? e += 1 : i.match(/^[0-7]/) || (e += 2);
							for (var r = "", n = 0; n < e; n++) r += "f";
							var i = new k(r, 16)
								.xor(t)
								.add(k.ONE)
								.toString(16)
								.replace(/^-/, "")
						}
						return i
					}, this.getPEMStringFromHex = function(t, e) {
						return hextopem(t, e)
					}, this.newObject = function(t) {
						var e = ft.asn1,
							r = e.DERBoolean,
							n = e.DERInteger,
							i = e.DERBitString,
							o = e.DEROctetString,
							a = e.DERNull,
							s = e.DERObjectIdentifier,
							c = e.DEREnumerated,
							u = e.DERUTF8String,
							d = e.DERNumericString,
							l = e.DERPrintableString,
							f = e.DERTeletexString,
							h = e.DERIA5String,
							p = e.DERUTCTime,
							m = e.DERGeneralizedTime,
							b = e.DERSequence,
							g = e.DERSet,
							y = e.DERTaggedObject,
							v = e.ASN1Util.newObject;
						e = Object.keys(t);
						if (1 != e.length) throw "key of param shall be only one.";
						if (e = e[0], -1 == ":bool:int:bitstr:octstr:null:oid:enum:utf8str:numstr:prnstr:telstr:ia5str:utctime:gentime:seq:set:tag:".indexOf(":" + e + ":")) throw "undefined key: " + e;
						if ("bool" == e) return new r(t[e]);
						if ("int" == e) return new n(t[e]);
						if ("bitstr" == e) return new i(t[e]);
						if ("octstr" == e) return new o(t[e]);
						if ("null" == e) return new a(t[e]);
						if ("oid" == e) return new s(t[e]);
						if ("enum" == e) return new c(t[e]);
						if ("utf8str" == e) return new u(t[e]);
						if ("numstr" == e) return new d(t[e]);
						if ("prnstr" == e) return new l(t[e]);
						if ("telstr" == e) return new f(t[e]);
						if ("ia5str" == e) return new h(t[e]);
						if ("utctime" == e) return new p(t[e]);
						if ("gentime" == e) return new m(t[e]);
						if ("seq" == e) {
							for (var S = t[e], w = [], C = 0; C < S.length; C++) {
								var _ = v(S[C]);
								w.push(_)
							}
							return new b({
								array: w
							})
						}
						if ("set" == e) {
							for (S = t[e], w = [], C = 0; C < S.length; C++) _ = v(S[C]), w.push(_);
							return new g({
								array: w
							})
						}
						if ("tag" == e) {
							if (e = t[e], "[object Array]" === Object.prototype.toString.call(e) && 3 == e.length) {
								var A = v(e[2]);
								return new y({
									tag: e[0],
									explicit: e[1],
									obj: A
								})
							}
							if (A = {}, void 0 !== e.explicit && (A.explicit = e.explicit), void 0 !== e.tag && (A.tag = e.tag), void 0 === e.obj) throw "obj shall be specified for 'tag'.";
							return A.obj = v(e.obj), new y(A)
						}
					}, this.jsonToASN1HEX = function(t) {
						return this.newObject(t)
							.getEncodedHex()
					}
				}, ft.asn1.ASN1Util.oidHexToInt = function(t) {
					for (var e = "", r = parseInt(t.substr(0, 2), 16), n = (e = Math.floor(r / 40) + "." + r % 40, ""), i = 2; i < t.length; i += 2) {
						var o = ("00000000" + parseInt(t.substr(i, 2), 16)
								.toString(2))
							.slice(-8);
						n += o.substr(1, 7), "0" == o.substr(0, 1) && (e = e + "." + new k(n, 2)
							.toString(10), n = "")
					}
					return e
				}, ft.asn1.ASN1Util.oidIntToHex = function(t) {
					function e(t) {
						return 1 == (t = t.toString(16))
							.length && (t = "0" + t), t
					}
					if (!t.match(/^[0-9.]+$/)) throw "malformed oid string: " + t;
					var r = "",
						n = t.split(".");
					t = 40 * parseInt(n[0]) + parseInt(n[1]);
					r += e(t), n.splice(0, 2);
					for (var i = 0; i < n.length; i++) r += function(t) {
						var r = "",
							n = new k(t, 10)
							.toString(2),
							i = 7 - n.length % 7;
						7 == i && (i = 0);
						for (var o = "", a = 0; a < i; a++) o += "0";
						for (n = o + n, a = 0; a < n.length - 1; a += 7) {
							var s = n.substr(a, 7);
							a != n.length - 7 && (s = "1" + s), r += e(parseInt(s, 2))
						}
						return r
					}(n[i]);
					return r
				}, ft.asn1.ASN1Object = function() {
					this.getLengthHexFromValue = function() {
						if (void 0 === this.hV || null == this.hV) throw "this.hV is null or undefined.";
						if (this.hV.length % 2 == 1) throw "value hex must be even length: n=" + "".length + ",v=" + this.hV;
						var t = this.hV.length / 2,
							e = t.toString(16);
						if (e.length % 2 == 1 && (e = "0" + e), t < 128) return e;
						var r = e.length / 2;
						if (15 < r) throw "ASN.1 length too long to represent by 8x: n = " + t.toString(16);
						return (128 + r)
							.toString(16) + e
					}, this.getEncodedHex = function() {
						return null != this.hTLV && !this.isModified || (this.hV = this.getFreshValueHex(), this.hL = this.getLengthHexFromValue(), this.hTLV = this.hT + this.hL + this.hV, this.isModified = !1), this.hTLV
					}, this.getValueHex = function() {
						return this.getEncodedHex(), this.hV
					}, this.getFreshValueHex = function() {
						return ""
					}
				}, ft.asn1.DERAbstractString = function(t) {
					ft.asn1.DERAbstractString.superclass.constructor.call(this), this.getString = function() {
						return this.s
					}, this.setString = function(t) {
						this.hTLV = null, this.isModified = !0, this.s = t, this.hV = stohex(this.s)
					}, this.setStringHex = function(t) {
						this.hTLV = null, this.isModified = !0, this.s = null, this.hV = t
					}, this.getFreshValueHex = function() {
						return this.hV
					}, void 0 !== t && ("string" == typeof t ? this.setString(t) : void 0 !== t.str ? this.setString(t.str) : void 0 !== t.hex && this.setStringHex(t.hex))
				}, lt.lang.extend(ft.asn1.DERAbstractString, ft.asn1.ASN1Object), ft.asn1.DERAbstractTime = function(t) {
					ft.asn1.DERAbstractTime.superclass.constructor.call(this), this.localDateToUTC = function(t) {
						return utc = t.getTime() + 6e4 * t.getTimezoneOffset(), new Date(utc)
					}, this.formatDate = function(t, e, r) {
						var n = this.zeroPadding,
							i = this.localDateToUTC(t);
						t = String(i.getFullYear());
						return "utc" == e && (t = t.substr(2, 2)), t = t + n(String(i.getMonth() + 1), 2) + n(String(i.getDate()), 2) + n(String(i.getHours()), 2) + n(String(i.getMinutes()), 2) + n(String(i.getSeconds()), 2), !0 !== r || 0 != (i = i.getMilliseconds()) && (t = t + "." + n(String(i), 3)
							.replace(/[0]+$/, "")), t + "Z"
					}, this.zeroPadding = function(t, e) {
						return t.length >= e ? t : new Array(e - t.length + 1)
							.join("0") + t
					}, this.getString = function() {
						return this.s
					}, this.setString = function(t) {
						this.hTLV = null, this.isModified = !0, this.s = t, this.hV = stohex(t)
					}, this.setByDateValue = function(t, e, r, n, i, o) {
						o = new Date(Date.UTC(t, e - 1, r, n, i, o, 0)), this.setByDate(o)
					}, this.getFreshValueHex = function() {
						return this.hV
					}
				}, lt.lang.extend(ft.asn1.DERAbstractTime, ft.asn1.ASN1Object), ft.asn1.DERAbstractStructured = function(t) {
					ft.asn1.DERAbstractString.superclass.constructor.call(this), this.setByASN1ObjectArray = function(t) {
						this.hTLV = null, this.isModified = !0, this.asn1Array = t
					}, this.appendASN1Object = function(t) {
						this.hTLV = null, this.isModified = !0, this.asn1Array.push(t)
					}, this.asn1Array = new Array, void 0 !== t && void 0 !== t.array && (this.asn1Array = t.array)
				}, lt.lang.extend(ft.asn1.DERAbstractStructured, ft.asn1.ASN1Object), ft.asn1.DERBoolean = function() {
					ft.asn1.DERBoolean.superclass.constructor.call(this), this.hT = "01", this.hTLV = "0101ff"
				}, lt.lang.extend(ft.asn1.DERBoolean, ft.asn1.ASN1Object), ft.asn1.DERInteger = function(t) {
					ft.asn1.DERInteger.superclass.constructor.call(this), this.hT = "02", this.setByBigInteger = function(t) {
						this.hTLV = null, this.isModified = !0, this.hV = ft.asn1.ASN1Util.bigIntToMinTwosComplementsHex(t)
					}, this.setByInteger = function(t) {
						t = new k(String(t), 10), this.setByBigInteger(t)
					}, this.setValueHex = function(t) {
						this.hV = t
					}, this.getFreshValueHex = function() {
						return this.hV
					}, void 0 !== t && (void 0 !== t.bigint ? this.setByBigInteger(t.bigint) : void 0 !== t.int ? this.setByInteger(t.int) : "number" == typeof t ? this.setByInteger(t) : void 0 !== t.hex && this.setValueHex(t.hex))
				}, lt.lang.extend(ft.asn1.DERInteger, ft.asn1.ASN1Object), ft.asn1.DERBitString = function(t) {
					var e;
					void 0 !== t && void 0 !== t.obj && (e = ft.asn1.ASN1Util.newObject(t.obj), t.hex = "00" + e.getEncodedHex()), ft.asn1.DERBitString.superclass.constructor.call(this), this.hT = "03", this.setHexValueIncludingUnusedBits = function(t) {
						this.hTLV = null, this.isModified = !0, this.hV = t
					}, this.setUnusedBitsAndHexValue = function(t, e) {
						if (t < 0 || 7 < t) throw "unused bits shall be from 0 to 7: u = " + t;
						t = "0" + t, this.hTLV = null, this.isModified = !0, this.hV = t + e
					}, this.setByBinaryString = function(t) {
						var e = 8 - (t = t.replace(/0+$/, ""))
							.length % 8;
						8 == e && (e = 0);
						for (var r = 0; r <= e; r++) t += "0";
						var n = "";
						for (r = 0; r < t.length - 1; r += 8) {
							var i = t.substr(r, 8);
							i = parseInt(i, 2)
								.toString(16);
							1 == i.length && (i = "0" + i), n += i
						}
						this.hTLV = null, this.isModified = !0, this.hV = "0" + e + n
					}, this.setByBooleanArray = function(t) {
						for (var e = "", r = 0; r < t.length; r++) 1 == t[r] ? e += "1" : e += "0";
						this.setByBinaryString(e)
					}, this.newFalseArray = function(t) {
						for (var e = new Array(t), r = 0; r < t; r++) e[r] = !1;
						return e
					}, this.getFreshValueHex = function() {
						return this.hV
					}, void 0 !== t && ("string" == typeof t && t.toLowerCase()
						.match(/^[0-9a-f]+$/) ? this.setHexValueIncludingUnusedBits(t) : void 0 !== t.hex ? this.setHexValueIncludingUnusedBits(t.hex) : void 0 !== t.bin ? this.setByBinaryString(t.bin) : void 0 !== t.array && this.setByBooleanArray(t.array))
				}, lt.lang.extend(ft.asn1.DERBitString, ft.asn1.ASN1Object), ft.asn1.DEROctetString = function(t) {
					var e;
					void 0 !== t && void 0 !== t.obj && (e = ft.asn1.ASN1Util.newObject(t.obj), t.hex = e.getEncodedHex()), ft.asn1.DEROctetString.superclass.constructor.call(this, t), this.hT = "04"
				}, lt.lang.extend(ft.asn1.DEROctetString, ft.asn1.DERAbstractString), ft.asn1.DERNull = function() {
					ft.asn1.DERNull.superclass.constructor.call(this), this.hT = "05", this.hTLV = "0500"
				}, lt.lang.extend(ft.asn1.DERNull, ft.asn1.ASN1Object), ft.asn1.DERObjectIdentifier = function(t) {
					function e(t) {
						return 1 == (t = t.toString(16))
							.length && (t = "0" + t), t
					}
					ft.asn1.DERObjectIdentifier.superclass.constructor.call(this), this.hT = "06", this.setValueHex = function(t) {
						this.hTLV = null, this.isModified = !0, this.s = null, this.hV = t
					}, this.setValueOidString = function(t) {
						if (!t.match(/^[0-9.]+$/)) throw "malformed oid string: " + t;
						var r = "",
							n = t.split(".");
						t = 40 * parseInt(n[0]) + parseInt(n[1]);
						r += e(t), n.splice(0, 2);
						for (var i = 0; i < n.length; i++) r += function(t) {
							var r = "",
								n = new k(t, 10)
								.toString(2),
								i = 7 - n.length % 7;
							7 == i && (i = 0);
							for (var o = "", a = 0; a < i; a++) o += "0";
							for (n = o + n, a = 0; a < n.length - 1; a += 7) {
								var s = n.substr(a, 7);
								a != n.length - 7 && (s = "1" + s), r += e(parseInt(s, 2))
							}
							return r
						}(n[i]);
						this.hTLV = null, this.isModified = !0, this.s = null, this.hV = r
					}, this.setValueName = function(t) {
						var e = ft.asn1.x509.OID.name2oid(t);
						if ("" === e) throw "DERObjectIdentifier oidName undefined: " + t;
						this.setValueOidString(e)
					}, this.getFreshValueHex = function() {
						return this.hV
					}, void 0 !== t && ("string" == typeof t ? t.match(/^[0-2].[0-9.]+$/) ? this.setValueOidString(t) : this.setValueName(t) : void 0 !== t.oid ? this.setValueOidString(t.oid) : void 0 !== t.hex ? this.setValueHex(t.hex) : void 0 !== t.name && this.setValueName(t.name))
				}, lt.lang.extend(ft.asn1.DERObjectIdentifier, ft.asn1.ASN1Object), ft.asn1.DEREnumerated = function(t) {
					ft.asn1.DEREnumerated.superclass.constructor.call(this), this.hT = "0a", this.setByBigInteger = function(t) {
						this.hTLV = null, this.isModified = !0, this.hV = ft.asn1.ASN1Util.bigIntToMinTwosComplementsHex(t)
					}, this.setByInteger = function(t) {
						t = new k(String(t), 10), this.setByBigInteger(t)
					}, this.setValueHex = function(t) {
						this.hV = t
					}, this.getFreshValueHex = function() {
						return this.hV
					}, void 0 !== t && (void 0 !== t.int ? this.setByInteger(t.int) : "number" == typeof t ? this.setByInteger(t) : void 0 !== t.hex && this.setValueHex(t.hex))
				}, lt.lang.extend(ft.asn1.DEREnumerated, ft.asn1.ASN1Object), ft.asn1.DERUTF8String = function(t) {
					ft.asn1.DERUTF8String.superclass.constructor.call(this, t), this.hT = "0c"
				}, lt.lang.extend(ft.asn1.DERUTF8String, ft.asn1.DERAbstractString), ft.asn1.DERNumericString = function(t) {
					ft.asn1.DERNumericString.superclass.constructor.call(this, t), this.hT = "12"
				}, lt.lang.extend(ft.asn1.DERNumericString, ft.asn1.DERAbstractString), ft.asn1.DERPrintableString = function(t) {
					ft.asn1.DERPrintableString.superclass.constructor.call(this, t), this.hT = "13"
				}, lt.lang.extend(ft.asn1.DERPrintableString, ft.asn1.DERAbstractString), ft.asn1.DERTeletexString = function(t) {
					ft.asn1.DERTeletexString.superclass.constructor.call(this, t), this.hT = "14"
				}, lt.lang.extend(ft.asn1.DERTeletexString, ft.asn1.DERAbstractString), ft.asn1.DERIA5String = function(t) {
					ft.asn1.DERIA5String.superclass.constructor.call(this, t), this.hT = "16"
				}, lt.lang.extend(ft.asn1.DERIA5String, ft.asn1.DERAbstractString), ft.asn1.DERUTCTime = function(t) {
					ft.asn1.DERUTCTime.superclass.constructor.call(this, t), this.hT = "17", this.setByDate = function(t) {
						this.hTLV = null, this.isModified = !0, this.date = t, this.s = this.formatDate(this.date, "utc"), this.hV = stohex(this.s)
					}, this.getFreshValueHex = function() {
						return void 0 === this.date && void 0 === this.s && (this.date = new Date, this.s = this.formatDate(this.date, "utc"), this.hV = stohex(this.s)), this.hV
					}, void 0 !== t && (void 0 !== t.str ? this.setString(t.str) : "string" == typeof t && t.match(/^[0-9]{12}Z$/) ? this.setString(t) : void 0 !== t.hex ? this.setStringHex(t.hex) : void 0 !== t.date && this.setByDate(t.date))
				}, lt.lang.extend(ft.asn1.DERUTCTime, ft.asn1.DERAbstractTime), ft.asn1.DERGeneralizedTime = function(t) {
					ft.asn1.DERGeneralizedTime.superclass.constructor.call(this, t), this.hT = "18", this.withMillis = !1, this.setByDate = function(t) {
						this.hTLV = null, this.isModified = !0, this.date = t, this.s = this.formatDate(this.date, "gen", this.withMillis), this.hV = stohex(this.s)
					}, this.getFreshValueHex = function() {
						return void 0 === this.date && void 0 === this.s && (this.date = new Date, this.s = this.formatDate(this.date, "gen", this.withMillis), this.hV = stohex(this.s)), this.hV
					}, void 0 !== t && (void 0 !== t.str ? this.setString(t.str) : "string" == typeof t && t.match(/^[0-9]{14}Z$/) ? this.setString(t) : void 0 !== t.hex ? this.setStringHex(t.hex) : void 0 !== t.date && this.setByDate(t.date), !0 === t.millis && (this.withMillis = !0))
				}, lt.lang.extend(ft.asn1.DERGeneralizedTime, ft.asn1.DERAbstractTime), ft.asn1.DERSequence = function(t) {
					ft.asn1.DERSequence.superclass.constructor.call(this, t), this.hT = "30", this.getFreshValueHex = function() {
						for (var t = "", e = 0; e < this.asn1Array.length; e++) t += this.asn1Array[e].getEncodedHex();
						return this.hV = t, this.hV
					}
				}, lt.lang.extend(ft.asn1.DERSequence, ft.asn1.DERAbstractStructured), ft.asn1.DERSet = function(t) {
					ft.asn1.DERSet.superclass.constructor.call(this, t), this.hT = "31", this.sortFlag = !0, this.getFreshValueHex = function() {
						for (var t = new Array, e = 0; e < this.asn1Array.length; e++) {
							var r = this.asn1Array[e];
							t.push(r.getEncodedHex())
						}
						return 1 == this.sortFlag && t.sort(), this.hV = t.join(""), this.hV
					}, void 0 !== t && void 0 !== t.sortflag && 0 == t.sortflag && (this.sortFlag = !1)
				}, lt.lang.extend(ft.asn1.DERSet, ft.asn1.DERAbstractStructured), ft.asn1.DERTaggedObject = function(t) {
					ft.asn1.DERTaggedObject.superclass.constructor.call(this), this.hT = "a0", this.hV = "", this.isExplicit = !0, this.asn1Object = null, this.setASN1Object = function(t, e, r) {
						this.hT = e, this.isExplicit = t, this.asn1Object = r, this.isExplicit ? (this.hV = this.asn1Object.getEncodedHex(), this.hTLV = null, this.isModified = !0) : (this.hV = null, this.hTLV = r.getEncodedHex(), this.hTLV = this.hTLV.replace(/^../, e), this.isModified = !1)
					}, this.getFreshValueHex = function() {
						return this.hV
					}, void 0 !== t && (void 0 !== t.tag && (this.hT = t.tag), void 0 !== t.explicit && (this.isExplicit = t.explicit), void 0 !== t.obj && (this.asn1Object = t.obj, this.setASN1Object(this.isExplicit, this.hT, this.asn1Object)))
				}, lt.lang.extend(ft.asn1.DERTaggedObject, ft.asn1.ASN1Object);
				var ht, pt, mt, bt = (f(pt = yt, mt = ht = ct), pt.prototype = null === mt ? Object.create(mt) : (gt.prototype = mt.prototype, new gt), yt.prototype.parseKey = function(t) {
					try {
						var e = 0,
							r = 0,
							n = /^\s*(?:[0-9A-Fa-f][0-9A-Fa-f]\s*)+$/.test(t) ? h(t) : p.unarmor(t),
							i = A.decode(n);
						if (3 === i.sub.length && (i = i.sub[2].sub[0]), 9 === i.sub.length) e = i.sub[1].getHexStringValue(), this.n = U(e, 16), r = i.sub[2].getHexStringValue(), this.e = parseInt(r, 16), n = i.sub[3].getHexStringValue(), this.d = U(n, 16), n = i.sub[4].getHexStringValue(), this.p = U(n, 16), n = i.sub[5].getHexStringValue(), this.q = U(n, 16), n = i.sub[6].getHexStringValue(), this.dmp1 = U(n, 16), n = i.sub[7].getHexStringValue(), this.dmq1 = U(n, 16), n = i.sub[8].getHexStringValue(), this.coeff = U(n, 16);
						else {
							if (2 !== i.sub.length) return !1;
							i = i.sub[1].sub[0], e = i.sub[0].getHexStringValue(), this.n = U(e, 16), r = i.sub[1].getHexStringValue(), this.e = parseInt(r, 16)
						}
						return !0
					} catch (t) {
						return !1
					}
				}, yt.prototype.getPrivateBaseKey = function() {
					var t = {
						array: [new ft.asn1.DERInteger({
							int: 0
						}), new ft.asn1.DERInteger({
							bigint: this.n
						}), new ft.asn1.DERInteger({
							int: this.e
						}), new ft.asn1.DERInteger({
							bigint: this.d
						}), new ft.asn1.DERInteger({
							bigint: this.p
						}), new ft.asn1.DERInteger({
							bigint: this.q
						}), new ft.asn1.DERInteger({
							bigint: this.dmp1
						}), new ft.asn1.DERInteger({
							bigint: this.dmq1
						}), new ft.asn1.DERInteger({
							bigint: this.coeff
						})]
					};
					return new ft.asn1.DERSequence(t)
						.getEncodedHex()
				}, yt.prototype.getPrivateBaseKeyB64 = function() {
					return c(this.getPrivateBaseKey())
				}, yt.prototype.getPublicBaseKey = function() {
					var t = new ft.asn1.DERSequence({
							array: [new ft.asn1.DERObjectIdentifier({
								oid: "1.2.840.113549.1.1.1"
							}), new ft.asn1.DERNull]
						}),
						e = new ft.asn1.DERSequence({
							array: [new ft.asn1.DERInteger({
								bigint: this.n
							}), new ft.asn1.DERInteger({
								int: this.e
							})]
						});
					e = new ft.asn1.DERBitString({
						hex: "00" + e.getEncodedHex()
					});
					return new ft.asn1.DERSequence({
							array: [t, e]
						})
						.getEncodedHex()
				}, yt.prototype.getPublicBaseKeyB64 = function() {
					return c(this.getPublicBaseKey())
				}, yt.wordwrap = function(t, e) {
					return t ? (e = "(.{1," + (e = e || 64) + "})( +|$\n?)|(.{1," + e + "})", t.match(RegExp(e, "g"))
						.join("\n")) : t
				}, yt.prototype.getPrivateKey = function() {
					var t = "-----BEGIN RSA PRIVATE KEY-----\n";
					return t += yt.wordwrap(this.getPrivateBaseKeyB64()) + "\n", t + "-----END RSA PRIVATE KEY-----"
				}, yt.prototype.getPublicKey = function() {
					var t = "-----BEGIN PUBLIC KEY-----\n";
					return t += yt.wordwrap(this.getPublicBaseKeyB64()) + "\n", t + "-----END PUBLIC KEY-----"
				}, yt.hasPublicKeyProperty = function(t) {
					return (t = t || {})
						.hasOwnProperty("n") && t.hasOwnProperty("e")
				}, yt.hasPrivateKeyProperty = function(t) {
					return (t = t || {})
						.hasOwnProperty("n") && t.hasOwnProperty("e") && t.hasOwnProperty("d") && t.hasOwnProperty("p") && t.hasOwnProperty("q") && t.hasOwnProperty("dmp1") && t.hasOwnProperty("dmq1") && t.hasOwnProperty("coeff")
				}, yt.prototype.parsePropertiesFrom = function(t) {
					this.n = t.n, this.e = t.e, t.hasOwnProperty("d") && (this.d = t.d, this.p = t.p, this.q = t.q, this.dmp1 = t.dmp1, this.dmq1 = t.dmq1, this.coeff = t.coeff)
				}, yt);

				function gt() {
					this.constructor = pt
				}

				function yt(t) {
					var e = ht.call(this) || this;
					return t && ("string" == typeof t ? e.parseKey(t) : (yt.hasPrivateKeyProperty(t) || yt.hasPublicKeyProperty(t)) && e.parsePropertiesFrom(t)), e
				}

				function vt(t) {
					t = t || {}, this.default_key_size = parseInt(t.default_key_size, 10) || 1024, this.default_public_exponent = t.default_public_exponent || "010001", this.log = t.log || !1, this.key = null
				}
				vt.prototype.setKey = function(t) {
					this.log && this.key && console.warn("A key was already set, overriding existing."), this.key = new bt(t)
				}, vt.prototype.setPrivateKey = function(t) {
					this.setKey(t)
				}, vt.prototype.setPublicKey = function(t) {
					this.setKey(t)
				}, vt.prototype.decrypt = function(t, e) {
					void 0 === e && (e = !0);
					try {
						return this.getKey()
							.decrypt(u(t), e)
					} catch (t) {
						return !1
					}
				}, vt.prototype.encrypt = function(t, e) {
					void 0 === e && (e = !1);
					try {
						return c(this.getKey()
							.encrypt(t, e))
					} catch (t) {
						return !1
					}
				}, vt.prototype.sign = function(t, e, r) {
					try {
						return c(this.getKey()
							.sign(t, e, r))
					} catch (t) {
						return !1
					}
				}, vt.prototype.verify = function(t, e, r) {
					try {
						return this.getKey()
							.verify(t, u(e), r)
					} catch (t) {
						return !1
					}
				}, vt.prototype.getKey = function(t) {
					if (!this.key) {
						if (this.key = new bt, t && "[object Function]" === {}.toString.call(t)) return void this.key.generateAsync(this.default_key_size, this.default_public_exponent, t);
						this.key.generate(this.default_key_size, this.default_public_exponent)
					}
					return this.key
				}, vt.prototype.getPrivateKey = function() {
					return this.getKey()
						.getPrivateKey()
				}, vt.prototype.getPrivateKeyB64 = function() {
					return this.getKey()
						.getPrivateBaseKeyB64()
				}, vt.prototype.getPublicKey = function() {
					return this.getKey()
						.getPublicKey()
				}, vt.prototype.getPublicKeyB64 = function() {
					return this.getKey()
						.getPublicBaseKeyB64()
				}, vt.version = "3.0.0-rc.1", lt = vt, window.JSEncrypt = lt, t.JSEncrypt = lt, t.default = lt, Object.defineProperty(t, "__esModule", {
					value: !0
				})
			}))
		},
		"9bdd": function(t, e, r) {
			var n = r("825a"),
				i = r("2a62");
			t.exports = function(t, e, r, o) {
				try {
					return o ? e(n(r)[0], r[1]) : e(r)
				} catch (a) {
					i(t, "throw", a)
				}
			}
		},
		"9bf2": function(t, e, r) {
			var n = r("da84"),
				i = r("83ab"),
				o = r("0cfb"),
				a = r("aed9"),
				s = r("825a"),
				c = r("a04b"),
				u = n.TypeError,
				d = Object.defineProperty,
				l = Object.getOwnPropertyDescriptor,
				f = "enumerable",
				h = "configurable",
				p = "writable";
			e.f = i ? a ? function(t, e, r) {
				if (s(t), e = c(e), s(r), "function" === typeof t && "prototype" === e && "value" in r && p in r && !r[p]) {
					var n = l(t, e);
					n && n[p] && (t[e] = r.value, r = {
						configurable: h in r ? r[h] : n[h],
						enumerable: f in r ? r[f] : n[f],
						writable: !1
					})
				}
				return d(t, e, r)
			} : d : function(t, e, r) {
				if (s(t), e = c(e), s(r), o) try {
					return d(t, e, r)
				} catch (n) {}
				if ("get" in r || "set" in r) throw u("Accessors not supported");
				return "value" in r && (t[e] = r.value), t
			}
		},
		"9ed3": function(t, e, r) {
			"use strict";
			var n = r("ae93")
				.IteratorPrototype,
				i = r("7c73"),
				o = r("5c6c"),
				a = r("d44e"),
				s = r("3f8c"),
				c = function() {
					return this
				};
			t.exports = function(t, e, r, u) {
				var d = e + " Iterator";
				return t.prototype = i(n, {
					next: o(+!u, r)
				}), a(t, d, !1, !0), s[d] = c, t
			}
		},
		a04b: function(t, e, r) {
			var n = r("c04e"),
				i = r("d9b5");
			t.exports = function(t) {
				var e = n(t, "string");
				return i(e) ? e : e + ""
			}
		},
		a476: function(t, e, r) {
			var n;
			n = function(t) {
				"use strict";
				var e = r("cb1f"),
					n = r("699f"),
					i = "…",
					o = /^(\d\d)(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])([01]\d|2[0-3])(?:([0-5]\d)(?:([0-5]\d)(?:[.,](\d{1,3}))?)?)?(Z|[-+](?:[0]\d|1[0-2])([0-5]\d)?)?$/,
					a = /^(\d\d\d\d)(0[1-9]|1[0-2])(0[1-9]|[12]\d|3[01])([01]\d|2[0-3])(?:([0-5]\d)(?:([0-5]\d)(?:[.,](\d{1,3}))?)?)?(Z|[-+](?:[0]\d|1[0-2])([0-5]\d)?)?$/;

				function s(t, e) {
					return t.length > e && (t = t.substring(0, e) + i), t
				}

				function c(t, e) {
					t instanceof c ? (this.enc = t.enc, this.pos = t.pos) : (this.enc = t, this.pos = e)
				}
				c.prototype.get = function(t) {
					if (void 0 === t && (t = this.pos++), t >= this.enc.length) throw "Requesting byte offset " + t + " on a stream of length " + this.enc.length;
					return "string" == typeof this.enc ? this.enc.charCodeAt(t) : this.enc[t]
				}, c.prototype.hexDigits = "0123456789ABCDEF", c.prototype.hexByte = function(t) {
					return this.hexDigits.charAt(t >> 4 & 15) + this.hexDigits.charAt(15 & t)
				}, c.prototype.hexDump = function(t, e, r) {
					for (var n = "", i = t; i < e; ++i)
						if (n += this.hexByte(this.get(i)), !0 !== r) switch (15 & i) {
							case 7:
								n += "  ";
								break;
							case 15:
								n += "\n";
								break;
							default:
								n += " "
						}
					return n
				};
				var u = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";

				function d(t, e, r, n, i, o) {
					if (!(n instanceof f)) throw "Invalid tag value.";
					this.stream = t, this.header = e, this.length = r, this.tag = n, this.tagLen = i, this.sub = o
				}

				function l(t, e, r) {
					var n = !0;
					if (t.tag.tagConstructed && t.sub && (n = !1, t.sub.forEach((function(e) {
						e.tag.tagClass == t.tag.tagClass && e.tag.tagNumber == t.tag.tagNumber || (n = !0)
					}))), n) return t.stream[e](t.posContent(), t.posContent() + Math.abs(t.length), r);
					var i = {
						size: 0,
						str: ""
					};
					return t.sub.forEach((function(t) {
						var n = l(t, e, r - i.str.length);
						i.size += n.size, i.str += n.str
					})), i
				}

				function f(t) {
					var r = t.get();
					if (this.tagClass = r >> 6, this.tagConstructed = 0 !== (32 & r), this.tagNumber = 31 & r, 31 == this.tagNumber) {
						var n = new e;
						do {
							r = t.get(), n.mulAdd(128, 127 & r)
						} while (128 & r);
						this.tagNumber = n.simplify()
					}
				}
				return c.prototype.b64Dump = function(t, e) {
					var r, n, i = (e - t) % 3,
						o = "";
					for (r = t; r + 2 < e; r += 3) n = this.get(r) << 16 | this.get(r + 1) << 8 | this.get(r + 2), o += u.charAt(n >> 18 & 63), o += u.charAt(n >> 12 & 63), o += u.charAt(n >> 6 & 63), o += u.charAt(63 & n);
					return i > 0 && (n = this.get(r) << 16, i > 1 && (n |= this.get(r + 1) << 8), o += u.charAt(n >> 18 & 63), o += u.charAt(n >> 12 & 63), 2 == i && (o += u.charAt(n >> 6 & 63))), o
				}, c.prototype.isASCII = function(t, e) {
					for (var r = t; r < e; ++r) {
						var n = this.get(r);
						if (n < 32 || n > 176) return !1
					}
					return !0
				}, c.prototype.parseStringISO = function(t, e) {
					for (var r = "", n = t; n < e; ++n) r += String.fromCharCode(this.get(n));
					return r
				}, c.prototype.parseStringUTF = function(t, e) {
					function r(t) {
						if (t < 128 || t >= 192) throw new Error("Invalid UTF-8 continuation byte: " + t);
						return 63 & t
					}

					function n(t) {
						if (t < 65536) throw new Error("UTF-8 overlong encoding, codepoint encoded in 4 bytes: " + t);
						return t -= 65536, String.fromCharCode(55296 + (t >> 10), 56320 + (1023 & t))
					}
					for (var i = "", o = t; o < e;) {
						var a = this.get(o++);
						if (a < 128) i += String.fromCharCode(a);
						else {
							if (a < 192) throw new Error("Invalid UTF-8 starting byte: " + a);
							if (a < 224) i += String.fromCharCode((31 & a) << 6 | r(this.get(o++)));
							else if (a < 240) i += String.fromCharCode((15 & a) << 12 | r(this.get(o++)) << 6 | r(this.get(o++)));
							else {
								if (!(a < 248)) throw new Error("Invalid UTF-8 starting byte (since 2003 it is restricted to 4 bytes): " + a);
								i += n((7 & a) << 18 | r(this.get(o++)) << 12 | r(this.get(o++)) << 6 | r(this.get(o++)))
							}
						}
					}
					return i
				}, c.prototype.parseStringBMP = function(t, e) {
					for (var r, n, i = "", o = t; o < e;) r = this.get(o++), n = this.get(o++), i += String.fromCharCode(r << 8 | n);
					return i
				}, c.prototype.parseTime = function(t, e, r) {
					var n = this.parseStringISO(t, e),
						i = (r ? o : a)
						.exec(n);
					return i ? (r && (i[1] = +i[1], i[1] += i[1] < 70 ? 2e3 : 1900), n = i[1] + "-" + i[2] + "-" + i[3] + " " + i[4], i[5] && (n += ":" + i[5], i[6] && (n += ":" + i[6], i[7] && (n += "." + i[7]))), i[8] && (n += " UTC", "Z" != i[8] && (n += i[8], i[9] && (n += ":" + i[9]))), n) : "Unrecognized time: " + n
				}, c.prototype.parseInteger = function(t, r) {
					var n, i = this.get(t),
						o = i > 127,
						a = o ? 255 : 0,
						s = "";
					while (i == a && ++t < r) i = this.get(t);
					if (n = r - t, 0 === n) return o ? "-1" : "0";
					if (n > 4) {
						s = i, n <<= 3;
						while (0 == (128 & (s ^ a))) s <<= 1, --n;
						s = "(" + n + " bit)\n"
					}
					o && (i -= 256);
					for (var c = new e(i), u = t + 1; u < r; ++u) c.mulAdd(256, this.get(u));
					return s + c.toString()
				}, c.prototype.parseBitString = function(t, e, r) {
					var n = this.get(t);
					if (n > 7) throw "Invalid BitString with unusedBits=" + n;
					for (var i = (e - t - 1 << 3) - n, o = "", a = t + 1; a < e; ++a) {
						for (var c = this.get(a), u = a == e - 1 ? n : 0, d = 7; d >= u; --d) o += c >> d & 1 ? "1" : "0";
						o.length > r && (o = s(o, r))
					}
					return {
						size: i,
						str: o
					}
				}, c.prototype.parseOctetString = function(t, e, r) {
					var n, o = e - t;
					try {
						var a;
						for (n = this.parseStringUTF(t, e), s = 0; s < n.length; ++s)
							if (a = n.charCodeAt(s), a < 32 && 9 != a && 10 != a && 13 != a) throw new Error("Unprintable character at index " + s + " (code " + n.charCodeAt(s) + ")");
						return {
							size: o,
							str: n
						}
					} catch (c) {}
					r /= 2, o > r && (e = t + r), n = "";
					for (var s = t; s < e; ++s) n += this.hexByte(this.get(s));
					return o > r && (n += i), {
						size: o,
						str: n
					}
				}, c.prototype.parseOID = function(t, r, i) {
					for (var o = "", a = new e, c = 0, u = t; u < r; ++u) {
						var d = this.get(u);
						if (a.mulAdd(128, 127 & d), c += 7, !(128 & d)) {
							if ("" === o)
								if (a = a.simplify(), a instanceof e) a.sub(80), o = "2." + a.toString();
								else {
									var l = a < 80 ? a < 40 ? 0 : 1 : 2;
									o = l + "." + (a - 40 * l)
								}
							else o += "." + a.toString();
							if (o.length > i) return s(o, i);
							a = new e, c = 0
						}
					}
					if (c > 0 && (o += ".incomplete"), "object" === typeof n) {
						var f = n[o];
						f && (f.d && (o += "\n" + f.d), f.c && (o += "\n" + f.c), f.w && (o += "\n(warning!)"))
					}
					return o
				}, d.prototype.typeName = function() {
					switch (this.tag.tagClass) {
						case 0:
							switch (this.tag.tagNumber) {
								case 0:
									return "EOC";
								case 1:
									return "BOOLEAN";
								case 2:
									return "INTEGER";
								case 3:
									return "BIT_STRING";
								case 4:
									return "OCTET_STRING";
								case 5:
									return "NULL";
								case 6:
									return "OBJECT_IDENTIFIER";
								case 7:
									return "ObjectDescriptor";
								case 8:
									return "EXTERNAL";
								case 9:
									return "REAL";
								case 10:
									return "ENUMERATED";
								case 11:
									return "EMBEDDED_PDV";
								case 12:
									return "UTF8String";
								case 16:
									return "SEQUENCE";
								case 17:
									return "SET";
								case 18:
									return "NumericString";
								case 19:
									return "PrintableString";
								case 20:
									return "TeletexString";
								case 21:
									return "VideotexString";
								case 22:
									return "IA5String";
								case 23:
									return "UTCTime";
								case 24:
									return "GeneralizedTime";
								case 25:
									return "GraphicString";
								case 26:
									return "VisibleString";
								case 27:
									return "GeneralString";
								case 28:
									return "UniversalString";
								case 30:
									return "BMPString"
							}
							return "Universal_" + this.tag.tagNumber.toString();
						case 1:
							return "Application_" + this.tag.tagNumber.toString();
						case 2:
							return "[" + this.tag.tagNumber.toString() + "]";
						case 3:
							return "Private_" + this.tag.tagNumber.toString()
					}
				}, d.prototype.content = function(t) {
					if (void 0 === this.tag) return null;
					void 0 === t && (t = 1 / 0);
					var e = this.posContent(),
						r = Math.abs(this.length);
					if (!this.tag.isUniversal()) {
						if (null !== this.sub) return "(" + this.sub.length + " elem)";
						var n = this.stream.parseOctetString(e, e + r, t);
						return "(" + n.size + " byte)\n" + n.str
					}
					switch (this.tag.tagNumber) {
						case 1:
							return 0 === this.stream.get(e) ? "false" : "true";
						case 2:
							return this.stream.parseInteger(e, e + r);
						case 3:
							var i = l(this, "parseBitString", t);
							return "(" + i.size + " bit)\n" + i.str;
						case 4:
							return i = l(this, "parseOctetString", t), "(" + i.size + " byte)\n" + i.str;
						case 6:
							return this.stream.parseOID(e, e + r, t);
						case 10:
							return this.stream.parseInteger(e, e + r);
						case 16:
						case 17:
							return null !== this.sub ? "(" + this.sub.length + " elem)" : "(no elem)";
						case 12:
							return s(this.stream.parseStringUTF(e, e + r), t);
						case 18:
						case 19:
						case 20:
						case 21:
						case 22:
						case 26:
						case 27:
							return s(this.stream.parseStringISO(e, e + r), t);
						case 30:
							return s(this.stream.parseStringBMP(e, e + r), t);
						case 23:
						case 24:
							return this.stream.parseTime(e, e + r, 23 == this.tag.tagNumber)
					}
					return null
				}, d.prototype.toString = function() {
					return this.typeName() + "@" + this.stream.pos + "[header:" + this.header + ",length:" + this.length + ",sub:" + (null === this.sub ? "null" : this.sub.length) + "]"
				}, d.prototype.toPrettyString = function(t) {
					void 0 === t && (t = "");
					var e = t + this.typeName() + " @" + this.stream.pos;
					this.length >= 0 && (e += "+"), e += this.length, this.tag.tagConstructed ? e += " (constructed)" : !this.tag.isUniversal() || 3 != this.tag.tagNumber && 4 != this.tag.tagNumber || null === this.sub || (e += " (encapsulates)");
					var r = this.content();
					if (r && (e += ": " + r.replace(/\n/g, "|")), e += "\n", null !== this.sub) {
						t += "  ";
						for (var n = 0, i = this.sub.length; n < i; ++n) e += this.sub[n].toPrettyString(t)
					}
					return e
				}, d.prototype.posStart = function() {
					return this.stream.pos
				}, d.prototype.posContent = function() {
					return this.stream.pos + this.header
				}, d.prototype.posEnd = function() {
					return this.stream.pos + this.header + Math.abs(this.length)
				}, d.prototype.posLen = function() {
					return this.stream.pos + this.tagLen
				}, d.prototype.toHexString = function() {
					return this.stream.hexDump(this.posStart(), this.posEnd(), !0)
				}, d.prototype.toB64String = function() {
					return this.stream.b64Dump(this.posStart(), this.posEnd())
				}, d.decodeLength = function(t) {
					var e = t.get(),
						r = 127 & e;
					if (r == e) return r;
					if (0 === r) return null;
					if (r > 6) throw "Length over 48 bits not supported at position " + (t.pos - 1);
					e = 0;
					for (var n = 0; n < r; ++n) e = 256 * e + t.get();
					return e
				}, f.prototype.isUniversal = function() {
					return 0 === this.tagClass
				}, f.prototype.isEOC = function() {
					return 0 === this.tagClass && 0 === this.tagNumber
				}, d.decode = function(t, e) {
					t instanceof c || (t = new c(t, e || 0));
					var r = new c(t),
						n = new f(t),
						i = t.pos - r.pos,
						o = d.decodeLength(t),
						a = t.pos,
						s = a - r.pos,
						u = null,
						l = function() {
							if (u = [], null !== o) {
								var e = a + o;
								if (e > t.enc.length) throw "Container at offset " + a + " has a length of " + o + ", which is past the end of the stream";
								while (t.pos < e) u[u.length] = d.decode(t);
								if (t.pos != e) throw "Content size is not correct for container at offset " + a
							} else try {
								for (;;) {
									var r = d.decode(t);
									if (r.tag.isEOC()) break;
									u[u.length] = r
								}
								o = a - t.pos
							} catch (n) {
								throw "Exception while decoding undefined length content at offset " + a + ": " + n
							}
						};
					if (n.tagConstructed) l();
					else if (n.isUniversal() && (3 == n.tagNumber || 4 == n.tagNumber)) try {
						if (3 == n.tagNumber && 0 != t.get()) throw "BIT STRINGs with unused bits cannot encapsulate.";
						l();
						for (var h = 0; h < u.length; ++h)
							if (u[h].tag.isEOC()) throw "EOC is not supposed to be actual content."
					} catch (p) {
						u = null
					}
					if (null === u) {
						if (null === o) throw "We can't skip over an invalid tag with undefined length at offset " + a;
						t.pos = a + Math.abs(o)
					}
					return new d(r, s, o, n, i, u)
				}, d
			}.call(e, r, e, t), void 0 === n || (t.exports = n)
		},
		a4b4: function(t, e, r) {
			var n = r("342f");
			t.exports = /web0s(?!.*chrome)/i.test(n)
		},
		a4d3: function(t, e, r) {
			r("d9f5"), r("b4f8"), r("c513"), r("e9c4"), r("5a47")
		},
		a630: function(t, e, r) {
			var n = r("23e7"),
				i = r("4df4"),
				o = r("1c7e"),
				a = !o((function(t) {
					Array.from(t)
				}));
			n({
				target: "Array",
				stat: !0,
				forced: a
			}, {
				from: i
			})
		},
		a79d: function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("c430"),
				o = r("d256"),
				a = r("d039"),
				s = r("d066"),
				c = r("1626"),
				u = r("4840"),
				d = r("cdf9"),
				l = r("cb2d"),
				f = o && o.prototype,
				h = !!o && a((function() {
					f["finally"].call({
						then: function() {}
					}, (function() {}))
				}));
			if (n({
				target: "Promise",
				proto: !0,
				real: !0,
				forced: h
			}, {
				finally: function(t) {
					var e = u(this, s("Promise")),
						r = c(t);
					return this.then(r ? function(r) {
						return d(e, t())
							.then((function() {
								return r
							}))
					} : t, r ? function(r) {
						return d(e, t())
							.then((function() {
								throw r
							}))
					} : t)
				}
			}), !i && c(o)) {
				var p = s("Promise")
					.prototype["finally"];
				f["finally"] !== p && l(f, "finally", p, {
					unsafe: !0
				})
			}
		},
		a960: function(t, e, r) {
			r("4fadc");
			var n = r("428f");
			t.exports = n.Object.entries
		},
		a981: function(t, e) {
			t.exports = "undefined" != typeof ArrayBuffer && "undefined" != typeof DataView
		},
		a9c6: function(t, e, r) {
			"use strict";
			r.d(e, "a", (function() {
				return p
			}));
			var n = r("6f9c"),
				i = r.n(n),
				o = r("64c1"),
				a = r.n(o),
				s = r("a476"),
				c = r.n(s);

			function u(t) {
				return u = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t) {
					return typeof t
				} : function(t) {
					return t && "function" == typeof Symbol && t.constructor === Symbol && t !== Symbol.prototype ? "symbol" : typeof t
				}, u(t)
			}

			function d() {
				/*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */
				d = function() {
					return t
				};
				var t = {},
					e = Object.prototype,
					r = e.hasOwnProperty,
					n = "function" == typeof Symbol ? Symbol : {},
					i = n.iterator || "@@iterator",
					o = n.asyncIterator || "@@asyncIterator",
					a = n.toStringTag || "@@toStringTag";

				function s(t, e, r) {
					return Object.defineProperty(t, e, {
						value: r,
						enumerable: !0,
						configurable: !0,
						writable: !0
					}), t[e]
				}
				try {
					s({}, "")
				} catch (x) {
					s = function(t, e, r) {
						return t[e] = r
					}
				}

				function c(t, e, r, n) {
					var i = e && e.prototype instanceof h ? e : h,
						o = Object.create(i.prototype),
						a = new I(n || []);
					return o._invoke = function(t, e, r) {
						var n = "suspendedStart";
						return function(i, o) {
							if ("executing" === n) throw new Error("Generator is already running");
							if ("completed" === n) {
								if ("throw" === i) throw o;
								return T()
							}
							for (r.method = i, r.arg = o;;) {
								var a = r.delegate;
								if (a) {
									var s = C(a, r);
									if (s) {
										if (s === f) continue;
										return s
									}
								}
								if ("next" === r.method) r.sent = r._sent = r.arg;
								else if ("throw" === r.method) {
									if ("suspendedStart" === n) throw n = "completed", r.arg;
									r.dispatchException(r.arg)
								} else "return" === r.method && r.abrupt("return", r.arg);
								n = "executing";
								var c = l(t, e, r);
								if ("normal" === c.type) {
									if (n = r.done ? "completed" : "suspendedYield", c.arg === f) continue;
									return {
										value: c.arg,
										done: r.done
									}
								}
								"throw" === c.type && (n = "completed", r.method = "throw", r.arg = c.arg)
							}
						}
					}(t, r, a), o
				}

				function l(t, e, r) {
					try {
						return {
							type: "normal",
							arg: t.call(e, r)
						}
					} catch (x) {
						return {
							type: "throw",
							arg: x
						}
					}
				}
				t.wrap = c;
				var f = {};

				function h() {}

				function p() {}

				function m() {}
				var b = {};
				s(b, i, (function() {
					return this
				}));
				var g = Object.getPrototypeOf,
					y = g && g(g(E([])));
				y && y !== e && r.call(y, i) && (b = y);
				var v = m.prototype = h.prototype = Object.create(b);

				function S(t) {
					["next", "throw", "return"].forEach((function(e) {
						s(t, e, (function(t) {
							return this._invoke(e, t)
						}))
					}))
				}

				function w(t, e) {
					function n(i, o, a, s) {
						var c = l(t[i], t, o);
						if ("throw" !== c.type) {
							var d = c.arg,
								f = d.value;
							return f && "object" == u(f) && r.call(f, "__await") ? e.resolve(f.__await)
								.then((function(t) {
									n("next", t, a, s)
								}), (function(t) {
									n("throw", t, a, s)
								})) : e.resolve(f)
								.then((function(t) {
									d.value = t, a(d)
								}), (function(t) {
									return n("throw", t, a, s)
								}))
						}
						s(c.arg)
					}
					var i;
					this._invoke = function(t, r) {
						function o() {
							return new e((function(e, i) {
								n(t, r, e, i)
							}))
						}
						return i = i ? i.then(o, o) : o()
					}
				}

				function C(t, e) {
					var r = t.iterator[e.method];
					if (void 0 === r) {
						if (e.delegate = null, "throw" === e.method) {
							if (t.iterator.return && (e.method = "return", e.arg = void 0, C(t, e), "throw" === e.method)) return f;
							e.method = "throw", e.arg = new TypeError("The iterator does not provide a 'throw' method")
						}
						return f
					}
					var n = l(r, t.iterator, e.arg);
					if ("throw" === n.type) return e.method = "throw", e.arg = n.arg, e.delegate = null, f;
					var i = n.arg;
					return i ? i.done ? (e[t.resultName] = i.value, e.next = t.nextLoc, "return" !== e.method && (e.method = "next", e.arg = void 0), e.delegate = null, f) : i : (e.method = "throw", e.arg = new TypeError("iterator result is not an object"), e.delegate = null, f)
				}

				function _(t) {
					var e = {
						tryLoc: t[0]
					};
					1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e)
				}

				function A(t) {
					var e = t.completion || {};
					e.type = "normal", delete e.arg, t.completion = e
				}

				function I(t) {
					this.tryEntries = [{
						tryLoc: "root"
					}], t.forEach(_, this), this.reset(!0)
				}

				function E(t) {
					if (t) {
						var e = t[i];
						if (e) return e.call(t);
						if ("function" == typeof t.next) return t;
						if (!isNaN(t.length)) {
							var n = -1,
								o = function e() {
									for (; ++n < t.length;)
										if (r.call(t, n)) return e.value = t[n], e.done = !1, e;
									return e.value = void 0, e.done = !0, e
								};
							return o.next = o
						}
					}
					return {
						next: T
					}
				}

				function T() {
					return {
						value: void 0,
						done: !0
					}
				}
				return p.prototype = m, s(v, "constructor", m), s(m, "constructor", p), p.displayName = s(m, a, "GeneratorFunction"), t.isGeneratorFunction = function(t) {
					var e = "function" == typeof t && t.constructor;
					return !!e && (e === p || "GeneratorFunction" === (e.displayName || e.name))
				}, t.mark = function(t) {
					return Object.setPrototypeOf ? Object.setPrototypeOf(t, m) : (t.__proto__ = m, s(t, a, "GeneratorFunction")), t.prototype = Object.create(v), t
				}, t.awrap = function(t) {
					return {
						__await: t
					}
				}, S(w.prototype), s(w.prototype, o, (function() {
					return this
				})), t.AsyncIterator = w, t.async = function(e, r, n, i, o) {
					void 0 === o && (o = Promise);
					var a = new w(c(e, r, n, i), o);
					return t.isGeneratorFunction(r) ? a : a.next()
						.then((function(t) {
							return t.done ? t.value : a.next()
						}))
				}, S(v), s(v, a, "Generator"), s(v, i, (function() {
					return this
				})), s(v, "toString", (function() {
					return "[object Generator]"
				})), t.keys = function(t) {
					var e = [];
					for (var r in t) e.push(r);
					return e.reverse(),
						function r() {
							for (; e.length;) {
								var n = e.pop();
								if (n in t) return r.value = n, r.done = !1, r
							}
							return r.done = !0, r
						}
				}, t.values = E, I.prototype = {
					constructor: I,
					reset: function(t) {
						if (this.prev = 0, this.next = 0, this.sent = this._sent = void 0, this.done = !1, this.delegate = null, this.method = "next", this.arg = void 0, this.tryEntries.forEach(A), !t)
							for (var e in this) "t" === e.charAt(0) && r.call(this, e) && !isNaN(+e.slice(1)) && (this[e] = void 0)
					},
					stop: function() {
						this.done = !0;
						var t = this.tryEntries[0].completion;
						if ("throw" === t.type) throw t.arg;
						return this.rval
					},
					dispatchException: function(t) {
						if (this.done) throw t;
						var e = this;

						function n(r, n) {
							return a.type = "throw", a.arg = t, e.next = r, n && (e.method = "next", e.arg = void 0), !!n
						}
						for (var i = this.tryEntries.length - 1; i >= 0; --i) {
							var o = this.tryEntries[i],
								a = o.completion;
							if ("root" === o.tryLoc) return n("end");
							if (o.tryLoc <= this.prev) {
								var s = r.call(o, "catchLoc"),
									c = r.call(o, "finallyLoc");
								if (s && c) {
									if (this.prev < o.catchLoc) return n(o.catchLoc, !0);
									if (this.prev < o.finallyLoc) return n(o.finallyLoc)
								} else if (s) {
									if (this.prev < o.catchLoc) return n(o.catchLoc, !0)
								} else {
									if (!c) throw new Error("try statement without catch or finally");
									if (this.prev < o.finallyLoc) return n(o.finallyLoc)
								}
							}
						}
					},
					abrupt: function(t, e) {
						for (var n = this.tryEntries.length - 1; n >= 0; --n) {
							var i = this.tryEntries[n];
							if (i.tryLoc <= this.prev && r.call(i, "finallyLoc") && this.prev < i.finallyLoc) {
								var o = i;
								break
							}
						}
						o && ("break" === t || "continue" === t) && o.tryLoc <= e && e <= o.finallyLoc && (o = null);
						var a = o ? o.completion : {};
						return a.type = t, a.arg = e, o ? (this.method = "next", this.next = o.finallyLoc, f) : this.complete(a)
					},
					complete: function(t, e) {
						if ("throw" === t.type) throw t.arg;
						return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), f
					},
					finish: function(t) {
						for (var e = this.tryEntries.length - 1; e >= 0; --e) {
							var r = this.tryEntries[e];
							if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), A(r), f
						}
					},
					catch: function(t) {
						for (var e = this.tryEntries.length - 1; e >= 0; --e) {
							var r = this.tryEntries[e];
							if (r.tryLoc === t) {
								var n = r.completion;
								if ("throw" === n.type) {
									var i = n.arg;
									A(r)
								}
								return i
							}
						}
						throw new Error("illegal catch attempt")
					},
					delegateYield: function(t, e, r) {
						return this.delegate = {
							iterator: E(t),
							resultName: e,
							nextLoc: r
						}, "next" === this.method && (this.arg = void 0), f
					}
				}, t
			}

			function l(t, e, r, n, i, o, a) {
				try {
					var s = t[o](a),
						c = s.value
				} catch (u) {
					return void r(u)
				}
				s.done ? e(c) : Promise.resolve(c)
					.then(n, i)
			}

			function f(t) {
				return function() {
					var e = this,
						r = arguments;
					return new Promise((function(n, i) {
						var o = t.apply(e, r);

						function a(t) {
							l(o, n, i, a, s, "next", t)
						}

						function s(t) {
							l(o, n, i, a, s, "throw", t)
						}
						a(void 0)
					}))
				}
			}
			var h = /^\s*(?:[0-9A-Fa-f][0-9A-Fa-f]\s*)+$/,
				p = function() {
					var t = f(d()
						.mark((function t(e, r) {
							return d()
								.wrap((function(t) {
									while (1) switch (t.prev = t.next) {
										case 0:
											return t.abrupt("return", new Promise((function(t, n) {
												e.files[r].async("base64")
													.then((function(e) {
														var r = m(e);
														t(r)
													}), (function(t) {
														n(t)
													}))
											})));
										case 1:
										case "end":
											return t.stop()
									}
								}), t)
						})));
					return function(e, r) {
						return t.apply(this, arguments)
					}
				}(),
				m = function(t) {
					try {
						var e = h.test(t) ? i.a.decode(t) : a.a.unarmor(t);
						return b(e)
					} catch (r) {
						return console.log(r), {}
					}
				},
				b = function(t, e) {
					e = e || 0;
					try {
						var r = y(t, e);
						if (void 0 === r.toSign) return {};
						var n = r.toSign.eseal.esealInfo.picture.type,
							i = r.toSign.eseal.esealInfo.picture.data.byte,
							o = r.toSign.eseal.esealInfo.picture.width,
							a = r.toSign.eseal.esealInfo.picture.height;
						return {
							ofdArray: i,
							type: n.toLowerCase(),
							width: o,
							height: a,
							SES_Signature: r,
							verifyRet: !0
						}
					} catch (s) {
						return console.log(s), {}
					}
				},
				g = function(t) {
					t = t.replace("Unrecognized time: ", "");
					t.indexOf("Z");
					return t = t.replace("Z", ""), t = t.substr(0, 1) < "5" ? "20" + t : "19" + t, t
				},
				y = function(t, e) {
					e = e || 0;
					var r, n = c.a.decode(t, e);
					try {
						var i, o, a, s, u, d, l, f, h, p, m, b, y, I, E, T, x, P, k, D, O, R, N, M, B, F, j, K, L, U, X, z, G, q, W, V, H, Y, Z, Q, J, $, tt, et, rt, nt, it, ot, at, st, ct, ut, dt, lt, ft, ht, pt, mt, bt, gt, yt, vt, St, wt, Ct, _t, At, It, Et, Tt, xt, Pt, kt, Dt, Ot, Rt, Nt, Mt, Bt, Ft, jt, Kt, Lt, Ut, Xt, zt, Gt, qt, Wt, Vt, Ht, Yt, Zt, Qt, Jt, $t, te, ee, re, ne, ie = g(null === (i = n.sub[0]) || void 0 === i || null === (o = i.sub[1]) || void 0 === o || null === (a = o.sub[0]) || void 0 === a || null === (s = a.sub[2]) || void 0 === s || null === (u = s.sub[3]) || void 0 === u ? void 0 : u.stream.parseTime(n.sub[0].sub[1].sub[0].sub[2].sub[3].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[3].header, n.sub[0].sub[1].sub[0].sub[2].sub[3].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[3].header + n.sub[0].sub[1].sub[0].sub[2].sub[3].length)),
							oe = g(null === (d = n.sub[0]) || void 0 === d || null === (l = d.sub[1]) || void 0 === l || null === (f = l.sub[0]) || void 0 === f || null === (h = f.sub[2]) || void 0 === h || null === (p = h.sub[4]) || void 0 === p ? void 0 : p.stream.parseTime(n.sub[0].sub[1].sub[0].sub[2].sub[4].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[4].header, n.sub[0].sub[1].sub[0].sub[2].sub[4].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[4].header + n.sub[0].sub[1].sub[0].sub[2].sub[4].length)),
							ae = g(null === (m = n.sub[0]) || void 0 === m || null === (b = m.sub[1]) || void 0 === b || null === (y = b.sub[0]) || void 0 === y || null === (I = y.sub[2]) || void 0 === I || null === (E = I.sub[5]) || void 0 === E ? void 0 : E.stream.parseTime(n.sub[0].sub[1].sub[0].sub[2].sub[5].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[5].header, n.sub[0].sub[1].sub[0].sub[2].sub[5].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[5].header + n.sub[0].sub[1].sub[0].sub[2].sub[5].length)),
							se = g(null === (T = n.sub[0]) || void 0 === T || null === (x = T.sub[2]) || void 0 === x ? void 0 : x.stream.parseTime(n.sub[0].sub[2].stream.pos + n.sub[0].sub[2].header, n.sub[0].sub[2].stream.pos + n.sub[0].sub[2].header + n.sub[0].sub[2].length, !1)),
							ce = null === (P = n.sub[0]) || void 0 === P || null === (k = P.sub[1]) || void 0 === k || null === (D = k.sub[0]) || void 0 === D || null === (O = D.sub[2]) || void 0 === O ? void 0 : O.sub[2],
							ue = new Array;
						ce && ce.sub.forEach((function(t) {
							ue.push(t.stream.parseOctetString(t.stream.pos + t.header, t.stream.pos + t.header + t.length))
						}));
						var de = null === (R = n.sub[0]) || void 0 === R || null === (N = R.sub[1]) || void 0 === N || null === (M = N.sub[0]) || void 0 === M ? void 0 : M.sub[4],
							le = new Array;
						de && de.sub.forEach((function(t) {
							var e, r, n;
							le.push({
								extnID: null === (e = t.sub[0]) || void 0 === e ? void 0 : e.stream.parseOID(t.sub[0].stream.pos + t.sub[0].header, t.sub[0].stream.pos + t.sub[0].header + t.sub[0].length),
								critical: null === (r = t.sub[1]) || void 0 === r ? void 0 : r.stream.parseInteger(t.sub[1].stream.pos + t.sub[1].header, t.sub[1].stream.pos + t.sub[1].header + t.sub[1].length),
								extnValue: null === (n = t.sub[2]) || void 0 === n ? void 0 : n.stream.parseOctetString(t.sub[2].stream.pos + t.sub[2].header, t.sub[2].stream.pos + t.sub[2].header + t.sub[2].length)
							})
						})), r = {
							realVersion: 1,
							toSignDer: null === (B = n.sub[0]) || void 0 === B ? void 0 : B.stream.enc.subarray(n.sub[0].stream.pos, n.sub[0].stream.pos + n.sub[0].header + n.sub[0].length),
							toSign: {
								version: null === (F = n.sub[0]) || void 0 === F || null === (j = F.sub[0]) || void 0 === j ? void 0 : j.stream.parseInteger(n.sub[0].sub[0].stream.pos + n.sub[0].sub[0].header, n.sub[0].sub[0].stream.pos + n.sub[0].sub[0].header + n.sub[0].sub[0].length),
								eseal: {
									esealInfo: {
										header: {
											ID: null === (K = n.sub[0]) || void 0 === K || null === (L = K.sub[1]) || void 0 === L || null === (U = L.sub[0]) || void 0 === U || null === (X = U.sub[0]) || void 0 === X || null === (z = X.sub[0]) || void 0 === z ? void 0 : z.stream.parseStringUTF(n.sub[0].sub[1].sub[0].sub[0].sub[0].stream.pos + n.sub[0].sub[1].sub[0].sub[0].sub[0].header, n.sub[0].sub[1].sub[0].sub[0].sub[0].stream.pos + n.sub[0].sub[1].sub[0].sub[0].sub[0].header + n.sub[0].sub[1].sub[0].sub[0].sub[0].length),
											version: null === (G = n.sub[0]) || void 0 === G || null === (q = G.sub[1]) || void 0 === q || null === (W = q.sub[0]) || void 0 === W || null === (V = W.sub[0]) || void 0 === V || null === (H = V.sub[1]) || void 0 === H ? void 0 : H.stream.parseInteger(n.sub[0].sub[1].sub[0].sub[0].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[0].sub[1].header, n.sub[0].sub[1].sub[0].sub[0].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[0].sub[1].header + n.sub[0].sub[1].sub[0].sub[0].sub[1].length),
											Vid: null === (Y = n.sub[0]) || void 0 === Y || null === (Z = Y.sub[1]) || void 0 === Z || null === (Q = Z.sub[0]) || void 0 === Q || null === (J = Q.sub[0]) || void 0 === J || null === ($ = J.sub[2]) || void 0 === $ ? void 0 : $.stream.parseStringUTF(n.sub[0].sub[1].sub[0].sub[0].sub[2].stream.pos + n.sub[0].sub[1].sub[0].sub[0].sub[2].header, n.sub[0].sub[1].sub[0].sub[0].sub[2].stream.pos + n.sub[0].sub[1].sub[0].sub[0].sub[2].header + n.sub[0].sub[1].sub[0].sub[0].sub[2].length)
										},
										esID: null === (tt = n.sub[0]) || void 0 === tt || null === (et = tt.sub[1]) || void 0 === et || null === (rt = et.sub[0]) || void 0 === rt || null === (nt = rt.sub[1]) || void 0 === nt ? void 0 : nt.stream.parseStringUTF(n.sub[0].sub[1].sub[0].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[1].header, n.sub[0].sub[1].sub[0].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[1].header + n.sub[0].sub[1].sub[0].sub[1].length),
										property: {
											type: null === (it = n.sub[0]) || void 0 === it || null === (ot = it.sub[1]) || void 0 === ot || null === (at = ot.sub[0]) || void 0 === at || null === (st = at.sub[2]) || void 0 === st || null === (ct = st.sub[0]) || void 0 === ct ? void 0 : ct.stream.parseInteger(n.sub[0].sub[1].sub[0].sub[2].sub[0].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[0].header, n.sub[0].sub[1].sub[0].sub[2].sub[0].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[0].header + n.sub[0].sub[1].sub[0].sub[2].sub[0].length),
											name: null === (ut = n.sub[0]) || void 0 === ut || null === (dt = ut.sub[1]) || void 0 === dt || null === (lt = dt.sub[0]) || void 0 === lt || null === (ft = lt.sub[2]) || void 0 === ft || null === (ht = ft.sub[1]) || void 0 === ht ? void 0 : ht.stream.parseStringUTF(n.sub[0].sub[1].sub[0].sub[2].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[1].header, n.sub[0].sub[1].sub[0].sub[2].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[1].header + n.sub[0].sub[1].sub[0].sub[2].sub[1].length),
											certList: ue,
											createDate: ie,
											validStart: oe,
											validEnd: ae
										},
										picture: {
											type: null === (pt = n.sub[0]) || void 0 === pt || null === (mt = pt.sub[1]) || void 0 === mt || null === (bt = mt.sub[0]) || void 0 === bt || null === (gt = bt.sub[3]) || void 0 === gt || null === (yt = gt.sub[0]) || void 0 === yt ? void 0 : yt.stream.parseStringUTF(n.sub[0].sub[1].sub[0].sub[3].sub[0].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[0].header, n.sub[0].sub[1].sub[0].sub[3].sub[0].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[0].header + n.sub[0].sub[1].sub[0].sub[3].sub[0].length),
											data: {
												hex: null === (vt = n.sub[0]) || void 0 === vt || null === (St = vt.sub[1]) || void 0 === St || null === (wt = St.sub[0]) || void 0 === wt || null === (Ct = wt.sub[3]) || void 0 === Ct || null === (_t = Ct.sub[1]) || void 0 === _t ? void 0 : _t.stream.parseOctetString(n.sub[0].sub[1].sub[0].sub[3].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[1].header, n.sub[0].sub[1].sub[0].sub[3].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[1].header + n.sub[0].sub[1].sub[0].sub[3].sub[1].length),
												byte: null === (At = n.sub[0]) || void 0 === At || null === (It = At.sub[1]) || void 0 === It || null === (Et = It.sub[0]) || void 0 === Et || null === (Tt = Et.sub[3]) || void 0 === Tt || null === (xt = Tt.sub[1]) || void 0 === xt ? void 0 : xt.stream.enc.subarray(n.sub[0].sub[1].sub[0].sub[3].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[1].header, n.sub[0].sub[1].sub[0].sub[3].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[1].header + n.sub[0].sub[1].sub[0].sub[3].sub[1].length)
											},
											width: null === (Pt = n.sub[0]) || void 0 === Pt || null === (kt = Pt.sub[1]) || void 0 === kt || null === (Dt = kt.sub[0]) || void 0 === Dt || null === (Ot = Dt.sub[3]) || void 0 === Ot || null === (Rt = Ot.sub[2]) || void 0 === Rt ? void 0 : Rt.stream.parseInteger(n.sub[0].sub[1].sub[0].sub[3].sub[2].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[2].header, n.sub[0].sub[1].sub[0].sub[3].sub[2].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[2].header + n.sub[0].sub[1].sub[0].sub[3].sub[2].length),
											height: null === (Nt = n.sub[0]) || void 0 === Nt || null === (Mt = Nt.sub[1]) || void 0 === Mt || null === (Bt = Mt.sub[0]) || void 0 === Bt || null === (Ft = Bt.sub[3]) || void 0 === Ft || null === (jt = Ft.sub[3]) || void 0 === jt ? void 0 : jt.stream.parseInteger(n.sub[0].sub[1].sub[0].sub[3].sub[3].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[3].header, n.sub[0].sub[1].sub[0].sub[3].sub[3].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[3].header + n.sub[0].sub[1].sub[0].sub[3].sub[3].length)
										},
										extDatas: le
									},
									signInfo: {
										cert: v(null === (Kt = n.sub[0]) || void 0 === Kt || null === (Lt = Kt.sub[1]) || void 0 === Lt || null === (Ut = Lt.sub[1]) || void 0 === Ut ? void 0 : Ut.sub[0]),
										signatureAlgorithm: null === (Xt = n.sub[0]) || void 0 === Xt || null === (zt = Xt.sub[1]) || void 0 === zt || null === (Gt = zt.sub[1]) || void 0 === Gt || null === (qt = Gt.sub[1]) || void 0 === qt ? void 0 : qt.stream.parseOID(n.sub[0].sub[1].sub[1].sub[1].stream.pos + n.sub[0].sub[1].sub[1].sub[1].header, n.sub[0].sub[1].sub[1].sub[1].stream.pos + n.sub[0].sub[1].sub[1].sub[1].header + n.sub[0].sub[1].sub[1].sub[1].length),
										signData: null === (Wt = n.sub[0]) || void 0 === Wt || null === (Vt = Wt.sub[1]) || void 0 === Vt || null === (Ht = Vt.sub[1]) || void 0 === Ht || null === (Yt = Ht.sub[2]) || void 0 === Yt ? void 0 : Yt.stream.hexDump(n.sub[0].sub[1].sub[1].sub[2].stream.pos + n.sub[0].sub[1].sub[1].sub[2].header, n.sub[0].sub[1].sub[1].sub[2].stream.pos + n.sub[0].sub[1].sub[1].sub[2].header + n.sub[0].sub[1].sub[1].sub[2].length, !1)
									}
								},
								timeInfo: se,
								dataHash: null === (Zt = n.sub[0]) || void 0 === Zt || null === (Qt = Zt.sub[3]) || void 0 === Qt ? void 0 : Qt.stream.hexDump(n.sub[0].sub[3].stream.pos + n.sub[0].sub[3].header, n.sub[0].sub[3].stream.pos + n.sub[0].sub[3].header + n.sub[0].sub[3].length, !1),
								propertyInfo: null === (Jt = n.sub[0]) || void 0 === Jt || null === ($t = Jt.sub[4]) || void 0 === $t ? void 0 : $t.stream.parseStringUTF(n.sub[0].sub[4].stream.pos + n.sub[0].sub[4].header, n.sub[0].sub[4].stream.pos + n.sub[0].sub[4].header + n.sub[0].sub[4].length),
								cert: v(null === (te = n.sub[0]) || void 0 === te ? void 0 : te.sub[5]),
								signatureAlgorithm: null === (ee = n.sub[0]) || void 0 === ee || null === (re = ee.sub[6]) || void 0 === re ? void 0 : re.stream.parseOID(n.sub[0].sub[6].stream.pos + n.sub[0].sub[6].header, n.sub[0].sub[6].stream.pos + n.sub[0].sub[6].header + n.sub[0].sub[6].length)
							},
							signature: null === (ne = n.sub[1]) || void 0 === ne ? void 0 : ne.stream.hexDump(n.sub[1].stream.pos + n.sub[1].header, n.sub[1].stream.pos + n.sub[1].header + n.sub[1].length, !1)
						}
					} catch (fn) {
						try {
							var fe, he, pe, me, be, ge, ye, ve, Se, we, Ce, _e, Ae, Ie, Ee, Te, xe, Pe, ke, De, Oe, Re, Ne, Me, Be, Fe, je, Ke, Le, Ue, Xe, ze, Ge, qe, We, Ve, He, Ye, Ze, Qe, Je, $e, tr, er, rr, nr, ir, or, ar, sr, cr, ur, dr, lr, fr, hr, pr, mr, br, gr, yr, vr, Sr, wr, Cr, _r, Ar, Ir, Er, Tr, xr, Pr, kr, Dr, Or, Rr, Nr, Mr, Br, Fr, jr, Kr, Lr, Ur, Xr, zr, Gr, qr, Wr, Vr, Hr, Yr, Zr, Qr, Jr, $r, tn, en, rn, nn = null === (fe = n.sub[0]) || void 0 === fe || null === (he = fe.sub[1]) || void 0 === he || null === (pe = he.sub[0]) || void 0 === pe || null === (me = pe.sub[2]) || void 0 === me || null === (be = me.sub[2]) || void 0 === be ? void 0 : be.stream.parseInteger(n.sub[0].sub[1].sub[0].sub[2].sub[2].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[2].header, n.sub[0].sub[1].sub[0].sub[2].sub[2].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[2].header + n.sub[0].sub[1].sub[0].sub[2].sub[2].length),
								on = null === (ge = n.sub[0]) || void 0 === ge || null === (ye = ge.sub[1]) || void 0 === ye || null === (ve = ye.sub[0]) || void 0 === ve || null === (Se = ve.sub[2]) || void 0 === Se ? void 0 : Se.sub[3],
								an = new Array;
							on && on.sub.forEach((function(t) {
								an.push(t.stream.parseOctetString(t.stream.pos + t.header, t.stream.pos + t.header + t.length))
							}));
							var sn = null === (we = n.sub[0]) || void 0 === we || null === (Ce = we.sub[1]) || void 0 === Ce || null === (_e = Ce.sub[0]) || void 0 === _e ? void 0 : _e.sub[4],
								cn = new Array;
							sn && sn.sub.forEach((function(t) {
								var e, r, n;
								cn.push({
									extnID: null === (e = t.sub[0]) || void 0 === e ? void 0 : e.stream.parseOID(t.sub[0].stream.pos + t.sub[0].header, t.sub[0].stream.pos + t.sub[0].header + t.sub[0].length),
									critical: null === (r = t.sub[1]) || void 0 === r ? void 0 : r.stream.parseInteger(t.sub[1].stream.pos + t.sub[1].header, t.sub[1].stream.pos + t.sub[1].header + t.sub[1].length),
									extnValue: null === (n = t.sub[2]) || void 0 === n ? void 0 : n.stream.parseOctetString(t.sub[2].stream.pos + t.sub[2].header, t.sub[2].stream.pos + t.sub[2].header + t.sub[2].length)
								})
							})), r = {
								realVersion: 4,
								toSignDer: null === (Ae = n.sub[0]) || void 0 === Ae ? void 0 : Ae.stream.enc.subarray(n.sub[0].stream.pos, n.sub[0].stream.pos + n.sub[0].header + n.sub[0].length),
								toSign: {
									version: null === (Ie = n.sub[0]) || void 0 === Ie || null === (Ee = Ie.sub[0]) || void 0 === Ee ? void 0 : Ee.stream.parseInteger(n.sub[0].sub[0].stream.pos + n.sub[0].sub[0].header, n.sub[0].sub[0].stream.pos + n.sub[0].sub[0].header + n.sub[0].sub[0].length),
									eseal: {
										esealInfo: {
											header: {
												ID: null === (Te = n.sub[0]) || void 0 === Te || null === (xe = Te.sub[1]) || void 0 === xe || null === (Pe = xe.sub[0]) || void 0 === Pe || null === (ke = Pe.sub[0]) || void 0 === ke || null === (De = ke.sub[0]) || void 0 === De ? void 0 : De.stream.parseStringUTF(n.sub[0].sub[1].sub[0].sub[0].sub[0].stream.pos + n.sub[0].sub[1].sub[0].sub[0].sub[0].header, n.sub[0].sub[1].sub[0].sub[0].sub[0].stream.pos + n.sub[0].sub[1].sub[0].sub[0].sub[0].header + n.sub[0].sub[1].sub[0].sub[0].sub[0].length),
												version: null === (Oe = n.sub[0]) || void 0 === Oe || null === (Re = Oe.sub[1]) || void 0 === Re || null === (Ne = Re.sub[0]) || void 0 === Ne || null === (Me = Ne.sub[0]) || void 0 === Me || null === (Be = Me.sub[1]) || void 0 === Be ? void 0 : Be.stream.parseInteger(n.sub[0].sub[1].sub[0].sub[0].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[0].sub[1].header, n.sub[0].sub[1].sub[0].sub[0].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[0].sub[1].header + n.sub[0].sub[1].sub[0].sub[0].sub[1].length),
												Vid: null === (Fe = n.sub[0]) || void 0 === Fe || null === (je = Fe.sub[1]) || void 0 === je || null === (Ke = je.sub[0]) || void 0 === Ke || null === (Le = Ke.sub[0]) || void 0 === Le || null === (Ue = Le.sub[2]) || void 0 === Ue ? void 0 : Ue.stream.parseStringUTF(n.sub[0].sub[1].sub[0].sub[0].sub[2].stream.pos + n.sub[0].sub[1].sub[0].sub[0].sub[2].header, n.sub[0].sub[1].sub[0].sub[0].sub[2].stream.pos + n.sub[0].sub[1].sub[0].sub[0].sub[2].header + n.sub[0].sub[1].sub[0].sub[0].sub[2].length)
											},
											esID: null === (Xe = n.sub[0]) || void 0 === Xe || null === (ze = Xe.sub[1]) || void 0 === ze || null === (Ge = ze.sub[0]) || void 0 === Ge || null === (qe = Ge.sub[1]) || void 0 === qe ? void 0 : qe.stream.parseStringUTF(n.sub[0].sub[1].sub[0].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[1].header, n.sub[0].sub[1].sub[0].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[1].header + n.sub[0].sub[1].sub[0].sub[1].length),
											property: {
												type: null === (We = n.sub[0]) || void 0 === We || null === (Ve = We.sub[1]) || void 0 === Ve || null === (He = Ve.sub[0]) || void 0 === He || null === (Ye = He.sub[2]) || void 0 === Ye || null === (Ze = Ye.sub[0]) || void 0 === Ze ? void 0 : Ze.stream.parseInteger(n.sub[0].sub[1].sub[0].sub[2].sub[0].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[0].header, n.sub[0].sub[1].sub[0].sub[2].sub[0].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[0].header + n.sub[0].sub[1].sub[0].sub[2].sub[0].length),
												name: null === (Qe = n.sub[0]) || void 0 === Qe || null === (Je = Qe.sub[1]) || void 0 === Je || null === ($e = Je.sub[0]) || void 0 === $e || null === (tr = $e.sub[2]) || void 0 === tr || null === (er = tr.sub[1]) || void 0 === er ? void 0 : er.stream.parseStringUTF(n.sub[0].sub[1].sub[0].sub[2].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[1].header, n.sub[0].sub[1].sub[0].sub[2].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[1].header + n.sub[0].sub[1].sub[0].sub[2].sub[1].length),
												certListType: nn,
												certList: an,
												createDate: null === (rr = n.sub[0]) || void 0 === rr || null === (nr = rr.sub[1]) || void 0 === nr || null === (ir = nr.sub[0]) || void 0 === ir || null === (or = ir.sub[2]) || void 0 === or || null === (ar = or.sub[4]) || void 0 === ar ? void 0 : ar.stream.parseTime(n.sub[0].sub[1].sub[0].sub[2].sub[4].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[4].header, n.sub[0].sub[1].sub[0].sub[2].sub[4].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[4].header + n.sub[0].sub[1].sub[0].sub[2].sub[4].length),
												validStart: null === (sr = n.sub[0]) || void 0 === sr || null === (cr = sr.sub[1]) || void 0 === cr || null === (ur = cr.sub[0]) || void 0 === ur || null === (dr = ur.sub[2]) || void 0 === dr || null === (lr = dr.sub[5]) || void 0 === lr ? void 0 : lr.stream.parseTime(n.sub[0].sub[1].sub[0].sub[2].sub[5].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[5].header, n.sub[0].sub[1].sub[0].sub[2].sub[5].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[5].header + n.sub[0].sub[1].sub[0].sub[2].sub[5].length),
												validEnd: null === (fr = n.sub[0]) || void 0 === fr || null === (hr = fr.sub[1]) || void 0 === hr || null === (pr = hr.sub[0]) || void 0 === pr || null === (mr = pr.sub[2]) || void 0 === mr || null === (br = mr.sub[6]) || void 0 === br ? void 0 : br.stream.parseTime(n.sub[0].sub[1].sub[0].sub[2].sub[6].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[6].header, n.sub[0].sub[1].sub[0].sub[2].sub[6].stream.pos + n.sub[0].sub[1].sub[0].sub[2].sub[6].header + n.sub[0].sub[1].sub[0].sub[2].sub[6].length)
											},
											picture: {
												type: null === (gr = n.sub[0]) || void 0 === gr || null === (yr = gr.sub[1]) || void 0 === yr || null === (vr = yr.sub[0]) || void 0 === vr || null === (Sr = vr.sub[3]) || void 0 === Sr || null === (wr = Sr.sub[0]) || void 0 === wr ? void 0 : wr.stream.parseStringUTF(n.sub[0].sub[1].sub[0].sub[3].sub[0].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[0].header, n.sub[0].sub[1].sub[0].sub[3].sub[0].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[0].header + n.sub[0].sub[1].sub[0].sub[3].sub[0].length),
												data: {
													hex: null === (Cr = n.sub[0]) || void 0 === Cr || null === (_r = Cr.sub[1]) || void 0 === _r || null === (Ar = _r.sub[0]) || void 0 === Ar || null === (Ir = Ar.sub[3]) || void 0 === Ir || null === (Er = Ir.sub[1]) || void 0 === Er ? void 0 : Er.stream.parseOctetString(n.sub[0].sub[1].sub[0].sub[3].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[1].header, n.sub[0].sub[1].sub[0].sub[3].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[1].header + n.sub[0].sub[1].sub[0].sub[3].sub[1].length),
													byte: null === (Tr = n.sub[0]) || void 0 === Tr || null === (xr = Tr.sub[1]) || void 0 === xr || null === (Pr = xr.sub[0]) || void 0 === Pr || null === (kr = Pr.sub[3]) || void 0 === kr || null === (Dr = kr.sub[1]) || void 0 === Dr ? void 0 : Dr.stream.enc.subarray(n.sub[0].sub[1].sub[0].sub[3].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[1].header, n.sub[0].sub[1].sub[0].sub[3].sub[1].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[1].header + n.sub[0].sub[1].sub[0].sub[3].sub[1].length)
												},
												width: null === (Or = n.sub[0]) || void 0 === Or || null === (Rr = Or.sub[1]) || void 0 === Rr || null === (Nr = Rr.sub[0]) || void 0 === Nr || null === (Mr = Nr.sub[3]) || void 0 === Mr || null === (Br = Mr.sub[2]) || void 0 === Br ? void 0 : Br.stream.parseInteger(n.sub[0].sub[1].sub[0].sub[3].sub[2].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[2].header, n.sub[0].sub[1].sub[0].sub[3].sub[2].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[2].header + n.sub[0].sub[1].sub[0].sub[3].sub[2].length),
												height: null === (Fr = n.sub[0]) || void 0 === Fr || null === (jr = Fr.sub[1]) || void 0 === jr || null === (Kr = jr.sub[0]) || void 0 === Kr || null === (Lr = Kr.sub[3]) || void 0 === Lr || null === (Ur = Lr.sub[3]) || void 0 === Ur ? void 0 : Ur.stream.parseInteger(n.sub[0].sub[1].sub[0].sub[3].sub[3].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[3].header, n.sub[0].sub[1].sub[0].sub[3].sub[3].stream.pos + n.sub[0].sub[1].sub[0].sub[3].sub[3].header + n.sub[0].sub[1].sub[0].sub[3].sub[3].length)
											},
											extDatas: cn
										},
										cert: v(null === (Xr = n.sub[0]) || void 0 === Xr || null === (zr = Xr.sub[1]) || void 0 === zr ? void 0 : zr.sub[1]),
										signAlgID: null === (Gr = n.sub[0]) || void 0 === Gr || null === (qr = Gr.sub[1]) || void 0 === qr || null === (Wr = qr.sub[2]) || void 0 === Wr ? void 0 : Wr.stream.parseOID(n.sub[0].sub[1].sub[2].stream.pos + n.sub[0].sub[1].sub[2].header, n.sub[0].sub[1].sub[2].stream.pos + n.sub[0].sub[1].sub[2].header + n.sub[0].sub[1].sub[2].length),
										signedValue: null === (Vr = n.sub[0]) || void 0 === Vr || null === (Hr = Vr.sub[1]) || void 0 === Hr || null === (Yr = Hr.sub[3]) || void 0 === Yr ? void 0 : Yr.stream.hexDump(n.sub[0].sub[1].sub[3].stream.pos + n.sub[0].sub[1].sub[3].header, n.sub[0].sub[1].sub[3].stream.pos + n.sub[0].sub[1].sub[3].header + n.sub[0].sub[1].sub[3].length, !1)
									},
									timeInfo: null === (Zr = n.sub[0]) || void 0 === Zr || null === (Qr = Zr.sub[2]) || void 0 === Qr ? void 0 : Qr.stream.parseTime(n.sub[0].sub[2].stream.pos + n.sub[0].sub[2].header, n.sub[0].sub[2].stream.pos + n.sub[0].sub[2].header + n.sub[0].sub[2].length, !1),
									dataHash: null === (Jr = n.sub[0]) || void 0 === Jr || null === ($r = Jr.sub[3]) || void 0 === $r ? void 0 : $r.stream.hexDump(n.sub[0].sub[3].stream.pos + n.sub[0].sub[3].header, n.sub[0].sub[3].stream.pos + n.sub[0].sub[3].header + n.sub[0].sub[3].length, !1),
									propertyInfo: S(n.sub[0].sub[4])
								},
								cert: v(n.sub[1]),
								signatureAlgID: null === (tn = n.sub[2]) || void 0 === tn ? void 0 : tn.stream.parseOID(n.sub[2].stream.pos + n.sub[2].header, n.sub[2].stream.pos + n.sub[2].header + n.sub[2].length),
								signature: null === (en = n.sub[3]) || void 0 === en ? void 0 : en.stream.hexDump(n.sub[3].stream.pos + n.sub[3].header, n.sub[3].stream.pos + n.sub[3].header + n.sub[3].length, !1),
								timpStamp: null === (rn = n.sub[4]) || void 0 === rn ? void 0 : rn.stream.parseTime(n.sub[4].stream.pos + n.sub[4].header, n.sub[4].stream.pos + n.sub[4].header + n.sub[4].length)
							}
						} catch (fn) {
							try {
								if (4 === n.sub.length && 4 === n.sub[0].sub.length) {
									var un = n.sub[0].sub[3];
									r = {
										realVersion: 4,
										toSign: {
											eseal: {
												esealInfo: {
													picture: {
														type: C(un.sub[0]),
														data: {
															hex: _(un.sub[1]),
															byte: A(un.sub[1])
														},
														width: w(un.sub[2]),
														height: w(un.sub[3])
													}
												}
											}
										}
									}
								} else if (4 === n.sub.length && 5 === n.sub[0].sub.length) {
									var dn = n.sub[0].sub[3];
									r = {
										realVersion: 4,
										toSign: {
											eseal: {
												esealInfo: {
													picture: {
														type: C(dn.sub[0]),
														data: {
															hex: _(dn.sub[1]),
															byte: A(dn.sub[1])
														},
														width: w(dn.sub[2]),
														height: w(dn.sub[3])
													}
												}
											}
										}
									}
								} else if (2 === n.sub.length && n.sub[0].sub.length >= 4) {
									var ln = n.sub[0].sub[3];
									r = {
										realVersion: 4,
										toSign: {
											eseal: {
												esealInfo: {
													picture: {
														type: C(ln.sub[0]),
														data: {
															hex: _(ln.sub[1]),
															byte: A(ln.sub[1])
														},
														width: w(ln.sub[2]),
														height: w(ln.sub[3])
													}
												}
											}
										}
									}
								} else r = {}
							} catch (fn) {
								console.log(fn), r = {}
							}
						}
					}
					return r
				},
				v = function(t, e) {
					e = e || 0;
					try {
						var r, n, i = t.sub[0].sub[0].sub[5],
							o = new Map;
						i.sub.forEach((function(t) {
							var e, r = t.sub[0].sub[0].content()
								.split("\n")[0],
								n = null === (e = t.sub[0].sub[1]) || void 0 === e ? void 0 : e.stream.parseStringUTF(t.sub[0].sub[1].stream.pos + t.sub[0].sub[1].header, t.sub[0].sub[1].stream.pos + t.sub[0].sub[1].header + t.sub[0].sub[1].length);
							o.set(r, n)
						}));
						var a = t.sub[0].sub[0].sub[6];
						return {
							subject: o,
							commonName: o.get("2.5.4.3"),
							subjectPublicKeyInfo: {
								algorithm: null === (r = a.sub[0]) || void 0 === r ? void 0 : r.stream.parseOID(a.sub[0].stream.pos + a.sub[0].header, a.sub[0].stream.pos + a.sub[0].header + a.sub[0].length),
								subjectPublicKey: null === (n = a.sub[1]) || void 0 === n ? void 0 : n.stream.hexDump(a.sub[1].stream.pos + a.sub[1].header, a.sub[1].stream.pos + a.sub[1].header + a.sub[1].length)
							}
						}
					} catch (s) {
						return console.log(s), {}
					}
				},
				S = function(t) {
					for (var e = "", r = 0; r < t.length; r++) e += String.fromCharCode(t[r]);
					return e
				},
				w = function(t) {
					return t.stream.parseInteger(t.stream.pos + t.header, t.stream.pos + t.header + t.length)
				},
				C = function(t) {
					return t.stream.parseStringUTF(t.stream.pos + t.header, t.stream.pos + t.header + t.length)
				},
				_ = function(t) {
					return t.stream.parseOctetString(t.stream.pos + t.header, t.stream.pos + t.header + t.length)
				},
				A = function(t) {
					return t.stream.enc.subarray(t.stream.pos + t.header, t.stream.pos + t.header + t.length)
				}
		},
		ab13: function(t, e, r) {
			var n = r("b622"),
				i = n("match");
			t.exports = function(t) {
				var e = /./;
				try {
					"/./" [t](e)
				} catch (r) {
					try {
						return e[i] = !1, "/./" [t](e)
					} catch (n) {}
				}
				return !1
			}
		},
		ab36: function(t, e, r) {
			var n = r("861d"),
				i = r("9112");
			t.exports = function(t, e) {
				n(e) && "cause" in e && i(t, "cause", e.cause)
			}
		},
		acac: function(t, e, r) {
			"use strict";
			var n = r("e330"),
				i = r("6964"),
				o = r("f183")
				.getWeakData,
				a = r("825a"),
				s = r("861d"),
				c = r("19aa"),
				u = r("2266"),
				d = r("b727"),
				l = r("1a2d"),
				f = r("69f3"),
				h = f.set,
				p = f.getterFor,
				m = d.find,
				b = d.findIndex,
				g = n([].splice),
				y = 0,
				v = function(t) {
					return t.frozen || (t.frozen = new S)
				},
				S = function() {
					this.entries = []
				},
				w = function(t, e) {
					return m(t.entries, (function(t) {
						return t[0] === e
					}))
				};
			S.prototype = {
				get: function(t) {
					var e = w(this, t);
					if (e) return e[1]
				},
				has: function(t) {
					return !!w(this, t)
				},
				set: function(t, e) {
					var r = w(this, t);
					r ? r[1] = e : this.entries.push([t, e])
				},
				delete: function(t) {
					var e = b(this.entries, (function(e) {
						return e[0] === t
					}));
					return ~e && g(this.entries, e, 1), !!~e
				}
			}, t.exports = {
				getConstructor: function(t, e, r, n) {
					var d = t((function(t, i) {
							c(t, f), h(t, {
								type: e,
								id: y++,
								frozen: void 0
							}), void 0 != i && u(i, t[n], {
								that: t,
								AS_ENTRIES: r
							})
						})),
						f = d.prototype,
						m = p(e),
						b = function(t, e, r) {
							var n = m(t),
								i = o(a(e), !0);
							return !0 === i ? v(n)
								.set(e, r) : i[n.id] = r, t
						};
					return i(f, {
						delete: function(t) {
							var e = m(this);
							if (!s(t)) return !1;
							var r = o(t);
							return !0 === r ? v(e)["delete"](t) : r && l(r, e.id) && delete r[e.id]
						},
						has: function(t) {
							var e = m(this);
							if (!s(t)) return !1;
							var r = o(t);
							return !0 === r ? v(e)
								.has(t) : r && l(r, e.id)
						}
					}), i(f, r ? {
						get: function(t) {
							var e = m(this);
							if (s(t)) {
								var r = o(t);
								return !0 === r ? v(e)
									.get(t) : r ? r[e.id] : void 0
							}
						},
						set: function(t, e) {
							return b(this, t, e)
						}
					} : {
						add: function(t) {
							return b(this, t, !0)
						}
					}), d
				}
			}
		},
		ad63: function(t, e, r) {
			r("e260"), r("d3b7"), r("10d1");
			var n = r("428f");
			t.exports = n.WeakMap
		},
		adc3: function(t, e, r) {
			"use strict";
			const n = r("90da"),
				i = {
					allowBooleanAttributes: !1
				},
				o = ["allowBooleanAttributes"];

			function a(t, e) {
				for (var r = e; e < t.length; e++)
					if ("?" != t[e] && " " != t[e]);
					else {
						var n = t.substr(r, e - r);
						if (e > 5 && "xml" === n) return m("InvalidXml", "XML declaration allowed only at the start of the document.", y(t, e));
						if ("?" == t[e] && ">" == t[e + 1]) {
							e++;
							break
						}
					} return e
			}

			function s(t, e) {
				if (t.length > e + 5 && "-" === t[e + 1] && "-" === t[e + 2]) {
					for (e += 3; e < t.length; e++)
						if ("-" === t[e] && "-" === t[e + 1] && ">" === t[e + 2]) {
							e += 2;
							break
						}
				} else if (t.length > e + 8 && "D" === t[e + 1] && "O" === t[e + 2] && "C" === t[e + 3] && "T" === t[e + 4] && "Y" === t[e + 5] && "P" === t[e + 6] && "E" === t[e + 7]) {
					let r = 1;
					for (e += 8; e < t.length; e++)
						if ("<" === t[e]) r++;
						else if (">" === t[e] && (r--, 0 === r)) break
				} else if (t.length > e + 9 && "[" === t[e + 1] && "C" === t[e + 2] && "D" === t[e + 3] && "A" === t[e + 4] && "T" === t[e + 5] && "A" === t[e + 6] && "[" === t[e + 7])
					for (e += 8; e < t.length; e++)
						if ("]" === t[e] && "]" === t[e + 1] && ">" === t[e + 2]) {
							e += 2;
							break
						} return e
			}
			e.validate = function(t, e) {
				e = n.buildOptions(e, i, o);
				const r = [];
				let c = !1,
					u = !1;
				"\ufeff" === t[0] && (t = t.substr(1));
				for (let n = 0; n < t.length; n++) {
					if ("<" !== t[n]) {
						if (" " === t[n] || "\t" === t[n] || "\n" === t[n] || "\r" === t[n]) continue;
						return m("InvalidChar", "char '" + t[n] + "' is not expected.", y(t, n))
					}
					if (n++, "?" === t[n]) {
						if (n = a(t, ++n), n.err) return n
					} else {
						if ("!" === t[n]) {
							n = s(t, n);
							continue
						} {
							let i = !1;
							"/" === t[n] && (i = !0, n++);
							let o = "";
							for (; n < t.length && ">" !== t[n] && " " !== t[n] && "\t" !== t[n] && "\n" !== t[n] && "\r" !== t[n]; n++) o += t[n];
							if (o = o.trim(), "/" === o[o.length - 1] && (o = o.substring(0, o.length - 1), n--), !g(o)) {
								let e;
								return e = 0 === o.trim()
									.length ? "There is an unnecessary space between tag name and backward slash '</ ..'." : "Tag '" + o + "' is an invalid name.", m("InvalidTag", e, y(t, n))
							}
							const a = d(t, n);
							if (!1 === a) return m("InvalidAttr", "Attributes for '" + o + "' have open quote.", y(t, n));
							let l = a.value;
							if (n = a.index, "/" === l[l.length - 1]) {
								l = l.substring(0, l.length - 1);
								const r = f(l, e);
								if (!0 !== r) return m(r.err.code, r.err.msg, y(t, n - l.length + r.err.line));
								c = !0
							} else if (i) {
								if (!a.tagClosed) return m("InvalidTag", "Closing tag '" + o + "' doesn't have proper closing.", y(t, n));
								if (l.trim()
									.length > 0) return m("InvalidTag", "Closing tag '" + o + "' can't have attributes or invalid starting.", y(t, n)); {
									const e = r.pop();
									if (o !== e) return m("InvalidTag", "Closing tag '" + e + "' is expected inplace of '" + o + "'.", y(t, n));
									0 == r.length && (u = !0)
								}
							} else {
								const i = f(l, e);
								if (!0 !== i) return m(i.err.code, i.err.msg, y(t, n - l.length + i.err.line));
								if (!0 === u) return m("InvalidXml", "Multiple possible root nodes found.", y(t, n));
								r.push(o), c = !0
							}
							for (n++; n < t.length; n++) {
								if ("<" === t[n]) {
									if ("!" === t[n + 1]) {
										n++, n = s(t, n);
										continue
									}
									break
								}
								if ("&" === t[n]) {
									const e = p(t, n);
									if (-1 == e) return m("InvalidChar", "char '&' is not expected.", y(t, n));
									n = e
								}
							}
							"<" === t[n] && n--
						}
					}
				}
				return c ? !(r.length > 0) || m("InvalidXml", "Invalid '" + JSON.stringify(r, null, 4)
					.replace(/\r?\n/g, "") + "' found.", 1) : m("InvalidXml", "Start tag expected.", 1)
			};
			var c = '"',
				u = "'";

			function d(t, e) {
				let r = "",
					n = "",
					i = !1;
				for (; e < t.length; e++) {
					if (t[e] === c || t[e] === u)
						if ("" === n) n = t[e];
						else {
							if (n !== t[e]) continue;
							n = ""
						}
					else if (">" === t[e] && "" === n) {
						i = !0;
						break
					}
					r += t[e]
				}
				return "" === n && {
					value: r,
					index: e,
					tagClosed: i
				}
			}
			const l = new RegExp("(\\s*)([^\\s=]+)(\\s*=)?(\\s*(['\"])(([\\s\\S])*?)\\5)?", "g");

			function f(t, e) {
				const r = n.getAllMatches(t, l),
					i = {};
				for (let n = 0; n < r.length; n++) {
					if (0 === r[n][1].length) return m("InvalidAttr", "Attribute '" + r[n][2] + "' has no space in starting.", v(t, r[n][0]));
					if (void 0 === r[n][3] && !e.allowBooleanAttributes) return m("InvalidAttr", "boolean attribute '" + r[n][2] + "' is not allowed.", v(t, r[n][0]));
					const o = r[n][2];
					if (!b(o)) return m("InvalidAttr", "Attribute '" + o + "' is an invalid name.", v(t, r[n][0]));
					if (i.hasOwnProperty(o)) return m("InvalidAttr", "Attribute '" + o + "' is repeated.", v(t, r[n][0]));
					i[o] = 1
				}
				return !0
			}

			function h(t, e) {
				let r = /\d/;
				for ("x" === t[e] && (e++, r = /[\da-fA-F]/); e < t.length; e++) {
					if (";" === t[e]) return e;
					if (!t[e].match(r)) break
				}
				return -1
			}

			function p(t, e) {
				if (e++, ";" === t[e]) return -1;
				if ("#" === t[e]) return e++, h(t, e);
				let r = 0;
				for (; e < t.length; e++, r++)
					if (!(t[e].match(/\w/) && r < 20)) {
						if (";" === t[e]) break;
						return -1
					} return e
			}

			function m(t, e, r) {
				return {
					err: {
						code: t,
						msg: e,
						line: r
					}
				}
			}

			function b(t) {
				return n.isName(t)
			}

			function g(t) {
				return n.isName(t)
			}

			function y(t, e) {
				var r = t.substring(0, e)
					.split(/\r?\n/);
				return r.length
			}

			function v(t, e) {
				return t.indexOf(e) + e.length
			}
		},
		addb: function(t, e, r) {
			var n = r("4dae"),
				i = Math.floor,
				o = function(t, e) {
					var r = t.length,
						c = i(r / 2);
					return r < 8 ? a(t, e) : s(t, o(n(t, 0, c), e), o(n(t, c), e), e)
				},
				a = function(t, e) {
					var r, n, i = t.length,
						o = 1;
					while (o < i) {
						n = o, r = t[o];
						while (n && e(t[n - 1], r) > 0) t[n] = t[--n];
						n !== o++ && (t[n] = r)
					}
					return t
				},
				s = function(t, e, r, n) {
					var i = e.length,
						o = r.length,
						a = 0,
						s = 0;
					while (a < i || s < o) t[a + s] = a < i && s < o ? n(e[a], r[s]) <= 0 ? e[a++] : r[s++] : a < i ? e[a++] : r[s++];
					return t
				};
			t.exports = o
		},
		ae93: function(t, e, r) {
			"use strict";
			var n, i, o, a = r("d039"),
				s = r("1626"),
				c = r("7c73"),
				u = r("e163"),
				d = r("cb2d"),
				l = r("b622"),
				f = r("c430"),
				h = l("iterator"),
				p = !1;
			[].keys && (o = [].keys(), "next" in o ? (i = u(u(o)), i !== Object.prototype && (n = i)) : p = !0);
			var m = void 0 == n || a((function() {
				var t = {};
				return n[h].call(t) !== t
			}));
			m ? n = {} : f && (n = c(n)), s(n[h]) || d(n, h, (function() {
				return this
			})), t.exports = {
				IteratorPrototype: n,
				BUGGY_SAFARI_ITERATORS: p
			}
		},
		aed9: function(t, e, r) {
			var n = r("83ab"),
				i = r("d039");
			t.exports = n && i((function() {
				return 42 != Object.defineProperty((function() {}), "prototype", {
						value: 42,
						writable: !1
					})
					.prototype
			}))
		},
		b041: function(t, e, r) {
			"use strict";
			var n = r("00ee"),
				i = r("f5df");
			t.exports = n ? {}.toString : function() {
				return "[object " + i(this) + "]"
			}
		},
		b109: function(t, e, r) {
			var n = r("da84"),
				i = r("e330");
			t.exports = function(t, e) {
				return i(n[t].prototype[e])
			}
		},
		b4f8: function(t, e, r) {
			var n = r("23e7"),
				i = r("d066"),
				o = r("1a2d"),
				a = r("577e"),
				s = r("5692"),
				c = r("3d87"),
				u = s("string-to-symbol-registry"),
				d = s("symbol-to-string-registry");
			n({
				target: "Symbol",
				stat: !0,
				forced: !c
			}, {
				for: function(t) {
					var e = a(t);
					if (o(u, e)) return u[e];
					var r = i("Symbol")(e);
					return u[e] = r, d[r] = e, r
				}
			})
		},
		b50d: function(t, e, r) {
			"use strict";
			var n = r("c532"),
				i = r("467f"),
				o = r("7aac"),
				a = r("30b5"),
				s = r("83b9"),
				c = r("c345"),
				u = r("3934"),
				d = r("2d83");
			t.exports = function(t) {
				return new Promise((function(e, r) {
					var l = t.data,
						f = t.headers;
					n.isFormData(l) && delete f["Content-Type"], (n.isBlob(l) || n.isFile(l)) && l.type && delete f["Content-Type"];
					var h = new XMLHttpRequest;
					if (t.auth) {
						var p = t.auth.username || "",
							m = unescape(encodeURIComponent(t.auth.password)) || "";
						f.Authorization = "Basic " + btoa(p + ":" + m)
					}
					var b = s(t.baseURL, t.url);
					if (h.open(t.method.toUpperCase(), a(b, t.params, t.paramsSerializer), !0), h.timeout = t.timeout, h.onreadystatechange = function() {
						if (h && 4 === h.readyState && (0 !== h.status || h.responseURL && 0 === h.responseURL.indexOf("file:"))) {
							var n = "getAllResponseHeaders" in h ? c(h.getAllResponseHeaders()) : null,
								o = t.responseType && "text" !== t.responseType ? h.response : h.responseText,
								a = {
									data: o,
									status: h.status,
									statusText: h.statusText,
									headers: n,
									config: t,
									request: h
								};
							i(e, r, a), h = null
						}
					}, h.onabort = function() {
						h && (r(d("Request aborted", t, "ECONNABORTED", h)), h = null)
					}, h.onerror = function() {
						r(d("Network Error", t, null, h)), h = null
					}, h.ontimeout = function() {
						var e = "timeout of " + t.timeout + "ms exceeded";
						t.timeoutErrorMessage && (e = t.timeoutErrorMessage), r(d(e, t, "ECONNABORTED", h)), h = null
					}, n.isStandardBrowserEnv()) {
						var g = (t.withCredentials || u(b)) && t.xsrfCookieName ? o.read(t.xsrfCookieName) : void 0;
						g && (f[t.xsrfHeaderName] = g)
					}
					if ("setRequestHeader" in h && n.forEach(f, (function(t, e) {
						"undefined" === typeof l && "content-type" === e.toLowerCase() ? delete f[e] : h.setRequestHeader(e, t)
					})), n.isUndefined(t.withCredentials) || (h.withCredentials = !!t.withCredentials), t.responseType) try {
						h.responseType = t.responseType
					} catch (y) {
						if ("json" !== t.responseType) throw y
					}
					"function" === typeof t.onDownloadProgress && h.addEventListener("progress", t.onDownloadProgress), "function" === typeof t.onUploadProgress && h.upload && h.upload.addEventListener("progress", t.onUploadProgress), t.cancelToken && t.cancelToken.promise.then((function(t) {
						h && (h.abort(), r(t), h = null)
					})), l || (l = null), h.send(l)
				}))
			}
		},
		b575: function(t, e, r) {
			var n, i, o, a, s, c, u, d, l = r("da84"),
				f = r("0366"),
				h = r("06cf")
				.f,
				p = r("2cf4")
				.set,
				m = r("1cdc"),
				b = r("d4c3"),
				g = r("a4b4"),
				y = r("605d"),
				v = l.MutationObserver || l.WebKitMutationObserver,
				S = l.document,
				w = l.process,
				C = l.Promise,
				_ = h(l, "queueMicrotask"),
				A = _ && _.value;
			A || (n = function() {
				var t, e;
				y && (t = w.domain) && t.exit();
				while (i) {
					e = i.fn, i = i.next;
					try {
						e()
					} catch (r) {
						throw i ? a() : o = void 0, r
					}
				}
				o = void 0, t && t.enter()
			}, m || y || g || !v || !S ? !b && C && C.resolve ? (u = C.resolve(void 0), u.constructor = C, d = f(u.then, u), a = function() {
				d(n)
			}) : y ? a = function() {
				w.nextTick(n)
			} : (p = f(p, l), a = function() {
				p(n)
			}) : (s = !0, c = S.createTextNode(""), new v(n)
				.observe(c, {
					characterData: !0
				}), a = function() {
					c.data = s = !s
				})), t.exports = A || function(t) {
				var e = {
					fn: t,
					next: void 0
				};
				o && (o.next = e), i || (i = e, a()), o = e
			}
		},
		b622: function(t, e, r) {
			var n = r("da84"),
				i = r("5692"),
				o = r("1a2d"),
				a = r("90e3"),
				s = r("4930"),
				c = r("fdbf"),
				u = i("wks"),
				d = n.Symbol,
				l = d && d["for"],
				f = c ? d : d && d.withoutSetter || a;
			t.exports = function(t) {
				if (!o(u, t) || !s && "string" != typeof u[t]) {
					var e = "Symbol." + t;
					s && o(d, t) ? u[t] = d[t] : u[t] = c && l ? l(e) : f(e)
				}
				return u[t]
			}
		},
		b636: function(t, e, r) {
			var n = r("746f");
			n("asyncIterator")
		},
		b639: function(t, e, r) {
			"use strict";
			(function(t) {
				/*!
				 * The buffer module from node.js, for the browser.
				 *
				 * @author   Feross Aboukhadijeh <http://feross.org>
				 * @license  MIT
				 */
				var n = r("1fb5"),
					i = r("9152"),
					o = r("e3db");

				function a() {
					try {
						var t = new Uint8Array(1);
						return t.__proto__ = {
								__proto__: Uint8Array.prototype,
								foo: function() {
									return 42
								}
							}, 42 === t.foo() && "function" === typeof t.subarray && 0 === t.subarray(1, 1)
							.byteLength
					} catch (e) {
						return !1
					}
				}

				function s() {
					return u.TYPED_ARRAY_SUPPORT ? 2147483647 : 1073741823
				}

				function c(t, e) {
					if (s() < e) throw new RangeError("Invalid typed array length");
					return u.TYPED_ARRAY_SUPPORT ? (t = new Uint8Array(e), t.__proto__ = u.prototype) : (null === t && (t = new u(e)), t.length = e), t
				}

				function u(t, e, r) {
					if (!u.TYPED_ARRAY_SUPPORT && !(this instanceof u)) return new u(t, e, r);
					if ("number" === typeof t) {
						if ("string" === typeof e) throw new Error("If encoding is specified then the first argument must be a string");
						return h(this, t)
					}
					return d(this, t, e, r)
				}

				function d(t, e, r, n) {
					if ("number" === typeof e) throw new TypeError('"value" argument must not be a number');
					return "undefined" !== typeof ArrayBuffer && e instanceof ArrayBuffer ? b(t, e, r, n) : "string" === typeof e ? p(t, e, r) : g(t, e)
				}

				function l(t) {
					if ("number" !== typeof t) throw new TypeError('"size" argument must be a number');
					if (t < 0) throw new RangeError('"size" argument must not be negative')
				}

				function f(t, e, r, n) {
					return l(e), e <= 0 ? c(t, e) : void 0 !== r ? "string" === typeof n ? c(t, e)
						.fill(r, n) : c(t, e)
						.fill(r) : c(t, e)
				}

				function h(t, e) {
					if (l(e), t = c(t, e < 0 ? 0 : 0 | y(e)), !u.TYPED_ARRAY_SUPPORT)
						for (var r = 0; r < e; ++r) t[r] = 0;
					return t
				}

				function p(t, e, r) {
					if ("string" === typeof r && "" !== r || (r = "utf8"), !u.isEncoding(r)) throw new TypeError('"encoding" must be a valid string encoding');
					var n = 0 | S(e, r);
					t = c(t, n);
					var i = t.write(e, r);
					return i !== n && (t = t.slice(0, i)), t
				}

				function m(t, e) {
					var r = e.length < 0 ? 0 : 0 | y(e.length);
					t = c(t, r);
					for (var n = 0; n < r; n += 1) t[n] = 255 & e[n];
					return t
				}

				function b(t, e, r, n) {
					if (e.byteLength, r < 0 || e.byteLength < r) throw new RangeError("'offset' is out of bounds");
					if (e.byteLength < r + (n || 0)) throw new RangeError("'length' is out of bounds");
					return e = void 0 === r && void 0 === n ? new Uint8Array(e) : void 0 === n ? new Uint8Array(e, r) : new Uint8Array(e, r, n), u.TYPED_ARRAY_SUPPORT ? (t = e, t.__proto__ = u.prototype) : t = m(t, e), t
				}

				function g(t, e) {
					if (u.isBuffer(e)) {
						var r = 0 | y(e.length);
						return t = c(t, r), 0 === t.length ? t : (e.copy(t, 0, 0, r), t)
					}
					if (e) {
						if ("undefined" !== typeof ArrayBuffer && e.buffer instanceof ArrayBuffer || "length" in e) return "number" !== typeof e.length || et(e.length) ? c(t, 0) : m(t, e);
						if ("Buffer" === e.type && o(e.data)) return m(t, e.data)
					}
					throw new TypeError("First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.")
				}

				function y(t) {
					if (t >= s()) throw new RangeError("Attempt to allocate Buffer larger than maximum size: 0x" + s()
						.toString(16) + " bytes");
					return 0 | t
				}

				function v(t) {
					return +t != t && (t = 0), u.alloc(+t)
				}

				function S(t, e) {
					if (u.isBuffer(t)) return t.length;
					if ("undefined" !== typeof ArrayBuffer && "function" === typeof ArrayBuffer.isView && (ArrayBuffer.isView(t) || t instanceof ArrayBuffer)) return t.byteLength;
					"string" !== typeof t && (t = "" + t);
					var r = t.length;
					if (0 === r) return 0;
					for (var n = !1;;) switch (e) {
						case "ascii":
						case "latin1":
						case "binary":
							return r;
						case "utf8":
						case "utf-8":
						case void 0:
							return Z(t)
								.length;
						case "ucs2":
						case "ucs-2":
						case "utf16le":
						case "utf-16le":
							return 2 * r;
						case "hex":
							return r >>> 1;
						case "base64":
							return $(t)
								.length;
						default:
							if (n) return Z(t)
								.length;
							e = ("" + e)
								.toLowerCase(), n = !0
					}
				}

				function w(t, e, r) {
					var n = !1;
					if ((void 0 === e || e < 0) && (e = 0), e > this.length) return "";
					if ((void 0 === r || r > this.length) && (r = this.length), r <= 0) return "";
					if (r >>>= 0, e >>>= 0, r <= e) return "";
					t || (t = "utf8");
					while (1) switch (t) {
						case "hex":
							return F(this, e, r);
						case "utf8":
						case "utf-8":
							return O(this, e, r);
						case "ascii":
							return M(this, e, r);
						case "latin1":
						case "binary":
							return B(this, e, r);
						case "base64":
							return D(this, e, r);
						case "ucs2":
						case "ucs-2":
						case "utf16le":
						case "utf-16le":
							return j(this, e, r);
						default:
							if (n) throw new TypeError("Unknown encoding: " + t);
							t = (t + "")
								.toLowerCase(), n = !0
					}
				}

				function C(t, e, r) {
					var n = t[e];
					t[e] = t[r], t[r] = n
				}

				function _(t, e, r, n, i) {
					if (0 === t.length) return -1;
					if ("string" === typeof r ? (n = r, r = 0) : r > 2147483647 ? r = 2147483647 : r < -2147483648 && (r = -2147483648), r = +r, isNaN(r) && (r = i ? 0 : t.length - 1), r < 0 && (r = t.length + r), r >= t.length) {
						if (i) return -1;
						r = t.length - 1
					} else if (r < 0) {
						if (!i) return -1;
						r = 0
					}
					if ("string" === typeof e && (e = u.from(e, n)), u.isBuffer(e)) return 0 === e.length ? -1 : A(t, e, r, n, i);
					if ("number" === typeof e) return e &= 255, u.TYPED_ARRAY_SUPPORT && "function" === typeof Uint8Array.prototype.indexOf ? i ? Uint8Array.prototype.indexOf.call(t, e, r) : Uint8Array.prototype.lastIndexOf.call(t, e, r) : A(t, [e], r, n, i);
					throw new TypeError("val must be string, number or Buffer")
				}

				function A(t, e, r, n, i) {
					var o, a = 1,
						s = t.length,
						c = e.length;
					if (void 0 !== n && (n = String(n)
						.toLowerCase(), "ucs2" === n || "ucs-2" === n || "utf16le" === n || "utf-16le" === n)) {
						if (t.length < 2 || e.length < 2) return -1;
						a = 2, s /= 2, c /= 2, r /= 2
					}

					function u(t, e) {
						return 1 === a ? t[e] : t.readUInt16BE(e * a)
					}
					if (i) {
						var d = -1;
						for (o = r; o < s; o++)
							if (u(t, o) === u(e, -1 === d ? 0 : o - d)) {
								if (-1 === d && (d = o), o - d + 1 === c) return d * a
							} else -1 !== d && (o -= o - d), d = -1
					} else
						for (r + c > s && (r = s - c), o = r; o >= 0; o--) {
							for (var l = !0, f = 0; f < c; f++)
								if (u(t, o + f) !== u(e, f)) {
									l = !1;
									break
								} if (l) return o
						}
					return -1
				}

				function I(t, e, r, n) {
					r = Number(r) || 0;
					var i = t.length - r;
					n ? (n = Number(n), n > i && (n = i)) : n = i;
					var o = e.length;
					if (o % 2 !== 0) throw new TypeError("Invalid hex string");
					n > o / 2 && (n = o / 2);
					for (var a = 0; a < n; ++a) {
						var s = parseInt(e.substr(2 * a, 2), 16);
						if (isNaN(s)) return a;
						t[r + a] = s
					}
					return a
				}

				function E(t, e, r, n) {
					return tt(Z(e, t.length - r), t, r, n)
				}

				function T(t, e, r, n) {
					return tt(Q(e), t, r, n)
				}

				function x(t, e, r, n) {
					return T(t, e, r, n)
				}

				function P(t, e, r, n) {
					return tt($(e), t, r, n)
				}

				function k(t, e, r, n) {
					return tt(J(e, t.length - r), t, r, n)
				}

				function D(t, e, r) {
					return 0 === e && r === t.length ? n.fromByteArray(t) : n.fromByteArray(t.slice(e, r))
				}

				function O(t, e, r) {
					r = Math.min(t.length, r);
					var n = [],
						i = e;
					while (i < r) {
						var o, a, s, c, u = t[i],
							d = null,
							l = u > 239 ? 4 : u > 223 ? 3 : u > 191 ? 2 : 1;
						if (i + l <= r) switch (l) {
							case 1:
								u < 128 && (d = u);
								break;
							case 2:
								o = t[i + 1], 128 === (192 & o) && (c = (31 & u) << 6 | 63 & o, c > 127 && (d = c));
								break;
							case 3:
								o = t[i + 1], a = t[i + 2], 128 === (192 & o) && 128 === (192 & a) && (c = (15 & u) << 12 | (63 & o) << 6 | 63 & a, c > 2047 && (c < 55296 || c > 57343) && (d = c));
								break;
							case 4:
								o = t[i + 1], a = t[i + 2], s = t[i + 3], 128 === (192 & o) && 128 === (192 & a) && 128 === (192 & s) && (c = (15 & u) << 18 | (63 & o) << 12 | (63 & a) << 6 | 63 & s, c > 65535 && c < 1114112 && (d = c))
						}
						null === d ? (d = 65533, l = 1) : d > 65535 && (d -= 65536, n.push(d >>> 10 & 1023 | 55296), d = 56320 | 1023 & d), n.push(d), i += l
					}
					return N(n)
				}
				e.Buffer = u, e.SlowBuffer = v, e.INSPECT_MAX_BYTES = 50, u.TYPED_ARRAY_SUPPORT = void 0 !== t.TYPED_ARRAY_SUPPORT ? t.TYPED_ARRAY_SUPPORT : a(), e.kMaxLength = s(), u.poolSize = 8192, u._augment = function(t) {
					return t.__proto__ = u.prototype, t
				}, u.from = function(t, e, r) {
					return d(null, t, e, r)
				}, u.TYPED_ARRAY_SUPPORT && (u.prototype.__proto__ = Uint8Array.prototype, u.__proto__ = Uint8Array, "undefined" !== typeof Symbol && Symbol.species && u[Symbol.species] === u && Object.defineProperty(u, Symbol.species, {
					value: null,
					configurable: !0
				})), u.alloc = function(t, e, r) {
					return f(null, t, e, r)
				}, u.allocUnsafe = function(t) {
					return h(null, t)
				}, u.allocUnsafeSlow = function(t) {
					return h(null, t)
				}, u.isBuffer = function(t) {
					return !(null == t || !t._isBuffer)
				}, u.compare = function(t, e) {
					if (!u.isBuffer(t) || !u.isBuffer(e)) throw new TypeError("Arguments must be Buffers");
					if (t === e) return 0;
					for (var r = t.length, n = e.length, i = 0, o = Math.min(r, n); i < o; ++i)
						if (t[i] !== e[i]) {
							r = t[i], n = e[i];
							break
						} return r < n ? -1 : n < r ? 1 : 0
				}, u.isEncoding = function(t) {
					switch (String(t)
						.toLowerCase()) {
						case "hex":
						case "utf8":
						case "utf-8":
						case "ascii":
						case "latin1":
						case "binary":
						case "base64":
						case "ucs2":
						case "ucs-2":
						case "utf16le":
						case "utf-16le":
							return !0;
						default:
							return !1
					}
				}, u.concat = function(t, e) {
					if (!o(t)) throw new TypeError('"list" argument must be an Array of Buffers');
					if (0 === t.length) return u.alloc(0);
					var r;
					if (void 0 === e)
						for (e = 0, r = 0; r < t.length; ++r) e += t[r].length;
					var n = u.allocUnsafe(e),
						i = 0;
					for (r = 0; r < t.length; ++r) {
						var a = t[r];
						if (!u.isBuffer(a)) throw new TypeError('"list" argument must be an Array of Buffers');
						a.copy(n, i), i += a.length
					}
					return n
				}, u.byteLength = S, u.prototype._isBuffer = !0, u.prototype.swap16 = function() {
					var t = this.length;
					if (t % 2 !== 0) throw new RangeError("Buffer size must be a multiple of 16-bits");
					for (var e = 0; e < t; e += 2) C(this, e, e + 1);
					return this
				}, u.prototype.swap32 = function() {
					var t = this.length;
					if (t % 4 !== 0) throw new RangeError("Buffer size must be a multiple of 32-bits");
					for (var e = 0; e < t; e += 4) C(this, e, e + 3), C(this, e + 1, e + 2);
					return this
				}, u.prototype.swap64 = function() {
					var t = this.length;
					if (t % 8 !== 0) throw new RangeError("Buffer size must be a multiple of 64-bits");
					for (var e = 0; e < t; e += 8) C(this, e, e + 7), C(this, e + 1, e + 6), C(this, e + 2, e + 5), C(this, e + 3, e + 4);
					return this
				}, u.prototype.toString = function() {
					var t = 0 | this.length;
					return 0 === t ? "" : 0 === arguments.length ? O(this, 0, t) : w.apply(this, arguments)
				}, u.prototype.equals = function(t) {
					if (!u.isBuffer(t)) throw new TypeError("Argument must be a Buffer");
					return this === t || 0 === u.compare(this, t)
				}, u.prototype.inspect = function() {
					var t = "",
						r = e.INSPECT_MAX_BYTES;
					return this.length > 0 && (t = this.toString("hex", 0, r)
						.match(/.{2}/g)
						.join(" "), this.length > r && (t += " ... ")), "<Buffer " + t + ">"
				}, u.prototype.compare = function(t, e, r, n, i) {
					if (!u.isBuffer(t)) throw new TypeError("Argument must be a Buffer");
					if (void 0 === e && (e = 0), void 0 === r && (r = t ? t.length : 0), void 0 === n && (n = 0), void 0 === i && (i = this.length), e < 0 || r > t.length || n < 0 || i > this.length) throw new RangeError("out of range index");
					if (n >= i && e >= r) return 0;
					if (n >= i) return -1;
					if (e >= r) return 1;
					if (e >>>= 0, r >>>= 0, n >>>= 0, i >>>= 0, this === t) return 0;
					for (var o = i - n, a = r - e, s = Math.min(o, a), c = this.slice(n, i), d = t.slice(e, r), l = 0; l < s; ++l)
						if (c[l] !== d[l]) {
							o = c[l], a = d[l];
							break
						} return o < a ? -1 : a < o ? 1 : 0
				}, u.prototype.includes = function(t, e, r) {
					return -1 !== this.indexOf(t, e, r)
				}, u.prototype.indexOf = function(t, e, r) {
					return _(this, t, e, r, !0)
				}, u.prototype.lastIndexOf = function(t, e, r) {
					return _(this, t, e, r, !1)
				}, u.prototype.write = function(t, e, r, n) {
					if (void 0 === e) n = "utf8", r = this.length, e = 0;
					else if (void 0 === r && "string" === typeof e) n = e, r = this.length, e = 0;
					else {
						if (!isFinite(e)) throw new Error("Buffer.write(string, encoding, offset[, length]) is no longer supported");
						e |= 0, isFinite(r) ? (r |= 0, void 0 === n && (n = "utf8")) : (n = r, r = void 0)
					}
					var i = this.length - e;
					if ((void 0 === r || r > i) && (r = i), t.length > 0 && (r < 0 || e < 0) || e > this.length) throw new RangeError("Attempt to write outside buffer bounds");
					n || (n = "utf8");
					for (var o = !1;;) switch (n) {
						case "hex":
							return I(this, t, e, r);
						case "utf8":
						case "utf-8":
							return E(this, t, e, r);
						case "ascii":
							return T(this, t, e, r);
						case "latin1":
						case "binary":
							return x(this, t, e, r);
						case "base64":
							return P(this, t, e, r);
						case "ucs2":
						case "ucs-2":
						case "utf16le":
						case "utf-16le":
							return k(this, t, e, r);
						default:
							if (o) throw new TypeError("Unknown encoding: " + n);
							n = ("" + n)
								.toLowerCase(), o = !0
					}
				}, u.prototype.toJSON = function() {
					return {
						type: "Buffer",
						data: Array.prototype.slice.call(this._arr || this, 0)
					}
				};
				var R = 4096;

				function N(t) {
					var e = t.length;
					if (e <= R) return String.fromCharCode.apply(String, t);
					var r = "",
						n = 0;
					while (n < e) r += String.fromCharCode.apply(String, t.slice(n, n += R));
					return r
				}

				function M(t, e, r) {
					var n = "";
					r = Math.min(t.length, r);
					for (var i = e; i < r; ++i) n += String.fromCharCode(127 & t[i]);
					return n
				}

				function B(t, e, r) {
					var n = "";
					r = Math.min(t.length, r);
					for (var i = e; i < r; ++i) n += String.fromCharCode(t[i]);
					return n
				}

				function F(t, e, r) {
					var n = t.length;
					(!e || e < 0) && (e = 0), (!r || r < 0 || r > n) && (r = n);
					for (var i = "", o = e; o < r; ++o) i += Y(t[o]);
					return i
				}

				function j(t, e, r) {
					for (var n = t.slice(e, r), i = "", o = 0; o < n.length; o += 2) i += String.fromCharCode(n[o] + 256 * n[o + 1]);
					return i
				}

				function K(t, e, r) {
					if (t % 1 !== 0 || t < 0) throw new RangeError("offset is not uint");
					if (t + e > r) throw new RangeError("Trying to access beyond buffer length")
				}

				function L(t, e, r, n, i, o) {
					if (!u.isBuffer(t)) throw new TypeError('"buffer" argument must be a Buffer instance');
					if (e > i || e < o) throw new RangeError('"value" argument is out of bounds');
					if (r + n > t.length) throw new RangeError("Index out of range")
				}

				function U(t, e, r, n) {
					e < 0 && (e = 65535 + e + 1);
					for (var i = 0, o = Math.min(t.length - r, 2); i < o; ++i) t[r + i] = (e & 255 << 8 * (n ? i : 1 - i)) >>> 8 * (n ? i : 1 - i)
				}

				function X(t, e, r, n) {
					e < 0 && (e = 4294967295 + e + 1);
					for (var i = 0, o = Math.min(t.length - r, 4); i < o; ++i) t[r + i] = e >>> 8 * (n ? i : 3 - i) & 255
				}

				function z(t, e, r, n, i, o) {
					if (r + n > t.length) throw new RangeError("Index out of range");
					if (r < 0) throw new RangeError("Index out of range")
				}

				function G(t, e, r, n, o) {
					return o || z(t, e, r, 4, 34028234663852886e22, -34028234663852886e22), i.write(t, e, r, n, 23, 4), r + 4
				}

				function q(t, e, r, n, o) {
					return o || z(t, e, r, 8, 17976931348623157e292, -17976931348623157e292), i.write(t, e, r, n, 52, 8), r + 8
				}
				u.prototype.slice = function(t, e) {
					var r, n = this.length;
					if (t = ~~t, e = void 0 === e ? n : ~~e, t < 0 ? (t += n, t < 0 && (t = 0)) : t > n && (t = n), e < 0 ? (e += n, e < 0 && (e = 0)) : e > n && (e = n), e < t && (e = t), u.TYPED_ARRAY_SUPPORT) r = this.subarray(t, e), r.__proto__ = u.prototype;
					else {
						var i = e - t;
						r = new u(i, void 0);
						for (var o = 0; o < i; ++o) r[o] = this[o + t]
					}
					return r
				}, u.prototype.readUIntLE = function(t, e, r) {
					t |= 0, e |= 0, r || K(t, e, this.length);
					var n = this[t],
						i = 1,
						o = 0;
					while (++o < e && (i *= 256)) n += this[t + o] * i;
					return n
				}, u.prototype.readUIntBE = function(t, e, r) {
					t |= 0, e |= 0, r || K(t, e, this.length);
					var n = this[t + --e],
						i = 1;
					while (e > 0 && (i *= 256)) n += this[t + --e] * i;
					return n
				}, u.prototype.readUInt8 = function(t, e) {
					return e || K(t, 1, this.length), this[t]
				}, u.prototype.readUInt16LE = function(t, e) {
					return e || K(t, 2, this.length), this[t] | this[t + 1] << 8
				}, u.prototype.readUInt16BE = function(t, e) {
					return e || K(t, 2, this.length), this[t] << 8 | this[t + 1]
				}, u.prototype.readUInt32LE = function(t, e) {
					return e || K(t, 4, this.length), (this[t] | this[t + 1] << 8 | this[t + 2] << 16) + 16777216 * this[t + 3]
				}, u.prototype.readUInt32BE = function(t, e) {
					return e || K(t, 4, this.length), 16777216 * this[t] + (this[t + 1] << 16 | this[t + 2] << 8 | this[t + 3])
				}, u.prototype.readIntLE = function(t, e, r) {
					t |= 0, e |= 0, r || K(t, e, this.length);
					var n = this[t],
						i = 1,
						o = 0;
					while (++o < e && (i *= 256)) n += this[t + o] * i;
					return i *= 128, n >= i && (n -= Math.pow(2, 8 * e)), n
				}, u.prototype.readIntBE = function(t, e, r) {
					t |= 0, e |= 0, r || K(t, e, this.length);
					var n = e,
						i = 1,
						o = this[t + --n];
					while (n > 0 && (i *= 256)) o += this[t + --n] * i;
					return i *= 128, o >= i && (o -= Math.pow(2, 8 * e)), o
				}, u.prototype.readInt8 = function(t, e) {
					return e || K(t, 1, this.length), 128 & this[t] ? -1 * (255 - this[t] + 1) : this[t]
				}, u.prototype.readInt16LE = function(t, e) {
					e || K(t, 2, this.length);
					var r = this[t] | this[t + 1] << 8;
					return 32768 & r ? 4294901760 | r : r
				}, u.prototype.readInt16BE = function(t, e) {
					e || K(t, 2, this.length);
					var r = this[t + 1] | this[t] << 8;
					return 32768 & r ? 4294901760 | r : r
				}, u.prototype.readInt32LE = function(t, e) {
					return e || K(t, 4, this.length), this[t] | this[t + 1] << 8 | this[t + 2] << 16 | this[t + 3] << 24
				}, u.prototype.readInt32BE = function(t, e) {
					return e || K(t, 4, this.length), this[t] << 24 | this[t + 1] << 16 | this[t + 2] << 8 | this[t + 3]
				}, u.prototype.readFloatLE = function(t, e) {
					return e || K(t, 4, this.length), i.read(this, t, !0, 23, 4)
				}, u.prototype.readFloatBE = function(t, e) {
					return e || K(t, 4, this.length), i.read(this, t, !1, 23, 4)
				}, u.prototype.readDoubleLE = function(t, e) {
					return e || K(t, 8, this.length), i.read(this, t, !0, 52, 8)
				}, u.prototype.readDoubleBE = function(t, e) {
					return e || K(t, 8, this.length), i.read(this, t, !1, 52, 8)
				}, u.prototype.writeUIntLE = function(t, e, r, n) {
					if (t = +t, e |= 0, r |= 0, !n) {
						var i = Math.pow(2, 8 * r) - 1;
						L(this, t, e, r, i, 0)
					}
					var o = 1,
						a = 0;
					this[e] = 255 & t;
					while (++a < r && (o *= 256)) this[e + a] = t / o & 255;
					return e + r
				}, u.prototype.writeUIntBE = function(t, e, r, n) {
					if (t = +t, e |= 0, r |= 0, !n) {
						var i = Math.pow(2, 8 * r) - 1;
						L(this, t, e, r, i, 0)
					}
					var o = r - 1,
						a = 1;
					this[e + o] = 255 & t;
					while (--o >= 0 && (a *= 256)) this[e + o] = t / a & 255;
					return e + r
				}, u.prototype.writeUInt8 = function(t, e, r) {
					return t = +t, e |= 0, r || L(this, t, e, 1, 255, 0), u.TYPED_ARRAY_SUPPORT || (t = Math.floor(t)), this[e] = 255 & t, e + 1
				}, u.prototype.writeUInt16LE = function(t, e, r) {
					return t = +t, e |= 0, r || L(this, t, e, 2, 65535, 0), u.TYPED_ARRAY_SUPPORT ? (this[e] = 255 & t, this[e + 1] = t >>> 8) : U(this, t, e, !0), e + 2
				}, u.prototype.writeUInt16BE = function(t, e, r) {
					return t = +t, e |= 0, r || L(this, t, e, 2, 65535, 0), u.TYPED_ARRAY_SUPPORT ? (this[e] = t >>> 8, this[e + 1] = 255 & t) : U(this, t, e, !1), e + 2
				}, u.prototype.writeUInt32LE = function(t, e, r) {
					return t = +t, e |= 0, r || L(this, t, e, 4, 4294967295, 0), u.TYPED_ARRAY_SUPPORT ? (this[e + 3] = t >>> 24, this[e + 2] = t >>> 16, this[e + 1] = t >>> 8, this[e] = 255 & t) : X(this, t, e, !0), e + 4
				}, u.prototype.writeUInt32BE = function(t, e, r) {
					return t = +t, e |= 0, r || L(this, t, e, 4, 4294967295, 0), u.TYPED_ARRAY_SUPPORT ? (this[e] = t >>> 24, this[e + 1] = t >>> 16, this[e + 2] = t >>> 8, this[e + 3] = 255 & t) : X(this, t, e, !1), e + 4
				}, u.prototype.writeIntLE = function(t, e, r, n) {
					if (t = +t, e |= 0, !n) {
						var i = Math.pow(2, 8 * r - 1);
						L(this, t, e, r, i - 1, -i)
					}
					var o = 0,
						a = 1,
						s = 0;
					this[e] = 255 & t;
					while (++o < r && (a *= 256)) t < 0 && 0 === s && 0 !== this[e + o - 1] && (s = 1), this[e + o] = (t / a >> 0) - s & 255;
					return e + r
				}, u.prototype.writeIntBE = function(t, e, r, n) {
					if (t = +t, e |= 0, !n) {
						var i = Math.pow(2, 8 * r - 1);
						L(this, t, e, r, i - 1, -i)
					}
					var o = r - 1,
						a = 1,
						s = 0;
					this[e + o] = 255 & t;
					while (--o >= 0 && (a *= 256)) t < 0 && 0 === s && 0 !== this[e + o + 1] && (s = 1), this[e + o] = (t / a >> 0) - s & 255;
					return e + r
				}, u.prototype.writeInt8 = function(t, e, r) {
					return t = +t, e |= 0, r || L(this, t, e, 1, 127, -128), u.TYPED_ARRAY_SUPPORT || (t = Math.floor(t)), t < 0 && (t = 255 + t + 1), this[e] = 255 & t, e + 1
				}, u.prototype.writeInt16LE = function(t, e, r) {
					return t = +t, e |= 0, r || L(this, t, e, 2, 32767, -32768), u.TYPED_ARRAY_SUPPORT ? (this[e] = 255 & t, this[e + 1] = t >>> 8) : U(this, t, e, !0), e + 2
				}, u.prototype.writeInt16BE = function(t, e, r) {
					return t = +t, e |= 0, r || L(this, t, e, 2, 32767, -32768), u.TYPED_ARRAY_SUPPORT ? (this[e] = t >>> 8, this[e + 1] = 255 & t) : U(this, t, e, !1), e + 2
				}, u.prototype.writeInt32LE = function(t, e, r) {
					return t = +t, e |= 0, r || L(this, t, e, 4, 2147483647, -2147483648), u.TYPED_ARRAY_SUPPORT ? (this[e] = 255 & t, this[e + 1] = t >>> 8, this[e + 2] = t >>> 16, this[e + 3] = t >>> 24) : X(this, t, e, !0), e + 4
				}, u.prototype.writeInt32BE = function(t, e, r) {
					return t = +t, e |= 0, r || L(this, t, e, 4, 2147483647, -2147483648), t < 0 && (t = 4294967295 + t + 1), u.TYPED_ARRAY_SUPPORT ? (this[e] = t >>> 24, this[e + 1] = t >>> 16, this[e + 2] = t >>> 8, this[e + 3] = 255 & t) : X(this, t, e, !1), e + 4
				}, u.prototype.writeFloatLE = function(t, e, r) {
					return G(this, t, e, !0, r)
				}, u.prototype.writeFloatBE = function(t, e, r) {
					return G(this, t, e, !1, r)
				}, u.prototype.writeDoubleLE = function(t, e, r) {
					return q(this, t, e, !0, r)
				}, u.prototype.writeDoubleBE = function(t, e, r) {
					return q(this, t, e, !1, r)
				}, u.prototype.copy = function(t, e, r, n) {
					if (r || (r = 0), n || 0 === n || (n = this.length), e >= t.length && (e = t.length), e || (e = 0), n > 0 && n < r && (n = r), n === r) return 0;
					if (0 === t.length || 0 === this.length) return 0;
					if (e < 0) throw new RangeError("targetStart out of bounds");
					if (r < 0 || r >= this.length) throw new RangeError("sourceStart out of bounds");
					if (n < 0) throw new RangeError("sourceEnd out of bounds");
					n > this.length && (n = this.length), t.length - e < n - r && (n = t.length - e + r);
					var i, o = n - r;
					if (this === t && r < e && e < n)
						for (i = o - 1; i >= 0; --i) t[i + e] = this[i + r];
					else if (o < 1e3 || !u.TYPED_ARRAY_SUPPORT)
						for (i = 0; i < o; ++i) t[i + e] = this[i + r];
					else Uint8Array.prototype.set.call(t, this.subarray(r, r + o), e);
					return o
				}, u.prototype.fill = function(t, e, r, n) {
					if ("string" === typeof t) {
						if ("string" === typeof e ? (n = e, e = 0, r = this.length) : "string" === typeof r && (n = r, r = this.length), 1 === t.length) {
							var i = t.charCodeAt(0);
							i < 256 && (t = i)
						}
						if (void 0 !== n && "string" !== typeof n) throw new TypeError("encoding must be a string");
						if ("string" === typeof n && !u.isEncoding(n)) throw new TypeError("Unknown encoding: " + n)
					} else "number" === typeof t && (t &= 255);
					if (e < 0 || this.length < e || this.length < r) throw new RangeError("Out of range index");
					if (r <= e) return this;
					var o;
					if (e >>>= 0, r = void 0 === r ? this.length : r >>> 0, t || (t = 0), "number" === typeof t)
						for (o = e; o < r; ++o) this[o] = t;
					else {
						var a = u.isBuffer(t) ? t : Z(new u(t, n)
								.toString()),
							s = a.length;
						for (o = 0; o < r - e; ++o) this[o + e] = a[o % s]
					}
					return this
				};
				var W = /[^+\/0-9A-Za-z-_]/g;

				function V(t) {
					if (t = H(t)
						.replace(W, ""), t.length < 2) return "";
					while (t.length % 4 !== 0) t += "=";
					return t
				}

				function H(t) {
					return t.trim ? t.trim() : t.replace(/^\s+|\s+$/g, "")
				}

				function Y(t) {
					return t < 16 ? "0" + t.toString(16) : t.toString(16)
				}

				function Z(t, e) {
					var r;
					e = e || 1 / 0;
					for (var n = t.length, i = null, o = [], a = 0; a < n; ++a) {
						if (r = t.charCodeAt(a), r > 55295 && r < 57344) {
							if (!i) {
								if (r > 56319) {
									(e -= 3) > -1 && o.push(239, 191, 189);
									continue
								}
								if (a + 1 === n) {
									(e -= 3) > -1 && o.push(239, 191, 189);
									continue
								}
								i = r;
								continue
							}
							if (r < 56320) {
								(e -= 3) > -1 && o.push(239, 191, 189), i = r;
								continue
							}
							r = 65536 + (i - 55296 << 10 | r - 56320)
						} else i && (e -= 3) > -1 && o.push(239, 191, 189);
						if (i = null, r < 128) {
							if ((e -= 1) < 0) break;
							o.push(r)
						} else if (r < 2048) {
							if ((e -= 2) < 0) break;
							o.push(r >> 6 | 192, 63 & r | 128)
						} else if (r < 65536) {
							if ((e -= 3) < 0) break;
							o.push(r >> 12 | 224, r >> 6 & 63 | 128, 63 & r | 128)
						} else {
							if (!(r < 1114112)) throw new Error("Invalid code point");
							if ((e -= 4) < 0) break;
							o.push(r >> 18 | 240, r >> 12 & 63 | 128, r >> 6 & 63 | 128, 63 & r | 128)
						}
					}
					return o
				}

				function Q(t) {
					for (var e = [], r = 0; r < t.length; ++r) e.push(255 & t.charCodeAt(r));
					return e
				}

				function J(t, e) {
					for (var r, n, i, o = [], a = 0; a < t.length; ++a) {
						if ((e -= 2) < 0) break;
						r = t.charCodeAt(a), n = r >> 8, i = r % 256, o.push(i), o.push(n)
					}
					return o
				}

				function $(t) {
					return n.toByteArray(V(t))
				}

				function tt(t, e, r, n) {
					for (var i = 0; i < n; ++i) {
						if (i + r >= e.length || i >= t.length) break;
						e[i + r] = t[i]
					}
					return i
				}

				function et(t) {
					return t !== t
				}
			})
			.call(this, r("c8ba"))
		},
		b6b7: function(t, e, r) {
			var n = r("ebb5"),
				i = r("4840"),
				o = n.TYPED_ARRAY_CONSTRUCTOR,
				a = n.aTypedArrayConstructor;
			t.exports = function(t) {
				return a(i(t, t[o]))
			}
		},
		b727: function(t, e, r) {
			var n = r("0366"),
				i = r("e330"),
				o = r("44ad"),
				a = r("7b0b"),
				s = r("07fa"),
				c = r("65f0"),
				u = i([].push),
				d = function(t) {
					var e = 1 == t,
						r = 2 == t,
						i = 3 == t,
						d = 4 == t,
						l = 6 == t,
						f = 7 == t,
						h = 5 == t || l;
					return function(p, m, b, g) {
						for (var y, v, S = a(p), w = o(S), C = n(m, b), _ = s(w), A = 0, I = g || c, E = e ? I(p, _) : r || f ? I(p, 0) : void 0; _ > A; A++)
							if ((h || A in w) && (y = w[A], v = C(y, A, S), t))
								if (e) E[A] = v;
								else if (v) switch (t) {
							case 3:
								return !0;
							case 5:
								return y;
							case 6:
								return A;
							case 2:
								u(E, y)
						} else switch (t) {
							case 4:
								return !1;
							case 7:
								u(E, y)
						}
						return l ? -1 : i || d ? d : E
					}
				};
			t.exports = {
				forEach: d(0),
				map: d(1),
				filter: d(2),
				some: d(3),
				every: d(4),
				find: d(5),
				findIndex: d(6),
				filterReject: d(7)
			}
		},
		b980: function(t, e, r) {
			var n = r("d039"),
				i = r("5c6c");
			t.exports = !n((function() {
				var t = Error("a");
				return !("stack" in t) || (Object.defineProperty(t, "stack", i(1, 7)), 7 !== t.stack)
			}))
		},
		bb2f: function(t, e, r) {
			var n = r("d039");
			t.exports = !n((function() {
				return Object.isExtensible(Object.preventExtensions({}))
			}))
		},
		bb56: function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("da84"),
				o = r("3a9b"),
				a = r("e163"),
				s = r("d2bb"),
				c = r("e893"),
				u = r("7c73"),
				d = r("9112"),
				l = r("5c6c"),
				f = r("c770"),
				h = r("ab36"),
				p = r("2266"),
				m = r("e391"),
				b = r("b622"),
				g = r("b980"),
				y = b("toStringTag"),
				v = i.Error,
				S = [].push,
				w = function(t, e) {
					var r, n = arguments.length > 2 ? arguments[2] : void 0,
						i = o(C, this);
					s ? r = s(new v, i ? a(this) : C) : (r = i ? this : u(C), d(r, y, "Error")), void 0 !== e && d(r, "message", m(e)), g && d(r, "stack", f(r.stack, 1)), h(r, n);
					var c = [];
					return p(t, S, {
						that: c
					}), d(r, "errors", c), r
				};
			s ? s(w, v) : c(w, v, {
				name: !0
			});
			var C = w.prototype = u(v.prototype, {
				constructor: l(1, w),
				message: l(1, ""),
				name: l(1, "AggregateError")
			});
			n({
				global: !0,
				constructor: !0,
				arity: 2
			}, {
				AggregateError: w
			})
		},
		bc3a: function(t, e, r) {
			t.exports = r("cee4")
		},
		bf19: function(t, e, r) {
			"use strict";
			var n = r("23e7"),
				i = r("c65b");
			n({
				target: "URL",
				proto: !0,
				enumerable: !0
			}, {
				toJSON: function() {
					return i(URL.prototype.toString, this)
				}
			})
		},
		bf2c: function(t, e, r) {
			r("caad");
			var n = r("b109");
			t.exports = n("Array", "includes")
		},
		c04e: function(t, e, r) {
			var n = r("da84"),
				i = r("c65b"),
				o = r("861d"),
				a = r("d9b5"),
				s = r("dc4a"),
				c = r("485a"),
				u = r("b622"),
				d = n.TypeError,
				l = u("toPrimitive");
			t.exports = function(t, e) {
				if (!o(t) || a(t)) return t;
				var r, n = s(t, l);
				if (n) {
					if (void 0 === e && (e = "default"), r = i(n, t, e), !o(r) || a(r)) return r;
					throw d("Can't convert object to primitive value")
				}
				return void 0 === e && (e = "number"), c(t, e)
			}
		},
		c1f9: function(t, e, r) {
			var n = r("23e7"),
				i = r("2266"),
				o = r("8418");
			n({
				target: "Object",
				stat: !0
			}, {
				fromEntries: function(t) {
					var e = {};
					return i(t, (function(t, r) {
						o(e, t, r)
					}), {
						AS_ENTRIES: !0
					}), e
				}
			})
		},
		c345: function(t, e, r) {
			"use strict";
			var n = r("c532"),
				i = ["age", "authorization", "content-length", "content-type", "etag", "expires", "from", "host", "if-modified-since", "if-unmodified-since", "last-modified", "location", "max-forwards", "proxy-authorization", "referer", "retry-after", "user-agent"];
			t.exports = function(t) {
				var e, r, o, a = {};
				return t ? (n.forEach(t.split("\n"), (function(t) {
					if (o = t.indexOf(":"), e = n.trim(t.substr(0, o))
						.toLowerCase(), r = n.trim(t.substr(o + 1)), e) {
						if (a[e] && i.indexOf(e) >= 0) return;
						a[e] = "set-cookie" === e ? (a[e] ? a[e] : [])
							.concat([r]) : a[e] ? a[e] + ", " + r : r
					}
				})), a) : a
			}
		},
		c401: function(t, e, r) {
			"use strict";
			var n = r("c532");
			t.exports = function(t, e, r) {
				return n.forEach(r, (function(r) {
					t = r(t, e)
				})), t
			}
		},
		c430: function(t, e) {
			t.exports = !1
		},
		c4e3: function(t, e, r) {
			(function(e, r, n) {
				var i;
				! function(e) {
					t.exports = e()
				}((function() {
					return function t(e, r, n) {
						function o(s, c) {
							if (!r[s]) {
								if (!e[s]) {
									var u = "function" == typeof i && i;
									if (!c && u) return i(s, !0);
									if (a) return a(s, !0);
									var d = new Error("Cannot find module '" + s + "'");
									throw d.code = "MODULE_NOT_FOUND", d
								}
								var l = r[s] = {
									exports: {}
								};
								e[s][0].call(l.exports, (function(t) {
									var r = e[s][1][t];
									return o(r || t)
								}), l, l.exports, t, e, r, n)
							}
							return r[s].exports
						}
						for (var a = "function" == typeof i && i, s = 0; s < n.length; s++) o(n[s]);
						return o
					}({
						1: [function(t, e, r) {
							"use strict";
							var n = t("./utils"),
								i = t("./support"),
								o = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
							r.encode = function(t) {
								for (var e, r, i, a, s, c, u, d = [], l = 0, f = t.length, h = f, p = "string" !== n.getTypeOf(t); l < t.length;) h = f - l, i = p ? (e = t[l++], r = l < f ? t[l++] : 0, l < f ? t[l++] : 0) : (e = t.charCodeAt(l++), r = l < f ? t.charCodeAt(l++) : 0, l < f ? t.charCodeAt(l++) : 0), a = e >> 2, s = (3 & e) << 4 | r >> 4, c = 1 < h ? (15 & r) << 2 | i >> 6 : 64, u = 2 < h ? 63 & i : 64, d.push(o.charAt(a) + o.charAt(s) + o.charAt(c) + o.charAt(u));
								return d.join("")
							}, r.decode = function(t) {
								var e, r, n, a, s, c, u = 0,
									d = 0,
									l = "data:";
								if (t.substr(0, l.length) === l) throw new Error("Invalid base64 input, it looks like a data url.");
								var f, h = 3 * (t = t.replace(/[^A-Za-z0-9\+\/\=]/g, ""))
									.length / 4;
								if (t.charAt(t.length - 1) === o.charAt(64) && h--, t.charAt(t.length - 2) === o.charAt(64) && h--, h % 1 != 0) throw new Error("Invalid base64 input, bad content length.");
								for (f = i.uint8array ? new Uint8Array(0 | h) : new Array(0 | h); u < t.length;) e = o.indexOf(t.charAt(u++)) << 2 | (a = o.indexOf(t.charAt(u++))) >> 4, r = (15 & a) << 4 | (s = o.indexOf(t.charAt(u++))) >> 2, n = (3 & s) << 6 | (c = o.indexOf(t.charAt(u++))), f[d++] = e, 64 !== s && (f[d++] = r), 64 !== c && (f[d++] = n);
								return f
							}
						}, {
							"./support": 30,
							"./utils": 32
						}],
						2: [function(t, e, r) {
							"use strict";
							var n = t("./external"),
								i = t("./stream/DataWorker"),
								o = t("./stream/Crc32Probe"),
								a = t("./stream/DataLengthProbe");

							function s(t, e, r, n, i) {
								this.compressedSize = t, this.uncompressedSize = e, this.crc32 = r, this.compression = n, this.compressedContent = i
							}
							s.prototype = {
								getContentWorker: function() {
									var t = new i(n.Promise.resolve(this.compressedContent))
										.pipe(this.compression.uncompressWorker())
										.pipe(new a("data_length")),
										e = this;
									return t.on("end", (function() {
										if (this.streamInfo.data_length !== e.uncompressedSize) throw new Error("Bug : uncompressed data size mismatch")
									})), t
								},
								getCompressedWorker: function() {
									return new i(n.Promise.resolve(this.compressedContent))
										.withStreamInfo("compressedSize", this.compressedSize)
										.withStreamInfo("uncompressedSize", this.uncompressedSize)
										.withStreamInfo("crc32", this.crc32)
										.withStreamInfo("compression", this.compression)
								}
							}, s.createWorkerFrom = function(t, e, r) {
								return t.pipe(new o)
									.pipe(new a("uncompressedSize"))
									.pipe(e.compressWorker(r))
									.pipe(new a("compressedSize"))
									.withStreamInfo("compression", e)
							}, e.exports = s
						}, {
							"./external": 6,
							"./stream/Crc32Probe": 25,
							"./stream/DataLengthProbe": 26,
							"./stream/DataWorker": 27
						}],
						3: [function(t, e, r) {
							"use strict";
							var n = t("./stream/GenericWorker");
							r.STORE = {
								magic: "\0\0",
								compressWorker: function(t) {
									return new n("STORE compression")
								},
								uncompressWorker: function() {
									return new n("STORE decompression")
								}
							}, r.DEFLATE = t("./flate")
						}, {
							"./flate": 7,
							"./stream/GenericWorker": 28
						}],
						4: [function(t, e, r) {
							"use strict";
							var n = t("./utils"),
								i = function() {
									for (var t, e = [], r = 0; r < 256; r++) {
										t = r;
										for (var n = 0; n < 8; n++) t = 1 & t ? 3988292384 ^ t >>> 1 : t >>> 1;
										e[r] = t
									}
									return e
								}();
							e.exports = function(t, e) {
								return void 0 !== t && t.length ? "string" !== n.getTypeOf(t) ? function(t, e, r, n) {
									var o = i,
										a = n + r;
									t ^= -1;
									for (var s = n; s < a; s++) t = t >>> 8 ^ o[255 & (t ^ e[s])];
									return -1 ^ t
								}(0 | e, t, t.length, 0) : function(t, e, r, n) {
									var o = i,
										a = n + r;
									t ^= -1;
									for (var s = n; s < a; s++) t = t >>> 8 ^ o[255 & (t ^ e.charCodeAt(s))];
									return -1 ^ t
								}(0 | e, t, t.length, 0) : 0
							}
						}, {
							"./utils": 32
						}],
						5: [function(t, e, r) {
							"use strict";
							r.base64 = !1, r.binary = !1, r.dir = !1, r.createFolders = !0, r.date = null, r.compression = null, r.compressionOptions = null, r.comment = null, r.unixPermissions = null, r.dosPermissions = null
						}, {}],
						6: [function(t, e, r) {
							"use strict";
							var n = null;
							n = "undefined" != typeof Promise ? Promise : t("lie"), e.exports = {
								Promise: n
							}
						}, {
							lie: 37
						}],
						7: [function(t, e, r) {
							"use strict";
							var n = "undefined" != typeof Uint8Array && "undefined" != typeof Uint16Array && "undefined" != typeof Uint32Array,
								i = t("pako"),
								o = t("./utils"),
								a = t("./stream/GenericWorker"),
								s = n ? "uint8array" : "array";

							function c(t, e) {
								a.call(this, "FlateWorker/" + t), this._pako = null, this._pakoAction = t, this._pakoOptions = e, this.meta = {}
							}
							r.magic = "\b\0", o.inherits(c, a), c.prototype.processChunk = function(t) {
								this.meta = t.meta, null === this._pako && this._createPako(), this._pako.push(o.transformTo(s, t.data), !1)
							}, c.prototype.flush = function() {
								a.prototype.flush.call(this), null === this._pako && this._createPako(), this._pako.push([], !0)
							}, c.prototype.cleanUp = function() {
								a.prototype.cleanUp.call(this), this._pako = null
							}, c.prototype._createPako = function() {
								this._pako = new i[this._pakoAction]({
									raw: !0,
									level: this._pakoOptions.level || -1
								});
								var t = this;
								this._pako.onData = function(e) {
									t.push({
										data: e,
										meta: t.meta
									})
								}
							}, r.compressWorker = function(t) {
								return new c("Deflate", t)
							}, r.uncompressWorker = function() {
								return new c("Inflate", {})
							}
						}, {
							"./stream/GenericWorker": 28,
							"./utils": 32,
							pako: 38
						}],
						8: [function(t, e, r) {
							"use strict";

							function n(t, e) {
								var r, n = "";
								for (r = 0; r < e; r++) n += String.fromCharCode(255 & t), t >>>= 8;
								return n
							}

							function i(t, e, r, i, a, d) {
								var l, f, h = t.file,
									p = t.compression,
									m = d !== s.utf8encode,
									b = o.transformTo("string", d(h.name)),
									g = o.transformTo("string", s.utf8encode(h.name)),
									y = h.comment,
									v = o.transformTo("string", d(y)),
									S = o.transformTo("string", s.utf8encode(y)),
									w = g.length !== h.name.length,
									C = S.length !== y.length,
									_ = "",
									A = "",
									I = "",
									E = h.dir,
									T = h.date,
									x = {
										crc32: 0,
										compressedSize: 0,
										uncompressedSize: 0
									};
								e && !r || (x.crc32 = t.crc32, x.compressedSize = t.compressedSize, x.uncompressedSize = t.uncompressedSize);
								var P = 0;
								e && (P |= 8), m || !w && !C || (P |= 2048);
								var k = 0,
									D = 0;
								E && (k |= 16), "UNIX" === a ? (D = 798, k |= function(t, e) {
									var r = t;
									return t || (r = e ? 16893 : 33204), (65535 & r) << 16
								}(h.unixPermissions, E)) : (D = 20, k |= function(t) {
									return 63 & (t || 0)
								}(h.dosPermissions)), l = T.getUTCHours(), l <<= 6, l |= T.getUTCMinutes(), l <<= 5, l |= T.getUTCSeconds() / 2, f = T.getUTCFullYear() - 1980, f <<= 4, f |= T.getUTCMonth() + 1, f <<= 5, f |= T.getUTCDate(), w && (A = n(1, 1) + n(c(b), 4) + g, _ += "up" + n(A.length, 2) + A), C && (I = n(1, 1) + n(c(v), 4) + S, _ += "uc" + n(I.length, 2) + I);
								var O = "";
								return O += "\n\0", O += n(P, 2), O += p.magic, O += n(l, 2), O += n(f, 2), O += n(x.crc32, 4), O += n(x.compressedSize, 4), O += n(x.uncompressedSize, 4), O += n(b.length, 2), O += n(_.length, 2), {
									fileRecord: u.LOCAL_FILE_HEADER + O + b + _,
									dirRecord: u.CENTRAL_FILE_HEADER + n(D, 2) + O + n(v.length, 2) + "\0\0\0\0" + n(k, 4) + n(i, 4) + b + _ + v
								}
							}
							var o = t("../utils"),
								a = t("../stream/GenericWorker"),
								s = t("../utf8"),
								c = t("../crc32"),
								u = t("../signature");

							function d(t, e, r, n) {
								a.call(this, "ZipFileWorker"), this.bytesWritten = 0, this.zipComment = e, this.zipPlatform = r, this.encodeFileName = n, this.streamFiles = t, this.accumulate = !1, this.contentBuffer = [], this.dirRecords = [], this.currentSourceOffset = 0, this.entriesCount = 0, this.currentFile = null, this._sources = []
							}
							o.inherits(d, a), d.prototype.push = function(t) {
								var e = t.meta.percent || 0,
									r = this.entriesCount,
									n = this._sources.length;
								this.accumulate ? this.contentBuffer.push(t) : (this.bytesWritten += t.data.length, a.prototype.push.call(this, {
									data: t.data,
									meta: {
										currentFile: this.currentFile,
										percent: r ? (e + 100 * (r - n - 1)) / r : 100
									}
								}))
							}, d.prototype.openedSource = function(t) {
								this.currentSourceOffset = this.bytesWritten, this.currentFile = t.file.name;
								var e = this.streamFiles && !t.file.dir;
								if (e) {
									var r = i(t, e, !1, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);
									this.push({
										data: r.fileRecord,
										meta: {
											percent: 0
										}
									})
								} else this.accumulate = !0
							}, d.prototype.closedSource = function(t) {
								this.accumulate = !1;
								var e = this.streamFiles && !t.file.dir,
									r = i(t, e, !0, this.currentSourceOffset, this.zipPlatform, this.encodeFileName);
								if (this.dirRecords.push(r.dirRecord), e) this.push({
									data: function(t) {
										return u.DATA_DESCRIPTOR + n(t.crc32, 4) + n(t.compressedSize, 4) + n(t.uncompressedSize, 4)
									}(t),
									meta: {
										percent: 100
									}
								});
								else
									for (this.push({
										data: r.fileRecord,
										meta: {
											percent: 0
										}
									}); this.contentBuffer.length;) this.push(this.contentBuffer.shift());
								this.currentFile = null
							}, d.prototype.flush = function() {
								for (var t = this.bytesWritten, e = 0; e < this.dirRecords.length; e++) this.push({
									data: this.dirRecords[e],
									meta: {
										percent: 100
									}
								});
								var r = this.bytesWritten - t,
									i = function(t, e, r, i, a) {
										var s = o.transformTo("string", a(i));
										return u.CENTRAL_DIRECTORY_END + "\0\0\0\0" + n(t, 2) + n(t, 2) + n(e, 4) + n(r, 4) + n(s.length, 2) + s
									}(this.dirRecords.length, r, t, this.zipComment, this.encodeFileName);
								this.push({
									data: i,
									meta: {
										percent: 100
									}
								})
							}, d.prototype.prepareNextSource = function() {
								this.previous = this._sources.shift(), this.openedSource(this.previous.streamInfo), this.isPaused ? this.previous.pause() : this.previous.resume()
							}, d.prototype.registerPrevious = function(t) {
								this._sources.push(t);
								var e = this;
								return t.on("data", (function(t) {
									e.processChunk(t)
								})), t.on("end", (function() {
									e.closedSource(e.previous.streamInfo), e._sources.length ? e.prepareNextSource() : e.end()
								})), t.on("error", (function(t) {
									e.error(t)
								})), this
							}, d.prototype.resume = function() {
								return !!a.prototype.resume.call(this) && (!this.previous && this._sources.length ? (this.prepareNextSource(), !0) : this.previous || this._sources.length || this.generatedError ? void 0 : (this.end(), !0))
							}, d.prototype.error = function(t) {
								var e = this._sources;
								if (!a.prototype.error.call(this, t)) return !1;
								for (var r = 0; r < e.length; r++) try {
									e[r].error(t)
								} catch (t) {}
								return !0
							}, d.prototype.lock = function() {
								a.prototype.lock.call(this);
								for (var t = this._sources, e = 0; e < t.length; e++) t[e].lock()
							}, e.exports = d
						}, {
							"../crc32": 4,
							"../signature": 23,
							"../stream/GenericWorker": 28,
							"../utf8": 31,
							"../utils": 32
						}],
						9: [function(t, e, r) {
							"use strict";
							var n = t("../compressions"),
								i = t("./ZipFileWorker");
							r.generateWorker = function(t, e, r) {
								var o = new i(e.streamFiles, r, e.platform, e.encodeFileName),
									a = 0;
								try {
									t.forEach((function(t, r) {
										a++;
										var i = function(t, e) {
												var r = t || e,
													i = n[r];
												if (!i) throw new Error(r + " is not a valid compression method !");
												return i
											}(r.options.compression, e.compression),
											s = r.options.compressionOptions || e.compressionOptions || {},
											c = r.dir,
											u = r.date;
										r._compressWorker(i, s)
											.withStreamInfo("file", {
												name: t,
												dir: c,
												date: u,
												comment: r.comment || "",
												unixPermissions: r.unixPermissions,
												dosPermissions: r.dosPermissions
											})
											.pipe(o)
									})), o.entriesCount = a
								} catch (t) {
									o.error(t)
								}
								return o
							}
						}, {
							"../compressions": 3,
							"./ZipFileWorker": 8
						}],
						10: [function(t, e, r) {
							"use strict";

							function n() {
								if (!(this instanceof n)) return new n;
								if (arguments.length) throw new Error("The constructor with parameters has been removed in JSZip 3.0, please check the upgrade guide.");
								this.files = Object.create(null), this.comment = null, this.root = "", this.clone = function() {
									var t = new n;
									for (var e in this) "function" != typeof this[e] && (t[e] = this[e]);
									return t
								}
							}(n.prototype = t("./object"))
							.loadAsync = t("./load"), n.support = t("./support"), n.defaults = t("./defaults"), n.version = "3.10.0", n.loadAsync = function(t, e) {
								return (new n)
									.loadAsync(t, e)
							}, n.external = t("./external"), e.exports = n
						}, {
							"./defaults": 5,
							"./external": 6,
							"./load": 11,
							"./object": 15,
							"./support": 30
						}],
						11: [function(t, e, r) {
							"use strict";
							var n = t("./utils"),
								i = t("./external"),
								o = t("./utf8"),
								a = t("./zipEntries"),
								s = t("./stream/Crc32Probe"),
								c = t("./nodejsUtils");

							function u(t) {
								return new i.Promise((function(e, r) {
									var n = t.decompressed.getContentWorker()
										.pipe(new s);
									n.on("error", (function(t) {
											r(t)
										}))
										.on("end", (function() {
											n.streamInfo.crc32 !== t.decompressed.crc32 ? r(new Error("Corrupted zip : CRC32 mismatch")) : e()
										}))
										.resume()
								}))
							}
							e.exports = function(t, e) {
								var r = this;
								return e = n.extend(e || {}, {
										base64: !1,
										checkCRC32: !1,
										optimizedBinaryString: !1,
										createFolders: !1,
										decodeFileName: o.utf8decode
									}), c.isNode && c.isStream(t) ? i.Promise.reject(new Error("JSZip can't accept a stream when loading a zip file.")) : n.prepareContent("the loaded zip file", t, !0, e.optimizedBinaryString, e.base64)
									.then((function(t) {
										var r = new a(e);
										return r.load(t), r
									}))
									.then((function(t) {
										var r = [i.Promise.resolve(t)],
											n = t.files;
										if (e.checkCRC32)
											for (var o = 0; o < n.length; o++) r.push(u(n[o]));
										return i.Promise.all(r)
									}))
									.then((function(t) {
										for (var i = t.shift(), o = i.files, a = 0; a < o.length; a++) {
											var s = o[a],
												c = s.fileNameStr,
												u = n.resolve(s.fileNameStr);
											r.file(u, s.decompressed, {
												binary: !0,
												optimizedBinaryString: !0,
												date: s.date,
												dir: s.dir,
												comment: s.fileCommentStr.length ? s.fileCommentStr : null,
												unixPermissions: s.unixPermissions,
												dosPermissions: s.dosPermissions,
												createFolders: e.createFolders
											}), s.dir || (r.file(u)
												.unsafeOriginalName = c)
										}
										return i.zipComment.length && (r.comment = i.zipComment), r
									}))
							}
						}, {
							"./external": 6,
							"./nodejsUtils": 14,
							"./stream/Crc32Probe": 25,
							"./utf8": 31,
							"./utils": 32,
							"./zipEntries": 33
						}],
						12: [function(t, e, r) {
							"use strict";
							var n = t("../utils"),
								i = t("../str