/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.config;

import cn.keking.config.ConfigConstants;
import cn.keking.service.cache.CacheService;
import cn.keking.utils.KkFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnExpression(value="'${cache.clean.enabled:false}'.equals('true')")
public class SchedulerCleanConfig {
    private final Logger logger = LoggerFactory.getLogger(SchedulerCleanConfig.class);
    private final CacheService cacheService;
    private final String fileDir = ConfigConstants.getFileDir();

    public SchedulerCleanConfig(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Scheduled(cron="${cache.clean.cron:0 0 3 * * ?}")
    public void clean() {
        this.logger.info("Cache clean start");
        this.cacheService.cleanCache();
        KkFileUtils.deleteDirectory((String)this.fileDir);
        this.logger.info("Cache clean end");
    }
}

