/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.model;

import cn.keking.config.ConfigConstants;
import java.util.HashMap;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public enum FileType {
    PICTURE("pictureFilePreviewImpl"),
    COMPRESS("compressFilePreviewImpl"),
    OFFICE("officeFilePreviewImpl"),
    SIMTEXT("simTextFilePreviewImpl"),
    PDF("pdfFilePreviewImpl"),
    CODE("codeFilePreviewImpl"),
    OTHER("otherFilePreviewImpl"),
    MEDIA("mediaFilePreviewImpl"),
    MARKDOWN("markdownFilePreviewImpl"),
    XML("xmlFilePreviewImpl"),
    FLV("flvFilePreviewImpl"),
    CAD("cadFilePreviewImpl"),
    TIFF("tiffFilePreviewImpl"),
    OFD("ofdFilePreviewImpl");

    private static final String[] OFFICE_TYPES;
    private static final String[] PICTURE_TYPES;
    private static final String[] ARCHIVE_TYPES;
    private static final String[] TIFF_TYPES;
    private static final String[] OFD_TYPES;
    private static final String[] SSIM_TEXT_TYPES;
    private static final String[] CODES;
    private static final String[] MEDIA_TYPES;
    public static final String[] MEDIA_TYPES_CONVERT;
    private static final Map<String, FileType> FILE_TYPE_MAPPER;
    private final String instanceName;

    private static FileType to(String fileType) {
        return FILE_TYPE_MAPPER.getOrDefault(fileType, OTHER);
    }

    public static FileType typeFromUrl(String url) {
        String nonPramStr = url.substring(0, url.contains("?") ? url.indexOf("?") : url.length());
        String fileName = nonPramStr.substring(nonPramStr.lastIndexOf("/") + 1);
        return FileType.typeFromFileName((String)fileName);
    }

    public static FileType typeFromFileName(String fileName) {
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1);
        String lowerCaseFileType = fileType.toLowerCase();
        return FileType.to((String)lowerCaseFileType);
    }

    private FileType(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    static {
        OFFICE_TYPES = new String[]{"docx", "wps", "doc", "xls", "xlsx", "ppt", "pptx"};
        PICTURE_TYPES = new String[]{"jpg", "jpeg", "png", "gif", "bmp", "ico", "raw"};
        ARCHIVE_TYPES = new String[]{"rar", "zip", "jar", "7-zip", "tar", "gzip", "7z"};
        TIFF_TYPES = new String[]{"tif", "tiff"};
        OFD_TYPES = new String[]{"ofd"};
        SSIM_TEXT_TYPES = ConfigConstants.getSimText();
        CODES = new String[]{"java", "c", "php", "go", "python", "py", "js", "html", "ftl", "css", "lua", "sh", "rb", "yaml", "yml", "json", "h", "cpp", "cs", "aspx", "jsp"};
        MEDIA_TYPES = ConfigConstants.getMedia();
        MEDIA_TYPES_CONVERT = ConfigConstants.getConvertMedias();
        FILE_TYPE_MAPPER = new HashMap();
        for (String office : OFFICE_TYPES) {
            FILE_TYPE_MAPPER.put(office, OFFICE);
        }
        for (String picture : PICTURE_TYPES) {
            FILE_TYPE_MAPPER.put(picture, PICTURE);
        }
        for (String archive : ARCHIVE_TYPES) {
            FILE_TYPE_MAPPER.put(archive, COMPRESS);
        }
        for (String text : SSIM_TEXT_TYPES) {
            FILE_TYPE_MAPPER.put(text, SIMTEXT);
        }
        for (String media : MEDIA_TYPES) {
            FILE_TYPE_MAPPER.put(media, MEDIA);
        }
        for (String media : MEDIA_TYPES_CONVERT) {
            FILE_TYPE_MAPPER.put(media, MEDIA);
        }
        for (String tif : TIFF_TYPES) {
            FILE_TYPE_MAPPER.put(tif, TIFF);
        }
        for (String code : CODES) {
            FILE_TYPE_MAPPER.put(code, CODE);
        }
        for (String ofd : OFD_TYPES) {
            FILE_TYPE_MAPPER.put(ofd, OFD);
        }
        FILE_TYPE_MAPPER.put("md", MARKDOWN);
        FILE_TYPE_MAPPER.put("xml", XML);
        FILE_TYPE_MAPPER.put("pdf", PDF);
        FILE_TYPE_MAPPER.put("dwg", CAD);
        FILE_TYPE_MAPPER.put("flv", FLV);
    }
}

