/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.service;

import cn.keking.config.ConfigConstants;
import cn.keking.model.FileType;
import cn.keking.service.CompressFileReader;
import cn.keking.service.FileHandlerService;
import cn.keking.utils.KkFileUtils;
import cn.keking.web.filter.BaseUrlFilter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.junrar.Archive;
import com.github.junrar.exception.RarException;
import com.github.junrar.rarfile.FileHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class CompressFileReader {
    private static final Pattern pattern = Pattern.compile("^\\d+");
    private final FileHandlerService fileHandlerService;
    private final String fileDir = ConfigConstants.getFileDir();
    private final ExecutorService executors = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    public static Comparator<FileNode> sortComparator = new /* Unavailable Anonymous Inner Class!! */;

    public CompressFileReader(FileHandlerService fileHandlerService) {
        this.fileHandlerService = fileHandlerService;
    }

    public String readZipFile(String filePath, String fileKey) {
        String archiveSeparator = "/";
        HashMap<String, FileNode> appender = new HashMap<String, FileNode>();
        LinkedList<String> imgUrls = new LinkedList<String>();
        String baseUrl = BaseUrlFilter.getBaseUrl();
        String archiveFileName = this.fileHandlerService.getFileNameFromPath(filePath);
        try {
            ZipFile zipFile = new ZipFile(filePath, KkFileUtils.getFileEncode((String)filePath));
            Enumeration entries = zipFile.getEntries();
            entries = this.sortZipEntries(entries);
            LinkedList<Map<String, ZipArchiveEntry>> entriesToBeExtracted = new LinkedList<Map<String, ZipArchiveEntry>>();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                String fullName = entry.getName().replaceAll("//", "").replaceAll("\\\\", "");
                int level = fullName.split(archiveSeparator).length;
                String originName = CompressFileReader.getLastFileName((String)fullName, (String)archiveSeparator);
                String childName = level + "_" + originName;
                boolean directory = entry.isDirectory();
                if (!directory) {
                    childName = archiveFileName + "_" + originName;
                    entriesToBeExtracted.add(Collections.singletonMap(childName, entry));
                }
                String parentName = CompressFileReader.getLast2FileName((String)fullName, (String)archiveSeparator, (String)archiveFileName);
                parentName = level - 1 + "_" + parentName;
                FileType type = FileType.typeFromUrl((String)childName);
                if (type.equals((Object)FileType.PICTURE)) {
                    imgUrls.add(baseUrl + childName);
                }
                FileNode node = new FileNode(originName, childName, parentName, new ArrayList(), directory, fileKey);
                this.addNodes(appender, parentName, node);
                appender.put(childName, node);
            }
            this.executors.submit((Runnable)new ZipExtractorWorker(this, entriesToBeExtracted, zipFile, filePath));
            this.fileHandlerService.putImgCache(fileKey, imgUrls);
            return new ObjectMapper().writeValueAsString(appender.get(""));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Enumeration<ZipArchiveEntry> sortZipEntries(Enumeration<ZipArchiveEntry> entries) {
        LinkedList<ZipArchiveEntry> sortedEntries = new LinkedList<ZipArchiveEntry>();
        while (entries.hasMoreElements()) {
            sortedEntries.add(entries.nextElement());
        }
        sortedEntries.sort(Comparator.comparingInt(o -> o.getName().length()));
        return Collections.enumeration(sortedEntries);
    }

    public String unRar(String filePath, String fileKey) {
        HashMap<String, FileNode> appender = new HashMap<String, FileNode>();
        ArrayList<String> imgUrls = new ArrayList<String>();
        String baseUrl = BaseUrlFilter.getBaseUrl();
        try {
            Archive archive = new Archive((InputStream)new FileInputStream(filePath));
            List headers = archive.getFileHeaders();
            headers = this.sortedHeaders(headers);
            String archiveFileName = this.fileHandlerService.getFileNameFromPath(filePath);
            ArrayList<Map<String, FileHeader>> headersToBeExtracted = new ArrayList<Map<String, FileHeader>>();
            for (FileHeader header : headers) {
                String originName;
                String fullName = header.isUnicode() ? header.getFileNameW() : header.getFileNameString();
                String childName = originName = CompressFileReader.getLastFileName((String)fullName, (String)"\\");
                boolean directory = header.isDirectory();
                if (!directory) {
                    childName = archiveFileName + "_" + originName;
                    headersToBeExtracted.add(Collections.singletonMap(childName, header));
                }
                String parentName = CompressFileReader.getLast2FileName((String)fullName, (String)"\\", (String)archiveFileName);
                FileType type = FileType.typeFromUrl((String)childName);
                if (type.equals((Object)FileType.PICTURE)) {
                    imgUrls.add(baseUrl + childName);
                }
                FileNode node = new FileNode(originName, childName, parentName, new ArrayList(), directory, fileKey);
                this.addNodes(appender, parentName, node);
                appender.put(childName, node);
            }
            this.executors.submit((Runnable)new RarExtractorWorker(this, headersToBeExtracted, archive, filePath));
            this.fileHandlerService.putImgCache(fileKey, imgUrls);
            return new ObjectMapper().writeValueAsString(appender.get(""));
        }
        catch (RarException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String read7zFile(String filePath, String fileKey) {
        String archiveSeparator = "/";
        HashMap<String, FileNode> appender = new HashMap<String, FileNode>();
        ArrayList<String> imgUrls = new ArrayList<String>();
        String baseUrl = BaseUrlFilter.getBaseUrl();
        String archiveFileName = this.fileHandlerService.getFileNameFromPath(filePath);
        try {
            SevenZFile zipFile = new SevenZFile(new File(filePath));
            Iterable entries = zipFile.getEntries();
            Enumeration newEntries = this.sortSevenZEntries(entries);
            ArrayList<Map<String, SevenZArchiveEntry>> entriesToBeExtracted = new ArrayList<Map<String, SevenZArchiveEntry>>();
            while (newEntries.hasMoreElements()) {
                SevenZArchiveEntry entry = (SevenZArchiveEntry)newEntries.nextElement();
                String fullName = entry.getName().replaceAll("//", "").replaceAll("\\\\", "");
                int level = fullName.split(archiveSeparator).length;
                String originName = CompressFileReader.getLastFileName((String)fullName, (String)archiveSeparator);
                String childName = level + "_" + originName;
                boolean directory = entry.isDirectory();
                if (!directory) {
                    childName = archiveFileName + "_" + originName;
                    entriesToBeExtracted.add(Collections.singletonMap(childName, entry));
                }
                String parentName = CompressFileReader.getLast2FileName((String)fullName, (String)archiveSeparator, (String)archiveFileName);
                parentName = level - 1 + "_" + parentName;
                FileType type = FileType.typeFromUrl((String)childName);
                if (type.equals((Object)FileType.PICTURE)) {
                    imgUrls.add(baseUrl + childName);
                }
                FileNode node = new FileNode(originName, childName, parentName, new ArrayList(), directory, fileKey);
                this.addNodes(appender, parentName, node);
                appender.put(childName, node);
            }
            this.executors.submit((Runnable)new SevenZExtractorWorker(this, entriesToBeExtracted, filePath));
            this.fileHandlerService.putImgCache(fileKey, imgUrls);
            return new ObjectMapper().writeValueAsString(appender.get(""));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Enumeration<SevenZArchiveEntry> sortSevenZEntries(Iterable<SevenZArchiveEntry> entries) {
        ArrayList<SevenZArchiveEntry> sortedEntries = new ArrayList<SevenZArchiveEntry>();
        for (SevenZArchiveEntry entry : entries) {
            sortedEntries.add(entry);
        }
        return Collections.enumeration(sortedEntries);
    }

    private void addNodes(Map<String, FileNode> appender, String parentName, FileNode node) {
        if (appender.containsKey(parentName)) {
            appender.get(parentName).getChildList().add(node);
            appender.get(parentName).getChildList().sort(sortComparator);
        } else {
            FileNode nodeRoot = new FileNode(parentName, parentName, "", new ArrayList(), true);
            nodeRoot.getChildList().add(node);
            appender.put("", nodeRoot);
            appender.put(parentName, nodeRoot);
        }
    }

    private List<FileHeader> sortedHeaders(List<FileHeader> headers) {
        ArrayList<FileHeader> sortedHeaders = new ArrayList<FileHeader>();
        TreeMap mapHeaders = new TreeMap();
        headers.forEach(header -> mapHeaders.put(new Integer(0).equals(header.getFileNameW().length()) ? header.getFileNameString().length() : header.getFileNameW().length(), header));
        for (Map.Entry entry : mapHeaders.entrySet()) {
            for (FileHeader header2 : headers) {
                if (!((Integer)entry.getKey()).equals(new Integer(0).equals(header2.getFileNameW().length()) ? header2.getFileNameString().length() : header2.getFileNameW().length())) continue;
                sortedHeaders.add(header2);
            }
        }
        return sortedHeaders;
    }

    private static String getLast2FileName(String fullName, String seperator, String rootName) {
        int endIndex;
        String leftPath;
        if (fullName.endsWith(seperator)) {
            fullName = fullName.substring(0, fullName.length() - 1);
        }
        if ((leftPath = fullName.substring(0, (endIndex = fullName.lastIndexOf(seperator)) == -1 ? 0 : endIndex)).length() > 1) {
            return CompressFileReader.getLastFileName((String)leftPath, (String)seperator);
        }
        return rootName;
    }

    private static String getLastFileName(String fullName, String seperator) {
        if (fullName.endsWith(seperator)) {
            fullName = fullName.substring(0, fullName.length() - 1);
        }
        String newName = fullName;
        if (fullName.contains(seperator)) {
            newName = fullName.substring(fullName.lastIndexOf(seperator) + 1);
        }
        return newName;
    }

    private static BigDecimal isStartNumber(FileNode src) {
        Matcher matcher = pattern.matcher(src.getOriginName());
        if (matcher.find()) {
            return new BigDecimal(matcher.group());
        }
        return null;
    }

    static /* synthetic */ BigDecimal access$000(FileNode x0) {
        return CompressFileReader.isStartNumber((FileNode)x0);
    }

    static /* synthetic */ String access$100(CompressFileReader x0) {
        return x0.fileDir;
    }
}

