/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.service;

import cn.keking.config.ConfigConstants;
import cn.keking.model.FileAttribute;
import cn.keking.model.FileType;
import cn.keking.service.cache.CacheService;
import cn.keking.utils.KkFileUtils;
import cn.keking.utils.WebUtils;
import com.aspose.cad.Color;
import com.aspose.cad.Image;
import com.aspose.cad.ImageOptionsBase;
import com.aspose.cad.imageoptions.CadRasterizationOptions;
import com.aspose.cad.imageoptions.PdfOptions;
import com.aspose.cad.imageoptions.VectorRasterizationOptions;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FileHandlerService {
    private final Logger logger = LoggerFactory.getLogger(FileHandlerService.class);
    private static final String DEFAULT_CONVERTER_CHARSET = System.getProperty("sun.jnu.encoding");
    private final String fileDir = ConfigConstants.getFileDir();
    private final CacheService cacheService;
    @Value(value="${server.tomcat.uri-encoding:UTF-8}")
    private String uriEncoding;

    public FileHandlerService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public Map<String, String> listConvertedFiles() {
        return this.cacheService.getPDFCache();
    }

    public String getConvertedFile(String key) {
        return this.cacheService.getPDFCache(key);
    }

    public Integer getConvertedPdfImage(String key) {
        return this.cacheService.getPdfImageCache(key);
    }

    public String getFileNameFromPath(String path) {
        return path.substring(path.lastIndexOf(File.separator) + 1);
    }

    public String getRelativePath(String absolutePath) {
        return absolutePath.substring(this.fileDir.length());
    }

    public void addConvertedFile(String fileName, String value) {
        this.cacheService.putPDFCache(fileName, value);
    }

    public void addConvertedPdfImage(String pdfFilePath, int num) {
        this.cacheService.putPdfImageCache(pdfFilePath, num);
    }

    public List<String> getImgCache(String fileKey) {
        return this.cacheService.getImgCache(fileKey);
    }

    public void putImgCache(String fileKey, List<String> imgs) {
        this.cacheService.putImgCache(fileKey, imgs);
    }

    public void doActionConvertedFile(String outFilePath) {
        Throwable throwable;
        Throwable throwable2;
        StringBuilder sb = new StringBuilder();
        try {
            throwable2 = null;
            try (FileInputStream inputStream = new FileInputStream(outFilePath);){
                throwable = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, DEFAULT_CONVERTER_CHARSET));){
                    String line;
                    while (null != (line = reader.readLine())) {
                        if (line.contains("charset=gb2312")) {
                            line = line.replace("charset=gb2312", "charset=utf-8");
                        }
                        sb.append(line);
                    }
                    sb.append("<script src=\"js/jquery-3.0.0.min.js\" type=\"text/javascript\"></script>");
                    sb.append("<script src=\"js/excel.header.js\" type=\"text/javascript\"></script>");
                    sb.append("<link rel=\"stylesheet\" href=\"bootstrap/css/bootstrap.min.css\">");
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable reader) {
                throwable2 = reader;
                throw reader;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            throwable2 = null;
            try (FileOutputStream fos = new FileOutputStream(outFilePath);){
                throwable = null;
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));){
                    writer.write(sb.toString());
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> pdf2jpg(String pdfFilePath, String pdfName, String baseUrl) {
        String urlPrefix;
        ArrayList<String> imageUrls = new ArrayList<String>();
        Integer imageCount = this.getConvertedPdfImage(pdfFilePath);
        String imageFileSuffix = ".jpg";
        String pdfFolder = pdfName.substring(0, pdfName.length() - 4);
        try {
            urlPrefix = baseUrl + URLEncoder.encode(pdfFolder, this.uriEncoding).replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("UnsupportedEncodingException", (Throwable)e);
            urlPrefix = baseUrl + pdfFolder;
        }
        if (imageCount != null && imageCount > 0) {
            for (int i = 0; i < imageCount; ++i) {
                imageUrls.add(urlPrefix + "/" + i + imageFileSuffix);
            }
            return imageUrls;
        }
        try {
            File pdfFile = new File(pdfFilePath);
            PDDocument doc = PDDocument.load((File)pdfFile);
            int pageCount = doc.getNumberOfPages();
            PDFRenderer pdfRenderer = new PDFRenderer(doc);
            int index = pdfFilePath.lastIndexOf(".");
            String folder = pdfFilePath.substring(0, index);
            File path = new File(folder);
            if (!path.exists() && !path.mkdirs()) {
                this.logger.error("\u521b\u5efa\u8f6c\u6362\u6587\u4ef6\u3010{}\u3011\u76ee\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76ee\u5f55\u6743\u9650\uff01", (Object)folder);
            }
            for (int pageIndex = 0; pageIndex < pageCount; ++pageIndex) {
                String imageFilePath = folder + File.separator + pageIndex + imageFileSuffix;
                BufferedImage image = pdfRenderer.renderImageWithDPI(pageIndex, 105.0f, ImageType.RGB);
                ImageIOUtil.writeImage((BufferedImage)image, (String)imageFilePath, (int)105);
                imageUrls.add(urlPrefix + "/" + pageIndex + imageFileSuffix);
            }
            doc.close();
            this.addConvertedPdfImage(pdfFilePath, pageCount);
        }
        catch (IOException e) {
            this.logger.error("Convert pdf to jpg exception, pdfFilePath\uff1a{}", (Object)pdfFilePath, (Object)e);
        }
        return imageUrls;
    }

    public boolean cadToPdf(String inputFilePath, String outputFilePath) {
        Image cadImage = Image.load((String)inputFilePath);
        CadRasterizationOptions cadRasterizationOptions = new CadRasterizationOptions();
        cadRasterizationOptions.setLayouts(new String[]{"Model"});
        cadRasterizationOptions.setNoScaling(true);
        cadRasterizationOptions.setBackgroundColor(Color.getWhite());
        cadRasterizationOptions.setPageWidth((float)cadImage.getWidth());
        cadRasterizationOptions.setPageHeight((float)cadImage.getHeight());
        cadRasterizationOptions.setPdfProductLocation("center");
        cadRasterizationOptions.setAutomaticLayoutsScaling(true);
        cadRasterizationOptions.setDrawType(1);
        PdfOptions pdfOptions = new PdfOptions();
        pdfOptions.setVectorRasterizationOptions((VectorRasterizationOptions)cadRasterizationOptions);
        File outputFile = new File(outputFilePath);
        try {
            FileOutputStream stream = new FileOutputStream(outputFile);
            cadImage.save((OutputStream)stream, (ImageOptionsBase)pdfOptions);
            cadImage.close();
            return true;
        }
        catch (FileNotFoundException e) {
            this.logger.error("PDFFileNotFoundException\uff0cinputFilePath\uff1a{}", (Object)inputFilePath, (Object)e);
            return false;
        }
    }

    public FileAttribute getFileAttribute(String url, HttpServletRequest req) {
        String suffix;
        FileType type;
        String fileName;
        FileAttribute attribute = new FileAttribute();
        String fullFileName = WebUtils.getUrlParameterReg((String)url, (String)"fullfilename");
        if (StringUtils.hasText((String)fullFileName)) {
            fileName = fullFileName;
            type = FileType.typeFromFileName((String)fullFileName);
            suffix = KkFileUtils.suffixFromFileName((String)fullFileName);
        } else {
            fileName = WebUtils.getFileNameFromURL((String)url);
            type = FileType.typeFromUrl((String)url);
            suffix = WebUtils.suffixFromUrl((String)url);
        }
        attribute.setType(type);
        attribute.setName(fileName);
        attribute.setSuffix(suffix);
        attribute.setUrl(url);
        if (req != null) {
            String officePreviewType = req.getParameter("officePreviewType");
            String fileKey = WebUtils.getUrlParameterReg((String)url, (String)"fileKey");
            if (StringUtils.hasText((String)officePreviewType)) {
                attribute.setOfficePreviewType(officePreviewType);
            }
            if (StringUtils.hasText((String)fileKey)) {
                attribute.setFileKey(fileKey);
            }
        }
        return attribute;
    }

    public Map<String, String> listConvertedMedias() {
        return this.cacheService.getMediaConvertCache();
    }

    public void addConvertedMedias(String fileName, String value) {
        this.cacheService.putMediaConvertCache(fileName, value);
    }

    public String getConvertedMedias(String key) {
        return this.cacheService.getMediaConvertCache(key);
    }
}

