/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.service;

import cn.keking.service.OfficePluginExtendFormatRegistry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.document.DocumentFormatRegistry;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.artofsolving.jodconverter.office.OfficeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.convert.DurationStyle;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class OfficePluginManager {
    private final Logger logger = LoggerFactory.getLogger(OfficePluginManager.class);
    private OfficeManager officeManager;
    @Value(value="${office.plugin.server.ports:2001,2002}")
    private String serverPorts;
    @Value(value="${office.plugin.task.timeout:5m}")
    private String timeOut;

    @PostConstruct
    public void startOfficeManager() {
        File officeHome = OfficeUtils.getDefaultOfficeHome();
        if (officeHome == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230office\u7ec4\u4ef6\uff0c\u8bf7\u786e\u8ba4'office.home'\u914d\u7f6e\u662f\u5426\u6709\u8bef");
        }
        boolean killOffice = this.killProcess();
        if (killOffice) {
            this.logger.warn("\u68c0\u6d4b\u5230\u6709\u6b63\u5728\u8fd0\u884c\u7684office\u8fdb\u7a0b\uff0c\u5df2\u81ea\u52a8\u7ed3\u675f\u8be5\u8fdb\u7a0b");
        }
        try {
            DefaultOfficeManagerConfiguration configuration = new DefaultOfficeManagerConfiguration();
            configuration.setOfficeHome(officeHome);
            String[] portsString = this.serverPorts.split(",");
            int[] ports = Arrays.stream(portsString).mapToInt(Integer::parseInt).toArray();
            configuration.setPortNumbers(ports);
            long timeout = DurationStyle.detectAndParse((String)this.timeOut).toMillis();
            configuration.setTaskExecutionTimeout(timeout);
            this.officeManager = configuration.buildOfficeManager();
            this.officeManager.start();
        }
        catch (Exception e) {
            this.logger.error("\u542f\u52a8office\u7ec4\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5office\u7ec4\u4ef6\u662f\u5426\u53ef\u7528");
            throw e;
        }
    }

    public OfficeDocumentConverter getDocumentConverter() {
        OfficeDocumentConverter converter = new OfficeDocumentConverter(this.officeManager, (DocumentFormatRegistry)new OfficePluginExtendFormatRegistry());
        converter.setDefaultLoadProperties(this.getLoadProperties());
        return converter;
    }

    private Map<String, ?> getLoadProperties() {
        HashMap<String, Object> loadProperties = new HashMap<String, Object>(10);
        loadProperties.put("Hidden", true);
        loadProperties.put("ReadOnly", true);
        loadProperties.put("UpdateDocMode", (short)1);
        loadProperties.put("CharacterSet", StandardCharsets.UTF_8.name());
        return loadProperties;
    }

    private boolean killProcess() {
        boolean flag = false;
        Properties props = System.getProperties();
        try {
            if (props.getProperty("os.name").toLowerCase().contains("windows")) {
                Process p = Runtime.getRuntime().exec("cmd /c tasklist ");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream os = p.getInputStream();
                byte[] b = new byte[256];
                while (os.read(b) > 0) {
                    baos.write(b);
                }
                String s = baos.toString();
                if (s.contains("soffice.bin")) {
                    Runtime.getRuntime().exec("taskkill /im soffice.bin /f");
                    flag = true;
                }
            } else {
                Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", "ps -ef | grep soffice.bin"});
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream os = p.getInputStream();
                byte[] b = new byte[256];
                while (os.read(b) > 0) {
                    baos.write(b);
                }
                String s = baos.toString();
                if (StringUtils.ordinalIndexOf((CharSequence)s, (CharSequence)"soffice.bin", (int)3) > 0) {
                    String[] cmd = new String[]{"sh", "-c", "kill -15 `ps -ef|grep soffice.bin|awk 'NR==1{print $2}'`"};
                    Runtime.getRuntime().exec(cmd);
                    flag = true;
                }
            }
        }
        catch (IOException e) {
            this.logger.error("\u68c0\u6d4boffice\u8fdb\u7a0b\u5f02\u5e38", (Throwable)e);
        }
        return flag;
    }

    @PreDestroy
    public void destroyOfficeManager() {
        if (null != this.officeManager && this.officeManager.isRunning()) {
            this.logger.info("Shutting down office process");
            this.officeManager.stop();
        }
    }
}

