/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.service.cache.impl;

import cn.keking.service.cache.CacheService;
import java.util.List;
import java.util.Map;
import org.redisson.Redisson;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RMapCache;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;

@ConditionalOnExpression(value="'${cache.type:default}'.equals('redis')")
@Service
public class CacheServiceRedisImpl
implements CacheService {
    private final RedissonClient redissonClient;

    public CacheServiceRedisImpl(Config config) {
        this.redissonClient = Redisson.create((Config)config);
    }

    public void initPDFCachePool(Integer capacity) {
    }

    public void initIMGCachePool(Integer capacity) {
    }

    public void initPdfImagesCachePool(Integer capacity) {
    }

    public void initMediaConvertCachePool(Integer capacity) {
    }

    public void putPDFCache(String key, String value) {
        RMapCache convertedList = this.redissonClient.getMapCache("converted-preview-pdf-file");
        convertedList.fastPut((Object)key, (Object)value);
    }

    public void putImgCache(String key, List<String> value) {
        RMapCache convertedList = this.redissonClient.getMapCache("converted-preview-imgs-file");
        convertedList.fastPut((Object)key, value);
    }

    public Map<String, String> getPDFCache() {
        return this.redissonClient.getMapCache("converted-preview-pdf-file");
    }

    public String getPDFCache(String key) {
        RMapCache convertedList = this.redissonClient.getMapCache("converted-preview-pdf-file");
        return (String)convertedList.get((Object)key);
    }

    public Map<String, List<String>> getImgCache() {
        return this.redissonClient.getMapCache("converted-preview-imgs-file");
    }

    public List<String> getImgCache(String key) {
        RMapCache convertedList = this.redissonClient.getMapCache("converted-preview-imgs-file");
        return (List)convertedList.get((Object)key);
    }

    public Integer getPdfImageCache(String key) {
        RMapCache convertedList = this.redissonClient.getMapCache("converted-preview-pdfimgs-file");
        return (Integer)convertedList.get((Object)key);
    }

    public void putPdfImageCache(String pdfFilePath, int num) {
        RMapCache convertedList = this.redissonClient.getMapCache("converted-preview-pdfimgs-file");
        convertedList.fastPut((Object)pdfFilePath, (Object)num);
    }

    public Map<String, String> getMediaConvertCache() {
        return this.redissonClient.getMapCache("converted-preview-media-file");
    }

    public void putMediaConvertCache(String key, String value) {
        RMapCache convertedList = this.redissonClient.getMapCache("converted-preview-media-file");
        convertedList.fastPut((Object)key, (Object)value);
    }

    public String getMediaConvertCache(String key) {
        RMapCache convertedList = this.redissonClient.getMapCache("converted-preview-media-file");
        return (String)convertedList.get((Object)key);
    }

    public void cleanCache() {
        this.cleanPdfCache();
        this.cleanImgCache();
        this.cleanPdfImgCache();
    }

    public void addQueueTask(String url) {
        RBlockingQueue queue = this.redissonClient.getBlockingQueue("convert-task");
        queue.addAsync((Object)url);
    }

    public String takeQueueTask() throws InterruptedException {
        RBlockingQueue queue = this.redissonClient.getBlockingQueue("convert-task");
        return (String)queue.take();
    }

    private void cleanPdfCache() {
        RMapCache pdfCache = this.redissonClient.getMapCache("converted-preview-pdf-file");
        pdfCache.clear();
    }

    private void cleanImgCache() {
        RMapCache imgCache = this.redissonClient.getMapCache("converted-preview-imgs-file");
        imgCache.clear();
    }

    private void cleanPdfImgCache() {
        RMapCache pdfImg = this.redissonClient.getMapCache("converted-preview-pdfimgs-file");
        pdfImg.clear();
    }
}

