/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.service.cache.impl;

import cn.keking.service.cache.CacheService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.artofsolving.jodconverter.util.ConfigUtils;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.stereotype.Service;

@ConditionalOnExpression(value="'${cache.type:default}'.equals('default')")
@Service
public class CacheServiceRocksDBImpl
implements CacheService {
    private static final String DB_PATH;
    private static final int QUEUE_SIZE = 500000;
    private static final Logger LOGGER;
    private final BlockingQueue<String> blockingQueue = new ArrayBlockingQueue(500000);
    private RocksDB db;

    public CacheServiceRocksDBImpl() {
        try {
            this.db = RocksDB.open((String)DB_PATH);
            if (this.db.get("converted-preview-pdf-file".getBytes()) == null) {
                HashMap initPDFCache = new HashMap();
                this.db.put("converted-preview-pdf-file".getBytes(), this.toByteArray(initPDFCache));
            }
            if (this.db.get("converted-preview-imgs-file".getBytes()) == null) {
                HashMap initIMGCache = new HashMap();
                this.db.put("converted-preview-imgs-file".getBytes(), this.toByteArray(initIMGCache));
            }
            if (this.db.get("converted-preview-pdfimgs-file".getBytes()) == null) {
                HashMap initPDFIMGCache = new HashMap();
                this.db.put("converted-preview-pdfimgs-file".getBytes(), this.toByteArray(initPDFIMGCache));
            }
        }
        catch (IOException | RocksDBException e) {
            LOGGER.error("Uable to init RocksDB" + e);
        }
    }

    public void initPDFCachePool(Integer capacity) {
    }

    public void initIMGCachePool(Integer capacity) {
    }

    public void initPdfImagesCachePool(Integer capacity) {
    }

    public void initMediaConvertCachePool(Integer capacity) {
    }

    public void putPDFCache(String key, String value) {
        try {
            Map pdfCacheItem = this.getPDFCache();
            pdfCacheItem.put(key, value);
            this.db.put("converted-preview-pdf-file".getBytes(), this.toByteArray((Object)pdfCacheItem));
        }
        catch (IOException | RocksDBException e) {
            LOGGER.error("Put into RocksDB Exception" + e);
        }
    }

    public void putImgCache(String key, List<String> value) {
        try {
            Map imgCacheItem = this.getImgCache();
            imgCacheItem.put(key, value);
            this.db.put("converted-preview-imgs-file".getBytes(), this.toByteArray((Object)imgCacheItem));
        }
        catch (IOException | RocksDBException e) {
            LOGGER.error("Put into RocksDB Exception" + e);
        }
    }

    public Map<String, String> getPDFCache() {
        HashMap<String, String> result = new HashMap();
        try {
            result = (Map)this.toObject(this.db.get("converted-preview-pdf-file".getBytes()));
        }
        catch (IOException | ClassNotFoundException | RocksDBException e) {
            LOGGER.error("Get from RocksDB Exception" + e);
        }
        return result;
    }

    public String getPDFCache(String key) {
        String result = "";
        try {
            Map map = (Map)this.toObject(this.db.get("converted-preview-pdf-file".getBytes()));
            result = (String)map.get(key);
        }
        catch (IOException | ClassNotFoundException | RocksDBException e) {
            LOGGER.error("Get from RocksDB Exception" + e);
        }
        return result;
    }

    public Map<String, List<String>> getImgCache() {
        HashMap<String, List<String>> result = new HashMap();
        try {
            result = (Map)this.toObject(this.db.get("converted-preview-imgs-file".getBytes()));
        }
        catch (IOException | ClassNotFoundException | RocksDBException e) {
            LOGGER.error("Get from RocksDB Exception" + e);
        }
        return result;
    }

    public List<String> getImgCache(String key) {
        List<String> result = new ArrayList<String>();
        try {
            Map map = (Map)this.toObject(this.db.get("converted-preview-imgs-file".getBytes()));
            result = (List)map.get(key);
        }
        catch (IOException | ClassNotFoundException | RocksDBException e) {
            LOGGER.error("Get from RocksDB Exception" + e);
        }
        return result;
    }

    public Integer getPdfImageCache(String key) {
        Integer result = 0;
        try {
            Map map = (Map)this.toObject(this.db.get("converted-preview-pdfimgs-file".getBytes()));
            result = (Integer)map.get(key);
        }
        catch (IOException | ClassNotFoundException | RocksDBException e) {
            LOGGER.error("Get from RocksDB Exception" + e);
        }
        return result;
    }

    public void putPdfImageCache(String pdfFilePath, int num) {
        try {
            Map pdfImageCacheItem = this.getPdfImageCaches();
            pdfImageCacheItem.put(pdfFilePath, num);
            this.db.put("converted-preview-pdfimgs-file".getBytes(), this.toByteArray((Object)pdfImageCacheItem));
        }
        catch (IOException | RocksDBException e) {
            LOGGER.error("Put into RocksDB Exception" + e);
        }
    }

    public Map<String, String> getMediaConvertCache() {
        HashMap<String, String> result = new HashMap();
        try {
            result = (Map)this.toObject(this.db.get("converted-preview-media-file".getBytes()));
        }
        catch (IOException | ClassNotFoundException | RocksDBException e) {
            LOGGER.error("Get from RocksDB Exception" + e);
        }
        return result;
    }

    public void putMediaConvertCache(String key, String value) {
        try {
            Map mediaConvertCacheItem = this.getMediaConvertCache();
            mediaConvertCacheItem.put(key, value);
            this.db.put("converted-preview-media-file".getBytes(), this.toByteArray((Object)mediaConvertCacheItem));
        }
        catch (IOException | RocksDBException e) {
            LOGGER.error("Put into RocksDB Exception" + e);
        }
    }

    public String getMediaConvertCache(String key) {
        String result = "";
        try {
            Map map = (Map)this.toObject(this.db.get("converted-preview-media-file".getBytes()));
            result = (String)map.get(key);
        }
        catch (IOException | ClassNotFoundException | RocksDBException e) {
            LOGGER.error("Get from RocksDB Exception" + e);
        }
        return result;
    }

    public void cleanCache() {
        try {
            this.cleanPdfCache();
            this.cleanImgCache();
            this.cleanPdfImgCache();
        }
        catch (IOException | RocksDBException e) {
            LOGGER.error("Clean Cache Exception" + e);
        }
    }

    public void addQueueTask(String url) {
        this.blockingQueue.add(url);
    }

    public String takeQueueTask() throws InterruptedException {
        return (String)this.blockingQueue.take();
    }

    private Map<String, Integer> getPdfImageCaches() {
        HashMap<String, Integer> map = new HashMap();
        try {
            map = (Map)this.toObject(this.db.get("converted-preview-pdfimgs-file".getBytes()));
        }
        catch (IOException | ClassNotFoundException | RocksDBException e) {
            LOGGER.error("Get from RocksDB Exception" + e);
        }
        return map;
    }

    private byte[] toByteArray(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(obj);
        oos.flush();
        byte[] bytes = bos.toByteArray();
        oos.close();
        bos.close();
        return bytes;
    }

    private Object toObject(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bis);
        Object obj = ois.readObject();
        ois.close();
        bis.close();
        return obj;
    }

    private void cleanPdfCache() throws IOException, RocksDBException {
        HashMap initPDFCache = new HashMap();
        this.db.put("converted-preview-pdf-file".getBytes(), this.toByteArray(initPDFCache));
    }

    private void cleanImgCache() throws IOException, RocksDBException {
        HashMap initIMGCache = new HashMap();
        this.db.put("converted-preview-imgs-file".getBytes(), this.toByteArray(initIMGCache));
    }

    private void cleanPdfImgCache() throws IOException, RocksDBException {
        HashMap initPDFIMGCache = new HashMap();
        this.db.put("converted-preview-pdfimgs-file".getBytes(), this.toByteArray(initPDFIMGCache));
    }

    static {
        RocksDB.loadLibrary();
        DB_PATH = ConfigUtils.getHomePath() + File.separator + "cache";
        LOGGER = LoggerFactory.getLogger(CacheServiceRocksDBImpl.class);
    }
}

