/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.service.impl;

import cn.keking.config.ConfigConstants;
import cn.keking.model.FileAttribute;
import cn.keking.model.ReturnResponse;
import cn.keking.service.FileHandlerService;
import cn.keking.service.FilePreview;
import cn.keking.service.impl.OfficeFilePreviewImpl;
import cn.keking.service.impl.OtherFilePreviewImpl;
import cn.keking.utils.DownloadUtils;
import cn.keking.web.filter.BaseUrlFilter;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;

@Service
public class CadFilePreviewImpl
implements FilePreview {
    private static final String OFFICE_PREVIEW_TYPE_IMAGE = "image";
    private static final String OFFICE_PREVIEW_TYPE_ALL_IMAGES = "allImages";
    private static final String FILE_DIR = ConfigConstants.getFileDir();
    private final FileHandlerService fileHandlerService;
    private final OtherFilePreviewImpl otherFilePreview;

    public CadFilePreviewImpl(FileHandlerService fileHandlerService, OtherFilePreviewImpl otherFilePreview) {
        this.fileHandlerService = fileHandlerService;
        this.otherFilePreview = otherFilePreview;
    }

    public String filePreviewHandle(String url, Model model, FileAttribute fileAttribute) {
        String officePreviewType = fileAttribute.getOfficePreviewType() == null ? ConfigConstants.getOfficePreviewType() : fileAttribute.getOfficePreviewType();
        String baseUrl = BaseUrlFilter.getBaseUrl();
        String fileName = fileAttribute.getName();
        String pdfName = fileName.substring(0, fileName.lastIndexOf(".") + 1) + "pdf";
        String outFilePath = FILE_DIR + pdfName;
        if (!this.fileHandlerService.listConvertedFiles().containsKey(pdfName) || !ConfigConstants.isCacheEnabled().booleanValue()) {
            ReturnResponse response = DownloadUtils.downLoad((FileAttribute)fileAttribute, null);
            if (response.isFailure()) {
                return this.otherFilePreview.notSupportedFile(model, fileAttribute, response.getMsg());
            }
            String filePath = (String)response.getContent();
            if (StringUtils.hasText((String)outFilePath)) {
                boolean convertResult = this.fileHandlerService.cadToPdf(filePath, outFilePath);
                if (!convertResult) {
                    return this.otherFilePreview.notSupportedFile(model, fileAttribute, "cad\u6587\u4ef6\u8f6c\u6362\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                }
                if (ConfigConstants.isCacheEnabled().booleanValue()) {
                    this.fileHandlerService.addConvertedFile(pdfName, this.fileHandlerService.getRelativePath(outFilePath));
                }
            }
        }
        if (baseUrl != null && (OFFICE_PREVIEW_TYPE_IMAGE.equals(officePreviewType) || OFFICE_PREVIEW_TYPE_ALL_IMAGES.equals(officePreviewType))) {
            return OfficeFilePreviewImpl.getPreviewType((Model)model, (FileAttribute)fileAttribute, (String)officePreviewType, (String)baseUrl, (String)pdfName, (String)outFilePath, (FileHandlerService)this.fileHandlerService, (String)OFFICE_PREVIEW_TYPE_IMAGE, (OtherFilePreviewImpl)this.otherFilePreview);
        }
        model.addAttribute("pdfUrl", (Object)pdfName);
        return "pdf";
    }
}

