/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.service.impl;

import cn.keking.config.ConfigConstants;
import cn.keking.model.FileAttribute;
import cn.keking.model.ReturnResponse;
import cn.keking.service.CompressFileReader;
import cn.keking.service.FileHandlerService;
import cn.keking.service.FilePreview;
import cn.keking.service.impl.OtherFilePreviewImpl;
import cn.keking.utils.DownloadUtils;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;

@Service
public class CompressFilePreviewImpl
implements FilePreview {
    private final FileHandlerService fileHandlerService;
    private final CompressFileReader compressFileReader;
    private final OtherFilePreviewImpl otherFilePreview;

    public CompressFilePreviewImpl(FileHandlerService fileHandlerService, CompressFileReader compressFileReader, OtherFilePreviewImpl otherFilePreview) {
        this.fileHandlerService = fileHandlerService;
        this.compressFileReader = compressFileReader;
        this.otherFilePreview = otherFilePreview;
    }

    public String filePreviewHandle(String url, Model model, FileAttribute fileAttribute) {
        String fileName = fileAttribute.getName();
        String suffix = fileAttribute.getSuffix();
        String fileTree = null;
        if (!StringUtils.hasText((String)this.fileHandlerService.getConvertedFile(fileName)) || !ConfigConstants.isCacheEnabled().booleanValue()) {
            ReturnResponse response = DownloadUtils.downLoad((FileAttribute)fileAttribute, (String)fileName);
            if (response.isFailure()) {
                return this.otherFilePreview.notSupportedFile(model, fileAttribute, response.getMsg());
            }
            String filePath = (String)response.getContent();
            if ("zip".equalsIgnoreCase(suffix) || "jar".equalsIgnoreCase(suffix) || "gzip".equalsIgnoreCase(suffix)) {
                fileTree = this.compressFileReader.readZipFile(filePath, fileName);
            } else if ("rar".equalsIgnoreCase(suffix)) {
                fileTree = this.compressFileReader.unRar(filePath, fileName);
            } else if ("7z".equalsIgnoreCase(suffix)) {
                fileTree = this.compressFileReader.read7zFile(filePath, fileName);
            }
            if (fileTree != null && !"null".equals(fileTree) && ConfigConstants.isCacheEnabled().booleanValue()) {
                this.fileHandlerService.addConvertedFile(fileName, fileTree);
            }
        } else {
            fileTree = this.fileHandlerService.getConvertedFile(fileName);
        }
        if (fileTree != null && !"null".equals(fileTree)) {
            model.addAttribute("fileTree", (Object)fileTree);
            return "compress";
        }
        return this.otherFilePreview.notSupportedFile(model, fileAttribute, "\u538b\u7f29\u6587\u4ef6\u7c7b\u578b\u4e0d\u53d7\u652f\u6301\uff0c\u5c1d\u8bd5\u5728\u538b\u7f29\u7684\u65f6\u5019\u9009\u62e9RAR4\u683c\u5f0f");
    }
}

