/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.service.impl;

import cn.keking.config.ConfigConstants;
import cn.keking.model.FileAttribute;
import cn.keking.model.FileType;
import cn.keking.model.ReturnResponse;
import cn.keking.service.FileHandlerService;
import cn.keking.service.FilePreview;
import cn.keking.service.impl.OtherFilePreviewImpl;
import cn.keking.utils.DownloadUtils;
import cn.keking.web.filter.BaseUrlFilter;
import java.io.File;
import org.artofsolving.jodconverter.util.ConfigUtils;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.FFmpegFrameRecorder;
import org.bytedeco.javacv.Frame;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MediaFilePreviewImpl
implements FilePreview {
    private final FileHandlerService fileHandlerService;
    private final OtherFilePreviewImpl otherFilePreview;
    private static Object LOCK = new Object();

    public MediaFilePreviewImpl(FileHandlerService fileHandlerService, OtherFilePreviewImpl otherFilePreview) {
        this.fileHandlerService = fileHandlerService;
        this.otherFilePreview = otherFilePreview;
    }

    public String filePreviewHandle(String url, Model model, FileAttribute fileAttribute) {
        if (url != null && !url.toLowerCase().startsWith("http")) {
            ReturnResponse response = DownloadUtils.downLoad((FileAttribute)fileAttribute, (String)fileAttribute.getName());
            if (response.isFailure()) {
                return this.otherFilePreview.notSupportedFile(model, fileAttribute, response.getMsg());
            }
            url = BaseUrlFilter.getBaseUrl() + this.fileHandlerService.getRelativePath((String)response.getContent());
            fileAttribute.setUrl(url);
        }
        if (!this.checkNeedConvert(fileAttribute.getSuffix())) {
            String[] medias;
            for (String media : medias = ConfigConstants.getMedia()) {
                if (!media.equals(fileAttribute.getSuffix())) continue;
                model.addAttribute("mediaUrl", (Object)url);
                return "media";
            }
            return this.otherFilePreview.notSupportedFile(model, fileAttribute, "\u6682\u4e0d\u652f\u6301");
        }
        url = this.convertUrl(fileAttribute);
        model.addAttribute("mediaUrl", (Object)url);
        return "media";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertUrl(FileAttribute fileAttribute) {
        String url = fileAttribute.getUrl();
        if (this.fileHandlerService.listConvertedMedias().containsKey(url)) {
            url = this.fileHandlerService.getConvertedMedias(url);
        } else if (!this.fileHandlerService.listConvertedMedias().containsKey(url)) {
            Object object = LOCK;
            synchronized (object) {
                if (!this.fileHandlerService.listConvertedMedias().containsKey(url)) {
                    String convertedUrl = MediaFilePreviewImpl.convertToMp4((FileAttribute)fileAttribute);
                    this.fileHandlerService.addConvertedMedias(url, convertedUrl);
                    url = convertedUrl;
                }
            }
        }
        return url;
    }

    private boolean checkNeedConvert(String suffix) {
        if ("false".equals(ConfigConstants.getMediaConvertDisable())) {
            return false;
        }
        String[] mediaTypesConvert = FileType.MEDIA_TYPES_CONVERT;
        String type = suffix;
        for (String temp : mediaTypesConvert) {
            if (!type.equals(temp)) continue;
            return true;
        }
        return false;
    }

    private static String convertToMp4(FileAttribute fileAttribute) {
        String homePath = ConfigUtils.getHomePath();
        String filePath = homePath + File.separator + "file" + File.separator + "demo" + File.separator + fileAttribute.getName();
        String convertFileName = fileAttribute.getUrl().replace(fileAttribute.getSuffix(), "mp4");
        File file = new File(filePath);
        FFmpegFrameGrabber frameGrabber = new FFmpegFrameGrabber(file);
        String fileName = null;
        Frame captured_frame = null;
        FFmpegFrameRecorder recorder = null;
        try {
            fileName = file.getAbsolutePath().replace(fileAttribute.getSuffix(), "mp4");
            File desFile = new File(fileName);
            if (desFile.exists()) {
                return fileName;
            }
            frameGrabber.start();
            recorder = new FFmpegFrameRecorder(fileName, frameGrabber.getImageWidth(), frameGrabber.getImageHeight(), frameGrabber.getAudioChannels());
            recorder.setVideoCodec(27);
            recorder.setFormat("mp4");
            recorder.setFrameRate(frameGrabber.getFrameRate());
            recorder.setSampleRate(frameGrabber.getSampleRate());
            recorder.setAudioChannels(frameGrabber.getAudioChannels());
            recorder.setFrameRate(frameGrabber.getFrameRate());
            recorder.start();
            while ((captured_frame = frameGrabber.grabFrame()) != null) {
                try {
                    recorder.setTimestamp(frameGrabber.getTimestamp());
                    recorder.record(captured_frame);
                }
                catch (Exception exception) {}
            }
            recorder.stop();
            recorder.release();
            frameGrabber.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return convertFileName;
    }
}

