/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.service.impl;

import cn.keking.config.ConfigConstants;
import cn.keking.model.FileAttribute;
import cn.keking.model.ReturnResponse;
import cn.keking.service.FileHandlerService;
import cn.keking.service.FilePreview;
import cn.keking.service.OfficeToPdfService;
import cn.keking.service.impl.OtherFilePreviewImpl;
import cn.keking.utils.DownloadUtils;
import cn.keking.web.filter.BaseUrlFilter;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OfficeFilePreviewImpl
implements FilePreview {
    public static final String OFFICE_PREVIEW_TYPE_IMAGE = "image";
    public static final String OFFICE_PREVIEW_TYPE_ALL_IMAGES = "allImages";
    private static final String FILE_DIR = ConfigConstants.getFileDir();
    private final FileHandlerService fileHandlerService;
    private final OfficeToPdfService officeToPdfService;
    private final OtherFilePreviewImpl otherFilePreview;

    public OfficeFilePreviewImpl(FileHandlerService fileHandlerService, OfficeToPdfService officeToPdfService, OtherFilePreviewImpl otherFilePreview) {
        this.fileHandlerService = fileHandlerService;
        this.officeToPdfService = officeToPdfService;
        this.otherFilePreview = otherFilePreview;
    }

    public String filePreviewHandle(String url, Model model, FileAttribute fileAttribute) {
        String officePreviewType = fileAttribute.getOfficePreviewType();
        String baseUrl = BaseUrlFilter.getBaseUrl();
        String suffix = fileAttribute.getSuffix();
        String fileName = fileAttribute.getName();
        boolean isHtml = suffix.equalsIgnoreCase("xls") || suffix.equalsIgnoreCase("xlsx");
        String pdfName = fileName.substring(0, fileName.lastIndexOf(".") + 1) + (isHtml ? "html" : "pdf");
        String outFilePath = FILE_DIR + pdfName;
        if (!this.fileHandlerService.listConvertedFiles().containsKey(pdfName) || !ConfigConstants.isCacheEnabled().booleanValue()) {
            ReturnResponse response = DownloadUtils.downLoad((FileAttribute)fileAttribute, null);
            if (response.isFailure()) {
                return this.otherFilePreview.notSupportedFile(model, fileAttribute, response.getMsg());
            }
            String filePath = (String)response.getContent();
            if (StringUtils.hasText((String)outFilePath)) {
                this.officeToPdfService.openOfficeToPDF(filePath, outFilePath);
                if (isHtml) {
                    this.fileHandlerService.doActionConvertedFile(outFilePath);
                }
                if (ConfigConstants.isCacheEnabled().booleanValue()) {
                    this.fileHandlerService.addConvertedFile(pdfName, this.fileHandlerService.getRelativePath(outFilePath));
                }
            }
        }
        if (!isHtml && baseUrl != null && ("image".equals(officePreviewType) || "allImages".equals(officePreviewType))) {
            return OfficeFilePreviewImpl.getPreviewType((Model)model, (FileAttribute)fileAttribute, (String)officePreviewType, (String)baseUrl, (String)pdfName, (String)outFilePath, (FileHandlerService)this.fileHandlerService, (String)"image", (OtherFilePreviewImpl)this.otherFilePreview);
        }
        model.addAttribute("pdfUrl", (Object)pdfName);
        return isHtml ? "html" : "pdf";
    }

    static String getPreviewType(Model model, FileAttribute fileAttribute, String officePreviewType, String baseUrl, String pdfName, String outFilePath, FileHandlerService fileHandlerService, String officePreviewTypeImage, OtherFilePreviewImpl otherFilePreview) {
        String suffix = fileAttribute.getSuffix();
        boolean isPPT = suffix.equalsIgnoreCase("ppt") || suffix.equalsIgnoreCase("pptx");
        List imageUrls = fileHandlerService.pdf2jpg(outFilePath, pdfName, baseUrl);
        if (imageUrls == null || imageUrls.size() < 1) {
            return otherFilePreview.notSupportedFile(model, fileAttribute, "office\u8f6c\u56fe\u7247\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        model.addAttribute("imgurls", (Object)imageUrls);
        model.addAttribute("currentUrl", imageUrls.get(0));
        if (officePreviewTypeImage.equals(officePreviewType)) {
            return isPPT ? "ppt" : "officePicture";
        }
        return "picture";
    }
}

