/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.service.impl;

import cn.keking.config.ConfigConstants;
import cn.keking.model.FileAttribute;
import cn.keking.model.ReturnResponse;
import cn.keking.service.FileHandlerService;
import cn.keking.service.FilePreview;
import cn.keking.service.impl.OtherFilePreviewImpl;
import cn.keking.utils.DownloadUtils;
import cn.keking.web.filter.BaseUrlFilter;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;

@Service
public class PdfFilePreviewImpl
implements FilePreview {
    private final FileHandlerService fileHandlerService;
    private final OtherFilePreviewImpl otherFilePreview;
    private static final String FILE_DIR = ConfigConstants.getFileDir();

    public PdfFilePreviewImpl(FileHandlerService fileHandlerService, OtherFilePreviewImpl otherFilePreview) {
        this.fileHandlerService = fileHandlerService;
        this.otherFilePreview = otherFilePreview;
    }

    public String filePreviewHandle(String url, Model model, FileAttribute fileAttribute) {
        String fileName = fileAttribute.getName();
        String officePreviewType = fileAttribute.getOfficePreviewType();
        String baseUrl = BaseUrlFilter.getBaseUrl();
        String pdfName = fileName.substring(0, fileName.lastIndexOf(".") + 1) + "pdf";
        String outFilePath = FILE_DIR + pdfName;
        if ("image".equals(officePreviewType) || "allImages".equals(officePreviewType)) {
            List imageUrls;
            if (!this.fileHandlerService.listConvertedFiles().containsKey(pdfName) || !ConfigConstants.isCacheEnabled().booleanValue()) {
                ReturnResponse response = DownloadUtils.downLoad((FileAttribute)fileAttribute, (String)fileName);
                if (response.isFailure()) {
                    return this.otherFilePreview.notSupportedFile(model, fileAttribute, response.getMsg());
                }
                outFilePath = (String)response.getContent();
                if (ConfigConstants.isCacheEnabled().booleanValue()) {
                    this.fileHandlerService.addConvertedFile(pdfName, this.fileHandlerService.getRelativePath(outFilePath));
                }
            }
            if ((imageUrls = this.fileHandlerService.pdf2jpg(outFilePath, pdfName, baseUrl)) == null || imageUrls.size() < 1) {
                return this.otherFilePreview.notSupportedFile(model, fileAttribute, "pdf\u8f6c\u56fe\u7247\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            }
            model.addAttribute("imgurls", (Object)imageUrls);
            model.addAttribute("currentUrl", imageUrls.get(0));
            if ("image".equals(officePreviewType)) {
                return "officePicture";
            }
            return "picture";
        }
        if (url != null && !url.toLowerCase().startsWith("http")) {
            if (!this.fileHandlerService.listConvertedFiles().containsKey(pdfName) || !ConfigConstants.isCacheEnabled().booleanValue()) {
                ReturnResponse response = DownloadUtils.downLoad((FileAttribute)fileAttribute, (String)pdfName);
                if (response.isFailure()) {
                    return this.otherFilePreview.notSupportedFile(model, fileAttribute, response.getMsg());
                }
                model.addAttribute("pdfUrl", (Object)this.fileHandlerService.getRelativePath((String)response.getContent()));
                if (ConfigConstants.isCacheEnabled().booleanValue()) {
                    this.fileHandlerService.addConvertedFile(pdfName, this.fileHandlerService.getRelativePath(outFilePath));
                }
            } else {
                model.addAttribute("pdfUrl", (Object)pdfName);
            }
        } else {
            model.addAttribute("pdfUrl", (Object)url);
        }
        return "pdf";
    }
}

