/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.service.impl;

import cn.keking.model.FileAttribute;
import cn.keking.model.ReturnResponse;
import cn.keking.service.FileHandlerService;
import cn.keking.service.FilePreview;
import cn.keking.service.impl.OtherFilePreviewImpl;
import cn.keking.utils.DownloadUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;

@Service
public class PictureFilePreviewImpl
implements FilePreview {
    private final FileHandlerService fileHandlerService;
    private final OtherFilePreviewImpl otherFilePreview;

    public PictureFilePreviewImpl(FileHandlerService fileHandlerService, OtherFilePreviewImpl otherFilePreview) {
        this.fileHandlerService = fileHandlerService;
        this.otherFilePreview = otherFilePreview;
    }

    public String filePreviewHandle(String url, Model model, FileAttribute fileAttribute) {
        ArrayList<String> imgUrls = new ArrayList<String>();
        imgUrls.add(url);
        String fileKey = fileAttribute.getFileKey();
        List zipImgUrls = this.fileHandlerService.getImgCache(fileKey);
        if (!CollectionUtils.isEmpty((Collection)zipImgUrls)) {
            imgUrls.addAll(zipImgUrls);
        }
        if (url != null && !url.toLowerCase().startsWith("http")) {
            ReturnResponse response = DownloadUtils.downLoad((FileAttribute)fileAttribute, null);
            if (response.isFailure()) {
                return this.otherFilePreview.notSupportedFile(model, fileAttribute, response.getMsg());
            }
            String file = this.fileHandlerService.getRelativePath((String)response.getContent());
            imgUrls.clear();
            imgUrls.add(file);
            model.addAttribute("imgUrls", imgUrls);
            model.addAttribute("currentUrl", (Object)file);
        } else {
            model.addAttribute("imgUrls", imgUrls);
            model.addAttribute("currentUrl", (Object)url);
        }
        return "picture";
    }
}

