/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.service.impl;

import cn.keking.config.ConfigConstants;
import cn.keking.model.FileAttribute;
import cn.keking.model.ReturnResponse;
import cn.keking.service.FilePreview;
import cn.keking.service.impl.OtherFilePreviewImpl;
import cn.keking.utils.DownloadUtils;
import cn.keking.utils.EncodingDetects;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.codec.binary.Base64;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.web.util.HtmlUtils;

@Service
public class SimTextFilePreviewImpl
implements FilePreview {
    private final OtherFilePreviewImpl otherFilePreview;
    private static final String FILE_DIR = ConfigConstants.getFileDir();

    public SimTextFilePreviewImpl(OtherFilePreviewImpl otherFilePreview) {
        this.otherFilePreview = otherFilePreview;
    }

    public String filePreviewHandle(String url, Model model, FileAttribute fileAttribute) {
        String fileName = fileAttribute.getName();
        String baseUrll = FILE_DIR + fileName;
        ReturnResponse response = DownloadUtils.downLoad((FileAttribute)fileAttribute, (String)fileName);
        if (response.isFailure()) {
            return this.otherFilePreview.notSupportedFile(model, fileAttribute, response.getMsg());
        }
        try {
            String fileData = HtmlUtils.htmlEscape((String)this.textData(baseUrll));
            model.addAttribute("textData", (Object)Base64.encodeBase64String((byte[])fileData.getBytes()));
        }
        catch (IOException e) {
            return this.otherFilePreview.notSupportedFile(model, fileAttribute, e.getLocalizedMessage());
        }
        return "txt";
    }

    private String textData(String baseUrll) throws IOException {
        String line;
        File file = new File(baseUrll);
        if (!file.exists() || file.length() == 0L) {
            String line2 = "";
            return line2;
        }
        String charset = EncodingDetects.getJavaEncode((String)baseUrll);
        System.out.println(charset);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(baseUrll), charset));
        StringBuilder result = new StringBuilder();
        while ((line = br.readLine()) != null) {
            result.append(line).append("\r\n");
        }
        return result.toString();
    }
}

